#version 120

uniform sampler2D sourcetexture;
uniform sampler2D destinationtexture;
uniform sampler2D feedtexture;
uniform sampler2D randomtexture;

uniform float effecttime;
uniform float effectspeed;
uniform float feedpower;
uniform float noisepower;
uniform float vorticity;

varying vec2 texturecoordinate;

void main(void)
{
	float xoff = sin(texturecoordinate.x*6.0+effecttime*25)*0.02 * sin(effecttime*7*effectspeed);
	float yoff = cos(texturecoordinate.y*9.0+effecttime*10)*0.01 * sin(effecttime*7*effectspeed);
	vec2 feedoffs = (texture2D(feedtexture, texturecoordinate).xy-vec2(0.5, 0.5)-texturecoordinate*0.5)*15*sin(effecttime*3*effectspeed);
	vec2 noiseoffs = texture2D(randomtexture, texturecoordinate).xy - vec2(0.5,0.5);
	
	float a = feedoffs.r + effecttime*5;

	float circle = 3.141592*2;//(2+2*sin(effecttime*11));
	feedoffs.xy = vec2(sin(a)*circle, cos(a)*circle)*vorticity;
	vec2 offs = texturecoordinate + vec2(xoff, yoff) + feedoffs*feedpower  + noiseoffs*noisepower; 
	vec4 sourcetexel = texture2D(sourcetexture, offs);
	vec4 destinationtexel = texture2D(destinationtexture, texturecoordinate);
	
	vec4 noisetexel = texture2D(randomtexture, texturecoordinate);
	
	float f = 0.1;
	float dim = 0.01;
	
	vec4 finalcolor = mix(sourcetexel, destinationtexel, f) * (1.0 - dim);
	float lum = finalcolor.r * 0.3 + finalcolor.g * 0.59 + finalcolor.b * 0.11;
	
	float factor = pow(lum, 0.03);
	finalcolor.rgb *= factor;
	finalcolor.rgb *= (noisetexel.rgb*0.005+0.999);
	
	gl_FragColor = finalcolor;
}