#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <fcntl.h>
#include <io.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <conio.h>
#include "build.h"

#define maxscandist 32
#define numtimecounts 8
#define maxsprites 64
#define xtotaldim 320
#define ytotaldim 200

static char timenames[numtimecounts][20] =
{
	"Main loop          ",
	"Wall calculations  ",
	"Vline calculations ",
	"Hline calculations ",
	"Sprite calc.&draw. ",
	"Vline drawing      ",
	"Hline drawing      ",
	"Grou-drawing       ",
};

struct walldata
{
	short unsigned int xa1, ya1, xa2, ya2;
	short unsigned int picnum[3], heinum[2];
	char shade[3], z[2], cstat, zosc, repeat;
};
short numlines;
struct walldata lin[maxlines+2];

static char got[maxlines+2];
static long px, py;
static short lintal[maxlines*4];     /*May need *5,*6... if dense board*/
static unsigned short lintaladdr[4097], lintalcnt;
static long xb1[65], yb1[65], xb2[65], yb2[65];
static short theline[64], uxsave[242], dxsave[242], ceilingstat;
static unsigned char swapped[64];
static long xs[maxsprites], ys[maxsprites], sizs[maxsprites];
static short sline[maxsprites], sord[maxsprites], snum;
static char sumost[maxsprites][xtotaldim], sdmost[maxsprites][xtotaldim];
static unsigned char uzmost[xtotaldim+1], dzmost[xtotaldim+1];
static long uplace[xtotaldim+1], dplace[xtotaldim+1], linum[xtotaldim+1];
static long udist[321], ddist[321], ndist[321];
static unsigned char tempbuf[maxlines*2];
static long tantable[1024], nowx, nowy;
static short radarang[320], board2d[4096];
static short capturecount, resolutionset = 0, detmode = 0;
static short halfwidth, eigthwidth, halfheight, tablesloaded = 0;
static short closestline, lintalplc, numhits, page, posfil;
static long poscapture = 0L;
static unsigned char clipbuf[128][128];
unsigned char picsiz[maxtiles], picanm[maxtiles], palette[768];
long waloff[maxtiles];

short searchit;         //these variables for EDITMAP use only
long searchx, searchy, searchreturn;

volatile long timetakercount[numtimecounts], takernum;
volatile unsigned char readch, oldreadch, extended;
static void (__interrupt __far *oldhand)();
static (__interrupt __far *oldkeyhandler)();
static void __interrupt __far ksmhandler(void);
static void __interrupt __far keyhandler(void);

static char *pic;
char *draw2buf, *grouwaloffs, *grouheioffs;
static short mousx, mousy, moustat;
unsigned long vplc1, vplc2, vinc1, vinc2, pplc;
long posze, horize, groudmost, grouumost, recip[2048];
long groudcnt, groudinc, groudend;
long centeroffset, scrsize, boardoffs[4096];

extern void setvmode(long);
extern void clearvscreen();
extern void vlineasm1(long,long,long,long,long,long);
extern void vlineasm2l(long,long,long,long,long,long);
extern void vlineasm2r(long,long,long,long,long,long);
extern void vlineasm2b(long,long,long,long,long,long);
extern void hlineasm64(long,long,long,long,long,long);
extern void hlineasm128(long,long,long,long,long,long);
extern void svlineasm1(long,long,long,long,long,long);
extern void svlineasm2l(long,long,long,long,long,long);
extern void svlineasm2r(long,long,long,long,long,long);
extern void svlineasm2b(long,long,long,long,long,long);
extern void row2draw320200(long,long,long,long,long,long);
extern void row2draw642(long,long,long,long,long,long);
extern long grouddraw(long,long,long,long,long,long);

#pragma aux setvmode parm [eax];
#pragma aux vlineasm1 parm [eax][ebx][ecx][edx][esi][edi];
#pragma aux vlineasm2l parm [eax][ebx][ecx][edx][esi][edi];
#pragma aux vlineasm2r parm [eax][ebx][ecx][edx][esi][edi];
#pragma aux vlineasm2b parm [eax][ebx][ecx][edx][esi][edi];
#pragma aux hlineasm64 parm [eax][ebx][ecx][edx][esi][edi];
#pragma aux hlineasm128 parm [eax][ebx][ecx][edx][esi][edi];
#pragma aux svlineasm1 parm [eax][ebx][ecx][edx][esi][edi];
#pragma aux svlineasm2l parm [eax][ebx][ecx][edx][esi][edi];
#pragma aux svlineasm2r parm [eax][ebx][ecx][edx][esi][edi];
#pragma aux svlineasm2b parm [eax][ebx][ecx][edx][esi][edi];
#pragma aux row2draw320200 parm [eax][ebx][ecx][edx][esi][edi];
#pragma aux row2draw642 parm [eax][ebx][ecx][edx][esi][edi];
#pragma aux grouddraw parm [eax][ebx][ecx][edx][esi][edi];

#pragma aux setupmouse =\
	"mov ax, 0",\
	"int 33h",\
	"mov moustat,1",\
	modify [eax]\

#pragma aux clearscreen =\
	"mov edi, frameplace",\
	"mov ecx, 16000d",\
	"xor eax, eax",\
	"rep stosd",\
	parm [edi][ax]\
	modify [eax ecx edi]\

#pragma aux readmouse =\
	"mov ax, 11d",\
	"int 33h",\
	"sar cx, 1",\
	"sar dx, 1",\
	"mov mousx, cx",\
	"mov mousy, dx",\
	modify [eax ecx edx]\

#pragma aux clearvscreen =\
	"mov edi, frameplace",\
	"add edi, centeroffset",\
	"mov ecx, scrsize",\
	"shr ecx, 3",\
	"mov eax, 0e3e3e3e3h",\
	"rep stosd",\
	"mov ecx, scrsize",\
	"shr ecx, 3",\
	"mov eax, 84848484h",\
	"rep stosd",\
	modify [eax ecx edi]\

#pragma aux interruptend =\
	"mov al, 20h",\
	"out 20h, al",\
	modify [eax]\

#pragma aux readkey =\
	"in al, 0x60",\
	"mov readch, al",\
	"in al, 0x61",\
	"or al, 0x80",\
	"out 0x61, al",\
	"and al, 0x7f",\
	"out 0x61, al",\
	modify [eax]\

#pragma aux drawrow =\
	"cld",\
	"mov ecx, 80d",\
	"mov esi, offset tempbuf",\
	"mov edi, pplc",\
	"rep movsd",\
	modify [edi esi ecx]\

#pragma aux readrow =\
	"mov ecx, 80d",\
	"mov esi, pplc",\
	"add edi, offset tempbuf",\
	"rep movsd",\
	parm [edi]\
	modify [edi esi ecx]\

#pragma aux memcopybyte =\
	"mov al, byte ptr [ecx]",\
	"add al, dl",\
	"mov byte ptr [ebx], al",\
	parm [ebx][ecx][edx]\

#pragma aux clearbuf =\
	"rep stosd",\
	parm [edi][ecx][eax]\

void __interrupt __far ksmhandler()
{
	clockspeed++;
	timetakercount[takernum]++;
	interruptend();
}

void __interrupt __far keyhandler()
{
	oldreadch = readch;
	readkey();
	if ((readch|1) == 0xe1)
		extended = 128;
	else
	{
		if (oldreadch != readch)
			keystatus[(readch&127)+extended] = ((readch>>7)^1);
		extended = 0;
	}
	interruptend();
}

drawscreen(drawmode)
char drawmode;
{
	long tempx, tempy;
	short i;

	if ((ceilingstat != 1) || (keystatus[0x3a] > 0))
		clearvscreen();
	if ((drawmode&1) == 0)
	{
		clearbuf((long)(&umost[0]),(long)(xdim>>1),0L);
		clearbuf((long)(&dmost[0]),(long)(xdim>>1),(long)ydim+(((long)ydim)<<16));
	}
	searchit = (drawmode&2);
	searchreturn = -1L;
	clearbuf((long)(&udist[0]),(long)xdim,0x7fffffff);
	clearbuf((long)(&ddist[0]),(long)xdim,0x7fffffff);
	for(i=0;i<numlines;i++)
		got[i] = 0;
	numhits = xdim;
	snum = 0;
	closestline = 0;
	px = (posx>>10); py = (posy>>10);

	tempx = ((maxscandist * ((long)sintable[(ang+256)&2047]))>>4);
	tempy = ((maxscandist * ((long)sintable[(ang+1792)&2047]))>>4);
	xb1[64] = posx+tempx;
	yb1[64] = posy+tempy;
	xb2[64] = posx-tempy;
	yb2[64] = posy+tempx;

	scan(64);

	if (snum > 0)
	{
		drawsprites();
		takernum = 0;
	}
	return(searchreturn);
}

scan (short thelin)
{
	short incrx1, incry1, incrx2, incry2, xdir1, ydir1, xdir2, ydir2;
	short gridx1, gridy1, gridx2, gridy2, cnt1, cnt2, x, y, ox, oy;
	long snx, sny, scanstop1, scanstop2, scanstop, scandist, side3;

	incrx1 = (xb1[thelin]-posx); incry1 = (yb1[thelin]-posy);
	xdir1 = 1; if (incrx1 < 0) xdir1 = -1, incrx1 = -incrx1;
	ydir1 = 1; if (incry1 < 0) ydir1 = -1, incry1 = -incry1;
	gridx1 = px; gridy1 = py;
	snx = (posx&1023); if (xdir1 == 1) snx ^= 1023;
	sny = (posy&1023); if (ydir1 == 1) sny ^= 1023;
	cnt1 = ((snx*incry1 - sny*incrx1)>>10);

	incrx2 = (xb2[thelin]-posx); incry2 = (yb2[thelin]-posy);
	xdir2 = 1; if (incrx2 < 0) xdir2 = -1, incrx2 = -incrx2;
	ydir2 = 1; if (incry2 < 0) ydir2 = -1, incry2 = -incry2;
	gridx2 = px; gridy2 = py;
	snx = (posx&1023); if (xdir2 == 1) snx ^= 1023;
	sny = (posy&1023); if (ydir2 == 1) sny ^= 1023;
	cnt2 = ((snx*incry2 - sny*incrx2)>>10);

	scanstop1 = labs((posx>>10)-(xb1[thelin]>>10)) + labs((posy>>10)-(yb1[thelin]>>10));
	scanstop2 = labs((posx>>10)-(xb2[thelin]>>10)) + labs((posy>>10)-(yb2[thelin]>>10));
	if (scanstop1 > scanstop2)
		scanstop = scanstop1;
	else
		scanstop = scanstop2;

	snx = 0; if (yb2[thelin] < yb1[thelin]) snx = 1023;
	sny = 0; if (xb2[thelin] > xb1[thelin]) sny = 1023;

	for (scandist=0;scandist<scanstop;scandist++)
	{
		x = gridx1; y = gridy1;
		side3 = ((x<<10)+snx-xb1[thelin])*(yb2[thelin]-yb1[thelin]) - (xb2[thelin]-xb1[thelin])*((y<<10)+sny-yb1[thelin]);
		ox = -1;
		while ((ox != gridx2) || (oy != gridy2))
		{
			if (side3 < 0)
			{
				addbox(x,y);      // ***********************
				drawlines();
				if (numhits <= 0)
					return(0);
			}
			ox = x; oy = y;
			if ((ox >= px) && (oy < py+scandist)) y++, side3 -= ((xb2[thelin]-xb1[thelin])<<10);
			if ((ox <= px) && (oy > py-scandist)) y--, side3 += ((xb2[thelin]-xb1[thelin])<<10);
			if ((oy >= py) && (ox > px-scandist)) x--, side3 -= ((yb2[thelin]-yb1[thelin])<<10);
			if ((oy <= py) && (ox < px+scandist)) x++, side3 += ((yb2[thelin]-yb1[thelin])<<10);
		}

		if (cnt1 < 0)
			cnt1 += incry1, gridx1 += xdir1;
		else
			cnt1 -= incrx1, gridy1 += ydir1;

		if (cnt2 < 0)
			cnt2 += incry2, gridx2 += xdir2;
		else
			cnt2 -= incrx2, gridy2 += ydir2;
	}
	return(0);
}

nextpage()
{
	if (detmode == 0)
	{
		outp(0x3d4,0xc); outp(0x3d5,page<<6);
		if (keystatus[0x3a] == 0)
		{
			page++;
			if (page >= 3)
				page = 0;
		}
		outp(0x3cd,page);
	}
	else
	{
		outp(0x3d4,0xd); outp(0x3d5,((page&1)^((page&2)>>1))*160);
		outp(0x3d4,0x33); outp(0x3d5,(page&2)>>1);
		if (keystatus[0x3a] == 0)
		{
			page++;
			if (page >= 4)
				page = 0;
		}
		frameplace = 0x00a0000+(((page&1)^((page&2)>>1))*160);
		outp(0x3cd,(page&2)>>1);
	}
	numframes++;
	totalclock += ((long)clockspeed), clockspeed = 0;
}

engineinput()
{
	int i, doubvel;

	if (vel < 0)
	{
		vel+=((clockspeed>>3)+1);
		if (vel > 0) vel = 0;
	}
	if (vel > 0)
	{
		vel-=((clockspeed>>3)+1);
		if (vel < 0) vel = 0;
	}
	if (svel < 0)
	{
		svel+=((clockspeed>>2)+1);
		if (svel > 0) svel = 0;
	}
	if (svel > 0)
	{
		svel-=((clockspeed>>2)+1);
		if (svel < 0) svel = 0;
	}
	if (hvel < 0)
	{
		hvel += 4;
		if (hvel > 0) hvel = 0;
	}
	if (hvel > 0)
	{
		hvel -= 4;
		if (hvel < 0) hvel = 0;
	}
	if (angvel < 0)
	{
		angvel+=((clockspeed>>1)+1);
		if (angvel > 0) angvel = 0;
	}
	if (angvel > 0)
	{
		angvel-=((clockspeed>>1)+1);
		if (angvel < 0) angvel = 0;
	}
	if (moustat == 1)
		readmouse();
	angvel += mousx;
	vel -= mousy;
	if (detmode == 0)
	{
		if (keystatus[0x4e] > 0) ceilingstat = 1;
		if (keystatus[0x4a] > 0) ceilingstat = 0;
		if (keystatus[0x9c] > 0) ceilingstat = 2;
	}
	if (keystatus[0x10] > 0)
	{
		outp(0x3d4,0x13); outp(0x3d5,40);               //unset 640*200 mode
		outp(0x3d4,0x14); outp(0x3d5,inp(0x3d5)&223);
		outp(0x3d4,0x17); outp(0x3d5,inp(0x3d5)&247);
		inp(0x3da); outp(0x3c0,0x30); outp(0x3c0,inp(0x3c1)|64);
		outp(0x3c4,1); outp(0x3c5,inp(0x3c5)&251);
		outp(0x3c4,0x4); outp(0x3c5,inp(0x3c5)|8);      //unset 4pixbytemode
		outp(0x3d4,0x14); outp(0x3d5,inp(0x3d5)|64);
		outp(0x3d4,0x17); outp(0x3d5,inp(0x3d5)&191);
		if (detmode == 1)
		{
			frameplace = 0x000a0000;
			outp(0x3d4,0xc), outp(0x3d5,0);
			outp(0x3d4,0xd), outp(0x3d5,0);
			outp(0x3d4,0x33), outp(0x3d5,0);
			xdim <<= 1;
			outp(0x3cd,0), clearscreen();
			outp(0x3cd,1), clearscreen();
			outp(0x3cd,2), clearscreen();
			halfwidth = (xdim>>1);
			eigthwidth = (xdim>>3);
			centeroffset = (long)(((200-ydim)>>1)*320) + ((320-xdim)>>1);
			scrsize = ((long)ydim)*320L;
		}
		detmode = 0;
	}
	if (keystatus[0x11] > 0)
	{
		outp(0x3d4,0x13); outp(0x3d5,160);              //set 640*200 mode
		outp(0x3d4,0x14); outp(0x3d5,inp(0x3d5)|32);
		outp(0x3d4,0x17); outp(0x3d5,inp(0x3d5)|8);
		inp(0x3da); outp(0x3c0,0x30); outp(0x3c0,inp(0x3c1)&191);
		outp(0x3c4,1); outp(0x3c5,inp(0x3c5)&251);
		outp(0x3c4,0x4); outp(0x3c5,inp(0x3c5)&247);    //set 4pixbytemode
		outp(0x3d4,0x14); outp(0x3d5,inp(0x3d5)&191);
		outp(0x3d4,0x17); outp(0x3d5,inp(0x3d5)|64);
		outp(0x3ce,0x5); outp(0x3cf,64);
		outp(0x3c4,2); outp(0x3c5,15);
		if (detmode == 0)
		{
			outp(0x3d4,0xc), outp(0x3d5,0);
			outp(0x3d4,0xd), outp(0x3d5,0);
			outp(0x3d4,0x33), outp(0x3d5,0);
			xdim >>= 1;
			outp(0x3cd,0), clearscreen();
			outp(0x3cd,1), clearscreen();
			halfwidth = (xdim>>1);
			eigthwidth = (xdim>>3);
			centeroffset = (long)(((200-ydim)>>1)*320) + ((160-xdim)>>1);
			ceilingstat = 1;
		}
		detmode = 1;
	}
	if (keystatus[0x2a] > 0)
		doubvel = 2;
	else
		doubvel = 1;

	if (keystatus[0x9d] == 0)
	{
		if (keystatus[0xcb] > 0) angvel -= 10;
		if (keystatus[0xcd] > 0) angvel += 10;
	}
	else
	{
		if (keystatus[0xcb] > 0) svel += 6*doubvel;
		if (keystatus[0xcd] > 0) svel -= 6*doubvel;
	}
	if (keystatus[0x1e] > 0) hvel -= 6*doubvel;
	if (keystatus[0x2c] > 0) hvel += 6*doubvel;
	if (keystatus[0xc8] > 0) vel += 6*doubvel;
	if (keystatus[0xd0] > 0) vel -= 6*doubvel;

	if (vel < -16*doubvel) vel = -16*doubvel;
	if (vel > 16*doubvel) vel = 16*doubvel;
	if (svel < -16*doubvel) svel = -16*doubvel;
	if (svel > 16*doubvel) svel = 16*doubvel;
	if (hvel < -16*doubvel) hvel = -16*doubvel;
	if (hvel > 16*doubvel) hvel = 16*doubvel;
	if (angvel < -24) angvel = -24;
	if (angvel > 24) angvel = 24;

	if (((keystatus[0x4b]|keystatus[0x4d]|keystatus[0x48]|keystatus[0x50]) != 0) && (detmode == 0))
	{
		if (detmode == 0)
		{
			if ((keystatus[0x4b] > 0) && (xdim > 8)) xdim -= 8;
			if ((keystatus[0x4d] > 0) && (xdim < 320)) xdim += 8;
		}
		else
		{
			if ((keystatus[0x4b] > 0) && (xdim > 4)) xdim -= 4;
			if ((keystatus[0x4d] > 0) && (xdim < 160)) xdim += 4;
		}
		if ((keystatus[0x48] > 0) && (ydim > 8)) ydim -= 8;
		if ((keystatus[0x50] > 0) && (ydim < 200)) ydim += 8;
		for(i=0;i<3;i++)
		{
			outp(0x3cd,i);
			clearscreen();
		}
		setscreensize(xdim,ydim);
	}
	if (keystatus[0x13] > 0)
		resettiming();
	if (keystatus[0x19] > 0)
	{
		keystatus[0x19] = 0;
		while ((keystatus[0x19] == 0) && (keystatus[1] == 0));
		keystatus[0x19] = 0;
	}
	if (keystatus[88] > 0)
	{
		screencapture();
		keystatus[88] = 0;
	}
	if ((keystatus[0x2e] > 0) && (poscapture == 0))
	{
		poscapture = 1L;
		posfil = open("poscapt.dat",O_BINARY|O_TRUNC|O_CREAT|O_WRONLY,S_IWRITE);
		write(posfil,&poscapture,4);
	}
	if (angvel != 0)
	{
		ang += ((angvel*clockspeed)>>3);
		ang = (ang+2048)&2047;
	}
	if (vel != 0)
		clipmove(vel*clockspeed);
	if (svel != 0)
	{
		ang = ((ang+1536)&2047);
		clipmove(svel*clockspeed);
		ang = ((ang+512)&2047);
	}
	if (hvel != 0)
	{
		newposz += (hvel<<7)+(hvel<<6);
		if (posz < 0) posz = 0;
		if (posz > 65535) posz = 65535;
	}
	posz = (posz+posz+posz+newposz)>>2;
	if (poscapture > 0)
	{
		write(posfil,&posx,4);
		write(posfil,&posy,4);
		write(posfil,&posz,4);
		write(posfil,&ang,2);
		poscapture++;
	}
}

loadtables()
{
	short fil;

	if (tablesloaded == 0)
	{
		if ((fil = open("tables.dat",O_BINARY|O_RDWR,S_IREAD)) != -1)
		{
			read(fil,&sintable[0],4096);
			read(fil,&tantable[0],4096);
			read(fil,&radarang[0],640);
			close(fil);
			tablesloaded = 1;
		}
	}
	return(0);
}

loadpics(filename)
char filename[20];
{
	long totpicsiz, offscount, siz;
	short fil, i;

	if ((fil = open(filename,O_BINARY|O_RDONLY,S_IREAD)) == -1)
		return(-1);
	read(fil,&picsiz[0],maxtiles);
	read(fil,&picanm[0],maxtiles);
	totpicsiz = 0L;
	for(i=0;i<maxtiles;i++)
		if (picsiz[i] > 0)
			totpicsiz += (1<<((long)((picsiz[i]&15)+(picsiz[i]>>4))));
	pic = (char *)malloc(totpicsiz);
	offscount = 0L;
	for(i=0;i<maxtiles;i++)
	{
		waloff[i] = offscount+FP_OFF(pic);
		if (picsiz[i] > 0)
		{
			siz = (1<<((long)((picsiz[i]&15)+(picsiz[i]>>4))));
			read(fil,&pic[offscount],siz);
			offscount += siz;
		}
	}
	close(fil);
	return(0);
}

vline(x, y1, y2, siz, walnume, picplc, shadeoffs)
short x, walnume, picplc;
long y1, y2, siz;
unsigned char shadeoffs;
{
	signed char tempchar;
	unsigned char shiftval;
	short thesiz, i, y1v, y2v, sizv;
	unsigned long vinc, vplc, p;

	y1v = ((short)(y1>>16));
	y2v = ((short)(y2>>16));
	sizv = ((short)(siz>>16));
	thesiz = y2v-y1v;
	if ((y1v > dmost[x]) || (y2v < umost[x]) || (thesiz <= 0) || (sizv <= 0) || (picsiz[walnume] == 0))
		return(0);

	picplc &= ((0xffff>>(16-(picsiz[walnume]&15)))<<(picsiz[walnume]>>4));
	vinc = ((33554432L*32L) / (siz>>11));
	vplc = (((long)picplc)<<16)+(((y1&65535^65535)*(vinc>>8))>>8);
	if (y1v < umost[x])
	{
		vplc += ((long)(umost[x]-y1v))*vinc;
		y1v = umost[x];
	}
	if (y2v > dmost[x]) y2v = dmost[x];
	thesiz = y2v-y1v;
	if ((thesiz < 1) || (thesiz > ydim))
		return(-1);

	tempchar = brightenarea-((char)(vinc>>(16+detmode)));
	if (tempchar < -8) tempchar = -8;
	if (tempchar > 1) tempchar = 1;
	shadeoffs += tempchar;

	shiftval = 32-(picsiz[walnume]>>4);
	vplc <<= (shiftval-16);
	vinc <<= (shiftval-16);
	p = ((long)(y1v*320+x))+frameplace+centeroffset;
	takernum = 5;
	vlineasm1(0L,vinc&0xffffff00,(vplc&0xffffff00)|shiftval,(long)((thesiz<<8)+shadeoffs),picplc+waloff[walnume],p);
	takernum = 2;
	return(0);
}

vline2(x, y1, y2, y3, y4, siz1, siz2, walnume, picplc1, picplc2, shadeoffs)
short x, walnume, picplc1, picplc2;
long y1, y2, y3, y4, siz1, siz2;
unsigned char shadeoffs;
{
	signed char tempchar;
	unsigned char shiftval;
	short thesiz1, thesiz2, doubsiz, y1v, y2v, y3v, y4v, siz1v, siz2v;
	unsigned long picoffs1, picoffs2;

	y1v = ((short)(y1>>16));
	y2v = ((short)(y2>>16));
	y3v = ((short)(y3>>16));
	y4v = ((short)(y4>>16));
	siz1v = ((short)(siz1>>16));
	siz2v = ((short)(siz2>>16));
	thesiz1 = y2v-y1v;
	thesiz2 = y4v-y3v;
	if ((y1v > dmost[x]) || (y2v < umost[x]) || (thesiz1 <= 0) || (siz1v <= 0) || (picsiz[walnume] == 0))
	{
		vline(x+1,y3,y4,siz2,walnume,picplc2,shadeoffs);
		return(0);
	}
	if ((y3v > dmost[x+1]) || (y4v < umost[x+1]) || (thesiz2 <= 0) || (siz2v <= 0))
	{
		vline(x,y1,y2,siz1,walnume,picplc1,shadeoffs);
		return(0);
	}

	picplc1 &= ((0xffff>>(16-(picsiz[walnume]&15)))<<(picsiz[walnume]>>4));
	vinc1 = ((33554432L*32L) / (siz1>>11));
	vplc1 = (((long)picplc1)<<16)+(((y1&65535^65535)*(vinc1>>8))>>8);
	if (y1v < umost[x])
	{
		vplc1 += ((long)(umost[x]-y1v))*vinc1;
		y1v = umost[x];
	}
	if (y2v > dmost[x]) y2v = dmost[x];
	thesiz1 = y2v-y1v;
	if (thesiz1 < 1)
	{
		vline(x+1,y3,y4,siz2,walnume,picplc2,shadeoffs);
		return(0);
	}

	picplc2 &= ((0xffff>>(16-(picsiz[walnume]&15)))<<(picsiz[walnume]>>4));
	vinc2 = ((33554432L*32L) / (siz2>>11));
	vplc2 = (((long)picplc2)<<16)+(((y3&65535^65535)*(vinc2>>8))>>8);
	if (y3v < umost[x+1])
	{
		vplc2 += ((long)(umost[x+1]-y3v))*vinc2;
		y3v = umost[x+1];
	}
	if (y4v > dmost[x+1]) y4v = dmost[x+1];
	thesiz2 = y4v-y3v;
	if (thesiz2 < 1)
	{
		vline(x,y1,y2,siz1,walnume,picplc1,shadeoffs);
		return(0);
	}

	tempchar = brightenarea-((char)(vinc1>>(16+detmode)));
	if (tempchar < -8) tempchar = -8;
	if (tempchar > 1) tempchar = 1;
	shadeoffs += tempchar;

	shiftval = 32-(picsiz[walnume]>>4);
	vplc1 <<= (shiftval-16);
	vinc1 <<= (shiftval-16);
	vplc2 <<= (shiftval-16);
	vinc2 <<= (shiftval-16);
	vplc1 += shiftval;
	vplc2 += shadeoffs;
	picoffs1 = (long)picplc1+waloff[walnume];
	picoffs2 = (long)picplc2+waloff[walnume];

	if (y1v < y3v)
	{
		pplc = ((long)(y1v*320+x))+frameplace+centeroffset;
		if (y2v < y4v)
			doubsiz = y2v-y3v;
		else
			doubsiz = y4v-y3v;
	}
	else
	{
		pplc = ((long)(y3v*320+x))+frameplace+centeroffset;
		if (y2v < y4v)
			doubsiz = y2v-y1v;
		else
			doubsiz = y4v-y1v;
	}
	takernum = 5;

	if (y1v < y3v)
		vlineasm2l(((long)(y3v-y1v-1))<<16,picoffs1,vplc1,vplc2,picoffs2,pplc);
	else if (y1v > y3v)
		vlineasm2r(((long)(y1v-y3v-1))<<16,picoffs1,vplc1,vplc2,picoffs2,pplc);

	if (doubsiz > 1)
		vlineasm2b(((long)doubsiz-1)<<16,picoffs1,vplc1,vplc2,picoffs2,pplc);

	if (y2v < y4v)
		vlineasm2r(((long)(y4v-y2v-1))<<16,picoffs1,vplc1,vplc2,picoffs2,pplc);
	else if (y2v > y4v)
		vlineasm2l(((long)(y2v-y4v-1))<<16,picoffs1,vplc1,vplc2,picoffs2,pplc);

	takernum = 2;
	return(0);
}

hline (xl, xr, yp, zd, walnume, shadeoffs)
unsigned short xl, xr, yp, zd;
short walnume;
char shadeoffs;
{
	signed char tempchar;
	short i, siz;
	long hd, x, y, xc, yc;

	if ((yp == halfheight) || (picsiz[walnume] == 0))
		return(-1);
	if (xl > xr)
		i = xl, xl = xr, xr = i;
	siz = xr-xl+1;

	hd = (((long)zd)<<14)/((long)((320>>detmode)*abs(halfheight-yp)));
	xc = (hd*(long)sintable[(2048+ang)&2047])>>2;
	yc = (hd*(long)sintable[(2560+ang)&2047])>>2;
	x = xc*(long)xl - (xc+yc)*(long)halfwidth - (posx<<22);
	y = yc*(long)xl + (xc-yc)*(long)halfwidth + (posy<<22);
	if (yp > halfheight)
	{
		y ^= 0xffffffff;
		yc ^= 0xffffffff;
	}

	tempchar = brightenarea-((char)(hd>>(13+detmode)));
	if (tempchar < -8) tempchar = -8;
	if (tempchar > 1) tempchar = 1;
	shadeoffs += tempchar;

	vinc1 = (xc&0xffffff00);
	takernum = 6;
	if ((picsiz[walnume]&15) == 6)
		hlineasm64(0L,(x&0xffffff00)|shadeoffs,waloff[walnume],(y&0xfffffe00)|(siz>>1)+((siz&1)<<8),yc&0xfffffe00,((long)(yp*320+xl))+frameplace+centeroffset);
	else if ((picsiz[walnume]&15) == 7)
		hlineasm128(((long)(siz&1))<<16,(x&0xffffff00)|shadeoffs,waloff[walnume],(y&0xfffffe00)|(siz>>1),yc&0xffffff00,((long)(yp*320+xl))+frameplace+centeroffset);
	takernum = 3;
	return(0);
}

loadboard(filename)
char filename[20];
{
	short fil, i;

	if ((fil = open(filename,O_BINARY|O_RDWR,S_IREAD)) != -1)
	{
		posz = 20480L;
		ang = 0;
		read(fil,&i,2), posx = (((long)i)<<5);
		read(fil,&i,2), posy = (((long)i)<<5);
		read(fil,&ang,2);
		read(fil,&numlines,2);
		read(fil,&tempbuf[0],numlines<<1);
		for(i=0;i<numlines;i++)
			lin[i].xa1 = (((unsigned short)tempbuf[i+i]+(((unsigned short)tempbuf[i+i+1])<<8))<<5);
		read(fil,&tempbuf[0],numlines<<1);
		for(i=0;i<numlines;i++)
			lin[i].ya1 = (((unsigned short)tempbuf[i+i]+(((unsigned short)tempbuf[i+i+1])<<8))<<5);
		read(fil,&tempbuf[0],numlines<<1);
		for(i=0;i<numlines;i++)
			lin[i].xa2 = (((unsigned short)tempbuf[i+i]+(((unsigned short)tempbuf[i+i+1])<<8))<<5);
		read(fil,&tempbuf[0],numlines<<1);
		for(i=0;i<numlines;i++)
			lin[i].ya2 = (((unsigned short)tempbuf[i+i]+(((unsigned short)tempbuf[i+i+1])<<8))<<5);
		read(fil,&tempbuf[0],numlines<<1);
		for(i=0;i<numlines;i++)
			lin[i].picnum[0] = (unsigned short)tempbuf[i+i]+(((unsigned short)tempbuf[i+i+1])<<8);
		read(fil,&tempbuf[0],numlines<<1);
		for(i=0;i<numlines;i++)
			lin[i].picnum[1] = (unsigned short)tempbuf[i+i]+(((unsigned short)tempbuf[i+i+1])<<8);
		read(fil,&tempbuf[0],numlines<<1);
		for(i=0;i<numlines;i++)
			lin[i].picnum[2] = (unsigned short)tempbuf[i+i]+(((unsigned short)tempbuf[i+i+1])<<8);
		read(fil,&tempbuf[0],numlines<<1);
		for(i=0;i<numlines;i++)
			lin[i].heinum[0] = (unsigned short)tempbuf[i+i]+(((unsigned short)tempbuf[i+i+1])<<8);
		read(fil,&tempbuf[0],numlines<<1);
		for(i=0;i<numlines;i++)
			lin[i].heinum[1] = (unsigned short)tempbuf[i+i]+(((unsigned short)tempbuf[i+i+1])<<8);
		read(fil,&tempbuf[0],numlines);
		for(i=0;i<numlines;i++)
			lin[i].shade[0] = tempbuf[i];
		read(fil,&tempbuf[0],numlines);
		for(i=0;i<numlines;i++)
			lin[i].shade[1] = tempbuf[i];
		read(fil,&tempbuf[0],numlines);
		for(i=0;i<numlines;i++)
			lin[i].shade[2] = tempbuf[i];
		read(fil,&tempbuf[0],numlines);
		for(i=0;i<numlines;i++)
			lin[i].z[0] = tempbuf[i];
		read(fil,&tempbuf[0],numlines);
		for(i=0;i<numlines;i++)
			lin[i].z[1] = tempbuf[i];
		read(fil,&tempbuf[0],numlines);
		for(i=0;i<numlines;i++)
			lin[i].cstat = tempbuf[i];
		read(fil,&tempbuf[0],numlines);
		for(i=0;i<numlines;i++)
			lin[i].zosc = tempbuf[i];
		read(fil,&tempbuf[0],numlines);
		for(i=0;i<numlines;i++)
			lin[i].repeat = tempbuf[i];
		close(fil);
		prepareboard();
		nowx = 0x80000000;
		nowy = 0x80000000;
	}
	return(0);
}

prepareboard()
{
	long zx, templong, clipx, clipy, xz, yz, oldxz, oldyz;
	long xa1v, xa2v, ya1v, ya2v;
	short i, j, gap, temp, tempword;
	char tempchar;

	gap = (numlines>>1);
	do
	{
		for(i=0;i<numlines-gap;i++)
		{
			temp = i;
			while ((lin[temp].xa1 > lin[temp+gap].xa1) && (temp >= 0))
			{
				tempword = lin[temp].xa1; lin[temp].xa1 = lin[temp+gap].xa1; lin[temp+gap].xa1 = tempword;
				tempword = lin[temp].ya1; lin[temp].ya1 = lin[temp+gap].ya1; lin[temp+gap].ya1 = tempword;
				tempword = lin[temp].xa2; lin[temp].xa2 = lin[temp+gap].xa2; lin[temp+gap].xa2 = tempword;
				tempword = lin[temp].ya2; lin[temp].ya2 = lin[temp+gap].ya2; lin[temp+gap].ya2 = tempword;
				tempword = lin[temp].picnum[0]; lin[temp].picnum[0] = lin[temp+gap].picnum[0]; lin[temp+gap].picnum[0] = tempword;
				tempword = lin[temp].picnum[1]; lin[temp].picnum[1] = lin[temp+gap].picnum[1]; lin[temp+gap].picnum[1] = tempword;
				tempword = lin[temp].picnum[2]; lin[temp].picnum[2] = lin[temp+gap].picnum[2]; lin[temp+gap].picnum[2] = tempword;
				tempword = lin[temp].heinum[0]; lin[temp].heinum[0] = lin[temp+gap].heinum[0]; lin[temp+gap].heinum[0] = tempword;
				tempword = lin[temp].heinum[1]; lin[temp].heinum[1] = lin[temp+gap].heinum[1]; lin[temp+gap].heinum[1] = tempword;
				tempchar = lin[temp].shade[0]; lin[temp].shade[0] = lin[temp+gap].shade[0]; lin[temp+gap].shade[0] = tempchar;
				tempchar = lin[temp].shade[1]; lin[temp].shade[1] = lin[temp+gap].shade[1]; lin[temp+gap].shade[1] = tempchar;
				tempchar = lin[temp].shade[2]; lin[temp].shade[2] = lin[temp+gap].shade[2]; lin[temp+gap].shade[2] = tempchar;
				tempchar = lin[temp].z[0]; lin[temp].z[0] = lin[temp+gap].z[0]; lin[temp+gap].z[0] = tempchar;
				tempchar = lin[temp].z[1]; lin[temp].z[1] = lin[temp+gap].z[1]; lin[temp+gap].z[1] = tempchar;
				tempchar = lin[temp].cstat; lin[temp].cstat = lin[temp+gap].cstat; lin[temp+gap].cstat = tempchar;
				tempchar = lin[temp].zosc; lin[temp].zosc = lin[temp+gap].zosc; lin[temp+gap].zosc = tempchar;
				tempchar = lin[temp].repeat; lin[temp].repeat = lin[temp+gap].repeat; lin[temp+gap].repeat = tempchar;
				temp -= gap;
			}
		}
		gap >>= 1;
	}
	while (gap > 0);
	clearbuf((long)(&lintaladdr[0]),2048L,0L);
	clearbuf((long)(&tempbuf[0]),16L,0L);
	lintalcnt = 0;
	for(i=0;i<numlines;i++)
	{
		xa1v = (long)lin[i].xa1;
		ya1v = (long)lin[i].ya1;
		xa2v = (long)lin[i].xa2;
		ya2v = (long)lin[i].ya2;
		if (xa1v == xa2v)
		{
			if (ya1v > ya2v)
				templong = ya1v, ya1v = ya2v, ya2v = templong;
			for(templong=(ya1v&0xfffffc00);templong<=((ya2v-1)&0xfffffc00);templong+=1024)
				addit((short)(xa1v>>10),(short)(templong>>10),i);
			if ((ya1v == ya2v) && ((ya1v&1023) == 0))
				addit((short)(xa1v>>10),(short)(ya1v>>10),i);
		}
		else if (ya1v == ya2v)
		{
			if (xa1v > xa2v)
				templong = xa1v, xa1v = xa2v, xa2v = templong;
			for(templong=(xa1v&0xfffffc00);templong<=((xa2v-1)&0xfffffc00);templong+=1024)
				addit((short)(templong>>10),(short)(ya1v>>10),i);
			if ((xa1v == xa2v) && ((xa1v&1023) == 0))
				addit((short)(xa1v>>10),(short)(ya1v>>10),i);
		}
		else
		{
			clipx = -1L, clipy = -1L;
			if ((xa2v > xa1v) && ((xa2v&1023) == 0)) clipx = xa2v;
			if ((ya2v > ya1v) && ((ya2v&1023) == 0)) clipy = ya2v;
			if ((xa1v > xa2v) && ((xa1v&1023) == 0)) clipx = xa1v;
			if ((ya1v > ya2v) && ((ya1v&1023) == 0)) clipy = ya1v;
			xz = xa1v, yz = ya1v;
			if ((xz != clipx) && (yz != clipy))
				addit((short)(xz>>10),(short)(yz>>10),i);
			for(zx=1;zx<=8;zx++)
			{
				oldxz = xz, oldyz = yz;
				xz = (((xa2v*zx) + (xa1v*(8-zx)))>>3);
				yz = (((ya2v*zx) + (ya1v*(8-zx)))>>3);
				if (((xz|1023) != (oldxz|1023)) || ((yz|1023) != (oldyz|1023)))
					if ((xz != clipx) && (yz != clipy))
						addit((short)(xz>>10),(short)(yz>>10),i);
			}
		}
	}
	for(i=1;i<=4096;i++)
		lintaladdr[i] = lintaladdr[i-1] + lintaladdr[i];
	return(0);
}

addit(x,y,i)
short x, y, i;
{
	short p, hereplc, zz;

	p = (x<<6) + y + 1;
	hereplc = 0;
	for(zz=0;zz<x;zz++)
		hereplc += tempbuf[zz];
	for(zz=(x<<6)+1;zz<p;zz++)
		hereplc += lintaladdr[zz];
	for(zz=lintalcnt;zz>hereplc;zz--)
		lintal[zz] = lintal[zz-1];
	lintaladdr[p]++;
	tempbuf[x]++;
	lintal[hereplc] = i;
	lintalcnt++;
	return(0);
}

short infront(short l1, short l2)
{
	long x1l1, y1l1, x2l1, y2l1, x1l2, y1l2, x2l2, y2l2;
	long templong0, templong1, templong2, templong3, templong4;

	x1l1 = lin[theline[l1]].xa1;
	y1l1 = lin[theline[l1]].ya1;
	x2l1 = lin[theline[l1]].xa2;
	y2l1 = lin[theline[l1]].ya2;
	x1l2 = lin[theline[l2]].xa1;
	y1l2 = lin[theline[l2]].ya1;
	x2l2 = lin[theline[l2]].xa2;
	y2l2 = lin[theline[l2]].ya2;

	templong1 = (x1l1-posx)*(y1l2-posy)-(x1l2-posx)*(y1l1-posy);
	templong2 = (x1l1-posx)*(y2l2-posy)-(x2l2-posx)*(y1l1-posy);
	templong3 = (x2l1-posx)*(y1l2-posy)-(x1l2-posx)*(y2l1-posy);
	templong4 = (x2l1-posx)*(y2l2-posy)-(x2l2-posx)*(y2l1-posy);
	if (templong1 == 0)
	{
		if (((templong2 <= 0) == (templong3 <= 0)) && ((templong3 <= 0) == (templong4 <= 0))) return(-1);
	}
	else if (templong2 == 0)
	{
		if (((templong1 <= 0) == (templong3 <= 0)) && ((templong3 <= 0) == (templong4 <= 0))) return(-1);
	}
	else if (templong3 == 0)
	{
		if (((templong1 <= 0) == (templong2 <= 0)) && ((templong2 <= 0) == (templong4 <= 0))) return(-1);
	}
	else if (templong4 == 0)
	{
		if (((templong1 <= 0) == (templong2 <= 0)) && ((templong2 <= 0) == (templong3 <= 0))) return(-1);
	}
	else
	{
		if (((templong1 <= 0) == (templong2 <= 0)) && ((templong2 <= 0) == (templong3 <= 0)) && ((templong3 <= 0) == (templong4 <= 0))) return(-1);
	}

	templong1 = (x1l2-x1l1)*(y2l1-y1l1) - (x2l1-x1l1)*(y1l2-y1l1); //p1(l2) vs. l1
	templong2 = (x2l2-x1l1)*(y2l1-y1l1) - (x2l1-x1l1)*(y2l2-y1l1); //p2(l2) vs. l1
	if (templong1 == 0) templong1 = templong2;
	if (templong2 == 0) templong2 = templong1;
	if ((templong1 < 0) == (templong2 < 0))
	{
		templong0 = (posx-x1l1)*(y2l1-y1l1) - (x2l1-x1l1)*(posy-y1l1);  //pos vs. l1
		if ((templong1<0) == (templong0<0))
			return(l2);
		else
			return(l1);
	}

	templong1 = (x1l1-x1l2)*(y2l2-y1l2) - (x2l2-x1l2)*(y1l1-y1l2); //p1(l1) vs. l2
	templong2 = (x2l1-x1l2)*(y2l2-y1l2) - (x2l2-x1l2)*(y2l1-y1l2); //p2(l1) vs. l2
	if (templong1 == 0) templong1 = templong2;
	if (templong2 == 0) templong2 = templong1;
	if ((templong1 < 0) == (templong2 < 0))
	{
		templong0 = (posx-x1l2)*(y2l2-y1l2) - (x2l2-x1l2)*(posy-y1l2);  //pos vs. l2
		if ((templong1<0) == (templong0<0))
			return(l1);
		else
			return(l2);
	}
	return(-2);
}

loadbmp(char filename[20],char *ptr)
{
	short fil, i;

	if ((fil = open(filename,O_BINARY|O_RDWR,S_IREAD)) == -1)
		return(-1);
	read(fil,&tempbuf[0],54);
	read(fil,&tempbuf[0],1024);
	outp(0x3c8,0);
	for(i=0;i<1024;i++)
		if ((i&3) != 0)
			outp(0x3c9,tempbuf[i^3]>>2);
	pplc = ((long)ptr)+64000L-320L;
	for(i=0;i<200;i++)
	{
		read(fil,&tempbuf[0],320);
		drawrow();
		pplc -= 320L;
	}
	close(fil);
	return(0);
}

screencapture()
{
	char filename[15];
	short fil;
	long i, j, k, bufplc;

	strcpy(filename,"capturxx.bmp");
	filename[6] = (capturecount/10)+48;
	filename[7] = (capturecount%10)+48;
	capturecount++;
	if ((fil=open(filename,O_BINARY|O_CREAT|O_WRONLY,S_IWRITE))==-1)
	{
		capturecount--;
		return(-1);
	}
	tempbuf[0] = 66, tempbuf[1] = 77, tempbuf[2] = 90, tempbuf[3] = 34;
	tempbuf[4] = 0, tempbuf[5] = 0, tempbuf[6] = 0, tempbuf[7] = 0;
	tempbuf[8] = 0, tempbuf[9] = 0, tempbuf[10] = 26, tempbuf[11] = 3;
	tempbuf[12] = 0, tempbuf[13] = 0, tempbuf[14] = 12, tempbuf[15] = 0;
	tempbuf[16] = 0, tempbuf[17] = 0, tempbuf[18] = 64, tempbuf[19] = 1;
	tempbuf[20] = 200, tempbuf[21] = 0, tempbuf[22] = 1, tempbuf[23] = 0;
	tempbuf[24] = 8, tempbuf[25] = 0;
	write(fil,&tempbuf[0],26);
	outp(0x3c7,0);
	for(i=0;i<768;i++)
		tempbuf[i] = (inp(0x3c9)<<2);
	for(i=0;i<768;i+=3)
	{
		j = tempbuf[i];
		tempbuf[i] = tempbuf[i+2];
		tempbuf[i+2] = j;
	}
	if (write(fil,&tempbuf[0],768) < 768)
	{
		close(fil);
		capturecount--;
		return(-1);
	}

	bufplc = 0L;
	for(j=199;j>=0;j--)
	{
		outp(97,inp(97)|3);
		pplc = frameplace+j*320;
		readrow(bufplc);
		bufplc += 320L;
		if (bufplc >= 3200L)
		{
			if (write(fil,&tempbuf[0],3200) < 3200)
			{
				close(fil);
				capturecount--;
				return(-1);
			}
			bufplc = 0L;
		}
		outp(97,inp(97)&252);
	}
	close(fil);
	return(0);
}

addbox(x,y)
short x,y;
{
	short p;
	long templong, templong1, xp1, yp1, xp2, yp2;
	short i, j, k, good;

	p = ((x&63)<<6)+(y&63);
	if (lintaladdr[p] == lintaladdr[p+1])
		return(0);
	for(i=lintaladdr[p];i<lintaladdr[p+1];i++)
	{
		if (got[lintal[i]] == 0)
		{
			got[lintal[i]] = 1;
			xp1 = (((long)(lin[lintal[i]].xa1-posx)*(long)sintable[(2048+ang)&2047]-(long)(lin[lintal[i]].ya1-posy)*(long)sintable[(2560+ang)&2047])>>15);
			yp1 = (((long)(lin[lintal[i]].xa1-posx)*(long)sintable[(2560+ang)&2047]+(long)(lin[lintal[i]].ya1-posy)*(long)sintable[(2048+ang)&2047])>>15);
			xp2 = (((long)(lin[lintal[i]].xa2-posx)*(long)sintable[(2048+ang)&2047]-(long)(lin[lintal[i]].ya2-posy)*(long)sintable[(2560+ang)&2047])>>15);
			yp2 = (((long)(lin[lintal[i]].xa2-posx)*(long)sintable[(2560+ang)&2047]+(long)(lin[lintal[i]].ya2-posy)*(long)sintable[(2048+ang)&2047])>>15);
			good = 7;
			if ((labs(xp1) <= yp1) && (yp1 > 0)) good--;
			if ((labs(xp2) <= yp2) && (yp2 > 0)) good-=2;
			if ((good == 7) && ((yp1 > 0) || (yp2 > 0)) && ((xp1 < 0) == (0 < xp2)))
				good = 3;
			yb1[lintalplc] = -1;
			yb2[lintalplc] = -1;
			if (good < 7)
			{
				if ((good&3) > 0)
					templong = xp2*yp1-xp1*yp2;
				if ((good&1) == 0)
				{
					if (yp1 != 0)
						xb1[lintalplc] = ((long)halfwidth)-((xp1*((long)halfwidth))/yp1);
					yb1[lintalplc] = yp1;
				}
				else
				{
					j = 0;
					if (xp1 > 0) j = 1;
					if (((xp1 < 0) == (0 < xp2)) && ((yp1 < 0) == (0 < yp2)))
						if (labs(xp1*yp2) < labs(xp2*yp1)) j = 1;
					if (j == 0)
					{
						xb1[lintalplc] = (long)(xdim-1);
						templong1 = yp2-yp1+xp2-xp1;
						if (templong1 != 0)
							yb1[lintalplc] = templong/templong1;
					}
					else
					{
						xb1[lintalplc] = 0L;
						templong1 = yp1-yp2+xp2-xp1;
						if (templong1 != 0)
							yb1[lintalplc] = templong/templong1;
					}
				}
				if ((good&2) == 0)
				{
					if (yp2 != 0)
						xb2[lintalplc] = ((long)halfwidth)-((xp2*((long)halfwidth))/yp2);
					yb2[lintalplc] = yp2;
				}
				else
				{
					j = 0;
					if (xp2 > 0) j = 1;
					if (((xp1 < 0) == (0 < xp2)) && ((yp1 < 0) == (0 < yp2)))
						if (labs(xp2*yp1) < labs(xp1*yp2)) j = 0;
					if (j == 0)
					{
						xb2[lintalplc] = (long)(xdim-1);
						templong1 = yp2-yp1+xp2-xp1;
						if (templong1 != 0)
							yb2[lintalplc] = templong/templong1;
					}
					else
					{
						xb2[lintalplc] = 0L;
						templong1 = yp1-yp2+xp2-xp1;
						if (templong1 != 0)
							yb2[lintalplc] = templong/templong1;
					}
				}
			}
			theline[lintalplc] = lintal[i];
			swapped[lintalplc] = 0;
			if (xb1[lintalplc] > xb2[lintalplc])
			{
				templong = xb1[lintalplc]; xb1[lintalplc] = xb2[lintalplc]; xb2[lintalplc] = templong;
				templong = yb1[lintalplc]; yb1[lintalplc] = yb2[lintalplc]; yb2[lintalplc] = templong;
				swapped[lintalplc] = 1;
			}
			if ((yb1[lintalplc] > 0L) && (yb2[lintalplc] > 0L) && ((xb1[lintalplc] != xb2[lintalplc]) || ((lin[lintal[i]].cstat&15) == 0)))
				if (((lin[lintal[i]].cstat&15) != 3) || (swapped[lintalplc] == 0))
					lintalplc++;
		}
	}
	return(0);
}

drawlines()
{
	unsigned char tempchar;
	long templong0, templong1, templong2;
	short i, j, m, n, good, gap;
	short temp, closest;

	if (lintalplc == 0)
		return(0);
	gap = (lintalplc>>1);
	while (gap > 0)
	{
		for(i=0;i<lintalplc-gap;i++)
		{
			temp = i;
			if (yb1[temp] < yb2[temp]) templong1 = yb1[temp]; else templong1 = yb2[temp];
			if (yb1[temp+gap] < yb2[temp+gap]) templong2 = yb1[temp+gap]; else templong2 = yb2[temp+gap];
			while (templong1 > templong2)
			{
				templong0 = xb1[temp]; xb1[temp] = xb1[temp+gap]; xb1[temp+gap] = templong0;
				templong0 = yb1[temp]; yb1[temp] = yb1[temp+gap]; yb1[temp+gap] = templong0;
				templong0 = xb2[temp]; xb2[temp] = xb2[temp+gap]; xb2[temp+gap] = templong0;
				templong0 = yb2[temp]; yb2[temp] = yb2[temp+gap]; yb2[temp+gap] = templong0;
				j = theline[temp]; theline[temp] = theline[temp+gap]; theline[temp+gap] = j;
				tempchar = swapped[temp]; swapped[temp] = swapped[temp+gap]; swapped[temp+gap] = tempchar;
				temp -= gap;
				if (temp < 0)
					break;
				if (yb1[temp] < yb2[temp]) templong1 = yb1[temp]; else templong1 = yb2[temp];
				if (yb1[temp+gap] < yb2[temp+gap]) templong2 = yb1[temp+gap]; else templong2 = yb2[temp+gap];
			}
		}
		gap >>= 1;
	}
	for(i=0;i<lintalplc;i++)
	{
		takernum = 0;
		closest = i;
		do
		{
			good = 0;
			if (lin[theline[closest]].z[1] >= uzmost[xb1[closest]+1]) good = 1;
			if (lin[theline[closest]].z[0] <= dzmost[xb1[closest]+1]) good = 1;
			if (lin[theline[closest]].z[1] >= uzmost[xb2[closest]-1]) good = 1;
			if (lin[theline[closest]].z[0] <= dzmost[xb2[closest]-1]) good = 1;
			if (good == 0)
				closest++;
		}
		while ((good == 0) && (closest < lintalplc));
		if (closest >= lintalplc)
		{
			i = lintalplc;
			numhits = 0;
			break;
		}
		m = 1;
		n = 0;
		while ((m == 1) && (n < (lintalplc-i)))
		{
			takernum = 0;
			m = 0;
			n++;
			for(j=i+1;j<lintalplc;j++)
			{
				if ((lin[theline[j]].z[1] >= uzmost[xb1[j]+1]) || (lin[theline[j]].z[0] <= dzmost[xb1[j]+1]) || (lin[theline[j]].z[1] >= uzmost[xb2[j]-1]) || (lin[theline[j]].z[0] <= dzmost[xb2[j]-1]))
					if ((xb1[j] <= xb2[closest]) && (xb1[closest] <= xb2[j]))
					{
						m = infront(j,closest);
						if (m == j)
						{
							closest = j;
							break;
						}
						else if (m == closest)
						{
							if ((lin[theline[closest]].cstat&15) == 3)
								if ((xb1[j] >= xb1[closest]) && (xb2[j] <= xb2[closest]))
								{
									lintalplc--;
									xb1[j] = xb1[lintalplc];
									yb1[j] = yb1[lintalplc];
									xb2[j] = xb2[lintalplc];
									yb2[j] = yb2[lintalplc];
									theline[j] = theline[lintalplc];
									swapped[j] = swapped[lintalplc];
									if (closest == lintalplc) closest = j;
								}
						}
					}
			}
			if (closest != i)
			{
				templong0 = xb1[i]; xb1[i] = xb1[closest]; xb1[closest] = templong0;
				templong0 = yb1[i]; yb1[i] = yb1[closest]; yb1[closest] = templong0;
				templong0 = xb2[i]; xb2[i] = xb2[closest]; xb2[closest] = templong0;
				templong0 = yb2[i]; yb2[i] = yb2[closest]; yb2[closest] = templong0;
				m = theline[i]; theline[i] = theline[closest]; theline[closest] = m;
				tempchar = swapped[i]; swapped[i] = swapped[closest]; swapped[closest] = tempchar;
			}
			drawall(i);
		}
	}
	lintalplc = 0;
	takernum = 0;
	return(0);
}

drawall(short i)
{
	unsigned char tempchar, theshade, z1v, z2v, cstatv, repeatv;
	unsigned short thez, dztop, dzbot, picn[3], hein[2];
	long templong0, templong1, templong2, templong3, dztoplong, dzbotlong;
	long x2, y2, x3, y3, top, bot, topinc, botinc, uplc, dplc;
	long hc1, hc2, hc3, hi1, hi2, hi3, yn1, yn2;
	long xa1v, ya1v, xa2v, ya2v, yh1, yh2, yh3, yh4, llinum, rlinum;
	short theplc, theceilpic, daline, j, k, m, n, o, good, um, dm, up, dp;

	if ((lin[theline[i]].cstat&15) == 0)
	{
		if (snum < maxsprites-1)
		{
			xs[snum] = xb1[i];
			dztoplong = posz-(((long)lin[theline[i]].z[0]+lin[theline[i]].z[1])<<7);
			if (lin[daline].zosc != 0)
				dztoplong += ((((long)lin[daline].zosc)*(sintable[(numframes<<6)&2047]-16384))>>15);
			templong1 = ((long)320)*yb1[i];
			ys[snum] = ((long)halfheight)-((dztoplong*((long)(xdim<<detmode))<<2)/templong1);
			sizs[snum] = ((65536L/yb1[i])*((long)xdim))/((long)320);
			sline[snum] = theline[i];
			for(j=0;j<320;j++)
			{
				sumost[snum][j] = (char)umost[j];
				sdmost[snum][j] = (char)dmost[j];
			}
			snum++;
		}
		good = 1;
	}
	else
	{
		good = 1;
		for(j=xb1[i];j<=xb2[i];j++)
			if (umost[j] < dmost[j])
				good = 0;
	}
	if (good == 0)
	{
		takernum = 1;
		daline = theline[i];
		z1v = lin[daline].z[0];
		z2v = lin[daline].z[1];
		cstatv = lin[daline].cstat;
		repeatv = lin[daline].repeat;
		if (lin[daline].zosc != 0)
		{
			if (cstatv == 3)
				z2v += ((((long)lin[daline].zosc)*(sintable[(numframes<<6)&2047]-16384))>>15);
			if (cstatv == 6)
				z1v += ((((long)lin[daline].zosc)*(sintable[(numframes<<6)&2047]-16384))>>15);
		}
		picn[0] = lin[daline].picnum[0];
		picn[1] = lin[daline].picnum[1];
		picn[2] = lin[daline].picnum[2];
		hein[0] = lin[daline].heinum[0];
		hein[1] = lin[daline].heinum[1];
		for(j=0;j<3;j++)
		{
			if (picanm[picn[j]] != 0)
			{
				switch(picanm[picn[j]]&192)
				{
					case 64:
						k = (numframes%((picanm[picn[j]]&63)<<1));
						if (k < (picanm[picn[j]]&63))
							picn[j] += k;
						else
							picn[j] += (((picanm[picn[j]]&63)<<1)-k);
						break;
					case 128:
						picn[j] += (numframes%((picanm[picn[j]]&63)+1));
						break;
					case 192:
						picn[j] -= (numframes%((picanm[picn[j]]&63)+1));
				}
			}
		}
		if ((closestline == 0) && ((cstatv&0x22) == 2))
		{
			if (swapped[i] == 0)
				newposz = (((long)z2v)<<8)-8192L;
			else
				newposz = (((long)z1v)<<8)-8192L;
			closestline = 1;
		}
		dztoplong = posz-(((long)z1v)<<8);
		dzbotlong = posz-(((long)z2v)<<8);
		if ((yb1[i] != 0) && (yb2[i] != 0))
		{
			templong0 = yb1[i]*320;
			templong1 = yb2[i]*320;
			templong2 = (dztoplong*((long)(xdim<<detmode))<<2);
			templong3 = (dzbotlong*((long)(xdim<<detmode))<<2);
			yh1 = templong2 / templong0;
			yh2 = templong3 / templong0;
			yh3 = templong2 / templong1;
			yh4 = templong3 / templong1;
			yn1 = 524288L / yb1[i];
			yn2 = 524288L / yb2[i];
		}
		dztop = (unsigned short)(labs(dztoplong));
		dzbot = (unsigned short)(labs(dzbotlong));

		templong0 = xb2[i]-xb1[i]+1L;
		hi1 = ((yh1-yh3)<<16)/templong0;
		hi2 = ((yh2-yh4)<<16)/templong0;
		hi3 = ((((yn2-yn1)*((long)(xdim<<detmode)))/320L)<<16)/templong0;
		uplc = ((((long)halfheight)-yh1)<<16);
		dplc = ((((long)halfheight)-yh2)<<16);
		hc3 = ((((long)((yn1*(xdim<<detmode))))/320L)<<16);
		for(j=xb1[i];j<xb2[i];j+=2)
		{
			uplace[j] = uplc;
			dplace[j] = dplc;
			ndist[j] = hc3;
			uplc += hi1;
			dplc += hi2;
			hc3 += hi3;
			uplace[j+1] = uplc;
			dplace[j+1] = dplc;
			ndist[j+1] = hc3;
			uplc += hi1;
			dplc += hi2;
			hc3 += hi3;
		}
		if (((xb2[i]^xb1[i])&1) == 0)
			uplace[j] = uplc, dplace[j] = dplc, ndist[j] = hc3;

		takernum = 3;
		if (ceilingstat > 0)
		{
			if (((cstatv&0x40) > 0) && (swapped[i] == 0))
			{
				for(j=xb1[i];j<xb2[i];j+=2)
				{
					x2 = (long)((sintable[(radarang[j<<detmode]+2048)&2047]/92) + ((ang&2047)>>1));
					y2 = (long)((sintable[(radarang[j<<detmode]+2560)&2047]/108));
					templong0 = ((((long)(((20480L/y2)*(xdim<<detmode))))/320L)<<16);
					x3 = (long)((sintable[(radarang[(j+1)<<detmode]+2048)&2047]/92) + ((ang&2047)>>1));
					y3 = (long)((sintable[(radarang[(j+1)<<detmode]+2560)&2047]/108));
					templong1 = ((((long)(((20480L/y3)*(xdim<<detmode))))/320L)<<16);
					vline2(j,(100L-((templong0>>8)/320L))<<16,uplace[j],(100L-((templong1>>8)/320L))<<16,uplace[j],(templong0<<2),(templong1<<2),picn[1],(short)(x2<<7),(short)(x3<<7),lin[daline].shade[1]);
				}
				if (((xb2[i]-xb1[i])&1) == 0)
				{
					x2 = (long)((sintable[(radarang[j<<detmode]+2048)&2047]/92) + ((ang&2047)>>1));
					y2 = (long)((sintable[(radarang[j<<detmode]+2560)&2047]/108));
					templong0 = ((((long)(((20480L/y2)*(xdim<<detmode))))/320L)<<16);
					vline(j,(100L-((templong0>>8)/320L))<<16,uplace[j],(templong0<<2),picn[1],(short)(x2<<7),lin[daline].shade[1]);
				}
			}
			if (((cstatv&0x22) == 0x22) && (swapped[i] == 1))
			{
				takernum = 7;
				theshade = lin[daline].shade[1];
				for(j=xb1[i];j<=xb2[i];j++)
					grouvline((long)j,((long)z2v)<<8,ddist[j],ndist[j],picn[1],hein[0],theshade);
				takernum = 3;
			}
			if (((cstatv&0x51) == 1) || (((cstatv&0x40) > 0) && (swapped[i] == 1)))
			{
				if (swapped[i] == 0)
				{
					thez = dztop;
					theceilpic = picn[1];
					theshade = lin[daline].shade[1];
					um = (short)(uplc>>16);
				}
				else
				{
					thez = dzbot;
					theceilpic = picn[2];
					theshade = lin[daline].shade[2];
					um = (short)(dplc>>16)-1;
				}
				up = um-1;
				if (dmost[xb1[i]]-1 <= up)
				{
					up = dmost[xb1[i]]-1;
					um = up+1;
				}
				if (um < -1) um = -1;
				if (up < -1) up = -1;
				if (um > ydim) um = ydim;
				if (up > ydim) up = ydim;

				for(j=xb1[i];j<=xb2[i];j++)
				{
					if (swapped[i] == 0)
						theplc = ((short)(uplace[j]>>16))-1;
					else
						theplc = ((short)(dplace[j]>>16));
					if (theplc < -1) theplc = -1;
					if (theplc > ydim) theplc = ydim;
					if (theplc >= dmost[j]) theplc = dmost[j]-1;

					while (umost[j] > um)
					{
						if (uxsave[um+1] >= 0)
						{
							hline(uxsave[um+1],j-1,um,thez,theceilpic,theshade);
							uxsave[um+1] = -1;
						}
						um++;
					}
					while (theplc < up)
					{
						if (uxsave[up+1] >= 0)
						{
							hline(uxsave[up+1],j-1,up,thez,theceilpic,theshade);
							uxsave[up+1] = -1;
						}
						up--;
					}
					if (umost[j] < um)
					{
						if (um > up+1) um = up+1;
						while (umost[j] < um)
						{
							um--;
							uxsave[um+1] = j;
						}
						um = umost[j];
					}
					if (theplc > up)
					{
						if (um > up+1) up = um-1;
						while (theplc > up)
						{
							up++;
							uxsave[up+1] = j;
						}
						up = theplc;
					}
				}
				for(m=um;m<=up;m++)
					if (uxsave[m+1] >= 0)
					{
						hline(uxsave[m+1],xb2[i],m,thez,theceilpic,theshade);
						uxsave[m+1] = -1;
					}
			}
			if (((cstatv&0x22) == 2) || (((cstatv&0x22) == 0x22) && (swapped[i] == 0)))
			{
				if (swapped[i] == 0)
				{
					thez = dzbot;
					theceilpic = picn[2];
					theshade = lin[daline].shade[2];
					dm = (short)(dplc>>16)-1;
				}
				else
				{
					thez = dztop;
					theceilpic = picn[1];
					theshade = lin[daline].shade[1];
					dm = (short)(uplc>>16);
				}
				dp = dm+1;
				if (umost[xb1[i]] >= dp)
				{
					dp = umost[xb1[i]];
					dm = dp-1;
				}
				if (dm < -1) dm = -1;
				if (dp < -1) dp = -1;
				if (dm > ydim) dm = ydim;
				if (dp > ydim) dp = ydim;

				for(j=xb1[i];j<=xb2[i];j++)
				{
					if (swapped[i] == 0)
						theplc = ((short)(dplace[j]>>16));
					else
						theplc = ((short)(uplace[j]>>16))-1;
					if (theplc < -1) theplc = -1;
					if (theplc > ydim) theplc = ydim;
					if (theplc < umost[j]) theplc = umost[j];
					while (dmost[j]-1 < dm)
					{
						if (dxsave[dm+1] >= 0)
						{
							hline(dxsave[dm+1],j-1,dm,thez,theceilpic,theshade);
							dxsave[dm+1] = -1;
						}
						dm--;
					}
					while (theplc > dp)
					{
						if (dxsave[dp+1] >= 0)
						{
							hline(dxsave[dp+1],j-1,dp,thez,theceilpic,theshade);
							dxsave[dp+1] = -1;
						}
						dp++;
					}
					while (dmost[j]-1 > dm)
					{
						dm++;
						if (dp <= dm)
							dxsave[dm+1] = j;
					}
					while (theplc < dp)
					{
						dp--;
						if (dp <= dm)
							dxsave[dp+1] = j;
					}
				}
				for(m=dp;m<=dm;m++)
					if (dxsave[m+1] >= 0)
					{
						hline(dxsave[m+1],xb2[i],m,thez,theceilpic,theshade);
						dxsave[m+1] = -1;
					}
			}
		}

		if ((ceilingstat < 2) && (swapped[i] == 0) && (z1v < z2v))
		{
			takernum = 2;

			xa1v = (long)lin[daline].xa1;
			ya1v = (long)lin[daline].ya1;
			xa2v = (long)lin[daline].xa2;
			ya2v = (long)lin[daline].ya2;
			tempchar = (picsiz[picn[0]]&15)+(picsiz[picn[0]]>>4);

			if (xb1[i] > 0)
				llinum = 0;
			else
			{
				x3 = (((long)((xdim>>1)-xb1[i]))*yb1[i])/(xdim>>3);
				y3 = yb1[i]<<2;
				x2 = posx-((x3*sintable[(2048-ang)&2047] - y3*sintable[(2560-ang)&2047])>>15);
				y2 = posy-((x3*sintable[(2560-ang)&2047] + y3*sintable[(2048-ang)&2047])>>15);
				if (labs(xa1v-xa2v) >= labs(ya1v-ya2v))
					llinum = ((labs(xa1v-x2))<<tempchar)/labs(xa2v-xa1v);
				else
					llinum = ((labs(ya1v-y2))<<tempchar)/labs(ya2v-ya1v);
				llinum *= ((long)(repeatv&15));
			}
			if (xb2[i] < xdim-1)
				rlinum = (1<<tempchar) * ((long)(repeatv&15));
			else
			{
				x3 = (((long)((xdim>>1)-xb2[i]))*yb2[i])/(xdim>>3);
				y3 = yb2[i]<<2;
				x2 = posx-((x3*sintable[(2048-ang)&2047] - y3*sintable[(2560-ang)&2047])>>15);
				y2 = posy-((x3*sintable[(2560-ang)&2047] + y3*sintable[(2048-ang)&2047])>>15);
				if (labs(xa1v-xa2v) >= labs(ya1v-ya2v))
					rlinum = ((labs(xa1v-x2))<<tempchar)/labs(xa2v-xa1v);
				else
					rlinum = ((labs(ya1v-y2))<<tempchar)/labs(ya2v-ya1v);
				rlinum *= ((long)(repeatv&15));
			}
			top = 0L, topinc = (rlinum-llinum)*(yb1[i]>>1);
			bot = (xb2[i]-xb1[i])*(yb2[i]>>1), botinc = (yb1[i]>>1)-(yb2[i]>>1);
			for(j=xb1[i];j<=xb2[i];j++)
			{
				if (bot != 0)
					linum[j] = llinum+(top/bot);
				top += topinc;
				bot += botinc;
				if ((top&0x40000000) != 0)
				{
					top >>= 1;
					bot >>= 1;
					topinc >>= 1;
					botinc >>= 1;
				}
			}
			k = 0;
			for(j=xb1[i];j<xb2[i];j+=2)
				vline2(j,uplace[j],dplace[j],uplace[j+1],dplace[j+1],ndist[j]>>(repeatv>>4),(ndist[j]+hi3)>>(repeatv>>4),picn[0],(short)linum[j],(short)linum[j+1],lin[daline].shade[0]);
			if (((xb2[i]-xb1[i])&1) == 0)
				vline(j,uplace[j],dplace[j],ndist[j]>>(repeatv>>4),picn[0],(short)linum[j],lin[daline].shade[0]);
		}

		takernum = 1;
		for(j=xb1[i];j<=xb2[i];j++)
			if (dmost[j] >= umost[j])
			{
				if ((cstatv&15) == 6)
				{
					if (swapped[i] == 0)
					{
						dzmost[j] = z1v;
						if (searchit > 0)
							if (searchx == j)
							{
								if (searchy > (short)(dplace[j]>>16))
								{
									searchreturn = (long)daline + 131072L;
									searchit = 0;
								}
								else if (searchy > (short)(uplace[j]>>16))
								{
									searchreturn = (long)daline;
									searchit = 0;
								}
							}
					}
					else
					{
						dzmost[j] = z2v;
						if (searchit > 0)
							if (searchx == j)
								if (searchy > (short)(uplace[j]>>16))
								{
									searchreturn = (long)daline + 65536L;
									searchit = 0;
								}
					}
					ddist[j] = ndist[j];
					if (((short)(uplace[j]>>16)) <= dmost[j])
						if (((cstatv&0x20) != 0x20) || (swapped[i] == 0))
							dmost[j] = ((short)(uplace[j]>>16));
				}
				else if ((cstatv&15) == 9)
				{
					if (swapped[i] == 0)
					{
						uzmost[j] = z2v;
						if (searchit > 0)
							if (searchx == j)
							{
								if (searchy < (short)(uplace[j]>>16))
								{
									searchreturn = (long)daline + 65536L;
									searchit = 0;
								}
								else if (searchy < (short)(dplace[j]>>16))
								{
									searchreturn = (long)daline;
									searchit = 0;
								}
							}
					}
					else
					{
						uzmost[j] = z1v;
						if (searchit > 0)
							if (searchx == j)
								if (searchy < (short)(dplace[j]>>16))
								{
									searchreturn = (long)daline + 131072L;
									searchit = 0;
								}
					}

					udist[j] = ndist[j];
					if (((short)(dplace[j]>>16)) >= umost[j])
						umost[j] = ((short)(dplace[j]>>16));
				}
				if (((cstatv&15) == 3) || (umost[j] > dmost[j]))
				{
					if (searchit > 0)
						if (searchx == j)
						{
							if (searchy < (short)(uplace[j]>>16))
							{
								searchreturn = (long)daline + 65536L;
								searchit = 0;
							}
							else if (searchy > (short)(dplace[j]>>16))
							{
								searchreturn = (long)daline + 131072L;
								searchit = 0;
							}
							else
							{
								searchreturn = (long)daline;
								searchit = 0;
							}
						}
					udist[j] = ndist[j];
					ddist[j] = ndist[j];
					umost[j] = 100;
					dmost[j] = 99;
					numhits--;
					if (numhits < 0)
					{
						j = xb2[i];
						i = lintalplc;
						break;
					}
				}
			}
		takernum = 0;
		if (keystatus[0x3a] > 0)
		{
			keystatus[0x19] = 0;
			while ((keystatus[0x19] == 0) && (keystatus[1] == 0));
			keystatus[0x19] = 0;
		}
	}
	return(0);
}

drawsprites()
{
	signed char tempchar;
	unsigned char shiftval, shadeoffs;
	unsigned short walnume;
	long vinc, nvinc, picplc1, picplc2, doubsiz;
	long siz, y1, y2, y1v, y2v, y3v, y4v, linume, lininc, pictot, xsiz, ysiz;
	short i, j, k, lside, rside, maskval, gap, temp, sordi;

	takernum = 4;
	for(i=0;i<snum;i++)
		sord[i] = i;
	gap = (snum>>1);
	while (gap > 0)
	{
		for(i=0;i<snum-gap;i++)
		{
			temp = i;
			while (sizs[temp] > sizs[temp+gap])
			{
				j = sord[temp];
				sord[temp] = sord[temp+gap];
				sord[temp+gap] = j;
				temp -= gap;
				if (temp < 0)
					break;
			}
		}
		gap >>= 1;
	}
	for(i=0;i<snum;i++)
	{
		sordi = sord[i];
		if (sizs[sordi] == 0)
			sizs[sordi] = 1;
		vinc = (4194304L / sizs[sordi])>>detmode;
		shadeoffs = lin[sline[sordi]].shade[0];

		tempchar = brightenarea-((char)(vinc>>(16+detmode)));
		if (tempchar < -8) tempchar = -8;
		if (tempchar > 1) tempchar = 1;
		shadeoffs += tempchar;

		if ((lin[sline[sordi]].repeat&240) > 0)
		{
			sizs[sordi] >>= (lin[sline[sordi]].repeat>>4);
			vinc <<= (lin[sline[sordi]].repeat>>4);
			if (sizs[sordi] == 0)
				sizs[sordi] = 1;
		}
		walnume = lin[sline[sordi]].picnum[0];
		if (picanm[walnume] != 0)
		{
			switch(picanm[walnume]&192)
			{
				case 64:
					k = (numframes%((picanm[walnume]&63)<<1));
					if (k < (picanm[walnume]&63))
						walnume += k;
					else
						walnume += (((picanm[walnume]&63)<<1)-k);
					break;
				case 128:
					walnume += (numframes%((picanm[walnume]&63)+1));
						break;
				case 192:
					walnume -= (numframes%((picanm[walnume]&63)+1));
			}
		}
		xsiz = ((sizs[sordi]<<(picsiz[walnume]&15))>>6);
		ysiz = ((sizs[sordi]<<((picsiz[walnume]>>4)+detmode))>>6);
		lside = (short)(xs[sordi]-(xsiz>>1));
		rside = (short)(lside+xsiz);
		y1 = ys[sordi]-(ysiz>>1);
		y2 = y1+ysiz;
		shiftval = 32-(picsiz[walnume]>>4);
		nvinc = vinc<<(shiftval-16);
		vinc1 = nvinc;
		vinc2 = nvinc;
		pictot = (1<<(((picsiz[walnume]&15)+(picsiz[walnume]>>4))));
		linume = 0L;
		lininc = (pictot<<16)/(xsiz+1);
		maskval = ((0xffff>>(16-(picsiz[walnume]&15)))<<(picsiz[walnume]>>4));
		if ((sizs[sordi] > 1) && (picsiz[walnume] != 0))
		{
			j = lside;
			while (j < rside)
			{
				if ((j >= 0) && (j < xdim))
				{
					y1v = y1, y2v = y2;
					picplc1 = (linume>>16)&maskval;
					vplc1 = (picplc1<<16);
					if (y1v < sumost[sordi][j])
					{
						vplc1 += (sumost[sordi][j]-y1v)*vinc;
						y1v = sumost[sordi][j];
					}
					if (y2v > sdmost[sordi][j]) y2v = sdmost[sordi][j];
				}
				else
					y1v = 1, y2v = 0;
				if ((j >= -1) && (j < xdim-1))
				{
					y3v = y1, y4v = y2;
					picplc2 = ((linume+lininc)>>16)&maskval;
					vplc2 = (picplc2<<16);
					if (y3v < sumost[sordi][j+1])
					{
						vplc2 += (sumost[sordi][j+1]-y3v)*vinc;
						y3v = sumost[sordi][j+1];
					}
					if (y4v > sdmost[sordi][j+1]) y4v = sdmost[sordi][j+1];
				}
				else
					y3v = 1, y4v = 0;

				if (y1v > y2v)
				{
					if (y3v < y4v)
						svlineasm1(0,nvinc,(vplc2<<(shiftval-16))+shiftval,((y4v-y3v)<<8)+shadeoffs,picplc2+waloff[walnume],(y3v*320+j+1)+frameplace+centeroffset);
				}
				else if (y3v > y4v)
				{
					if (y1v < y2v)
						svlineasm1(0,nvinc,(vplc1<<(shiftval-16))+shiftval,((y2v-y1v)<<8)+shadeoffs,picplc1+waloff[walnume],(y1v*320+j)+frameplace+centeroffset);
				}
				else
				{
					vplc1 <<= (shiftval-16), vplc1 += shiftval;
					vplc2 <<= (shiftval-16), vplc2 += shadeoffs;
					picplc1 += waloff[walnume];
					picplc2 += waloff[walnume];

					if (y2v < y4v)
						doubsiz = y2v;
					else
						doubsiz = y4v;
					if (y1v < y3v)
					{
						pplc = (y1v*320+j)+frameplace+centeroffset;
						svlineasm2l((y3v-y1v-1)<<16,picplc1,vplc1,vplc2,picplc2,pplc);
						doubsiz -= y3v;
					}
					else
					{
						pplc = (y3v*320+j)+frameplace+centeroffset;
						if (y3v < y1v)
							svlineasm2r((y1v-y3v-1)<<16,picplc1,vplc1,vplc2,picplc2,pplc);
						doubsiz -= y1v;
					}
					if (doubsiz > 1)
						svlineasm2b((doubsiz-1)<<16,picplc1,vplc1,vplc2,picplc2,pplc);
					if (y2v < y4v)
						svlineasm2r((y4v-y2v-1)<<16,picplc1,vplc1,vplc2,picplc2,pplc);
					else if (y2v > y4v)
						svlineasm2l((y2v-y4v-1)<<16,picplc1,vplc1,vplc2,picplc2,pplc);
				}
				linume += (lininc<<1);
				j += 2;
			}
			if ((j == rside) && (j >= 0) && (j < xdim))
			{
				y1v = y1, y2v = y2;
				picplc1 = (linume>>16)&maskval;
				vplc1 = (picplc1<<16);
				if (y1v < sumost[sordi][j])
				{
					vplc1 += (sumost[sordi][j]-y1v)*vinc;
					y1v = sumost[sordi][j];
				}
				if (y2v > sdmost[sordi][j]) y2v = sdmost[sordi][j];

				if (y2v > y1v)
					svlineasm1(0,nvinc,(vplc1<<(shiftval-16))+shiftval,((y2v-y1v)<<8)+shadeoffs,picplc1+waloff[walnume],(y1v*320+j)+frameplace+centeroffset);
			}
		}
	}
	return(0);
}

drawsprite(x,y,siz,walnume,shadeoffs)
short walnume;
long x, y, siz;
unsigned char shadeoffs;
{
	unsigned char shiftval;
	long vinc, nvinc, picplc1, picplc2, doubsiz;
	long y1, y2, y1v, y2v, y3v, y4v, linume, lininc, pictot, xsiz, ysiz;
	short i, j, k, lside, rside, maskval;

	takernum = 4;
	if (siz == 0)
		siz = 1;
	vinc = (4194304L / siz)>>detmode;

	if (picanm[walnume] != 0)
	{
		switch(picanm[walnume]&192)
		{
			case 64:
				k = (numframes%((picanm[walnume]&63)<<1));
				if (k < (picanm[walnume]&63))
					walnume += k;
				else
					walnume += (((picanm[walnume]&63)<<1)-k);
				break;
			case 128:
				walnume += (numframes%((picanm[walnume]&63)+1));
					break;
			case 192:
				walnume -= (numframes%((picanm[walnume]&63)+1));
		}
	}
	xsiz = ((siz<<(picsiz[walnume]&15))>>6);
	ysiz = ((siz<<((picsiz[walnume]>>4)+detmode))>>6);
	lside = (short)(x-(xsiz>>1));
	rside = (short)(lside+xsiz);
	y1 = y-(ysiz>>1);
	y2 = y1+ysiz;
	shiftval = 32-(picsiz[walnume]>>4);
	nvinc = vinc<<(shiftval-16);
	vinc1 = nvinc;
	vinc2 = nvinc;
	pictot = (1<<(((picsiz[walnume]&15)+(picsiz[walnume]>>4))));
	linume = 0L;
	lininc = (pictot<<16)/(xsiz+1);
	maskval = ((0xffff>>(16-(picsiz[walnume]&15)))<<(picsiz[walnume]>>4));
	if ((siz > 1) && (picsiz[walnume] != 0))
	{
		j = lside;
		while (j < rside)
		{
			if ((j >= 0) && (j < xtotaldim))
			{
				y1v = y1, y2v = y2;
				picplc1 = (linume>>16)&maskval;
				vplc1 = (picplc1<<16);
				if (y1v < 0)
				{
					vplc1 += (0-y1v)*vinc;
					y1v = 0;
				}
				if (y2v > ytotaldim) y2v = ytotaldim;
			}
			else
				y1v = 1, y2v = 0;
			if ((j >= -1) && (j < xtotaldim-1))
			{
				y3v = y1, y4v = y2;
				picplc2 = ((linume+lininc)>>16)&maskval;
				vplc2 = (picplc2<<16);
				if (y3v < 0)
				{
					vplc2 += (0-y3v)*vinc;
					y3v = 0;
				}
				if (y4v > ytotaldim) y4v = ytotaldim;
			}
			else
				y3v = 1, y4v = 0;

			if (y1v > y2v)
			{
				if (y3v < y4v)
					svlineasm1(0,nvinc,(vplc2<<(shiftval-16))+shiftval,((y4v-y3v)<<8)+shadeoffs,picplc2+waloff[walnume],(y3v*320+j+1)+frameplace);
			}
			else if (y3v > y4v)
			{
				if (y1v < y2v)
					svlineasm1(0,nvinc,(vplc1<<(shiftval-16))+shiftval,((y2v-y1v)<<8)+shadeoffs,picplc1+waloff[walnume],(y1v*320+j)+frameplace);
			}
			else
			{
				vplc1 <<= (shiftval-16), vplc1 += shiftval;
				vplc2 <<= (shiftval-16), vplc2 += shadeoffs;
				picplc1 += waloff[walnume];
				picplc2 += waloff[walnume];

				if (y2v < y4v)
					doubsiz = y2v;
				else
					doubsiz = y4v;
				if (y1v < y3v)
				{
					pplc = (y1v*320+j)+frameplace;
					svlineasm2l((y3v-y1v-1)<<16,picplc1,vplc1,vplc2,picplc2,pplc);
					doubsiz -= y3v;
				}
				else
				{
					pplc = (y3v*320+j)+frameplace;
					if (y3v < y1v)
						svlineasm2r((y1v-y3v-1)<<16,picplc1,vplc1,vplc2,picplc2,pplc);
					doubsiz -= y1v;
				}
				if (doubsiz > 1)
					svlineasm2b((doubsiz-1)<<16,picplc1,vplc1,vplc2,picplc2,pplc);
				if (y2v < y4v)
					svlineasm2r((y4v-y2v-1)<<16,picplc1,vplc1,vplc2,picplc2,pplc);
				else if (y2v > y4v)
					svlineasm2l((y2v-y4v-1)<<16,picplc1,vplc1,vplc2,picplc2,pplc);
			}
			linume += (lininc<<1);
			j += 2;
		}
		if ((j == rside) && (j >= 0) && (j < xtotaldim))
		{
			y1v = y1, y2v = y2;
			picplc1 = (linume>>16)&maskval;
			vplc1 = (picplc1<<16);
			if (y1v < 0)
			{
				vplc1 += (0-y1v)*vinc;
				y1v = 0;
			}
			if (y2v > ytotaldim) y2v = ytotaldim;
			if (y2v > y1v)
				svlineasm1(0,nvinc,(vplc1<<(shiftval-16))+shiftval,((y2v-y1v)<<8)+shadeoffs,picplc1+waloff[walnume],(y1v*320+j)+frameplace);
		}
	}
	return(0);
}

copytilepiece(walnume1,x1,y1,xsiz,ysiz,walnume2,x2,y2,shadeoffs)
long walnume1, x1, y1, xsiz, ysiz, walnume2, x2, y2;
char shadeoffs;
{
	long xsiz1, ysiz1, xsiz2, ysiz2, picplc1, picplc2, i, j, ptr1, ptr2;

	if ((picsiz[walnume1] != 0) && (picsiz[walnume2] != 0))
	{
		xsiz1 = (1<<(picsiz[walnume1]&15));
		ysiz1 = (1<<(picsiz[walnume1]>>4));
		xsiz2 = (1<<(picsiz[walnume2]&15));
		ysiz2 = (1<<(picsiz[walnume2]>>4));
		for(i=x1;i<x1+xsiz;i++)
			for(j=y1;j<y1+ysiz;j++)
				if ((i < xsiz1) && (j < ysiz1) && (i-x1+x2 < xsiz2) && (j-y1+y2 < ysiz2))
				{
					ptr1 = waloff[walnume1] + i * ysiz1 + j;
					ptr2 = waloff[walnume2] + (i-x1+x2) * ysiz2 + (j-y1+y2);
					memcopybyte(ptr2,ptr1,shadeoffs);
				}
	}
}

setgamemode()
{
	int i;

	setvmode(0x13);
	for(i=2;i>=0;i--)
	{
		outp(0x3cd,i);
		clearscreen();
	}
	if ((i = open("palette.dat",O_BINARY|O_RDWR,S_IREAD)) != -1)
	{
		read(i,&palette[0],768);
		close(i);
	}
	outp(0x3c8,0);
	for(i=0;i<768;i++)
		outp(0x3c9,palette[i]);
}

initengine()
{
	long templong;
	short i;

	loadtables();
	if (resolutionset == 0)
		setscreensize(320,200);
	ceilingstat = 1;
	for(templong=1;templong<2048;templong++)
		recip[templong] = 65536L / templong;
	for(i=0;i<242;i++)
	{
		uxsave[i] = -1;
		dxsave[i] = -1;
	}
	capturecount = 0;
	clearbuf((long)(&keystatus[0]),64L,0L);
	clockspeed = 0;
	totalclock = 0;
	numframes = 0;
	takernum = 0;
	for(i=0;i<numtimecounts;i++)
		timetakercount[i] = 0;
	mousx = 0;
	mousy = 0;
	lintalplc = 0;
	page = 0;
	brightenarea = 0;
	setupmouse();
	oldkeyhandler = _dos_getvect(0x9);
	_disable(); _dos_setvect(0x9, keyhandler); _enable();
	oldhand = _dos_getvect(0x8);
	_dos_setvect(0x8, ksmhandler);
	outp(0x43,54); outp(0x40,4972&255); outp(0x40,4972>>8);
}

uninitengine()
{
	if (poscapture > 0)
	{
		lseek(posfil,0L,SEEK_SET);
		poscapture--;
		write(posfil,&poscapture,4);
		close(posfil);
	}
	_dos_setvect(0x8, oldhand);
	_dos_setvect(0x9, oldkeyhandler);
	outp(0x43,54); outp(0x40,255); outp(0x40,255);
	free(pic);
}

resettiming()
{
	long i;

	for(i=0;i<numtimecounts;i++)
		timetakercount[i] = 0L;
	numframes = 0L;
	clockspeed = 0L;
	totalclock = 0L;
}

showengineinfo(whatpart)
char whatpart;
{
	short i, j, k;
	long templong, templong1;

	setvmode(0x3);
	if (whatpart == 1)
	{
		templong = 0;
		for(i=0;i<numtimecounts;i++)
			templong += timetakercount[i];
		if (templong != 0)
			for(i=0;i<numtimecounts;i++)
			{
				templong1 = (10000L*timetakercount[i])/templong;
				printf("%d - %2d.%1d%1d%% - %s",i,(short)(templong1/100),(short)((templong1/10)%10),(short)(templong1%10),timenames[i]);
				j = (short)((templong1+50)/100);
				for(k=0;k<(j>>1);k++)
					printf("");
				if ((j&1) > 0)
					printf("");
				printf("\n");
			}
		printf("Lintalcnt = %d\n",lintalcnt);
	}
	if (totalclock != 0)
	{
		templong1 = (numframes*24000L)/totalclock;
		printf("%d.%1d%1d frames per second\n",(short)(templong1/100),(short)((templong1/10)%10),(short)(templong1%10));
	}
}

setscreensize(xd, yd)
short xd, yd;
{
	xdim = (xd&0xfff8);
	ydim = (yd&0xfff8);
	if (xdim > 320) xdim = 320;
	if (xdim < 8) xdim = 8;
	if (ydim > 200) ydim = 200;
	if (ydim < 8) ydim = 8;
	halfwidth = (xdim>>1);
	eigthwidth = (xdim>>3);
	halfheight = (ydim>>1);
	centeroffset = (long)(((200-ydim)>>1)*320) + ((320-xdim)>>1);
	scrsize = ((long)ydim)*320L;
	resolutionset = 1;
}

loadpcx(char filename[20],char *ptr)
{
	unsigned char dat;
	long fil, i, p, datcnt, leng;

	if ((fil = open(filename,O_BINARY|O_RDWR,S_IREAD)) == -1)
		return(-1);
	read(fil,&tempbuf[0],128);
	p = 64000;
	read(fil,&tempbuf[0],4096), datcnt = 0;
	while (p > 0)
	{
		dat = tempbuf[datcnt++];
		if (datcnt == 4096)
			read(fil,&tempbuf[0],4096), datcnt = 0;
		if ((dat&0xc0) == 0xc0)
		{
			leng = (dat&0x3f);
			dat = tempbuf[datcnt++];
			if (datcnt == 4096)
				read(fil,&tempbuf[0],4096), datcnt = 0;
			for(i=0;i<leng;i++)
			{
				*ptr = dat;
				ptr++;
			}
			p -= leng;
		}
		else
		{
			*ptr = dat;
			ptr++;
			p--;
		}
	}
	dat = tempbuf[datcnt++];
	if (datcnt == 4096)
		read(fil,&tempbuf[0],4096), datcnt = 0;
	if (dat == 0xc)
	{
		outp(0x3c8,0);
		for(i=0;i<768;i++)
		{
			dat = tempbuf[datcnt++];
			if (datcnt == 4096)
				read(fil,&tempbuf[0],4096), datcnt = 0;
			outp(0x3c9,dat>>2);
		}
	}
	close(fil);
	return(0);
}

setupdraw2buffer(char *ptr)
{
	long i, j;

	draw2buf = (char *)malloc(81864L);
	for(j=0;j<200;j++)
		for(i=0;i<320;i++)
		{
			draw2buf[(i<<8)+j] = *ptr;
			ptr++;
		}
}

draw2d(plcx, plcy, zoom, ange)
long plcx, plcy, zoom;
short ange;
{
	short i;
	long cosang, sinang, xcosadd, xsinadd, ycosadd, ysinadd;
	long x, y, xinc1, yinc1, xinc2, yinc2, p;

	cosang = ((((long)sintable[(ange+512)&2047])*zoom)>>16);
	sinang = ((((long)sintable[ange])*zoom)>>16);
	xcosadd = ((320 * cosang)>>1);
	xsinadd = ((320 * sinang)>>1);
	ycosadd = ((200 * cosang)>>1);
	ysinadd = ((200 * sinang)>>1);
	x = (plcx>>8) + ysinadd - xcosadd;
	y = (plcy>>8) - ycosadd - xsinadd;
	xinc1 = ((xcosadd<<1) / 320);
	yinc1 = ((xsinadd<<1) / 320);
	xinc2 = ((ysinadd<<1) / 200);
	yinc2 = ((ycosadd<<1) / 200);
	p = frameplace;
	for(i=0;i<200;i++)
	{
		row2draw320200(160<<16,x<<6,y<<6,yinc1<<6,xinc1<<6,p);
		p += 320L;
		x -= xinc2;
		y += yinc2;
	}
	return(0);
}

freedraw2buffer()
{
	free(draw2buf);
}

grouvline(i, zd, d1, d2, walnume, heinume, shadeoffs)
long i, zd, d1, d2;
short walnume, heinume;
char shadeoffs;
{
	signed char tempchar;
	long sinval, cosval, tempx, tempy;

	if (((d1 < 8L) && (d2 < 8L)) || (umost[i] >= dmost[i]) || (picsiz[walnume] == 0) || (picsiz[heinume] == 0))
		return(0);

	if (d1 < 8L) d1 = 8L;
	groudcnt = ((33554432L*32L) / (d1>>3));
	if (groudcnt < 1L) groudcnt = 1L;

	if (d2 < 8L) d2 = 8L;
	groudend = ((33554432L*32L) / (d2>>3));
	if (groudend < 1L) groudend = 1L;
	if (groudend >= 2048L) groudend = 2047L;

	if (groudend-1 <= groudcnt)
		return(0);

	grouwaloffs = (char *)waloff[walnume];
	grouheioffs = (char *)waloff[heinume];

	cosval = (long)sintable[(ang+2560)&2047];
	sinval = (long)sintable[(ang+2048)&2047];
	tempx = groudcnt;
	tempy = ((i-halfwidth) * (groudcnt+1)) / halfwidth;
	vplc1 = -((((posx<<12) + ((tempx*cosval - tempy*sinval)<<1))<<10));
	vplc2 = -((((posy<<12) + ((tempy*cosval + tempx*sinval)<<1))<<10));
	tempx = (groudend-groudcnt)-1;
	tempy = ((i-halfwidth) * tempx) / halfwidth;
	vinc1 = -((((tempx*cosval - tempy*sinval)<<3)/tempx)<<9);
	vinc2 = -((((tempy*cosval + tempx*sinval)<<3)/tempx)<<9);

	tempchar = brightenarea-((char)(groudcnt>>(8+detmode)));
	if (tempchar < -8) tempchar = -8;
	if (tempchar > 1) tempchar = 1;
	shadeoffs += tempchar;

	grouumost = umost[i];
	groudmost = dmost[i];
	posze = zd-posz;
	horize = halfheight;
	groudinc = 2L;
	dmost[i] = grouddraw(0,0,groudmost,(long)shadeoffs,groudcnt,(groudmost*320L+i)+frameplace);
	return(0);
}

clipmove (long vel)
{
	unsigned char poszchar;
	long i, x, y, zx;
	long incr1, incr2, xdir, ydir, xdiredge, ydiredge, d, bad, bad1, bad2;

	poszchar = (unsigned char)(posz>>8);
	incr1 = vel * sintable[(ang+2560)&2047];
	incr2 = vel * sintable[(ang+2048)&2047];
	if (incr1 < 0)
	{
		xdir = -1;
		incr1 = -incr1;
	}
	else if (incr1 > 0)
	{
		xdir = 1;
	}
	else
	{
		xdir = 0;
	}
	if (incr2 < 0)
	{
		ydir = -1;
		incr2 = -incr2;
	}
	else if (incr2 > 0)
	{
		ydir = 1;
	}
	else
	{
		ydir = 0;
	}
	xdiredge = (xdir<<3); ydiredge = (ydir<<3);
	d = incr2 - incr1;
	bad1 = 0; bad2 = 0;
	x = ((posx-nowx)>>4); y = ((posy-nowy)>>4);
	if ((x <= 8) || (x >= 119) || (y <= 8) || (y >= 119))
	{
		nowx = ((posx-256)&0xfc00);
		nowy = ((posy-256)&0xfc00);
		x = ((posx-nowx)>>4); y = ((posy-nowy)>>4);
		cliploadlocal();
	}
	for(i=0;i<=((incr1+incr2)>>19);i++)
	{
		if (d < 0)
		{
			d += incr2;
			bad1 = 0;
			if (clipbuf[x+xdiredge][y-7] < poszchar) bad1 = 2;
			if (clipbuf[x+xdiredge][y+7] < poszchar) bad1 = 2;
			for(zx=-6;zx<=6;zx++)
				if (clipbuf[x+xdiredge][y+zx] < poszchar) bad1 = 1;
			if (bad1 == 0) x += xdir;
		}
		else
		{
			d -= incr1;
			bad2 = 0;
			if (clipbuf[x-7][y+ydiredge] < poszchar) bad2 = 2;
			if (clipbuf[x+7][y+ydiredge] < poszchar) bad2 = 2;
			for(zx=-6;zx<=6;zx++)
				if (clipbuf[x+zx][y+ydiredge] < poszchar) bad2 = 1;
			if (bad2 == 0) y += ydir;
		}
		if (((bad1 == 2) || (bad2 == 2)) && ((bad1 > 0) && (bad2 > 0)))
		{
			if (bad1 == 2)
			{
				bad = 0;
				for(zx=-7;zx<=7;zx++)
					bad |= (255-clipbuf[x+zx][y-ydiredge]);
				if (bad == 0)
				{
					y -= ydir;
					d = 0;
				}
			}
			if (bad2 == 2)
			{
				bad = 0;
				for(zx=-7;zx<=7;zx++)
					bad |= (255-clipbuf[x-xdiredge][y+zx]);
				if (bad == 0)
				{
					x -= xdir;
					d = -1;
				}
			}
		}
		bad = 0;
		if (x <= 8)
		{
			nowx -= 1024;
			x += 64;
			bad = 1;
		}
		if (x >= 119)
		{
			nowx += 1024;
			x -= 64;
			bad = 1;
		}
		if (y <= 8)
		{
			nowy -= 1024;
			y += 64;
			bad = 1;
		}
		if (y >= 119)
		{
			nowy += 1024;
			y -= 64;
			bad = 1;
		}
		if (bad == 1) cliploadlocal();
	}
	posx = nowx + (x<<4);
	posy = nowy + (y<<4);
}

cliploadlocal()
{
	char clipheight;
	long i, j, xz, yz, p, linti, xc1, yc1, xc2, yc2;
	long incr1, incr2, xdir, ydir, xc, x, y;

	clearbuf((long)(&tempbuf[0]),((long)(numlines+3)>>2),0L);
	clearbuf((long)(&clipbuf),4096L,0xffffffff);
	for(xz=nowx;xz<=nowx+1024;xz+=1024)
		for(yz=nowy;yz<=nowy+1024;yz+=1024)
		{
			p = ((xz>>10)<<6) + (yz>>10);
			for(i=lintaladdr[p];i<lintaladdr[p+1];i++)
			{
				linti = lintal[i];
				if (tempbuf[linti] == 0)
				{
					clipheight = 255;
					if ((lin[linti].cstat&15) == 6) clipheight = lin[linti].z[0];
					if ((lin[linti].cstat&15) == 3) clipheight = 0;
					if ((lin[linti].cstat&15) == 0) clipheight = 0;
					if ((lin[linti].cstat&128) > 0)
					{
						if ((lin[linti].cstat&15) == 3)
						{
							clipheight = 255;
						}
						else if ((lin[linti].cstat&15) == 6)
						{
							if (abs(lin[linti].z[0]-lin[linti].z[1]) < 32)
								clipheight = 0;
							else
								clipheight = 255;
						}
					}
					if (clipheight < 255)
					{
						tempbuf[linti] = 1;
						xc1 = ((lin[linti].xa1-nowx)>>4);
						yc1 = ((lin[linti].ya1-nowy)>>4);
						xc2 = ((lin[linti].xa2-nowx)>>4);
						yc2 = ((lin[linti].ya2-nowy)>>4);

						incr1 = xc2 - xc1;
						incr2 = yc2 - yc1;
						if (incr1 < 0)
						{
							xdir = -1;
							incr1 = -incr1;
						}
						else if (incr1 > 0)
						{
							xdir = 1;
						}
						else
						{
							xdir = 0;
						}
						if (incr2 < 0)
						{
							ydir = -1;
							incr2 = -incr2;
						}
						else if (incr2 > 0)
						{
							ydir = 1;
						}
						else
						{
							ydir = 0;
						}
						xc = 0;
						x = xc1; y = yc1;
						do
						{
							if (((x|y)&0xff80) == 0) clipbuf[x][y] = clipheight;
							if (xc < 0)
							{
								xc += incr2;
								x += xdir;
							}
							else
							{
								xc -= incr1;
								y += ydir;
							}
						}
						while ((x != xc2) || (y != yc2));
					}
				}
			}
		}
}

showpositioncapture(char filename[20])
{
	long i, fil, framenumber;

	if ((fil = open(filename,O_BINARY|O_RDWR,S_IREAD)) != -1)
	{
		read(fil,&framenumber,4);
		while ((framenumber > 0) && ((keystatus[0x1c]|keystatus[0x9c]|keystatus[1]|keystatus[0x39]) == 0))
		{
			read(fil,&posx,4);
			read(fil,&posy,4);
			read(fil,&posz,4);
			read(fil,&ang,2);

			drawscreen(0);
			nextpage();

			framenumber--;
		}
		close(fil);
	}
}

load2board(char filename[20])
{
	short i, j;

	if ((i = open(filename,O_BINARY|O_RDWR,S_IREAD)) != -1)
	{
		read(i,&board2d[0],8192);
		for(j=0;j<4096;j++)
			boardoffs[j] = waloff[board2d[j]&1023];
		close(i);
	}
}

draw2board(posx, posy, zoom, ang)
long posx, posy, zoom;
short ang;
{
	short pagcnt;
	long cosang, sinang, xcosadd, xsinadd, ycosadd, ysinadd;
	long i, x, y, xinc1, yinc1, xinc2, yinc2, p;

	cosang = ((((long)sintable[(ang+512)&2047])*zoom)>>16);
	sinang = ((((long)sintable[ang])*zoom)>>16);
	xcosadd = ((xdim * cosang)>>1);
	xsinadd = ((xdim * sinang)>>1);
	ycosadd = ((ydim * cosang)>>1);
	ysinadd = ((ydim * sinang)>>1);
	x = (posx>>8) + ysinadd - xcosadd;
	y = (posy>>8) - ycosadd - xsinadd;
	xinc1 = ((xcosadd<<1) / xdim);
	yinc1 = ((xsinadd<<1) / xdim);
	xinc2 = ((ysinadd<<1) / ydim);
	yinc2 = ((ycosadd<<1) / ydim);
	if (detmode == 0)
		p = (centeroffset&65535)+0x000a0000;
	else
		p = ((centeroffset>>2)&65535)+0x000a0000;
	if (detmode == 0)
	{
		for(i=0;i<ydim;i++)
		{
			row2draw642(((xdim>>1)<<16),(x<<16)+((x>>6)&0xfc00),(xinc1<<16)+(yinc1&0xffff),(y<<16)+((y>>6)&0xfc00),i,p);
			p += 320L;
			x -= xinc2;
			y += yinc2;
		}
	}
	else
	{
		for(i=0;i<ydim;i++)
		{
			row2draw642(((xdim>>2)<<16),((x+xinc1)<<16)+(((x+xinc1)>>6)&0xfc00),(xinc1<<17)+((yinc1<<1)&0xffff),((y+yinc1)<<16)+(((y+yinc1)>>6)&0xfc00),i,p);
			p += 160L;
			x -= xinc2;
			y += yinc2;
		}
	}
	return(0);
}
