/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal;

import com.jogamp.common.os.Platform;
import com.jogamp.openal.AL;
import com.jogamp.openal.ALC;
import com.jogamp.openal.ALException;
import jogamp.openal.ALCImpl;
import jogamp.openal.ALImpl;
import jogamp.openal.Debug;

public class ALFactory {
    public static final boolean DEBUG = Debug.debug("Factory");
    private static boolean initialized = false;
    private static AL al;
    private static ALC alc;

    private ALFactory() {
    }

    private static synchronized void initialize() throws ALException {
        try {
            if (!initialized) {
                Platform.initSingleton();
                if (null == ALImpl.getALProcAddressTable()) {
                    throw new ALException("AL not initialized (ProcAddressTable null)");
                }
                initialized = true;
                if (DEBUG) {
                    System.err.println("AL initialized");
                }
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new ALException(unsatisfiedLinkError);
        }
    }

    public static AL getAL() throws ALException {
        ALFactory.initialize();
        if (al == null) {
            al = new ALImpl();
        }
        return al;
    }

    public static ALC getALC() throws ALException {
        ALFactory.initialize();
        if (alc == null) {
            alc = new ALCImpl();
        }
        return alc;
    }
}

