/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.av;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import jogamp.opengl.egl.EGL;
import jogamp.opengl.egl.EGLContext;
import jogamp.opengl.egl.EGLDrawable;
import jogamp.opengl.egl.EGLExt;
import jogamp.opengl.util.av.GLMediaPlayerImpl;

public abstract class EGLMediaPlayerImpl
extends GLMediaPlayerImpl {
    protected final TextureType texType;
    protected final boolean useKHRSync;

    protected EGLMediaPlayerImpl() {
        this(TextureType.GL, false);
    }

    protected EGLMediaPlayerImpl(TextureType textureType, boolean bl) {
        this.texType = textureType;
        this.useKHRSync = bl;
    }

    @Override
    protected TextureSequence.TextureFrame createTexImage(GL gL, int n, int[] nArray) {
        long l;
        long l2;
        Buffer buffer;
        Object object;
        EGLDrawable eGLDrawable;
        EGLExt eGLExt;
        EGLContext eGLContext;
        boolean bl;
        Texture texture = super.createTexImageImpl(gL, n, nArray, this.width, this.height, false);
        boolean bl2 = bl = TextureType.KHRImage == this.texType || this.useKHRSync;
        if (bl) {
            eGLContext = (EGLContext)gL.getContext();
            eGLExt = eGLContext.getEGLExt();
            eGLDrawable = (EGLDrawable)eGLContext.getGLDrawable();
        } else {
            eGLContext = null;
            eGLExt = null;
            eGLDrawable = null;
        }
        if (TextureType.KHRImage == this.texType) {
            object = Buffers.newDirectIntBuffer((int)1);
            buffer = null;
            ((IntBuffer)object).put(0, 12344);
            l2 = eGLExt.eglCreateImageKHR(eGLDrawable.getDisplay(), eGLContext.getHandle(), 12465, buffer, (IntBuffer)object);
            if (0L == l2) {
                throw new RuntimeException("EGLImage creation failed: " + EGL.eglGetError() + ", ctx " + eGLContext + ", tex " + nArray[n] + ", err " + EGLMediaPlayerImpl.toHexString(EGL.eglGetError()));
            }
        } else {
            buffer = null;
            l2 = 0L;
        }
        if (this.useKHRSync) {
            object = new int[1];
            object[0] = 12344;
            l = eGLExt.eglCreateSyncKHR(eGLDrawable.getDisplay(), 12537, (int[])object, 0);
            if (0L == l) {
                throw new RuntimeException("EGLSync creation failed: " + EGL.eglGetError() + ", ctx " + eGLContext + ", err " + EGLMediaPlayerImpl.toHexString(EGL.eglGetError()));
            }
        } else {
            l = 0L;
        }
        return new EGLTextureFrame(buffer, texture, l2, l);
    }

    @Override
    protected void destroyTexImage(GL gL, TextureSequence.TextureFrame textureFrame) {
        EGLDrawable eGLDrawable;
        EGLExt eGLExt;
        boolean bl;
        boolean bl2 = bl = TextureType.KHRImage == this.texType || this.useKHRSync;
        if (bl) {
            EGLContext eGLContext = (EGLContext)gL.getContext();
            eGLExt = eGLContext.getEGLExt();
            eGLDrawable = (EGLDrawable)eGLContext.getGLDrawable();
        } else {
            Object var4_5 = null;
            eGLExt = null;
            eGLDrawable = null;
        }
        EGLTextureFrame eGLTextureFrame = (EGLTextureFrame)textureFrame;
        if (0L != eGLTextureFrame.getImage()) {
            eGLExt.eglDestroyImageKHR(eGLDrawable.getDisplay(), eGLTextureFrame.getImage());
        }
        if (0L != eGLTextureFrame.getSync()) {
            eGLExt.eglDestroySyncKHR(eGLDrawable.getDisplay(), eGLTextureFrame.getSync());
        }
        super.destroyTexImage(gL, textureFrame);
    }

    public static class EGLTextureFrame
    extends TextureSequence.TextureFrame {
        protected final Buffer clientBuffer;
        protected final long image;
        protected final long sync;

        public EGLTextureFrame(Buffer buffer, Texture texture, long l, long l2) {
            super(texture);
            this.clientBuffer = buffer;
            this.image = l;
            this.sync = l2;
        }

        public final Buffer getClientBuffer() {
            return this.clientBuffer;
        }

        public final long getImage() {
            return this.image;
        }

        public final long getSync() {
            return this.sync;
        }

        @Override
        public String toString() {
            return "EGLTextureFrame[" + this.texture + ", img " + this.image + ", sync " + this.sync + ", clientBuffer " + this.clientBuffer + "]";
        }
    }

    public static enum TextureType {
        GL(0),
        KHRImage(1);

        public final int id;

        private TextureType(int n2) {
            this.id = n2;
        }
    }
}

