/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.event;

import com.jogamp.newt.event.InputEvent;

public class MouseEvent
extends InputEvent {
    public static final int BUTTON1 = 1;
    public static final int BUTTON2 = 2;
    public static final int BUTTON3 = 3;
    public static final int BUTTON4 = 4;
    public static final int BUTTON5 = 5;
    public static final int BUTTON6 = 6;
    public static final int BUTTON_NUMBER = 6;
    private final int[] x;
    private final int[] y;
    private final int clickCount;
    private final int button;
    private final int wheelRotation;
    private final float[] pressure;
    private final int[] pointerids;
    public static final int EVENT_MOUSE_CLICKED = 200;
    public static final int EVENT_MOUSE_ENTERED = 201;
    public static final int EVENT_MOUSE_EXITED = 202;
    public static final int EVENT_MOUSE_PRESSED = 203;
    public static final int EVENT_MOUSE_RELEASED = 204;
    public static final int EVENT_MOUSE_MOVED = 205;
    public static final int EVENT_MOUSE_DRAGGED = 206;
    public static final int EVENT_MOUSE_WHEEL_MOVED = 207;

    public static final int getClickTimeout() {
        return 300;
    }

    public MouseEvent(int n, Object object, long l, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, object, l, n2);
        this.x = new int[]{n3};
        this.y = new int[]{n4};
        this.pressure = new float[]{0.0f};
        this.pointerids = new int[]{-1};
        this.clickCount = n5;
        this.button = n6;
        this.wheelRotation = n7;
    }

    public MouseEvent(int n, Object object, long l, int n2, int[] nArray, int[] nArray2, float[] fArray, int[] nArray3, int n3, int n4, int n5) {
        super(n, object, l, n2);
        this.x = nArray;
        this.y = nArray2;
        if (nArray3.length != fArray.length || nArray3.length != nArray.length || nArray3.length != nArray2.length) {
            throw new IllegalArgumentException("All multiple pointer arrays must be of same size");
        }
        this.pressure = fArray;
        this.pointerids = nArray3;
        this.clickCount = n3;
        this.button = n4;
        this.wheelRotation = n5;
    }

    public int getPointerCount() {
        return this.x.length;
    }

    public int getPointerId(int n) {
        if (n >= this.pointerids.length) {
            return -1;
        }
        return this.pointerids[n];
    }

    public int getButton() {
        return this.button;
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public int getX() {
        return this.x[0];
    }

    public int getY() {
        return this.y[0];
    }

    public int getX(int n) {
        return this.x[n];
    }

    public int getY(int n) {
        return this.y[n];
    }

    public float getPressure() {
        return this.pressure[0];
    }

    public float getPressure(int n) {
        return this.pressure[n];
    }

    public int getWheelRotation() {
        return this.wheelRotation;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MouseEvent[").append(MouseEvent.getEventTypeString(this.getEventType())).append(", ").append(this.x).append("/").append(this.y).append(", button ").append(this.button).append(", count ").append(this.clickCount).append(", wheel rotation ").append(this.wheelRotation);
        if (this.pointerids.length > 0) {
            stringBuilder.append(", pointer<").append(this.pointerids.length).append(">[");
            for (int i = 0; i < this.pointerids.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.pointerids[i]).append(": ").append(this.x[i]).append(" / ").append(this.y[i]).append(" ").append(this.pressure[i]).append("p");
            }
            stringBuilder.append("]");
        }
        stringBuilder.append(", ").append(super.toString()).append("]");
        return stringBuilder.toString();
    }

    public static String getEventTypeString(int n) {
        switch (n) {
            case 200: {
                return "EVENT_MOUSE_CLICKED";
            }
            case 201: {
                return "EVENT_MOUSE_ENTERED";
            }
            case 202: {
                return "EVENT_MOUSE_EXITED";
            }
            case 203: {
                return "EVENT_MOUSE_PRESSED";
            }
            case 204: {
                return "EVENT_MOUSE_RELEASED";
            }
            case 205: {
                return "EVENT_MOUSE_MOVED";
            }
            case 206: {
                return "EVENT_MOUSE_DRAGGED";
            }
            case 207: {
                return "EVENT_MOUSE_WHEEL_MOVED";
            }
        }
        return "unknown (" + n + ")";
    }
}

