/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.awt;

import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.nativewindow.awt.AWTGraphicsConfiguration;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.OffscreenLayerOption;
import javax.media.nativewindow.OffscreenLayerSurface;
import javax.media.nativewindow.SurfaceUpdatedListener;
import javax.media.nativewindow.util.InsetsImmutable;
import javax.media.nativewindow.util.Point;
import javax.media.nativewindow.util.Rectangle;
import javax.media.nativewindow.util.RectangleImmutable;
import jogamp.nativewindow.SurfaceUpdatedHelper;
import jogamp.nativewindow.jawt.JAWT;
import jogamp.nativewindow.jawt.JAWTUtil;
import jogamp.nativewindow.jawt.JAWT_Rectangle;

public abstract class JAWTWindow
implements NativeWindow,
OffscreenLayerSurface,
OffscreenLayerOption {
    protected static final boolean DEBUG = JAWTUtil.DEBUG;
    protected boolean shallUseOffscreenLayer = false;
    protected Component component;
    private AWTGraphicsConfiguration config;
    private SurfaceUpdatedHelper surfaceUpdatedHelper = new SurfaceUpdatedHelper();
    private RecursiveLock surfaceLock = LockFactory.createRecursiveLock();
    private boolean isApplet;
    private JAWT jawt;
    private boolean isOffscreenLayerSurface;
    protected long drawable;
    protected Rectangle bounds;
    protected javax.media.nativewindow.util.Insets insets;
    private long drawable_old;

    protected JAWTWindow(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        if (abstractGraphicsConfiguration == null) {
            throw new NativeWindowException("Error: AbstractGraphicsConfiguration is null");
        }
        if (!(abstractGraphicsConfiguration instanceof AWTGraphicsConfiguration)) {
            throw new NativeWindowException("Error: AbstractGraphicsConfiguration is not an AWTGraphicsConfiguration: " + abstractGraphicsConfiguration);
        }
        this.config = (AWTGraphicsConfiguration)abstractGraphicsConfiguration;
        this.init((Component)object);
    }

    private void init(Component component) throws NativeWindowException {
        this.invalidate();
        this.component = component;
        this.isApplet = false;
    }

    @Override
    public void setShallUseOffscreenLayer(boolean bl) {
        this.shallUseOffscreenLayer = bl;
    }

    @Override
    public final boolean getShallUseOffscreenLayer() {
        return this.shallUseOffscreenLayer;
    }

    @Override
    public final boolean isOffscreenLayerSurfaceEnabled() {
        return this.isOffscreenLayerSurface;
    }

    protected synchronized void invalidate() {
        this.invalidateNative();
        this.jawt = null;
        this.isOffscreenLayerSurface = false;
        this.drawable = 0L;
        this.drawable_old = 0L;
        this.bounds = new Rectangle();
        this.insets = new javax.media.nativewindow.util.Insets();
    }

    protected abstract void invalidateNative();

    protected final void updateBounds(JAWT_Rectangle jAWT_Rectangle) {
        this.bounds.setX(jAWT_Rectangle.getX());
        this.bounds.setY(jAWT_Rectangle.getY());
        this.bounds.setWidth(jAWT_Rectangle.getWidth());
        this.bounds.setHeight(jAWT_Rectangle.getHeight());
        if (this.component instanceof Container) {
            Insets insets = ((Container)this.component).getInsets();
            this.insets.setLeftWidth(insets.left);
            this.insets.setRightWidth(insets.right);
            this.insets.setTopHeight(insets.top);
            this.insets.setBottomHeight(insets.bottom);
        }
    }

    public final RectangleImmutable getBounds() {
        return this.bounds;
    }

    @Override
    public final InsetsImmutable getInsets() {
        return this.insets;
    }

    public final Component getAWTComponent() {
        return this.component;
    }

    public final boolean isApplet() {
        return this.isApplet;
    }

    public final JAWT getJAWT() {
        return this.jawt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void attachSurfaceLayer(long l) throws NativeWindowException {
        if (!this.isOffscreenLayerSurfaceEnabled()) {
            throw new NativeWindowException("Not an offscreen layer surface");
        }
        int n = this.lockSurface();
        if (1 >= n) {
            throw new NativeWindowException("Could not lock (offscreen layer): " + this);
        }
        try {
            if (DEBUG) {
                System.err.println("JAWTWindow.attachSurfaceHandle(): 0x" + Long.toHexString(l));
            }
            this.attachSurfaceLayerImpl(l);
        }
        finally {
            this.unlockSurface();
        }
    }

    protected abstract void attachSurfaceLayerImpl(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void detachSurfaceLayer(long l) throws NativeWindowException {
        if (!this.isOffscreenLayerSurfaceEnabled()) {
            throw new UnsupportedOperationException("Not an offscreen layer surface");
        }
        int n = this.lockSurface();
        if (1 >= n) {
            throw new NativeWindowException("Could not lock (offscreen layer): " + this);
        }
        try {
            if (DEBUG) {
                System.err.println("JAWTWindow.detachSurfaceHandle(): 0x" + Long.toHexString(l));
            }
            this.detachSurfaceLayerImpl(l);
        }
        finally {
            this.unlockSurface();
        }
    }

    protected abstract void detachSurfaceLayerImpl(long var1);

    @Override
    public void addSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.surfaceUpdatedHelper.addSurfaceUpdatedListener(surfaceUpdatedListener);
    }

    @Override
    public void addSurfaceUpdatedListener(int n, SurfaceUpdatedListener surfaceUpdatedListener) throws IndexOutOfBoundsException {
        this.surfaceUpdatedHelper.addSurfaceUpdatedListener(n, surfaceUpdatedListener);
    }

    @Override
    public void removeSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.surfaceUpdatedHelper.removeSurfaceUpdatedListener(surfaceUpdatedListener);
    }

    @Override
    public void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
        this.surfaceUpdatedHelper.surfaceUpdated(object, nativeSurface, l);
    }

    private void determineIfApplet() {
        for (Component component = this.component; !this.isApplet && null != component; component = component.getParent()) {
            this.isApplet = component instanceof Applet;
        }
    }

    protected abstract JAWT fetchJAWTImpl() throws NativeWindowException;

    protected abstract int lockSurfaceImpl() throws NativeWindowException;

    protected void dumpJAWTInfo() {
        if (null != this.jawt) {
            System.err.println("JAWT version: 0x" + Integer.toHexString(this.jawt.getCachedVersion()) + ", CA_LAYER: " + JAWTUtil.isJAWTUsingOffscreenLayer(this.jawt) + ", isLayeredSurface " + this.isOffscreenLayerSurfaceEnabled() + ", bounds " + this.bounds + ", insets " + this.insets);
        } else {
            System.err.println("JAWT n/a, bounds " + this.bounds + ", insets " + this.insets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int lockSurface() throws NativeWindowException {
        int n;
        this.surfaceLock.lock();
        int n2 = n = this.surfaceLock.getHoldCount() == 1 ? 1 : 3;
        if (1 == n) {
            this.determineIfApplet();
            try {
                AbstractGraphicsDevice abstractGraphicsDevice = this.getGraphicsConfiguration().getScreen().getDevice();
                abstractGraphicsDevice.lock();
                try {
                    this.jawt = this.fetchJAWTImpl();
                    this.isOffscreenLayerSurface = JAWTUtil.isJAWTUsingOffscreenLayer(this.jawt);
                    n = this.lockSurfaceImpl();
                    if (3 == n && this.drawable_old != this.drawable) {
                        n = 2;
                        if (DEBUG) {
                            System.err.println("JAWTWindow: surface change 0x" + Long.toHexString(this.drawable_old) + " -> 0x" + Long.toHexString(this.drawable));
                        }
                    }
                }
                finally {
                    if (1 >= n) {
                        abstractGraphicsDevice.unlock();
                    }
                }
            }
            finally {
                if (1 >= n) {
                    this.surfaceLock.unlock();
                }
            }
        }
        return n;
    }

    protected abstract void unlockSurfaceImpl() throws NativeWindowException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unlockSurface() {
        this.surfaceLock.validateLocked();
        this.drawable_old = this.drawable;
        if (this.surfaceLock.getHoldCount() == 1) {
            AbstractGraphicsDevice abstractGraphicsDevice = this.getGraphicsConfiguration().getScreen().getDevice();
            try {
                this.unlockSurfaceImpl();
            }
            finally {
                abstractGraphicsDevice.unlock();
            }
        }
        this.surfaceLock.unlock();
    }

    @Override
    public final boolean isSurfaceLockedByOtherThread() {
        return this.surfaceLock.isLockedByOtherThread();
    }

    @Override
    public final boolean isSurfaceLocked() {
        return this.surfaceLock.isLocked();
    }

    @Override
    public final Thread getSurfaceLockOwner() {
        return this.surfaceLock.getOwner();
    }

    @Override
    public boolean surfaceSwap() {
        return false;
    }

    @Override
    public long getSurfaceHandle() {
        return this.drawable;
    }

    public final AWTGraphicsConfiguration getPrivateGraphicsConfiguration() {
        return this.config;
    }

    @Override
    public final AbstractGraphicsConfiguration getGraphicsConfiguration() {
        return this.config.getNativeGraphicsConfiguration();
    }

    @Override
    public final long getDisplayHandle() {
        return this.getGraphicsConfiguration().getScreen().getDevice().getHandle();
    }

    @Override
    public final int getScreenIndex() {
        return this.getGraphicsConfiguration().getScreen().getIndex();
    }

    @Override
    public int getWidth() {
        return this.component.getWidth();
    }

    @Override
    public int getHeight() {
        return this.component.getHeight();
    }

    @Override
    public synchronized void destroy() {
        this.invalidate();
        this.component = null;
    }

    @Override
    public final NativeWindow getParent() {
        return null;
    }

    @Override
    public long getWindowHandle() {
        return this.drawable;
    }

    @Override
    public final int getX() {
        return this.component.getX();
    }

    @Override
    public final int getY() {
        return this.component.getY();
    }

    @Override
    public Point getLocationOnScreen(Point point) {
        Point point2 = this.getLocationOnScreenNative(point);
        if (null == point2) {
            if (!Thread.holdsLock(this.component.getTreeLock())) {
                if (DEBUG) {
                    System.err.println("Warning: JAWT Lock hold, but not the AWT tree lock: " + this);
                    Thread.dumpStack();
                }
                return JAWTWindow.getLocationOnScreenNonBlocking(point, this.component);
            }
            java.awt.Point point3 = this.component.getLocationOnScreen();
            point2 = null != point ? point.translate(point3.x, point3.y) : new Point(point3.x, point3.y);
        }
        return point2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Point getLocationOnScreenNative(Point point) {
        int n = this.lockSurface();
        if (1 == n) {
            if (DEBUG) {
                System.err.println("Warning: JAWT Lock couldn't be acquired: " + this);
                Thread.dumpStack();
            }
            return null;
        }
        try {
            Point point2 = this.getLocationOnScreenNativeImpl(0, 0);
            if (null != point2 && null != point) {
                point.translate(point2.getX(), point2.getY());
                Point point3 = point;
                return point3;
            }
            Point point4 = point2;
            return point4;
        }
        finally {
            this.unlockSurface();
        }
    }

    protected abstract Point getLocationOnScreenNativeImpl(int var1, int var2);

    protected static Point getLocationOnScreenNonBlocking(Point point, Component component) {
        int n = 0;
        int n2 = 0;
        while (null != component) {
            n += component.getX();
            n2 += component.getY();
            component = component.getParent();
        }
        if (null != point) {
            point.translate(n, n2);
            return point;
        }
        return new Point(n, n2);
    }

    @Override
    public boolean hasFocus() {
        return this.component.hasFocus();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("JAWT-Window[windowHandle 0x" + Long.toHexString(this.getWindowHandle()) + ", surfaceHandle 0x" + Long.toHexString(this.getSurfaceHandle()) + ", bounds " + this.bounds + ", insets " + this.insets + ", shallUseOffscreenLayer " + this.shallUseOffscreenLayer + ", isOffscreenLayerSurface " + this.isOffscreenLayerSurface);
        if (null != this.component) {
            stringBuilder.append(", pos " + this.getX() + "/" + this.getY() + ", size " + this.getWidth() + "x" + this.getHeight() + ", visible " + this.component.isVisible());
        } else {
            stringBuilder.append(", component NULL");
        }
        stringBuilder.append(", lockedExt " + this.isSurfaceLockedByOtherThread() + ",\n\tconfig " + this.getPrivateGraphicsConfiguration() + ",\n\tawtComponent " + this.getAWTComponent() + ",\n\tsurfaceLock " + this.surfaceLock + "]");
        return stringBuilder.toString();
    }
}

