/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.terra.area.movables;

import com.js.test.terra.area.chunks.BigChunkDataGrid;
import com.js.test.terra.area.movables.Movable;
import com.js.test.terra.math.Vector3;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class MovableHandler {
    private static MovableHandler myInstance;
    private List<Movable> myMovables = new ArrayList<Movable>();
    private List<Movable> myNewList = new ArrayList<Movable>();

    private MovableHandler() {
    }

    public static MovableHandler getInstance() {
        if (myInstance == null) {
            myInstance = new MovableHandler();
            return myInstance;
        }
        return myInstance;
    }

    public List<Movable> getMyMovables() {
        return this.myMovables;
    }

    public void setMyMovables(List<Movable> myMovables) {
        this.myMovables = myMovables;
    }

    public void addMovable(Movable theMovableToAdd) {
        this.myNewList.add(theMovableToAdd);
    }

    public void doTicks(float amount, BigChunkDataGrid theGrid, GL2 theGl, GLU theGlu) {
        this.myMovables.addAll(this.myNewList);
        this.myNewList.clear();
        Iterator<Movable> myIterator = this.myMovables.iterator();
        while (myIterator.hasNext()) {
            int aZToDo;
            int aYToDo;
            int aXToDo;
            Vector3 hit;
            Movable aMovable = myIterator.next();
            aMovable.currentTicks += amount;
            if (aMovable.currentTicks > aMovable.maxTicks) {
                aMovable.die(theGrid, theGl, theGlu);
                myIterator.remove();
                continue;
            }
            Vector3 aMoveVector = new Vector3(aMovable.direction.x * (double)amount, aMovable.direction.y * (double)amount, aMovable.direction.z * (double)amount);
            if (aMovable.checkIntersect && (hit = theGrid.intersectRay((float)aMovable.position.x, (float)aMovable.position.y, (float)aMovable.position.z, (float)aMoveVector.x, (float)aMoveVector.y, (float)aMoveVector.z, (float)aMoveVector.length())) != null && aMovable.doIntersect(theGrid, aXToDo = (int)Math.round(hit.x), aYToDo = (int)Math.round(hit.y), aZToDo = (int)Math.round(hit.z), theGl, theGlu)) {
                aMovable.die(theGrid, theGl, theGlu);
                myIterator.remove();
            }
            aMovable.position.x += aMoveVector.x;
            aMovable.position.y += aMoveVector.y;
            aMovable.position.z += aMoveVector.z;
        }
    }
}

