/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.terra.area.movables;

import com.js.test.engine.camera.Camera;
import com.js.test.engine.material.TextureHandler;
import com.js.test.terra.area.blocks.Block;
import com.js.test.terra.area.blocks.BlockLoader;
import com.js.test.terra.area.chunks.BigChunkDataGrid;
import com.js.test.terra.area.movables.Movable;
import com.js.test.terra.math.Vector3;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class LightMovable
extends Movable {
    private int destruction = 0;

    public LightMovable(Vector3 position, Vector3 direction, float currentTicks, float maxTicks, boolean checkIntersect, int textureId) {
        super(position, direction, currentTicks, maxTicks, checkIntersect, textureId);
    }

    @Override
    public boolean doIntersect(BigChunkDataGrid theGrid, int x, int y, int z, GL2 theGl, GLU theGlu) {
        int blockAt = theGrid.getBlockAt(x, y, z);
        Block aBlockToSet = BlockLoader.getInstance().getMyBlocksAsArray()[this.textureId];
        theGrid.removeBlockWithUpdates(x, y, z, theGl, theGlu, true, true);
        theGrid.addBlockWithUpdates(x, y, z, aBlockToSet, theGl, theGlu, 0);
        return true;
    }

    @Override
    public void render(GL2 theGl, GLU theGlu, Camera camera) {
        theGl.glPushMatrix();
        theGl.glDepthMask(false);
        theGl.glDisable(2884);
        theGl.glTranslatef((float)this.position.x, (float)this.position.y, (float)this.position.z);
        theGl.glRotatef((float)(-camera.getRotX()), 0.0f, 1.0f, 0.0f);
        theGl.glRotatef((float)camera.getRotY(), 1.0f, 0.0f, 0.0f);
        theGl.glRotatef(this.currentTicks * 60.0f, 0.0f, 0.0f, 1.0f);
        TextureHandler.getInstance().bindTextureSaturated("green", theGl);
        theGl.glBegin(7);
        theGl.glTexCoord2f(0.0f, 1.0f);
        theGl.glVertex3f(-0.5f, 0.5f, 0.0f);
        theGl.glTexCoord2f(1.0f, 1.0f);
        theGl.glVertex3f(0.5f, 0.5f, 0.0f);
        theGl.glTexCoord2f(1.0f, 0.0f);
        theGl.glVertex3f(0.5f, -0.5f, 0.0f);
        theGl.glTexCoord2f(0.0f, 0.0f);
        theGl.glVertex3f(-0.5f, -0.5f, 0.0f);
        theGl.glEnd();
        TextureHandler.getInstance().unbindTextureSaturated(theGl);
        theGl.glDepthMask(true);
        theGl.glEnable(2884);
        theGl.glPopMatrix();
    }
}

