/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.terra.area.movables;

import com.js.test.engine.camera.Camera;
import com.js.test.engine.material.TextureHandler;
import com.js.test.terra.area.chunks.BigChunkDataGrid;
import com.js.test.terra.area.movables.Movable;
import com.js.test.terra.math.Vector3;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class LaserMovable
extends Movable {
    private float length;
    private Vector3 rotVector;

    public LaserMovable(Vector3 position, float length, Vector3 rotVector, float currentTicks, float maxTicks, boolean checkIntersect, int textureId) {
        super(position, new Vector3(0.0, 0.0, 0.0), currentTicks, maxTicks, false, textureId);
        this.length = length;
        this.rotVector = rotVector;
    }

    @Override
    public boolean doIntersect(BigChunkDataGrid theGrid, int x, int y, int z, GL2 theGl, GLU theGlu) {
        return true;
    }

    @Override
    public void render(GL2 theGl, GLU theGlu, Camera camera) {
        theGl.glPushMatrix();
        theGl.glDepthMask(false);
        theGl.glDisable(2884);
        theGl.glTranslatef((float)this.position.x, (float)this.position.y, (float)this.position.z);
        theGl.glRotatef((float)(-this.rotVector.x), 0.0f, 1.0f, 0.0f);
        theGl.glRotatef((float)this.rotVector.y, 1.0f, 0.0f, 0.0f);
        theGl.glRotatef(this.currentTicks * 60.0f, 0.0f, 0.0f, 1.0f);
        TextureHandler.getInstance().bindTextureSaturated("laser", theGl);
        float l2 = this.length / 2.0f;
        theGl.glBegin(7);
        theGl.glTexCoord2f(0.0f, 1.0f);
        theGl.glVertex3f(0.0f, 0.1f, -l2);
        theGl.glTexCoord2f(1.0f, 1.0f);
        theGl.glVertex3f(0.0f, 0.1f, l2);
        theGl.glTexCoord2f(1.0f, 0.0f);
        theGl.glVertex3f(0.0f, -0.1f, l2);
        theGl.glTexCoord2f(0.0f, 0.0f);
        theGl.glVertex3f(-0.0f, -0.1f, -l2);
        theGl.glTexCoord2f(0.0f, 0.0f);
        theGl.glVertex3f(-0.0f, -0.1f, -l2);
        theGl.glTexCoord2f(1.0f, 0.0f);
        theGl.glVertex3f(0.0f, -0.1f, l2);
        theGl.glTexCoord2f(1.0f, 1.0f);
        theGl.glVertex3f(0.0f, 0.1f, l2);
        theGl.glTexCoord2f(0.0f, 1.0f);
        theGl.glVertex3f(0.0f, 0.1f, -l2);
        theGl.glTexCoord2f(0.0f, 1.0f);
        theGl.glVertex3f(0.1f, 0.0f, -l2);
        theGl.glTexCoord2f(1.0f, 1.0f);
        theGl.glVertex3f(0.1f, 0.0f, l2);
        theGl.glTexCoord2f(1.0f, 0.0f);
        theGl.glVertex3f(-0.1f, -0.0f, l2);
        theGl.glTexCoord2f(0.0f, 0.0f);
        theGl.glVertex3f(-0.1f, -0.0f, -l2);
        theGl.glTexCoord2f(0.0f, 0.0f);
        theGl.glVertex3f(-0.1f, -0.0f, -l2);
        theGl.glTexCoord2f(1.0f, 0.0f);
        theGl.glVertex3f(-0.1f, -0.0f, l2);
        theGl.glTexCoord2f(1.0f, 1.0f);
        theGl.glVertex3f(0.1f, 0.0f, l2);
        theGl.glTexCoord2f(0.0f, 1.0f);
        theGl.glVertex3f(0.1f, 0.0f, -l2);
        theGl.glEnd();
        TextureHandler.getInstance().unbindTextureSaturated(theGl);
        theGl.glDepthMask(true);
        theGl.glEnable(2884);
        theGl.glPopMatrix();
    }
}

