/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.terra.area.movables;

import com.js.test.engine.camera.Camera;
import com.js.test.engine.material.TextureHandler;
import com.js.test.terra.area.animatedgenerator.AnimatedGeneratorHandler;
import com.js.test.terra.area.animatedgenerator.GrowAnimatedGenerator;
import com.js.test.terra.area.chunks.BigChunkDataGrid;
import com.js.test.terra.area.movables.Movable;
import com.js.test.terra.math.Vector3;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class GrowMovable
extends Movable {
    private int blockId = 0;

    public GrowMovable(Vector3 position, Vector3 direction, float currentTicks, float maxTicks, boolean checkIntersect, int textureId, int blockId) {
        super(position, direction, currentTicks, maxTicks, checkIntersect, textureId);
        this.blockId = blockId;
    }

    @Override
    public boolean doIntersect(BigChunkDataGrid theGrid, int x, int y, int z, GL2 theGl, GLU theGlu) {
        GrowAnimatedGenerator aNewBlock = new GrowAnimatedGenerator(16, 16, 16, x, y, z, this.blockId, theGrid, theGl);
        if (!aNewBlock.isInvalid()) {
            AnimatedGeneratorHandler.getInstance().getAnimatedGenerators().add(aNewBlock);
        }
        return true;
    }

    @Override
    public void render(GL2 theGl, GLU theGlu, Camera camera) {
        theGl.glPushMatrix();
        theGl.glDepthMask(false);
        theGl.glDisable(2884);
        theGl.glTranslatef((float)this.position.x, (float)this.position.y, (float)this.position.z);
        theGl.glRotatef((float)(-camera.getRotX()), 0.0f, 1.0f, 0.0f);
        theGl.glRotatef((float)camera.getRotY(), 1.0f, 0.0f, 0.0f);
        TextureHandler.getInstance().bindTextureSaturated("elevator", theGl);
        theGl.glBegin(7);
        theGl.glTexCoord2f(0.0f, 1.0f);
        theGl.glVertex3f(-0.5f, 0.5f, 0.0f);
        theGl.glTexCoord2f(1.0f, 1.0f);
        theGl.glVertex3f(0.5f, 0.5f, 0.0f);
        theGl.glTexCoord2f(1.0f, 0.0f);
        theGl.glVertex3f(0.5f, -0.5f, 0.0f);
        theGl.glTexCoord2f(0.0f, 0.0f);
        theGl.glVertex3f(-0.5f, -0.5f, 0.0f);
        theGl.glEnd();
        TextureHandler.getInstance().unbindTextureSaturated(theGl);
        theGl.glDepthMask(true);
        theGl.glEnable(2884);
        theGl.glPopMatrix();
    }
}

