/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.engine.material;

import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureIO;
import com.js.test.terra.area.blocks.Block;
import com.js.test.terra.area.blocks.BlockLoader;
import com.js.test.terra.area.item.BaseItem;
import com.js.test.terra.area.item.BaseItemLoader;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLException;
import javax.media.opengl.glu.GLU;

public class TextureHandler {
    private static TextureHandler myInstance;
    private Map<String, Texture> myTextures = new HashMap<String, Texture>();
    private int[][] myBlockTextures;
    private int[][] myAnimatedBlockTextures;
    private int[] myItemTextures;

    private TextureHandler() {
        try {
            this.myTextures.put("skysphere", TextureIO.newTexture((File)new File("assets/skybox/stars2.png"), (boolean)true));
            this.myTextures.put("plasma", TextureIO.newTexture((File)new File("assets/particles/plasma.png"), (boolean)true));
            this.myTextures.put("laser", TextureIO.newTexture((File)new File("assets/particles/laser.png"), (boolean)true));
            this.myTextures.put("green", TextureIO.newTexture((File)new File("assets/particles/green.png"), (boolean)true));
            this.myTextures.put("elevator", TextureIO.newTexture((File)new File("assets/particles/elevator.png"), (boolean)true));
            this.myTextures.put("explosion", TextureIO.newTexture((File)new File("assets/particles/explosion_donut.png"), (boolean)true));
            this.myTextures.put("cloud", TextureIO.newTexture((File)new File("assets/particles/explosion_cloud.png"), (boolean)true));
            this.myTextures.put("sucker", TextureIO.newTexture((File)new File("assets/particles/explosion.png"), (boolean)true));
            this.myTextures.put("ui_box", TextureIO.newTexture((File)new File("assets/ui/box.png"), (boolean)true));
            this.myTextures.put("ui_selector", TextureIO.newTexture((File)new File("assets/ui/gui_select_goldcursor.png"), (boolean)true));
            this.myTextures.put("ui_selector_2", TextureIO.newTexture((File)new File("assets/ui/gui_select_whitecursor.png"), (boolean)true));
            this.myTextures.put("ui_checked", TextureIO.newTexture((File)new File("assets/ui/gui_checked.png"), (boolean)true));
            this.myTextures.put("ui_unchecked", TextureIO.newTexture((File)new File("assets/ui/gui_unchecked.png"), (boolean)true));
        }
        catch (GLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readTerrainTexturesFromProperties(GL2 theGl, GLU theGlu) {
        try {
            this.myBlockTextures = new int[BlockLoader.getInstance().getMyAmountOfBlocks()][];
            int count = 0;
            Block[] blockArray = BlockLoader.getInstance().getMyBlocksAsArray();
            int n = blockArray.length;
            int n2 = 0;
            while (n2 < n) {
                Block aBlock = blockArray[n2];
                if (!aBlock.isAnimated()) {
                    BufferedImage anImage = ImageIO.read(new File(aBlock.getMyResource()));
                    BlockTexture aTextureData = this.readPixels(anImage, true);
                    this.myBlockTextures[count] = new int[1];
                    theGl.glGenTextures(1, this.myBlockTextures[count], 0);
                    theGl.glBindTexture(3553, this.myBlockTextures[count][0]);
                    theGl.glTexEnvf(8960, 8704, 8448.0f);
                    theGl.glTexParameterf(3553, 10241, 9984.0f);
                    theGl.glTexParameterf(3553, 10240, 9728.0f);
                    theGl.glTexParameterf(3553, 10242, 10496.0f);
                    theGl.glTexParameterf(3553, 10243, 10496.0f);
                    theGl.glTexParameterf(3553, 34046, 8.0f);
                    theGlu.gluBuild2DMipmaps(3553, 32856, aTextureData.width, aTextureData.height, 6408, 5121, (Buffer)aTextureData.getPixels());
                    ++count;
                } else {
                    String[] imagesToLoad = aBlock.getMyResource().split(";");
                    this.myBlockTextures[count] = new int[imagesToLoad.length];
                    int i = 0;
                    while (i < imagesToLoad.length) {
                        BufferedImage anImage = ImageIO.read(new File(imagesToLoad[i]));
                        BlockTexture aTextureData = this.readPixels(anImage, true);
                        theGl.glGenTextures(1, this.myBlockTextures[count], i);
                        theGl.glBindTexture(3553, this.myBlockTextures[count][i]);
                        theGl.glTexEnvf(8960, 8704, 8448.0f);
                        theGl.glTexParameterf(3553, 10241, 9984.0f);
                        theGl.glTexParameterf(3553, 10240, 9728.0f);
                        theGl.glTexParameterf(3553, 10242, 10496.0f);
                        theGl.glTexParameterf(3553, 10243, 10496.0f);
                        theGl.glTexParameterf(3553, 34046, 8.0f);
                        theGlu.gluBuild2DMipmaps(3553, 32856, aTextureData.width, aTextureData.height, 6408, 5121, (Buffer)aTextureData.getPixels());
                        ++i;
                    }
                    ++count;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void readItemTexturesFromProperties(GL2 theGl, GLU theGlu) {
        try {
            this.myItemTextures = new int[BaseItemLoader.getInstance().getMyAmountOfItems()];
            theGl.glGenTextures(this.myItemTextures.length, this.myItemTextures, 0);
            int count = 0;
            for (BaseItem anItem : BaseItemLoader.getInstance().getMyItems()) {
                if (!"null".equals(anItem.getMyAsset())) {
                    BufferedImage anImage = ImageIO.read(new File(anItem.getMyAsset()));
                    BlockTexture aTextureData = this.readPixels(anImage, true);
                    theGl.glBindTexture(3553, this.myItemTextures[count]);
                    theGl.glTexEnvf(8960, 8704, 8448.0f);
                    theGl.glTexParameterf(3553, 10241, 9984.0f);
                    theGl.glTexParameterf(3553, 10240, 9728.0f);
                    theGl.glTexParameterf(3553, 10242, 10496.0f);
                    theGl.glTexParameterf(3553, 10243, 10496.0f);
                    theGl.glTexParameterf(3553, 34046, 8.0f);
                    theGlu.gluBuild2DMipmaps(3553, 32856, aTextureData.width, aTextureData.height, 6408, 5121, (Buffer)aTextureData.getPixels());
                }
                ++count;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void readTerrainTextures(GL2 theGl, GLU theGlu) {
        File aTextureFile = new File("assets/images/terrain.png");
    }

    private BlockTexture readPixels(BufferedImage img, boolean storeAlphaChannel) {
        int[] packedPixels = new int[img.getWidth() * img.getHeight()];
        PixelGrabber pixelgrabber = new PixelGrabber(img, 0, 0, img.getWidth(), img.getHeight(), packedPixels, 0, img.getWidth());
        try {
            pixelgrabber.grabPixels();
        }
        catch (InterruptedException e) {
            throw new RuntimeException();
        }
        int bytesPerPixel = storeAlphaChannel ? 4 : 3;
        ByteBuffer unpackedPixels = ByteBuffer.allocate(packedPixels.length * bytesPerPixel);
        int row = img.getHeight() - 1;
        while (row >= 0) {
            int col = 0;
            while (col < img.getWidth()) {
                int packedPixel = packedPixels[row * img.getWidth() + col];
                unpackedPixels.put((byte)(packedPixel >> 16 & 0xFF));
                unpackedPixels.put((byte)(packedPixel >> 8 & 0xFF));
                unpackedPixels.put((byte)(packedPixel >> 0 & 0xFF));
                if (storeAlphaChannel) {
                    unpackedPixels.put((byte)(packedPixel >> 24 & 0xFF));
                }
                ++col;
            }
            --row;
        }
        unpackedPixels.flip();
        return new BlockTexture(unpackedPixels, img.getWidth(), img.getHeight());
    }

    public void setupTextureDefaultValues(GL2 theGl) {
        for (String aTextureKey : this.myTextures.keySet()) {
            Texture aTexture = this.myTextures.get(aTextureKey);
            aTexture.enable((GL)theGl);
            aTexture.bind((GL)theGl);
            aTexture.setTexParameteri((GL)theGl, 10241, 9984);
            aTexture.setTexParameteri((GL)theGl, 10240, 9728);
            aTexture.setTexParameteri((GL)theGl, 10242, 10497);
            aTexture.setTexParameteri((GL)theGl, 10243, 10497);
            aTexture.setTexParameterf((GL)theGl, 34046, 8.0f);
            aTexture.disable((GL)theGl);
        }
    }

    public static synchronized TextureHandler getInstance() {
        if (myInstance == null) {
            myInstance = new TextureHandler();
            return myInstance;
        }
        return myInstance;
    }

    public Texture getTexture(String theAssetName) {
        return this.myTextures.get(theAssetName);
    }

    public void bindTextureAsTransparent(String theAssetName, GL2 theGl) {
        Texture aTexture = this.getTexture(theAssetName);
        theGl.glEnable(3042);
        theGl.glBlendFunc(1, 771);
        theGl.glTexEnvf(8960, 8704, 8448.0f);
        aTexture.enable((GL)theGl);
        aTexture.bind((GL)theGl);
    }

    public void unbindTextureAsTransparent(String theAssetName, GL2 theGl) {
        Texture aTexture = this.getTexture(theAssetName);
        aTexture.disable((GL)theGl);
        theGl.glDisable(3042);
    }

    public void bindTextureWithClamp(String theAssetName, GL2 theGl) {
        Texture aTexture = this.getTexture(theAssetName);
        aTexture.setTexParameteri(theGl.getGL(), 10242, 33071);
        aTexture.setTexParameteri(theGl.getGL(), 10243, 33071);
        aTexture.setTexParameteri((GL)theGl, 10241, 9729);
        aTexture.setTexParameteri((GL)theGl, 10240, 9729);
        theGl.glTexEnvf(8960, 8704, 8448.0f);
        aTexture.enable((GL)theGl);
        aTexture.bind((GL)theGl);
    }

    public void unbindTextureWithClamp(String theAssetName, GL2 theGl) {
        Texture aTexture = this.getTexture(theAssetName);
        aTexture.disable((GL)theGl);
    }

    public void bindBlockTexture(int theBlockId, GL2 theGl, int animationStep) {
        theGl.glEnable(3553);
        theGl.glBindTexture(3553, this.myBlockTextures[theBlockId][animationStep % this.myBlockTextures[theBlockId].length]);
    }

    public void bindTextureSaturated(String theAssetName, GL2 theGl) {
        Texture aTexture = this.getTexture(theAssetName);
        theGl.glEnable(3042);
        theGl.glBlendFunc(1, 1);
        theGl.glTexEnvf(8960, 8704, 8448.0f);
        aTexture.bind((GL)theGl);
    }

    public void unbindTextureSaturated(GL2 theGl) {
        theGl.glDisable(3042);
    }

    public void bindItemTexture(int theItemId, GL2 theGl) {
        theGl.glEnable(3553);
        theGl.glBindTexture(3553, this.myItemTextures[theItemId]);
        theGl.glEnable(3042);
        theGl.glBlendFunc(770, 771);
        theGl.glTexEnvf(8960, 8704, 8448.0f);
    }

    public void unbindItemTexture(int theItemId, GL2 theGl) {
        theGl.glDisable(3042);
    }

    public void bindBlockTextureAsTransparent(int theBlockId, GL2 theGl, int animationStep) {
        theGl.glEnable(3042);
        theGl.glBlendFunc(1, 771);
        theGl.glTexEnvf(8960, 8704, 7681.0f);
        theGl.glEnable(3553);
        theGl.glBindTexture(3553, this.myBlockTextures[theBlockId][animationStep % this.myBlockTextures[theBlockId].length]);
    }

    public void unbindBlockTextureAsTransparent(int theBlockId, GL2 theGl) {
        theGl.glDisable(3042);
    }

    public static class BlockTexture {
        private ByteBuffer pixels;
        private int width;
        private int height;

        public BlockTexture(ByteBuffer pixels, int width, int height) {
            this.height = height;
            this.pixels = pixels;
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public ByteBuffer getPixels() {
            return this.pixels;
        }

        public int getWidth() {
            return this.width;
        }
    }
}

