/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.engine.input;

import com.js.test.Game;
import com.js.test.engine.input.Controls;
import com.js.test.engine.player.Player;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Event;
import net.java.games.input.EventQueue;

public class InputThread
extends Thread {
    private Game myGame;
    private Controls myMovement;
    private Player myPlayer;

    public InputThread(Game theGame, Controls theMovement, Player thePlayer) {
        this.myGame = theGame;
        this.myMovement = theMovement;
        this.myPlayer = thePlayer;
    }

    @Override
    public void run() {
        while (true) {
            Controller[] controllers;
            if ((controllers = ControllerEnvironment.getDefaultEnvironment().getControllers()).length == 0) {
                System.out.println("Found no controllers.");
                System.exit(0);
            }
            int i = 0;
            while (i < controllers.length) {
                controllers[i].poll();
                EventQueue queue = controllers[i].getEventQueue();
                Event event = new Event();
                while (queue.getNextEvent(event)) {
                    Component comp;
                    Controller aController = controllers[i];
                    if (aController.getType() == Controller.Type.MOUSE) {
                        comp = event.getComponent();
                        float value = event.getValue();
                        if (!this.myPlayer.isInInventory() && !this.myPlayer.isInMenu()) {
                            if (comp.getName().equals("x")) {
                                this.myGame.previousX += (double)(value / 20.0f);
                            }
                            if (comp.getName().equals("y")) {
                                this.myGame.previousY += (double)(value / 20.0f);
                            }
                        }
                        if (comp.getName().equals("Left")) {
                            this.myMovement.doPressLeft = event.getValue() > 0.0f;
                        }
                        if (comp.getName().equals("Right")) {
                            this.myMovement.doPressRight = event.getValue() > 0.0f;
                        }
                        if (comp.getName().equals("z")) {
                            this.myMovement.chosenZ = (int)((float)this.myMovement.chosenZ + value);
                            if (this.myMovement.chosenZ > 128) {
                                this.myMovement.chosenZ = 128;
                            }
                            if (this.myMovement.chosenZ < 1) {
                                this.myMovement.chosenZ = 1;
                            }
                        }
                        if (!comp.getName().equals("y") && !comp.getName().equals("x")) {
                            System.out.println("st:" + comp.getName() + " v: " + value);
                        }
                    }
                    if (aController.getType() != Controller.Type.KEYBOARD) continue;
                    comp = event.getComponent();
                    System.out.println("n: " + comp.getName() + " v: " + event.getValue());
                    if (comp.getName().equalsIgnoreCase("w")) {
                        if (event.getValue() > 0.0f) {
                            this.myMovement.doMoveForward = true;
                            this.myMovement.moveForwardStart = System.currentTimeMillis();
                            continue;
                        }
                        this.myMovement.doMoveForward = false;
                        continue;
                    }
                    if (comp.getName().equalsIgnoreCase("s")) {
                        if (event.getValue() > 0.0f) {
                            this.myMovement.doMoveBackwards = true;
                            this.myMovement.moveBackwardsStart = System.currentTimeMillis();
                            continue;
                        }
                        this.myMovement.doMoveBackwards = false;
                        continue;
                    }
                    if (comp.getName().equalsIgnoreCase("a")) {
                        if (event.getValue() > 0.0f) {
                            this.myMovement.doStrafeLeft = true;
                            this.myMovement.strafeLeftStart = System.currentTimeMillis();
                            continue;
                        }
                        this.myMovement.doStrafeLeft = false;
                        continue;
                    }
                    if (comp.getName().equalsIgnoreCase("d")) {
                        if (event.getValue() > 0.0f) {
                            this.myMovement.doStrafeRight = true;
                            this.myMovement.strafeRightStart = System.currentTimeMillis();
                            continue;
                        }
                        this.myMovement.doStrafeRight = false;
                        continue;
                    }
                    if (comp.getName().equalsIgnoreCase("e")) {
                        if (event.getValue() > 0.0f) {
                            this.myMovement.activateAction = true;
                            continue;
                        }
                        this.myMovement.activateAction = false;
                        continue;
                    }
                    if (comp.getName().equalsIgnoreCase("t")) {
                        if (event.getValue() > 0.0f) {
                            this.myMovement.tunableAction = true;
                            continue;
                        }
                        this.myMovement.tunableAction = false;
                        continue;
                    }
                    if (comp.getName().equalsIgnoreCase("f")) {
                        if (event.getValue() > 0.0f) {
                            this.myMovement.activateElevatorUp = true;
                            continue;
                        }
                        this.myMovement.activateElevatorUp = false;
                        continue;
                    }
                    if (comp.getName().equalsIgnoreCase("g")) {
                        if (event.getValue() > 0.0f) {
                            this.myMovement.activateElevatorDown = true;
                            continue;
                        }
                        this.myMovement.activateElevatorDown = false;
                        continue;
                    }
                    if (comp.getName().equalsIgnoreCase("1")) {
                        if (!(event.getValue() > 0.0f)) continue;
                        this.myMovement.activateHKList[0] = true;
                        continue;
                    }
                    if (comp.getName().equalsIgnoreCase("2")) {
                        if (!(event.getValue() > 0.0f)) continue;
                        this.myMovement.activateHKList[1] = true;
                        continue;
                    }
                    if (comp.getName().equalsIgnoreCase("3")) {
                        if (!(event.getValue() > 0.0f)) continue;
                        this.myMovement.activateHKList[2] = true;
                        continue;
                    }
                    if (comp.getName().equalsIgnoreCase("4")) {
                        if (!(event.getValue() > 0.0f)) continue;
                        this.myMovement.activateHKList[3] = true;
                        continue;
                    }
                    if (comp.getName().equalsIgnoreCase("5")) {
                        if (!(event.getValue() > 0.0f)) continue;
                        this.myMovement.activateHKList[4] = true;
                        continue;
                    }
                    if (comp.getName().equalsIgnoreCase("6")) {
                        if (!(event.getValue() > 0.0f)) continue;
                        this.myMovement.activateHKList[5] = true;
                        continue;
                    }
                    if (comp.getName().equalsIgnoreCase("7")) {
                        if (!(event.getValue() > 0.0f)) continue;
                        this.myMovement.activateHKList[6] = true;
                        continue;
                    }
                    if (comp.getName().equalsIgnoreCase("8")) {
                        if (!(event.getValue() > 0.0f)) continue;
                        this.myMovement.activateHKList[7] = true;
                        continue;
                    }
                    if (comp.getName().equalsIgnoreCase("9")) {
                        if (!(event.getValue() > 0.0f)) continue;
                        this.myMovement.activateHKList[8] = true;
                        continue;
                    }
                    if (comp.getName().equalsIgnoreCase("0")) {
                        if (!(event.getValue() > 0.0f)) continue;
                        this.myMovement.activateHKList[9] = true;
                        continue;
                    }
                    if (comp.getName().equalsIgnoreCase("LEFT SHIFT")) {
                        if (event.getValue() > 0.0f) {
                            this.myMovement.hkHandModifier = true;
                            continue;
                        }
                        this.myMovement.hkHandModifier = false;
                        continue;
                    }
                    if (comp.getName().equalsIgnoreCase("TAB")) {
                        if (!(event.getValue() > 0.0f)) continue;
                        this.myMovement.tabTrigger = true;
                        continue;
                    }
                    if (comp.getName().equalsIgnoreCase("Escape")) {
                        if (!(event.getValue() > 0.0f)) continue;
                        this.myMovement.escPressed = true;
                        continue;
                    }
                    if (comp.getName().equalsIgnoreCase(" ")) {
                        if (event.getValue() > 0.0f) {
                            this.myMovement.doJumpStarted = true;
                            this.myMovement.jumpStart = System.currentTimeMillis();
                            continue;
                        }
                        this.myMovement.doJumpRelease = true;
                        continue;
                    }
                    if (!comp.getName().equalsIgnoreCase("F4")) continue;
                    this.myMovement.doSave = true;
                }
                ++i;
            }
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

