/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.engine.gui.impl;

import com.js.test.engine.gui.Component;
import com.js.test.engine.gui.GuiButton;
import com.js.test.engine.gui.GuiCheckbox;
import com.js.test.engine.gui.GuiImage;
import com.js.test.engine.gui.GuiItemContainer;
import com.js.test.engine.gui.GuiItemIcon;
import com.js.test.engine.gui.GuiKeyEvent;
import com.js.test.engine.gui.GuiLabel;
import com.js.test.engine.gui.GuiMouseEvent;
import com.js.test.engine.gui.GuiMouseListener;
import com.js.test.engine.gui.GuiPanel;
import com.js.test.engine.gui.Overlay;
import com.js.test.engine.machines.ItemMakerConvertion;
import com.js.test.engine.player.ItemMaker;
import com.js.test.terra.area.item.BaseItem;
import com.js.test.terra.area.item.BaseItemLoader;
import com.js.test.terra.math.Vector3;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class ItemMakerOverlay
extends Overlay
implements GuiMouseListener {
    private GuiPanel myPanel;
    private GuiItemContainer myItemContainer;
    private GuiItemContainer myProducedItemContainer;
    private GuiImage myPowerImage;
    private GuiButton myLeft;
    private GuiButton myRight;
    private GuiItemIcon myItemIcon;
    private GuiLabel myItemLabel;
    private GuiButton myActiveToggle;
    private GuiButton myIncreseBlocks;
    private GuiButton myDecreaseBlocks;
    private GuiLabel myMakeAmountLabel;
    private GuiCheckbox myMakeInfiniteBox;
    private int myNewW;
    private int myNewH;
    private ItemMaker myItemMaker;

    public ItemMakerOverlay(int sw, int sh) {
        super("itemmaker");
        this.init(sw, sh);
    }

    @Override
    public void init(int sw, int sh) {
        this.myNewW = sw;
        this.myNewH = sh;
        this.myPanel = new GuiPanel(0, 0, 0, 0, new Vector3(0.4, 0.4, 0.4), 1.0f);
        this.myItemContainer = new GuiItemContainer(0, 0, 0, 0, 0, 0, null);
        this.myProducedItemContainer = new GuiItemContainer(0, 0, 0, 0, 0, 0, null);
        this.myPowerImage = new GuiImage(0, 0, 0, 0, "power_0");
        this.myLeft = new GuiButton(0, 0, 0, 0, "<", new Vector3(0.5, 0.5, 0.5), new Vector3(0.6, 0.6, 0.6));
        this.myRight = new GuiButton(0, 0, 0, 0, ">", new Vector3(0.5, 0.5, 0.5), new Vector3(0.6, 0.6, 0.6));
        this.myActiveToggle = new GuiButton(0, 0, 0, 0, "activate", new Vector3(0.5, 0.5, 0.5), new Vector3(0.6, 0.6, 0.6));
        this.myItemIcon = new GuiItemIcon(0, 0, 0, 0, 0);
        this.myItemLabel = new GuiLabel(0, 0, 0, 0, "none", new Vector3(0.5, 0.5, 0.5));
        this.myMakeInfiniteBox = new GuiCheckbox(0, 0, 0, 0, false);
        this.myDecreaseBlocks = new GuiButton(0, 0, 0, 0, "<", new Vector3(0.5, 0.5, 0.5), new Vector3(0.6, 0.6, 0.6));
        this.myIncreseBlocks = new GuiButton(0, 0, 0, 0, ">", new Vector3(0.5, 0.5, 0.5), new Vector3(0.6, 0.6, 0.6));
        this.myMakeAmountLabel = new GuiLabel(0, 0, 0, 0, "0", new Vector3(0.5, 0.5, 0.5));
        this.myLeft.addMouseListener(this);
        this.myRight.addMouseListener(this);
        this.myActiveToggle.addMouseListener(this);
        this.myMakeInfiniteBox.addMouseListener(this);
        this.myDecreaseBlocks.addMouseListener(this);
        this.myIncreseBlocks.addMouseListener(this);
        this.myPanel.addComponent(this.myItemContainer);
        this.myPanel.addComponent(this.myProducedItemContainer);
        this.myPanel.addComponent(this.myPowerImage);
        this.myPanel.addComponent(this.myLeft);
        this.myPanel.addComponent(this.myRight);
        this.myPanel.addComponent(this.myItemIcon);
        this.myPanel.addComponent(this.myActiveToggle);
        this.myPanel.addComponent(this.myItemLabel);
        this.myPanel.addComponent(this.myMakeInfiniteBox);
        this.myPanel.addComponent(this.myDecreaseBlocks);
        this.myPanel.addComponent(this.myIncreseBlocks);
        this.myPanel.addComponent(this.myMakeAmountLabel);
    }

    @Override
    public void resize(int newW, int newH) {
        this.myNewW = newW;
        this.myNewH = newH;
    }

    public void newItemMaker(ItemMaker theItemMaker) {
        this.myItemMaker = theItemMaker;
        int tenOfSw = this.myNewW / 10;
        int tenOfSh = this.myNewH / 10;
        int itemSize = (this.myNewW - 4 * tenOfSw) / (this.myItemMaker.getMyInventory().getMyW() * 2);
        if (itemSize > 68) {
            itemSize = 68;
        }
        int offset = (this.myNewW - 4 * tenOfSw - itemSize * this.myItemMaker.getMyInventory().getMyW() * 2) / 2;
        this.myPanel.getBox().x = tenOfSw + offset;
        this.myPanel.getBox().y = tenOfSh * 6;
        this.myPanel.getBox().w = this.myNewW - 2 * tenOfSw - offset * 2;
        this.myPanel.getBox().h = itemSize * this.myItemMaker.getMyInventory().getMyH();
        this.myItemContainer.setMyInventory(this.myItemMaker.getMyInventory());
        this.myItemContainer.getBox().x = tenOfSw + offset;
        this.myItemContainer.getBox().y = tenOfSh * 6;
        this.myItemContainer.getBox().w = itemSize * this.myItemMaker.getMyInventory().getMyW();
        this.myItemContainer.getBox().h = itemSize * this.myItemMaker.getMyInventory().getMyH();
        this.myItemContainer.setMyItemSize(itemSize);
        this.myItemContainer.setMyOffset(0);
        this.myProducedItemContainer.setMyInventory(this.myItemMaker.getMyProducedItems());
        this.myProducedItemContainer.getBox().x = this.myNewW - tenOfSw - offset - itemSize * this.myItemMaker.getMyInventory().getMyW();
        this.myProducedItemContainer.getBox().y = tenOfSh * 6;
        this.myProducedItemContainer.getBox().w = itemSize * this.myItemMaker.getMyInventory().getMyW();
        this.myProducedItemContainer.getBox().h = itemSize * this.myItemMaker.getMyInventory().getMyH();
        this.myProducedItemContainer.setMyItemSize(itemSize);
        this.myProducedItemContainer.setMyOffset(0);
        String asset = "power_0";
        if (this.myItemMaker.isPowered()) {
            asset = "power_" + this.myItemMaker.getMyPowerLevel() % 5;
        }
        this.myPowerImage.setMyAsset(asset);
        this.myPowerImage.getBox().x = tenOfSw + offset + itemSize * this.myItemMaker.getMyInventory().getMyW() + tenOfSw / 2;
        this.myPowerImage.getBox().y = tenOfSh * 6;
        this.myPowerImage.getBox().w = tenOfSw;
        this.myPowerImage.getBox().h = tenOfSw / 4;
        this.myLeft.getBox().x = tenOfSw + offset + itemSize * this.myItemMaker.getMyInventory().getMyW();
        this.myLeft.getBox().y = (float)tenOfSh * 6.5f;
        this.myLeft.getBox().w = itemSize / 2;
        this.myLeft.getBox().h = itemSize;
        this.myRight.getBox().x = (float)(tenOfSw + offset + itemSize * this.myItemMaker.getMyInventory().getMyW()) + (float)itemSize * 1.5f;
        this.myRight.getBox().y = (float)tenOfSh * 6.5f;
        this.myRight.getBox().w = itemSize / 2;
        this.myRight.getBox().h = itemSize;
        this.myMakeInfiniteBox.getBox().x = (float)(tenOfSw + offset + itemSize * this.myItemMaker.getMyInventory().getMyW()) + (float)itemSize * 2.5f;
        this.myMakeInfiniteBox.getBox().y = (float)tenOfSh * 6.5f;
        this.myMakeInfiniteBox.getBox().w = itemSize / 2;
        this.myMakeInfiniteBox.getBox().h = itemSize / 2;
        this.myMakeInfiniteBox.setMyState(this.myItemMaker.isMyMakeInfinite());
        this.myDecreaseBlocks.getBox().x = (float)(tenOfSw + offset + itemSize * this.myItemMaker.getMyInventory().getMyW()) + (float)itemSize * 2.5f;
        this.myDecreaseBlocks.getBox().y = (float)tenOfSh * 6.5f + (float)(itemSize / 2) + 6.0f;
        this.myDecreaseBlocks.getBox().w = itemSize / 2;
        this.myDecreaseBlocks.getBox().h = itemSize / 2;
        this.myMakeAmountLabel.getBox().x = (float)(tenOfSw + offset + itemSize * this.myItemMaker.getMyInventory().getMyW()) + (float)itemSize * 3.0f;
        this.myMakeAmountLabel.getBox().y = (float)tenOfSh * 6.5f + (float)(itemSize / 2) + 6.0f;
        this.myMakeAmountLabel.getBox().w = itemSize / 2;
        this.myMakeAmountLabel.getBox().h = itemSize / 2;
        this.myMakeAmountLabel.setMyText(Integer.toString(this.myItemMaker.getMyMakeAmount()));
        this.myIncreseBlocks.getBox().x = (float)(tenOfSw + offset + itemSize * this.myItemMaker.getMyInventory().getMyW()) + (float)itemSize * 3.5f;
        this.myIncreseBlocks.getBox().y = (float)tenOfSh * 6.5f + (float)(itemSize / 2) + 6.0f;
        this.myIncreseBlocks.getBox().w = itemSize / 2;
        this.myIncreseBlocks.getBox().h = itemSize / 2;
        this.myItemIcon.getBox().x = tenOfSw + offset + itemSize * this.myItemMaker.getMyInventory().getMyW() + itemSize / 2;
        this.myItemIcon.getBox().y = (float)tenOfSh * 6.5f;
        this.myItemIcon.getBox().w = itemSize;
        this.myItemIcon.getBox().h = itemSize;
        if (this.myItemMaker.getMyItemToMake() != 0) {
            this.myItemIcon.setMyItemId(this.myItemMaker.getMyItemToMake());
        } else {
            this.myItemIcon.setMyItemId(0);
        }
        this.myActiveToggle.getBox().x = tenOfSw + offset + itemSize * this.myItemMaker.getMyInventory().getMyW() + 20;
        this.myActiveToggle.getBox().y = tenOfSh * 8;
        this.myActiveToggle.getBox().w = tenOfSw * 2 - 40;
        this.myActiveToggle.getBox().h = tenOfSw / 4;
        if (this.myItemMaker.isActivated()) {
            this.myActiveToggle.setMyText("stop");
        } else {
            this.myActiveToggle.setMyText("activate");
        }
        this.myItemLabel.getBox().x = tenOfSw + offset + itemSize * this.myItemMaker.getMyInventory().getMyW() + 20;
        this.myItemLabel.getBox().y = (float)tenOfSh * 7.5f;
        this.myItemLabel.getBox().w = tenOfSw * 2 - 40;
        this.myItemLabel.getBox().h = tenOfSw / 4;
        BaseItem anItemToMake = BaseItemLoader.getInstance().getMyItems().get(this.myItemMaker.getMyItemToMake());
        if (this.myItemMaker.getMyItemToMake() != 0) {
            this.myItemLabel.setMyText(anItemToMake.getMyFancyName());
        } else {
            this.myItemLabel.setMyText("none");
        }
    }

    @Override
    public void render(GL2 theGl, GLU theGlu) {
        if (this.myItemMaker != null) {
            this.myMakeAmountLabel.setMyText(Integer.toString(this.myItemMaker.getMyMakeAmount()));
        }
        this.myPanel.render(theGl, theGlu);
    }

    @Override
    public void mouseMove(GuiMouseEvent e) {
        this.myPanel.mouseMove(e);
    }

    @Override
    public void click(GuiMouseEvent e) {
        this.myPanel.click(e);
    }

    @Override
    public void mouseOver(GuiMouseEvent e) {
        this.myPanel.mouseOver(e);
    }

    @Override
    public void mouseLeave(GuiMouseEvent e) {
        this.myPanel.mouseLeave(e);
    }

    @Override
    public void keyEvent(GuiKeyEvent e) {
        this.myPanel.keyEvent(e);
    }

    @Override
    public void mousePressed(GuiMouseEvent e) {
        this.myPanel.mousePressed(e);
    }

    @Override
    public void mouseReleased(GuiMouseEvent e) {
        this.myPanel.mouseReleased(e);
    }

    @Override
    public void click(GuiMouseEvent e, Component trigger) {
        if (trigger == this.myActiveToggle) {
            this.myItemMaker.setActivated(!this.myItemMaker.isActivated());
            if (this.myItemMaker.isActivated()) {
                this.myActiveToggle.setMyText("stop");
            } else {
                this.myActiveToggle.setMyText("activate");
            }
        } else if (trigger == this.myLeft) {
            int[] makeableItems = ItemMakerConvertion.getInstance().getMakableItems();
            int anIndex = this.myItemMaker.getMyIndex() - 1;
            if (anIndex < 0) {
                anIndex = makeableItems.length - 1;
            }
            this.myItemMaker.setMyIndex(anIndex);
            if (anIndex > 0) {
                BaseItem aItemToMake = BaseItemLoader.getInstance().getMyItems().get(makeableItems[anIndex]);
                this.myItemMaker.setMyItemToMake(makeableItems[anIndex]);
                this.myItemIcon.setMyItemId(aItemToMake.getMyId());
                this.myItemLabel.setMyText(aItemToMake.getMyFancyName());
            } else {
                this.myItemLabel.setMyText("none");
                this.myItemMaker.setMyItemToMake(0);
                this.myItemIcon.setMyItemId(0);
            }
        } else if (trigger == this.myRight) {
            int[] makeableItems = ItemMakerConvertion.getInstance().getMakableItems();
            int anIndex = this.myItemMaker.getMyIndex() + 1;
            if (anIndex >= makeableItems.length) {
                anIndex = 0;
            }
            this.myItemMaker.setMyIndex(anIndex);
            if (anIndex > 0) {
                BaseItem aItemToMake = BaseItemLoader.getInstance().getMyItems().get(makeableItems[anIndex]);
                this.myItemMaker.setMyItemToMake(makeableItems[anIndex]);
                this.myItemIcon.setMyItemId(aItemToMake.getMyId());
                this.myItemLabel.setMyText(aItemToMake.getMyFancyName());
            } else {
                this.myItemLabel.setMyText("none");
                this.myItemMaker.setMyItemToMake(0);
                this.myItemIcon.setMyItemId(0);
            }
        } else if (trigger == this.myMakeInfiniteBox) {
            this.myItemMaker.setMyMakeInfinite(!this.myItemMaker.isMyMakeInfinite());
            if (this.myItemMaker.isMyMakeInfinite()) {
                this.myMakeInfiniteBox.setMyState(true);
            } else {
                this.myMakeInfiniteBox.setMyState(false);
            }
        } else if (trigger == this.myDecreaseBlocks) {
            if (this.myItemMaker.getMyMakeAmount() > 0) {
                this.myItemMaker.setMyMakeAmount(this.myItemMaker.getMyMakeAmount() - 1);
                this.myMakeAmountLabel.setMyText(Integer.toString(this.myItemMaker.getMyMakeAmount()));
            }
        } else if (trigger == this.myIncreseBlocks) {
            this.myItemMaker.setMyMakeAmount(this.myItemMaker.getMyMakeAmount() + 1);
            this.myMakeAmountLabel.setMyText(Integer.toString(this.myItemMaker.getMyMakeAmount()));
        }
    }
}

