/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.engine.gui.impl;

import com.js.test.engine.gui.GuiHotbar;
import com.js.test.engine.gui.GuiKeyEvent;
import com.js.test.engine.gui.GuiMouseEvent;
import com.js.test.engine.gui.GuiPanel;
import com.js.test.engine.gui.Overlay;
import com.js.test.engine.player.Player;
import com.js.test.terra.math.Vector3;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class HotbarOverlay
extends Overlay {
    private Player myPlayer;
    private GuiPanel myPanel;
    private GuiHotbar myHotbar;

    public HotbarOverlay(int sw, int sh, Player player) {
        super("hotbar");
        this.myPlayer = player;
        this.init(sw, sh);
    }

    @Override
    public void init(int sw, int sh) {
        int tenOfSw = sw / 10;
        int tenOfSh = sh / 10;
        int itemSize = (sw - 2 * tenOfSw) / 10;
        if (itemSize > 68) {
            itemSize = 68;
        }
        int offset = (sw - 2 * tenOfSw - itemSize * 10) / 2;
        this.myPanel = new GuiPanel(tenOfSw, sh - tenOfSh, sw - 2 * tenOfSw, itemSize, new Vector3(1.0, 1.0, 1.0), 0.0f);
        this.myHotbar = new GuiHotbar(tenOfSw, sh - tenOfSh, sw - 2 * tenOfSw, itemSize, itemSize, offset, this.myPlayer.getMyInventory());
        this.myPanel.addComponent(this.myHotbar);
    }

    @Override
    public void resize(int newW, int newH) {
        int tenOfSw = newW / 10;
        int tenOfSh = newH / 10;
        int itemSize = (newW - 2 * tenOfSw) / 10;
        if (itemSize > 68) {
            itemSize = 68;
        }
        int offset = (newW - 2 * tenOfSw - itemSize * 10) / 2;
        this.myPanel.getBox().x = tenOfSw;
        this.myPanel.getBox().y = newH - tenOfSh;
        this.myPanel.getBox().w = newW - 2 * tenOfSw;
        this.myPanel.getBox().h = itemSize;
        this.myHotbar.getBox().x = tenOfSw;
        this.myHotbar.getBox().y = newH - tenOfSh;
        this.myHotbar.getBox().w = newW - 2 * tenOfSw;
        this.myHotbar.getBox().h = itemSize;
        this.myHotbar.setMyItemSize(itemSize);
        this.myHotbar.setMyOffset(offset);
    }

    @Override
    public void render(GL2 theGl, GLU theGlu) {
        this.myPanel.render(theGl, theGlu);
    }

    @Override
    public void mouseMove(GuiMouseEvent e) {
    }

    @Override
    public void click(GuiMouseEvent e) {
    }

    @Override
    public void mouseOver(GuiMouseEvent e) {
    }

    @Override
    public void mouseLeave(GuiMouseEvent e) {
    }

    @Override
    public void keyEvent(GuiKeyEvent e) {
    }

    @Override
    public void mousePressed(GuiMouseEvent e) {
        this.myPanel.mousePressed(e);
    }

    @Override
    public void mouseReleased(GuiMouseEvent e) {
        this.myPanel.mouseReleased(e);
    }
}

