/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.engine.gui.impl;

import com.js.test.engine.gui.GuiImage;
import com.js.test.engine.gui.GuiItemContainer;
import com.js.test.engine.gui.GuiKeyEvent;
import com.js.test.engine.gui.GuiMouseEvent;
import com.js.test.engine.gui.GuiPanel;
import com.js.test.engine.gui.Overlay;
import com.js.test.engine.player.Grinder;
import com.js.test.terra.math.Vector3;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class GrinderOverlay
extends Overlay {
    private GuiPanel myPanel;
    private GuiItemContainer myItemContainer;
    private GuiItemContainer myProducedItemContainer;
    private GuiImage myPowerImage;
    private int myNewW;
    private int myNewH;
    private Grinder myGrinder;

    public GrinderOverlay(int sw, int sh) {
        super("grinder");
        this.init(sw, sh);
    }

    @Override
    public void init(int sw, int sh) {
        this.myNewW = sw;
        this.myNewH = sh;
        this.myPanel = new GuiPanel(0, 0, 0, 0, new Vector3(0.4, 0.4, 0.4), 1.0f);
        this.myItemContainer = new GuiItemContainer(0, 0, 0, 0, 0, 0, null);
        this.myProducedItemContainer = new GuiItemContainer(0, 0, 0, 0, 0, 0, null);
        this.myPowerImage = new GuiImage(0, 0, 0, 0, "power_0");
        this.myPanel.addComponent(this.myItemContainer);
        this.myPanel.addComponent(this.myProducedItemContainer);
        this.myPanel.addComponent(this.myPowerImage);
    }

    @Override
    public void resize(int newW, int newH) {
        this.myNewW = newW;
        this.myNewH = newH;
    }

    public void newGrinder(Grinder theGrinder) {
        this.myGrinder = theGrinder;
        int tenOfSw = this.myNewW / 10;
        int tenOfSh = this.myNewH / 10;
        int itemSize = (this.myNewW - 3 * tenOfSw) / (this.myGrinder.getMyInventory().getMyW() * 2);
        if (itemSize > 68) {
            itemSize = 68;
        }
        int offset = (this.myNewW - 3 * tenOfSw - itemSize * this.myGrinder.getMyInventory().getMyW() * 2) / 2;
        this.myPanel.getBox().x = tenOfSw + offset;
        this.myPanel.getBox().y = tenOfSh * 6;
        this.myPanel.getBox().w = this.myNewW - 2 * tenOfSw - offset * 2;
        this.myPanel.getBox().h = itemSize * this.myGrinder.getMyInventory().getMyH();
        this.myItemContainer.setMyInventory(this.myGrinder.getMyInventory());
        this.myItemContainer.getBox().x = tenOfSw + offset;
        this.myItemContainer.getBox().y = tenOfSh * 6;
        this.myItemContainer.getBox().w = itemSize * this.myGrinder.getMyInventory().getMyW();
        this.myItemContainer.getBox().h = itemSize * this.myGrinder.getMyInventory().getMyH();
        this.myItemContainer.setMyItemSize(itemSize);
        this.myItemContainer.setMyOffset(0);
        this.myProducedItemContainer.setMyInventory(this.myGrinder.getMyProducedItems());
        this.myProducedItemContainer.getBox().x = this.myNewW - tenOfSw - offset - itemSize * this.myGrinder.getMyInventory().getMyW();
        this.myProducedItemContainer.getBox().y = tenOfSh * 6;
        this.myProducedItemContainer.getBox().w = itemSize * this.myGrinder.getMyInventory().getMyW();
        this.myProducedItemContainer.getBox().h = itemSize * this.myGrinder.getMyInventory().getMyH();
        this.myProducedItemContainer.setMyItemSize(itemSize);
        this.myProducedItemContainer.setMyOffset(0);
        String asset = "power_0";
        if (this.myGrinder.isPowered()) {
            asset = "power_" + this.myGrinder.getMyPowerLevel() % 5;
        }
        this.myPowerImage.setMyAsset(asset);
        this.myPowerImage.getBox().x = tenOfSw + offset + itemSize * this.myGrinder.getMyInventory().getMyW();
        this.myPowerImage.getBox().y = tenOfSh * 6;
        this.myPowerImage.getBox().w = tenOfSw;
        this.myPowerImage.getBox().h = tenOfSw / 4;
    }

    @Override
    public void render(GL2 theGl, GLU theGlu) {
        this.myPanel.render(theGl, theGlu);
    }

    @Override
    public void mouseMove(GuiMouseEvent e) {
        this.myPanel.mouseMove(e);
    }

    @Override
    public void click(GuiMouseEvent e) {
        this.myPanel.click(e);
    }

    @Override
    public void mouseOver(GuiMouseEvent e) {
        this.myPanel.mouseOver(e);
    }

    @Override
    public void mouseLeave(GuiMouseEvent e) {
        this.myPanel.mouseLeave(e);
    }

    @Override
    public void keyEvent(GuiKeyEvent e) {
        this.myPanel.keyEvent(e);
    }

    @Override
    public void mousePressed(GuiMouseEvent e) {
        this.myPanel.mousePressed(e);
    }

    @Override
    public void mouseReleased(GuiMouseEvent e) {
        this.myPanel.mouseReleased(e);
    }
}

