/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.engine.camera;

import com.js.test.terra.math.Vector3;

public class Plane {
    public float a;
    public float b;
    public float c;
    public float d;

    public Plane() {
    }

    public Plane(float a, float b, float c, float d, boolean normalize) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        if (normalize) {
            this.normalizePlane();
        }
    }

    public float getA() {
        return this.a;
    }

    public void setA(float a) {
        this.a = a;
    }

    public float getB() {
        return this.b;
    }

    public void setB(float b) {
        this.b = b;
    }

    public float getC() {
        return this.c;
    }

    public void setC(float c) {
        this.c = c;
    }

    public float getD() {
        return this.d;
    }

    public void setD(float d) {
        this.d = d;
    }

    public void normalizePlane() {
        float mag = (float)Math.sqrt(this.a * this.a + this.b * this.b + this.c * this.c);
        this.a /= mag;
        this.b /= mag;
        this.c /= mag;
        this.d /= mag;
    }

    public float distanceToPlane(Vector3 point) {
        return (float)((double)this.a * point.x + (double)this.b * point.y + (double)this.c * point.z + (double)this.d);
    }

    public int sideOfPlane(Vector3 point) {
        float dist = (float)((double)this.a * point.x + (double)this.b * point.y + (double)this.c * point.z + (double)this.d);
        if (dist < 0.0f) {
            return -1;
        }
        if (dist > 0.0f) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "[a: " + this.a + " b: " + this.b + " c: " + this.c + " d: " + this.d + "]";
    }
}

