/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.macosx.cgl;

import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opengl.util.GLBuffers;
import javax.media.nativewindow.DefaultGraphicsConfiguration;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.SurfaceChangeable;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.opengl.macosx.cgl.CGL;
import jogamp.opengl.macosx.cgl.MacOSXCGLDrawable;
import jogamp.opengl.macosx.cgl.MacOSXCGLDrawableFactory;
import jogamp.opengl.macosx.cgl.MacOSXPbufferCGLContext;

public class MacOSXPbufferCGLDrawable
extends MacOSXCGLDrawable {
    protected GLBackendImpl impl;
    protected long pBuffer;
    protected int pBufferTexTarget;
    protected int pBufferTexWidth;
    protected int pBufferTexHeight;

    public MacOSXPbufferCGLDrawable(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface) {
        super(gLDrawableFactory, nativeSurface, false);
    }

    @Override
    protected void destroyImpl() {
        this.setRealized(false);
    }

    @Override
    protected void setRealizedImpl() {
        if (this.realized) {
            this.createPbuffer();
        } else {
            this.destroyPbuffer();
        }
    }

    @Override
    public GLContext createContext(GLContext gLContext) {
        MacOSXPbufferCGLContext macOSXPbufferCGLContext = new MacOSXPbufferCGLContext(this, gLContext);
        this.registerContext(macOSXPbufferCGLContext);
        return macOSXPbufferCGLContext;
    }

    @Override
    protected long getNSViewHandle() {
        return 0L;
    }

    @Override
    public long getHandle() {
        return this.pBuffer;
    }

    protected int getTextureTarget() {
        return this.pBufferTexTarget;
    }

    protected int getTextureWidth() {
        return this.pBufferTexWidth;
    }

    protected int getTextureHeight() {
        return this.pBufferTexHeight;
    }

    protected void destroyPbuffer() {
        if (this.pBuffer != 0L) {
            NativeSurface nativeSurface = this.getNativeSurface();
            this.impl.destroy(this.pBuffer);
            this.pBuffer = 0L;
            ((SurfaceChangeable)((Object)nativeSurface)).setSurfaceHandle(0L);
        }
    }

    private void createPbuffer() {
        NativeSurface nativeSurface = this.getNativeSurface();
        DefaultGraphicsConfiguration defaultGraphicsConfiguration = (DefaultGraphicsConfiguration)nativeSurface.getGraphicsConfiguration();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)defaultGraphicsConfiguration.getChosenCapabilities();
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        MacOSXCGLDrawableFactory.SharedResource sharedResource = ((MacOSXCGLDrawableFactory)this.factory).getOrCreateOSXSharedResource(defaultGraphicsConfiguration.getScreen().getDevice());
        if (DEBUG) {
            System.out.println("Pbuffer config: " + defaultGraphicsConfiguration);
        }
        this.pBufferTexTarget = gLCapabilitiesImmutable.getPbufferRenderToTextureRectangle() && null != sharedResource && sharedResource.isRECTTextureAvailable() ? 34037 : 3553;
        if (34037 == this.pBufferTexTarget || null != sharedResource && sharedResource.isNPOTTextureAvailable()) {
            this.pBufferTexWidth = this.getWidth();
            this.pBufferTexHeight = this.getHeight();
        } else {
            this.pBufferTexWidth = GLBuffers.getNextPowerOf2(this.getWidth());
            this.pBufferTexHeight = GLBuffers.getNextPowerOf2(this.getHeight());
        }
        int n = 6408;
        if (gLCapabilitiesImmutable.getPbufferFloatingPointBuffers()) {
            if (!gLProfile.isGL2GL3() || null == sharedResource || sharedResource.isAppletFloatPixelsAvailable()) {
                throw new GLException("Floating-point support (GL_APPLE_float_pixels) not available");
            }
            switch (gLCapabilitiesImmutable.getRedBits()) {
                case 16: {
                    n = 34842;
                    break;
                }
                case 32: {
                    n = 34836;
                    break;
                }
                default: {
                    throw new GLException("Invalid floating-point bit depth (only 16 and 32 supported)");
                }
            }
        }
        this.pBuffer = this.impl.create(this.pBufferTexTarget, n, this.getWidth(), this.getHeight());
        if (DEBUG) {
            System.err.println("MacOSXPbufferCGLDrawable tex: target " + MacOSXPbufferCGLDrawable.toHexString(this.pBufferTexTarget) + ", pbufferSize " + this.getWidth() + "x" + this.getHeight() + ", texSize " + this.pBufferTexWidth + "x" + this.pBufferTexHeight + ", internal-fmt " + MacOSXPbufferCGLDrawable.toHexString(n));
            System.err.println("MacOSXPbufferCGLDrawable pBuffer: " + MacOSXPbufferCGLDrawable.toHexString(this.pBuffer));
        }
        if (this.pBuffer == 0L) {
            throw new GLException("pbuffer creation error: CGL.createPBuffer() failed");
        }
        ((SurfaceChangeable)((Object)nativeSurface)).setSurfaceHandle(this.pBuffer);
    }

    @Override
    public void setOpenGLMode(MacOSXCGLDrawable.GLBackendType gLBackendType) {
        super.setOpenGLMode(gLBackendType);
        this.createPbuffer();
    }

    @Override
    protected void initOpenGLImpl(MacOSXCGLDrawable.GLBackendType gLBackendType) {
        switch (gLBackendType) {
            case NSOPENGL: {
                this.impl = new NSOpenGLImpl();
                break;
            }
            case CGL: {
                this.impl = new CGLImpl();
                break;
            }
            default: {
                throw new InternalError("Illegal implementation mode " + (Object)((Object)gLBackendType));
            }
        }
    }

    class CGLImpl
    implements GLBackendImpl {
        CGLImpl() {
        }

        @Override
        public long create(int n, int n2, int n3, int n4) {
            PointerBuffer pointerBuffer = PointerBuffer.allocateDirect((int)1);
            int n5 = CGL.CGLCreatePBuffer(n3, n4, n, n2, 0, pointerBuffer);
            if (n5 != 0) {
                throw new GLException("Error creating CGL-based pbuffer: error code " + n5);
            }
            return pointerBuffer.get(0);
        }

        @Override
        public void destroy(long l) {
            int n = CGL.CGLDestroyPBuffer(l);
            if (n != 0) {
                throw new GLException("Error destroying CGL-based pbuffer: error code " + n);
            }
        }
    }

    class NSOpenGLImpl
    implements GLBackendImpl {
        NSOpenGLImpl() {
        }

        @Override
        public long create(int n, int n2, int n3, int n4) {
            return CGL.createPBuffer(n, n2, n3, n4);
        }

        @Override
        public void destroy(long l) {
            CGL.destroyPBuffer(l);
        }
    }

    static interface GLBackendImpl {
        public long create(int var1, int var2, int var3, int var4);

        public void destroy(long var1);
    }
}

