/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import java.util.HashSet;
import java.util.StringTokenizer;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import jogamp.opengl.Debug;
import jogamp.opengl.GLContextImpl;

final class ExtensionAvailabilityCache {
    protected static final boolean DEBUG = GLContextImpl.DEBUG;
    private static final boolean DEBUG_AVAILABILITY = Debug.isPropertyDefined("jogl.debug.ExtensionAvailabilityCache", true);
    private boolean initialized = false;
    private String glExtensions = null;
    private String glXExtensions = null;
    private HashSet<String> availableExtensionCache = new HashSet(50);
    private GLContextImpl context;

    ExtensionAvailabilityCache(GLContextImpl gLContextImpl) {
        this.context = gLContextImpl;
    }

    final void flush() {
        if (DEBUG) {
            System.out.println("ExtensionAvailabilityCache: Flush availability OpenGL " + this.context.getGLVersion());
        }
        this.availableExtensionCache.clear();
        this.initialized = false;
    }

    final void reset() {
        this.flush();
        this.initAvailableExtensions();
    }

    final boolean isInitialized() {
        return this.initialized && !this.availableExtensionCache.isEmpty();
    }

    final boolean isExtensionAvailable(String string) {
        this.initAvailableExtensions();
        return this.availableExtensionCache.contains(ExtensionAvailabilityCache.mapGLExtensionName(string));
    }

    final String getPlatformExtensionsString() {
        this.initAvailableExtensions();
        return this.glXExtensions;
    }

    final String getGLExtensionsString() {
        this.initAvailableExtensions();
        if (DEBUG) {
            System.err.println("ExtensionAvailabilityCache: getGLExtensions() called");
        }
        return this.glExtensions;
    }

    private final void initAvailableExtensions() {
        GL gL = this.context.getGL();
        if (this.availableExtensionCache.isEmpty() || !this.initialized) {
            Object object;
            Object object2;
            if (DEBUG) {
                System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: Pre-caching init " + gL + ", OpenGL " + this.context.getGLVersion());
            }
            boolean bl = false;
            if (this.context.isGL3()) {
                if (!this.context.isFunctionAvailable("glGetStringi")) {
                    if (DEBUG) {
                        System.err.println("GLContext: GL >= 3.1 usage, but no glGetStringi");
                    }
                } else {
                    bl = true;
                }
            }
            if (DEBUG) {
                System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: Pre-caching extension availability OpenGL " + this.context.getGLVersion() + ", use " + (bl ? "glGetStringi" : "glGetString"));
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (bl) {
                object2 = gL.getGL2GL3();
                object = new int[]{0};
                object2.glGetIntegerv(33309, (int[])object, 0);
                for (int i = 0; i < object[0]; ++i) {
                    stringBuffer.append(object2.glGetStringi(7939, i));
                    if (i >= object[0]) continue;
                    stringBuffer.append(" ");
                }
                if (DEBUG) {
                    System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: GL_EXTENSIONS: " + (int)object[0]);
                }
                if (false == object[0]) {
                    bl = false;
                }
            }
            if (!bl) {
                stringBuffer.append(gL.glGetString(7939));
            }
            this.glExtensions = stringBuffer.toString();
            object2 = new HashSet(50);
            object = new StringTokenizer(this.context.getPlatformExtensionsStringImpl().toString());
            while (((StringTokenizer)object).hasMoreTokens()) {
                ((HashSet)object2).add(((StringTokenizer)object).nextToken().trim());
            }
            Object object3 = new StringBuffer();
            Object object4 = ((HashSet)object2).iterator();
            while (object4.hasNext()) {
                ((StringBuffer)object3).append((String)object4.next()).append(" ");
            }
            this.glXExtensions = ((StringBuffer)object3).toString();
            stringBuffer.append(" ");
            stringBuffer.append(this.glXExtensions);
            object2 = stringBuffer.toString();
            if (DEBUG_AVAILABILITY) {
                System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: GL vendor: " + gL.glGetString(7936));
            }
            object = new StringTokenizer((String)object2);
            while (((StringTokenizer)object).hasMoreTokens()) {
                object3 = ((StringTokenizer)object).nextToken().trim();
                object3 = ((String)object3).intern();
                this.availableExtensionCache.add((String)object3);
                if (!DEBUG_AVAILABILITY) continue;
                System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: Available: " + (String)object3);
            }
            if (DEBUG) {
                System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: ALL EXTENSIONS: " + this.availableExtensionCache.size());
            }
            if (!this.context.isGLES()) {
                object3 = new int[]{this.context.getGLVersionMajor()};
                object4 = new int[]{this.context.getGLVersionMinor()};
                while (GLContext.isValidGLVersion((int)object3[0], (int)object4[0])) {
                    this.availableExtensionCache.add("GL_VERSION_" + (int)object3[0] + "_" + (int)object4[0]);
                    if (DEBUG) {
                        System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: Added GL_VERSION_" + (int)object3[0] + "_" + (int)object4[0] + " to known extensions");
                    }
                    if (GLContext.decrementGLVersion((int[])object3, (int[])object4)) continue;
                }
            }
            this.availableExtensionCache.add("<INTERNAL_DUMMY_PLACEHOLDER>");
            this.initialized = true;
        }
    }

    private static String mapGLExtensionName(String string) {
        if (string != null && (string.equals("WGL_NV_vertex_array_range") || string.equals("GLX_NV_vertex_array_range"))) {
            return "GL_NV_vertex_array_range";
        }
        return string;
    }

    static String getThreadName() {
        return Thread.currentThread().getName();
    }
}

