/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.awt;

import com.jogamp.newt.Display;
import com.jogamp.newt.util.EDTUtil;
import java.awt.EventQueue;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.media.nativewindow.NativeWindowException;
import jogamp.newt.Debug;

public class AWTEDTUtil
implements EDTUtil {
    public static final boolean DEBUG = Debug.debug("EDT");
    private static Timer pumpMessagesTimer = null;
    private static TimerTask pumpMessagesTimerTask = null;
    private static final Map<Display, Runnable> pumpMessageDisplayMap = new HashMap<Display, Runnable>();
    private static AWTEDTUtil singletonMainThread = new AWTEDTUtil();
    private static long pollPeriod = 10L;

    public static AWTEDTUtil getSingleton() {
        return singletonMainThread;
    }

    AWTEDTUtil() {
    }

    @Override
    public final long getPollPeriod() {
        return pollPeriod;
    }

    @Override
    public final void setPollPeriod(long l) {
        pollPeriod = l;
    }

    @Override
    public final void reset() {
    }

    @Override
    public final void start() {
    }

    @Override
    public final boolean isCurrentThreadEDT() {
        return EventQueue.isDispatchThread();
    }

    @Override
    public final boolean isRunning() {
        return true;
    }

    @Override
    public final void invokeStop(Runnable runnable) {
        this.invoke(true, runnable);
    }

    @Override
    public final void invoke(boolean bl, Runnable runnable) {
        if (runnable == null) {
            return;
        }
        try {
            if (this.isCurrentThreadEDT()) {
                runnable.run();
                return;
            }
            if (bl) {
                EventQueue.invokeAndWait(runnable);
            } else {
                EventQueue.invokeLater(runnable);
            }
        }
        catch (Exception exception) {
            throw new NativeWindowException(exception);
        }
    }

    @Override
    public final void waitUntilIdle() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public final void waitUntilStopped() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPumpMessage(Display display, Runnable runnable) {
        if (DEBUG) {
            System.err.println("AWTEDTUtil.addPumpMessage(): " + Thread.currentThread().getName() + " - dpy " + display);
        }
        Map<Display, Runnable> map = pumpMessageDisplayMap;
        synchronized (map) {
            if (null == pumpMessagesTimer) {
                pumpMessagesTimer = new Timer();
                pumpMessagesTimerTask = new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Map map = pumpMessageDisplayMap;
                        synchronized (map) {
                            Iterator iterator = pumpMessageDisplayMap.values().iterator();
                            while (iterator.hasNext()) {
                                AWTEDTUtil.getSingleton().invoke(true, (Runnable)iterator.next());
                            }
                        }
                    }
                };
                pumpMessagesTimer.scheduleAtFixedRate(pumpMessagesTimerTask, 0L, pollPeriod);
            }
            pumpMessageDisplayMap.put(display, runnable);
        }
    }
}

