/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.windows;

import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.ProxySurface;
import jogamp.nativewindow.windows.GDI;

public class GDISurface
extends ProxySurface {
    protected long windowHandle;
    protected long surfaceHandle;

    public GDISurface(AbstractGraphicsConfiguration abstractGraphicsConfiguration, long l) {
        super(abstractGraphicsConfiguration);
        if (0L == l) {
            throw new NativeWindowException("Error hwnd 0, werr: " + GDI.GetLastError());
        }
        this.windowHandle = l;
    }

    @Override
    protected final void invalidateImpl() {
        this.windowHandle = 0L;
        this.surfaceHandle = 0L;
    }

    @Override
    protected int lockSurfaceImpl() {
        if (0L != this.surfaceHandle) {
            throw new InternalError("surface not released");
        }
        this.surfaceHandle = GDI.GetDC(this.windowHandle);
        return 0L != this.surfaceHandle ? 3 : 1;
    }

    @Override
    protected void unlockSurfaceImpl() {
        if (0L == this.surfaceHandle) {
            throw new InternalError("surface not acquired: " + this + ", thread: " + Thread.currentThread().getName());
        }
        if (0 == GDI.ReleaseDC(this.windowHandle, this.surfaceHandle)) {
            throw new NativeWindowException("DC not released: " + this + ", isWindow " + GDI.IsWindow(this.windowHandle) + ", werr " + GDI.GetLastError() + ", thread: " + Thread.currentThread().getName());
        }
        this.surfaceHandle = 0L;
    }

    @Override
    public long getSurfaceHandle() {
        return this.surfaceHandle;
    }

    @Override
    public String toString() {
        return "GDISurface[config " + this.getPrivateGraphicsConfiguration() + ", displayHandle 0x" + Long.toHexString(this.getDisplayHandle()) + ", windowHandle 0x" + Long.toHexString(this.windowHandle) + ", surfaceHandle 0x" + Long.toHexString(this.getSurfaceHandle()) + ", size " + this.getWidth() + "x" + this.getHeight() + "]";
    }
}

