/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.geom.Vertex;
import java.util.ArrayList;
import jogamp.graph.font.typecast.TypecastFont;
import jogamp.graph.font.typecast.TypecastGlyph;
import jogamp.graph.font.typecast.ot.OTGlyph;
import jogamp.graph.font.typecast.ot.Point;
import jogamp.graph.geom.plane.AffineTransform;
import jogamp.graph.geom.plane.Path2D;
import jogamp.graph.geom.plane.PathIterator;

public class TypecastRenderer {
    private static void getPaths(TypecastFont typecastFont, CharSequence charSequence, float f, AffineTransform affineTransform, Path2D[] path2DArray) {
        if (charSequence == null) {
            return;
        }
        Font.Metrics metrics = typecastFont.getMetrics();
        float f2 = 0.0f;
        float f3 = metrics.getLineGap(f);
        float f4 = metrics.getAscent(f);
        float f5 = metrics.getDescent(f);
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        AffineTransform affineTransform2 = new AffineTransform();
        float f6 = f3 - f5 + f4;
        float f7 = 0.0f;
        for (int i = 0; i < charSequence.length(); ++i) {
            path2DArray[i] = new Path2D();
            path2DArray[i].reset();
            affineTransform2.setTransform(affineTransform);
            char c = charSequence.charAt(i);
            if (c == '\n') {
                f7 += f6;
                f2 = 0.0f;
                continue;
            }
            if (c == ' ') {
                f2 += (float)typecastFont.font.getHmtxTable().getAdvanceWidth(3) * metrics.getScale(f);
                continue;
            }
            TypecastGlyph typecastGlyph = (TypecastGlyph)typecastFont.getGlyph(c);
            Path2D path2D = typecastGlyph.getPath();
            float f8 = metrics.getScale(f);
            affineTransform2.translate(f2, f7);
            affineTransform2.scale(f8, f8);
            path2DArray[i].append(path2D.iterator(affineTransform2), false);
            f2 += typecastGlyph.getAdvance(f, true);
        }
    }

    public static ArrayList<OutlineShape> getOutlineShapes(TypecastFont typecastFont, CharSequence charSequence, float f, AffineTransform affineTransform, Vertex.Factory<? extends Vertex> factory) {
        Path2D[] path2DArray = new Path2D[charSequence.length()];
        TypecastRenderer.getPaths(typecastFont, charSequence, f, affineTransform, path2DArray);
        ArrayList<OutlineShape> arrayList = new ArrayList<OutlineShape>();
        int n = path2DArray.length;
        for (int i = 0; i < n; ++i) {
            if (path2DArray[i] == null) continue;
            OutlineShape outlineShape = new OutlineShape(factory);
            arrayList.add(outlineShape);
            PathIterator pathIterator = path2DArray[i].iterator(affineTransform);
            if (null == pathIterator) continue;
            while (!pathIterator.isDone()) {
                float[] fArray = new float[6];
                int n2 = pathIterator.currentSegment(fArray);
                TypecastRenderer.addPathVertexToOutline(outlineShape, factory, fArray, n2);
                pathIterator.next();
            }
        }
        return arrayList;
    }

    private static void addPathVertexToOutline(OutlineShape outlineShape, Vertex.Factory<? extends Vertex> factory, float[] fArray, int n) {
        switch (n) {
            case 0: {
                outlineShape.closeLastOutline();
                outlineShape.addEmptyOutline();
                outlineShape.addVertex(0, factory.create(fArray, 0, 2, true));
                break;
            }
            case 1: {
                outlineShape.addVertex(0, factory.create(fArray, 0, 2, true));
                break;
            }
            case 2: {
                outlineShape.addVertex(0, factory.create(fArray, 0, 2, false));
                outlineShape.addVertex(0, factory.create(fArray, 2, 2, true));
                break;
            }
            case 3: {
                outlineShape.addVertex(0, factory.create(fArray, 0, 2, false));
                outlineShape.addVertex(0, factory.create(fArray, 2, 2, false));
                outlineShape.addVertex(0, factory.create(fArray, 4, 2, true));
                break;
            }
            case 4: {
                outlineShape.closeLastOutline();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled Segment Type: " + n);
            }
        }
    }

    public static Path2D buildPath(OTGlyph oTGlyph) {
        if (oTGlyph == null) {
            return null;
        }
        Path2D path2D = new Path2D();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < oTGlyph.getPointCount(); ++i) {
            ++n2;
            if (!oTGlyph.getPoint((int)i).endOfContour) continue;
            TypecastRenderer.addContourToPath(path2D, oTGlyph, n, n2);
            n = i + 1;
            n2 = 0;
        }
        return path2D;
    }

    private static void addContourToPath(Path2D path2D, OTGlyph oTGlyph, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            Point point = oTGlyph.getPoint(n + n3 % n2);
            Point point2 = oTGlyph.getPoint(n + (n3 + 1) % n2);
            Point point3 = oTGlyph.getPoint(n + (n3 + 2) % n2);
            if (n3 == 0) {
                path2D.moveTo(point.x, point.y);
            }
            if (point.onCurve) {
                if (point2.onCurve) {
                    path2D.lineTo(point2.x, point2.y);
                    ++n3;
                    continue;
                }
                if (point3.onCurve) {
                    path2D.quadTo(point2.x, point2.y, point3.x, point3.y);
                    n3 += 2;
                    continue;
                }
                path2D.quadTo(point2.x, point2.y, TypecastRenderer.midValue(point2.x, point3.x), TypecastRenderer.midValue(point2.y, point3.y));
                n3 += 2;
                continue;
            }
            if (point2.onCurve) {
                path2D.quadTo(point.x, point.y, point2.x, point2.y);
                ++n3;
                continue;
            }
            path2D.quadTo(point.x, point.y, TypecastRenderer.midValue(point.x, point2.x), TypecastRenderer.midValue(point.y, point2.y));
            ++n3;
        }
    }

    private static int midValue(int n, int n2) {
        return n + (n2 - n) / 2;
    }
}

