/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl;

import com.jogamp.common.GlueGenVersion;
import com.jogamp.common.jvm.JNILibLoaderBase;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.common.util.cache.TempJarCache;
import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveThreadGroupLock;
import com.jogamp.nativewindow.NativeWindowVersion;
import com.jogamp.opengl.JoglVersion;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import jogamp.opengl.Debug;
import jogamp.opengl.DesktopGLDynamicLookupHelper;
import jogamp.opengl.GLDrawableFactoryImpl;
import jogamp.opengl.GLDynamicLookupHelper;

public class GLProfile {
    public static final boolean DEBUG = Debug.debug("GLProfile");
    public static final String GL4bc = "GL4bc";
    public static final String GL4 = "GL4";
    public static final String GL3bc = "GL3bc";
    public static final String GL3 = "GL3";
    public static final String GL2 = "GL2";
    public static final String GLES1 = "GLES1";
    public static final String GLES2 = "GLES2";
    public static final String GL2ES1 = "GL2ES1";
    public static final String GL2ES2 = "GL2ES2";
    public static final String GL2GL3 = "GL2GL3";
    private static final String GL_DEFAULT = "GL_DEFAULT";
    public static final String[] GL_PROFILE_LIST_ALL;
    public static final String[] GL_PROFILE_LIST_MAX;
    public static final String[] GL_PROFILE_LIST_MIN;
    public static final String[] GL_PROFILE_LIST_MIN_DESKTOP;
    public static final String[] GL_PROFILE_LIST_MAX_FIXEDFUNC;
    public static final String[] GL_PROFILE_LIST_MAX_PROGSHADER;
    private static boolean isAWTAvailable;
    private static boolean hasDesktopGLFactory;
    private static boolean hasGL234Impl;
    private static boolean hasEGLFactory;
    private static boolean hasGLES2Impl;
    private static boolean hasGLES1Impl;
    private static GLDrawableFactoryImpl eglFactory;
    private static GLDrawableFactoryImpl desktopFactory;
    private static AbstractGraphicsDevice defaultDevice;
    private static AbstractGraphicsDevice defaultDesktopDevice;
    private static AbstractGraphicsDevice defaultEGLDevice;
    private static volatile boolean initialized;
    private static RecursiveThreadGroupLock initLock;
    private static HashMap<String, HashMap<String, GLProfile>> deviceConn2ProfileMap;
    private GLProfile profileImpl = null;
    private String profile = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initSingleton(final boolean bl) {
        initLock.lock();
        try {
            if (!initialized) {
                initialized = true;
                if (DEBUG) {
                    System.err.println("GLProfile.initSingleton(firstUIActionOnProcess: " + bl + ") - thread " + Thread.currentThread().getName());
                    Thread.dumpStack();
                }
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        Platform.initSingleton();
                        if (TempJarCache.isInitialized()) {
                            String[] stringArray = new String[]{"nativewindow", "jogl", null};
                            if (ReflectionUtil.isClassAvailable((String)"com.jogamp.newt.NewtFactory", (ClassLoader)GLProfile.class.getClassLoader())) {
                                stringArray[2] = "newt";
                            }
                            JNILibLoaderBase.addNativeJarLibs(GLProfile.class, (String)"jogl-all", (String[])stringArray);
                        }
                        GLProfile.initProfilesForDefaultDevices(bl);
                        return null;
                    }
                });
            }
        }
        finally {
            initLock.unlock();
        }
    }

    public static void initSingleton() {
        GLProfile.initSingleton(false);
    }

    public static void initProfiles(AbstractGraphicsDevice abstractGraphicsDevice) throws GLException {
        GLProfile.getProfileMap(abstractGraphicsDevice, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown(ShutdownType shutdownType) {
        initLock.lock();
        try {
            if (initialized) {
                initialized = false;
                if (DEBUG) {
                    System.err.println("GLProfile.shutdown(type: " + (Object)((Object)shutdownType) + ") - thread " + Thread.currentThread().getName());
                    Thread.dumpStack();
                }
                GLDrawableFactory.shutdown(shutdownType);
                if (ShutdownType.COMPLETE == shutdownType) {
                    GLContext.shutdown();
                }
                NativeWindowFactory.shutdown();
            }
        }
        finally {
            initLock.unlock();
        }
    }

    public static boolean isAvailable(AbstractGraphicsDevice abstractGraphicsDevice, String string) {
        GLProfile.initSingleton();
        return GLProfile.isAvailableImpl(GLProfile.getProfileMap(abstractGraphicsDevice, false), string);
    }

    private static boolean isAvailableImpl(HashMap<String, GLProfile> hashMap, String string) {
        return null != hashMap && null != hashMap.get(string);
    }

    public static boolean isAvailable(String string) {
        return GLProfile.isAvailable(null, string);
    }

    public static boolean isAnyAvailable() {
        return GLProfile.isAvailable(null, null);
    }

    public static String glAvailabilityToString(AbstractGraphicsDevice abstractGraphicsDevice) {
        StringBuffer stringBuffer = new StringBuffer();
        GLProfile.initSingleton();
        if (null == abstractGraphicsDevice) {
            abstractGraphicsDevice = defaultDevice;
        }
        HashMap<String, GLProfile> hashMap = GLProfile.getProfileMap(abstractGraphicsDevice, false);
        stringBuffer.append("GLAvailability[Native[GL4bc ");
        boolean bl = GLProfile.isAvailableImpl(hashMap, GL4bc);
        stringBuffer.append(bl);
        if (bl) {
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuffer, 4, 2);
        }
        stringBuffer.append(", GL4 ");
        bl = GLProfile.isAvailableImpl(hashMap, GL4);
        stringBuffer.append(bl);
        if (bl) {
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuffer, 4, 4);
        }
        stringBuffer.append(", GL3bc ");
        bl = GLProfile.isAvailableImpl(hashMap, GL3bc);
        stringBuffer.append(bl);
        if (bl) {
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuffer, 3, 2);
        }
        stringBuffer.append(", GL3 ");
        bl = GLProfile.isAvailableImpl(hashMap, GL3);
        stringBuffer.append(bl);
        if (bl) {
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuffer, 3, 4);
        }
        stringBuffer.append(", GL2 ");
        bl = GLProfile.isAvailableImpl(hashMap, GL2);
        stringBuffer.append(bl);
        if (bl) {
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuffer, 2, 2);
        }
        stringBuffer.append(", GL2ES1 ");
        stringBuffer.append(GLProfile.isAvailableImpl(hashMap, GL2ES1));
        stringBuffer.append(", GLES1 ");
        bl = GLProfile.isAvailableImpl(hashMap, GLES1);
        stringBuffer.append(bl);
        if (bl) {
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuffer, 1, 8);
        }
        stringBuffer.append(", GL2ES2 ");
        stringBuffer.append(GLProfile.isAvailableImpl(hashMap, GL2ES2));
        stringBuffer.append(", GLES2 ");
        bl = GLProfile.isAvailableImpl(hashMap, GLES2);
        stringBuffer.append(bl);
        if (bl) {
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuffer, 2, 8);
        }
        stringBuffer.append("], Profiles[");
        if (null != hashMap) {
            Iterator<GLProfile> iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString());
                stringBuffer.append(", ");
            }
            stringBuffer.append(", default ");
            try {
                stringBuffer.append(GLProfile.getDefault(abstractGraphicsDevice));
            }
            catch (GLException gLException) {
                stringBuffer.append("n/a");
            }
        }
        stringBuffer.append("]]");
        return stringBuffer.toString();
    }

    public static String glAvailabilityToString() {
        return GLProfile.glAvailabilityToString(null);
    }

    public static GLProfile getDefault(AbstractGraphicsDevice abstractGraphicsDevice) {
        GLProfile gLProfile = GLProfile.get(abstractGraphicsDevice, GL_DEFAULT);
        return gLProfile;
    }

    public static GLProfile getDefault() {
        return GLProfile.getDefault(defaultDevice);
    }

    public static GLProfile getMaximum(AbstractGraphicsDevice abstractGraphicsDevice) throws GLException {
        return GLProfile.get(abstractGraphicsDevice, GL_PROFILE_LIST_MAX);
    }

    public static GLProfile getMaximum() throws GLException {
        return GLProfile.get(GL_PROFILE_LIST_MAX);
    }

    public static GLProfile getMinimum(AbstractGraphicsDevice abstractGraphicsDevice) throws GLException {
        return GLProfile.get(abstractGraphicsDevice, GL_PROFILE_LIST_MIN);
    }

    public static GLProfile getMinimum() throws GLException {
        return GLProfile.get(GL_PROFILE_LIST_MIN);
    }

    public static GLProfile getMaxFixedFunc(AbstractGraphicsDevice abstractGraphicsDevice) throws GLException {
        return GLProfile.get(abstractGraphicsDevice, GL_PROFILE_LIST_MAX_FIXEDFUNC);
    }

    public static GLProfile getMaxFixedFunc() throws GLException {
        return GLProfile.get(GL_PROFILE_LIST_MAX_FIXEDFUNC);
    }

    public static GLProfile getMaxProgrammable(AbstractGraphicsDevice abstractGraphicsDevice) throws GLException {
        return GLProfile.get(abstractGraphicsDevice, GL_PROFILE_LIST_MAX_PROGSHADER);
    }

    public static GLProfile getMaxProgrammable() throws GLException {
        return GLProfile.get(GL_PROFILE_LIST_MAX_PROGSHADER);
    }

    public static GLProfile getGL2ES1(AbstractGraphicsDevice abstractGraphicsDevice) throws GLException {
        return GLProfile.get(abstractGraphicsDevice, GL2ES1).getImpl();
    }

    public static GLProfile getGL2ES1() throws GLException {
        return GLProfile.get(defaultDevice, GL2ES1).getImpl();
    }

    public static GLProfile getGL2ES2(AbstractGraphicsDevice abstractGraphicsDevice) throws GLException {
        return GLProfile.get(abstractGraphicsDevice, GL2ES2).getImpl();
    }

    public static GLProfile getGL2ES2() throws GLException {
        return GLProfile.get(defaultDevice, GL2ES2).getImpl();
    }

    public static GLProfile get(AbstractGraphicsDevice abstractGraphicsDevice, String string) throws GLException {
        HashMap<String, GLProfile> hashMap;
        GLProfile gLProfile;
        if (null == string || string.equals("GL")) {
            string = GL_DEFAULT;
        }
        if (null == (gLProfile = (hashMap = GLProfile.getProfileMap(abstractGraphicsDevice, true)).get(string))) {
            throw new GLException("Profile " + string + " is not available on " + abstractGraphicsDevice + ", but: " + hashMap.values());
        }
        return gLProfile;
    }

    public static GLProfile get(String string) throws GLException {
        return GLProfile.get(defaultDevice, string);
    }

    public static GLProfile get(AbstractGraphicsDevice abstractGraphicsDevice, String[] stringArray) throws GLException {
        HashMap<String, GLProfile> hashMap = GLProfile.getProfileMap(abstractGraphicsDevice, true);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            GLProfile gLProfile = hashMap.get(string);
            if (null == gLProfile) continue;
            return gLProfile;
        }
        throw new GLException("Profiles " + GLProfile.array2String(stringArray) + " not available on device " + abstractGraphicsDevice);
    }

    public static GLProfile get(String[] stringArray) throws GLException {
        return GLProfile.get(defaultDevice, stringArray);
    }

    public static boolean usesNativeGLES1(String string) {
        return GLES1.equals(string);
    }

    public static boolean usesNativeGLES2(String string) {
        return GLES2.equals(string);
    }

    public static boolean usesNativeGLES(String string) {
        return GLProfile.usesNativeGLES2(string) || GLProfile.usesNativeGLES1(string);
    }

    public static boolean isAWTAvailable() {
        return isAWTAvailable;
    }

    public static String getGLTypeName(int n) {
        switch (n) {
            case 5121: {
                return "GL_UNSIGNED_BYTE";
            }
            case 5120: {
                return "GL_BYTE";
            }
            case 5123: {
                return "GL_UNSIGNED_SHORT";
            }
            case 5122: {
                return "GL_SHORT";
            }
            case 5126: {
                return "GL_FLOAT";
            }
            case 5132: {
                return "GL_FIXED";
            }
            case 5124: {
                return "GL_INT";
            }
            case 5125: {
                return "GL_UNSIGNED_INT";
            }
            case 5130: {
                return "GL_DOUBLE";
            }
            case 5127: {
                return "GL_2_BYTES";
            }
            case 5128: {
                return "GL_3_BYTES";
            }
            case 5129: {
                return "GL_4_BYTES";
            }
        }
        return null;
    }

    public static String getGLArrayName(int n) {
        switch (n) {
            case 32884: {
                return "GL_VERTEX_ARRAY";
            }
            case 32885: {
                return "GL_NORMAL_ARRAY";
            }
            case 32886: {
                return "GL_COLOR_ARRAY";
            }
            case 32888: {
                return "GL_TEXTURE_COORD_ARRAY";
            }
        }
        return null;
    }

    public final String getGLImplBaseClassName() {
        return GLProfile.getGLImplBaseClassName(this.getImplName());
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof GLProfile) {
            GLProfile gLProfile = (GLProfile)object;
            return this.getName().equals(gLProfile.getName()) && this.getImplName().equals(gLProfile.getImplName());
        }
        return false;
    }

    public int hashCode() {
        int n = 5;
        n = 97 * n + this.getImplName().hashCode();
        n = 97 * n + this.getName().hashCode();
        return n;
    }

    public final void verifyEquality(GLProfile gLProfile) throws GLException {
        if (!this.equals(gLProfile)) {
            throw new GLException("GLProfiles are not equal: " + this + " != " + gLProfile);
        }
    }

    public final String getName() {
        return this.profile;
    }

    public final GLProfile getImpl() {
        return null != this.profileImpl ? this.profileImpl : this;
    }

    public final String getImplName() {
        return null != this.profileImpl ? this.profileImpl.getName() : this.getName();
    }

    public final boolean isGL4bc() {
        return GL4bc.equals(this.profile);
    }

    public final boolean isGL4() {
        return this.isGL4bc() || GL4.equals(this.profile);
    }

    public final boolean isGL3bc() {
        return this.isGL4bc() || GL3bc.equals(this.profile);
    }

    public final boolean isGL3() {
        return this.isGL4() || this.isGL3bc() || GL3.equals(this.profile);
    }

    public final boolean isGL2() {
        return this.isGL3bc() || GL2.equals(this.profile);
    }

    public final boolean isGLES1() {
        return GLES1.equals(this.profile);
    }

    public final boolean isGLES2() {
        return GLES2.equals(this.profile);
    }

    public final boolean isGL2ES1() {
        return GL2ES1.equals(this.profile) || this.isGL2() || this.isGLES1();
    }

    public final boolean isGL2ES2() {
        return GL2ES2.equals(this.profile) || this.isGL2() || this.isGL3() || this.isGLES2();
    }

    public final boolean isGL2GL3() {
        return GL2GL3.equals(this.profile) || this.isGL2() || this.isGL3();
    }

    public final boolean hasGLSL() {
        return this.isGL2ES2();
    }

    public final boolean usesNativeGLES1() {
        return GLES1.equals(this.getImplName());
    }

    public final boolean usesNativeGLES2() {
        return GLES2.equals(this.getImplName());
    }

    public final boolean usesNativeGLES() {
        return this.usesNativeGLES2() || this.usesNativeGLES1();
    }

    public boolean isValidDataType(int n, boolean bl) {
        switch (n) {
            case 5120: 
            case 5121: 
            case 5122: 
            case 5123: 
            case 5126: 
            case 5132: {
                return true;
            }
            case 5124: 
            case 5125: {
                if (this.isGL2ES2()) {
                    return true;
                }
            }
            case 5130: {
                if (this.isGL3()) {
                    return true;
                }
            }
            case 5127: 
            case 5128: 
            case 5129: {
                if (!this.isGL2()) break;
                return true;
            }
        }
        if (bl) {
            throw new GLException("Illegal data type on profile " + this + ": " + n);
        }
        return false;
    }

    public boolean isValidArrayDataType(int n, int n2, int n3, boolean bl, boolean bl2) {
        block82: {
            String string;
            block84: {
                block83: {
                    block81: {
                        string = GLProfile.getGLArrayName(n);
                        if (!this.isGLES1()) break block81;
                        if (bl) {
                            if (bl2) {
                                throw new GLException("Illegal array type for " + string + " on profile GLES1: VertexAttribPointer");
                            }
                            return false;
                        }
                        block0 : switch (n) {
                            case 32884: 
                            case 32888: {
                                switch (n3) {
                                    case 5120: 
                                    case 5122: 
                                    case 5126: 
                                    case 5132: {
                                        break;
                                    }
                                    default: {
                                        if (bl2) {
                                            throw new GLException("Illegal data type for " + string + " on profile GLES1: " + n3);
                                        }
                                        return false;
                                    }
                                }
                                switch (n2) {
                                    case 0: 
                                    case 2: 
                                    case 3: 
                                    case 4: {
                                        break block0;
                                    }
                                }
                                if (bl2) {
                                    throw new GLException("Illegal component number for " + string + " on profile GLES1: " + n2);
                                }
                                return false;
                            }
                            case 32885: {
                                switch (n3) {
                                    case 5120: 
                                    case 5122: 
                                    case 5126: 
                                    case 5132: {
                                        break;
                                    }
                                    default: {
                                        if (bl2) {
                                            throw new GLException("Illegal data type for " + string + " on profile GLES1: " + n3);
                                        }
                                        return false;
                                    }
                                }
                                switch (n2) {
                                    case 0: 
                                    case 3: {
                                        break block0;
                                    }
                                }
                                if (bl2) {
                                    throw new GLException("Illegal component number for " + string + " on profile GLES1: " + n2);
                                }
                                return false;
                            }
                            case 32886: {
                                switch (n3) {
                                    case 5121: 
                                    case 5126: 
                                    case 5132: {
                                        break;
                                    }
                                    default: {
                                        if (bl2) {
                                            throw new GLException("Illegal data type for " + string + " on profile GLES1: " + n3);
                                        }
                                        return false;
                                    }
                                }
                                switch (n2) {
                                    case 0: 
                                    case 4: {
                                        break block0;
                                    }
                                }
                                if (bl2) {
                                    throw new GLException("Illegal component number for " + string + " on profile GLES1: " + n2);
                                }
                                return false;
                            }
                        }
                        break block82;
                    }
                    if (!this.isGLES2()) break block83;
                    switch (n3) {
                        case 5120: 
                        case 5121: 
                        case 5122: 
                        case 5123: 
                        case 5126: 
                        case 5132: {
                            break block82;
                        }
                        default: {
                            if (bl2) {
                                throw new GLException("Illegal data type for " + string + " on profile GLES2: " + n3);
                            }
                            return false;
                        }
                    }
                }
                if (!this.isGL2ES2()) break block82;
                if (!bl) break block84;
                switch (n3) {
                    case 5120: 
                    case 5121: 
                    case 5122: 
                    case 5123: 
                    case 5124: 
                    case 5125: 
                    case 5126: 
                    case 5130: {
                        break;
                    }
                    default: {
                        if (bl2) {
                            throw new GLException("Illegal data type for " + string + " on profile GL2: " + n3);
                        }
                        return false;
                    }
                }
                switch (n2) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        break block82;
                    }
                    default: {
                        if (bl2) {
                            throw new GLException("Illegal component number for " + string + " on profile GL2: " + n2);
                        }
                        return false;
                    }
                }
            }
            block32 : switch (n) {
                case 32884: {
                    switch (n3) {
                        case 5122: 
                        case 5124: 
                        case 5126: 
                        case 5130: {
                            break;
                        }
                        default: {
                            if (bl2) {
                                throw new GLException("Illegal data type for " + string + " on profile GL2: " + n3);
                            }
                            return false;
                        }
                    }
                    switch (n2) {
                        case 0: 
                        case 2: 
                        case 3: 
                        case 4: {
                            break block32;
                        }
                    }
                    if (bl2) {
                        throw new GLException("Illegal component number for " + string + " on profile GL2: " + n2);
                    }
                    return false;
                }
                case 32885: {
                    switch (n3) {
                        case 5120: 
                        case 5122: 
                        case 5124: 
                        case 5126: 
                        case 5130: {
                            break;
                        }
                        default: {
                            if (bl2) {
                                throw new GLException("Illegal data type for " + string + " on profile GL2: " + n3);
                            }
                            return false;
                        }
                    }
                    switch (n2) {
                        case 0: 
                        case 3: {
                            break block32;
                        }
                    }
                    if (bl2) {
                        throw new GLException("Illegal component number for " + string + " on profile GLES1: " + n2);
                    }
                    return false;
                }
                case 32886: {
                    switch (n3) {
                        case 5120: 
                        case 5121: 
                        case 5122: 
                        case 5123: 
                        case 5124: 
                        case 5125: 
                        case 5126: 
                        case 5130: {
                            break;
                        }
                        default: {
                            if (bl2) {
                                throw new GLException("Illegal data type for " + string + " on profile GL2: " + n3);
                            }
                            return false;
                        }
                    }
                    switch (n2) {
                        case 0: 
                        case 3: 
                        case 4: {
                            break block32;
                        }
                    }
                    if (bl2) {
                        throw new GLException("Illegal component number for " + string + " on profile GL2: " + n2);
                    }
                    return false;
                }
                case 32888: {
                    switch (n3) {
                        case 5122: 
                        case 5124: 
                        case 5126: 
                        case 5130: {
                            break;
                        }
                        default: {
                            if (bl2) {
                                throw new GLException("Illegal data type for " + string + " on profile GL2: " + n3);
                            }
                            return false;
                        }
                    }
                    switch (n2) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            break block32;
                        }
                    }
                    if (bl2) {
                        throw new GLException("Illegal component number for " + string + " on profile GL2: " + n2);
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public String toString() {
        return "GLProfile[" + this.getName() + "/" + this.getImplName() + "]";
    }

    private static void initProfilesForDefaultDevices(boolean bl) {
        boolean bl2;
        GLDynamicLookupHelper gLDynamicLookupHelper;
        NativeWindowFactory.initSingleton(bl);
        if (DEBUG) {
            System.err.println("GLProfile.init firstUIActionOnProcess: " + bl + ", thread: " + Thread.currentThread().getName());
            System.err.println(VersionUtil.getPlatformInfo());
            System.err.println(GlueGenVersion.getInstance());
            System.err.println((Object)NativeWindowVersion.getInstance());
            System.err.println((Object)JoglVersion.getInstance());
        }
        ClassLoader classLoader = GLProfile.class.getClassLoader();
        isAWTAvailable = NativeWindowFactory.isAWTAvailable() && ReflectionUtil.isClassAvailable((String)"javax.media.opengl.awt.GLCanvas", (ClassLoader)classLoader);
        hasGL234Impl = ReflectionUtil.isClassAvailable((String)"jogamp.opengl.gl4.GL4bcImpl", (ClassLoader)classLoader);
        hasGLES1Impl = ReflectionUtil.isClassAvailable((String)"jogamp.opengl.es1.GLES1Impl", (ClassLoader)classLoader);
        hasGLES2Impl = ReflectionUtil.isClassAvailable((String)"jogamp.opengl.es2.GLES2Impl", (ClassLoader)classLoader);
        GLDrawableFactory.initSingleton();
        Throwable throwable = null;
        try {
            desktopFactory = (GLDrawableFactoryImpl)GLDrawableFactory.getFactoryImpl(GL2);
            if (null != desktopFactory && null != (gLDynamicLookupHelper = (DesktopGLDynamicLookupHelper)desktopFactory.getGLDynamicLookupHelper(0))) {
                hasDesktopGLFactory = gLDynamicLookupHelper.isLibComplete() && hasGL234Impl;
            }
        }
        catch (LinkageError linkageError) {
            throwable = linkageError;
        }
        catch (RuntimeException runtimeException) {
            throwable = runtimeException;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        if (DEBUG) {
            if (null != throwable) {
                throwable.printStackTrace();
            }
            if (null == desktopFactory) {
                System.err.println("Info: GLProfile.init - Desktop GLDrawable factory not available");
            }
        }
        if (null == desktopFactory) {
            hasDesktopGLFactory = false;
            hasGL234Impl = false;
        } else {
            defaultDevice = defaultDesktopDevice = desktopFactory.getDefaultDevice();
        }
        if (ReflectionUtil.isClassAvailable((String)"jogamp.opengl.egl.EGLDrawableFactory", (ClassLoader)classLoader)) {
            throwable = null;
            try {
                eglFactory = (GLDrawableFactoryImpl)GLDrawableFactory.getFactoryImpl(GLES2);
                if (null != eglFactory) {
                    hasEGLFactory = true;
                    gLDynamicLookupHelper = eglFactory.getGLDynamicLookupHelper(2);
                    if (null != gLDynamicLookupHelper) {
                        boolean bl3 = hasGLES2Impl = gLDynamicLookupHelper.isLibComplete() && hasGLES2Impl;
                    }
                    if (null != (gLDynamicLookupHelper = eglFactory.getGLDynamicLookupHelper(1))) {
                        hasGLES1Impl = gLDynamicLookupHelper.isLibComplete() && hasGLES1Impl;
                    }
                }
            }
            catch (LinkageError linkageError) {
                throwable = linkageError;
            }
            catch (SecurityException securityException) {
                throwable = securityException;
            }
            catch (NullPointerException nullPointerException) {
                throwable = nullPointerException;
            }
            catch (RuntimeException runtimeException) {
                throwable = runtimeException;
            }
            if (DEBUG) {
                if (null != throwable) {
                    throwable.printStackTrace();
                }
                if (null == eglFactory) {
                    System.err.println("Info: GLProfile.init - EGL GLDrawable factory not available");
                }
            }
        }
        if (null == eglFactory) {
            hasGLES2Impl = false;
            hasGLES1Impl = false;
        } else {
            defaultEGLDevice = eglFactory.getDefaultDevice();
            if (null == defaultDevice) {
                defaultDevice = defaultEGLDevice;
            }
        }
        boolean bl4 = GLProfile.initProfilesForDevice(defaultDesktopDevice);
        boolean bl5 = GLProfile.initProfilesForDevice(defaultEGLDevice);
        boolean bl6 = bl2 = bl4 || bl5;
        if (DEBUG) {
            System.err.println("GLProfile.init addedAnyProfile(d/e) " + bl2 + " (" + bl4 + "/" + bl5 + ")");
            System.err.println("GLProfile.init isAWTAvailable       " + isAWTAvailable);
            System.err.println("GLProfile.init hasDesktopGLFactory  " + hasDesktopGLFactory);
            System.err.println("GLProfile.init hasGL234Impl         " + hasGL234Impl);
            System.err.println("GLProfile.init hasEGLFactory        " + hasEGLFactory);
            System.err.println("GLProfile.init hasGLES1Impl         " + hasGLES1Impl);
            System.err.println("GLProfile.init hasGLES2Impl         " + hasGLES2Impl);
            System.err.println("GLProfile.init defaultDesktopDevice " + defaultDesktopDevice);
            System.err.println("GLProfile.init defaultEGLDevice     " + defaultEGLDevice);
            System.err.println("GLProfile.init defaultDevice        " + defaultDevice);
            System.err.println("GLProfile.init: " + GLProfile.array2String(GL_PROFILE_LIST_ALL) + ", " + GLProfile.glAvailabilityToString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean initProfilesForDevice(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (null == abstractGraphicsDevice) {
            return false;
        }
        initLock.lock();
        try {
            GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactoryImpl(abstractGraphicsDevice);
            gLDrawableFactory.enterThreadCriticalZone();
            try {
                boolean bl = GLProfile.initProfilesForDeviceCritical(abstractGraphicsDevice);
                gLDrawableFactory.leaveThreadCriticalZone();
                return bl;
            }
            catch (Throwable throwable) {
                gLDrawableFactory.leaveThreadCriticalZone();
                throw throwable;
            }
        }
        finally {
            initLock.unlock();
        }
    }

    private static boolean initProfilesForDeviceCritical(AbstractGraphicsDevice abstractGraphicsDevice) {
        boolean bl;
        boolean bl2;
        block21: {
            int n;
            List<GLCapabilitiesImmutable> list;
            block22: {
                boolean bl3 = GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice);
                if (DEBUG) {
                    String string = "Info: GLProfile.initProfilesForDevice: " + abstractGraphicsDevice + ", isSet " + bl3;
                    Throwable throwable = new Throwable(string);
                    throwable.printStackTrace();
                }
                if (bl3) {
                    return GLProfile.isAvailable(abstractGraphicsDevice, GL_DEFAULT);
                }
                bl2 = false;
                bl = false;
                boolean bl4 = false;
                boolean bl5 = false;
                if (hasDesktopGLFactory && (bl4 = desktopFactory.getIsDeviceCompatible(abstractGraphicsDevice))) {
                    GLProfile.computeProfileMap(abstractGraphicsDevice, true, true);
                    list = desktopFactory.getSharedResourceThread();
                    if (null != list) {
                        initLock.addOwner((Thread)((Object)list));
                    }
                    n = desktopFactory.createSharedResource(abstractGraphicsDevice);
                    if (null != list) {
                        initLock.removeOwner((Thread)((Object)list));
                    }
                    if (n == 0) {
                        hasDesktopGLFactory = false;
                    }
                    if (DEBUG) {
                        System.err.println("GLProfile.initProfilesForDevice: " + abstractGraphicsDevice + ": desktop Shared Ctx " + (n != 0));
                    }
                    if (hasDesktopGLFactory && null == GLContext.getAvailableGLVersion(abstractGraphicsDevice, 2, 2)) {
                        GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 2, 2, 1, 5, 34);
                    }
                    bl2 = GLProfile.computeProfileMap(abstractGraphicsDevice, false, false);
                } else if (hasEGLFactory && (hasGLES2Impl || hasGLES1Impl) && (bl5 = eglFactory.getIsDeviceCompatible(abstractGraphicsDevice))) {
                    GLProfile.computeProfileMap(abstractGraphicsDevice, false, true);
                    list = eglFactory.getSharedResourceThread();
                    if (null != list) {
                        initLock.addOwner((Thread)((Object)list));
                    }
                    n = eglFactory.createSharedResource(abstractGraphicsDevice);
                    if (null != list) {
                        initLock.removeOwner((Thread)((Object)list));
                    }
                    if (n == 0) {
                        hasEGLFactory = false;
                        hasGLES2Impl = false;
                        hasGLES1Impl = false;
                    }
                    if (DEBUG) {
                        System.err.println("GLProfile.initProfilesForDevice: " + abstractGraphicsDevice + ": egl Shared Ctx " + (n != 0));
                    }
                    if (hasGLES2Impl && null == GLContext.getAvailableGLVersion(abstractGraphicsDevice, 2, 8)) {
                        GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 2, 8, 2, 0, 40);
                    }
                    if (hasGLES1Impl && null == GLContext.getAvailableGLVersion(abstractGraphicsDevice, 1, 8)) {
                        GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 1, 8, 1, 0, 40);
                    }
                    bl = GLProfile.computeProfileMap(abstractGraphicsDevice, false, false);
                } else {
                    GLProfile.setProfileMap(abstractGraphicsDevice, new HashMap<String, GLProfile>());
                    if (DEBUG) {
                        System.err.println("GLProfile: device could not be initialized: " + abstractGraphicsDevice);
                        System.err.println("GLProfile: compatible w/ desktop: " + bl4 + ", egl " + bl5);
                        System.err.println("GLProfile: desktoplFactory      " + desktopFactory);
                        System.err.println("GLProfile: eglFactory           " + eglFactory);
                        System.err.println("GLProfile: hasGLES1Impl         " + hasGLES1Impl);
                        System.err.println("GLProfile: hasGLES2Impl         " + hasGLES2Impl);
                    }
                }
                if (!GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice)) {
                    GLContext.setAvailableGLVersionsSet(abstractGraphicsDevice);
                }
                if (!DEBUG) break block21;
                System.err.println("GLProfile.initProfilesForDevice: " + abstractGraphicsDevice.getConnection() + ": added profile(s): desktop " + bl2 + ", egl " + bl);
                System.err.println("GLProfile.initProfilesForDevice: " + abstractGraphicsDevice.getConnection() + ": " + GLProfile.glAvailabilityToString(abstractGraphicsDevice));
                if (!bl2) break block22;
                GLProfile.dumpGLInfo(desktopFactory, abstractGraphicsDevice);
                list = desktopFactory.getAvailableCapabilities(abstractGraphicsDevice);
                for (n = 0; n < list.size(); ++n) {
                    System.err.println(list.get(n));
                }
                break block21;
            }
            if (!bl) break block21;
            GLProfile.dumpGLInfo(eglFactory, abstractGraphicsDevice);
            list = eglFactory.getAvailableCapabilities(abstractGraphicsDevice);
            for (n = 0; n < list.size(); ++n) {
                System.err.println(list.get(n));
            }
        }
        return bl2 || bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpGLInfo(GLDrawableFactoryImpl gLDrawableFactoryImpl, AbstractGraphicsDevice abstractGraphicsDevice) {
        GLContext gLContext = gLDrawableFactoryImpl.getOrCreateSharedContext(abstractGraphicsDevice);
        if (null != gLContext) {
            System.err.println("GLProfile.dumpGLInfo: " + gLContext);
            gLContext.makeCurrent();
            try {
                System.err.println(JoglVersion.getGLInfo(gLContext.getGL(), null));
            }
            finally {
                gLContext.release();
            }
        } else {
            System.err.println("GLProfile.dumpGLInfo: shared context n/a");
        }
    }

    public static AbstractGraphicsDevice getDefaultDevice() {
        GLProfile.initSingleton();
        return defaultDevice;
    }

    public static AbstractGraphicsDevice getDefaultDesktopDevice() {
        GLProfile.initSingleton();
        return defaultDesktopDevice;
    }

    public static AbstractGraphicsDevice getDefaultEGLDevice() {
        GLProfile.initSingleton();
        return defaultEGLDevice;
    }

    private static String array2String(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private static void glAvailabilityToString(AbstractGraphicsDevice abstractGraphicsDevice, StringBuffer stringBuffer, int n, int n2) {
        String string = GLContext.getAvailableGLVersionAsString(abstractGraphicsDevice, n, n2);
        if (null == string) {
            throw new GLException("Internal Error");
        }
        stringBuffer.append("[");
        stringBuffer.append(string);
        stringBuffer.append("]");
    }

    private static boolean computeProfileMap(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, boolean bl2) {
        if (DEBUG) {
            System.err.println("GLProfile.init map " + abstractGraphicsDevice.getConnection() + ", desktopCtxUndef " + bl + ", esCtxUndef " + bl2);
        }
        GLProfile gLProfile = null;
        HashMap<String, GLProfile> hashMap = new HashMap<String, GLProfile>(GL_PROFILE_LIST_ALL.length + 1);
        for (int i = 0; i < GL_PROFILE_LIST_ALL.length; ++i) {
            String string = GL_PROFILE_LIST_ALL[i];
            String string2 = GLProfile.computeProfileImpl(abstractGraphicsDevice, string, bl, bl2);
            if (null != string2) {
                GLProfile gLProfile2;
                if (string.equals(string2)) {
                    gLProfile2 = new GLProfile(string, null);
                } else {
                    GLProfile gLProfile3 = hashMap.get(string2);
                    if (null == gLProfile3) {
                        throw new InternalError("XXX0");
                    }
                    gLProfile2 = new GLProfile(string, gLProfile3);
                }
                hashMap.put(string, gLProfile2);
                if (DEBUG) {
                    System.err.println("GLProfile.init map " + gLProfile2 + " on devide " + abstractGraphicsDevice.getConnection());
                }
                if (null != gLProfile) continue;
                gLProfile = gLProfile2;
                if (!DEBUG) continue;
                System.err.println("GLProfile.init map default " + gLProfile2 + " on device " + abstractGraphicsDevice.getConnection());
                continue;
            }
            if (!DEBUG) continue;
            System.err.println("GLProfile.init map *** no mapping for " + string + " on device " + abstractGraphicsDevice.getConnection());
        }
        if (null != gLProfile) {
            hashMap.put(GL_DEFAULT, gLProfile);
        }
        GLProfile.setProfileMap(abstractGraphicsDevice, hashMap);
        return hashMap.size() > 0;
    }

    private static String computeProfileImpl(AbstractGraphicsDevice abstractGraphicsDevice, String string, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = Platform.OS_TYPE == Platform.OSType.MACOS;
        if (GL2ES1.equals(string)) {
            if (hasGL234Impl) {
                if (GLContext.isGL4bcAvailable(abstractGraphicsDevice)) {
                    return GL4bc;
                }
                if (GLContext.isGL3bcAvailable(abstractGraphicsDevice)) {
                    return GL3bc;
                }
                if (bl || GLContext.isGL2Available(abstractGraphicsDevice)) {
                    return GL2;
                }
            }
            if (hasGLES1Impl && (bl2 || GLContext.isGLES1Available(abstractGraphicsDevice))) {
                return GLES1;
            }
        } else if (GL2ES2.equals(string)) {
            if (hasGL234Impl) {
                if (!bl3 && GLContext.isGL4bcAvailable(abstractGraphicsDevice)) {
                    return GL4bc;
                }
                if (!bl3 && GLContext.isGL4Available(abstractGraphicsDevice)) {
                    return GL4;
                }
                if (!bl3 && GLContext.isGL3bcAvailable(abstractGraphicsDevice)) {
                    return GL3bc;
                }
                if (!bl3 && GLContext.isGL3Available(abstractGraphicsDevice)) {
                    return GL3;
                }
                if (bl || GLContext.isGL2Available(abstractGraphicsDevice)) {
                    return GL2;
                }
            }
            if (hasGLES2Impl && (bl2 || GLContext.isGLES2Available(abstractGraphicsDevice))) {
                return GLES2;
            }
        } else if (GL2GL3.equals(string)) {
            if (hasGL234Impl) {
                if (!bl3 && GLContext.isGL4bcAvailable(abstractGraphicsDevice)) {
                    return GL4bc;
                }
                if (!bl3 && GLContext.isGL4Available(abstractGraphicsDevice)) {
                    return GL4;
                }
                if (!bl3 && GLContext.isGL3bcAvailable(abstractGraphicsDevice)) {
                    return GL3bc;
                }
                if (!bl3 && GLContext.isGL3Available(abstractGraphicsDevice)) {
                    return GL3;
                }
                if (bl || GLContext.isGL2Available(abstractGraphicsDevice)) {
                    return GL2;
                }
            }
        } else {
            if (GL4bc.equals(string) && hasGL234Impl && (bl || GLContext.isGL4bcAvailable(abstractGraphicsDevice))) {
                return GL4bc;
            }
            if (GL4.equals(string) && hasGL234Impl && (bl || GLContext.isGL4Available(abstractGraphicsDevice))) {
                return GL4;
            }
            if (GL3bc.equals(string) && hasGL234Impl && (bl || GLContext.isGL3bcAvailable(abstractGraphicsDevice))) {
                return GL3bc;
            }
            if (GL3.equals(string) && hasGL234Impl && (bl || GLContext.isGL3Available(abstractGraphicsDevice))) {
                return GL3;
            }
            if (GL2.equals(string) && hasGL234Impl && (bl || GLContext.isGL2Available(abstractGraphicsDevice))) {
                return GL2;
            }
            if (GLES2.equals(string) && hasGLES2Impl && (bl2 || GLContext.isGLES2Available(abstractGraphicsDevice))) {
                return GLES2;
            }
            if (GLES1.equals(string) && hasGLES1Impl && (bl2 || GLContext.isGLES1Available(abstractGraphicsDevice))) {
                return GLES1;
            }
        }
        return null;
    }

    private static String getGLImplBaseClassName(String string) {
        if (GL4bc.equals(string) || GL4.equals(string) || GL3bc.equals(string) || GL3.equals(string) || GL2.equals(string)) {
            return "jogamp.opengl.gl4.GL4bc";
        }
        if (GLES1.equals(string) || GL2ES1.equals(string)) {
            return "jogamp.opengl.es1.GLES1";
        }
        if (GLES2.equals(string) || GL2ES2.equals(string)) {
            return "jogamp.opengl.es2.GLES2";
        }
        throw new GLException("unsupported profile \"" + string + "\"");
    }

    private static HashMap<String, GLProfile> getProfileMap(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl) throws GLException {
        String string;
        HashMap<String, GLProfile> hashMap;
        GLProfile.initSingleton();
        if (null == abstractGraphicsDevice) {
            abstractGraphicsDevice = defaultDevice;
        }
        if (null != (hashMap = deviceConn2ProfileMap.get(string = abstractGraphicsDevice.getUniqueID()))) {
            return hashMap;
        }
        if (!GLProfile.initProfilesForDevice(abstractGraphicsDevice)) {
            if (bl) {
                throw new GLException("No Profile available for " + abstractGraphicsDevice);
            }
            return null;
        }
        hashMap = deviceConn2ProfileMap.get(string);
        if (null == hashMap && bl) {
            throw new InternalError("initProfilesForDevice(..) didn't setProfileMap(..) for " + abstractGraphicsDevice);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setProfileMap(AbstractGraphicsDevice abstractGraphicsDevice, HashMap<String, GLProfile> hashMap) {
        HashMap<String, HashMap<String, GLProfile>> hashMap2 = deviceConn2ProfileMap;
        synchronized (hashMap2) {
            deviceConn2ProfileMap.put(abstractGraphicsDevice.getUniqueID(), hashMap);
        }
    }

    private GLProfile(String string, GLProfile gLProfile) {
        this.profile = string;
        this.profileImpl = gLProfile;
    }

    static {
        Platform.initSingleton();
        GL_PROFILE_LIST_ALL = new String[]{GL4bc, GL3bc, GL2, GL4, GL3, GL2GL3, GLES2, GL2ES2, GLES1, GL2ES1};
        GL_PROFILE_LIST_MAX = new String[]{GL4bc, GL4, GL3bc, GL3, GL2, GLES2, GLES1};
        GL_PROFILE_LIST_MIN = new String[]{GLES1, GLES2, GL2, GL3, GL3bc, GL4, GL4bc};
        GL_PROFILE_LIST_MIN_DESKTOP = new String[]{GL2, GL3bc, GL4bc, GL3, GL4};
        GL_PROFILE_LIST_MAX_FIXEDFUNC = new String[]{GL4bc, GL3bc, GL2, GLES1};
        GL_PROFILE_LIST_MAX_PROGSHADER = new String[]{GL4bc, GL4, GL3bc, GL3, GL2, GLES2};
        initialized = false;
        initLock = LockFactory.createRecursiveThreadGroupLock();
        deviceConn2ProfileMap = new HashMap();
    }

    public static enum ShutdownType {
        SHARED_ONLY,
        COMPLETE;

    }
}

