/*
 * Decompiled with CFR 0.152.
 */
package javax.media.nativewindow.x11;

import javax.media.nativewindow.DefaultGraphicsDevice;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.ToolkitLock;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.nativewindow.x11.X11Util;

public class X11GraphicsDevice
extends DefaultGraphicsDevice
implements Cloneable {
    public static final boolean DEBUG = Debug.debug("GraphicsDevice");
    final boolean closeDisplay;

    public X11GraphicsDevice(String string, int n) {
        super("X11", string, n);
        this.closeDisplay = false;
    }

    public X11GraphicsDevice(long l, int n, boolean bl) {
        super("X11", X11Lib.XDisplayString(l), n, l);
        if (0L == l) {
            throw new NativeWindowException("null display");
        }
        this.closeDisplay = bl;
    }

    public X11GraphicsDevice(long l, int n, ToolkitLock toolkitLock, boolean bl) {
        super("X11", X11Lib.XDisplayString(l), n, l, toolkitLock);
        if (0L == l) {
            throw new NativeWindowException("null display");
        }
        this.closeDisplay = bl;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean close() {
        if (this.closeDisplay && 0L != this.handle) {
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - X11GraphicsDevice.close(): " + this);
            }
            X11Util.closeDisplay(this.handle);
        }
        return super.close();
    }
}

