/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.glsl.sdk;

import com.jogamp.common.util.IOUtil;
import com.jogamp.opengl.util.glsl.ShaderCode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import javax.media.opengl.GLException;

public abstract class CompileShader {
    public abstract int getBinaryFormat();

    public abstract File getSDKCompilerDir();

    public abstract String getVertexShaderCompiler();

    public abstract String getFragmentShaderCompiler();

    public void processOneShader(String string) throws IOException, UnsupportedEncodingException, InterruptedException {
        int n = -1;
        String string2 = null;
        int n2 = -1;
        if (string.endsWith(ShaderCode.getFileSuffix(false, 35632))) {
            n2 = 2;
            n = 35632;
        } else if (string.endsWith(".frag")) {
            n2 = 4;
            n = 35632;
        } else if (string.endsWith(ShaderCode.getFileSuffix(false, 35633))) {
            n2 = 2;
            n = 35633;
        } else if (string.endsWith(".vert")) {
            n2 = 4;
            n = 35633;
        }
        String string3 = CompileShader.basename(string);
        string2 = string3.substring(0, string3.length() - n2) + ShaderCode.getFileSuffix(true, n);
        URL uRL = IOUtil.getResource(null, (String)string);
        String string4 = CompileShader.dirname(uRL.getPath());
        string2 = string4 + File.separator + "bin" + File.separator + ShaderCode.getBinarySubPath(this.getBinaryFormat()) + File.separator + string2;
        this.processOneShader(string, string2, n);
    }

    public void processOneShader(String string, String string2, int n) throws IOException, UnsupportedEncodingException, InterruptedException {
        String string3;
        URL uRL = IOUtil.getResource(null, (String)string);
        String string4 = CompileShader.dirname(uRL.getPath());
        String string5 = ShaderCode.readShaderSource(null, string);
        if (null == string5) {
            System.err.println("Can't find shader source " + string + " - ignored");
            return;
        }
        System.err.println("Preprocessing: " + string + ", in dir: " + string4);
        String string6 = CompileShader.basename(string);
        switch (n) {
            case 35633: {
                string3 = this.getVertexShaderCompiler();
                break;
            }
            case 35632: {
                string3 = this.getFragmentShaderCompiler();
                break;
            }
            default: {
                throw new GLException("Unknown shader type: " + n);
            }
        }
        File file = new File(string2);
        File file2 = new File(string4 + File.separator + "tmp");
        file2.mkdirs();
        File file3 = new File(file2, string6);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file3));
        ((Writer)bufferedWriter).write(string5, 0, string5.length());
        ((Writer)bufferedWriter).flush();
        ((Writer)bufferedWriter).close();
        System.err.println("Preprocessed: " + file3.getAbsolutePath());
        File file4 = this.getSDKCompilerDir();
        System.err.println("SDK: " + file4.getAbsolutePath() + ", compiler: " + string3);
        System.err.println("Output: " + file.getAbsolutePath());
        Process process = Runtime.getRuntime().exec(new String[]{file4.getAbsolutePath() + File.separator + string3, file3.getAbsolutePath(), file.getAbsolutePath()});
        new StreamMonitor(process.getInputStream());
        new StreamMonitor(process.getErrorStream());
        process.waitFor();
    }

    protected static String basename(String string) {
        int n = string.lastIndexOf("/");
        if (n < 0) {
            n = string.lastIndexOf("\\");
        }
        String string2 = n < 0 ? string : string.substring(n + 1);
        return string2;
    }

    protected static String dirname(String string) {
        int n = string.lastIndexOf("/");
        if (n < 0) {
            n = string.lastIndexOf("\\");
        }
        String string2 = n < 0 ? new String() : string.substring(0, n + 1);
        return string2;
    }

    public void run(String[] stringArray) {
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                this.processOneShader(stringArray[i]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static class StreamMonitor
    implements Runnable {
        private InputStream istream;

        public StreamMonitor(InputStream inputStream) {
            this.istream = inputStream;
            new Thread((Runnable)this, "Output Reader Thread").start();
        }

        @Override
        public void run() {
            byte[] byArray = new byte[4096];
            try {
                int n = 0;
                do {
                    if ((n = this.istream.read(byArray)) <= 0) continue;
                    System.out.write(byArray, 0, n);
                    System.out.flush();
                } while (n >= 0);
            }
            catch (IOException iOException) {
                try {
                    this.istream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
        }
    }
}

