/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.nio.Buffers;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GLException;
import javax.media.opengl.fixedfunc.GLMatrixFunc;
import jogamp.opengl.ProjectFloat;

public class PMVMatrix
implements GLMatrixFunc {
    protected final float[] matrixBufferArray;
    private int nioBackupArraySupported = 0;
    private final String msgCantComputeInverse = "Invalid source Mv matrix, can't compute inverse";
    protected Buffer matrixBuffer;
    protected FloatBuffer matrixIdent;
    protected FloatBuffer matrixPMvMvit;
    protected FloatBuffer matrixPMvMvi;
    protected FloatBuffer matrixPMv;
    protected FloatBuffer matrixP;
    protected FloatBuffer matrixTex;
    protected FloatBuffer matrixMv;
    protected FloatBuffer matrixMvi;
    protected FloatBuffer matrixMvit;
    protected float[] matrixMult;
    protected float[] matrixTrans;
    protected float[] matrixRot;
    protected float[] matrixScale;
    protected float[] matrixOrtho;
    protected float[] matrixFrustum;
    protected float[] vec3f;
    protected List<float[]> matrixTStack;
    protected List<float[]> matrixPStack;
    protected List<float[]> matrixMvStack;
    protected int matrixMode = 5888;
    protected int modified = 0;
    protected int usesMviMvit = 0;
    protected ProjectFloat projectFloat = new ProjectFloat();
    public static final int DIRTY_MODELVIEW = 1;
    public static final int DIRTY_PROJECTION = 2;
    public static final int DIRTY_TEXTURE = 4;

    public PMVMatrix() {
        this(true);
    }

    public PMVMatrix(boolean bl) {
        if (bl) {
            this.matrixBufferArray = new float[96];
            this.matrixBuffer = null;
        } else {
            this.matrixBufferArray = null;
            this.matrixBuffer = Buffers.newDirectByteBuffer((int)384);
            this.matrixBuffer.mark();
        }
        this.matrixIdent = PMVMatrix.slice2Float(this.matrixBuffer, this.matrixBufferArray, 0, 16);
        this.matrixTex = PMVMatrix.slice2Float(this.matrixBuffer, this.matrixBufferArray, 16, 16);
        this.matrixPMvMvit = PMVMatrix.slice2Float(this.matrixBuffer, this.matrixBufferArray, 32, 64);
        this.matrixPMvMvi = PMVMatrix.slice2Float(this.matrixBuffer, this.matrixBufferArray, 32, 48);
        this.matrixPMv = PMVMatrix.slice2Float(this.matrixBuffer, this.matrixBufferArray, 32, 32);
        this.matrixP = PMVMatrix.slice2Float(this.matrixBuffer, this.matrixBufferArray, 32, 16);
        this.matrixMv = PMVMatrix.slice2Float(this.matrixBuffer, this.matrixBufferArray, 48, 16);
        this.matrixMvi = PMVMatrix.slice2Float(this.matrixBuffer, this.matrixBufferArray, 64, 16);
        this.matrixMvit = PMVMatrix.slice2Float(this.matrixBuffer, this.matrixBufferArray, 80, 16);
        if (null != this.matrixBuffer) {
            this.matrixBuffer.reset();
        }
        ProjectFloat.gluMakeIdentityf(this.matrixIdent);
        this.vec3f = new float[3];
        this.matrixMult = new float[16];
        this.matrixTrans = new float[16];
        this.matrixRot = new float[16];
        this.matrixScale = new float[16];
        this.matrixOrtho = new float[16];
        this.matrixFrustum = new float[16];
        ProjectFloat.gluMakeIdentityf(this.matrixTrans, 0);
        ProjectFloat.gluMakeIdentityf(this.matrixRot, 0);
        ProjectFloat.gluMakeIdentityf(this.matrixScale, 0);
        ProjectFloat.gluMakeIdentityf(this.matrixOrtho, 0);
        ProjectFloat.gluMakeZero(this.matrixFrustum, 0);
        this.matrixPStack = new ArrayList<float[]>();
        this.matrixMvStack = new ArrayList<float[]>();
        this.glMatrixMode(5889);
        this.glLoadIdentity();
        this.glMatrixMode(5888);
        this.glLoadIdentity();
        this.glMatrixMode(5890);
        this.glLoadIdentity();
        this.setDirty();
        this.update();
    }

    public void destroy() {
        if (null != this.projectFloat) {
            this.projectFloat.destroy();
            this.projectFloat = null;
        }
        this.matrixBuffer = null;
        this.matrixBuffer = null;
        this.matrixPMvMvit = null;
        this.matrixPMvMvi = null;
        this.matrixPMv = null;
        this.matrixP = null;
        this.matrixTex = null;
        this.matrixMv = null;
        this.matrixMvi = null;
        this.matrixMvit = null;
        this.vec3f = null;
        this.matrixMult = null;
        this.matrixTrans = null;
        this.matrixRot = null;
        this.matrixScale = null;
        this.matrixOrtho = null;
        this.matrixFrustum = null;
        if (null != this.matrixPStack) {
            this.matrixPStack.clear();
            this.matrixPStack = null;
        }
        if (null != this.matrixMvStack) {
            this.matrixMvStack.clear();
            this.matrixMvStack = null;
        }
        if (null != this.matrixPStack) {
            this.matrixPStack.clear();
            this.matrixPStack = null;
        }
        if (null != this.matrixTStack) {
            this.matrixTStack.clear();
            this.matrixTStack = null;
        }
    }

    private static FloatBuffer slice2Float(Buffer buffer, float[] fArray, int n, int n2) {
        if (buffer instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)buffer;
            byteBuffer.position(n * 4);
            byteBuffer.limit((n + n2) * 4);
            FloatBuffer floatBuffer = byteBuffer.slice().order(byteBuffer.order()).asFloatBuffer();
            floatBuffer.mark();
            return floatBuffer;
        }
        if (null != fArray) {
            FloatBuffer floatBuffer = FloatBuffer.wrap(fArray, n, n2);
            floatBuffer.mark();
            return floatBuffer;
        }
        if (buffer instanceof FloatBuffer) {
            FloatBuffer floatBuffer = (FloatBuffer)buffer;
            floatBuffer.position(n);
            floatBuffer.limit(n + n2);
            FloatBuffer floatBuffer2 = floatBuffer.slice();
            floatBuffer2.mark();
            return floatBuffer2;
        }
        throw new InternalError("XXX");
    }

    public static final boolean isMatrixModeName(int n) {
        switch (n) {
            case 2982: 
            case 2983: 
            case 2984: {
                return true;
            }
        }
        return false;
    }

    public static final int matrixModeName2MatrixGetName(int n) {
        switch (n) {
            case 5888: {
                return 2982;
            }
            case 5889: {
                return 2983;
            }
            case 5890: {
                return 2984;
            }
        }
        throw new GLException("unsupported matrixName: " + n);
    }

    public static final boolean isMatrixGetName(int n) {
        switch (n) {
            case 2976: 
            case 2982: 
            case 2983: 
            case 2984: {
                return true;
            }
        }
        return false;
    }

    public static final int matrixGetName2MatrixModeName(int n) {
        switch (n) {
            case 2982: {
                return 5888;
            }
            case 2983: {
                return 5889;
            }
            case 2984: {
                return 5890;
            }
        }
        throw new GLException("unsupported matrixGetName: " + n);
    }

    public void setDirty() {
        this.modified = 7;
        this.matrixMode = 5888;
    }

    public int getDirtyBits() {
        return this.modified;
    }

    public boolean isDirty(int n) {
        boolean bl;
        switch (n) {
            case 5888: {
                bl = (this.modified & 1) != 0;
                break;
            }
            case 5889: {
                bl = (this.modified & 2) != 0;
                break;
            }
            case 5890: {
                bl = (this.modified & 4) != 0;
                break;
            }
            default: {
                throw new GLException("unsupported matrixName: " + n);
            }
        }
        return bl;
    }

    public boolean isDirty() {
        return this.modified != 0;
    }

    public boolean update() {
        if (0 == this.modified) {
            return false;
        }
        int n = this.modified;
        if ((n & 1) != 0) {
            this.setMviMvit();
        }
        this.modified = 0;
        return n != 0;
    }

    public final int glGetMatrixMode() {
        return this.matrixMode;
    }

    public final FloatBuffer glGetTMatrixf() {
        return this.matrixTex;
    }

    public final FloatBuffer glGetPMatrixf() {
        return this.matrixP;
    }

    public final FloatBuffer glGetMvMatrixf() {
        return this.matrixMv;
    }

    public final FloatBuffer glGetPMvMviMatrixf() {
        this.usesMviMvit |= 1;
        return this.matrixPMvMvi;
    }

    public final FloatBuffer glGetPMvMatrixf() {
        return this.matrixPMv;
    }

    public final FloatBuffer glGetMviMatrixf() {
        this.usesMviMvit |= 1;
        return this.matrixMvi;
    }

    public final FloatBuffer glGetPMvMvitMatrixf() {
        this.usesMviMvit |= 3;
        return this.matrixPMvMvit;
    }

    public final FloatBuffer glGetMvitMatrixf() {
        this.usesMviMvit |= 3;
        return this.matrixMvit;
    }

    public final FloatBuffer glGetMatrixf() {
        return this.glGetMatrixf(this.matrixMode);
    }

    public final FloatBuffer glGetMatrixf(int n) {
        if (n == 5888) {
            return this.matrixMv;
        }
        if (n == 5889) {
            return this.matrixP;
        }
        if (n == 5890) {
            return this.matrixTex;
        }
        throw new GLException("unsupported matrixName: " + n);
    }

    public final void gluPerspective(float f, float f2, float f3, float f4) {
        float f5 = (float)Math.tan(f * (float)Math.PI / 360.0f) * f3;
        float f6 = -1.0f * f5;
        float f7 = f2 * f6;
        float f8 = f2 * f5;
        this.glFrustumf(f7, f8, f6, f5, f3, f4);
    }

    public static final void glMultMatrixf(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3) {
        int n = floatBuffer.position();
        int n2 = floatBuffer2.position();
        int n3 = floatBuffer3.position();
        for (int i = 0; i < 4; ++i) {
            float f = floatBuffer.get(n + i + 0);
            float f2 = floatBuffer.get(n + i + 4);
            float f3 = floatBuffer.get(n + i + 8);
            float f4 = floatBuffer.get(n + i + 12);
            floatBuffer3.put(n3 + i + 0, f * floatBuffer2.get(n2 + 0 + 0) + f2 * floatBuffer2.get(n2 + 1 + 0) + f3 * floatBuffer2.get(n2 + 2 + 0) + f4 * floatBuffer2.get(n2 + 3 + 0));
            floatBuffer3.put(n3 + i + 4, f * floatBuffer2.get(n2 + 0 + 4) + f2 * floatBuffer2.get(n2 + 1 + 4) + f3 * floatBuffer2.get(n2 + 2 + 4) + f4 * floatBuffer2.get(n2 + 3 + 4));
            floatBuffer3.put(n3 + i + 8, f * floatBuffer2.get(n2 + 0 + 8) + f2 * floatBuffer2.get(n2 + 1 + 8) + f3 * floatBuffer2.get(n2 + 2 + 8) + f4 * floatBuffer2.get(n2 + 3 + 8));
            floatBuffer3.put(n3 + i + 12, f * floatBuffer2.get(n2 + 0 + 12) + f2 * floatBuffer2.get(n2 + 1 + 12) + f3 * floatBuffer2.get(n2 + 2 + 12) + f4 * floatBuffer2.get(n2 + 3 + 12));
        }
    }

    public static final void glMultMatrixf(FloatBuffer floatBuffer, float[] fArray, int n, FloatBuffer floatBuffer2) {
        int n2 = floatBuffer.position();
        int n3 = floatBuffer2.position();
        for (int i = 0; i < 4; ++i) {
            float f = floatBuffer.get(n2 + i + 0);
            float f2 = floatBuffer.get(n2 + i + 4);
            float f3 = floatBuffer.get(n2 + i + 8);
            float f4 = floatBuffer.get(n2 + i + 12);
            floatBuffer2.put(n3 + i + 0, f * fArray[n + 0 + 0] + f2 * fArray[n + 1 + 0] + f3 * fArray[n + 2 + 0] + f4 * fArray[n + 3 + 0]);
            floatBuffer2.put(n3 + i + 4, f * fArray[n + 0 + 4] + f2 * fArray[n + 1 + 4] + f3 * fArray[n + 2 + 4] + f4 * fArray[n + 3 + 4]);
            floatBuffer2.put(n3 + i + 8, f * fArray[n + 0 + 8] + f2 * fArray[n + 1 + 8] + f3 * fArray[n + 2 + 8] + f4 * fArray[n + 3 + 8]);
            floatBuffer2.put(n3 + i + 12, f * fArray[n + 0 + 12] + f2 * fArray[n + 1 + 12] + f3 * fArray[n + 2 + 12] + f4 * fArray[n + 3 + 12]);
        }
    }

    @Override
    public void glMatrixMode(int n) {
        switch (n) {
            case 5888: 
            case 5889: 
            case 5890: {
                break;
            }
            default: {
                throw new GLException("unsupported matrixName: " + n);
            }
        }
        this.matrixMode = n;
    }

    @Override
    public void glGetFloatv(int n, FloatBuffer floatBuffer) {
        int n2 = floatBuffer.position();
        if (n == 2976) {
            floatBuffer.put(this.matrixMode);
        } else {
            FloatBuffer floatBuffer2 = this.glGetMatrixf(PMVMatrix.matrixGetName2MatrixModeName(n));
            floatBuffer.put(floatBuffer2);
            floatBuffer2.reset();
        }
        floatBuffer.position(n2);
    }

    @Override
    public void glGetFloatv(int n, float[] fArray, int n2) {
        if (n == 2976) {
            fArray[n2] = this.matrixMode;
        } else {
            FloatBuffer floatBuffer = this.glGetMatrixf(PMVMatrix.matrixGetName2MatrixModeName(n));
            floatBuffer.get(fArray, n2, 16);
            floatBuffer.reset();
        }
    }

    @Override
    public void glGetIntegerv(int n, IntBuffer intBuffer) {
        int n2 = intBuffer.position();
        if (n != 2976) {
            throw new GLException("unsupported pname: " + n);
        }
        intBuffer.put(this.matrixMode);
        intBuffer.position(n2);
    }

    @Override
    public void glGetIntegerv(int n, int[] nArray, int n2) {
        if (n != 2976) {
            throw new GLException("unsupported pname: " + n);
        }
        nArray[n2] = this.matrixMode;
    }

    @Override
    public final void glLoadMatrixf(float[] fArray, int n) {
        int n2 = fArray.length - n;
        if (this.matrixMode == 5888) {
            this.matrixMv.put(fArray, n, n2);
            this.matrixMv.reset();
            this.modified |= 1;
        } else if (this.matrixMode == 5889) {
            this.matrixP.put(fArray, n, n2);
            this.matrixP.reset();
            this.modified |= 2;
        } else if (this.matrixMode == 5890) {
            this.matrixTex.put(fArray, n, n2);
            this.matrixTex.reset();
            this.modified |= 4;
        }
    }

    @Override
    public final void glLoadMatrixf(FloatBuffer floatBuffer) {
        int n = floatBuffer.position();
        if (this.matrixMode == 5888) {
            this.matrixMv.put(floatBuffer);
            this.matrixMv.reset();
            this.modified |= 1;
        } else if (this.matrixMode == 5889) {
            this.matrixP.put(floatBuffer);
            this.matrixP.reset();
            this.modified |= 2;
        } else if (this.matrixMode == 5890) {
            this.matrixTex.put(floatBuffer);
            this.matrixTex.reset();
            this.modified |= 4;
        }
        floatBuffer.position(n);
    }

    @Override
    public final void glPopMatrix() {
        float[] fArray = null;
        if (this.matrixMode == 5888) {
            fArray = this.matrixMvStack.remove(0);
        } else if (this.matrixMode == 5889) {
            fArray = this.matrixPStack.remove(0);
        } else if (this.matrixMode == 5890) {
            fArray = this.matrixTStack.remove(0);
        }
        this.glLoadMatrixf(fArray, 0);
    }

    @Override
    public final void glPushMatrix() {
        float[] fArray = new float[16];
        if (this.matrixMode == 5888) {
            this.matrixMv.get(fArray);
            this.matrixMv.reset();
            this.matrixMvStack.add(0, fArray);
        } else if (this.matrixMode == 5889) {
            this.matrixP.get(fArray);
            this.matrixP.reset();
            this.matrixPStack.add(0, fArray);
        } else if (this.matrixMode == 5890) {
            this.matrixTex.get(fArray);
            this.matrixTex.reset();
            this.matrixTStack.add(0, fArray);
        }
    }

    @Override
    public final void glLoadIdentity() {
        if (this.matrixMode == 5888) {
            this.matrixMv.put(this.matrixIdent);
            this.matrixMv.reset();
            this.modified |= 1;
        } else if (this.matrixMode == 5889) {
            this.matrixP.put(this.matrixIdent);
            this.matrixP.reset();
            this.modified |= 2;
        } else if (this.matrixMode == 5890) {
            this.matrixTex.put(this.matrixIdent);
            this.matrixTex.reset();
            this.modified |= 4;
        }
        this.matrixIdent.reset();
    }

    @Override
    public final void glMultMatrixf(FloatBuffer floatBuffer) {
        if (this.matrixMode == 5888) {
            PMVMatrix.glMultMatrixf(this.matrixMv, floatBuffer, this.matrixMv);
            this.modified |= 1;
        } else if (this.matrixMode == 5889) {
            PMVMatrix.glMultMatrixf(this.matrixP, floatBuffer, this.matrixP);
            this.modified |= 2;
        } else if (this.matrixMode == 5890) {
            PMVMatrix.glMultMatrixf(this.matrixTex, floatBuffer, this.matrixTex);
            this.modified |= 4;
        }
    }

    @Override
    public void glMultMatrixf(float[] fArray, int n) {
        if (this.matrixMode == 5888) {
            PMVMatrix.glMultMatrixf(this.matrixMv, fArray, n, this.matrixMv);
            this.modified |= 1;
        } else if (this.matrixMode == 5889) {
            PMVMatrix.glMultMatrixf(this.matrixP, fArray, n, this.matrixP);
            this.modified |= 2;
        } else if (this.matrixMode == 5890) {
            PMVMatrix.glMultMatrixf(this.matrixTex, fArray, n, this.matrixTex);
            this.modified |= 4;
        }
    }

    @Override
    public final void glTranslatef(float f, float f2, float f3) {
        this.matrixTrans[12] = f;
        this.matrixTrans[13] = f2;
        this.matrixTrans[14] = f3;
        this.glMultMatrixf(this.matrixTrans, 0);
    }

    @Override
    public final void glRotatef(float f, float f2, float f3, float f4) {
        float f5 = f * (float)Math.PI / 180.0f;
        float f6 = (float)Math.cos(f5);
        float f7 = 1.0f - f6;
        float f8 = (float)Math.sin(f5);
        this.vec3f[0] = f2;
        this.vec3f[1] = f3;
        this.vec3f[2] = f4;
        ProjectFloat.normalize(this.vec3f);
        f2 = this.vec3f[0];
        f3 = this.vec3f[1];
        f4 = this.vec3f[2];
        float f9 = f2 * f3;
        float f10 = f2 * f4;
        float f11 = f2 * f8;
        float f12 = f3 * f8;
        float f13 = f3 * f4;
        float f14 = f4 * f8;
        this.matrixRot[0] = f2 * f2 * f7 + f6;
        this.matrixRot[1] = f9 * f7 + f14;
        this.matrixRot[2] = f10 * f7 - f12;
        this.matrixRot[4] = f9 * f7 - f14;
        this.matrixRot[5] = f3 * f3 * f7 + f6;
        this.matrixRot[6] = f13 * f7 + f11;
        this.matrixRot[8] = f10 * f7 + f12;
        this.matrixRot[9] = f13 * f7 - f11;
        this.matrixRot[10] = f4 * f4 * f7 + f6;
        this.glMultMatrixf(this.matrixRot, 0);
    }

    @Override
    public final void glScalef(float f, float f2, float f3) {
        this.matrixScale[0] = f;
        this.matrixScale[5] = f2;
        this.matrixScale[10] = f3;
        this.glMultMatrixf(this.matrixScale, 0);
    }

    @Override
    public final void glOrthof(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = f2 - f;
        float f8 = f4 - f3;
        float f9 = f6 - f5;
        float f10 = -1.0f * (f2 + f) / f7;
        float f11 = -1.0f * (f4 + f3) / f8;
        float f12 = -1.0f * (f6 + f5) / f9;
        this.matrixOrtho[0] = 2.0f / f7;
        this.matrixOrtho[5] = 2.0f / f8;
        this.matrixOrtho[10] = -2.0f / f9;
        this.matrixOrtho[12] = f10;
        this.matrixOrtho[13] = f11;
        this.matrixOrtho[14] = f12;
        this.glMultMatrixf(this.matrixOrtho, 0);
    }

    @Override
    public final void glFrustumf(float f, float f2, float f3, float f4, float f5, float f6) {
        if (f5 <= 0.0f || f6 < 0.0f) {
            throw new GLException("GL_INVALID_VALUE: zNear and zFar must be positive, and zNear>0");
        }
        if (f == f2 || f4 == f3) {
            throw new GLException("GL_INVALID_VALUE: top,bottom and left,right must not be equal");
        }
        float f7 = 2.0f * f5;
        float f8 = f2 - f;
        float f9 = f4 - f3;
        float f10 = f6 - f5;
        float f11 = (f2 + f) / f8;
        float f12 = (f4 + f3) / f9;
        float f13 = -1.0f * (f6 + f5) / f10;
        float f14 = -2.0f * (f6 * f5) / f10;
        this.matrixFrustum[0] = f7 / f8;
        this.matrixFrustum[5] = f7 / f9;
        this.matrixFrustum[10] = f13;
        this.matrixFrustum[8] = f11;
        this.matrixFrustum[9] = f12;
        this.matrixFrustum[14] = f14;
        this.matrixFrustum[11] = -1.0f;
        this.glMultMatrixf(this.matrixFrustum, 0);
    }

    private final void setMviMvit() {
        if (0 != (this.usesMviMvit & 1)) {
            if (this.nioBackupArraySupported >= 0) {
                try {
                    this.setMviMvitNIOBackupArray();
                    this.nioBackupArraySupported = 1;
                    return;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this.nioBackupArraySupported = -1;
                }
            }
            this.setMviMvitNIODirectAccess();
        }
    }

    private final void setMviMvitNIOBackupArray() {
        float[] fArray = this.matrixMvi.array();
        int n = this.matrixMvi.position();
        if (!this.projectFloat.gluInvertMatrixf(this.matrixMv.array(), this.matrixMv.position(), fArray, n)) {
            throw new GLException("Invalid source Mv matrix, can't compute inverse");
        }
        if (0 != (this.usesMviMvit & 2)) {
            float[] fArray2 = this.matrixMvit.array();
            int n2 = this.matrixMvit.position();
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    fArray2[n2 + j + i * 4] = fArray[n + i + j * 4];
                }
            }
        }
    }

    private final void setMviMvitNIODirectAccess() {
        if (!this.projectFloat.gluInvertMatrixf(this.matrixMv, this.matrixMvi)) {
            throw new GLException("Invalid source Mv matrix, can't compute inverse");
        }
        if (0 != (this.usesMviMvit & 2)) {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.matrixMvit.put(j + i * 4, this.matrixMvi.get(i + j * 4));
                }
            }
        }
    }
}

