/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.os.NativeLibrary;
import com.jogamp.common.util.IOUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import jogamp.common.Debug;

public class JarUtil {
    private static final boolean DEBUG = Debug.debug("JarUtil");

    public static String getJarBasename(String string, ClassLoader classLoader) throws IllegalArgumentException, IOException {
        URL uRL = IOUtil.getClassURL(string, classLoader);
        if (null != uRL) {
            String string2 = uRL.toExternalForm();
            if (DEBUG) {
                System.out.println("getJarName " + uRL + ", extForm: " + string2);
            }
            if (!string2.startsWith("jar:")) {
                throw new IllegalArgumentException("JAR URL doesn't start with 'jar:', got <" + string2 + ">");
            }
            int n = (string2 = string2.substring(4, string2.length())).lastIndexOf(33);
            if (0 > n) {
                throw new IllegalArgumentException("JAR URL does not contain jar url terminator '!', in <" + uRL.toExternalForm() + ">, got <" + string2 + ">");
            }
            string2 = string2.substring(0, n);
            n = string2.lastIndexOf(47);
            if (0 > n && 0 > (n = string2.lastIndexOf(58))) {
                throw new IllegalArgumentException("JAR URL does not contain protocol terminator ':', in <" + uRL.toExternalForm() + ">, got <" + string2 + ">");
            }
            if (0 >= (string2 = string2.substring(n + 1)).lastIndexOf(".jar")) {
                throw new IllegalArgumentException("No Jar name in <" + uRL.toExternalForm() + ">, got <" + string2 + ">");
            }
            if (DEBUG) {
                System.out.println("getJarName res: " + string2);
            }
            return string2;
        }
        return null;
    }

    public static URL getJarSubURL(String string, ClassLoader classLoader) throws IllegalArgumentException, IOException {
        URL uRL = IOUtil.getClassURL(string, classLoader);
        if (null != uRL) {
            String string2 = uRL.toExternalForm();
            if (DEBUG) {
                System.out.println("getJarSubURL " + uRL + ", extForm: " + string2);
            }
            if (!string2.startsWith("jar:")) {
                throw new IllegalArgumentException("JAR URL doesn't start with 'jar:', got <" + string2 + ">");
            }
            int n = (string2 = string2.substring(4, string2.length())).lastIndexOf(33);
            if (0 > n) {
                throw new IllegalArgumentException("JAR URL does not contain jar url terminator '!', url <" + string2 + ">");
            }
            string2 = string2.substring(0, n);
            if (0 >= string2.lastIndexOf(".jar")) {
                throw new IllegalArgumentException("No Jar name in <" + uRL.toExternalForm() + ">, got <" + string2 + ">");
            }
            if (DEBUG) {
                System.out.println("getJarSubURL res: " + string2);
            }
            return new URL(string2);
        }
        return null;
    }

    public static URL getJarFileURL(String string, ClassLoader classLoader) throws IllegalArgumentException, IOException {
        URL uRL = JarUtil.getJarSubURL(string, classLoader);
        if (null != uRL) {
            uRL = new URL("jar:" + uRL.toExternalForm() + "!/");
            if (DEBUG) {
                System.out.println("getJarFileURL res: " + uRL);
            }
            return uRL;
        }
        return null;
    }

    public static URL getURLDirname(URL uRL) throws IllegalArgumentException, IOException {
        int n;
        String string = uRL.toExternalForm();
        if (DEBUG) {
            System.out.println("getURLDirname " + uRL + ", extForm: " + string);
        }
        if (0 > (n = string.lastIndexOf(47)) && 0 > (n = string.lastIndexOf(58))) {
            throw new IllegalArgumentException("URL does not contain protocol terminator ':', in <" + uRL.toExternalForm() + ">, got <" + string + ">");
        }
        string = string.substring(0, n + 1);
        if (DEBUG) {
            System.out.println("getJarURLDirname res: " + string);
        }
        return new URL(string);
    }

    public static URL getJarFileURL(URL uRL, String string) throws IOException {
        if (null == string) {
            throw new IllegalArgumentException("jarFileName is null");
        }
        return new URL("jar:" + uRL.toExternalForm() + string + "!/");
    }

    public static URL getJarFileURL(URL uRL) throws IOException {
        if (null == uRL) {
            throw new IllegalArgumentException("jarSubUrl is null");
        }
        return new URL("jar:" + uRL.toExternalForm() + "!/");
    }

    public static URL getJarEntryURL(URL uRL, String string) throws IOException {
        if (null == string) {
            throw new IllegalArgumentException("jarEntry is null");
        }
        return new URL(uRL.toExternalForm() + string);
    }

    public static JarFile getJarFile(String string, ClassLoader classLoader) throws IOException {
        return JarUtil.getJarFile(JarUtil.getJarFileURL(string, classLoader), classLoader);
    }

    public static JarFile getJarFile(URL uRL, ClassLoader classLoader) throws IOException {
        URLConnection uRLConnection;
        if (DEBUG) {
            System.out.println("getJarFile: " + uRL);
        }
        if (null != uRL && (uRLConnection = uRL.openConnection()) instanceof JarURLConnection) {
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            JarFile jarFile = jarURLConnection.getJarFile();
            if (DEBUG) {
                System.out.println("getJarFile res: " + jarFile.getName());
            }
            return jarFile;
        }
        if (DEBUG) {
            System.out.println("getJarFile res: NULL");
        }
        return null;
    }

    public static Map<String, String> getNativeLibNames(JarFile jarFile) {
        if (DEBUG) {
            System.err.println("JarUtil: getNativeLibNames: " + jarFile);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string = jarEntry.getName();
            String string2 = NativeLibrary.isValidNativeLibraryName(string, false);
            if (null == string2) continue;
            hashMap.put(string2, string);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int extract(File file, Map<String, String> map, JarFile jarFile, boolean bl, boolean bl2, boolean bl3) throws IOException {
        if (DEBUG) {
            System.err.println("JarUtil: extract: " + jarFile.getName() + " -> " + file + ", extractNativeLibraries " + bl + ", extractClassFiles " + bl2 + ", extractOtherFiles " + bl3);
        }
        int n = 0;
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            boolean bl4;
            boolean bl5;
            JarEntry jarEntry = enumeration.nextElement();
            String string = jarEntry.getName();
            String string2 = NativeLibrary.isValidNativeLibraryName(string, false);
            boolean bl6 = bl5 = null != string2;
            if (bl5 && !bl) {
                if (!DEBUG) continue;
                System.err.println("JarUtil: JarEntry : " + string + " native-lib skipped");
                continue;
            }
            boolean bl7 = string.endsWith(".class");
            if (bl7 && !bl2) {
                if (!DEBUG) continue;
                System.err.println("JarUtil: JarEntry : " + string + " class-file skipped");
                continue;
            }
            if (!(bl5 || bl7 || bl3)) {
                if (!DEBUG) continue;
                System.err.println("JarUtil: JarEntry : " + string + " other-file skipped");
                continue;
            }
            boolean bl8 = string.endsWith("/");
            boolean bl9 = bl4 = string.indexOf(47) == -1 && string.indexOf(File.separatorChar) == -1;
            if (DEBUG) {
                System.err.println("JarUtil: JarEntry : isNativeLib " + bl5 + ", isClassFile " + bl7 + ", isDir " + bl8 + ", isRootEntry " + bl4);
            }
            File file2 = new File(file, string);
            if (bl8) {
                if (DEBUG) {
                    System.err.println("JarUtil: MKDIR: " + string + " -> " + file2);
                }
                file2.mkdir();
                continue;
            }
            File file3 = new File(file2.getParent());
            if (!file3.exists()) {
                if (DEBUG) {
                    System.err.println("JarUtil: MKDIR (parent): " + string + " -> " + file3);
                }
                file3.mkdir();
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(jarFile.getInputStream(jarEntry));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            int n2 = -1;
            try {
                n2 = IOUtil.copyStream2Stream(bufferedInputStream, bufferedOutputStream, -1);
            }
            finally {
                ((InputStream)bufferedInputStream).close();
                ((OutputStream)bufferedOutputStream).close();
            }
            boolean bl10 = false;
            if (n2 > 0) {
                ++n;
                if (bl5 && (bl4 || !map.containsKey(string2))) {
                    map.put(string2, file2.getAbsolutePath());
                    bl10 = true;
                }
            }
            if (!DEBUG) continue;
            System.err.println("JarUtil: EXTRACT[" + n + "]: [" + string2 + " -> ] " + string + " -> " + file2 + ": " + n2 + " bytes, addedAsNativeLib: " + bl10);
        }
        return n;
    }

    public static final void validateCertificates(Certificate[] certificateArray, JarFile jarFile) throws IOException, SecurityException {
        if (DEBUG) {
            System.err.println("JarUtil: validateCertificates: " + jarFile.getName());
        }
        if (certificateArray == null || certificateArray.length == 0) {
            throw new IllegalArgumentException("Null certificates passed");
        }
        byte[] byArray = new byte[1024];
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (jarEntry.isDirectory() || jarEntry.getName().startsWith("META-INF/")) continue;
            JarUtil.validateCertificate(certificateArray, jarFile, jarEntry, byArray);
        }
    }

    private static final void validateCertificate(Certificate[] certificateArray, JarFile jarFile, JarEntry jarEntry, byte[] byArray) throws IOException, SecurityException {
        if (DEBUG) {
            System.err.println("JarUtil: validate JarEntry : " + jarEntry.getName());
        }
        InputStream inputStream = jarFile.getInputStream(jarEntry);
        while (inputStream.read(byArray) > 0) {
        }
        inputStream.close();
        Certificate[] certificateArray2 = jarEntry.getCertificates();
        if (certificateArray2 == null || certificateArray2.length == 0) {
            throw new SecurityException("no certificate for " + jarEntry.getName() + " in " + jarFile.getName());
        }
        int n = 0;
        block1: for (int i = 0; i < certificateArray.length; ++i) {
            for (int j = 0; j < certificateArray2.length; ++j) {
                if (!certificateArray2[j].equals(certificateArray[i])) continue;
                ++n;
                continue block1;
            }
        }
        if (n != certificateArray.length) {
            throw new SecurityException("not all certificates match, only " + n + " out of " + certificateArray.length + " for " + jarEntry.getName() + " in " + jarFile.getName());
        }
    }
}

