/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.AndroidVersion;
import com.jogamp.common.os.MachineDescription;
import com.jogamp.common.os.Platform;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.security.AccessController;
import jogamp.common.Debug;
import jogamp.common.os.android.StaticContext;

public class IOUtil {
    private static final boolean DEBUG = Debug.isPropertyDefined("jogamp.debug.IOUtil", true, AccessController.getContext());

    private IOUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyURL2File(URL uRL, File file) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.connect();
        int n = 0;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            try {
                n = IOUtil.copyStream2Stream(bufferedInputStream, bufferedOutputStream, uRLConnection.getContentLength());
            }
            finally {
                ((OutputStream)bufferedOutputStream).close();
            }
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
        return n;
    }

    public static int copyStream2Stream(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[Platform.getMachineDescription().pageSizeInBytes()];
        int n3 = 0;
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
            n3 += n2;
        }
        return n3;
    }

    public static byte[] copyStream2ByteArray(InputStream inputStream) throws IOException {
        byte[] byArray;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        int n = 0;
        int n2 = inputStream.available();
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        do {
            if (n + n2 > byArray2.length) {
                byArray = new byte[n + n2];
                System.arraycopy(byArray2, 0, byArray, 0, n);
                byArray2 = byArray;
            }
            if ((n3 = inputStream.read(byArray2, n, n2)) < 0) continue;
            n += n3;
        } while ((n2 = inputStream.available()) > 0 && n3 >= 0);
        if (n != byArray2.length) {
            byArray = new byte[n];
            System.arraycopy(byArray2, 0, byArray, 0, n);
            byArray2 = byArray;
        }
        return byArray2;
    }

    public static ByteBuffer copyStream2ByteBuffer(InputStream inputStream) throws IOException {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        int n = inputStream.available();
        MachineDescription machineDescription = Platform.getMachineDescription();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(machineDescription.pageAlignedSize(n));
        byte[] byArray = new byte[machineDescription.pageSizeInBytes()];
        int n2 = Math.min(machineDescription.pageSizeInBytes(), n);
        int n3 = 0;
        do {
            if (n > byteBuffer.remaining()) {
                ByteBuffer byteBuffer2 = Buffers.newDirectByteBuffer(machineDescription.pageAlignedSize(byteBuffer.position() + n));
                byteBuffer2.put(byteBuffer);
                byteBuffer = byteBuffer2;
            }
            if ((n3 = inputStream.read(byArray, 0, n2)) >= 0) {
                byteBuffer.put(byArray, 0, n3);
            }
            n = inputStream.available();
            n2 = Math.min(machineDescription.pageSizeInBytes(), n);
        } while (n > 0 && n3 >= 0);
        byteBuffer.flip();
        return byteBuffer;
    }

    public static String slashify(String string, boolean bl, boolean bl2) {
        String string2 = string.replace('\\', '/');
        if (bl && !string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (bl2 && !string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        return string2;
    }

    public static URL toURL(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    public static URL toURLSimple(File file) throws MalformedURLException {
        return new URL("file", "", IOUtil.slashify(file.getAbsolutePath(), true, file.isDirectory()));
    }

    public static URL toURLSimple(String string, String string2, boolean bl) throws MalformedURLException {
        return new URL(string, "", IOUtil.slashify(string2, true, bl));
    }

    public static String getFileSuffix(File file) {
        return IOUtil.getFileSuffix(file.getName());
    }

    public static String getFileSuffix(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        return IOUtil.toLowerCase(string.substring(n + 1));
    }

    public static String getClassFileName(String string) throws IOException {
        return string.replace('.', '/') + ".class";
    }

    public static URL getClassURL(String string, ClassLoader classLoader) throws IOException {
        return classLoader.getResource(IOUtil.getClassFileName(string));
    }

    public static String getBasename(String string) {
        int n = (string = IOUtil.slashify(string, false, false)).lastIndexOf(47);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static String getDirname(String string) {
        int n = (string = IOUtil.slashify(string, false, false)).lastIndexOf(47);
        if (n >= 0) {
            string = string.substring(0, n + 1);
        }
        return string;
    }

    private static String toLowerCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase();
    }

    public static URL getResource(Class<?> clazz, String string) {
        if (null == string) {
            return null;
        }
        ClassLoader classLoader = null != clazz ? clazz.getClassLoader() : null;
        URL uRL = null;
        if (null != clazz) {
            String string2 = clazz.getName().replace('.', '/');
            int n = string2.lastIndexOf(47);
            if (n >= 0) {
                String string3 = string2.substring(0, n + 1) + string;
                uRL = IOUtil.getResource(string3, classLoader);
            }
            if (DEBUG) {
                System.err.println("IOUtil: found <" + string + "> within class package: " + (null != uRL));
            }
        } else if (DEBUG) {
            System.err.println("IOUtil: null context");
        }
        if (null == uRL) {
            uRL = IOUtil.getResource(string, classLoader);
            if (DEBUG) {
                System.err.println("IOUtil: found <" + string + "> by classloader: " + (null != uRL));
            }
        }
        return uRL;
    }

    public static URL getResource(String string, ClassLoader classLoader) {
        URL uRL;
        block13: {
            if (null == string) {
                return null;
            }
            if (DEBUG) {
                System.err.println("IOUtil: locating <" + string + ">, has cl: " + (null != classLoader));
            }
            uRL = null;
            if (classLoader != null && !IOUtil.urlExists(uRL = classLoader.getResource(string), "cl.getResource()")) {
                uRL = null;
            }
            if (null == uRL && !IOUtil.urlExists(uRL = ClassLoader.getSystemResource(string), "cl.getSystemResource()")) {
                uRL = null;
            }
            if (null == uRL) {
                try {
                    uRL = new URL(string);
                    if (!IOUtil.urlExists(uRL, "new URL()")) {
                        uRL = null;
                    }
                }
                catch (Throwable throwable) {
                    if (!DEBUG) break block13;
                    System.err.println("IOUtil: Catched Exception:");
                    throwable.printStackTrace();
                }
            }
        }
        if (null == uRL) {
            block14: {
                try {
                    File file = new File(string);
                    if (file.exists()) {
                        uRL = IOUtil.toURLSimple(file);
                    }
                }
                catch (Throwable throwable) {
                    if (!DEBUG) break block14;
                    System.err.println("IOUtil: Catched Exception:");
                    throwable.printStackTrace();
                }
            }
            if (DEBUG) {
                System.err.println("IOUtil: file.exists(" + string + ") - " + (null != uRL));
            }
        }
        return uRL;
    }

    public static String getRelativeOf(File file, String string) {
        if (null == string) {
            return null;
        }
        while (file != null && string.startsWith("../")) {
            file = file.getParentFile();
            string = string.substring(3);
        }
        if (file != null) {
            File file2 = new File(file, string);
            return IOUtil.slashify(file2.getPath(), false, false);
        }
        return null;
    }

    public static String getRelativeOf(URL uRL, String string) {
        String string2 = uRL.getPath();
        if (uRL.toString().startsWith("jar")) {
            try {
                JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
                string2 = jarURLConnection.getEntryName();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
        return IOUtil.getRelativeOf(new File(string2).getParentFile(), string);
    }

    public static boolean urlExists(URL uRL) {
        return IOUtil.urlExists(uRL, ".");
    }

    public static boolean urlExists(URL uRL, String string) {
        boolean bl;
        block6: {
            bl = false;
            if (null != uRL) {
                try {
                    uRL.openConnection();
                    bl = true;
                    if (DEBUG) {
                        System.err.println("IOUtil: urlExists(" + uRL + ") [" + string + "] - true");
                    }
                    break block6;
                }
                catch (IOException iOException) {
                    if (DEBUG) {
                        System.err.println("IOUtil: urlExists(" + uRL + ") [" + string + "] - false: " + iOException.getMessage());
                    }
                    break block6;
                }
            }
            if (DEBUG) {
                System.err.println("IOUtil: no url - urlExists(null) [" + string + "]");
            }
        }
        return bl;
    }

    public static File createTempFile(String string, String string2) throws IllegalArgumentException, IOException, SecurityException {
        return File.createTempFile(string, string2, IOUtil.getTempRoot());
    }

    public static File getTempRoot() throws SecurityException {
        Object object;
        if (AndroidVersion.isAvailable && null != (object = StaticContext.getContext())) {
            File file = object.getDir("temp", 1);
            if (DEBUG) {
                System.err.println("IOUtil.getTempRoot(Android): temp dir: " + file.getAbsolutePath());
            }
            return file;
        }
        object = System.getProperty("java.io.tmpdir");
        File file = new File((String)object);
        if (DEBUG) {
            System.err.println("IOUtil.getTempRoot(isAndroid: " + AndroidVersion.isAvailable + "): temp dir: " + file.getAbsolutePath());
        }
        return file;
    }

    public static File getTempDir(String string) throws IOException, SecurityException {
        File file = IOUtil.getTempRoot();
        for (int i = 0; i <= 999999; ++i) {
            String string2 = String.format("_%06d", i);
            File file2 = new File(file, string + string2);
            if (file2.isDirectory()) {
                if (!file2.canWrite()) continue;
                return file2;
            }
            file2.mkdir();
            if (!file2.isDirectory()) {
                throw new IOException("Cannot create temp base directory " + file2);
            }
            if (!file2.canWrite()) {
                throw new IOException("Cannot write to created temp base directory " + file2);
            }
            return file2;
        }
        throw new IOException("Could not create temp directory @ " + file.getAbsolutePath() + string + "_*");
    }
}

