/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.os;

import com.jogamp.common.jvm.JNILibLoaderBase;
import com.jogamp.common.os.DynamicLibraryBundleInfo;
import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.os.NativeLibrary;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class DynamicLibraryBundle
implements DynamicLookupHelper {
    protected static final boolean DEBUG = NativeLibrary.DEBUG;
    protected static final boolean DEBUG_LOOKUP = NativeLibrary.DEBUG_LOOKUP;
    private DynamicLibraryBundleInfo info;
    private List<List<String>> toolLibNames;
    private boolean[] toolLibLoaded;
    private int toolLibLoadedNumber;
    protected List<NativeLibrary> nativeLibraries;
    private List<String> glueLibNames;
    private boolean[] glueLibLoaded;
    private int glueLibLoadedNumber;
    private long toolGetProcAddressHandle;
    private HashSet<String> toolGetProcAddressFuncNameSet;
    private List<String> toolGetProcAddressFuncNameList;

    public DynamicLibraryBundle(DynamicLibraryBundleInfo dynamicLibraryBundleInfo) {
        if (null == dynamicLibraryBundleInfo) {
            throw new RuntimeException("Null DynamicLibraryBundleInfo");
        }
        this.info = dynamicLibraryBundleInfo;
        if (DEBUG) {
            System.err.println(Thread.currentThread().getName() + " - DynamicLibraryBundle.init start with: " + dynamicLibraryBundleInfo.getClass().getName());
            Thread.dumpStack();
        }
        this.nativeLibraries = new ArrayList<NativeLibrary>();
        this.toolLibNames = dynamicLibraryBundleInfo.getToolLibNames();
        this.glueLibNames = dynamicLibraryBundleInfo.getGlueLibNames();
        this.loadLibraries();
        this.toolGetProcAddressFuncNameList = dynamicLibraryBundleInfo.getToolGetProcAddressFuncNameList();
        if (null != this.toolGetProcAddressFuncNameList) {
            this.toolGetProcAddressFuncNameSet = new HashSet<String>(this.toolGetProcAddressFuncNameList);
            this.toolGetProcAddressHandle = this.getToolGetProcAddressHandle();
        } else {
            this.toolGetProcAddressFuncNameSet = new HashSet();
            this.toolGetProcAddressHandle = 0L;
        }
        if (DEBUG) {
            System.err.println("DynamicLibraryBundle.init Summary: " + dynamicLibraryBundleInfo.getClass().getName());
            System.err.println("     toolGetProcAddressFuncNameList: " + this.toolGetProcAddressFuncNameList);
            System.err.println("     Tool Lib Names : " + this.toolLibNames);
            System.err.println("     Tool Lib Loaded: " + this.getToolLibLoadedNumber() + "/" + this.getToolLibNumber() + " " + Arrays.toString(this.toolLibLoaded) + ", complete " + this.isToolLibComplete());
            System.err.println("     Glue Lib Names : " + this.glueLibNames);
            System.err.println("     Glue Lib Loaded: " + this.getGlueLibLoadedNumber() + "/" + this.getGlueLibNumber() + " " + Arrays.toString(this.glueLibLoaded) + ", complete " + this.isGlueLibComplete());
            System.err.println("     All Complete: " + this.isLibComplete());
        }
    }

    public void destroy() {
        if (DEBUG) {
            System.err.println(Thread.currentThread().getName() + " - DynamicLibraryBundle.destroy() START: " + this.info.getClass().getName());
        }
        this.toolGetProcAddressFuncNameSet = null;
        this.toolGetProcAddressHandle = 0L;
        for (int i = 0; i < this.nativeLibraries.size(); ++i) {
            this.nativeLibraries.get(i).close();
        }
        this.nativeLibraries.clear();
        this.nativeLibraries = null;
        this.toolLibNames = null;
        this.glueLibNames = null;
        if (DEBUG) {
            System.err.println(Thread.currentThread().getName() + " - DynamicLibraryBundle.destroy() END: " + this.info.getClass().getName());
        }
        this.info = null;
    }

    public final boolean isLibComplete() {
        return this.isToolLibComplete() && this.isGlueLibComplete();
    }

    public final int getToolLibNumber() {
        return this.toolLibNames.size();
    }

    public final int getToolLibLoadedNumber() {
        return this.toolLibLoadedNumber;
    }

    public final boolean isToolLibComplete() {
        return this.getToolLibNumber() == this.getToolLibLoadedNumber();
    }

    public final boolean isToolLibLoaded() {
        return 0 < this.toolLibLoadedNumber;
    }

    public final boolean isToolLibLoaded(int n) {
        if (0 <= n && n < this.toolLibLoaded.length) {
            return this.toolLibLoaded[n];
        }
        return false;
    }

    public final int getGlueLibNumber() {
        return this.glueLibNames.size();
    }

    public final int getGlueLibLoadedNumber() {
        return this.glueLibLoadedNumber;
    }

    public final boolean isGlueLibComplete() {
        return this.isGlueLibLoaded(this.getGlueLibNumber() - 1);
    }

    public final boolean isGlueLibLoaded(int n) {
        if (0 <= n && n < this.glueLibLoaded.length) {
            return this.glueLibLoaded[n];
        }
        return false;
    }

    public final DynamicLibraryBundleInfo getBundleInfo() {
        return this.info;
    }

    protected long getToolGetProcAddressHandle() {
        if (!this.isToolLibLoaded()) {
            return 0L;
        }
        long l = 0L;
        for (int i = 0; i < this.toolGetProcAddressFuncNameList.size(); ++i) {
            String string = this.toolGetProcAddressFuncNameList.get(i);
            l = this.dynamicLookupFunctionOnLibs(string);
            if (!DEBUG) continue;
            System.err.println("getToolGetProcAddressHandle: " + string + " -> 0x" + Long.toHexString(l));
        }
        return l;
    }

    protected NativeLibrary loadFirstAvailable(List<String> list, ClassLoader classLoader, boolean bl) {
        for (int i = 0; i < list.size(); ++i) {
            NativeLibrary nativeLibrary = NativeLibrary.open(list.get(i), classLoader, bl);
            if (nativeLibrary == null) continue;
            return nativeLibrary;
        }
        return null;
    }

    private void loadLibraries() {
        List<String> list;
        int n;
        if (null == this.toolLibNames || this.toolLibNames.size() == 0) {
            if (DEBUG) {
                System.err.println("No Tool native library names given");
            }
            return;
        }
        if (null == this.glueLibNames || this.glueLibNames.size() == 0) {
            if (DEBUG) {
                System.err.println("No Glue native library names given");
            }
            return;
        }
        this.toolLibLoadedNumber = 0;
        this.toolLibLoaded = new boolean[this.toolLibNames.size()];
        for (n = 0; n < this.toolLibNames.size(); ++n) {
            this.toolLibLoaded[n] = false;
        }
        this.glueLibLoaded = new boolean[this.glueLibNames.size()];
        for (n = 0; n < this.glueLibNames.size(); ++n) {
            this.glueLibLoaded[n] = false;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        NativeLibrary nativeLibrary = null;
        for (n = 0; n < this.toolLibNames.size(); ++n) {
            list = this.toolLibNames.get(n);
            if (null == list || list.size() <= 0) continue;
            nativeLibrary = this.loadFirstAvailable(list, classLoader, this.info.shallLinkGlobal());
            if (null == nativeLibrary) {
                if (!DEBUG) continue;
                System.err.println("Unable to load any Tool library of: " + list);
                continue;
            }
            this.nativeLibraries.add(nativeLibrary);
            this.toolLibLoaded[n] = true;
            ++this.toolLibLoadedNumber;
            if (!DEBUG) continue;
            System.err.println("Loaded Tool library: " + nativeLibrary);
        }
        if (!this.isToolLibLoaded()) {
            if (DEBUG) {
                System.err.println("No Tool libraries loaded");
            }
            return;
        }
        this.glueLibLoadedNumber = 0;
        for (n = 0; n < this.glueLibNames.size(); ++n) {
            boolean bl;
            block14: {
                list = this.glueLibNames.get(n);
                boolean bl2 = true;
                try {
                    bl = GlueJNILibLoader.loadLibrary((String)((Object)list), bl2);
                    if (DEBUG && !bl) {
                        System.err.println("Info: Could not load JNI/Glue library: " + (String)((Object)list));
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    bl = false;
                    if (!DEBUG) break block14;
                    System.err.println("Unable to load JNI/Glue library: " + (String)((Object)list));
                    unsatisfiedLinkError.printStackTrace();
                }
            }
            this.glueLibLoaded[n] = bl;
            if (!bl) continue;
            ++this.glueLibLoadedNumber;
        }
    }

    private long dynamicLookupFunctionOnLibs(String string) {
        if (!this.isToolLibLoaded() || null == string) {
            if (DEBUG_LOOKUP && !this.isToolLibLoaded()) {
                System.err.println("Lookup-Native: <" + string + "> ** FAILED ** Tool native library not loaded");
            }
            return 0L;
        }
        long l = 0L;
        NativeLibrary nativeLibrary = null;
        if (this.info.shallLookupGlobal()) {
            l = NativeLibrary.dynamicLookupFunctionGlobal(string);
        }
        for (int i = 0; 0L == l && i < this.nativeLibraries.size(); ++i) {
            nativeLibrary = this.nativeLibraries.get(i);
            l = nativeLibrary.dynamicLookupFunction(string);
        }
        if (DEBUG_LOOKUP) {
            String string2;
            String string3 = string2 = null == nativeLibrary ? "GLOBAL" : nativeLibrary.toString();
            if (0L != l) {
                System.err.println("Lookup-Native: <" + string + "> 0x" + Long.toHexString(l) + " in lib " + string2);
            } else {
                System.err.println("Lookup-Native: <" + string + "> ** FAILED ** in libs " + this.nativeLibraries);
            }
        }
        return l;
    }

    private long toolDynamicLookupFunction(String string) {
        if (0L != this.toolGetProcAddressHandle) {
            long l = this.info.toolGetProcAddress(this.toolGetProcAddressHandle, string);
            if (DEBUG_LOOKUP && 0L != l) {
                System.err.println("Lookup-Tool: <" + string + "> 0x" + Long.toHexString(l));
            }
            return l;
        }
        return 0L;
    }

    @Override
    public long dynamicLookupFunction(String string) {
        if (!this.isToolLibLoaded() || null == string) {
            if (DEBUG_LOOKUP && !this.isToolLibLoaded()) {
                System.err.println("Lookup: <" + string + "> ** FAILED ** Tool native library not loaded");
            }
            return 0L;
        }
        if (this.toolGetProcAddressFuncNameSet.contains(string)) {
            return this.toolGetProcAddressHandle;
        }
        long l = 0L;
        boolean bl = this.info.useToolGetProcAdressFirst(string);
        if (bl) {
            l = this.toolDynamicLookupFunction(string);
        }
        if (0L == l) {
            l = this.dynamicLookupFunctionOnLibs(string);
        }
        if (0L == l && !bl) {
            l = this.toolDynamicLookupFunction(string);
        }
        return l;
    }

    static class GlueJNILibLoader
    extends JNILibLoaderBase {
        GlueJNILibLoader() {
        }

        protected static synchronized boolean loadLibrary(String string, boolean bl) {
            return JNILibLoaderBase.loadLibrary(string, bl);
        }
    }
}

