//VERTEX
#version 330

uniform mat4 u_ViewMatrix;
uniform mat4 u_ProjectionMatrix;
uniform mat4 u_ObjectLocalMatrix;

uniform mat4 u_JointMatrix[40];
uniform mat4 u_BindPoseMatrix[40];

in layout(location = 0) vec3 Vertex;
in layout(location = 1) vec3 Normal;
in layout(location = 2) vec2 UV;

out vec3 color_vertex;
out vec3 color_normal;

void main()
{
	gl_Position = u_ProjectionMatrix * u_ViewMatrix * u_ObjectLocalMatrix * vec4(Vertex,1.0);
	color_normal = Normal;
	color_vertex = Vertex;
}



//FRAGMENT
#version 330
#extension GL_ARB_separate_shader_objects : enable

in vec3 color_vertex;
in vec3 color_normal;

out layout(location = 0) vec4 color;
out layout(location = 1) vec4 position;
out layout(location = 2) vec4 normal;

void main() {
	color = vec4(1.0,0.5,0.0,1.0);
	position = vec4(color_vertex,1.0);
	normal = vec4(color_normal,1.0);
}

//END
