//VERTEX
#version 330

uniform mat4 u_ViewMatrix;
uniform mat4 u_ProjectionMatrix;
uniform mat4 u_ObjectLocalMatrix;

uniform mat4 u_JointMatrix[40];
uniform mat4 u_BindPoseMatrix[40];

in layout(location = 0) vec3 Vertex;
in layout(location = 1) vec3 Normal;
in layout(location = 2) vec2 UV;

out vec3 color_vertex;
out vec3 color_normal;
out vec2 uv;

void main()
{
	gl_Position = u_ProjectionMatrix * u_ViewMatrix * u_ObjectLocalMatrix * vec4(Vertex,1.0);
	uv = UV;
	color_normal = Normal;
	color_vertex = Vertex;
}



//FRAGMENT
#version 330
#extension GL_ARB_separate_shader_objects : enable

in vec3 color_vertex;
in vec3 color_normal;

uniform sampler2D texture;

uniform vec2 u_Resolution;
uniform float u_Timer;

out layout(location = 0) vec4 color;
out layout(location = 1) vec4 position;
out layout(location = 2) vec4 normal;

in vec2 uv;

void main() {

	vec2 zoom = uv;

	zoom.x += sin(u_Timer * zoom.y + zoom.x) * zoom.y * zoom.x * 0.1;


	color = vec4(texture2D(texture,zoom).xyz,1.0) * 10.0;

	color.xyz += vec3(0.2);
	color.a = 1.0;

	position = vec4(color_vertex,1.0);
	normal = vec4(color_normal,1.0);
}

//END
