//VERTEX

#version 330

in layout(location = 0) vec3 Vertex;
in layout(location = 2) vec2 Uv;

out vec2 uv;

void main()
{
	uv = Uv;
	gl_Position = vec4(Vertex,1.0);
}

//FRAGMENT

#version 330
#extension GL_ARB_shading_language_420pack : enable

float noise(vec2 pos,float seed) {
	float ret = fract(sin(seed+dot(pos,vec2(12.9898,78.233)))*43758.5453)*2.0-0.8;
	return ret;
}

layout(binding=0) uniform sampler2D diffuseMap;
layout(binding=1) uniform sampler2D vertexMap;
layout(binding=2) uniform sampler2D normalMap;


uniform float u_Timer;
uniform vec2 u_Resolution;

out vec3 Color;
in vec2 uv;

const float totStrength = 1.38;
const float strength = 0.00003;
const float offset = 180.0;
const float falloff = 0.001;
const float rad = 0.01;
#define SAMPLES 10;
const float invSamples = -1.38/10.0;

const float zFar = 50.0;

void main()
{
	//lolz big array
	vec3 pSphere[10] = vec3[](vec3(-0.010735935, 0.01647018, 0.0062425877),vec3(-0.06533369, 0.3647007, -0.13746321),vec3(-0.6539235, -0.016726388, -0.53000957),vec3(0.40958285, 0.0052428036, -0.5591124),vec3(-0.1465366, 0.09899267, 0.15571679),vec3(-0.44122112, -0.5458797, 0.04912532),vec3(0.03755566, -0.10961345, -0.33040273),vec3(0.019100213, 0.29652783, 0.066237666),vec3(0.8765323, 0.011236004, 0.28265962),vec3(0.29264435, -0.40794238, 0.15964167));


	vec3 ReflectNormal;

	ReflectNormal.x = noise(uv*180.0,1232.0)*2.0;
	ReflectNormal.y = noise(uv*180.0,12431.0)*2.0;
	ReflectNormal.z = noise(uv*180.0,12122.0)*2.0;

	ReflectNormal = normalize(ReflectNormal);

	vec3 InNormal = texture2D(normalMap,uv).xyz;
	
	float Depth = texture2D(vertexMap,uv).y/zFar;

	float radD = rad/Depth;

	vec3 FragCoord3D = vec3(uv,Depth);


	float OccluderDepth,DepthDifference;
	vec4 OccluderFragment;
	vec3 Ray;
	float bl = 0.0;
	int i;

	for(i=0;i<10;i++)
	{
		Ray = radD*reflect(pSphere[i],ReflectNormal);

		OccluderFragment = texture2D(normalMap,uv + sign(dot(Ray,InNormal))*Ray.xy);
		float OccluderDepth = texture2D(vertexMap,uv + sign(dot(Ray,InNormal))*Ray.xy).y;

		DepthDifference = Depth - (OccluderDepth/zFar);

		bl += step(falloff,DepthDifference)*(1.0-dot(OccluderFragment.xyz,InNormal))*(1.0-smoothstep(falloff,strength,DepthDifference));

	}


	Color.xyz = texture2D(diffuseMap,uv).xyz;

	
	Color.xyz *= 1.0+bl*invSamples;

	Color.xyz *= 2.0;
}

//END
