//VERTEX
#version 330

uniform mat4 u_ViewMatrix;
uniform mat4 u_ProjectionMatrix;
uniform mat4 u_ObjectLocalMatrix;

uniform mat4 u_JointMatrix[70];
uniform mat4 u_BindPoseMatrix[70];

uniform int u_Animated;

in layout(location = 0) vec3 Vertex;
in layout(location = 1) vec3 Normal;
in layout(location = 2) vec2 UV;

in layout(location = 6) int Influences;
in layout(location = 7) vec4 Weights;
in layout(location = 8) ivec4 JointIndex;

out vec3 vertex;
out vec4 normal;

void main()
{
	vec4 v = vec4(0.0);
	float w = 0.0;

	for(int i=0;i<Influences;i++)
	{
		mat4 inverseMatrix;
		mat4 matrix;
		float weight;

		if(i==0)
		{
			inverseMatrix = u_BindPoseMatrix[JointIndex.x];
			matrix = u_JointMatrix[JointIndex.x];
			weight = Weights.x;
		}
		if(i==1)
		{
			inverseMatrix = u_BindPoseMatrix[JointIndex.y];
			matrix = u_JointMatrix[JointIndex.y];
			weight = Weights.y;
		}
		if(i==2)
		{
			inverseMatrix = u_BindPoseMatrix[JointIndex.z];
			matrix = u_JointMatrix[JointIndex.z];
			weight = Weights.z;
		}
		if(i==3)
		{
			inverseMatrix = u_BindPoseMatrix[JointIndex.a];
			matrix = u_JointMatrix[JointIndex.a];
			weight = Weights.a;
		}

		w += weight;
		v += (matrix * (inverseMatrix * vec4(Vertex,1.0) )) * weight;
		
	}


	
	if(w!=1.0)
	{
		v += vec4(Vertex,1.0) * (1.0-w);
	}
	
	
	vertex = vec3((v.y+10.0)/15.0);


	gl_Position = u_ProjectionMatrix * u_ViewMatrix * u_ObjectLocalMatrix * vec4(v.xyz,1.0);
}



//FRAGMENT
#version 330

layout(location=0) out vec4 color;

in vec3 vertex;

void main() {
	color = vec4(vertex,1.0);
}

//END
