//VERTEX
#version 330

in layout(location = 0) vec3 Vertex;
in layout(location = 2) vec2 Uv;

out vec2 uv;

void main()
{
	uv = Uv;
	gl_Position = vec4(Vertex,1.0);
}


//FRAGMENT
#version 330

#extension GL_ARB_shading_language_420pack : enable

layout(binding=0) uniform sampler2D colorMap;

out layout(location=0) vec4 Color;

in vec2 uv;

void main(void) {
	float FXAA_SPAN_MAX = 2.0;
	float FXAA_REDUCE_MUL = 1.0/8.0;
	float FXAA_REDUCE_MIN = (1.0/128.0);

	vec2 uvOffset = 2.0*uv-1.0;

	vec3 rgbNW = texture2D(colorMap, uv.xy + (vec2(-1.0, -1.0) * uvOffset)).xyz;
	vec3 rgbNE = texture2D(colorMap, uv.xy + (vec2(+1.0, -1.0) * uvOffset)).xyz;
	vec3 rgbSW = texture2D(colorMap, uv.xy + (vec2(-1.0, +1.0) * uvOffset)).xyz;
	vec3 rgbSE = texture2D(colorMap, uv.xy + (vec2(+1.0, +1.0) * uvOffset)).xyz;
	vec3 rgbM  = texture2D(colorMap, uv.xy).xyz;
	
	vec3 luma = vec3(0.299, 0.587, 0.114);
	float lumaNW = dot(rgbNW, luma);
	float lumaNE = dot(rgbNE, luma);
	float lumaSW = dot(rgbSW, luma);
	float lumaSE = dot(rgbSE, luma);
	float lumaM  = dot( rgbM, luma);
	
	float lumaMin = min(lumaM, min(min(lumaNW, lumaNE), min(lumaSW, lumaSE)));
	float lumaMax = max(lumaM, max(max(lumaNW, lumaNE), max(lumaSW, lumaSE)));
	
	vec2 dir;
	dir.x = -((lumaNW + lumaNE) - (lumaSW + lumaSE));
	dir.y =  ((lumaNW + lumaSW) - (lumaNE + lumaSE));
	
	float dirReduce = max((lumaNW + lumaNE + lumaSW + lumaSE) * (0.25 * FXAA_REDUCE_MUL), FXAA_REDUCE_MIN);
		
	float rcpDirMin = 1.0/(min(abs(dir.x), abs(dir.y)) + dirReduce);
	
	dir = min(vec2(FXAA_SPAN_MAX,  FXAA_SPAN_MAX), 
	      max(vec2(-FXAA_SPAN_MAX, -FXAA_SPAN_MAX), dir * rcpDirMin)) * uvOffset;
		
	vec3 rgbA = (1.0/2.0) * (
	            texture2D(colorMap, uv.xy + dir * (1.0/3.0 - 0.5)).xyz +
	            texture2D(colorMap, uv.xy + dir * (2.0/3.0 - 0.5)).xyz);
	vec3 rgbB = rgbA * (1.0/2.0) + (1.0/4.0) * (
	            texture2D(colorMap, uv.xy + dir * (0.0/3.0 - 0.5)).xyz +
	            texture2D(colorMap, uv.xy + dir * (3.0/3.0 - 0.5)).xyz);
	float lumaB = dot(rgbB, luma);

	if((lumaB < lumaMin) || (lumaB > lumaMax)){
	  Color.xyz=rgbA;
	} else {
	  Color.xyz=rgbB;
	}

	Color.a = 1.0;
	  
}
//END
