//VERTEX
#version 330

in layout(location = 0) vec3 Vertex;
in layout(location = 2) vec2 Uv;

out vec2 uv;

void main()
{
	uv = Uv;
	gl_Position = vec4(Vertex,1.0);
}


//FRAGMENT
#version 330

#extension GL_ARB_shading_language_420pack : enable

uniform sampler2D colorMap;

const float blurSize = 1.0/1024.0;

out layout(location=0) vec4 Color;
out layout(location=1) vec4 Original;

in vec2 uv;

void main(void) {
   vec4 sum = vec4(0.0);
   sum += texture2D(colorMap, vec2(uv.x - 4.0*blurSize, uv.y)) * 0.05;
   sum += texture2D(colorMap, vec2(uv.x - 3.0*blurSize, uv.y)) * 0.09;
   sum += texture2D(colorMap, vec2(uv.x - 2.0*blurSize, uv.y)) * 0.12;
   sum += texture2D(colorMap, vec2(uv.x - blurSize, uv.y)) * 0.15;
   sum += texture2D(colorMap, vec2(uv.x, uv.y)) * 0.16;
   sum += texture2D(colorMap, vec2(uv.x + blurSize, uv.y)) * 0.15;
   sum += texture2D(colorMap, vec2(uv.x + 2.0*blurSize, uv.y)) * 0.12;
   sum += texture2D(colorMap, vec2(uv.x + 3.0*blurSize, uv.y)) * 0.09;
   sum += texture2D(colorMap, vec2(uv.x + 4.0*blurSize, uv.y)) * 0.05; 
   Color = sum;
   Original = texture2D(colorMap,uv);
}
//END
