#version 330

in vec2 TexCoord;

layout( location = 0 ) out vec4 out_Color;

uniform sampler2D TexSampler;
uniform sampler2D TexSampler2;
uniform float BloomDry;
uniform float BloomWet;
uniform float Exposure;
uniform float Flash;
uniform float Vignette;

uniform float Fade;


void main()
{
	vec4 original = texture2D( TexSampler, TexCoord );
	vec4 blurred = texture2D( TexSampler2, TexCoord );

	vec4 color = ( original * BloomDry ) + ( blurred * BloomWet );

	vec2 imgTexCoord = TexCoord - 0.5f;

	float vignette = 1 - dot( imgTexCoord, imgTexCoord );
	
	vec4 color_correction = vec4( 0.1, 0.15, 0.4, 0.2 ) * Flash;
	//vec4 color_correction = vec4( 0.01, 0.02, 0.34, 0.2 ) * Flash;

	color += color_correction;

	color *= pow( vignette, Vignette );

	color *= Exposure; //Exposure level

	out_Color = ( color * Fade );//pow( color, vec4( 0.55 ) ); //Gamma
}