#version 330

in vec2 TexCoord;

out vec4 out_Color;

uniform sampler2D TexSampler;
uniform float BloomCutoff;

void main()
{
	vec4 color = texture2D( TexSampler, TexCoord );
	float lum = sqrt( 0.241 * pow( color.r, 2 ) + 0.691 * pow( color.g, 2 ) + 0.068 * pow( color.b, 2 ) );
	if( lum > BloomCutoff )
	{
		out_Color = color;// * 8.0; //Brighten it up a bit
	}
	else
	{
		out_Color = vec4( 0.0, 0.0, 0.0, 0.0 );
	}
}