#version 330

layout( location = 0 ) in vec3 InVertex;
layout( location = 1 ) in float InParticleSize;
layout( location = 2 ) in float InParticleBrightness;

out float ParticleSize;
out float ParticleBrightness;

uniform mat4 ViewMatrix;
uniform mat4 ProjectionMatrix;
uniform float CurrentTime;

void main()
{
	ParticleSize = InParticleSize;
	ParticleBrightness = InParticleBrightness;
	vec3 pos = InVertex;
	gl_Position = ProjectionMatrix * ViewMatrix * vec4( pos, 1.0 );
}