 /**
  * Cre un sprite zoomable. Ce type de sprite sert dans les affichages en pseudo-3D
  * (affichage 2D avec zoom plan). Il peut tre anim via le principe du "sprite CSS"
  * (utilisation d'une image comprenant des frames d'animation juxtaposes).
  * 
  * Les paramtres sont les suivants :
  * 	width 		: largeur en pixels d'une frame non zoome (pas de l'image complte)
  *     height		: hauteur en pixels d'une frame non zoome (pas de l'image complte)
  *     hotSpotX    : point de rfrence en pixels d'une frame,  partir duquel
  *     hotSpotY    : l'image sera positionne.
  *     imageFile   : chemin vers le fichier image (utilis comme url pour la proprit CSS background-position)
  *     frameCountX : nombre de frames dans la largeur de l'image
  *     frameCountY : nombre de frames dans la hauteur de l'image
  *
  * A noter que l'image doit avoir les dimensions suivantes :
  *   - largeur : width*frameCountX
  *   - hauteur : height*frameCountY
  * 
  * La cration n'ajoute pas le sprite dans le document, un appel  appendChild() sera ncessaire.
  */
 function ZoomableSprite(width, height, hotSpotX, hotSpotY, imageFile, frameCountX, frameCountY)
 {
	this.width = width;
	this.height = height;
	this.frameCountX = frameCountX;
	this.frameCountY = frameCountY;
	this.hotSpotX = hotSpotX;
	this.hotSpotY = hotSpotY;
	this.clipped = false;
	this.clipLeft = 0;
	this.clipRight = 0;
	this.clipTop = 0;
	this.clipBottom = 0;
	
	this.box = document.createElement('div');
	this.box.style.position="absolute";
	this.box.style.overflow="hidden";
	this.box.style.visibility="hidden";
	this.box.style.width=width+"px";
	this.box.style.height=height+"px";
	this.image = document.createElement('img');
	this.image.style.position="absolute";
	this.image.style.width=(100*frameCountX)+"%";
	this.image.style.height=(100*frameCountY)+"%";
	this.image.style.top="0%";
	this.image.style.left="0%";
	this.image.setAttribute("src", imageFile);
	this.box.appendChild(this.image);
 }
 
 
 ZoomableSprite.prototype = {
 
	/**
	 * Renvoie l'objet <div>, instanciation du sprite dans le document
	 */
	getSpriteObject : function() {
		return this.box;
	},
 
	/**
	 * Modifie l'image du sprite.
	 * Attention, aucun test n'est fait sur la consistance.
	 * Il est indispensable que le nouveau fichier fasse les mmes dimensions que l'ancien
	 */
	setImageFile : function(imageFile) {
		this.image.setAttribute("src", imageFile);
	},
 
	/**
	 * Dfinit la zone de clipping, en coordonnes parent (les mmes que pour la position)
	 * L'ordre des paramtres est celui de la proprit CSS clip
	 * Attention, le clipping ne sera effectif qu'au prochain dplacement (setPosition ou moveSpriteTo)
	 */
	setClipArea : function(top, right, bottom, left) {
		this.clipped = true;
		this.clipLeft = left;
		this.clipRight = right;
		this.clipTop = top;
		this.clipBottom = bottom;		
	},
 
	/**
	 * Modifie le zoom du sprite. 1 = taille par dfaut
	 */
	setZoom : function(value) {
		this.box.style.width=Math.round(value*this.width)+"px";
		this.box.style.height=Math.round(value*this.height)+"px";
	},
	
	/**
     * Dplace le sprite.
	 * x et y sont les coordonnes en haut  gauche
	 */
	setPosition : function(x, y, z) {
		this.box.style.left=Math.round(x)+"px";
		this.box.style.top=Math.round(y)+"px";
		this.box.style.zIndex=Math.round(z);
		if (this.clipped) {
			this.box.style.clip="rect(" + Math.round(this.clipTop-y)+"px "
										+ Math.round(this.clipRight-x)+"px "
										+ Math.round(this.clipBottom-y)+"px "
										+ Math.round(this.clipLeft-x)+"px)";
		}
	},
	
	/**
	 * Dplace et zoome le sprite.
	 * Les coordonnes sont celles du hot spot.
	 *   x    : abscisse en pixels du hot spot
	 *   y    : ordonne en pixels du hot spot
	 *   z    : z-index du sprite
	 *   zoom : niveau de zoom, 1 = taille par dfaut
	 */
	moveSpriteTo : function(x, y, z, zoom) {
		var pixelWidth = Math.round(zoom*this.width);
		var pixelHeight = Math.round(zoom*this.height);
		
		var zoomedHotSpotX = zoom*this.hotSpotX;
		var zoomedHotSpotY = zoom*this.hotSpotY;
		
		// on recalcule les coordonnes en haut  gauche
		// pour que le hot spot se trouve en (x, y)
		var px = x-zoomedHotSpotX;
		var py = y-zoomedHotSpotY;
		this.box.style.left=Math.round(px)+"px";
		this.box.style.top=Math.round(py)+"px";
		this.box.style.zIndex=Math.round(z);
		this.box.style.width=pixelWidth+"px";
		this.box.style.height=pixelHeight+"px";
		if (this.clipped) {
			this.box.style.clip="rect(" + Math.round(this.clipTop-py)+"px "
										+ Math.round(this.clipRight-px)+"px "
										+ Math.round(this.clipBottom-py)+"px "
										+ Math.round(this.clipLeft-px)+"px)";
		}
	},
	
	/**
	  * Change l'image du sprite (la frame affiche)
	  * x et y sont les index horizontaux et verticaux de l'image  affiche,  partir de 0
	  */
	setAnimationFrame : function(x, y) {
		this.image.style.left=(-100*x)+"%";
		this.image.style.top=(-100*y)+"%";
	},
	
	/**
	  * Affiche (true) ou masque (false) le sprite
	  */
	 setVisible : function(shown) {
		this.box.style.visibility=(shown?"visible":"hidden");
	}
}