/**	
 * Jeu : course auto en pseudo-3D
 * Inspirations : Lotus Esprit Turbo Challenge, Jaguar XJ220, Crazy Cars III
 */
 



/**
 * Initialisation de l'application
 *  - cre et initialise les classes de donnes (Garage, ...)
 *  - cre le moteur de jeu
 *  - cre les diffrents crans de prparation
 */
function RacingGameApp(containerName, lastTrack, carMask, modeMask)
{
	var container = document.getElementById(containerName);

	this.engine = new RaceEngine(this, container);
	this.garage = new Garage (16, 16);
	this.garage.defineCars(carMask);
	
	this.intro = new IntroViewer(container, this);
	
	this.season = new Season();
	this.season.defineStandardTracks();
	
	this.raceResult = new RaceResult(this.season, this.garage);
	this.fader =  new Fader(container, this.engine.screenWidth, this.engine.screenHeight);
	this.engine.fader = this.fader;
	this.raceLoader = new RaceLoader(this, this.engine, container, this.season, this.fader);
	this.timingWindow = new TimingWindow(this, container, this.fader, this.engine.imageFx);
	this.escapeWindow = new EscapeWindow(this, container, this.fader, this.engine.imageFx);

	
	this.playerLastTrack = lastTrack;
} 

RacingGameApp.prototype = {

    /**
	 * Initialise et lance le jeu
	 */
	main : function() {
		this.engine.initializeEnvironment();
        this.startIntro();
	},

	startIntro : function() {
		this.intro.launch("http://renaissanceracer.com/demojs/intro/intro_", 8, true); 
	},

	afterIntro : function() {
		this.startRaceLoader();
	},
	
	/**
	 * Etat Chargement de la course (splash screen) : point d'entre
	 */
	startRaceLoader : function() {
		var modeIndex = 2; 
		var trackIndex = 0; // basculer  1 une fois le circuit prt
		var carIndex = 7;
		
		this.raceLoader.launchScreen(modeIndex, trackIndex, carIndex, this.garage.getCar(carIndex).imageFile, false);
	},

	
	/**
	 * Etat Chargement de la course (splash screen) : point de sortie
	 */
	raceLoaded : function() {
		if (this.raceLoader.loadFailed) {
			this.startRaceLoader();
		} else if (this.raceLoader.loadAborted) {
			this.startRaceLoader();
		} else {
			this.startRace();
		}
	},
	
	/**
	 * Etat Course : point d'entre
	 */
	startRace : function() {
		var modeIndex = 2;
		var selectedCar = 7;
		
		this.engine.setupGameParameters(modeIndex, selectedCar, this.garage.getCar(selectedCar), this.raceResult);
		this.engine.launchGame();
	},
	 
	/**
	 * Etat Course : point de sortie principal en fin de course
	 */	 
	afterRaceCompleted : function() {
		this.startTimingWindow();
	},
	
	/**
	 * Etat Course : point de sortie secondaire sur chappement (touche ESC)
	 */	 
	afterRaceSuspended : function() {
		this.startRaceEscapeWindow();
	},
	
	/**
	 * Etat Course suspendue : point d'entre
	 */
	startRaceEscapeWindow : function() {
		this.escapeWindow.launchScreen();
	},
	
	/**
	 * Etat Course suspendue : point de sortie sur choix utilisateur
	 */
	afterRaceEscapeWindow : function() {
		switch (this.escapeWindow.getSelectedOption()) {
			case 0 : // reprendre
				this.engine.resumeRace();
				break;
			case 1 : // recommencer au dpart
				this.startRace();
				break;
			default : // retour au menu
				this.engine.hideScene();
				this.startRaceLoader();
				break;
		}
	},
	
	/**
	 * Etat Affichage du temps de course : point d'entre
	 */
	startTimingWindow : function() {
		this.timingWindow.launchScreen(this.engine.road, this.raceResult);
	},
	
	/**
	 * Etat Affichage du temps de course : point de sortie
	 */
	afterTimingWindow : function() {
		this.engine.hideScene();
		switch (this.timingWindow.getSelectedOption()) {
			case 0 : // circuit suivant
				this.startRaceLoader();
				break;
			case 1 : // rejouer
				this.startRace();
				break;
			default : // retour au menu
				this.startRaceLoader();
				break;
		}
	},
	
	startFinal : function() {
		this.intro.launch("http://renaissanceracer.com/demojs/intro/final_", 3, false); 
	},

};
