<?php

/**
 * La classe Dictionary dfinit l'ensemble des textes et intituls du jeu, hors
 * messages d'erreur, prsents  l'utilisateur, et effectue leur internationalisation.
 */
 
 
class Dictionary
{
	private $contents = array (
		"fr" => array (
			"MENU_HOME"					=> "ACCUEIL",
			"MENU_RACE"					=> "JOUER",
			"MENU_HOF"					=> "RECORDS",
			"MENU_OPTIONS"				=> "OPTIONS",
			"MENU_TOS"					=> "Conditions d'utilisation",
			"MENU_CREDITS"				=> "Crdits",
			"MENU_LICENSE"				=> "Licence",
			"FORM_NAME"					=> "Pseudo",
			"FORM_PASSWORD"				=> "Mot de passe",
			"FORM_ADDRESS"				=> "Adresse mail",
			"FORM_LOGIN"				=> "En avant !",
			"FORM_SIGNUP"				=> "S'inscrire",
			"FORM_LOST_PASSWORD"		=> "Mot de passe perdu",
			"FORM_LOGOUT"				=> "Se dconnecter",
			"FORM_CANCEL"				=> "Annuler",
			"FORM_SEND"					=> "Envoyer",
			"FORM_SIGNUP_INTRO"			=> "Inscription sur le site : ",
			"FORM_LOST_PW_INTRO"		=> "Rentrez votre pseudo et l'adresse mail avec laquelle vous vous tes inscrit, et le site vous enverra un nouveau mot de passe : ",
			"HOF_NO_RECORD"				=> "Aucun record sur ce circuit",
			"TEXT"						=> "TEXTE",
			"OPTION_TITLE"				=> "Options de jeu",
			"OPTION_DETAIL"				=> "Niveau de dtail",
			"OPTION_DETAIL_LOW"			=> "Faible",
			"OPTION_DETAIL_MEDIUM"		=> "Moyen",
			"OPTION_DETAIL_HIGH"		=> "Elev",
			"OPTION_DETAIL_ADAPTIVE"	=> "Automatique",
			"OPTION_SKIP_FRAMES"		=> "N'afficher qu'une image sur deux",
			"OPTION_SOUND"				=> "Activer le son",
			"OPTION_SUBMIT"				=> "Modifier mes options",
			"OPTIONS_NEED_LOGIN"		=> "Vous devez tre identifi pour accder aux options de jeu.",
			"OPTIONS_CHANGED"			=> "Vos options ont t enregistres.",
			"404_TITLE"					=> "Sortie de route !",
			"404_IMAGE"					=> "404_fr",
			"404_MESSAGE"				=> "Cette page n'existe pas. D'ailleurs, la route n'est mme pas sur la carte. Vous n'auriez pas d faire confiance  votre GPS quand il vous a dit de tourner  droite dans les champs. Heureusement, vous pouvez toujours revenir en marche arrire jusqu' ",
			"404_MESSAGE_2"				=> "l'accueil",
			"TRACK_1"					=> "Grands Causses",
			"TRACK_2"					=> "Territoire du Nord",
			"TRACK_3"					=> "Alpes Suisses",
			"TRACK_4"					=> "Connemara",
			"TRACK_5"					=> "Test Zone",
			"TRACK_6"					=> "Ligne droite",
			"TRACK_7"					=> "Circuit 7",
			"TRACK_8"					=> "Circuit 8",
			"TRACK_9"					=> "Circuit 9",
			"TRACK_10"					=> "Circuit 10",
			"TRACK_11"					=> "Circuit 11",
			"TRACK_12"					=> "Circuit 12",
			"TRACK_13"					=> "Circuit 13",
			"TRACK_14"					=> "Circuit 14",
			"TRACK_15"					=> "Circuit 15",
			"TRACK_16"					=> "Circuit 16",
			"MESSAGE_LOGIN"				=> "Login russi.",
			"NEWSBOX_1_TITLE"			=> "Torrent",
			"NEWSBOX_1_CONTENT"			=> "Une nouvelle voiture est dissimule sur le troisime circuit. Pour la trouver, tudiez l'indice donn sur l'cran de choix de votre bolide : \"A gauche du rouge,  droite du bleu\".",
			"NEWSBOX_2_TITLE"			=> "Recommencer une course",
			"NEWSBOX_2_CONTENT"			=> "En jeu, la touche Escape ouvre dsormais un menu permettant de sortir ou recommencer la course  zro, par exemple si on a loup son dpart. Au passage Espace met en pause, et F1, F2 et F3 changent la camra (mais F3 ne sert qu'en mode drift).",
			"NEWSBOX_3_TITLE"			=> "Bienvenue sur la beta",
			"NEWSBOX_3_CONTENT"			=> "Ceci est la version beta de Renaissance Racer. Les futurs pilotes comptent sur vous pour faire une reconnaissance des diffrents circuits, reprer les diffrents dangers et trouver tous les bugs, pour qu'ils puissent ensuite se lancer l'esprit tranquille et finir dans les graviers au premier virage."
		),
		"en" => array (
			"MENU_HOME"					=> "HOME",
			"MENU_RACE"					=> "RACE",
			"MENU_HOF"					=> "HALL OF FAME",
			"MENU_OPTIONS"				=> "OPTIONS",
			"MENU_TOS"					=> "Terms of service",
			"MENU_CREDITS"				=> "Credits",
			"MENU_LICENSE"				=> "License",
			"FORM_NAME"					=> "Nickname",
			"FORM_PASSWORD"				=> "Password",
			"FORM_ADDRESS"				=> "Mail address",
			"FORM_LOGIN"				=> "Drive !",
			"FORM_SIGNUP"				=> "Sign up",
			"FORM_LOST_PASSWORD"		=> "Lost password",
			"FORM_LOGOUT"				=> "Log out",
			"FORM_CANCEL"				=> "Cancel",
			"FORM_SEND"					=> "Send",
			"FORM_SIGNUP_INTRO"			=> "Create your driver account : ",
			"FORM_LOST_PW_INTRO"		=> "Type in your nickname and the address you used to register, and we will send you a brand new password : ",
			"HOF_NO_RECORD"				=> "No laptime recorded",
			"TEXT"						=> "TEXT",
			"OPTION_TITLE"				=> "Game options",
			"OPTION_DETAIL"				=> "Level of detail",
			"OPTION_DETAIL_LOW"			=> "Low",
			"OPTION_DETAIL_MEDIUM"		=> "Medium",
			"OPTION_DETAIL_HIGH"		=> "High",
			"OPTION_DETAIL_ADAPTIVE"	=> "Adaptive",
			"OPTION_SKIP_FRAMES"		=> "Skip every other frame",
			"OPTION_SOUND"				=> "Engine sound",
			"OPTION_SUBMIT"				=> "Change options",
			"OPTIONS_NEED_LOGIN"		=> "Log in to edit game options.",
			"OPTIONS_CHANGED"			=> "Options were successfully saved.",
			"404_TITLE"					=> "Wrong way !",
			"404_IMAGE"					=> "404_en",
			"404_MESSAGE"				=> "There is no such page. The road is not even mentioned on the map. Next time, think again about trusting your GPS when it tells you to make a right into a field. Luckily, you can still back up to the ",
			"404_MESSAGE_2"				=> "main page",
			"TRACK_1"					=> "Great Causses",
			"TRACK_2"					=> "Northern Territory",
			"TRACK_3"					=> "Swiss Alps",
			"TRACK_4"					=> "Connemara",
			"TRACK_5"					=> "Test Zone",
			"TRACK_6"					=> "Ligne droite",
			"TRACK_7"					=> "Track 7",
			"TRACK_8"					=> "Track 8",
			"TRACK_9"					=> "Track 9",
			"TRACK_10"					=> "Track 10",
			"TRACK_11"					=> "Track 11",
			"TRACK_12"					=> "Track 12",
			"TRACK_13"					=> "Track 13",
			"TRACK_14"					=> "Track 14",
			"TRACK_15"					=> "Track 15",
			"TRACK_16"					=> "Track 16",
			"MESSAGE_LOGIN"				=> "Login successful !",
			"NEWSBOX_1_TITLE"			=> "Torrent",
			"NEWSBOX_1_CONTENT"			=> "A new car was concealed on the third track. You can find it with the clue given on the car selection screen : \"Left side of the red, right side of the blue\".",
			"NEWSBOX_2_TITLE"			=> "Restart race",
			"NEWSBOX_2_CONTENT"			=> "During the game, press Escape to open a menu and get an opportunity to quit, or restart the race. Also, Space pauses the race, and F1 to F3 change the camera (although F3 is for drift mode only).",
			"NEWSBOX_3_TITLE"			=> "Welcome to the beta",
			"NEWSBOX_3_CONTENT"			=> "This is the beta version of Renaissance Racer. Our upcoming pilots rely on you to review the tracks, look for the hazards and identify all the bugs, so they can safely floor it and visit the roadside."

		)
	);

	/** Langue  utiliser pour les affichanges, anglais par dfaut */
	private $language = "en";

	/** Instance du singleton */
	private static $instance = null;
	
	/** Paramtres pour le message  afficher si celui-ci a des lments variables*/
	private $messageParameters = null;

	/**
	 * Renvoie l'instance du singleton
	 */
	public static function getInstance()
	{
		if (self::$instance == null) {
			self::$instance = new Dictionary();
		}
		return self::$instance;
	}
	
	/**
	 * Retourne la liste des langues supportes (pour appel  http_negociate_language)
	 */
	 public function getSupportedLanguages() 
	 {
		return array_keys($this->contents);
	 }
	
	/**
	 * Valide un nouveau choix de langue  utiliser pour les traductions
	 *  - si l'acronyme fourni est valide, l'accepte et renvoie true
	 *  - sinon, renvoie false
	 */
	 public function setLanguage ($newLanguage)
	 {
		$newLanguage = strtolower($newLanguage);
		if ("fr" == $newLanguage ||"en" == $newLanguage) {
			$this->language = $newLanguage;
			setcookie('RRLanguage', $newLanguage, time()+2592000, '/'); // validit 30 jours
			return true;
		}
		return false;
	 }
	 
	/**
	 * Renvoie la langue utilise, dfinie prcdemment par setLanguage()
	 */
	 public function getLanguage()
	 {
		return $this->language;
	}
	 
	/**
	 * Renvoie le message internationalis correspondant  l'index fourni
	 */
	function translate($messageId)
	{
		if (! array_key_exists($messageId, $this->contents[$this->language])) {
			return "???";
		}
		$message = $this->contents[$this->language][$messageId];
		$paramCount = count($this->messageParameters);
		for ($index=0; $index<$paramCount; ++$index)
		{
			$searchPattern = '/\{'.$index.'\}/';
			$message = preg_replace($searchPattern, $this->messageParameters[$index], $message);
		}
		// Le message utilisateur est destin  tre affich via le navigateur
		return htmlentities($message);
	}
	
	/**
	 * Dfinit les paramtres du message cours, pour remplacement dans la
	 * chane de caractres
	 */
	function setParameters($value)
	{
		$this->messageParameters = array( $value );
	}
}

function t_($message) {
	return Dictionary::getInstance()->translate($message);
}