/**
 * Ecran/fentre d'chappement d'une course 
 *
 * S'affiche lors d'un appui sur Escape, en superposition par rapport  la visu du jeu.
 *
 * Elle permet de recommencer la course au dpart, ou revenir au menu, sans attendre la fin de la partie.
 *
 */
 
 
 /**
  * Cration de la fentre d'affichage du menu d'chappement de la course
  *
  *  - application : l'application (RacingGameApp)  qui rendre la main  l'issue
  *  - container : l'objet DIV qui contiendra les lments DHTML crs
  *  - fader : le fader sur le container (tat In, i.e. affichage normal, en entre)
  *  - imageFx : l'outil pour effectuer les oprations graphiques (texte dtour)
  */
function EscapeWindow(application, container, fader, imageFx)
{
	this.application = application;
	this.container = container;
	this.fader = fader;
	this.imageFx = imageFx;
	
	this.width = 430;
	this.height = 190;
	
}

EscapeWindow.prototype =  {

	/**
	 * Initialization / remise  zro des paramtres 
	 */
	initialize : function() {
		this.timer = 0;
		this.leavingTimer = 0;
	},
	
	/**
	 * Renvoie l'option slectionne dans le menu, ou zro s'il n'a pas t cr
	 */
	getSelectedOption : function() {
		if (this.menuDriver) {
			return this.menuDriver.getSelectedOption();
		}
		return 0;
	},
	
	/**
	 * Cration et initialisation des lments d'affichage (DHTML)
	 * Branchement des gestionnaires d'vnements clavier
	 *
	 * Prrequis : fader In en entre (visu normale), on n'y touche pas
	 *
	 */
	launchScreen : function() {
	
		// panel parent de l'affichage du menu
		// en deux niveaux : le premier a une opacit  1 et contient le texte du menu
		// le second est noir avec une opacit  0.5 et ne contient rien
		this.opaqueMaster = document.createElement('div');
		this.opaqueMaster.setAttribute("class", "escape_master");
		this.container.appendChild(this.opaqueMaster);
		this.blackBox = document.createElement('div');
		this.blackBox.setAttribute("class", "escape_black_box");
		this.opaqueMaster.appendChild(this.blackBox);

		
		
		this.menuDriver = new MenuDriver(this.opaqueMaster, this.fader, this.imageFx, 3);
		this.menuDriver.initialize();
		this.menuDriver.setOptionText(0, _("TW004"));
		this.menuDriver.setOptionText(1, _("TW005"));
		this.menuDriver.setOptionText(2, _("TW003"));
		this.menuDriver.getControl(0).style.top = "50px";
		this.menuDriver.getControl(1).style.top = "110px";
		this.menuDriver.getControl(2).style.top = "170px";
		this.menuDriver.getControl(0).style.opacity=1;
		this.menuDriver.getControl(1).style.opacity=1;
		this.menuDriver.getControl(2).style.opacity=1;
		this.menuDriver.setEscapeOption(0);


		var control = this.menuDriver;
		document.onkeydown = function(event) { return control.onKeyDown(event); }
		document.onkeyup = function(event) { control.onKeyUp(event); }
		
		this.initialize();
		
		this.choiceLoop();
	},
	
	/**
	 * Boucle principale de gestion des vnements et d'affichage, pour le menu de choix
	 * utilisateur (suite, recommencer ..) en fin de course.
	 * Fait disparatre l'affichge prcdent, le remplace par le nouveau
	 * et met  jour en fonction de la slection utilisateur
	 */
	choiceLoop : function() {
		var motionEnd = 12;
		if (this.timer <= motionEnd)
		{	// 1re phase, on fait apparatre la blackbox par la gauche
			// et le texte des menus par la droite
			
			var masterLeft = 480-40*this.timer;
			this.opaqueMaster.style.left = masterLeft+"px";
			this.opaqueMaster.style.clip = "rect(0px, "+(40*this.timer)+"px, 240px, "+(-masterLeft)+"px)";

			this.blackBox.style.left = (-935+80*this.timer)+"px";
			
		} 
		this.menuDriver.repaint(this.timer);
		++this.timer;
	
		var keepOn = true;
		if (this.menuDriver.userAcknowledged) {
			document.onkeydown = null;
			document.onkeyup = null;

			this.opaqueMaster.style.left = (40*this.leavingTimer)+"px";
			this.opaqueMaster.style.clip = "rect(0px, "+(480-40*this.leavingTimer)+"px, 240px, "+(-40*this.leavingTimer)+"px)";

			this.blackBox.style.left = (25-80*this.leavingTimer)+"px";
			++this.leavingTimer;

			var faderNeeded = (this.menuDriver.getSelectedOption() > 0);
			if (!this.fader.fading) { // le rideau est  l'arrt
				if (this.fader.faded || !faderNeeded) { // soit il est dja tir, ou pas ncessaire
					if (this.leavingTimer>=motionEnd) {
						this.terminateScreen();
						keepOn = false;
					}
				} else { // soit on est au tout dbut et on doit le tirer
					this.fader.fadeOut();
				}
			}
		} 
		if (keepOn) {
			setTimeout("escapeWindowChoiceLoop(lotus.escapeWindow)", 40);
		} else {
			this.application.afterRaceEscapeWindow();
		}
	},
	
	
	/**
	 *	Ferme et dtruit les lments DHTML de l'cran
	 */
	terminateScreen : function() {
		document.onkeydown = null;
		document.onkeyup = null;
		
		this.menuDriver.terminate();
	
		this.opaqueMaster.style.display="none";
		this.opaqueMaster.removeChild(this.blackBox);
		this.container.removeChild(this.opaqueMaster);
	}
}
	
	
function escapeWindowChoiceLoop(screen)
{
	screen.choiceLoop();
}