/*------------------------------------------------------------------------------
Copyright (c) 2011 Antoine Santo Aka NoNameNo

This File is part of the CODEF project. (http://code.google.com/p/codef/)

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
------------------------------------------------------------------------------*/


function codef3D(dst, camZ, fov, near, far){
	this.camera = new THREE.Camera( fov, dst.width / dst.height, near, far );
	this.camera.position.z = camZ;
	
	this.scene = new THREE.Scene();
	
	this.renderer = new THREE.CanvasRenderer({ canvas: dst.canvas});
	this.renderer.setSize( dst.width, dst.height );
	this.renderer.autoClear=false;
	
	this.group = new THREE.Object3D();
	this.scene.add( this.group );
	
	
	
	this.line=function(p1,p2, params){
		var geom = new THREE.Geometry();
		geom.vertices.push( new THREE.Vertex( p1 ) );
		geom.vertices.push( new THREE.Vertex( p2 ) );
		var line = new THREE.Line( geom,  params  );
		this.group.add(line );
	}
	
	this.lines=function(vertices, object, params){
		for(var i=0; i<object.length; i++){
			this.line(vertices[object[i].p1],vertices[object[i].p2], params);
		}
	}
	
	this.faces=function(vertices, object,doubleSided,overdraw){
		var geom = new THREE.Geometry(); 
		for(var i=0; i<vertices.length; i++){
			geom.vertices.push(new THREE.Vertex(new THREE.Vector3( vertices[i].x,  vertices[i].y,  vertices[i].z)));

		}
		
		for(var i=0; i<object.length; i++){
			geom.faces.push( new THREE.Face3( object[i].p1,object[i].p2,object[i].p3, null, null,object[i].params ));
			if(typeof(object[i].v3)!='undefined'){
				geom.faceVertexUvs[ 0 ].push( [
						new THREE.UV( object[i].u1,object[i].v1 ),
						new THREE.UV( object[i].u2,object[i].v2 ),
						new THREE.UV( object[i].u3,object[i].v3)
					] );
			}
			
		}


		geom.computeFaceNormals();
		geom.computeCentroids();
		geom.computeVertexNormals();


		form = new THREE.Mesh( geom, new THREE.MeshFaceMaterial());
		form.overdraw = overdraw;
		form.doubleSided=doubleSided;
		this.group.add(form );

		
	}
	

			
	
	this.addAmbiLight=function(color){
                this.scene.add( new THREE.AmbientLight( color ) );
        }

        this.addDirLight=function(x,y,z,color){

                var directionalLight = new THREE.DirectionalLight( color );
                directionalLight.position.x = x;
                directionalLight.position.y = y;
                directionalLight.position.z = z;
                directionalLight.position.normalize();
                this.scene.add( directionalLight );
        }
        
        this.vectorball_dot=function(vertices){

		
		for(var i=0; i<vertices.length; i++){
			eval('plop=function ( context ){context.beginPath(); context.arc( 0, 0, '+vertices[i].size+', 0, Math.PI*2, true ); context.closePath();context.fill();}');
			var material = new THREE.ParticleCanvasMaterial( {
			color: vertices[i].color,
			program: plop
			} );
			
			var particle = new THREE.Particle( material );
			particle.position.x = vertices[i].x;
			particle.position.y = vertices[i].y;
			particle.position.z = vertices[i].z;
			this.group.add( particle );
		}
		
	}
	
	this.vectorball_img=function(vertices,img){

		
		for(var i=0; i<vertices.length; i++){
			eval('plop=function ( context ){context.drawImage(img['+vertices[i].img+'].img,-'+img[vertices[i].img].img.width/2+',-'+img[vertices[i].img].img.height/2+');}');
			var material = new THREE.ParticleCanvasMaterial( {
			program: plop
			} );
			
			var particle = new THREE.Particle( material );
			particle.position.x = vertices[i].x;
			particle.position.y = vertices[i].y;
			particle.position.z = vertices[i].z;
			this.group.add( particle );
		}
		
	}

	
	
	this.draw=function(){
		this.renderer.render( this.scene, this.camera );
	}
}


// Three.js r45dev - http://github.com/mrdoob/three.js
var THREE=THREE||{};if(!self.Int32Array)self.Int32Array=Array,self.Float32Array=Array;THREE.Color=function(b){b!==void 0&&this.setHex(b);return this};
THREE.Color.prototype={constructor:THREE.Color,r:1,g:1,b:1,copy:function(b){this.r=b.r;this.g=b.g;this.b=b.b;return this},setRGB:function(b,c,e){this.r=b;this.g=c;this.b=e;return this},setHSV:function(b,c,e){var f,h,m;if(e==0)this.r=this.g=this.b=0;else switch(f=Math.floor(b*6),h=b*6-f,b=e*(1-c),m=e*(1-c*h),c=e*(1-c*(1-h)),f){case 1:this.r=m;this.g=e;this.b=b;break;case 2:this.r=b;this.g=e;this.b=c;break;case 3:this.r=b;this.g=m;this.b=e;break;case 4:this.r=c;this.g=b;this.b=e;break;case 5:this.r=
e;this.g=b;this.b=m;break;case 6:case 0:this.r=e,this.g=c,this.b=b}return this},setHex:function(b){b=Math.floor(b);this.r=(b>>16&255)/255;this.g=(b>>8&255)/255;this.b=(b&255)/255;return this},getHex:function(){return~~(this.r*255)<<16^~~(this.g*255)<<8^~~(this.b*255)},getContextStyle:function(){return"rgb("+Math.floor(this.r*255)+","+Math.floor(this.g*255)+","+Math.floor(this.b*255)+")"},clone:function(){return(new THREE.Color).setRGB(this.r,this.g,this.b)}};
THREE.Vector2=function(b,c){this.x=b||0;this.y=c||0};
THREE.Vector2.prototype={constructor:THREE.Vector2,set:function(b,c){this.x=b;this.y=c;return this},copy:function(b){this.x=b.x;this.y=b.y;return this},clone:function(){return new THREE.Vector2(this.x,this.y)},add:function(b,c){this.x=b.x+c.x;this.y=b.y+c.y;return this},addSelf:function(b){this.x+=b.x;this.y+=b.y;return this},sub:function(b,c){this.x=b.x-c.x;this.y=b.y-c.y;return this},subSelf:function(b){this.x-=b.x;this.y-=b.y;return this},multiplyScalar:function(b){this.x*=b;this.y*=b;return this},
divideScalar:function(b){b?(this.x/=b,this.y/=b):this.set(0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(b){return this.x*b.x+this.y*b.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},distanceTo:function(b){return Math.sqrt(this.distanceToSquared(b))},distanceToSquared:function(b){var c=this.x-b.x,b=this.y-b.y;return c*c+b*b},setLength:function(b){return this.normalize().multiplyScalar(b)},
equals:function(b){return b.x==this.x&&b.y==this.y}};THREE.Vector3=function(b,c,e){this.x=b||0;this.y=c||0;this.z=e||0};
THREE.Vector3.prototype={constructor:THREE.Vector3,set:function(b,c,e){this.x=b;this.y=c;this.z=e;return this},setX:function(b){this.x=b;return this},setY:function(b){this.y=b;return this},setZ:function(b){this.z=b;return this},copy:function(b){this.x=b.x;this.y=b.y;this.z=b.z;return this},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)},add:function(b,c){this.x=b.x+c.x;this.y=b.y+c.y;this.z=b.z+c.z;return this},addSelf:function(b){this.x+=b.x;this.y+=b.y;this.z+=b.z;return this},
addScalar:function(b){this.x+=b;this.y+=b;this.z+=b;return this},sub:function(b,c){this.x=b.x-c.x;this.y=b.y-c.y;this.z=b.z-c.z;return this},subSelf:function(b){this.x-=b.x;this.y-=b.y;this.z-=b.z;return this},multiply:function(b,c){this.x=b.x*c.x;this.y=b.y*c.y;this.z=b.z*c.z;return this},multiplySelf:function(b){this.x*=b.x;this.y*=b.y;this.z*=b.z;return this},multiplyScalar:function(b){this.x*=b;this.y*=b;this.z*=b;return this},divideSelf:function(b){this.x/=b.x;this.y/=b.y;this.z/=b.z;return this},
divideScalar:function(b){b?(this.x/=b,this.y/=b,this.z/=b):this.set(0,0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(b){return this.x*b.x+this.y*b.y+this.z*b.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.lengthSq())},lengthManhattan:function(){return this.x+this.y+this.z},normalize:function(){return this.divideScalar(this.length())},setLength:function(b){return this.normalize().multiplyScalar(b)},
cross:function(b,c){this.x=b.y*c.z-b.z*c.y;this.y=b.z*c.x-b.x*c.z;this.z=b.x*c.y-b.y*c.x;return this},crossSelf:function(b){return this.set(this.y*b.z-this.z*b.y,this.z*b.x-this.x*b.z,this.x*b.y-this.y*b.x)},distanceTo:function(b){return Math.sqrt(this.distanceToSquared(b))},distanceToSquared:function(b){return(new THREE.Vector3).sub(this,b).lengthSq()},setPositionFromMatrix:function(b){this.x=b.n14;this.y=b.n24;this.z=b.n34},setRotationFromMatrix:function(b){var c=Math.cos(this.y);this.y=Math.asin(b.n13);
Math.abs(c)>1.0E-5?(this.x=Math.atan2(-b.n23/c,b.n33/c),this.z=Math.atan2(-b.n12/c,b.n11/c)):(this.x=0,this.z=Math.atan2(b.n21,b.n22))},isZero:function(){return this.lengthSq()<1.0E-4}};THREE.Vector4=function(b,c,e,f){this.x=b||0;this.y=c||0;this.z=e||0;this.w=f!==void 0?f:1};
THREE.Vector4.prototype={constructor:THREE.Vector4,set:function(b,c,e,f){this.x=b;this.y=c;this.z=e;this.w=f;return this},copy:function(b){this.x=b.x;this.y=b.y;this.z=b.z;this.w=b.w!==void 0?b.w:1},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)},add:function(b,c){this.x=b.x+c.x;this.y=b.y+c.y;this.z=b.z+c.z;this.w=b.w+c.w;return this},addSelf:function(b){this.x+=b.x;this.y+=b.y;this.z+=b.z;this.w+=b.w;return this},sub:function(b,c){this.x=b.x-c.x;this.y=b.y-c.y;this.z=b.z-
c.z;this.w=b.w-c.w;return this},subSelf:function(b){this.x-=b.x;this.y-=b.y;this.z-=b.z;this.w-=b.w;return this},multiplyScalar:function(b){this.x*=b;this.y*=b;this.z*=b;this.w*=b;return this},divideScalar:function(b){b?(this.x/=b,this.y/=b,this.z/=b,this.w/=b):(this.z=this.y=this.x=0,this.w=1);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(b){return this.x*b.x+this.y*b.y+this.z*b.z+this.w*b.w},lengthSq:function(){return this.dot(this)},length:function(){return Math.sqrt(this.lengthSq())},
normalize:function(){return this.divideScalar(this.length())},setLength:function(b){return this.normalize().multiplyScalar(b)},lerpSelf:function(b,c){this.x+=(b.x-this.x)*c;this.y+=(b.y-this.y)*c;this.z+=(b.z-this.z)*c;this.w+=(b.w-this.w)*c;return this}};THREE.Ray=function(b,c){this.origin=b||new THREE.Vector3;this.direction=c||new THREE.Vector3};
THREE.Ray.prototype={constructor:THREE.Ray,intersectScene:function(b){return this.intersectObjects(b.objects)},intersectObjects:function(b){var c,e,f=[];c=0;for(e=b.length;c<e;c++)f=f.concat(this.intersectObject(b[c]));f.sort(function(b,e){return b.distance-e.distance});return f},intersectObject:function(b){function c(b,e,c){var f;f=c.clone().subSelf(b).dot(e);if(f<=0)return null;b=b.clone().addSelf(e.clone().multiplyScalar(f));return c.distanceTo(b)}function e(b,e,c,f){var f=f.clone().subSelf(e),
c=c.clone().subSelf(e),h=b.clone().subSelf(e),b=f.dot(f),e=f.dot(c),f=f.dot(h),k=c.dot(c),c=c.dot(h),h=1/(b*k-e*e),k=(k*f-e*c)*h,b=(b*c-e*f)*h;return k>0&&b>0&&k+b<1}if(b instanceof THREE.Particle){var f=c(this.origin,this.direction,b.matrixWorld.getPosition());if(f==null||f>b.scale.x)return[];return[{distance:f,point:b.position,face:null,object:b}]}else if(b instanceof THREE.Mesh){f=c(this.origin,this.direction,b.matrixWorld.getPosition());if(f==null||f>b.geometry.boundingSphere.radius*Math.max(b.scale.x,
Math.max(b.scale.y,b.scale.z)))return[];var h,m,k,n,t,u,w,v,x,p,y=b.geometry,z=y.vertices,A=[],f=0;for(h=y.faces.length;f<h;f++)if(m=y.faces[f],x=this.origin.clone(),p=this.direction.clone(),u=b.matrixWorld,k=u.multiplyVector3(m.centroid.clone()).subSelf(x),v=k.dot(p),!(v<=0)&&(k=u.multiplyVector3(z[m.a].position.clone()),n=u.multiplyVector3(z[m.b].position.clone()),t=u.multiplyVector3(z[m.c].position.clone()),u=m instanceof THREE.Face4?u.multiplyVector3(z[m.d].position.clone()):null,w=b.matrixRotationWorld.multiplyVector3(m.normal.clone()),
v=p.dot(w),b.doubleSided||(b.flipSided?v>0:v<0)))if(v=w.dot((new THREE.Vector3).sub(k,x))/v,x=x.addSelf(p.multiplyScalar(v)),m instanceof THREE.Face3)e(x,k,n,t)&&(m={distance:this.origin.distanceTo(x),point:x,face:m,object:b},A.push(m));else if(m instanceof THREE.Face4&&(e(x,k,n,u)||e(x,n,t,u)))m={distance:this.origin.distanceTo(x),point:x,face:m,object:b},A.push(m);A.sort(function(b,e){return b.distance-e.distance});return A}else return[]}};
THREE.Rectangle=function(){function b(){m=f-c;k=h-e}var c,e,f,h,m,k,n=!0;this.getX=function(){return c};this.getY=function(){return e};this.getWidth=function(){return m};this.getHeight=function(){return k};this.getLeft=function(){return c};this.getTop=function(){return e};this.getRight=function(){return f};this.getBottom=function(){return h};this.set=function(k,m,w,v){n=!1;c=k;e=m;f=w;h=v;b()};this.addPoint=function(k,m){n?(n=!1,c=k,e=m,f=k,h=m):(c=c<k?c:k,e=e<m?e:m,f=f>k?f:k,h=h>m?h:m);b()};this.add3Points=
function(k,m,w,v,x,p){n?(n=!1,c=k<w?k<x?k:x:w<x?w:x,e=m<v?m<p?m:p:v<p?v:p,f=k>w?k>x?k:x:w>x?w:x,h=m>v?m>p?m:p:v>p?v:p):(c=k<w?k<x?k<c?k:c:x<c?x:c:w<x?w<c?w:c:x<c?x:c,e=m<v?m<p?m<e?m:e:p<e?p:e:v<p?v<e?v:e:p<e?p:e,f=k>w?k>x?k>f?k:f:x>f?x:f:w>x?w>f?w:f:x>f?x:f,h=m>v?m>p?m>h?m:h:p>h?p:h:v>p?v>h?v:h:p>h?p:h);b()};this.addRectangle=function(k){n?(n=!1,c=k.getLeft(),e=k.getTop(),f=k.getRight(),h=k.getBottom()):(c=c<k.getLeft()?c:k.getLeft(),e=e<k.getTop()?e:k.getTop(),f=f>k.getRight()?f:k.getRight(),h=h>
k.getBottom()?h:k.getBottom());b()};this.inflate=function(k){c-=k;e-=k;f+=k;h+=k;b()};this.minSelf=function(k){c=c>k.getLeft()?c:k.getLeft();e=e>k.getTop()?e:k.getTop();f=f<k.getRight()?f:k.getRight();h=h<k.getBottom()?h:k.getBottom();b()};this.intersects=function(b){return Math.min(f,b.getRight())-Math.max(c,b.getLeft())>=0&&Math.min(h,b.getBottom())-Math.max(e,b.getTop())>=0};this.empty=function(){n=!0;h=f=e=c=0;b()};this.isEmpty=function(){return n}};THREE.Matrix3=function(){this.m=[]};
THREE.Matrix3.prototype={constructor:THREE.Matrix3,transpose:function(){var b,c=this.m;b=c[1];c[1]=c[3];c[3]=b;b=c[2];c[2]=c[6];c[6]=b;b=c[5];c[5]=c[7];c[7]=b;return this},transposeIntoArray:function(b){var c=this.m;b[0]=c[0];b[1]=c[3];b[2]=c[6];b[3]=c[1];b[4]=c[4];b[5]=c[7];b[6]=c[2];b[7]=c[5];b[8]=c[8];return this}};
THREE.Matrix4=function(b,c,e,f,h,m,k,n,t,u,w,v,x,p,y,z){this.set(b!==void 0?b:1,c||0,e||0,f||0,h||0,m!==void 0?m:1,k||0,n||0,t||0,u||0,w!==void 0?w:1,v||0,x||0,p||0,y||0,z!==void 0?z:1);this.flat=Array(16);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={constructor:THREE.Matrix4,set:function(b,c,e,f,h,m,k,n,t,u,w,v,x,p,y,z){this.n11=b;this.n12=c;this.n13=e;this.n14=f;this.n21=h;this.n22=m;this.n23=k;this.n24=n;this.n31=t;this.n32=u;this.n33=w;this.n34=v;this.n41=x;this.n42=p;this.n43=y;this.n44=z;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(b){this.set(b.n11,b.n12,b.n13,b.n14,b.n21,b.n22,b.n23,b.n24,b.n31,b.n32,b.n33,b.n34,b.n41,b.n42,b.n43,b.n44);return this},lookAt:function(b,
c,e){var f=THREE.Matrix4.__v1,h=THREE.Matrix4.__v2,m=THREE.Matrix4.__v3;m.sub(b,c).normalize();if(m.length()===0)m.z=1;f.cross(e,m).normalize();f.length()===0&&(m.x+=1.0E-4,f.cross(e,m).normalize());h.cross(m,f).normalize();this.n11=f.x;this.n12=h.x;this.n13=m.x;this.n21=f.y;this.n22=h.y;this.n23=m.y;this.n31=f.z;this.n32=h.z;this.n33=m.z;return this},multiplyVector3:function(b){var c=b.x,e=b.y,f=b.z,h=1/(this.n41*c+this.n42*e+this.n43*f+this.n44);b.x=(this.n11*c+this.n12*e+this.n13*f+this.n14)*h;
b.y=(this.n21*c+this.n22*e+this.n23*f+this.n24)*h;b.z=(this.n31*c+this.n32*e+this.n33*f+this.n34)*h;return b},multiplyVector4:function(b){var c=b.x,e=b.y,f=b.z,h=b.w;b.x=this.n11*c+this.n12*e+this.n13*f+this.n14*h;b.y=this.n21*c+this.n22*e+this.n23*f+this.n24*h;b.z=this.n31*c+this.n32*e+this.n33*f+this.n34*h;b.w=this.n41*c+this.n42*e+this.n43*f+this.n44*h;return b},rotateAxis:function(b){var c=b.x,e=b.y,f=b.z;b.x=c*this.n11+e*this.n12+f*this.n13;b.y=c*this.n21+e*this.n22+f*this.n23;b.z=c*this.n31+
e*this.n32+f*this.n33;b.normalize();return b},crossVector:function(b){var c=new THREE.Vector4;c.x=this.n11*b.x+this.n12*b.y+this.n13*b.z+this.n14*b.w;c.y=this.n21*b.x+this.n22*b.y+this.n23*b.z+this.n24*b.w;c.z=this.n31*b.x+this.n32*b.y+this.n33*b.z+this.n34*b.w;c.w=b.w?this.n41*b.x+this.n42*b.y+this.n43*b.z+this.n44*b.w:1;return c},multiply:function(b,c){var e=b.n11,f=b.n12,h=b.n13,m=b.n14,k=b.n21,n=b.n22,t=b.n23,u=b.n24,w=b.n31,v=b.n32,x=b.n33,p=b.n34,y=b.n41,z=b.n42,A=b.n43,C=b.n44,E=c.n11,G=c.n12,
H=c.n13,M=c.n14,R=c.n21,J=c.n22,I=c.n23,K=c.n24,W=c.n31,D=c.n32,S=c.n33,U=c.n34,da=c.n41,Q=c.n42,o=c.n43,pa=c.n44;this.n11=e*E+f*R+h*W+m*da;this.n12=e*G+f*J+h*D+m*Q;this.n13=e*H+f*I+h*S+m*o;this.n14=e*M+f*K+h*U+m*pa;this.n21=k*E+n*R+t*W+u*da;this.n22=k*G+n*J+t*D+u*Q;this.n23=k*H+n*I+t*S+u*o;this.n24=k*M+n*K+t*U+u*pa;this.n31=w*E+v*R+x*W+p*da;this.n32=w*G+v*J+x*D+p*Q;this.n33=w*H+v*I+x*S+p*o;this.n34=w*M+v*K+x*U+p*pa;this.n41=y*E+z*R+A*W+C*da;this.n42=y*G+z*J+A*D+C*Q;this.n43=y*H+z*I+A*S+C*o;this.n44=
y*M+z*K+A*U+C*pa;return this},multiplyToArray:function(b,c,e){this.multiply(b,c);e[0]=this.n11;e[1]=this.n21;e[2]=this.n31;e[3]=this.n41;e[4]=this.n12;e[5]=this.n22;e[6]=this.n32;e[7]=this.n42;e[8]=this.n13;e[9]=this.n23;e[10]=this.n33;e[11]=this.n43;e[12]=this.n14;e[13]=this.n24;e[14]=this.n34;e[15]=this.n44;return this},multiplySelf:function(b){this.multiply(this,b);return this},multiplyScalar:function(b){this.n11*=b;this.n12*=b;this.n13*=b;this.n14*=b;this.n21*=b;this.n22*=b;this.n23*=b;this.n24*=
b;this.n31*=b;this.n32*=b;this.n33*=b;this.n34*=b;this.n41*=b;this.n42*=b;this.n43*=b;this.n44*=b;return this},determinant:function(){var b=this.n11,c=this.n12,e=this.n13,f=this.n14,h=this.n21,m=this.n22,k=this.n23,n=this.n24,t=this.n31,u=this.n32,w=this.n33,v=this.n34,x=this.n41,p=this.n42,y=this.n43,z=this.n44;return f*k*u*x-e*n*u*x-f*m*w*x+c*n*w*x+e*m*v*x-c*k*v*x-f*k*t*p+e*n*t*p+f*h*w*p-b*n*w*p-e*h*v*p+b*k*v*p+f*m*t*y-c*n*t*y-f*h*u*y+b*n*u*y+c*h*v*y-b*m*v*y-e*m*t*z+c*k*t*z+e*h*u*z-b*k*u*z-c*h*
w*z+b*m*w*z},transpose:function(){var b;b=this.n21;this.n21=this.n12;this.n12=b;b=this.n31;this.n31=this.n13;this.n13=b;b=this.n32;this.n32=this.n23;this.n23=b;b=this.n41;this.n41=this.n14;this.n14=b;b=this.n42;this.n42=this.n24;this.n24=b;b=this.n43;this.n43=this.n34;this.n43=b;return this},clone:function(){var b=new THREE.Matrix4;b.n11=this.n11;b.n12=this.n12;b.n13=this.n13;b.n14=this.n14;b.n21=this.n21;b.n22=this.n22;b.n23=this.n23;b.n24=this.n24;b.n31=this.n31;b.n32=this.n32;b.n33=this.n33;b.n34=
this.n34;b.n41=this.n41;b.n42=this.n42;b.n43=this.n43;b.n44=this.n44;return b},flatten:function(){this.flat[0]=this.n11;this.flat[1]=this.n21;this.flat[2]=this.n31;this.flat[3]=this.n41;this.flat[4]=this.n12;this.flat[5]=this.n22;this.flat[6]=this.n32;this.flat[7]=this.n42;this.flat[8]=this.n13;this.flat[9]=this.n23;this.flat[10]=this.n33;this.flat[11]=this.n43;this.flat[12]=this.n14;this.flat[13]=this.n24;this.flat[14]=this.n34;this.flat[15]=this.n44;return this.flat},flattenToArray:function(b){b[0]=
this.n11;b[1]=this.n21;b[2]=this.n31;b[3]=this.n41;b[4]=this.n12;b[5]=this.n22;b[6]=this.n32;b[7]=this.n42;b[8]=this.n13;b[9]=this.n23;b[10]=this.n33;b[11]=this.n43;b[12]=this.n14;b[13]=this.n24;b[14]=this.n34;b[15]=this.n44;return b},flattenToArrayOffset:function(b,c){b[c]=this.n11;b[c+1]=this.n21;b[c+2]=this.n31;b[c+3]=this.n41;b[c+4]=this.n12;b[c+5]=this.n22;b[c+6]=this.n32;b[c+7]=this.n42;b[c+8]=this.n13;b[c+9]=this.n23;b[c+10]=this.n33;b[c+11]=this.n43;b[c+12]=this.n14;b[c+13]=this.n24;b[c+14]=
this.n34;b[c+15]=this.n44;return b},setTranslation:function(b,c,e){this.set(1,0,0,b,0,1,0,c,0,0,1,e,0,0,0,1);return this},setScale:function(b,c,e){this.set(b,0,0,0,0,c,0,0,0,0,e,0,0,0,0,1);return this},setRotationX:function(b){var c=Math.cos(b),b=Math.sin(b);this.set(1,0,0,0,0,c,-b,0,0,b,c,0,0,0,0,1);return this},setRotationY:function(b){var c=Math.cos(b),b=Math.sin(b);this.set(c,0,b,0,0,1,0,0,-b,0,c,0,0,0,0,1);return this},setRotationZ:function(b){var c=Math.cos(b),b=Math.sin(b);this.set(c,-b,0,
0,b,c,0,0,0,0,1,0,0,0,0,1);return this},setRotationAxis:function(b,c){var e=Math.cos(c),f=Math.sin(c),h=1-e,m=b.x,k=b.y,n=b.z,t=h*m,u=h*k;this.set(t*m+e,t*k-f*n,t*n+f*k,0,t*k+f*n,u*k+e,u*n-f*m,0,t*n-f*k,u*n+f*m,h*n*n+e,0,0,0,0,1);return this},setPosition:function(b){this.n14=b.x;this.n24=b.y;this.n34=b.z;return this},getPosition:function(){if(!this.position)this.position=new THREE.Vector3;this.position.set(this.n14,this.n24,this.n34);return this.position},getColumnX:function(){if(!this.columnX)this.columnX=
new THREE.Vector3;this.columnX.set(this.n11,this.n21,this.n31);return this.columnX},getColumnY:function(){if(!this.columnY)this.columnY=new THREE.Vector3;this.columnY.set(this.n12,this.n22,this.n32);return this.columnY},getColumnZ:function(){if(!this.columnZ)this.columnZ=new THREE.Vector3;this.columnZ.set(this.n13,this.n23,this.n33);return this.columnZ},setRotationFromEuler:function(b,c){var e=b.x,f=b.y,h=b.z,m=Math.cos(e),e=Math.sin(e),k=Math.cos(f),f=Math.sin(f),n=Math.cos(h),h=Math.sin(h);switch(c){case "YXZ":var t=
k*n,u=k*h,w=f*n,v=f*h;this.n11=t+v*e;this.n12=w*e-u;this.n13=m*f;this.n21=m*h;this.n22=m*n;this.n23=-e;this.n31=u*e-w;this.n32=v+t*e;this.n33=m*k;break;case "ZXY":t=k*n;u=k*h;w=f*n;v=f*h;this.n11=t-v*e;this.n12=-m*h;this.n13=w+u*e;this.n21=u+w*e;this.n22=m*n;this.n23=v-t*e;this.n31=-m*f;this.n32=e;this.n33=m*k;break;case "ZYX":t=m*n;u=m*h;w=e*n;v=e*h;this.n11=k*n;this.n12=w*f-u;this.n13=t*f+v;this.n21=k*h;this.n22=v*f+t;this.n23=u*f-w;this.n31=-f;this.n32=e*k;this.n33=m*k;break;case "YZX":t=m*k;u=
m*f;w=e*k;v=e*f;this.n11=k*n;this.n12=v-t*h;this.n13=w*h+u;this.n21=h;this.n22=m*n;this.n23=-e*n;this.n31=-f*n;this.n32=u*h+w;this.n33=t-v*h;break;case "XZY":t=m*k;u=m*f;w=e*k;v=e*f;this.n11=k*n;this.n12=-h;this.n13=f*n;this.n21=t*h+v;this.n22=m*n;this.n23=u*h-w;this.n31=w*h-u;this.n32=e*n;this.n33=v*h+t;break;default:t=m*n,u=m*h,w=e*n,v=e*h,this.n11=k*n,this.n12=-k*h,this.n13=f,this.n21=u+w*f,this.n22=t-v*f,this.n23=-e*k,this.n31=v-t*f,this.n32=w+u*f,this.n33=m*k}return this},setRotationFromQuaternion:function(b){var c=
b.x,e=b.y,f=b.z,h=b.w,m=c+c,k=e+e,n=f+f,b=c*m,t=c*k;c*=n;var u=e*k;e*=n;f*=n;m*=h;k*=h;h*=n;this.n11=1-(u+f);this.n12=t-h;this.n13=c+k;this.n21=t+h;this.n22=1-(b+f);this.n23=e-m;this.n31=c-k;this.n32=e+m;this.n33=1-(b+u);return this},scale:function(b){var c=b.x,e=b.y,b=b.z;this.n11*=c;this.n12*=e;this.n13*=b;this.n21*=c;this.n22*=e;this.n23*=b;this.n31*=c;this.n32*=e;this.n33*=b;this.n41*=c;this.n42*=e;this.n43*=b;return this},compose:function(b,c,e){var f=THREE.Matrix4.__m1,h=THREE.Matrix4.__m2;
f.identity();f.setRotationFromQuaternion(c);h.setScale(e.x,e.y,e.z);this.multiply(f,h);this.n14=b.x;this.n24=b.y;this.n34=b.z;return this},decompose:function(b,c,e){var f=THREE.Matrix4.__v1,h=THREE.Matrix4.__v2,m=THREE.Matrix4.__v3;f.set(this.n11,this.n21,this.n31);h.set(this.n12,this.n22,this.n32);m.set(this.n13,this.n23,this.n33);b=b instanceof THREE.Vector3?b:new THREE.Vector3;c=c instanceof THREE.Quaternion?c:new THREE.Quaternion;e=e instanceof THREE.Vector3?e:new THREE.Vector3;e.x=f.length();
e.y=h.length();e.z=m.length();b.x=this.n14;b.y=this.n24;b.z=this.n34;f=THREE.Matrix4.__m1;f.copy(this);f.n11/=e.x;f.n21/=e.x;f.n31/=e.x;f.n12/=e.y;f.n22/=e.y;f.n32/=e.y;f.n13/=e.z;f.n23/=e.z;f.n33/=e.z;c.setFromRotationMatrix(f);return[b,c,e]},extractPosition:function(b){this.n14=b.n14;this.n24=b.n24;this.n34=b.n34},extractRotation:function(b,c){var e=1/c.x,f=1/c.y,h=1/c.z;this.n11=b.n11*e;this.n21=b.n21*e;this.n31=b.n31*e;this.n12=b.n12*f;this.n22=b.n22*f;this.n32=b.n32*f;this.n13=b.n13*h;this.n23=
b.n23*h;this.n33=b.n33*h}};
THREE.Matrix4.makeInvert=function(b,c){var e=b.n11,f=b.n12,h=b.n13,m=b.n14,k=b.n21,n=b.n22,t=b.n23,u=b.n24,w=b.n31,v=b.n32,x=b.n33,p=b.n34,y=b.n41,z=b.n42,A=b.n43,C=b.n44;c===void 0&&(c=new THREE.Matrix4);c.n11=t*p*z-u*x*z+u*v*A-n*p*A-t*v*C+n*x*C;c.n12=m*x*z-h*p*z-m*v*A+f*p*A+h*v*C-f*x*C;c.n13=h*u*z-m*t*z+m*n*A-f*u*A-h*n*C+f*t*C;c.n14=m*t*v-h*u*v-m*n*x+f*u*x+h*n*p-f*t*p;c.n21=u*x*y-t*p*y-u*w*A+k*p*A+t*w*C-k*x*C;c.n22=h*p*y-m*x*y+m*w*A-e*p*A-h*w*C+e*x*C;c.n23=m*t*y-h*u*y-m*k*A+e*u*A+h*k*C-e*t*C;c.n24=
h*u*w-m*t*w+m*k*x-e*u*x-h*k*p+e*t*p;c.n31=n*p*y-u*v*y+u*w*z-k*p*z-n*w*C+k*v*C;c.n32=m*v*y-f*p*y-m*w*z+e*p*z+f*w*C-e*v*C;c.n33=h*u*y-m*n*y+m*k*z-e*u*z-f*k*C+e*n*C;c.n34=m*n*w-f*u*w-m*k*v+e*u*v+f*k*p-e*n*p;c.n41=t*v*y-n*x*y-t*w*z+k*x*z+n*w*A-k*v*A;c.n42=f*x*y-h*v*y+h*w*z-e*x*z-f*w*A+e*v*A;c.n43=h*n*y-f*t*y-h*k*z+e*t*z+f*k*A-e*n*A;c.n44=f*t*w-h*n*w+h*k*v-e*t*v-f*k*x+e*n*x;c.multiplyScalar(1/b.determinant());return c};
THREE.Matrix4.makeInvert3x3=function(b){var c=b.m33,e=c.m,f=b.n33*b.n22-b.n32*b.n23,h=-b.n33*b.n21+b.n31*b.n23,m=b.n32*b.n21-b.n31*b.n22,k=-b.n33*b.n12+b.n32*b.n13,n=b.n33*b.n11-b.n31*b.n13,t=-b.n32*b.n11+b.n31*b.n12,u=b.n23*b.n12-b.n22*b.n13,w=-b.n23*b.n11+b.n21*b.n13,v=b.n22*b.n11-b.n21*b.n12,b=b.n11*f+b.n21*k+b.n31*u;b==0&&console.error("THREE.Matrix4.makeInvert3x3: Matrix not invertible.");b=1/b;e[0]=b*f;e[1]=b*h;e[2]=b*m;e[3]=b*k;e[4]=b*n;e[5]=b*t;e[6]=b*u;e[7]=b*w;e[8]=b*v;return c};
THREE.Matrix4.makeFrustum=function(b,c,e,f,h,m){var k;k=new THREE.Matrix4;k.n11=2*h/(c-b);k.n12=0;k.n13=(c+b)/(c-b);k.n14=0;k.n21=0;k.n22=2*h/(f-e);k.n23=(f+e)/(f-e);k.n24=0;k.n31=0;k.n32=0;k.n33=-(m+h)/(m-h);k.n34=-2*m*h/(m-h);k.n41=0;k.n42=0;k.n43=-1;k.n44=0;return k};THREE.Matrix4.makePerspective=function(b,c,e,f){var h,b=e*Math.tan(b*Math.PI/360);h=-b;return THREE.Matrix4.makeFrustum(h*c,b*c,h,b,e,f)};
THREE.Matrix4.makeOrtho=function(b,c,e,f,h,m){var k,n,t,u;k=new THREE.Matrix4;n=c-b;t=e-f;u=m-h;k.n11=2/n;k.n12=0;k.n13=0;k.n14=-((c+b)/n);k.n21=0;k.n22=2/t;k.n23=0;k.n24=-((e+f)/t);k.n31=0;k.n32=0;k.n33=-2/u;k.n34=-((m+h)/u);k.n41=0;k.n42=0;k.n43=0;k.n44=1;return k};THREE.Matrix4.__v1=new THREE.Vector3;THREE.Matrix4.__v2=new THREE.Vector3;THREE.Matrix4.__v3=new THREE.Vector3;THREE.Matrix4.__m1=new THREE.Matrix4;THREE.Matrix4.__m2=new THREE.Matrix4;
THREE.Object3D=function(){this.id=THREE.Object3DCount++;this.name="";this.parent=void 0;this.children=[];this.up=new THREE.Vector3(0,1,0);this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.eulerOrder="XYZ";this.scale=new THREE.Vector3(1,1,1);this.flipSided=this.doubleSided=this.dynamic=!1;this.renderDepth=null;this.rotationAutoUpdate=!0;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixWorldNeedsUpdate=this.matrixAutoUpdate=
!0;this.quaternion=new THREE.Quaternion;this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;this.visible=!0;this.receiveShadow=this.castShadow=!1;this.frustumCulled=!0;this._vector=new THREE.Vector3};
THREE.Object3D.prototype={constructor:THREE.Object3D,translate:function(b,c){this.matrix.rotateAxis(c);this.position.addSelf(c.multiplyScalar(b))},translateX:function(b){this.translate(b,this._vector.set(1,0,0))},translateY:function(b){this.translate(b,this._vector.set(0,1,0))},translateZ:function(b){this.translate(b,this._vector.set(0,0,1))},lookAt:function(b){this.matrix.lookAt(b,this.position,this.up);this.rotationAutoUpdate&&this.rotation.setRotationFromMatrix(this.matrix)},add:function(b){if(this.children.indexOf(b)===
-1){b.parent!==void 0&&b.parent.removeChild(b);b.parent=this;this.children.push(b);for(var c=this;c.parent!==void 0;)c=c.parent;c!==void 0&&c instanceof THREE.Scene&&c.addChildRecurse(b)}},remove:function(b){var c=this,e=this.children.indexOf(b);if(e!==-1){b.parent=void 0;for(this.children.splice(e,1);c.parent!==void 0;)c=c.parent;c!==void 0&&c instanceof THREE.Scene&&c.removeChildRecurse(b)}},getChildByName:function(b,c){var e,f,h;e=0;for(f=this.children.length;e<f;e++){h=this.children[e];if(h.name===
b)return h;if(c&&(h=h.getChildByName(b,c),h!==void 0))return h}},updateMatrix:function(){this.matrix.setPosition(this.position);this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation,this.eulerOrder);if(this.scale.x!==1||this.scale.y!==1||this.scale.z!==1)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z));this.matrixWorldNeedsUpdate=!0},update:function(b,c,e){this.matrixAutoUpdate&&
this.updateMatrix();if(this.matrixWorldNeedsUpdate||c)b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixRotationWorld.extractRotation(this.matrixWorld,this.scale),this.matrixWorldNeedsUpdate=!1,c=!0;for(var b=0,f=this.children.length;b<f;b++)this.children[b].update(this.matrixWorld,c,e)},addChild:function(b){console.warn("DEPRECATED: Object3D.addChild() is now Object3D.add()");this.add(b)},removeChild:function(b){console.warn("DEPRECATED: Object3D.removeChild() is now Object3D.remove()");
this.remove(b)}};THREE.Object3DCount=0;
THREE.Projector=function(){function b(){var b=t[n]=t[n]||new THREE.RenderableVertex;n++;return b}function c(b,e){return e.z-b.z}function e(b,e){var c=0,f=1,k=b.z+b.w,h=e.z+e.w,m=-b.z+b.w,n=-e.z+e.w;return k>=0&&h>=0&&m>=0&&n>=0?!0:k<0&&h<0||m<0&&n<0?!1:(k<0?c=Math.max(c,k/(k-h)):h<0&&(f=Math.min(f,k/(k-h))),m<0?c=Math.max(c,m/(m-n)):n<0&&(f=Math.min(f,m/(m-n))),f<c?!1:(b.lerpSelf(e,c),e.lerpSelf(b,1-f),!0))}var f,h,m=[],k,n,t=[],u,w,v=[],x,p=[],y,z,A=[],C,E,G=[],H=[],M=[],R=new THREE.Vector4,J=new THREE.Vector4,
I=new THREE.Matrix4,K=new THREE.Matrix4,W=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],D=new THREE.Vector4,S=new THREE.Vector4;this.projectVector=function(b,e){I.multiply(e.projectionMatrix,e.matrixWorldInverse);I.multiplyVector3(b);return b};this.unprojectVector=function(b,e){I.multiply(e.matrixWorld,THREE.Matrix4.makeInvert(e.projectionMatrix));I.multiplyVector3(b);return b};this.projectObjects=function(b,e,k){var o,n;h=H.length=0;
o=b.objects;b=0;for(e=o.length;b<e;b++){n=o[b];var p;if(!(p=!n.visible))if(p=n instanceof THREE.Mesh)if(p=n.frustumCulled){a:{p=void 0;for(var v=n.matrixWorld,t=-n.geometry.boundingSphere.radius*Math.max(n.scale.x,Math.max(n.scale.y,n.scale.z)),u=0;u<6;u++)if(p=W[u].x*v.n14+W[u].y*v.n24+W[u].z*v.n34+W[u].w,p<=t){p=!1;break a}p=!0}p=!p}if(!p)p=m[h]=m[h]||new THREE.RenderableObject,h++,f=p,R.copy(n.position),I.multiplyVector3(R),f.object=n,f.z=R.z,H.push(f)}k&&H.sort(c);return H};this.projectScene=
function(f,h,m){var o=h.near,H=h.far,R,ma,ca,na,ja,la,ga,Z,V,$,ea,ka,ta,N,fa,ra,ua;E=z=x=w=M.length=0;h.matrixAutoUpdate&&h.update(void 0,!0);f.update(void 0,!1,h);I.multiply(h.projectionMatrix,h.matrixWorldInverse);W[0].set(I.n41-I.n11,I.n42-I.n12,I.n43-I.n13,I.n44-I.n14);W[1].set(I.n41+I.n11,I.n42+I.n12,I.n43+I.n13,I.n44+I.n14);W[2].set(I.n41+I.n21,I.n42+I.n22,I.n43+I.n23,I.n44+I.n24);W[3].set(I.n41-I.n21,I.n42-I.n22,I.n43-I.n23,I.n44-I.n24);W[4].set(I.n41-I.n31,I.n42-I.n32,I.n43-I.n33,I.n44-I.n34);
W[5].set(I.n41+I.n31,I.n42+I.n32,I.n43+I.n33,I.n44+I.n34);for(R=0;R<6;R++)V=W[R],V.divideScalar(Math.sqrt(V.x*V.x+V.y*V.y+V.z*V.z));V=this.projectObjects(f,h,!0);f=0;for(R=V.length;f<R;f++)if($=V[f].object,$.visible)if(ea=$.matrixWorld,ka=$.matrixRotationWorld,ta=$.materials,N=$.overdraw,n=0,$ instanceof THREE.Mesh){fa=$.geometry;na=fa.vertices;ra=fa.faces;fa=fa.faceVertexUvs;ma=0;for(ca=na.length;ma<ca;ma++)k=b(),k.positionWorld.copy(na[ma].position),ea.multiplyVector3(k.positionWorld),k.positionScreen.copy(k.positionWorld),
I.multiplyVector4(k.positionScreen),k.positionScreen.x/=k.positionScreen.w,k.positionScreen.y/=k.positionScreen.w,k.visible=k.positionScreen.z>o&&k.positionScreen.z<H;na=0;for(ma=ra.length;na<ma;na++){ca=ra[na];if(ca instanceof THREE.Face3)if(ja=t[ca.a],la=t[ca.b],ga=t[ca.c],ja.visible&&la.visible&&ga.visible&&($.doubleSided||$.flipSided!=(ga.positionScreen.x-ja.positionScreen.x)*(la.positionScreen.y-ja.positionScreen.y)-(ga.positionScreen.y-ja.positionScreen.y)*(la.positionScreen.x-ja.positionScreen.x)<
0))Z=v[w]=v[w]||new THREE.RenderableFace3,w++,u=Z,u.v1.copy(ja),u.v2.copy(la),u.v3.copy(ga);else continue;else if(ca instanceof THREE.Face4)if(ja=t[ca.a],la=t[ca.b],ga=t[ca.c],Z=t[ca.d],ja.visible&&la.visible&&ga.visible&&Z.visible&&($.doubleSided||$.flipSided!=((Z.positionScreen.x-ja.positionScreen.x)*(la.positionScreen.y-ja.positionScreen.y)-(Z.positionScreen.y-ja.positionScreen.y)*(la.positionScreen.x-ja.positionScreen.x)<0||(la.positionScreen.x-ga.positionScreen.x)*(Z.positionScreen.y-ga.positionScreen.y)-
(la.positionScreen.y-ga.positionScreen.y)*(Z.positionScreen.x-ga.positionScreen.x)<0)))ua=p[x]=p[x]||new THREE.RenderableFace4,x++,u=ua,u.v1.copy(ja),u.v2.copy(la),u.v3.copy(ga),u.v4.copy(Z);else continue;u.normalWorld.copy(ca.normal);ka.multiplyVector3(u.normalWorld);u.centroidWorld.copy(ca.centroid);ea.multiplyVector3(u.centroidWorld);u.centroidScreen.copy(u.centroidWorld);I.multiplyVector3(u.centroidScreen);ga=ca.vertexNormals;ja=0;for(la=ga.length;ja<la;ja++)Z=u.vertexNormalsWorld[ja],Z.copy(ga[ja]),
ka.multiplyVector3(Z);ja=0;for(la=fa.length;ja<la;ja++)if(ua=fa[ja][na]){ga=0;for(Z=ua.length;ga<Z;ga++)u.uvs[ja][ga]=ua[ga]}u.meshMaterials=ta;u.faceMaterials=ca.materials;u.overdraw=N;u.z=u.centroidScreen.z;M.push(u)}}else if($ instanceof THREE.Line){K.multiply(I,ea);na=$.geometry.vertices;ja=b();ja.positionScreen.copy(na[0].position);K.multiplyVector4(ja.positionScreen);ma=1;for(ca=na.length;ma<ca;ma++)if(ja=b(),ja.positionScreen.copy(na[ma].position),K.multiplyVector4(ja.positionScreen),la=t[n-
2],D.copy(ja.positionScreen),S.copy(la.positionScreen),e(D,S))D.multiplyScalar(1/D.w),S.multiplyScalar(1/S.w),ea=A[z]=A[z]||new THREE.RenderableLine,z++,y=ea,y.v1.positionScreen.copy(D),y.v2.positionScreen.copy(S),y.z=Math.max(D.z,S.z),y.materials=$.materials,M.push(y)}else if($ instanceof THREE.Particle&&(J.set($.matrixWorld.n14,$.matrixWorld.n24,$.matrixWorld.n34,1),I.multiplyVector4(J),J.z/=J.w,J.z>0&&J.z<1))ea=G[E]=G[E]||new THREE.RenderableParticle,E++,C=ea,C.x=J.x/J.w,C.y=J.y/J.w,C.z=J.z,C.rotation=
$.rotation.z,C.scale.x=$.scale.x*Math.abs(C.x-(J.x+h.projectionMatrix.n11)/(J.w+h.projectionMatrix.n14)),C.scale.y=$.scale.y*Math.abs(C.y-(J.y+h.projectionMatrix.n22)/(J.w+h.projectionMatrix.n24)),C.materials=$.materials,M.push(C);m&&M.sort(c);return M}};THREE.Quaternion=function(b,c,e,f){this.set(b||0,c||0,e||0,f!==void 0?f:1)};
THREE.Quaternion.prototype={constructor:THREE.Quaternion,set:function(b,c,e,f){this.x=b;this.y=c;this.z=e;this.w=f;return this},copy:function(b){this.x=b.x;this.y=b.y;this.z=b.z;this.w=b.w;return this},setFromEuler:function(b){var c=0.5*Math.PI/360,e=b.x*c,f=b.y*c,h=b.z*c,b=Math.cos(f),f=Math.sin(f),c=Math.cos(-h),h=Math.sin(-h),m=Math.cos(e),e=Math.sin(e),k=b*c,n=f*h;this.w=k*m-n*e;this.x=k*e+n*m;this.y=f*c*m+b*h*e;this.z=b*h*m-f*c*e;return this},setFromAxisAngle:function(b,c){var e=c/2,f=Math.sin(e);
this.x=b.x*f;this.y=b.y*f;this.z=b.z*f;this.w=Math.cos(e);return this},setFromRotationMatrix:function(b){var c=Math.pow(b.determinant(),1/3);this.w=Math.sqrt(Math.max(0,c+b.n11+b.n22+b.n33))/2;this.x=Math.sqrt(Math.max(0,c+b.n11-b.n22-b.n33))/2;this.y=Math.sqrt(Math.max(0,c-b.n11+b.n22-b.n33))/2;this.z=Math.sqrt(Math.max(0,c-b.n11-b.n22+b.n33))/2;this.x=b.n32-b.n23<0?-Math.abs(this.x):Math.abs(this.x);this.y=b.n13-b.n31<0?-Math.abs(this.y):Math.abs(this.y);this.z=b.n21-b.n12<0?-Math.abs(this.z):Math.abs(this.z);
this.normalize();return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var b=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);b==0?this.w=this.z=this.y=this.x=0:(b=1/b,this.x*=b,this.y*=b,this.z*=b,this.w*=b);return this},multiplySelf:function(b){var c=
this.x,e=this.y,f=this.z,h=this.w,m=b.x,k=b.y,n=b.z,b=b.w;this.x=c*b+h*m+e*n-f*k;this.y=e*b+h*k+f*m-c*n;this.z=f*b+h*n+c*k-e*m;this.w=h*b-c*m-e*k-f*n;return this},multiply:function(b,c){this.x=b.x*c.w+b.y*c.z-b.z*c.y+b.w*c.x;this.y=-b.x*c.z+b.y*c.w+b.z*c.x+b.w*c.y;this.z=b.x*c.y-b.y*c.x+b.z*c.w+b.w*c.z;this.w=-b.x*c.x-b.y*c.y-b.z*c.z+b.w*c.w;return this},multiplyVector3:function(b,c){c||(c=b);var e=b.x,f=b.y,h=b.z,m=this.x,k=this.y,n=this.z,t=this.w,u=t*e+k*h-n*f,w=t*f+n*e-m*h,v=t*h+m*f-k*e,e=-m*
e-k*f-n*h;c.x=u*t+e*-m+w*-n-v*-k;c.y=w*t+e*-k+v*-m-u*-n;c.z=v*t+e*-n+u*-k-w*-m;return c}};THREE.Quaternion.slerp=function(b,c,e,f){var h=b.w*c.w+b.x*c.x+b.y*c.y+b.z*c.z;if(Math.abs(h)>=1)return e.w=b.w,e.x=b.x,e.y=b.y,e.z=b.z,e;var m=Math.acos(h),k=Math.sqrt(1-h*h);if(Math.abs(k)<0.001)return e.w=0.5*(b.w+c.w),e.x=0.5*(b.x+c.x),e.y=0.5*(b.y+c.y),e.z=0.5*(b.z+c.z),e;h=Math.sin((1-f)*m)/k;f=Math.sin(f*m)/k;e.w=b.w*h+c.w*f;e.x=b.x*h+c.x*f;e.y=b.y*h+c.y*f;e.z=b.z*h+c.z*f;return e};
THREE.Vertex=function(b){this.position=b||new THREE.Vector3};THREE.Face3=function(b,c,e,f,h,m){this.a=b;this.b=c;this.c=e;this.normal=f instanceof THREE.Vector3?f:new THREE.Vector3;this.vertexNormals=f instanceof Array?f:[];this.color=h instanceof THREE.Color?h:new THREE.Color;this.vertexColors=h instanceof Array?h:[];this.vertexTangents=[];this.materials=m instanceof Array?m:[m];this.centroid=new THREE.Vector3};
THREE.Face4=function(b,c,e,f,h,m,k){this.a=b;this.b=c;this.c=e;this.d=f;this.normal=h instanceof THREE.Vector3?h:new THREE.Vector3;this.vertexNormals=h instanceof Array?h:[];this.color=m instanceof THREE.Color?m:new THREE.Color;this.vertexColors=m instanceof Array?m:[];this.vertexTangents=[];this.materials=k instanceof Array?k:[k];this.centroid=new THREE.Vector3};THREE.UV=function(b,c){this.u=b||0;this.v=c||0};
THREE.UV.prototype={constructor:THREE.UV,set:function(b,c){this.u=b;this.v=c;return this},copy:function(b){this.u=b.u;this.v=b.v;return this},clone:function(){return new THREE.UV(this.u,this.v)}};
THREE.Geometry=function(){this.id=THREE.GeometryCount++;this.vertices=[];this.colors=[];this.faces=[];this.edges=[];this.faceUvs=[[]];this.faceVertexUvs=[[]];this.morphTargets=[];this.morphColors=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.dynamic=this.hasTangents=!1};
THREE.Geometry.prototype={constructor:THREE.Geometry,applyMatrix:function(b){var c=new THREE.Matrix4;c.extractRotation(b,new THREE.Vector3(1,1,1));for(var e=0,f=this.vertices.length;e<f;e++)b.multiplyVector3(this.vertices[e].position);e=0;for(f=this.faces.length;e<f;e++){var h=this.faces[e];c.multiplyVector3(h.normal);for(var m=0,k=h.vertexNormals.length;m<k;m++)c.multiplyVector3(h.vertexNormals[m]);b.multiplyVector3(h.centroid)}},computeCentroids:function(){var b,c,e;b=0;for(c=this.faces.length;b<
c;b++)e=this.faces[b],e.centroid.set(0,0,0),e instanceof THREE.Face3?(e.centroid.addSelf(this.vertices[e.a].position),e.centroid.addSelf(this.vertices[e.b].position),e.centroid.addSelf(this.vertices[e.c].position),e.centroid.divideScalar(3)):e instanceof THREE.Face4&&(e.centroid.addSelf(this.vertices[e.a].position),e.centroid.addSelf(this.vertices[e.b].position),e.centroid.addSelf(this.vertices[e.c].position),e.centroid.addSelf(this.vertices[e.d].position),e.centroid.divideScalar(4))},computeFaceNormals:function(b){var c,
e,f,h,m,k,n=new THREE.Vector3,t=new THREE.Vector3;f=0;for(h=this.faces.length;f<h;f++){m=this.faces[f];if(b&&m.vertexNormals.length){n.set(0,0,0);c=0;for(e=m.vertexNormals.length;c<e;c++)n.addSelf(m.vertexNormals[c]);n.divideScalar(3)}else c=this.vertices[m.a],e=this.vertices[m.b],k=this.vertices[m.c],n.sub(k.position,e.position),t.sub(c.position,e.position),n.crossSelf(t);n.isZero()||n.normalize();m.normal.copy(n)}},computeVertexNormals:function(){var b,c,e,f;if(this.__tmpVertices==void 0){f=this.__tmpVertices=
Array(this.vertices.length);b=0;for(c=this.vertices.length;b<c;b++)f[b]=new THREE.Vector3;b=0;for(c=this.faces.length;b<c;b++)if(e=this.faces[b],e instanceof THREE.Face3)e.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(e instanceof THREE.Face4)e.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}else{f=this.__tmpVertices;b=0;for(c=this.vertices.length;b<c;b++)f[b].set(0,0,0)}b=0;for(c=this.faces.length;b<c;b++)e=this.faces[b],e instanceof
THREE.Face3?(f[e.a].addSelf(e.normal),f[e.b].addSelf(e.normal),f[e.c].addSelf(e.normal)):e instanceof THREE.Face4&&(f[e.a].addSelf(e.normal),f[e.b].addSelf(e.normal),f[e.c].addSelf(e.normal),f[e.d].addSelf(e.normal));b=0;for(c=this.vertices.length;b<c;b++)f[b].normalize();b=0;for(c=this.faces.length;b<c;b++)e=this.faces[b],e instanceof THREE.Face3?(e.vertexNormals[0].copy(f[e.a]),e.vertexNormals[1].copy(f[e.b]),e.vertexNormals[2].copy(f[e.c])):e instanceof THREE.Face4&&(e.vertexNormals[0].copy(f[e.a]),
e.vertexNormals[1].copy(f[e.b]),e.vertexNormals[2].copy(f[e.c]),e.vertexNormals[3].copy(f[e.d]))},computeTangents:function(){function b(b,e,c,f,h,m,o){n=b.vertices[e].position;t=b.vertices[c].position;u=b.vertices[f].position;w=k[h];v=k[m];x=k[o];p=t.x-n.x;y=u.x-n.x;z=t.y-n.y;A=u.y-n.y;C=t.z-n.z;E=u.z-n.z;G=v.u-w.u;H=x.u-w.u;M=v.v-w.v;R=x.v-w.v;J=1/(G*R-H*M);D.set((R*p-M*y)*J,(R*z-M*A)*J,(R*C-M*E)*J);S.set((G*y-H*p)*J,(G*A-H*z)*J,(G*E-H*C)*J);K[e].addSelf(D);K[c].addSelf(D);K[f].addSelf(D);W[e].addSelf(S);
W[c].addSelf(S);W[f].addSelf(S)}var c,e,f,h,m,k,n,t,u,w,v,x,p,y,z,A,C,E,G,H,M,R,J,I,K=[],W=[],D=new THREE.Vector3,S=new THREE.Vector3,U=new THREE.Vector3,da=new THREE.Vector3,Q=new THREE.Vector3;c=0;for(e=this.vertices.length;c<e;c++)K[c]=new THREE.Vector3,W[c]=new THREE.Vector3;c=0;for(e=this.faces.length;c<e;c++)m=this.faces[c],k=this.faceVertexUvs[0][c],m instanceof THREE.Face3?b(this,m.a,m.b,m.c,0,1,2):m instanceof THREE.Face4&&(b(this,m.a,m.b,m.c,0,1,2),b(this,m.a,m.b,m.d,0,1,3));var o=["a",
"b","c","d"];c=0;for(e=this.faces.length;c<e;c++){m=this.faces[c];for(f=0;f<m.vertexNormals.length;f++)Q.copy(m.vertexNormals[f]),h=m[o[f]],I=K[h],U.copy(I),U.subSelf(Q.multiplyScalar(Q.dot(I))).normalize(),da.cross(m.vertexNormals[f],I),h=da.dot(W[h]),h=h<0?-1:1,m.vertexTangents[f]=new THREE.Vector4(U.x,U.y,U.z,h)}this.hasTangents=!0},computeBoundingBox:function(){var b;if(this.vertices.length>0){this.boundingBox={x:[this.vertices[0].position.x,this.vertices[0].position.x],y:[this.vertices[0].position.y,
this.vertices[0].position.y],z:[this.vertices[0].position.z,this.vertices[0].position.z]};for(var c=1,e=this.vertices.length;c<e;c++){b=this.vertices[c];if(b.position.x<this.boundingBox.x[0])this.boundingBox.x[0]=b.position.x;else if(b.position.x>this.boundingBox.x[1])this.boundingBox.x[1]=b.position.x;if(b.position.y<this.boundingBox.y[0])this.boundingBox.y[0]=b.position.y;else if(b.position.y>this.boundingBox.y[1])this.boundingBox.y[1]=b.position.y;if(b.position.z<this.boundingBox.z[0])this.boundingBox.z[0]=
b.position.z;else if(b.position.z>this.boundingBox.z[1])this.boundingBox.z[1]=b.position.z}}},computeBoundingSphere:function(){for(var b=0,c=0,e=this.vertices.length;c<e;c++)b=Math.max(b,this.vertices[c].position.length());this.boundingSphere={radius:b}},computeEdgeFaces:function(){function b(b,e){return Math.min(b,e)+"_"+Math.max(b,e)}function c(b,e,c){b[e]===void 0?(b[e]={set:{},array:[]},b[e].set[c]=1,b[e].array.push(c)):b[e].set[c]===void 0&&(b[e].set[c]=1,b[e].array.push(c))}var e,f,h,m,k,n=
{};e=0;for(f=this.faces.length;e<f;e++)k=this.faces[e],k instanceof THREE.Face3?(h=b(k.a,k.b),c(n,h,e),h=b(k.b,k.c),c(n,h,e),h=b(k.a,k.c),c(n,h,e)):k instanceof THREE.Face4&&(h=b(k.b,k.d),c(n,h,e),h=b(k.a,k.b),c(n,h,e),h=b(k.a,k.d),c(n,h,e),h=b(k.b,k.c),c(n,h,e),h=b(k.c,k.d),c(n,h,e));e=0;for(f=this.edges.length;e<f;e++){k=this.edges[e];h=k.vertexIndices[0];m=k.vertexIndices[1];k.faceIndices=n[b(h,m)].array;for(h=0;h<k.faceIndices.length;h++)m=k.faceIndices[h],k.faces.push(this.faces[m])}}};
THREE.GeometryCount=0;
THREE.Spline=function(b){function c(b,e,c,f,k,h,m){b=(c-b)*0.5;f=(f-e)*0.5;return(2*(e-c)+b+f)*m+(-3*(e-c)-2*b-f)*h+b*k+e}this.points=b;var e=[],f={x:0,y:0,z:0},h,m,k,n,t,u,w,v,x;this.initFromArray=function(b){this.points=[];for(var e=0;e<b.length;e++)this.points[e]={x:b[e][0],y:b[e][1],z:b[e][2]}};this.getPoint=function(b){h=(this.points.length-1)*b;m=Math.floor(h);k=h-m;e[0]=m==0?m:m-1;e[1]=m;e[2]=m>this.points.length-2?m:m+1;e[3]=m>this.points.length-3?m:m+2;u=this.points[e[0]];w=this.points[e[1]];
v=this.points[e[2]];x=this.points[e[3]];n=k*k;t=k*n;f.x=c(u.x,w.x,v.x,x.x,k,n,t);f.y=c(u.y,w.y,v.y,x.y,k,n,t);f.z=c(u.z,w.z,v.z,x.z,k,n,t);return f};this.getControlPointsArray=function(){var b,e,c=this.points.length,f=[];for(b=0;b<c;b++)e=this.points[b],f[b]=[e.x,e.y,e.z];return f};this.getLength=function(b){var e,c,f=e=e=0,k=new THREE.Vector3,h=new THREE.Vector3,m=[],n=0;m[0]=0;b||(b=100);c=this.points.length*b;k.copy(this.points[0]);for(b=1;b<c;b++)e=b/c,position=this.getPoint(e),h.copy(position),
n+=h.distanceTo(k),k.copy(position),e*=this.points.length-1,e=Math.floor(e),e!=f&&(m[e]=n,f=e);m[m.length]=n;return{chunks:m,total:n}};this.reparametrizeByArcLength=function(b){var e,c,f,k,h,m,n=[],v=new THREE.Vector3,u=this.getLength();n.push(v.copy(this.points[0]).clone());for(e=1;e<this.points.length;e++){c=u.chunks[e]-u.chunks[e-1];m=Math.ceil(b*c/u.total);k=(e-1)/(this.points.length-1);h=e/(this.points.length-1);for(c=1;c<m-1;c++)f=k+c*(1/m)*(h-k),position=this.getPoint(f),n.push(v.copy(position).clone());
n.push(v.copy(this.points[e]).clone())}this.points=n}};THREE.Edge=function(b,c,e,f){this.vertices=[b,c];this.vertexIndices=[e,f];this.faces=[];this.faceIndices=[]};THREE.Camera=function(b,c,e,f,h){THREE.Object3D.call(this);this.fov=b||50;this.aspect=c||1;this.near=e!==void 0?e:0.1;this.far=f!==void 0?f:2E3;this.target=h||new THREE.Object3D;this.useTarget=!0;this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=null;this.updateProjectionMatrix()};THREE.Camera.prototype=new THREE.Object3D;
THREE.Camera.prototype.constructor=THREE.Camera;THREE.Camera.prototype.supr=THREE.Object3D.prototype;THREE.Camera.prototype.translate=function(b,c){this.matrix.rotateAxis(c);c.multiplyScalar(b);this.position.addSelf(c);this.target.position.addSelf(c)};
THREE.Camera.prototype.updateProjectionMatrix=function(){if(this.fullWidth){var b=this.fullWidth/this.fullHeight,c=Math.tan(this.fov*Math.PI/360)*this.near,e=-c,f=b*e,b=Math.abs(b*c-f),e=Math.abs(c-e);this.projectionMatrix=THREE.Matrix4.makeFrustum(f+this.x*b/this.fullWidth,f+(this.x+this.width)*b/this.fullWidth,c-(this.y+this.height)*e/this.fullHeight,c-this.y*e/this.fullHeight,this.near,this.far)}else this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,this.far)};
THREE.Camera.prototype.setViewOffset=function(b,c,e,f,h,m){this.fullWidth=b;this.fullHeight=c;this.x=e;this.y=f;this.width=h;this.height=m;this.updateProjectionMatrix()};
THREE.Camera.prototype.update=function(b,c,e){if(this.useTarget)this.matrix.lookAt(this.position,this.target.position,this.up),this.matrix.setPosition(this.position),b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix),THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse),c=!0;else if(this.matrixAutoUpdate&&this.updateMatrix(),c||this.matrixWorldNeedsUpdate)b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=
!1,c=!0,THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse);for(b=0;b<this.children.length;b++)this.children[b].update(this.matrixWorld,c,e)};THREE.OrthoCamera=function(b,c,e,f,h,m,k){THREE.Camera.call(this,45,1,h,m,k);this.left=b;this.right=c;this.top=e;this.bottom=f;this.updateProjectionMatrix()};THREE.OrthoCamera.prototype=new THREE.Camera;THREE.OrthoCamera.prototype.constructor=THREE.OrthoCamera;
THREE.OrthoCamera.prototype.updateProjectionMatrix=function(){this.projectionMatrix=THREE.Matrix4.makeOrtho(this.left,this.right,this.top,this.bottom,this.near,this.far)};THREE.Light=function(b){THREE.Object3D.call(this);this.color=new THREE.Color(b)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(b){THREE.Light.call(this,b)};THREE.AmbientLight.prototype=new THREE.Light;
THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;THREE.DirectionalLight=function(b,c,e){THREE.Light.call(this,b);this.position=new THREE.Vector3(0,1,0);this.intensity=c!==void 0?c:1;this.distance=e!==void 0?e:0};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;THREE.PointLight=function(b,c,e){THREE.Light.call(this,b);this.position=new THREE.Vector3(0,0,0);this.intensity=c!==void 0?c:1;this.distance=e!==void 0?e:0};
THREE.PointLight.prototype=new THREE.Light;THREE.PointLight.prototype.constructor=THREE.PointLight;THREE.SpotLight=function(b,c,e,f){THREE.Light.call(this,b);this.position=new THREE.Vector3(0,1,0);this.target=new THREE.Object3D;this.intensity=c!==void 0?c:1;this.distance=e!==void 0?e:0;this.castShadow=f!==void 0?f:!1};THREE.SpotLight.prototype=new THREE.Light;THREE.SpotLight.prototype.constructor=THREE.SpotLight;
THREE.Material=function(b){this.id=THREE.MaterialCount++;b=b||{};this.opacity=b.opacity!==void 0?b.opacity:1;this.transparent=b.transparent!==void 0?b.transparent:!1;this.blending=b.blending!==void 0?b.blending:THREE.NormalBlending;this.depthTest=b.depthTest!==void 0?b.depthTest:!0;this.depthWrite=b.depthWrite!==void 0?b.depthWrite:!0;this.polygonOffset=b.polygonOffset!==void 0?b.polygonOffset:!1;this.polygonOffsetFactor=b.polygonOffsetFactor!==void 0?b.polygonOffsetFactor:0;this.polygonOffsetUnits=
b.polygonOffsetUnits!==void 0?b.polygonOffsetUnits:0;this.alphaTest=b.alphaTest!==void 0?b.alphaTest:0};THREE.MaterialCount=0;THREE.NoShading=0;THREE.FlatShading=1;THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;THREE.VertexColors=2;THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;THREE.MultiplyBlending=3;THREE.AdditiveAlphaBlending=4;
THREE.LineBasicMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==void 0?new THREE.Color(b.color):new THREE.Color(16777215);this.linewidth=b.linewidth!==void 0?b.linewidth:1;this.linecap=b.linecap!==void 0?b.linecap:"round";this.linejoin=b.linejoin!==void 0?b.linejoin:"round";this.vertexColors=b.vertexColors?b.vertexColors:!1;this.fog=b.fog!==void 0?b.fog:!0};THREE.LineBasicMaterial.prototype=new THREE.Material;THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial;
THREE.MeshBasicMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==void 0?new THREE.Color(b.color):new THREE.Color(16777215);this.map=b.map!==void 0?b.map:null;this.lightMap=b.lightMap!==void 0?b.lightMap:null;this.envMap=b.envMap!==void 0?b.envMap:null;this.combine=b.combine!==void 0?b.combine:THREE.MultiplyOperation;this.reflectivity=b.reflectivity!==void 0?b.reflectivity:1;this.refractionRatio=b.refractionRatio!==void 0?b.refractionRatio:0.98;this.fog=b.fog!==void 0?b.fog:
!0;this.shading=b.shading!==void 0?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==void 0?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==void 0?b.wireframeLinewidth:1;this.wireframeLinecap=b.wireframeLinecap!==void 0?b.wireframeLinecap:"round";this.wireframeLinejoin=b.wireframeLinejoin!==void 0?b.wireframeLinejoin:"round";this.vertexColors=b.vertexColors!==void 0?b.vertexColors:!1;this.skinning=b.skinning!==void 0?b.skinning:!1;this.morphTargets=b.morphTargets!==void 0?b.morphTargets:
!1};THREE.MeshBasicMaterial.prototype=new THREE.Material;THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial;
THREE.MeshLambertMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==void 0?new THREE.Color(b.color):new THREE.Color(16777215);this.map=b.map!==void 0?b.map:null;this.lightMap=b.lightMap!==void 0?b.lightMap:null;this.envMap=b.envMap!==void 0?b.envMap:null;this.combine=b.combine!==void 0?b.combine:THREE.MultiplyOperation;this.reflectivity=b.reflectivity!==void 0?b.reflectivity:1;this.refractionRatio=b.refractionRatio!==void 0?b.refractionRatio:0.98;this.fog=b.fog!==void 0?
b.fog:!0;this.shading=b.shading!==void 0?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==void 0?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==void 0?b.wireframeLinewidth:1;this.wireframeLinecap=b.wireframeLinecap!==void 0?b.wireframeLinecap:"round";this.wireframeLinejoin=b.wireframeLinejoin!==void 0?b.wireframeLinejoin:"round";this.vertexColors=b.vertexColors!==void 0?b.vertexColors:!1;this.skinning=b.skinning!==void 0?b.skinning:!1;this.morphTargets=b.morphTargets!==void 0?
b.morphTargets:!1};THREE.MeshLambertMaterial.prototype=new THREE.Material;THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial;
THREE.MeshPhongMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==void 0?new THREE.Color(b.color):new THREE.Color(16777215);this.ambient=b.ambient!==void 0?new THREE.Color(b.ambient):new THREE.Color(328965);this.specular=b.specular!==void 0?new THREE.Color(b.specular):new THREE.Color(1118481);this.shininess=b.shininess!==void 0?b.shininess:30;this.map=b.map!==void 0?b.map:null;this.lightMap=b.lightMap!==void 0?b.lightMap:null;this.envMap=b.envMap!==void 0?b.envMap:null;
this.combine=b.combine!==void 0?b.combine:THREE.MultiplyOperation;this.reflectivity=b.reflectivity!==void 0?b.reflectivity:1;this.refractionRatio=b.refractionRatio!==void 0?b.refractionRatio:0.98;this.fog=b.fog!==void 0?b.fog:!0;this.shading=b.shading!==void 0?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==void 0?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==void 0?b.wireframeLinewidth:1;this.wireframeLinecap=b.wireframeLinecap!==void 0?b.wireframeLinecap:"round";this.wireframeLinejoin=
b.wireframeLinejoin!==void 0?b.wireframeLinejoin:"round";this.vertexColors=b.vertexColors!==void 0?b.vertexColors:!1;this.skinning=b.skinning!==void 0?b.skinning:!1;this.morphTargets=b.morphTargets!==void 0?b.morphTargets:!1};THREE.MeshPhongMaterial.prototype=new THREE.Material;THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial;
THREE.MeshDepthMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.shading=b.shading!==void 0?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==void 0?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==void 0?b.wireframeLinewidth:1};THREE.MeshDepthMaterial.prototype=new THREE.Material;THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial;
THREE.MeshNormalMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.shading=b.shading?b.shading:THREE.FlatShading;this.wireframe=b.wireframe?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth?b.wireframeLinewidth:1};THREE.MeshNormalMaterial.prototype=new THREE.Material;THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial;THREE.MeshFaceMaterial=function(){};
THREE.ShaderMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.fragmentShader=b.fragmentShader!==void 0?b.fragmentShader:"void main() {}";this.vertexShader=b.vertexShader!==void 0?b.vertexShader:"void main() {}";this.uniforms=b.uniforms!==void 0?b.uniforms:{};this.attributes=b.attributes;this.shading=b.shading!==void 0?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==void 0?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==void 0?b.wireframeLinewidth:1;this.fog=b.fog!==
void 0?b.fog:!1;this.lights=b.lights!==void 0?b.lights:!1;this.vertexColors=b.vertexColors!==void 0?b.vertexColors:!1;this.skinning=b.skinning!==void 0?b.skinning:!1;this.morphTargets=b.morphTargets!==void 0?b.morphTargets:!1};THREE.ShaderMaterial.prototype=new THREE.Material;THREE.ShaderMaterial.prototype.constructor=THREE.ShaderMaterial;
THREE.ParticleBasicMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==void 0?new THREE.Color(b.color):new THREE.Color(16777215);this.map=b.map!==void 0?b.map:null;this.size=b.size!==void 0?b.size:1;this.sizeAttenuation=b.sizeAttenuation!==void 0?b.sizeAttenuation:!0;this.vertexColors=b.vertexColors!==void 0?b.vertexColors:!1;this.fog=b.fog!==void 0?b.fog:!0};THREE.ParticleBasicMaterial.prototype=new THREE.Material;THREE.ParticleBasicMaterial.prototype.constructor=THREE.ParticleBasicMaterial;
THREE.ParticleCanvasMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==void 0?new THREE.Color(b.color):new THREE.Color(16777215);this.program=b.program!==void 0?b.program:function(){}};THREE.ParticleCanvasMaterial.prototype=new THREE.Material;THREE.ParticleCanvasMaterial.prototype.constructor=THREE.ParticleCanvasMaterial;THREE.ParticleDOMMaterial=function(b){THREE.Material.call(this);this.domElement=b};
THREE.Texture=function(b,c,e,f,h,m){this.id=THREE.TextureCount++;this.image=b;this.mapping=c!==void 0?c:new THREE.UVMapping;this.wrapS=e!==void 0?e:THREE.ClampToEdgeWrapping;this.wrapT=f!==void 0?f:THREE.ClampToEdgeWrapping;this.magFilter=h!==void 0?h:THREE.LinearFilter;this.minFilter=m!==void 0?m:THREE.LinearMipMapLinearFilter;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.needsUpdate=!1};
THREE.Texture.prototype={constructor:THREE.Texture,clone:function(){var b=new THREE.Texture(this.image,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter);b.offset.copy(this.offset);b.repeat.copy(this.repeat);return b}};THREE.TextureCount=0;THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};THREE.LatitudeReflectionMapping=function(){};THREE.LatitudeRefractionMapping=function(){};
THREE.SphericalReflectionMapping=function(){};THREE.SphericalRefractionMapping=function(){};THREE.UVMapping=function(){};THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;THREE.ByteType=9;THREE.UnsignedByteType=10;THREE.ShortType=11;THREE.UnsignedShortType=12;THREE.IntType=13;
THREE.UnsignedIntType=14;THREE.FloatType=15;THREE.AlphaFormat=16;THREE.RGBFormat=17;THREE.RGBAFormat=18;THREE.LuminanceFormat=19;THREE.LuminanceAlphaFormat=20;THREE.DataTexture=function(b,c,e,f,h,m,k,n,t){THREE.Texture.call(this,null,h,m,k,n,t);this.image={data:b,width:c,height:e};this.format=f!==void 0?f:THREE.RGBAFormat};THREE.DataTexture.prototype=new THREE.Texture;THREE.DataTexture.prototype.constructor=THREE.DataTexture;
THREE.DataTexture.prototype.clone=function(){var b=new THREE.DataTexture(this.data.slice(0),this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter);b.offset.copy(this.offset);b.repeat.copy(this.repeat);return b};THREE.Particle=function(b){THREE.Object3D.call(this);this.materials=b instanceof Array?b:[b]};THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;
THREE.ParticleSystem=function(b,c){THREE.Object3D.call(this);this.geometry=b;this.materials=c instanceof Array?c:[c];this.sortParticles=!1};THREE.ParticleSystem.prototype=new THREE.Object3D;THREE.ParticleSystem.prototype.constructor=THREE.ParticleSystem;THREE.Line=function(b,c,e){THREE.Object3D.call(this);this.geometry=b;this.materials=c instanceof Array?c:[c];this.type=e!=void 0?e:THREE.LineStrip};THREE.LineStrip=0;THREE.LinePieces=1;THREE.Line.prototype=new THREE.Object3D;
THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(b,c){THREE.Object3D.call(this);this.geometry=b;this.materials=c&&c.length?c:[c];this.overdraw=!1;if(this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere(),this.boundRadius=b.boundingSphere.radius,this.geometry.morphTargets.length)){this.morphTargetBase=-1;this.morphTargetForcedOrder=[];this.morphTargetInfluences=[];this.morphTargetDictionary={};for(var e=0;e<this.geometry.morphTargets.length;e++)this.morphTargetInfluences.push(0),this.morphTargetDictionary[this.geometry.morphTargets[e].name]=
e}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;THREE.Mesh.prototype.getMorphTargetIndexByName=function(b){if(this.morphTargetDictionary[b]!==void 0)return this.morphTargetDictionary[b];console.log("THREE.Mesh.getMorphTargetIndexByName: morph target "+b+" does not exist. Returning 0.");return 0};
THREE.Bone=function(b){THREE.Object3D.call(this);this.skin=b;this.skinMatrix=new THREE.Matrix4;this.hasNoneBoneChildren=!1};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(b,c,e){this.matrixAutoUpdate&&(c|=this.updateMatrix());if(c||this.matrixWorldNeedsUpdate)b?this.skinMatrix.multiply(b,this.matrix):this.skinMatrix.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,c=!0;var f,h=this.children.length;if(this.hasNoneBoneChildren){this.matrixWorld.multiply(this.skin.matrixWorld,this.skinMatrix);for(f=0;f<h;f++)b=this.children[f],b instanceof THREE.Bone?b.update(this.skinMatrix,c,e):b.update(this.matrixWorld,!0,e)}else for(f=0;f<h;f++)this.children[f].update(this.skinMatrix,
c,e)};THREE.Bone.prototype.addChild=function(b){if(this.children.indexOf(b)===-1&&(b.parent!==void 0&&b.parent.removeChild(b),b.parent=this,this.children.push(b),!(b instanceof THREE.Bone)))this.hasNoneBoneChildren=!0};
THREE.SkinnedMesh=function(b,c){THREE.Mesh.call(this,b,c);this.identityMatrix=new THREE.Matrix4;this.bones=[];this.boneMatrices=[];var e,f,h,m,k,n;if(this.geometry.bones!==void 0){for(e=0;e<this.geometry.bones.length;e++)h=this.geometry.bones[e],m=h.pos,k=h.rotq,n=h.scl,f=this.addBone(),f.name=h.name,f.position.set(m[0],m[1],m[2]),f.quaternion.set(k[0],k[1],k[2],k[3]),f.useQuaternion=!0,n!==void 0?f.scale.set(n[0],n[1],n[2]):f.scale.set(1,1,1);for(e=0;e<this.bones.length;e++)h=this.geometry.bones[e],
f=this.bones[e],h.parent===-1?this.addChild(f):this.bones[h.parent].addChild(f);this.boneMatrices=new Float32Array(16*this.bones.length);this.pose()}};THREE.SkinnedMesh.prototype=new THREE.Mesh;THREE.SkinnedMesh.prototype.constructor=THREE.SkinnedMesh;
THREE.SkinnedMesh.prototype.update=function(b,c,e){if(this.visible){this.matrixAutoUpdate&&(c|=this.updateMatrix());if(c||this.matrixWorldNeedsUpdate)b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,c=!0;var f,h=this.children.length;for(f=0;f<h;f++)b=this.children[f],b instanceof THREE.Bone?b.update(this.identityMatrix,!1,e):b.update(this.matrixWorld,c,e);e=this.bones.length;ba=this.bones;bm=this.boneMatrices;for(c=0;c<e;c++)ba[c].skinMatrix.flattenToArrayOffset(bm,
c*16)}};THREE.SkinnedMesh.prototype.addBone=function(b){b===void 0&&(b=new THREE.Bone(this));this.bones.push(b);return b};
THREE.SkinnedMesh.prototype.pose=function(){this.update(void 0,!0);for(var b,c=[],e=0;e<this.bones.length;e++)b=this.bones[e],c.push(THREE.Matrix4.makeInvert(b.skinMatrix)),b.skinMatrix.flattenToArrayOffset(this.boneMatrices,e*16);if(this.geometry.skinVerticesA===void 0){this.geometry.skinVerticesA=[];this.geometry.skinVerticesB=[];var f;for(b=0;b<this.geometry.skinIndices.length;b++){var e=this.geometry.vertices[b].position,h=this.geometry.skinIndices[b].x,m=this.geometry.skinIndices[b].y;f=new THREE.Vector3(e.x,
e.y,e.z);this.geometry.skinVerticesA.push(c[h].multiplyVector3(f));f=new THREE.Vector3(e.x,e.y,e.z);this.geometry.skinVerticesB.push(c[m].multiplyVector3(f));this.geometry.skinWeights[b].x+this.geometry.skinWeights[b].y!==1&&(e=(1-(this.geometry.skinWeights[b].x+this.geometry.skinWeights[b].y))*0.5,this.geometry.skinWeights[b].x+=e,this.geometry.skinWeights[b].y+=e)}}};THREE.Ribbon=function(b,c){THREE.Object3D.call(this);this.geometry=b;this.materials=c instanceof Array?c:[c]};
THREE.Ribbon.prototype=new THREE.Object3D;THREE.Ribbon.prototype.constructor=THREE.Ribbon;THREE.LOD=function(){THREE.Object3D.call(this);this.LODs=[]};THREE.LOD.prototype=new THREE.Object3D;THREE.LOD.prototype.constructor=THREE.LOD;THREE.LOD.prototype.supr=THREE.Object3D.prototype;THREE.LOD.prototype.addLevel=function(b,c){c===void 0&&(c=0);for(var c=Math.abs(c),e=0;e<this.LODs.length;e++)if(c<this.LODs[e].visibleAtDistance)break;this.LODs.splice(e,0,{visibleAtDistance:c,object3D:b});this.add(b)};
THREE.LOD.prototype.update=function(b,c,e){this.matrixAutoUpdate&&(c|=this.updateMatrix());if(c||this.matrixWorldNeedsUpdate)b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,c=!0;if(this.LODs.length>1){b=e.matrixWorldInverse;b=-(b.n31*this.position.x+b.n32*this.position.y+b.n33*this.position.z+b.n34);this.LODs[0].object3D.visible=!0;for(var f=1;f<this.LODs.length;f++)if(b>=this.LODs[f].visibleAtDistance)this.LODs[f-1].object3D.visible=!1,
this.LODs[f].object3D.visible=!0;else break;for(;f<this.LODs.length;f++)this.LODs[f].object3D.visible=!1}for(b=0;b<this.children.length;b++)this.children[b].update(this.matrixWorld,c,e)};
THREE.Sprite=function(b){THREE.Object3D.call(this);if(b.material!==void 0)this.material=b.material,this.map=void 0,this.blending=material.blending;else if(b.map!==void 0)this.map=b.map instanceof THREE.Texture?b.map:THREE.ImageUtils.loadTexture(b.map),this.material=void 0,this.blending=b.blending!==void 0?b.blending:THREE.NormalBlending;this.useScreenCoordinates=b.useScreenCoordinates!==void 0?b.useScreenCoordinates:!0;this.mergeWith3D=b.mergeWith3D!==void 0?b.mergeWith3D:!this.useScreenCoordinates;
this.affectedByDistance=b.affectedByDistance!==void 0?b.affectedByDistance:!this.useScreenCoordinates;this.scaleByViewport=b.scaleByViewport!==void 0?b.scaleByViewport:!this.affectedByDistance;this.alignment=b.alignment instanceof THREE.Vector2?b.alignment:THREE.SpriteAlignment.center;this.rotation3d=this.rotation;this.rotation=0;this.opacity=1;this.uvOffset=new THREE.Vector2(0,0);this.uvScale=new THREE.Vector2(1,1)};THREE.Sprite.prototype=new THREE.Object3D;THREE.Sprite.prototype.constructor=THREE.Sprite;
THREE.Sprite.prototype.supr=THREE.Object3D.prototype;THREE.Sprite.prototype.updateMatrix=function(){this.matrix.setPosition(this.position);this.rotation3d.set(0,0,this.rotation);this.matrix.setRotationFromEuler(this.rotation3d);if(this.scale.x!==1||this.scale.y!==1)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,this.scale.y);this.matrixWorldNeedsUpdate=!0};THREE.SpriteAlignment={};THREE.SpriteAlignment.topLeft=new THREE.Vector2(1,-1);
THREE.SpriteAlignment.topCenter=new THREE.Vector2(0,-1);THREE.SpriteAlignment.topRight=new THREE.Vector2(-1,-1);THREE.SpriteAlignment.centerLeft=new THREE.Vector2(1,0);THREE.SpriteAlignment.center=new THREE.Vector2(0,0);THREE.SpriteAlignment.centerRight=new THREE.Vector2(-1,0);THREE.SpriteAlignment.bottomLeft=new THREE.Vector2(1,1);THREE.SpriteAlignment.bottomCenter=new THREE.Vector2(0,1);THREE.SpriteAlignment.bottomRight=new THREE.Vector2(-1,1);
THREE.Scene=function(){THREE.Object3D.call(this);this.matrixAutoUpdate=!1;this.collisions=this.overrideMaterial=this.fog=null;this.objects=[];this.lights=[];this.__objectsAdded=[];this.__objectsRemoved=[]};THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;THREE.Scene.prototype.supr=THREE.Object3D.prototype;THREE.Scene.prototype.add=function(b){this.supr.add.call(this,b);this.addChildRecurse(b)};
THREE.Scene.prototype.addChildRecurse=function(b){if(b instanceof THREE.Light)this.lights.indexOf(b)===-1&&this.lights.push(b);else if(!(b instanceof THREE.Camera||b instanceof THREE.Bone)&&this.objects.indexOf(b)===-1)this.objects.push(b),this.__objectsAdded.push(b);for(var c=0;c<b.children.length;c++)this.addChildRecurse(b.children[c])};THREE.Scene.prototype.remove=function(b){this.supr.remove.call(this,b);this.removeChildRecurse(b)};
THREE.Scene.prototype.removeChildRecurse=function(b){if(b instanceof THREE.Light){var c=this.lights.indexOf(b);c!==-1&&this.lights.splice(c,1)}else b instanceof THREE.Camera||(c=this.objects.indexOf(b),c!==-1&&(this.objects.splice(c,1),this.__objectsRemoved.push(b)));for(c=0;c<b.children.length;c++)this.removeChildRecurse(b.children[c])};THREE.Scene.prototype.addChild=function(b){console.warn("DEPRECATED: Scene.addChild() is now Scene.add()");this.add(b)};
THREE.Scene.prototype.addObject=function(b){console.warn("DEPRECATED: Scene.addObject() is now Scene.add()");this.add(b)};THREE.Scene.prototype.addLight=function(b){console.warn("DEPRECATED: Scene.addLight() is now Scene.add()");this.add(b)};THREE.Scene.prototype.removeChild=function(b){console.warn("DEPRECATED: Scene.removeChild() is now Scene.remove()");this.remove(b)};THREE.Scene.prototype.removeObject=function(b){console.warn("DEPRECATED: Scene.removeObject() is now Scene.remove()");this.remove(b)};
THREE.Scene.prototype.removeLight=function(b){console.warn("DEPRECATED: Scene.removeLight() is now Scene.remove()");this.remove(b)};THREE.Fog=function(b,c,e){this.color=new THREE.Color(b);this.near=c!==void 0?c:1;this.far=e!==void 0?e:1E3};THREE.FogExp2=function(b,c){this.color=new THREE.Color(b);this.density=c!==void 0?c:2.5E-4};
THREE.DOMRenderer=function(){THREE.Renderer.call(this);var b=null,c=new THREE.Projector,e,f,h,m;this.domElement=document.createElement("div");this.setSize=function(b,c){e=b;f=c;h=e/2;m=f/2};this.render=function(e,f){var t,u,w,v,x,p,y,z;b=c.projectScene(e,f);t=0;for(u=b.length;t<u;t++)if(x=b[t],x instanceof THREE.RenderableParticle){y=x.x*h+h;z=x.y*m+m;w=0;for(v=x.material.length;w<v;w++)if(p=x.material[w],p instanceof THREE.ParticleDOMMaterial)p=p.domElement,p.style.left=y+"px",p.style.top=z+"px"}}};
THREE.CanvasRenderer=function(b){function c(b){if(A!=b)p.globalAlpha=A=b}function e(b){if(C!=b){switch(b){case THREE.NormalBlending:p.globalCompositeOperation="source-over";break;case THREE.AdditiveBlending:p.globalCompositeOperation="lighter";break;case THREE.SubtractiveBlending:p.globalCompositeOperation="darker"}C=b}}function f(b){if(E!=b)p.strokeStyle=E=b}function h(b){if(G!=b)p.fillStyle=G=b}var m=this,k=null,n=new THREE.Projector,b=b||{},t=b.canvas!==void 0?b.canvas:document.createElement("canvas"),
u,w,v,x,p=t.getContext("2d"),y=new THREE.Color(0),z=0,A=1,C=0,E=null,G=null,H=null,M=null,R=null,J,I,K,W,D=new THREE.RenderableVertex,S=new THREE.RenderableVertex,U,da,Q,o,pa,T,ma,ca,na,ja,la,ga,Z=new THREE.Color(0),V=new THREE.Color(0),$=new THREE.Color(0),ea=new THREE.Color(0),ka=new THREE.Color(0),ta=[],N,fa,ra,ua,sa,xa,Ca,za,Aa,Ea,L=new THREE.Rectangle,O=new THREE.Rectangle,ha=new THREE.Rectangle,aa=!1,ia=new THREE.Color,qa=new THREE.Color,ya=new THREE.Color,va=new THREE.Color,oa=new THREE.Vector3,
Fa,Y,Ba,X,Va,Wa,b=16;Fa=document.createElement("canvas");Fa.width=Fa.height=2;Y=Fa.getContext("2d");Y.fillStyle="rgba(0,0,0,1)";Y.fillRect(0,0,2,2);Ba=Y.getImageData(0,0,2,2);X=Ba.data;Va=document.createElement("canvas");Va.width=Va.height=b;Wa=Va.getContext("2d");Wa.translate(-b/2,-b/2);Wa.scale(b,b);b--;this.domElement=t;this.sortElements=this.sortObjects=this.autoClear=!0;this.data={vertices:0,faces:0};this.setSize=function(b,e){u=b;w=e;v=Math.floor(u/2);x=Math.floor(w/2);t.width=u;t.height=w;
L.set(-v,-x,v,x);O.set(-v,-x,v,x);A=1;C=0;R=M=H=G=E=null};this.setClearColor=function(b,e){y.copy(b);z=e;O.set(-v,-x,v,x)};this.setClearColorHex=function(b,e){y.setHex(b);z=e;O.set(-v,-x,v,x)};this.clear=function(){p.setTransform(1,0,0,-1,v,x);O.isEmpty()||(O.minSelf(L),O.inflate(2),z<1&&p.clearRect(Math.floor(O.getX()),Math.floor(O.getY()),Math.floor(O.getWidth()),Math.floor(O.getHeight())),z>0&&(e(THREE.NormalBlending),c(1),h("rgba("+Math.floor(y.r*255)+","+Math.floor(y.g*255)+","+Math.floor(y.b*
255)+","+z+")"),p.fillRect(Math.floor(O.getX()),Math.floor(O.getY()),Math.floor(O.getWidth()),Math.floor(O.getHeight()))),O.empty())};this.render=function(b,u){function t(b){var e,c,f,k=b.lights;qa.setRGB(0,0,0);ya.setRGB(0,0,0);va.setRGB(0,0,0);b=0;for(e=k.length;b<e;b++)c=k[b],f=c.color,c instanceof THREE.AmbientLight?(qa.r+=f.r,qa.g+=f.g,qa.b+=f.b):c instanceof THREE.DirectionalLight?(ya.r+=f.r,ya.g+=f.g,ya.b+=f.b):c instanceof THREE.PointLight&&(va.r+=f.r,va.g+=f.g,va.b+=f.b)}function w(b,e,c,
f){var k,h,m,o,n=b.lights,b=0;for(k=n.length;b<k;b++)h=n[b],m=h.color,h instanceof THREE.DirectionalLight?(o=c.dot(h.position),o<=0||(o*=h.intensity,f.r+=m.r*o,f.g+=m.g*o,f.b+=m.b*o)):h instanceof THREE.PointLight&&(o=c.dot(oa.sub(h.position,e).normalize()),o<=0||(o*=h.distance==0?1:1-Math.min(e.distanceTo(h.position)/h.distance,1),o!=0&&(o*=h.intensity,f.r+=m.r*o,f.g+=m.g*o,f.b+=m.b*o)))}function y(b,k,m){c(m.opacity);e(m.blending);var o,n,u,X,t,w;if(m instanceof THREE.ParticleBasicMaterial){if(m.map)X=
m.map.image,t=X.width>>1,w=X.height>>1,m=k.scale.x*v,u=k.scale.y*x,o=m*t,n=u*w,ha.set(b.x-o,b.y-n,b.x+o,b.y+n),L.intersects(ha)&&(p.save(),p.translate(b.x,b.y),p.rotate(-k.rotation),p.scale(m,-u),p.translate(-t,-w),p.drawImage(X,0,0),p.restore())}else m instanceof THREE.ParticleCanvasMaterial&&(o=k.scale.x*v,n=k.scale.y*x,ha.set(b.x-o,b.y-n,b.x+o,b.y+n),L.intersects(ha)&&(f(m.color.getContextStyle()),h(m.color.getContextStyle()),p.save(),p.translate(b.x,b.y),p.rotate(-k.rotation),p.scale(o,n),m.program(p),
p.restore()))}function z(b,k,h,m){c(m.opacity);e(m.blending);p.beginPath();p.moveTo(b.positionScreen.x,b.positionScreen.y);p.lineTo(k.positionScreen.x,k.positionScreen.y);p.closePath();if(m instanceof THREE.LineBasicMaterial){b=m.linewidth;if(H!=b)p.lineWidth=H=b;b=m.linecap;if(M!=b)p.lineCap=M=b;b=m.linejoin;if(R!=b)p.lineJoin=R=b;f(m.color.getContextStyle());p.stroke();ha.inflate(m.linewidth*2)}}function A(b,f,k,h,n,v,X,p,t){m.data.vertices+=3;m.data.faces++;c(p.opacity);e(p.blending);U=b.positionScreen.x;
da=b.positionScreen.y;Q=f.positionScreen.x;o=f.positionScreen.y;pa=k.positionScreen.x;T=k.positionScreen.y;E(U,da,Q,o,pa,T);if(p instanceof THREE.MeshBasicMaterial)if(p.map)p.map.mapping instanceof THREE.UVMapping&&(ua=X.uvs[0],$a(U,da,Q,o,pa,T,ua[h].u,ua[h].v,ua[n].u,ua[n].v,ua[v].u,ua[v].v,p.map));else if(p.envMap){if(p.envMap.mapping instanceof THREE.SphericalReflectionMapping)b=u.matrixWorldInverse,oa.copy(X.vertexNormalsWorld[0]),sa=(oa.x*b.n11+oa.y*b.n12+oa.z*b.n13)*0.5+0.5,xa=-(oa.x*b.n21+
oa.y*b.n22+oa.z*b.n23)*0.5+0.5,oa.copy(X.vertexNormalsWorld[1]),Ca=(oa.x*b.n11+oa.y*b.n12+oa.z*b.n13)*0.5+0.5,za=-(oa.x*b.n21+oa.y*b.n22+oa.z*b.n23)*0.5+0.5,oa.copy(X.vertexNormalsWorld[2]),Aa=(oa.x*b.n11+oa.y*b.n12+oa.z*b.n13)*0.5+0.5,Ea=-(oa.x*b.n21+oa.y*b.n22+oa.z*b.n23)*0.5+0.5,$a(U,da,Q,o,pa,T,sa,xa,Ca,za,Aa,Ea,p.envMap)}else p.wireframe?Ia(p.color,p.wireframeLinewidth,p.wireframeLinecap,p.wireframeLinejoin):Ja(p.color);else if(p instanceof THREE.MeshLambertMaterial)p.map&&!p.wireframe&&(p.map.mapping instanceof
THREE.UVMapping&&(ua=X.uvs[0],$a(U,da,Q,o,pa,T,ua[h].u,ua[h].v,ua[n].u,ua[n].v,ua[v].u,ua[v].v,p.map)),e(THREE.SubtractiveBlending)),aa?!p.wireframe&&p.shading==THREE.SmoothShading&&X.vertexNormalsWorld.length==3?(V.r=$.r=ea.r=qa.r,V.g=$.g=ea.g=qa.g,V.b=$.b=ea.b=qa.b,w(t,X.v1.positionWorld,X.vertexNormalsWorld[0],V),w(t,X.v2.positionWorld,X.vertexNormalsWorld[1],$),w(t,X.v3.positionWorld,X.vertexNormalsWorld[2],ea),V.r=Math.max(0,Math.min(p.color.r*V.r,1)),V.g=Math.max(0,Math.min(p.color.g*V.g,1)),
V.b=Math.max(0,Math.min(p.color.b*V.b,1)),$.r=Math.max(0,Math.min(p.color.r*$.r,1)),$.g=Math.max(0,Math.min(p.color.g*$.g,1)),$.b=Math.max(0,Math.min(p.color.b*$.b,1)),ea.r=Math.max(0,Math.min(p.color.r*ea.r,1)),ea.g=Math.max(0,Math.min(p.color.g*ea.g,1)),ea.b=Math.max(0,Math.min(p.color.b*ea.b,1)),ka.r=($.r+ea.r)*0.5,ka.g=($.g+ea.g)*0.5,ka.b=($.b+ea.b)*0.5,ra=Xa(V,$,ea,ka),Sa(U,da,Q,o,pa,T,0,0,1,0,0,1,ra)):(ia.r=qa.r,ia.g=qa.g,ia.b=qa.b,w(t,X.centroidWorld,X.normalWorld,ia),Z.r=Math.max(0,Math.min(p.color.r*
ia.r,1)),Z.g=Math.max(0,Math.min(p.color.g*ia.g,1)),Z.b=Math.max(0,Math.min(p.color.b*ia.b,1)),p.wireframe?Ia(Z,p.wireframeLinewidth,p.wireframeLinecap,p.wireframeLinejoin):Ja(Z)):p.wireframe?Ia(p.color,p.wireframeLinewidth,p.wireframeLinecap,p.wireframeLinejoin):Ja(p.color);else if(p instanceof THREE.MeshDepthMaterial)N=u.near,fa=u.far,V.r=V.g=V.b=1-Na(b.positionScreen.z,N,fa),$.r=$.g=$.b=1-Na(f.positionScreen.z,N,fa),ea.r=ea.g=ea.b=1-Na(k.positionScreen.z,N,fa),ka.r=($.r+ea.r)*0.5,ka.g=($.g+ea.g)*
0.5,ka.b=($.b+ea.b)*0.5,ra=Xa(V,$,ea,ka),Sa(U,da,Q,o,pa,T,0,0,1,0,0,1,ra);else if(p instanceof THREE.MeshNormalMaterial)Z.r=Ta(X.normalWorld.x),Z.g=Ta(X.normalWorld.y),Z.b=Ta(X.normalWorld.z),p.wireframe?Ia(Z,p.wireframeLinewidth,p.wireframeLinecap,p.wireframeLinejoin):Ja(Z)}function C(b,f,k,h,n,p,v,X,t){m.data.vertices+=4;m.data.faces++;c(X.opacity);e(X.blending);if(X.map||X.envMap)A(b,f,h,0,1,3,v,X,t),A(n,k,p,1,2,3,v,X,t);else if(U=b.positionScreen.x,da=b.positionScreen.y,Q=f.positionScreen.x,o=
f.positionScreen.y,pa=k.positionScreen.x,T=k.positionScreen.y,ma=h.positionScreen.x,ca=h.positionScreen.y,na=n.positionScreen.x,ja=n.positionScreen.y,la=p.positionScreen.x,ga=p.positionScreen.y,X instanceof THREE.MeshBasicMaterial)G(U,da,Q,o,pa,T,ma,ca),X.wireframe?Ia(X.color,X.wireframeLinewidth,X.wireframeLinecap,X.wireframeLinejoin):Ja(X.color);else if(X instanceof THREE.MeshLambertMaterial)aa?!X.wireframe&&X.shading==THREE.SmoothShading&&v.vertexNormalsWorld.length==4?(V.r=$.r=ea.r=ka.r=qa.r,
V.g=$.g=ea.g=ka.g=qa.g,V.b=$.b=ea.b=ka.b=qa.b,w(t,v.v1.positionWorld,v.vertexNormalsWorld[0],V),w(t,v.v2.positionWorld,v.vertexNormalsWorld[1],$),w(t,v.v4.positionWorld,v.vertexNormalsWorld[3],ea),w(t,v.v3.positionWorld,v.vertexNormalsWorld[2],ka),V.r=Math.max(0,Math.min(X.color.r*V.r,1)),V.g=Math.max(0,Math.min(X.color.g*V.g,1)),V.b=Math.max(0,Math.min(X.color.b*V.b,1)),$.r=Math.max(0,Math.min(X.color.r*$.r,1)),$.g=Math.max(0,Math.min(X.color.g*$.g,1)),$.b=Math.max(0,Math.min(X.color.b*$.b,1)),ea.r=
Math.max(0,Math.min(X.color.r*ea.r,1)),ea.g=Math.max(0,Math.min(X.color.g*ea.g,1)),ea.b=Math.max(0,Math.min(X.color.b*ea.b,1)),ka.r=Math.max(0,Math.min(X.color.r*ka.r,1)),ka.g=Math.max(0,Math.min(X.color.g*ka.g,1)),ka.b=Math.max(0,Math.min(X.color.b*ka.b,1)),ra=Xa(V,$,ea,ka),E(U,da,Q,o,ma,ca),Sa(U,da,Q,o,ma,ca,0,0,1,0,0,1,ra),E(na,ja,pa,T,la,ga),Sa(na,ja,pa,T,la,ga,1,0,1,1,0,1,ra)):(ia.r=qa.r,ia.g=qa.g,ia.b=qa.b,w(t,v.centroidWorld,v.normalWorld,ia),Z.r=Math.max(0,Math.min(X.color.r*ia.r,1)),Z.g=
Math.max(0,Math.min(X.color.g*ia.g,1)),Z.b=Math.max(0,Math.min(X.color.b*ia.b,1)),G(U,da,Q,o,pa,T,ma,ca),X.wireframe?Ia(Z,X.wireframeLinewidth,X.wireframeLinecap,X.wireframeLinejoin):Ja(Z)):(G(U,da,Q,o,pa,T,ma,ca),X.wireframe?Ia(X.color,X.wireframeLinewidth,X.wireframeLinecap,X.wireframeLinejoin):Ja(X.color));else if(X instanceof THREE.MeshNormalMaterial)Z.r=Ta(v.normalWorld.x),Z.g=Ta(v.normalWorld.y),Z.b=Ta(v.normalWorld.z),G(U,da,Q,o,pa,T,ma,ca),X.wireframe?Ia(Z,X.wireframeLinewidth,X.wireframeLinecap,
X.wireframeLinejoin):Ja(Z);else if(X instanceof THREE.MeshDepthMaterial)N=u.near,fa=u.far,V.r=V.g=V.b=1-Na(b.positionScreen.z,N,fa),$.r=$.g=$.b=1-Na(f.positionScreen.z,N,fa),ea.r=ea.g=ea.b=1-Na(h.positionScreen.z,N,fa),ka.r=ka.g=ka.b=1-Na(k.positionScreen.z,N,fa),ra=Xa(V,$,ea,ka),E(U,da,Q,o,ma,ca),Sa(U,da,Q,o,ma,ca,0,0,1,0,0,1,ra),E(na,ja,pa,T,la,ga),Sa(na,ja,pa,T,la,ga,1,0,1,1,0,1,ra)}function E(b,e,c,f,k,h){p.beginPath();p.moveTo(b,e);p.lineTo(c,f);p.lineTo(k,h);p.lineTo(b,e);p.closePath()}function G(b,
e,c,f,k,h,m,o){p.beginPath();p.moveTo(b,e);p.lineTo(c,f);p.lineTo(k,h);p.lineTo(m,o);p.lineTo(b,e);p.closePath()}function Ia(b,e,c,k){if(H!=e)p.lineWidth=H=e;if(M!=c)p.lineCap=M=c;if(R!=k)p.lineJoin=R=k;f(b.getContextStyle());p.stroke();ha.inflate(e*2)}function Ja(b){h(b.getContextStyle());p.fill()}function $a(b,e,c,f,k,m,o,n,X,v,u,t,w){if(w.image.width!=0){if(w.needsUpdate==!0||ta[w.id]==void 0){var x=w.wrapS==THREE.RepeatWrapping,Ma=w.wrapT==THREE.RepeatWrapping;ta[w.id]=p.createPattern(w.image,
x&&Ma?"repeat":x&&!Ma?"repeat-x":!x&&Ma?"repeat-y":"no-repeat");w.needsUpdate=!1}h(ta[w.id]);var x=w.offset.x/w.repeat.x,Ma=w.offset.y/w.repeat.y,L=(w.image.width-1)*w.repeat.x,w=(w.image.height-1)*w.repeat.y,o=(o+x)*L,n=(n+Ma)*w,X=(X+x)*L,v=(v+Ma)*w,u=(u+x)*L,t=(t+Ma)*w;c-=b;f-=e;k-=b;m-=e;X-=o;v-=n;u-=o;t-=n;x=1/(X*t-u*v);w=(t*c-v*k)*x;v=(t*f-v*m)*x;c=(X*k-u*c)*x;f=(X*m-u*f)*x;b=b-w*o-c*n;e=e-v*o-f*n;p.save();p.transform(w,v,c,f,b,e);p.fill();p.restore()}}function Sa(b,e,c,f,k,h,m,o,n,X,v,u,t){var w,
x;w=t.width-1;x=t.height-1;m*=w;o*=x;n*=w;X*=x;v*=w;u*=x;c-=b;f-=e;k-=b;h-=e;n-=m;X-=o;v-=m;u-=o;x=1/(n*u-v*X);w=(u*c-X*k)*x;X=(u*f-X*h)*x;c=(n*k-v*c)*x;f=(n*h-v*f)*x;b=b-w*m-c*o;e=e-X*m-f*o;p.save();p.transform(w,X,c,f,b,e);p.clip();p.drawImage(t,0,0);p.restore()}function Xa(b,e,c,f){var k=~~(b.r*255),h=~~(b.g*255),b=~~(b.b*255),m=~~(e.r*255),o=~~(e.g*255),e=~~(e.b*255),n=~~(c.r*255),v=~~(c.g*255),c=~~(c.b*255),p=~~(f.r*255),u=~~(f.g*255),f=~~(f.b*255);X[0]=k<0?0:k>255?255:k;X[1]=h<0?0:h>255?255:
h;X[2]=b<0?0:b>255?255:b;X[4]=m<0?0:m>255?255:m;X[5]=o<0?0:o>255?255:o;X[6]=e<0?0:e>255?255:e;X[8]=n<0?0:n>255?255:n;X[9]=v<0?0:v>255?255:v;X[10]=c<0?0:c>255?255:c;X[12]=p<0?0:p>255?255:p;X[13]=u<0?0:u>255?255:u;X[14]=f<0?0:f>255?255:f;Y.putImageData(Ba,0,0);Wa.drawImage(Fa,0,0);return Va}function Na(b,e,c){b=(b-e)/(c-e);return b*b*(3-2*b)}function Ta(b){b=(b+1)*0.5;return b<0?0:b>1?1:b}function Ka(b,e){var c=e.x-b.x,f=e.y-b.y,k=c*c+f*f;k!=0&&(k=1/Math.sqrt(k),c*=k,f*=k,e.x+=c,e.y+=f,b.x-=c,b.y-=
f)}var Ya,cb,wa,Da,La,Ua,Za,F;this.autoClear?this.clear():p.setTransform(1,0,0,-1,v,x);m.data.vertices=0;m.data.faces=0;k=n.projectScene(b,u,this.sortElements);(aa=b.lights.length>0)&&t(b);Ya=0;for(cb=k.length;Ya<cb;Ya++){wa=k[Ya];ha.empty();if(wa instanceof THREE.RenderableParticle){J=wa;J.x*=v;J.y*=x;Da=0;for(La=wa.materials.length;Da<La;)F=wa.materials[Da++],F.opacity!=0&&y(J,wa,F,b)}else if(wa instanceof THREE.RenderableLine){if(J=wa.v1,I=wa.v2,J.positionScreen.x*=v,J.positionScreen.y*=x,I.positionScreen.x*=
v,I.positionScreen.y*=x,ha.addPoint(J.positionScreen.x,J.positionScreen.y),ha.addPoint(I.positionScreen.x,I.positionScreen.y),L.intersects(ha)){Da=0;for(La=wa.materials.length;Da<La;)F=wa.materials[Da++],F.opacity!=0&&z(J,I,wa,F,b)}}else if(wa instanceof THREE.RenderableFace3){if(J=wa.v1,I=wa.v2,K=wa.v3,J.positionScreen.x*=v,J.positionScreen.y*=x,I.positionScreen.x*=v,I.positionScreen.y*=x,K.positionScreen.x*=v,K.positionScreen.y*=x,wa.overdraw&&(Ka(J.positionScreen,I.positionScreen),Ka(I.positionScreen,
K.positionScreen),Ka(K.positionScreen,J.positionScreen)),ha.add3Points(J.positionScreen.x,J.positionScreen.y,I.positionScreen.x,I.positionScreen.y,K.positionScreen.x,K.positionScreen.y),L.intersects(ha)){Da=0;for(La=wa.meshMaterials.length;Da<La;)if(F=wa.meshMaterials[Da++],F instanceof THREE.MeshFaceMaterial){Ua=0;for(Za=wa.faceMaterials.length;Ua<Za;)(F=wa.faceMaterials[Ua++])&&F.opacity!=0&&A(J,I,K,0,1,2,wa,F,b)}else F.opacity!=0&&A(J,I,K,0,1,2,wa,F,b)}}else if(wa instanceof THREE.RenderableFace4&&
(J=wa.v1,I=wa.v2,K=wa.v3,W=wa.v4,J.positionScreen.x*=v,J.positionScreen.y*=x,I.positionScreen.x*=v,I.positionScreen.y*=x,K.positionScreen.x*=v,K.positionScreen.y*=x,W.positionScreen.x*=v,W.positionScreen.y*=x,D.positionScreen.copy(I.positionScreen),S.positionScreen.copy(W.positionScreen),wa.overdraw&&(Ka(J.positionScreen,I.positionScreen),Ka(I.positionScreen,W.positionScreen),Ka(W.positionScreen,J.positionScreen),Ka(K.positionScreen,D.positionScreen),Ka(K.positionScreen,S.positionScreen)),ha.addPoint(J.positionScreen.x,
J.positionScreen.y),ha.addPoint(I.positionScreen.x,I.positionScreen.y),ha.addPoint(K.positionScreen.x,K.positionScreen.y),ha.addPoint(W.positionScreen.x,W.positionScreen.y),L.intersects(ha))){Da=0;for(La=wa.meshMaterials.length;Da<La;)if(F=wa.meshMaterials[Da++],F instanceof THREE.MeshFaceMaterial){Ua=0;for(Za=wa.faceMaterials.length;Ua<Za;)(F=wa.faceMaterials[Ua++])&&F.opacity!=0&&C(J,I,K,W,D,S,wa,F,b)}else F.opacity!=0&&C(J,I,K,W,D,S,wa,F,b)}O.addRectangle(ha)}p.setTransform(1,0,0,1,0,0)}};
THREE.SVGRenderer=function(){function b(b,e,c){var f,k,h,m;f=0;for(k=b.lights.length;f<k;f++)h=b.lights[f],h instanceof THREE.DirectionalLight?(m=e.normalWorld.dot(h.position)*h.intensity,m>0&&(c.r+=h.color.r*m,c.g+=h.color.g*m,c.b+=h.color.b*m)):h instanceof THREE.PointLight&&(W.sub(h.position,e.centroidWorld),W.normalize(),m=e.normalWorld.dot(W)*h.intensity,m>0&&(c.r+=h.color.r*m,c.g+=h.color.g*m,c.b+=h.color.b*m))}function c(e,c,k,o,n,v){m.data.vertices+=3;m.data.faces++;U=f(da++);U.setAttribute("d",
"M "+e.positionScreen.x+" "+e.positionScreen.y+" L "+c.positionScreen.x+" "+c.positionScreen.y+" L "+k.positionScreen.x+","+k.positionScreen.y+"z");n instanceof THREE.MeshBasicMaterial?H.copy(n.color):n instanceof THREE.MeshLambertMaterial?G?(M.r=R.r,M.g=R.g,M.b=R.b,b(v,o,M),H.r=Math.max(0,Math.min(n.color.r*M.r,1)),H.g=Math.max(0,Math.min(n.color.g*M.g,1)),H.b=Math.max(0,Math.min(n.color.b*M.b,1))):H.copy(n.color):n instanceof THREE.MeshDepthMaterial?(K=1-n.__2near/(n.__farPlusNear-o.z*n.__farMinusNear),
H.setRGB(K,K,K)):n instanceof THREE.MeshNormalMaterial&&H.setRGB(h(o.normalWorld.x),h(o.normalWorld.y),h(o.normalWorld.z));n.wireframe?U.setAttribute("style","fill: none; stroke: "+H.getContextStyle()+"; stroke-width: "+n.wireframeLinewidth+"; stroke-opacity: "+n.opacity+"; stroke-linecap: "+n.wireframeLinecap+"; stroke-linejoin: "+n.wireframeLinejoin):U.setAttribute("style","fill: "+H.getContextStyle()+"; fill-opacity: "+n.opacity);t.appendChild(U)}function e(e,c,k,o,n,v,p){m.data.vertices+=4;m.data.faces++;
U=f(da++);U.setAttribute("d","M "+e.positionScreen.x+" "+e.positionScreen.y+" L "+c.positionScreen.x+" "+c.positionScreen.y+" L "+k.positionScreen.x+","+k.positionScreen.y+" L "+o.positionScreen.x+","+o.positionScreen.y+"z");v instanceof THREE.MeshBasicMaterial?H.copy(v.color):v instanceof THREE.MeshLambertMaterial?G?(M.r=R.r,M.g=R.g,M.b=R.b,b(p,n,M),H.r=Math.max(0,Math.min(v.color.r*M.r,1)),H.g=Math.max(0,Math.min(v.color.g*M.g,1)),H.b=Math.max(0,Math.min(v.color.b*M.b,1))):H.copy(v.color):v instanceof
THREE.MeshDepthMaterial?(K=1-v.__2near/(v.__farPlusNear-n.z*v.__farMinusNear),H.setRGB(K,K,K)):v instanceof THREE.MeshNormalMaterial&&H.setRGB(h(n.normalWorld.x),h(n.normalWorld.y),h(n.normalWorld.z));v.wireframe?U.setAttribute("style","fill: none; stroke: "+H.getContextStyle()+"; stroke-width: "+v.wireframeLinewidth+"; stroke-opacity: "+v.opacity+"; stroke-linecap: "+v.wireframeLinecap+"; stroke-linejoin: "+v.wireframeLinejoin):U.setAttribute("style","fill: "+H.getContextStyle()+"; fill-opacity: "+
v.opacity);t.appendChild(U)}function f(b){D[b]==null&&(D[b]=document.createElementNS("http://www.w3.org/2000/svg","path"),o==0&&D[b].setAttribute("shape-rendering","crispEdges"));return D[b]}function h(b){b=(b+1)*0.5;return b<0?0:b>1?1:b}var m=this,k=null,n=new THREE.Projector,t=document.createElementNS("http://www.w3.org/2000/svg","svg"),u,w,v,x,p,y,z,A,C=new THREE.Rectangle,E=new THREE.Rectangle,G=!1,H=new THREE.Color(16777215),M=new THREE.Color(16777215),R=new THREE.Color(0),J=new THREE.Color(0),
I=new THREE.Color(0),K,W=new THREE.Vector3,D=[],S=[],U,da,Q,o=1;this.domElement=t;this.sortElements=this.sortObjects=this.autoClear=!0;this.data={vertices:0,faces:0};this.setQuality=function(b){switch(b){case "high":o=1;break;case "low":o=0}};this.setSize=function(b,e){u=b;w=e;v=u/2;x=w/2;t.setAttribute("viewBox",-v+" "+-x+" "+u+" "+w);t.setAttribute("width",u);t.setAttribute("height",w);C.set(-v,-x,v,x)};this.clear=function(){for(;t.childNodes.length>0;)t.removeChild(t.childNodes[0])};this.render=
function(b,f){var h,u,w,H,M,D,K,V;this.autoClear&&this.clear();m.data.vertices=0;m.data.faces=0;k=n.projectScene(b,f,this.sortElements);Q=da=0;if(G=b.lights.length>0){K=b.lights;R.setRGB(0,0,0);J.setRGB(0,0,0);I.setRGB(0,0,0);h=0;for(u=K.length;h<u;h++)w=K[h],H=w.color,w instanceof THREE.AmbientLight?(R.r+=H.r,R.g+=H.g,R.b+=H.b):w instanceof THREE.DirectionalLight?(J.r+=H.r,J.g+=H.g,J.b+=H.b):w instanceof THREE.PointLight&&(I.r+=H.r,I.g+=H.g,I.b+=H.b)}h=0;for(u=k.length;h<u;h++)if(K=k[h],E.empty(),
K instanceof THREE.RenderableParticle){p=K;p.x*=v;p.y*=-x;w=0;for(H=K.materials.length;w<H;)w++}else if(K instanceof THREE.RenderableLine){if(p=K.v1,y=K.v2,p.positionScreen.x*=v,p.positionScreen.y*=-x,y.positionScreen.x*=v,y.positionScreen.y*=-x,E.addPoint(p.positionScreen.x,p.positionScreen.y),E.addPoint(y.positionScreen.x,y.positionScreen.y),C.intersects(E)){w=0;for(H=K.materials.length;w<H;)if((V=K.materials[w++])&&V.opacity!=0){M=p;D=y;var $=Q++;S[$]==null&&(S[$]=document.createElementNS("http://www.w3.org/2000/svg",
"line"),o==0&&S[$].setAttribute("shape-rendering","crispEdges"));U=S[$];U.setAttribute("x1",M.positionScreen.x);U.setAttribute("y1",M.positionScreen.y);U.setAttribute("x2",D.positionScreen.x);U.setAttribute("y2",D.positionScreen.y);V instanceof THREE.LineBasicMaterial&&(U.setAttribute("style","fill: none; stroke: "+V.color.getContextStyle()+"; stroke-width: "+V.linewidth+"; stroke-opacity: "+V.opacity+"; stroke-linecap: "+V.linecap+"; stroke-linejoin: "+V.linejoin),t.appendChild(U))}}}else if(K instanceof
THREE.RenderableFace3){if(p=K.v1,y=K.v2,z=K.v3,p.positionScreen.x*=v,p.positionScreen.y*=-x,y.positionScreen.x*=v,y.positionScreen.y*=-x,z.positionScreen.x*=v,z.positionScreen.y*=-x,E.addPoint(p.positionScreen.x,p.positionScreen.y),E.addPoint(y.positionScreen.x,y.positionScreen.y),E.addPoint(z.positionScreen.x,z.positionScreen.y),C.intersects(E)){w=0;for(H=K.meshMaterials.length;w<H;)if(V=K.meshMaterials[w++],V instanceof THREE.MeshFaceMaterial){M=0;for(D=K.faceMaterials.length;M<D;)(V=K.faceMaterials[M++])&&
V.opacity!=0&&c(p,y,z,K,V,b)}else V&&V.opacity!=0&&c(p,y,z,K,V,b)}}else if(K instanceof THREE.RenderableFace4&&(p=K.v1,y=K.v2,z=K.v3,A=K.v4,p.positionScreen.x*=v,p.positionScreen.y*=-x,y.positionScreen.x*=v,y.positionScreen.y*=-x,z.positionScreen.x*=v,z.positionScreen.y*=-x,A.positionScreen.x*=v,A.positionScreen.y*=-x,E.addPoint(p.positionScreen.x,p.positionScreen.y),E.addPoint(y.positionScreen.x,y.positionScreen.y),E.addPoint(z.positionScreen.x,z.positionScreen.y),E.addPoint(A.positionScreen.x,A.positionScreen.y),
C.intersects(E))){w=0;for(H=K.meshMaterials.length;w<H;)if(V=K.meshMaterials[w++],V instanceof THREE.MeshFaceMaterial){M=0;for(D=K.faceMaterials.length;M<D;)(V=K.faceMaterials[M++])&&V.opacity!=0&&e(p,y,z,A,K,V,b)}else V&&V.opacity!=0&&e(p,y,z,A,K,V,b)}}};
THREE.ShaderChunk={fog_pars_fragment:"#ifdef USE_FOG\nuniform vec3 fogColor;\n#ifdef FOG_EXP2\nuniform float fogDensity;\n#else\nuniform float fogNear;\nuniform float fogFar;\n#endif\n#endif",fog_fragment:"#ifdef USE_FOG\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\n#ifdef FOG_EXP2\nconst float LOG2 = 1.442695;\nfloat fogFactor = exp2( - fogDensity * fogDensity * depth * depth * LOG2 );\nfogFactor = 1.0 - clamp( fogFactor, 0.0, 1.0 );\n#else\nfloat fogFactor = smoothstep( fogNear, fogFar, depth );\n#endif\ngl_FragColor = mix( gl_FragColor, vec4( fogColor, gl_FragColor.w ), fogFactor );\n#endif",envmap_pars_fragment:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float reflectivity;\nuniform samplerCube envMap;\nuniform int combine;\n#endif",
envmap_fragment:"#ifdef USE_ENVMAP\nvec4 cubeColor = textureCube( envMap, vec3( -vReflect.x, vReflect.yz ) );\nif ( combine == 1 ) {\ngl_FragColor = vec4( mix( gl_FragColor.xyz, cubeColor.xyz, reflectivity ), opacity );\n} else {\ngl_FragColor = gl_FragColor * cubeColor;\n}\n#endif",envmap_pars_vertex:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float refractionRatio;\nuniform bool useRefract;\n#endif",envmap_vertex:"#ifdef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = mat3( objectMatrix[ 0 ].xyz, objectMatrix[ 1 ].xyz, objectMatrix[ 2 ].xyz ) * normal;\nif ( useRefract ) {\nvReflect = refract( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ), refractionRatio );\n} else {\nvReflect = reflect( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ) );\n}\n#endif",
map_particle_pars_fragment:"#ifdef USE_MAP\nuniform sampler2D map;\n#endif",map_particle_fragment:"#ifdef USE_MAP\ngl_FragColor = gl_FragColor * texture2D( map, gl_PointCoord );\n#endif",map_pars_vertex:"#ifdef USE_MAP\nvarying vec2 vUv;\nuniform vec4 offsetRepeat;\n#endif",map_pars_fragment:"#ifdef USE_MAP\nvarying vec2 vUv;\nuniform sampler2D map;\n#endif",map_vertex:"#ifdef USE_MAP\nvUv = uv * offsetRepeat.zw + offsetRepeat.xy;\n#endif",map_fragment:"#ifdef USE_MAP\ngl_FragColor = gl_FragColor * texture2D( map, vUv );\n#endif",
lightmap_pars_fragment:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\nuniform sampler2D lightMap;\n#endif",lightmap_pars_vertex:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\n#endif",lightmap_fragment:"#ifdef USE_LIGHTMAP\ngl_FragColor = gl_FragColor * texture2D( lightMap, vUv2 );\n#endif",lightmap_vertex:"#ifdef USE_LIGHTMAP\nvUv2 = uv2;\n#endif",lights_pars_vertex:"uniform bool enableLighting;\nuniform vec3 ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\nuniform float pointLightDistance[ MAX_POINT_LIGHTS ];\n#ifdef PHONG\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\n#endif",
lights_vertex:"if ( !enableLighting ) {\nvLightWeighting = vec3( 1.0 );\n} else {\nvLightWeighting = ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nfor( int i = 0; i < MAX_DIR_LIGHTS; i ++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nfloat directionalLightWeighting = max( dot( transformedNormal, normalize( lDirection.xyz ) ), 0.0 );\nvLightWeighting += directionalLightColor[ i ] * directionalLightWeighting;\n}\n#endif\n#if MAX_POINT_LIGHTS > 0\nfor( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 lVector = lPosition.xyz - mvPosition.xyz;\nfloat lDistance = 1.0;\nif ( pointLightDistance[ i ] > 0.0 )\nlDistance = 1.0 - min( ( length( lVector ) / pointLightDistance[ i ] ), 1.0 );\nlVector = normalize( lVector );\nfloat pointLightWeighting = max( dot( transformedNormal, lVector ), 0.0 );\nvLightWeighting += pointLightColor[ i ] * pointLightWeighting * lDistance;\n#ifdef PHONG\nvPointLight[ i ] = vec4( lVector, lDistance );\n#endif\n}\n#endif\n}",
lights_pars_fragment:"#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",lights_fragment:"vec3 normal = normalize( vNormal );\nvec3 viewPosition = normalize( vViewPosition );\nvec4 mColor = vec4( diffuse, opacity );\nvec4 mSpecular = vec4( specular, opacity );\n#if MAX_POINT_LIGHTS > 0\nvec4 pointDiffuse  = vec4( vec3( 0.0 ), 1.0 );\nvec4 pointSpecular = vec4( vec3( 0.0 ), 1.0 );\nfor ( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\nvec3 pointVector = normalize( vPointLight[ i ].xyz );\nvec3 pointHalfVector = normalize( vPointLight[ i ].xyz + viewPosition );\nfloat pointDistance = vPointLight[ i ].w;\nfloat pointDotNormalHalf = dot( normal, pointHalfVector );\nfloat pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );\nfloat pointSpecularWeight = 0.0;\nif ( pointDotNormalHalf >= 0.0 )\npointSpecularWeight = pow( pointDotNormalHalf, shininess );\npointDiffuse  += mColor * pointDiffuseWeight * pointDistance;\npointSpecular += mSpecular * pointSpecularWeight * pointDistance;\n}\n#endif\n#if MAX_DIR_LIGHTS > 0\nvec4 dirDiffuse  = vec4( vec3( 0.0 ), 1.0 );\nvec4 dirSpecular = vec4( vec3( 0.0 ), 1.0 );\nfor( int i = 0; i < MAX_DIR_LIGHTS; i ++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nvec3 dirHalfVector = normalize( lDirection.xyz + viewPosition );\nfloat dirDotNormalHalf = dot( normal, dirHalfVector );\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\nfloat dirSpecularWeight = 0.0;\nif ( dirDotNormalHalf >= 0.0 )\ndirSpecularWeight = pow( dirDotNormalHalf, shininess );\ndirDiffuse  += mColor * dirDiffuseWeight;\ndirSpecular += mSpecular * dirSpecularWeight;\n}\n#endif\nvec4 totalLight = vec4( ambient, opacity );\n#if MAX_DIR_LIGHTS > 0\ntotalLight += dirDiffuse + dirSpecular;\n#endif\n#if MAX_POINT_LIGHTS > 0\ntotalLight += pointDiffuse + pointSpecular;\n#endif\ngl_FragColor = gl_FragColor * totalLight;",
color_pars_fragment:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_fragment:"#ifdef USE_COLOR\ngl_FragColor = gl_FragColor * vec4( vColor, opacity );\n#endif",color_pars_vertex:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_vertex:"#ifdef USE_COLOR\nvColor = color;\n#endif",skinning_pars_vertex:"#ifdef USE_SKINNING\nuniform mat4 boneGlobalMatrices[ MAX_BONES ];\n#endif",skinning_vertex:"#ifdef USE_SKINNING\ngl_Position  = ( boneGlobalMatrices[ int( skinIndex.x ) ] * skinVertexA ) * skinWeight.x;\ngl_Position += ( boneGlobalMatrices[ int( skinIndex.y ) ] * skinVertexB ) * skinWeight.y;\ngl_Position  = projectionMatrix * viewMatrix * objectMatrix * gl_Position;\n#endif",
morphtarget_pars_vertex:"#ifdef USE_MORPHTARGETS\nuniform float morphTargetInfluences[ 8 ];\n#endif",morphtarget_vertex:"#ifdef USE_MORPHTARGETS\nvec3 morphed = vec3( 0.0, 0.0, 0.0 );\nmorphed += ( morphTarget0 - position ) * morphTargetInfluences[ 0 ];\nmorphed += ( morphTarget1 - position ) * morphTargetInfluences[ 1 ];\nmorphed += ( morphTarget2 - position ) * morphTargetInfluences[ 2 ];\nmorphed += ( morphTarget3 - position ) * morphTargetInfluences[ 3 ];\nmorphed += ( morphTarget4 - position ) * morphTargetInfluences[ 4 ];\nmorphed += ( morphTarget5 - position ) * morphTargetInfluences[ 5 ];\nmorphed += ( morphTarget6 - position ) * morphTargetInfluences[ 6 ];\nmorphed += ( morphTarget7 - position ) * morphTargetInfluences[ 7 ];\nmorphed += position;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( morphed, 1.0 );\n#endif",
default_vertex:"#ifndef USE_MORPHTARGETS\n#ifndef USE_SKINNING\ngl_Position = projectionMatrix * mvPosition;\n#endif\n#endif",shadowmap_pars_fragment:"#ifdef USE_SHADOWMAP\nuniform sampler2D shadowMap[ MAX_SHADOWS ];\nuniform float shadowDarkness;\nuniform float shadowBias;\nvarying vec4 vShadowCoord[ MAX_SHADOWS ];\nfloat unpackDepth( const in vec4 rgba_depth ) {\nconst vec4 bit_shift = vec4( 1.0 / ( 256.0 * 256.0 * 256.0 ), 1.0 / ( 256.0 * 256.0 ), 1.0 / 256.0, 1.0 );\nfloat depth = dot( rgba_depth, bit_shift );\nreturn depth;\n}\n#endif",
shadowmap_fragment:"#ifdef USE_SHADOWMAP\n#ifdef SHADOWMAP_SOFT\nconst float xPixelOffset = 1.0 / SHADOWMAP_WIDTH;\nconst float yPixelOffset = 1.0 / SHADOWMAP_HEIGHT;\n#endif\nvec4 shadowColor = vec4( 1.0 );\nfor( int i = 0; i < MAX_SHADOWS; i ++ ) {\nvec3 shadowCoord = vShadowCoord[ i ].xyz / vShadowCoord[ i ].w;\nif ( shadowCoord.x >= 0.0 && shadowCoord.x <= 1.0 && shadowCoord.y >= 0.0 && shadowCoord.y <= 1.0 ) {\n#ifdef SHADOWMAP_SOFT\nfloat shadow = 0.0;\nfor ( float y = -1.25; y <= 1.25; y += 1.25 )\nfor ( float x = -1.25; x <= 1.25; x += 1.25 ) {\nvec4 rgbaDepth = texture2D( shadowMap[ i ], vec2( x * xPixelOffset, y * yPixelOffset ) + shadowCoord.xy );\nfloat fDepth = unpackDepth( rgbaDepth );\nif ( fDepth < ( shadowCoord.z + shadowBias ) )\nshadow += 1.0;\n}\nshadow /= 9.0;\nshadowColor = shadowColor * vec4( vec3( ( 1.0 - shadowDarkness * shadow ) ), 1.0 );\n#else\nvec4 rgbaDepth = texture2D( shadowMap[ i ], shadowCoord.xy );\nfloat fDepth = unpackDepth( rgbaDepth );\nif ( fDepth < ( shadowCoord.z + shadowBias ) )\nshadowColor = shadowColor * vec4( vec3( shadowDarkness ), 1.0 );\n#endif\n}\n}\ngl_FragColor = gl_FragColor * shadowColor;\n#endif",
shadowmap_pars_vertex:"#ifdef USE_SHADOWMAP\nvarying vec4 vShadowCoord[ MAX_SHADOWS ];\nuniform mat4 shadowMatrix[ MAX_SHADOWS ];\n#endif",shadowmap_vertex:"#ifdef USE_SHADOWMAP\nfor( int i = 0; i < MAX_SHADOWS; i ++ ) {\nvShadowCoord[ i ] = shadowMatrix[ i ] * objectMatrix * vec4( position, 1.0 );\n}\n#endif",alphatest_fragment:"#ifdef ALPHATEST\nif ( gl_FragColor.a < ALPHATEST ) discard;\n#endif"};
THREE.UniformsUtils={merge:function(b){var c,e,f,h={};for(c=0;c<b.length;c++)for(e in f=this.clone(b[c]),f)h[e]=f[e];return h},clone:function(b){var c,e,f,h={};for(c in b)for(e in h[c]={},b[c])f=b[c][e],h[c][e]=f instanceof THREE.Color||f instanceof THREE.Vector2||f instanceof THREE.Vector3||f instanceof THREE.Vector4||f instanceof THREE.Matrix4||f instanceof THREE.Texture?f.clone():f instanceof Array?f.slice():f;return h}};
THREE.UniformsLib={common:{diffuse:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},map:{type:"t",value:0,texture:null},offsetRepeat:{type:"v4",value:new THREE.Vector4(0,0,1,1)},lightMap:{type:"t",value:2,texture:null},envMap:{type:"t",value:1,texture:null},useRefract:{type:"i",value:0},reflectivity:{type:"f",value:1},refractionRatio:{type:"f",value:0.98},combine:{type:"i",value:0},morphTargetInfluences:{type:"f",value:0}},fog:{fogDensity:{type:"f",value:2.5E-4},fogNear:{type:"f",
value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}},lights:{enableLighting:{type:"i",value:1},ambientLightColor:{type:"fv",value:[]},directionalLightDirection:{type:"fv",value:[]},directionalLightColor:{type:"fv",value:[]},pointLightColor:{type:"fv",value:[]},pointLightPosition:{type:"fv",value:[]},pointLightDistance:{type:"fv1",value:[]}},particle:{psColor:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},size:{type:"f",value:1},scale:{type:"f",
value:1},map:{type:"t",value:0,texture:null},fogDensity:{type:"f",value:2.5E-4},fogNear:{type:"f",value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}},shadowmap:{shadowMap:{type:"tv",value:3,texture:[]},shadowMatrix:{type:"m4v",value:[]},shadowBias:{type:"f",value:0.0039},shadowDarkness:{type:"f",value:0.2}}};
THREE.ShaderLib={lensFlareVertexTexture:{vertexShader:"uniform vec3 screenPosition;\nuniform vec2 scale;\nuniform float rotation;\nuniform int renderType;\nuniform sampler2D occlusionMap;\nattribute vec2 position;\nattribute vec2 UV;\nvarying vec2 vUV;\nvarying float vVisibility;\nvoid main() {\nvUV = UV;\nvec2 pos = position;\nif( renderType == 2 ) {\nvec4 visibility = texture2D( occlusionMap, vec2( 0.1, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.5 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.1, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.1, 0.5 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.5 ) );\nvVisibility = (       visibility.r / 9.0 ) *\n( 1.0 - visibility.g / 9.0 ) *\n(       visibility.b / 9.0 ) *\n( 1.0 - visibility.a / 9.0 );\npos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;\npos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;\n}\ngl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );\n}",fragmentShader:"#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D map;\nuniform float opacity;\nuniform int renderType;\nvarying vec2 vUV;\nvarying float vVisibility;\nvoid main() {\nif( renderType == 0 ) {\ngl_FragColor = vec4( 1.0, 0.0, 1.0, 0.0 );\n} else if( renderType == 1 ) {\ngl_FragColor = texture2D( map, vUV );\n} else {\nvec4 color = texture2D( map, vUV );\ncolor.a *= opacity * vVisibility;\ngl_FragColor = color;\n}\n}"},
lensFlare:{vertexShader:"uniform vec3 screenPosition;\nuniform vec2 scale;\nuniform float rotation;\nuniform int renderType;\nattribute vec2 position;\nattribute vec2 UV;\nvarying vec2 vUV;\nvoid main() {\nvUV = UV;\nvec2 pos = position;\nif( renderType == 2 ) {\npos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;\npos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;\n}\ngl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );\n}",fragmentShader:"#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D map;\nuniform sampler2D occlusionMap;\nuniform float opacity;\nuniform int renderType;\nvarying vec2 vUV;\nvoid main() {\nif( renderType == 0 ) {\ngl_FragColor = vec4( texture2D( map, vUV ).rgb, 0.0 );\n} else if( renderType == 1 ) {\ngl_FragColor = texture2D( map, vUV );\n} else {\nfloat visibility = texture2D( occlusionMap, vec2( 0.5, 0.1 ) ).a +\ntexture2D( occlusionMap, vec2( 0.9, 0.5 ) ).a +\ntexture2D( occlusionMap, vec2( 0.5, 0.9 ) ).a +\ntexture2D( occlusionMap, vec2( 0.1, 0.5 ) ).a;\nvisibility = ( 1.0 - visibility / 4.0 );\nvec4 color = texture2D( map, vUV );\ncolor.a *= opacity * visibility;\ngl_FragColor = color;\n}\n}"},
sprite:{vertexShader:"uniform int useScreenCoordinates;\nuniform int affectedByDistance;\nuniform vec3 screenPosition;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform float rotation;\nuniform vec2 scale;\nuniform vec2 alignment;\nuniform vec2 uvOffset;\nuniform vec2 uvScale;\nattribute vec2 position;\nattribute vec2 uv;\nvarying vec2 vUV;\nvoid main() {\nvUV = uvOffset + uv * uvScale;\nvec2 alignedPosition = position + alignment;\nvec2 rotatedPosition;\nrotatedPosition.x = ( cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y ) * scale.x;\nrotatedPosition.y = ( sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y ) * scale.y;\nvec4 finalPosition;\nif( useScreenCoordinates != 0 ) {\nfinalPosition = vec4( screenPosition.xy + rotatedPosition, screenPosition.z, 1.0 );\n} else {\nfinalPosition = projectionMatrix * modelViewMatrix * vec4( 0.0, 0.0, 0.0, 1.0 );\nfinalPosition.xy += rotatedPosition * ( affectedByDistance == 1 ? 1.0 : finalPosition.z );\n}\ngl_Position = finalPosition;\n}",
fragmentShader:"#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D map;\nuniform float opacity;\nvarying vec2 vUV;\nvoid main() {\nvec4 color = texture2D( map, vUV );\ncolor.a *= opacity;\ngl_FragColor = color;\n}"},shadowPost:{vertexShader:"uniform \tmat4 \tprojectionMatrix;\nattribute \tvec3 \tposition;\nvoid main() {\ngl_Position = projectionMatrix * vec4( position, 1.0 );\n}",fragmentShader:"#ifdef GL_ES\nprecision highp float;\n#endif\nuniform \tfloat \tdarkness;\nvoid main() {\ngl_FragColor = vec4( 0, 0, 0, darkness );\n}"},
shadowVolumeDynamic:{uniforms:{directionalLightDirection:{type:"fv",value:[]}},vertexShader:"uniform \tvec3 \tdirectionalLightDirection;\nvoid main() {\nvec4 pos      = objectMatrix * vec4( position, 1.0 );\nvec3 norm     = mat3( objectMatrix[ 0 ].xyz, objectMatrix[ 1 ].xyz, objectMatrix[ 2 ].xyz ) * normal;\nvec4 extruded = vec4( directionalLightDirection * 5000.0 * step( 0.0, dot( directionalLightDirection, norm ) ), 0.0 );\ngl_Position   = projectionMatrix * viewMatrix * ( pos + extruded );\n}",
fragmentShader:"void main() {\ngl_FragColor = vec4( 1.0 );\n}"},depth:{uniforms:{mNear:{type:"f",value:1},mFar:{type:"f",value:2E3},opacity:{type:"f",value:1}},fragmentShader:"uniform float mNear;\nuniform float mFar;\nuniform float opacity;\nvoid main() {\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\nfloat color = 1.0 - smoothstep( mNear, mFar, depth );\ngl_FragColor = vec4( vec3( color ), opacity );\n}",vertexShader:"void main() {\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}"},
normal:{uniforms:{opacity:{type:"f",value:1}},fragmentShader:"uniform float opacity;\nvarying vec3 vNormal;\nvoid main() {\ngl_FragColor = vec4( 0.5 * normalize( vNormal ) + 0.5, opacity );\n}",vertexShader:"varying vec3 vNormal;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvNormal = normalize( normalMatrix * normal );\ngl_Position = projectionMatrix * mvPosition;\n}"},basic:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.fog,THREE.UniformsLib.shadowmap]),
fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,"void main() {\ngl_FragColor = vec4( diffuse, opacity );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.alphatest_fragment,THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,
THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:[THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,
THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n")},lambert:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.fog,THREE.UniformsLib.lights,THREE.UniformsLib.shadowmap]),fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;\nvarying vec3 vLightWeighting;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,
THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,"void main() {\ngl_FragColor = vec4( diffuse, opacity );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.alphatest_fragment,"gl_FragColor = gl_FragColor * vec4( vLightWeighting, 1.0 );",THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.fog_fragment,
"}"].join("\n"),vertexShader:["varying vec3 vLightWeighting;",THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.lights_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,
THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,"vec3 transformedNormal = normalize( normalMatrix * normal );",THREE.ShaderChunk.lights_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n")},phong:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.fog,THREE.UniformsLib.lights,THREE.UniformsLib.shadowmap,{ambient:{type:"c",value:new THREE.Color(328965)},
specular:{type:"c",value:new THREE.Color(1118481)},shininess:{type:"f",value:30}}]),fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;\nuniform vec3 ambient;\nuniform vec3 specular;\nuniform float shininess;\nvarying vec3 vLightWeighting;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.lights_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,
"void main() {\ngl_FragColor = vec4( vLightWeighting, 1.0 );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.alphatest_fragment,THREE.ShaderChunk.lights_fragment,THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:["#define PHONG\nvarying vec3 vLightWeighting;\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,
THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.lights_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,"#ifndef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\n#endif\nvViewPosition = -mvPosition.xyz;\nvec3 transformedNormal = normalize( normalMatrix * normal );\nvNormal = transformedNormal;",
THREE.ShaderChunk.lights_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n")},particle_basic:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.particle,THREE.UniformsLib.shadowmap]),fragmentShader:["uniform vec3 psColor;\nuniform float opacity;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_particle_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,
"void main() {\ngl_FragColor = vec4( psColor, opacity );",THREE.ShaderChunk.map_particle_fragment,THREE.ShaderChunk.alphatest_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:["uniform float size;\nuniform float scale;",THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {",THREE.ShaderChunk.color_vertex,"vec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\n#ifdef USE_SIZEATTENUATION\ngl_PointSize = size * ( scale / length( mvPosition.xyz ) );\n#else\ngl_PointSize = size;\n#endif\ngl_Position = projectionMatrix * mvPosition;",
THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n")},depthRGBA:{uniforms:{},fragmentShader:"vec4 pack_depth( const in float depth ) {\nconst vec4 bit_shift = vec4( 256.0 * 256.0 * 256.0, 256.0 * 256.0, 256.0, 1.0 );\nconst vec4 bit_mask  = vec4( 0.0, 1.0 / 256.0, 1.0 / 256.0, 1.0 / 256.0 );\nvec4 res = fract( depth * bit_shift );\nres -= res.xxyz * bit_mask;\nreturn res;\n}\nvoid main() {\ngl_FragData[ 0 ] = pack_depth( gl_FragCoord.z );\n}",vertexShader:[THREE.ShaderChunk.morphtarget_pars_vertex,
"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,"}"].join("\n")}};
THREE.WebGLRenderer=function(b){function c(b,e,c){var f,k,h,m=b.vertices,n=m.length,v=b.colors,p=v.length,u=b.__vertexArray,t=b.__colorArray,w=b.__sortArray,x=b.__dirtyVertices,L=b.__dirtyColors,y=b.__webglCustomAttributes,ha,O;if(y)for(ha in y)y[ha].offset=0;if(c.sortParticles){ra.multiplySelf(c.matrixWorld);for(f=0;f<n;f++)k=m[f].position,xa.copy(k),ra.multiplyVector3(xa),w[f]=[xa.z,f];w.sort(function(b,e){return e[0]-b[0]});for(f=0;f<n;f++)k=m[w[f][1]].position,h=f*3,u[h]=k.x,u[h+1]=k.y,u[h+2]=
k.z;for(f=0;f<p;f++)h=f*3,color=v[w[f][1]],t[h]=color.r,t[h+1]=color.g,t[h+2]=color.b;if(y)for(ha in y){f=y[ha];v=f.value.length;for(h=0;h<v;h++){index=w[h][1];p=f.offset;if(f.size===1){if(f.boundTo===void 0||f.boundTo==="vertices")f.array[p]=f.value[index]}else{if(f.boundTo===void 0||f.boundTo==="vertices")O=f.value[index];f.size===2?(f.array[p]=O.x,f.array[p+1]=O.y):f.size===3?f.type==="c"?(f.array[p]=O.r,f.array[p+1]=O.g,f.array[p+2]=O.b):(f.array[p]=O.x,f.array[p+1]=O.y,f.array[p+2]=O.z):(f.array[p]=
O.x,f.array[p+1]=O.y,f.array[p+2]=O.z,f.array[p+3]=O.w)}f.offset+=f.size}}}else{if(x)for(f=0;f<n;f++)k=m[f].position,h=f*3,u[h]=k.x,u[h+1]=k.y,u[h+2]=k.z;if(L)for(f=0;f<p;f++)color=v[f],h=f*3,t[h]=color.r,t[h+1]=color.g,t[h+2]=color.b;if(y)for(ha in y)if(f=y[ha],f.__original.needsUpdate){v=f.value.length;for(h=0;h<v;h++){p=f.offset;if(f.size===1){if(f.boundTo===void 0||f.boundTo==="vertices")f.array[p]=f.value[h]}else{if(f.boundTo===void 0||f.boundTo==="vertices")O=f.value[h];f.size===2?(f.array[p]=
O.x,f.array[p+1]=O.y):f.size===3?f.type==="c"?(f.array[p]=O.r,f.array[p+1]=O.g,f.array[p+2]=O.b):(f.array[p]=O.x,f.array[p+1]=O.y,f.array[p+2]=O.z):(f.array[p]=O.x,f.array[p+1]=O.y,f.array[p+2]=O.z,f.array[p+3]=O.w)}f.offset+=f.size}}}if(x||c.sortParticles)o.bindBuffer(o.ARRAY_BUFFER,b.__webglVertexBuffer),o.bufferData(o.ARRAY_BUFFER,u,e);if(L||c.sortParticles)o.bindBuffer(o.ARRAY_BUFFER,b.__webglColorBuffer),o.bufferData(o.ARRAY_BUFFER,t,e);if(y)for(ha in y)if(f=y[ha],f.__original.needsUpdate||c.sortParticles)o.bindBuffer(o.ARRAY_BUFFER,
f.buffer),o.bufferData(o.ARRAY_BUFFER,f.array,e)}function e(b,e,c,f,k){f.program||Q.initMaterial(f,e,c,k);if(f.morphTargets&&!k.__webglMorphTargetInfluences){k.__webglMorphTargetInfluences=new Float32Array(Q.maxMorphTargets);for(var h=0,m=Q.maxMorphTargets;h<m;h++)k.__webglMorphTargetInfluences[h]=0}var h=f.program,m=h.uniforms,n=f.uniforms;h!=T&&(o.useProgram(h),T=h);o.uniformMatrix4fv(m.projectionMatrix,!1,ua);if(c&&f.fog)if(n.fogColor.value=c.color,c instanceof THREE.Fog)n.fogNear.value=c.near,
n.fogFar.value=c.far;else if(c instanceof THREE.FogExp2)n.fogDensity.value=c.density;if(f instanceof THREE.MeshPhongMaterial||f instanceof THREE.MeshLambertMaterial||f.lights){var p,v,u,t=0,w=0,x=0,L,y,ha,O=Ca,z=O.directional.colors,A=O.directional.positions,C=O.point.colors,E=O.point.positions,G=O.point.distances,H=0,aa=0,c=v=ha=0;for(p=e.length;c<p;c++)if(v=e[c],u=v.color,L=v.position,y=v.intensity,ha=v.distance,v instanceof THREE.AmbientLight)t+=u.r,w+=u.g,x+=u.b;else if(v instanceof THREE.DirectionalLight)ha=
H*3,z[ha]=u.r*y,z[ha+1]=u.g*y,z[ha+2]=u.b*y,A[ha]=L.x,A[ha+1]=L.y,A[ha+2]=L.z,H+=1;else if(v instanceof THREE.SpotLight)ha=H*3,z[ha]=u.r*y,z[ha+1]=u.g*y,z[ha+2]=u.b*y,u=1/L.length(),A[ha]=L.x*u,A[ha+1]=L.y*u,A[ha+2]=L.z*u,H+=1;else if(v instanceof THREE.PointLight)v=aa*3,C[v]=u.r*y,C[v+1]=u.g*y,C[v+2]=u.b*y,E[v]=L.x,E[v+1]=L.y,E[v+2]=L.z,G[aa]=ha,aa+=1;for(c=H*3;c<z.length;c++)z[c]=0;for(c=aa*3;c<C.length;c++)C[c]=0;O.point.length=aa;O.directional.length=H;O.ambient[0]=t;O.ambient[1]=w;O.ambient[2]=
x;e=Ca;n.enableLighting.value=e.directional.length+e.point.length;n.ambientLightColor.value=e.ambient;n.directionalLightColor.value=e.directional.colors;n.directionalLightDirection.value=e.directional.positions;n.pointLightColor.value=e.point.colors;n.pointLightPosition.value=e.point.positions;n.pointLightDistance.value=e.point.distances}if(f instanceof THREE.MeshBasicMaterial||f instanceof THREE.MeshLambertMaterial||f instanceof THREE.MeshPhongMaterial)n.diffuse.value=f.color,n.opacity.value=f.opacity,
(n.map.texture=f.map)&&n.offsetRepeat.value.set(f.map.offset.x,f.map.offset.y,f.map.repeat.x,f.map.repeat.y),n.lightMap.texture=f.lightMap,n.envMap.texture=f.envMap,n.reflectivity.value=f.reflectivity,n.refractionRatio.value=f.refractionRatio,n.combine.value=f.combine,n.useRefract.value=f.envMap&&f.envMap.mapping instanceof THREE.CubeRefractionMapping;if(f instanceof THREE.LineBasicMaterial)n.diffuse.value=f.color,n.opacity.value=f.opacity;else if(f instanceof THREE.ParticleBasicMaterial)n.psColor.value=
f.color,n.opacity.value=f.opacity,n.size.value=f.size,n.scale.value=za.height/2,n.map.texture=f.map;else if(f instanceof THREE.MeshPhongMaterial)n.ambient.value=f.ambient,n.specular.value=f.specular,n.shininess.value=f.shininess;else if(f instanceof THREE.MeshDepthMaterial)n.mNear.value=b.near,n.mFar.value=b.far,n.opacity.value=f.opacity;else if(f instanceof THREE.MeshNormalMaterial)n.opacity.value=f.opacity;if(k.receiveShadow&&!f._shadowPass&&n.shadowMatrix){for(e=0;e<ia.length;e++)n.shadowMatrix.value[e]=
ia[e],n.shadowMap.texture[e]=Q.shadowMap[e];n.shadowDarkness.value=Q.shadowMapDarkness;n.shadowBias.value=Q.shadowMapBias}for(var N in n)if(p=h.uniforms[N])if(c=n[N],t=c.type,e=c.value,t=="i")o.uniform1i(p,e);else if(t=="f")o.uniform1f(p,e);else if(t=="v2")o.uniform2f(p,e.x,e.y);else if(t=="v3")o.uniform3f(p,e.x,e.y,e.z);else if(t=="v4")o.uniform4f(p,e.x,e.y,e.z,e.w);else if(t=="c")o.uniform3f(p,e.r,e.g,e.b);else if(t=="fv1")o.uniform1fv(p,e);else if(t=="fv")o.uniform3fv(p,e);else if(t=="v3v"){if(!c._array)c._array=
new Float32Array(3*e.length);t=0;for(w=e.length;t<w;t++)x=t*3,c._array[x]=e[t].x,c._array[x+1]=e[t].y,c._array[x+2]=e[t].z;o.uniform3fv(p,c._array)}else if(t=="m4"){if(!c._array)c._array=new Float32Array(16);e.flattenToArray(c._array);o.uniformMatrix4fv(p,!1,c._array)}else if(t=="m4v"){if(!c._array)c._array=new Float32Array(16*e.length);t=0;for(w=e.length;t<w;t++)e[t].flattenToArrayOffset(c._array,t*16);o.uniformMatrix4fv(p,!1,c._array)}else if(t=="t"){if(o.uniform1i(p,e),p=c.texture)if(p.image instanceof
Array&&p.image.length==6){if(c=p,c.image.length==6)if(c.needsUpdate){if(!c.image.__webglTextureCube)c.image.__webglTextureCube=o.createTexture();o.activeTexture(o.TEXTURE0+e);o.bindTexture(o.TEXTURE_CUBE_MAP,c.image.__webglTextureCube);for(e=0;e<6;e++)o.texImage2D(o.TEXTURE_CUBE_MAP_POSITIVE_X+e,0,o.RGBA,o.RGBA,o.UNSIGNED_BYTE,c.image[e]);I(o.TEXTURE_CUBE_MAP,c,c.image[0]);c.needsUpdate=!1}else o.activeTexture(o.TEXTURE0+e),o.bindTexture(o.TEXTURE_CUBE_MAP,c.image.__webglTextureCube)}else p instanceof
THREE.WebGLRenderTargetCube?(c=p,o.activeTexture(o.TEXTURE0+e),o.bindTexture(o.TEXTURE_CUBE_MAP,c.__webglTexture)):K(p,e)}else if(t=="tv"){if(!c._array){c._array=[];t=0;for(w=c.texture.length;t<w;t++)c._array[t]=e+t}o.uniform1iv(p,c._array);t=0;for(w=c.texture.length;t<w;t++)(p=c.texture[t])&&K(p,c._array[t])}o.uniformMatrix4fv(m.modelViewMatrix,!1,k._modelViewMatrixArray);m.normalMatrix&&o.uniformMatrix3fv(m.normalMatrix,!1,k._normalMatrixArray);(f instanceof THREE.ShaderMaterial||f instanceof THREE.MeshPhongMaterial||
f.envMap)&&m.cameraPosition!==null&&o.uniform3f(m.cameraPosition,b.position.x,b.position.y,b.position.z);(f instanceof THREE.ShaderMaterial||f.envMap||f.skinning||k.receiveShadow)&&m.objectMatrix!==null&&o.uniformMatrix4fv(m.objectMatrix,!1,k._objectMatrixArray);(f instanceof THREE.MeshPhongMaterial||f instanceof THREE.MeshLambertMaterial||f instanceof THREE.ShaderMaterial||f.skinning)&&m.viewMatrix!==null&&o.uniformMatrix4fv(m.viewMatrix,!1,sa);f.skinning&&(o.uniformMatrix4fv(m.cameraInverseMatrix,
!1,sa),o.uniformMatrix4fv(m.boneGlobalMatrices,!1,k.boneMatrices));return h}function f(b,c,f,k,h,m){if(k.opacity!=0){var n,b=e(b,c,f,k,m).attributes;if(!k.morphTargets&&b.position>=0)o.bindBuffer(o.ARRAY_BUFFER,h.__webglVertexBuffer),o.vertexAttribPointer(b.position,3,o.FLOAT,!1,0,0);else if(m.morphTargetBase){c=k.program.attributes;m.morphTargetBase!==-1?(o.bindBuffer(o.ARRAY_BUFFER,h.__webglMorphTargetsBuffers[m.morphTargetBase]),o.vertexAttribPointer(c.position,3,o.FLOAT,!1,0,0)):c.position>=0&&
(o.bindBuffer(o.ARRAY_BUFFER,h.__webglVertexBuffer),o.vertexAttribPointer(c.position,3,o.FLOAT,!1,0,0));if(m.morphTargetForcedOrder.length)for(var f=0,p=m.morphTargetForcedOrder,v=m.morphTargetInfluences;f<k.numSupportedMorphTargets&&f<p.length;)o.bindBuffer(o.ARRAY_BUFFER,h.__webglMorphTargetsBuffers[p[f]]),o.vertexAttribPointer(c["morphTarget"+f],3,o.FLOAT,!1,0,0),m.__webglMorphTargetInfluences[f]=v[p[f]],f++;else{var p=[],t=-1,u=0,v=m.morphTargetInfluences,w,x=v.length,f=0;for(m.morphTargetBase!==
-1&&(p[m.morphTargetBase]=!0);f<k.numSupportedMorphTargets;){for(w=0;w<x;w++)!p[w]&&v[w]>t&&(u=w,t=v[u]);o.bindBuffer(o.ARRAY_BUFFER,h.__webglMorphTargetsBuffers[u]);o.vertexAttribPointer(c["morphTarget"+f],3,o.FLOAT,!1,0,0);m.__webglMorphTargetInfluences[f]=t;p[u]=1;t=-1;f++}}k.program.uniforms.morphTargetInfluences!==null&&o.uniform1fv(k.program.uniforms.morphTargetInfluences,m.__webglMorphTargetInfluences)}if(h.__webglCustomAttributes)for(n in h.__webglCustomAttributes)b[n]>=0&&(c=h.__webglCustomAttributes[n],
o.bindBuffer(o.ARRAY_BUFFER,c.buffer),o.vertexAttribPointer(b[n],c.size,o.FLOAT,!1,0,0));b.color>=0&&(o.bindBuffer(o.ARRAY_BUFFER,h.__webglColorBuffer),o.vertexAttribPointer(b.color,3,o.FLOAT,!1,0,0));b.normal>=0&&(o.bindBuffer(o.ARRAY_BUFFER,h.__webglNormalBuffer),o.vertexAttribPointer(b.normal,3,o.FLOAT,!1,0,0));b.tangent>=0&&(o.bindBuffer(o.ARRAY_BUFFER,h.__webglTangentBuffer),o.vertexAttribPointer(b.tangent,4,o.FLOAT,!1,0,0));b.uv>=0&&(h.__webglUVBuffer?(o.bindBuffer(o.ARRAY_BUFFER,h.__webglUVBuffer),
o.vertexAttribPointer(b.uv,2,o.FLOAT,!1,0,0),o.enableVertexAttribArray(b.uv)):o.disableVertexAttribArray(b.uv));b.uv2>=0&&(h.__webglUV2Buffer?(o.bindBuffer(o.ARRAY_BUFFER,h.__webglUV2Buffer),o.vertexAttribPointer(b.uv2,2,o.FLOAT,!1,0,0),o.enableVertexAttribArray(b.uv2)):o.disableVertexAttribArray(b.uv2));k.skinning&&b.skinVertexA>=0&&b.skinVertexB>=0&&b.skinIndex>=0&&b.skinWeight>=0&&(o.bindBuffer(o.ARRAY_BUFFER,h.__webglSkinVertexABuffer),o.vertexAttribPointer(b.skinVertexA,4,o.FLOAT,!1,0,0),o.bindBuffer(o.ARRAY_BUFFER,
h.__webglSkinVertexBBuffer),o.vertexAttribPointer(b.skinVertexB,4,o.FLOAT,!1,0,0),o.bindBuffer(o.ARRAY_BUFFER,h.__webglSkinIndicesBuffer),o.vertexAttribPointer(b.skinIndex,4,o.FLOAT,!1,0,0),o.bindBuffer(o.ARRAY_BUFFER,h.__webglSkinWeightsBuffer),o.vertexAttribPointer(b.skinWeight,4,o.FLOAT,!1,0,0));m instanceof THREE.Mesh?(k.wireframe?(o.lineWidth(k.wireframeLinewidth),o.bindBuffer(o.ELEMENT_ARRAY_BUFFER,h.__webglLineBuffer),o.drawElements(o.LINES,h.__webglLineCount,o.UNSIGNED_SHORT,0)):(o.bindBuffer(o.ELEMENT_ARRAY_BUFFER,
h.__webglFaceBuffer),o.drawElements(o.TRIANGLES,h.__webglFaceCount,o.UNSIGNED_SHORT,0)),Q.data.vertices+=h.__webglFaceCount,Q.data.faces+=h.__webglFaceCount/3,Q.data.drawCalls++):m instanceof THREE.Line?(m=m.type==THREE.LineStrip?o.LINE_STRIP:o.LINES,o.lineWidth(k.linewidth),o.drawArrays(m,0,h.__webglLineCount),Q.data.drawCalls++):m instanceof THREE.ParticleSystem?(o.drawArrays(o.POINTS,0,h.__webglParticleCount),Q.data.drawCalls++):m instanceof THREE.Ribbon&&(o.drawArrays(o.TRIANGLE_STRIP,0,h.__webglVertexCount),
Q.data.drawCalls++)}}function h(b,e,c){if(!b.__webglVertexBuffer)b.__webglVertexBuffer=o.createBuffer();if(!b.__webglNormalBuffer)b.__webglNormalBuffer=o.createBuffer();b.hasPos&&(o.bindBuffer(o.ARRAY_BUFFER,b.__webglVertexBuffer),o.bufferData(o.ARRAY_BUFFER,b.positionArray,o.DYNAMIC_DRAW),o.enableVertexAttribArray(e.attributes.position),o.vertexAttribPointer(e.attributes.position,3,o.FLOAT,!1,0,0));if(b.hasNormal){o.bindBuffer(o.ARRAY_BUFFER,b.__webglNormalBuffer);if(c==THREE.FlatShading){var f,
h,k,m,n,p,v,t,u,w,x=b.count*3;for(w=0;w<x;w+=9)c=b.normalArray,f=c[w],h=c[w+1],k=c[w+2],m=c[w+3],p=c[w+4],t=c[w+5],n=c[w+6],v=c[w+7],u=c[w+8],f=(f+m+n)/3,h=(h+p+v)/3,k=(k+t+u)/3,c[w]=f,c[w+1]=h,c[w+2]=k,c[w+3]=f,c[w+4]=h,c[w+5]=k,c[w+6]=f,c[w+7]=h,c[w+8]=k}o.bufferData(o.ARRAY_BUFFER,b.normalArray,o.DYNAMIC_DRAW);o.enableVertexAttribArray(e.attributes.normal);o.vertexAttribPointer(e.attributes.normal,3,o.FLOAT,!1,0,0)}o.drawArrays(o.TRIANGLES,0,b.count);b.count=0}function m(b){if(ca!=b.doubleSided)b.doubleSided?
o.disable(o.CULL_FACE):o.enable(o.CULL_FACE),ca=b.doubleSided;if(na!=b.flipSided)b.flipSided?o.frontFace(o.CW):o.frontFace(o.CCW),na=b.flipSided}function k(b){la!=b&&(b?o.enable(o.DEPTH_TEST):o.disable(o.DEPTH_TEST),la=b)}function n(b){ga!=b&&(o.depthMask(b),ga=b)}function t(b,e,c){Z!=b&&(b?o.enable(o.POLYGON_OFFSET_FILL):o.disable(o.POLYGON_OFFSET_FILL),Z=b);if(b&&(V!=e||$!=c))o.polygonOffset(e,c),V=e,$=c}function u(b){fa[0].set(b.n41-b.n11,b.n42-b.n12,b.n43-b.n13,b.n44-b.n14);fa[1].set(b.n41+b.n11,
b.n42+b.n12,b.n43+b.n13,b.n44+b.n14);fa[2].set(b.n41+b.n21,b.n42+b.n22,b.n43+b.n23,b.n44+b.n24);fa[3].set(b.n41-b.n21,b.n42-b.n22,b.n43-b.n23,b.n44-b.n24);fa[4].set(b.n41-b.n31,b.n42-b.n32,b.n43-b.n33,b.n44-b.n34);fa[5].set(b.n41+b.n31,b.n42+b.n32,b.n43+b.n33,b.n44+b.n34);for(var e,b=0;b<6;b++)e=fa[b],e.divideScalar(Math.sqrt(e.x*e.x+e.y*e.y+e.z*e.z))}function w(b){for(var e=b.matrixWorld,c=-b.geometry.boundingSphere.radius*Math.max(b.scale.x,Math.max(b.scale.y,b.scale.z)),f=0;f<6;f++)if(b=fa[f].x*
e.n14+fa[f].y*e.n24+fa[f].z*e.n34+fa[f].w,b<=c)return!1;return!0}function v(b,e){b.list[b.count]=e;b.count+=1}function x(b){var e,c,f=b.object,h=b.opaque,k=b.transparent;k.count=0;b=h.count=0;for(e=f.materials.length;b<e;b++)c=f.materials[b],c.transparent?v(k,c):v(h,c)}function p(b){var e,c,f,h,k=b.object,m=b.buffer,n=b.opaque,o=b.transparent;o.count=0;b=n.count=0;for(f=k.materials.length;b<f;b++)if(e=k.materials[b],e instanceof THREE.MeshFaceMaterial){e=0;for(c=m.materials.length;e<c;e++)(h=m.materials[e])&&
(h.transparent?v(o,h):v(n,h))}else(h=e)&&(h.transparent?v(o,h):v(n,h))}function y(b,e){return e.z-b.z}function z(b,c){var n,p,v,t=0,x,L,y,z,A=b.lights;aa||(aa=new THREE.Camera(Q.shadowCameraFov,c.aspect,Q.shadowCameraNear,Q.shadowCameraFar));n=0;for(p=A.length;n<p;n++)if(v=A[n],v instanceof THREE.SpotLight&&v.castShadow){Q.shadowMap[t]||(Q.shadowMap[t]=new THREE.WebGLRenderTarget(Q.shadowMapWidth,Q.shadowMapHeight,{minFilter:THREE.LinearFilter,magFilter:THREE.LinearFilter,format:THREE.RGBAFormat}));
ia[t]||(ia[t]=new THREE.Matrix4);x=Q.shadowMap[t];L=ia[t];aa.position.copy(v.position);aa.target.position.copy(v.target.position);aa.update(void 0,!0);b.update(void 0,!1,aa);L.set(0.5,0,0,0.5,0,0.5,0,0.5,0,0,0.5,0.5,0,0,0,1);L.multiplySelf(aa.projectionMatrix);L.multiplySelf(aa.matrixWorldInverse);aa.matrixWorldInverse.flattenToArray(sa);aa.projectionMatrix.flattenToArray(ua);ra.multiply(aa.projectionMatrix,aa.matrixWorldInverse);u(ra);Q.initWebGLObjects(b);W(x);o.clearColor(1,1,1,1);Q.clear();o.clearColor(O.r,
O.g,O.b,ha);L=b.__webglObjects.length;v=b.__webglObjectsImmediate.length;for(x=0;x<L;x++)y=b.__webglObjects[x],z=y.object,z.visible&&z.castShadow?!(z instanceof THREE.Mesh)||!z.frustumCulled||w(z)?(z.matrixWorld.flattenToArray(z._objectMatrixArray),C(z,aa,!1),y.render=!0):y.render=!1:y.render=!1;k(!0);J(THREE.NormalBlending);for(x=0;x<L;x++)if(y=b.__webglObjects[x],y.render)z=y.object,buffer=y.buffer,m(z),y=z.customDepthMaterial?z.customDepthMaterial:z.geometry.morphTargets.length?va:ya,f(aa,A,null,
y,buffer,z);for(x=0;x<v;x++)y=b.__webglObjectsImmediate[x],z=y.object,z.visible&&z.castShadow&&(z.matrixAutoUpdate&&z.matrixWorld.flattenToArray(z._objectMatrixArray),C(z,aa,!1),m(z),program=e(aa,A,null,ya,z),z.render(function(b){h(b,program,ya.shading)}));t++}}function A(b,e){var c,f,h;c=Y.attributes;var k=Y.uniforms,m=N/ta,n,p=[],v=ta*0.5,t=N*0.5,u=!0;o.useProgram(Y.program);T=Y.program;la=ja=-1;Ba||(o.enableVertexAttribArray(Y.attributes.position),o.enableVertexAttribArray(Y.attributes.uv),Ba=
!0);o.disable(o.CULL_FACE);o.enable(o.BLEND);o.depthMask(!0);o.bindBuffer(o.ARRAY_BUFFER,Y.vertexBuffer);o.vertexAttribPointer(c.position,2,o.FLOAT,!1,16,0);o.vertexAttribPointer(c.uv,2,o.FLOAT,!1,16,8);o.bindBuffer(o.ELEMENT_ARRAY_BUFFER,Y.elementBuffer);o.uniformMatrix4fv(k.projectionMatrix,!1,ua);o.activeTexture(o.TEXTURE0);o.uniform1i(k.map,0);c=0;for(f=b.__webglSprites.length;c<f;c++)h=b.__webglSprites[c],h.useScreenCoordinates?h.z=-h.position.z:(h._modelViewMatrix.multiplyToArray(e.matrixWorldInverse,
h.matrixWorld,h._modelViewMatrixArray),h.z=-h._modelViewMatrix.n34);b.__webglSprites.sort(y);c=0;for(f=b.__webglSprites.length;c<f;c++)h=b.__webglSprites[c],h.material===void 0&&h.map&&h.map.image&&h.map.image.width&&(h.useScreenCoordinates?(o.uniform1i(k.useScreenCoordinates,1),o.uniform3f(k.screenPosition,(h.position.x-v)/v,(t-h.position.y)/t,Math.max(0,Math.min(1,h.position.z)))):(o.uniform1i(k.useScreenCoordinates,0),o.uniform1i(k.affectedByDistance,h.affectedByDistance?1:0),o.uniformMatrix4fv(k.modelViewMatrix,
!1,h._modelViewMatrixArray)),n=h.map.image.width/(h.scaleByViewport?N:1),p[0]=n*m*h.scale.x,p[1]=n*h.scale.y,o.uniform2f(k.uvScale,h.uvScale.x,h.uvScale.y),o.uniform2f(k.uvOffset,h.uvOffset.x,h.uvOffset.y),o.uniform2f(k.alignment,h.alignment.x,h.alignment.y),o.uniform1f(k.opacity,h.opacity),o.uniform1f(k.rotation,h.rotation),o.uniform2fv(k.scale,p),h.mergeWith3D&&!u?(o.enable(o.DEPTH_TEST),u=!0):!h.mergeWith3D&&u&&(o.disable(o.DEPTH_TEST),u=!1),J(h.blending),K(h.map,0),o.drawElements(o.TRIANGLES,
6,o.UNSIGNED_SHORT,0));o.enable(o.CULL_FACE);o.enable(o.DEPTH_TEST);o.depthMask(ga)}function C(b,e,c){b._modelViewMatrix.multiplyToArray(e.matrixWorldInverse,b.matrixWorld,b._modelViewMatrixArray);c&&THREE.Matrix4.makeInvert3x3(b._modelViewMatrix).transposeIntoArray(b._normalMatrixArray)}function E(b){var e,c,f,h;h=b.__materials;b=0;for(c=h.length;b<c;b++)if(f=h[b],f.attributes)for(e in f.attributes)if(f.attributes[e].needsUpdate)return!0;return!1}function G(b){var e,c,f,h;h=b.__materials;b=0;for(c=
h.length;b<c;b++)if(f=h[b],f.attributes)for(e in f.attributes)f.attributes[e].needsUpdate=!1}function H(b,e){var c;for(c=b.length-1;c>=0;c--)b[c].object==e&&b.splice(c,1)}function M(b){function e(b){var h=[];c=0;for(f=b.length;c<f;c++)b[c]==void 0?h.push("undefined"):h.push(b[c].id);return h.join("_")}var c,f,h,k,m,n,o,p,v={},t=b.morphTargets!==void 0?b.morphTargets.length:0;b.geometryGroups={};h=0;for(k=b.faces.length;h<k;h++)m=b.faces[h],n=m.materials,o=e(n),v[o]==void 0&&(v[o]={hash:o,counter:0}),
p=v[o].hash+"_"+v[o].counter,b.geometryGroups[p]==void 0&&(b.geometryGroups[p]={faces:[],materials:n,vertices:0,numMorphTargets:t}),m=m instanceof THREE.Face3?3:4,b.geometryGroups[p].vertices+m>65535&&(v[o].counter+=1,p=v[o].hash+"_"+v[o].counter,b.geometryGroups[p]==void 0&&(b.geometryGroups[p]={faces:[],materials:n,vertices:0,numMorphTargets:t})),b.geometryGroups[p].faces.push(h),b.geometryGroups[p].vertices+=m;b.geometryGroupsList=[];for(var u in b.geometryGroups)b.geometryGroupsList.push(b.geometryGroups[u])}
function R(b,e,c){b.push({buffer:e,object:c,opaque:{list:[],count:0},transparent:{list:[],count:0}})}function J(b){if(b!=ja){switch(b){case THREE.AdditiveBlending:o.blendEquation(o.FUNC_ADD);o.blendFunc(o.SRC_ALPHA,o.ONE);break;case THREE.SubtractiveBlending:o.blendEquation(o.FUNC_ADD);o.blendFunc(o.ZERO,o.ONE_MINUS_SRC_COLOR);break;case THREE.MultiplyBlending:o.blendEquation(o.FUNC_ADD);o.blendFunc(o.ZERO,o.SRC_COLOR);break;default:o.blendEquationSeparate(o.FUNC_ADD,o.FUNC_ADD),o.blendFuncSeparate(o.SRC_ALPHA,
o.ONE_MINUS_SRC_ALPHA,o.ONE,o.ONE_MINUS_SRC_ALPHA)}ja=b}}function I(b,e,c){(c.width&c.width-1)==0&&(c.height&c.height-1)==0?(o.texParameteri(b,o.TEXTURE_WRAP_S,da(e.wrapS)),o.texParameteri(b,o.TEXTURE_WRAP_T,da(e.wrapT)),o.texParameteri(b,o.TEXTURE_MAG_FILTER,da(e.magFilter)),o.texParameteri(b,o.TEXTURE_MIN_FILTER,da(e.minFilter)),o.generateMipmap(b)):(o.texParameteri(b,o.TEXTURE_WRAP_S,o.CLAMP_TO_EDGE),o.texParameteri(b,o.TEXTURE_WRAP_T,o.CLAMP_TO_EDGE),o.texParameteri(b,o.TEXTURE_MAG_FILTER,U(e.magFilter)),
o.texParameteri(b,o.TEXTURE_MIN_FILTER,U(e.minFilter)))}function K(b,e){if(b.needsUpdate){if(!b.__webglInit)b.__webglInit=!0,b.__webglTexture=o.createTexture();o.activeTexture(o.TEXTURE0+e);o.bindTexture(o.TEXTURE_2D,b.__webglTexture);b instanceof THREE.DataTexture?o.texImage2D(o.TEXTURE_2D,0,da(b.format),b.image.width,b.image.height,0,da(b.format),o.UNSIGNED_BYTE,b.image.data):o.texImage2D(o.TEXTURE_2D,0,o.RGBA,o.RGBA,o.UNSIGNED_BYTE,b.image);I(o.TEXTURE_2D,b,b.image);b.needsUpdate=!1}else o.activeTexture(o.TEXTURE0+
e),o.bindTexture(o.TEXTURE_2D,b.__webglTexture)}function W(b){var e=b instanceof THREE.WebGLRenderTargetCube;if(b&&!b.__webglFramebuffer){if(b.depthBuffer===void 0)b.depthBuffer=!0;if(b.stencilBuffer===void 0)b.stencilBuffer=!0;b.__webglRenderbuffer=o.createRenderbuffer();b.__webglTexture=o.createTexture();if(e){o.bindTexture(o.TEXTURE_CUBE_MAP,b.__webglTexture);I(o.TEXTURE_CUBE_MAP,b,b);b.__webglFramebuffer=[];for(var c=0;c<6;c++)b.__webglFramebuffer[c]=o.createFramebuffer(),o.texImage2D(o.TEXTURE_CUBE_MAP_POSITIVE_X+
c,0,da(b.format),b.width,b.height,0,da(b.format),da(b.type),null)}else b.__webglFramebuffer=o.createFramebuffer(),o.bindTexture(o.TEXTURE_2D,b.__webglTexture),I(o.TEXTURE_2D,b,b),o.texImage2D(o.TEXTURE_2D,0,da(b.format),b.width,b.height,0,da(b.format),da(b.type),null);o.bindRenderbuffer(o.RENDERBUFFER,b.__webglRenderbuffer);if(e)for(c=0;c<6;++c)o.bindFramebuffer(o.FRAMEBUFFER,b.__webglFramebuffer[c]),o.framebufferTexture2D(o.FRAMEBUFFER,o.COLOR_ATTACHMENT0,o.TEXTURE_CUBE_MAP_POSITIVE_X+c,b.__webglTexture,
0);else o.bindFramebuffer(o.FRAMEBUFFER,b.__webglFramebuffer),o.framebufferTexture2D(o.FRAMEBUFFER,o.COLOR_ATTACHMENT0,o.TEXTURE_2D,b.__webglTexture,0);b.depthBuffer&&!b.stencilBuffer?(o.renderbufferStorage(o.RENDERBUFFER,o.DEPTH_COMPONENT16,b.width,b.height),o.framebufferRenderbuffer(o.FRAMEBUFFER,o.DEPTH_ATTACHMENT,o.RENDERBUFFER,b.__webglRenderbuffer)):b.depthBuffer&&b.stencilBuffer?(o.renderbufferStorage(o.RENDERBUFFER,o.DEPTH_STENCIL,b.width,b.height),o.framebufferRenderbuffer(o.FRAMEBUFFER,
o.DEPTH_STENCIL_ATTACHMENT,o.RENDERBUFFER,b.__webglRenderbuffer)):o.renderbufferStorage(o.RENDERBUFFER,o.RGBA4,b.width,b.height);e?o.bindTexture(o.TEXTURE_CUBE_MAP,null):o.bindTexture(o.TEXTURE_2D,null);o.bindRenderbuffer(o.RENDERBUFFER,null);o.bindFramebuffer(o.FRAMEBUFFER,null)}var f,h;b?(e=e?b.__webglFramebuffer[b.activeCubeFace]:b.__webglFramebuffer,c=b.width,b=b.height,h=f=0):(e=null,c=ta,b=N,f=ea,h=ka);e!=ma&&(o.bindFramebuffer(o.FRAMEBUFFER,e),o.viewport(f,h,c,b),ma=e)}function D(b){b instanceof
THREE.WebGLRenderTargetCube?(o.bindTexture(o.TEXTURE_CUBE_MAP,b.__webglTexture),o.generateMipmap(o.TEXTURE_CUBE_MAP),o.bindTexture(o.TEXTURE_CUBE_MAP,null)):(o.bindTexture(o.TEXTURE_2D,b.__webglTexture),o.generateMipmap(o.TEXTURE_2D),o.bindTexture(o.TEXTURE_2D,null))}function S(b,e){var c;b=="fragment"?c=o.createShader(o.FRAGMENT_SHADER):b=="vertex"&&(c=o.createShader(o.VERTEX_SHADER));o.shaderSource(c,e);o.compileShader(c);if(!o.getShaderParameter(c,o.COMPILE_STATUS))return console.error(o.getShaderInfoLog(c)),
console.error(e),null;return c}function U(b){switch(b){case THREE.NearestFilter:case THREE.NearestMipMapNearestFilter:case THREE.NearestMipMapLinearFilter:return o.NEAREST;default:return o.LINEAR}}function da(b){switch(b){case THREE.RepeatWrapping:return o.REPEAT;case THREE.ClampToEdgeWrapping:return o.CLAMP_TO_EDGE;case THREE.MirroredRepeatWrapping:return o.MIRRORED_REPEAT;case THREE.NearestFilter:return o.NEAREST;case THREE.NearestMipMapNearestFilter:return o.NEAREST_MIPMAP_NEAREST;case THREE.NearestMipMapLinearFilter:return o.NEAREST_MIPMAP_LINEAR;
case THREE.LinearFilter:return o.LINEAR;case THREE.LinearMipMapNearestFilter:return o.LINEAR_MIPMAP_NEAREST;case THREE.LinearMipMapLinearFilter:return o.LINEAR_MIPMAP_LINEAR;case THREE.ByteType:return o.BYTE;case THREE.UnsignedByteType:return o.UNSIGNED_BYTE;case THREE.ShortType:return o.SHORT;case THREE.UnsignedShortType:return o.UNSIGNED_SHORT;case THREE.IntType:return o.INT;case THREE.UnsignedShortType:return o.UNSIGNED_INT;case THREE.FloatType:return o.FLOAT;case THREE.AlphaFormat:return o.ALPHA;
case THREE.RGBFormat:return o.RGB;case THREE.RGBAFormat:return o.RGBA;case THREE.LuminanceFormat:return o.LUMINANCE;case THREE.LuminanceAlphaFormat:return o.LUMINANCE_ALPHA}return 0}var Q=this,o,pa=[],T=null,ma=null,ca=null,na=null,ja=null,la=null,ga=null,Z=null,V=null,$=null,ea=0,ka=0,ta=0,N=0,fa=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],ra=new THREE.Matrix4,ua=new Float32Array(16),sa=new Float32Array(16),xa=new THREE.Vector4,Ca=
{ambient:[0,0,0],directional:{length:0,colors:[],positions:[]},point:{length:0,colors:[],positions:[],distances:[]}},b=b||{},za=b.canvas!==void 0?b.canvas:document.createElement("canvas"),Aa=b.stencil!==void 0?b.stencil:!0,Ea=b.preserveDrawingBuffer!==void 0?b.preserveDrawingBuffer:!1,L=b.antialias!==void 0?b.antialias:!1,O=b.clearColor!==void 0?new THREE.Color(b.clearColor):new THREE.Color(0),ha=b.clearAlpha!==void 0?b.clearAlpha:0;_maxLights=b.maxLights!==void 0?b.maxLights:4;this.data={vertices:0,
faces:0,drawCalls:0};this.maxMorphTargets=8;this.domElement=za;this.sortObjects=this.autoClear=!0;this.shadowMapBias=0.0039;this.shadowMapDarkness=0.5;this.shadowMapHeight=this.shadowMapWidth=512;this.shadowCameraNear=1;this.shadowCameraFar=5E3;this.shadowCameraFov=50;this.shadowMap=[];this.shadowMapEnabled=!1;this.shadowMapSoft=!0;var aa,ia=[],b=THREE.ShaderLib.depthRGBA,qa=THREE.UniformsUtils.clone(b.uniforms),ya=new THREE.ShaderMaterial({fragmentShader:b.fragmentShader,vertexShader:b.vertexShader,
uniforms:qa}),va=new THREE.ShaderMaterial({fragmentShader:b.fragmentShader,vertexShader:b.vertexShader,uniforms:qa,morphTargets:!0});ya._shadowPass=!0;va._shadowPass=!0;try{if(!(o=za.getContext("experimental-webgl",{antialias:L,stencil:Aa,preserveDrawingBuffer:Ea})))throw"Error creating WebGL context.";console.log(navigator.userAgent+" | "+o.getParameter(o.VERSION)+" | "+o.getParameter(o.VENDOR)+" | "+o.getParameter(o.RENDERER)+" | "+o.getParameter(o.SHADING_LANGUAGE_VERSION))}catch(oa){console.error(oa)}o.clearColor(0,
0,0,1);o.clearDepth(1);o.clearStencil(0);o.enable(o.DEPTH_TEST);o.depthFunc(o.LEQUAL);o.frontFace(o.CCW);o.cullFace(o.BACK);o.enable(o.CULL_FACE);o.enable(o.BLEND);o.blendEquation(o.FUNC_ADD);o.blendFunc(o.SRC_ALPHA,o.ONE_MINUS_SRC_ALPHA);o.clearColor(O.r,O.g,O.b,ha);this.context=o;var Fa=o.getParameter(o.MAX_VERTEX_TEXTURE_IMAGE_UNITS)>0,Y={};Y.vertices=new Float32Array(16);Y.faces=new Uint16Array(6);i=0;Y.vertices[i++]=-1;Y.vertices[i++]=-1;Y.vertices[i++]=0;Y.vertices[i++]=1;Y.vertices[i++]=1;
Y.vertices[i++]=-1;Y.vertices[i++]=1;Y.vertices[i++]=1;Y.vertices[i++]=1;Y.vertices[i++]=1;Y.vertices[i++]=1;Y.vertices[i++]=0;Y.vertices[i++]=-1;Y.vertices[i++]=1;Y.vertices[i++]=0;i=Y.vertices[i++]=0;Y.faces[i++]=0;Y.faces[i++]=1;Y.faces[i++]=2;Y.faces[i++]=0;Y.faces[i++]=2;Y.faces[i++]=3;Y.vertexBuffer=o.createBuffer();Y.elementBuffer=o.createBuffer();o.bindBuffer(o.ARRAY_BUFFER,Y.vertexBuffer);o.bufferData(o.ARRAY_BUFFER,Y.vertices,o.STATIC_DRAW);o.bindBuffer(o.ELEMENT_ARRAY_BUFFER,Y.elementBuffer);
o.bufferData(o.ELEMENT_ARRAY_BUFFER,Y.faces,o.STATIC_DRAW);Y.program=o.createProgram();o.attachShader(Y.program,S("fragment",THREE.ShaderLib.sprite.fragmentShader));o.attachShader(Y.program,S("vertex",THREE.ShaderLib.sprite.vertexShader));o.linkProgram(Y.program);Y.attributes={};Y.uniforms={};Y.attributes.position=o.getAttribLocation(Y.program,"position");Y.attributes.uv=o.getAttribLocation(Y.program,"uv");Y.uniforms.uvOffset=o.getUniformLocation(Y.program,"uvOffset");Y.uniforms.uvScale=o.getUniformLocation(Y.program,
"uvScale");Y.uniforms.rotation=o.getUniformLocation(Y.program,"rotation");Y.uniforms.scale=o.getUniformLocation(Y.program,"scale");Y.uniforms.alignment=o.getUniformLocation(Y.program,"alignment");Y.uniforms.map=o.getUniformLocation(Y.program,"map");Y.uniforms.opacity=o.getUniformLocation(Y.program,"opacity");Y.uniforms.useScreenCoordinates=o.getUniformLocation(Y.program,"useScreenCoordinates");Y.uniforms.affectedByDistance=o.getUniformLocation(Y.program,"affectedByDistance");Y.uniforms.screenPosition=
o.getUniformLocation(Y.program,"screenPosition");Y.uniforms.modelViewMatrix=o.getUniformLocation(Y.program,"modelViewMatrix");Y.uniforms.projectionMatrix=o.getUniformLocation(Y.program,"projectionMatrix");var Ba=!1;this.setSize=function(b,e){za.width=b;za.height=e;this.setViewport(0,0,za.width,za.height)};this.setViewport=function(b,e,c,f){ea=b;ka=e;ta=c;N=f;o.viewport(ea,ka,ta,N)};this.setScissor=function(b,e,c,f){o.scissor(b,e,c,f)};this.enableScissorTest=function(b){b?o.enable(o.SCISSOR_TEST):
o.disable(o.SCISSOR_TEST)};this.setClearColorHex=function(b,e){O.setHex(b);ha=e;o.clearColor(O.r,O.g,O.b,ha)};this.setClearColor=function(b,e){O.copy(b);ha=e;o.clearColor(O.r,O.g,O.b,ha)};this.getClearColor=function(){return O};this.getClearAlpha=function(){return ha};this.clear=function(){o.clear(o.COLOR_BUFFER_BIT|o.DEPTH_BUFFER_BIT|o.STENCIL_BUFFER_BIT)};this.getContext=function(){return o};this.deallocateObject=function(b){if(b.__webglInit)if(b.__webglInit=!1,delete b._modelViewMatrix,delete b._normalMatrixArray,
delete b._modelViewMatrixArray,delete b._objectMatrixArray,b instanceof THREE.Mesh)for(g in b.geometry.geometryGroups){var e=b.geometry.geometryGroups[g];o.deleteBuffer(e.__webglVertexBuffer);o.deleteBuffer(e.__webglNormalBuffer);o.deleteBuffer(e.__webglTangentBuffer);o.deleteBuffer(e.__webglColorBuffer);o.deleteBuffer(e.__webglUVBuffer);o.deleteBuffer(e.__webglUV2Buffer);o.deleteBuffer(e.__webglSkinVertexABuffer);o.deleteBuffer(e.__webglSkinVertexBBuffer);o.deleteBuffer(e.__webglSkinIndicesBuffer);
o.deleteBuffer(e.__webglSkinWeightsBuffer);o.deleteBuffer(e.__webglFaceBuffer);o.deleteBuffer(e.__webglLineBuffer);if(e.numMorphTargets)for(var c=0,f=e.numMorphTargets;c<f;c++)o.deleteBuffer(e.__webglMorphTargetsBuffers[c])}else if(b instanceof THREE.Ribbon)b=b.geometry,o.deleteBuffer(b.__webglVertexBuffer),o.deleteBuffer(b.__webglColorBuffer);else if(b instanceof THREE.Line)b=b.geometry,o.deleteBuffer(b.__webglVertexBuffer),o.deleteBuffer(b.__webglColorBuffer);else if(b instanceof THREE.ParticleSystem)b=
b.geometry,o.deleteBuffer(b.__webglVertexBuffer),o.deleteBuffer(b.__webglColorBuffer)};this.deallocateTexture=function(b){if(b.__webglInit)b.__webglInit=!1,o.deleteTexture(b.__webglTexture)};this.initMaterial=function(b,e,c,f){var h,k,m;b instanceof THREE.MeshDepthMaterial?m="depth":b instanceof THREE.MeshNormalMaterial?m="normal":b instanceof THREE.MeshBasicMaterial?m="basic":b instanceof THREE.MeshLambertMaterial?m="lambert":b instanceof THREE.MeshPhongMaterial?m="phong":b instanceof THREE.LineBasicMaterial?
m="basic":b instanceof THREE.ParticleBasicMaterial&&(m="particle_basic");if(m){var n=THREE.ShaderLib[m];b.uniforms=THREE.UniformsUtils.clone(n.uniforms);b.vertexShader=n.vertexShader;b.fragmentShader=n.fragmentShader}var p,v,t;p=t=n=0;for(v=e.length;p<v;p++)k=e[p],k instanceof THREE.SpotLight&&t++,k instanceof THREE.DirectionalLight&&t++,k instanceof THREE.PointLight&&n++;n+t<=_maxLights?p=t:(p=Math.ceil(_maxLights*t/(n+t)),n=_maxLights-p);k={directional:p,point:n};n=t=0;for(p=e.length;n<p;n++)v=
e[n],v instanceof THREE.SpotLight&&v.castShadow&&t++;var u=50;if(f!==void 0&&f instanceof THREE.SkinnedMesh)u=f.bones.length;var w;a:{p=b.fragmentShader;v=b.vertexShader;var n=b.uniforms,e=b.attributes,c={map:!!b.map,envMap:!!b.envMap,lightMap:!!b.lightMap,vertexColors:b.vertexColors,fog:c,useFog:b.fog,sizeAttenuation:b.sizeAttenuation,skinning:b.skinning,morphTargets:b.morphTargets,maxMorphTargets:this.maxMorphTargets,maxDirLights:k.directional,maxPointLights:k.point,maxBones:u,shadowMapEnabled:this.shadowMapEnabled&&
f.receiveShadow,shadowMapSoft:this.shadowMapSoft,shadowMapWidth:this.shadowMapWidth,shadowMapHeight:this.shadowMapHeight,maxShadows:t,alphaTest:b.alphaTest},x,f=[];m?f.push(m):(f.push(p),f.push(v));for(x in c)f.push(x),f.push(c[x]);m=f.join();x=0;for(f=pa.length;x<f;x++)if(pa[x].code==m){w=pa[x].program;break a}x=o.createProgram();f=[Fa?"#define VERTEX_TEXTURES":"","#define MAX_DIR_LIGHTS "+c.maxDirLights,"#define MAX_POINT_LIGHTS "+c.maxPointLights,"#define MAX_SHADOWS "+c.maxShadows,"#define MAX_BONES "+
c.maxBones,c.map?"#define USE_MAP":"",c.envMap?"#define USE_ENVMAP":"",c.lightMap?"#define USE_LIGHTMAP":"",c.vertexColors?"#define USE_COLOR":"",c.skinning?"#define USE_SKINNING":"",c.morphTargets?"#define USE_MORPHTARGETS":"",c.shadowMapEnabled?"#define USE_SHADOWMAP":"",c.shadowMapSoft?"#define SHADOWMAP_SOFT":"",c.sizeAttenuation?"#define USE_SIZEATTENUATION":"","uniform mat4 objectMatrix;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform mat4 viewMatrix;\nuniform mat3 normalMatrix;\nuniform vec3 cameraPosition;\nuniform mat4 cameraInverseMatrix;\nattribute vec3 position;\nattribute vec3 normal;\nattribute vec2 uv;\nattribute vec2 uv2;\n#ifdef USE_COLOR\nattribute vec3 color;\n#endif\n#ifdef USE_MORPHTARGETS\nattribute vec3 morphTarget0;\nattribute vec3 morphTarget1;\nattribute vec3 morphTarget2;\nattribute vec3 morphTarget3;\nattribute vec3 morphTarget4;\nattribute vec3 morphTarget5;\nattribute vec3 morphTarget6;\nattribute vec3 morphTarget7;\n#endif\n#ifdef USE_SKINNING\nattribute vec4 skinVertexA;\nattribute vec4 skinVertexB;\nattribute vec4 skinIndex;\nattribute vec4 skinWeight;\n#endif\n"].join("\n");
k=["#ifdef GL_ES\nprecision highp float;\n#endif","#define MAX_DIR_LIGHTS "+c.maxDirLights,"#define MAX_POINT_LIGHTS "+c.maxPointLights,"#define MAX_SHADOWS "+c.maxShadows,c.alphaTest?"#define ALPHATEST "+c.alphaTest:"",c.useFog&&c.fog?"#define USE_FOG":"",c.useFog&&c.fog instanceof THREE.FogExp2?"#define FOG_EXP2":"",c.map?"#define USE_MAP":"",c.envMap?"#define USE_ENVMAP":"",c.lightMap?"#define USE_LIGHTMAP":"",c.vertexColors?"#define USE_COLOR":"",c.shadowMapEnabled?"#define USE_SHADOWMAP":"",
c.shadowMapSoft?"#define SHADOWMAP_SOFT":"",c.shadowMapSoft?"#define SHADOWMAP_WIDTH "+c.shadowMapWidth.toFixed(1):"",c.shadowMapSoft?"#define SHADOWMAP_HEIGHT "+c.shadowMapHeight.toFixed(1):"","uniform mat4 viewMatrix;\nuniform vec3 cameraPosition;\n"].join("\n");o.attachShader(x,S("fragment",k+p));o.attachShader(x,S("vertex",f+v));o.linkProgram(x);o.getProgramParameter(x,o.LINK_STATUS)||console.error("Could not initialise shader\nVALIDATE_STATUS: "+o.getProgramParameter(x,o.VALIDATE_STATUS)+", gl error ["+
o.getError()+"]");x.uniforms={};x.attributes={};var L,f=["viewMatrix","modelViewMatrix","projectionMatrix","normalMatrix","objectMatrix","cameraPosition","cameraInverseMatrix","boneGlobalMatrices","morphTargetInfluences"];for(L in n)f.push(L);L=f;f=0;for(n=L.length;f<n;f++)p=L[f],x.uniforms[p]=o.getUniformLocation(x,p);f=["position","normal","uv","uv2","tangent","color","skinVertexA","skinVertexB","skinIndex","skinWeight"];for(L=0;L<c.maxMorphTargets;L++)f.push("morphTarget"+L);for(w in e)f.push(w);
w=f;L=0;for(e=w.length;L<e;L++)c=w[L],x.attributes[c]=o.getAttribLocation(x,c);pa.push({program:x,code:m});w=x}b.program=w;w=b.program.attributes;w.position>=0&&o.enableVertexAttribArray(w.position);w.color>=0&&o.enableVertexAttribArray(w.color);w.normal>=0&&o.enableVertexAttribArray(w.normal);w.tangent>=0&&o.enableVertexAttribArray(w.tangent);b.skinning&&w.skinVertexA>=0&&w.skinVertexB>=0&&w.skinIndex>=0&&w.skinWeight>=0&&(o.enableVertexAttribArray(w.skinVertexA),o.enableVertexAttribArray(w.skinVertexB),
o.enableVertexAttribArray(w.skinIndex),o.enableVertexAttribArray(w.skinWeight));if(b.attributes)for(h in b.attributes)w[h]!==void 0&&w[h]>=0&&o.enableVertexAttribArray(w[h]);if(b.morphTargets)for(h=b.numSupportedMorphTargets=0;h<this.maxMorphTargets;h++)L="morphTarget"+h,w[L]>=0&&(o.enableVertexAttribArray(w[L]),b.numSupportedMorphTargets++)};this.clearTarget=function(b,e,c,f){W(b);b=0;e&&(b|=o.COLOR_BUFFER_BIT);c&&(b|=o.DEPTH_BUFFER_BIT);f&&(b|=o.STENCIL_BUFFER_BIT);o.clear(b)};this.render=function(b,
c,o,v){var L,ha,O,E,G,H,aa,N,I=b.lights,qa=b.fog;this.shadowMapEnabled&&z(b,c);Q.data.vertices=0;Q.data.faces=0;Q.data.drawCalls=0;c.matrixAutoUpdate&&c.update(void 0,!0);b.update(void 0,!1,c);c.matrixWorldInverse.flattenToArray(sa);c.projectionMatrix.flattenToArray(ua);ra.multiply(c.projectionMatrix,c.matrixWorldInverse);u(ra);this.initWebGLObjects(b);W(o);(this.autoClear||v)&&this.clear();G=b.__webglObjects.length;for(v=0;v<G;v++)if(L=b.__webglObjects[v],aa=L.object,aa.visible)if(!(aa instanceof
THREE.Mesh)||!aa.frustumCulled||w(aa)){if(aa.matrixWorld.flattenToArray(aa._objectMatrixArray),C(aa,c,!0),p(L),L.render=!0,this.sortObjects)L.object.renderDepth?L.z=L.object.renderDepth:(xa.copy(aa.position),ra.multiplyVector3(xa),L.z=xa.z)}else L.render=!1;else L.render=!1;this.sortObjects&&b.__webglObjects.sort(y);H=b.__webglObjectsImmediate.length;for(v=0;v<H;v++)L=b.__webglObjectsImmediate[v],aa=L.object,aa.visible&&(aa.matrixAutoUpdate&&aa.matrixWorld.flattenToArray(aa._objectMatrixArray),C(aa,
c,!0),x(L));if(b.overrideMaterial){k(b.overrideMaterial.depthTest);J(b.overrideMaterial.blending);for(v=0;v<G;v++)if(L=b.__webglObjects[v],L.render)aa=L.object,N=L.buffer,m(aa),f(c,I,qa,b.overrideMaterial,N,aa);for(v=0;v<H;v++)L=b.__webglObjectsImmediate[v],aa=L.object,aa.visible&&(m(aa),ha=e(c,I,qa,b.overrideMaterial,aa),aa.render(function(c){h(c,ha,b.overrideMaterial.shading)}))}else{J(THREE.NormalBlending);for(v=G-1;v>=0;v--)if(L=b.__webglObjects[v],L.render){aa=L.object;N=L.buffer;O=L.opaque;
m(aa);for(L=0;L<O.count;L++)E=O.list[L],k(E.depthTest),n(E.depthWrite),t(E.polygonOffset,E.polygonOffsetFactor,E.polygonOffsetUnits),f(c,I,qa,E,N,aa)}for(v=0;v<H;v++)if(L=b.__webglObjectsImmediate[v],aa=L.object,aa.visible){O=L.opaque;m(aa);for(L=0;L<O.count;L++)E=O.list[L],k(E.depthTest),n(E.depthWrite),t(E.polygonOffset,E.polygonOffsetFactor,E.polygonOffsetUnits),ha=e(c,I,qa,E,aa),aa.render(function(b){h(b,ha,E.shading)})}for(v=0;v<G;v++)if(L=b.__webglObjects[v],L.render){aa=L.object;N=L.buffer;
O=L.transparent;m(aa);for(L=0;L<O.count;L++)E=O.list[L],J(E.blending),k(E.depthTest),n(E.depthWrite),t(E.polygonOffset,E.polygonOffsetFactor,E.polygonOffsetUnits),f(c,I,qa,E,N,aa)}for(v=0;v<H;v++)if(L=b.__webglObjectsImmediate[v],aa=L.object,aa.visible){O=L.transparent;m(aa);for(L=0;L<O.count;L++)E=O.list[L],J(E.blending),k(E.depthTest),n(E.depthWrite),t(E.polygonOffset,E.polygonOffsetFactor,E.polygonOffsetUnits),ha=e(c,I,qa,E,aa),aa.render(function(b){h(b,ha,E.shading)})}}b.__webglSprites.length&&
A(b,c);o&&o.minFilter!==THREE.NearestFilter&&o.minFilter!==THREE.LinearFilter&&D(o)};this.initWebGLObjects=function(b){if(!b.__webglObjects)b.__webglObjects=[],b.__webglObjectsImmediate=[],b.__webglSprites=[];for(;b.__objectsAdded.length;){var e=b.__objectsAdded[0],f=b,h=void 0,k=void 0,m=void 0;if(!e.__webglInit)if(e.__webglInit=!0,e._modelViewMatrix=new THREE.Matrix4,e._normalMatrixArray=new Float32Array(9),e._modelViewMatrixArray=new Float32Array(16),e._objectMatrixArray=new Float32Array(16),e.matrixWorld.flattenToArray(e._objectMatrixArray),
e instanceof THREE.Mesh)for(h in k=e.geometry,k.geometryGroups==void 0&&M(k),k.geometryGroups){m=k.geometryGroups[h];if(!m.__webglVertexBuffer){var n=m;n.__webglVertexBuffer=o.createBuffer();n.__webglNormalBuffer=o.createBuffer();n.__webglTangentBuffer=o.createBuffer();n.__webglColorBuffer=o.createBuffer();n.__webglUVBuffer=o.createBuffer();n.__webglUV2Buffer=o.createBuffer();n.__webglSkinVertexABuffer=o.createBuffer();n.__webglSkinVertexBBuffer=o.createBuffer();n.__webglSkinIndicesBuffer=o.createBuffer();
n.__webglSkinWeightsBuffer=o.createBuffer();n.__webglFaceBuffer=o.createBuffer();n.__webglLineBuffer=o.createBuffer();if(n.numMorphTargets){var v=void 0,p=void 0;n.__webglMorphTargetsBuffers=[];v=0;for(p=n.numMorphTargets;v<p;v++)n.__webglMorphTargetsBuffers.push(o.createBuffer())}for(var n=m,v=e,t=void 0,u=void 0,w=void 0,x=w=void 0,L=void 0,y=void 0,ha=y=p=0,O=w=u=void 0,z=O=u=t=void 0,w=void 0,x=v.geometry,L=x.faces,O=n.faces,t=0,u=O.length;t<u;t++)w=O[t],w=L[w],w instanceof THREE.Face3?(p+=3,
y+=1,ha+=3):w instanceof THREE.Face4&&(p+=4,y+=2,ha+=4);for(var t=n,u=v,A=O=L=void 0,C=void 0,A=void 0,w=[],L=0,O=u.materials.length;L<O;L++)if(A=u.materials[L],A instanceof THREE.MeshFaceMaterial){A=0;for(l=t.materials.length;A<l;A++)(C=t.materials[A])&&w.push(C)}else(C=A)&&w.push(C);t=w;n.__materials=t;a:{L=u=void 0;O=t.length;for(u=0;u<O;u++)if(L=t[u],L.map||L.lightMap||L instanceof THREE.ShaderMaterial){u=!0;break a}u=!1}a:{O=L=void 0;w=t.length;for(L=0;L<w;L++)if(O=t[L],!(O instanceof THREE.MeshBasicMaterial&&
!O.envMap||O instanceof THREE.MeshDepthMaterial)){O=O&&O.shading!=void 0&&O.shading==THREE.SmoothShading?THREE.SmoothShading:THREE.FlatShading;break a}O=!1}a:{w=L=void 0;A=t.length;for(L=0;L<A;L++)if(w=t[L],w.vertexColors){w=w.vertexColors;break a}w=!1}n.__vertexArray=new Float32Array(p*3);if(O)n.__normalArray=new Float32Array(p*3);if(x.hasTangents)n.__tangentArray=new Float32Array(p*4);if(w)n.__colorArray=new Float32Array(p*3);if(u){if(x.faceUvs.length>0||x.faceVertexUvs.length>0)n.__uvArray=new Float32Array(p*
2);if(x.faceUvs.length>1||x.faceVertexUvs.length>1)n.__uv2Array=new Float32Array(p*2)}if(v.geometry.skinWeights.length&&v.geometry.skinIndices.length)n.__skinVertexAArray=new Float32Array(p*4),n.__skinVertexBArray=new Float32Array(p*4),n.__skinIndexArray=new Float32Array(p*4),n.__skinWeightArray=new Float32Array(p*4);n.__faceArray=new Uint16Array(y*3+(v.geometry.edgeFaces?v.geometry.edgeFaces.length*6:0));n.__lineArray=new Uint16Array(ha*2);if(n.numMorphTargets){n.__morphTargetsArrays=[];x=0;for(L=
n.numMorphTargets;x<L;x++)n.__morphTargetsArrays.push(new Float32Array(p*3))}n.__needsSmoothNormals=O==THREE.SmoothShading;n.__uvType=u;n.__vertexColorType=w;n.__normalType=O;n.__webglFaceCount=y*3+(v.geometry.edgeFaces?v.geometry.edgeFaces.length*6:0);n.__webglLineCount=ha*2;x=0;for(L=t.length;x<L;x++)if(u=t[x],u.attributes){if(n.__webglCustomAttributes===void 0)n.__webglCustomAttributes={};for(a in u.attributes){w=u.attributes[a];O={};for(z in w)O[z]=w[z];if(!O.__webglInitialized||O.createUniqueBuffers)O.__webglInitialized=
!0,y=1,O.type==="v2"?y=2:O.type==="v3"?y=3:O.type==="v4"?y=4:O.type==="c"&&(y=3),O.size=y,O.array=new Float32Array(p*y),O.buffer=o.createBuffer(),O.buffer.belongsToAttribute=a,w.needsUpdate=!0,O.__original=w;n.__webglCustomAttributes[a]=O}}n.__inittedArrays=!0;k.__dirtyVertices=!0;k.__dirtyMorphTargets=!0;k.__dirtyElements=!0;k.__dirtyUvs=!0;k.__dirtyNormals=!0;k.__dirtyTangents=!0;k.__dirtyColors=!0}R(f.__webglObjects,m,e)}else if(e instanceof THREE.Ribbon){k=e.geometry;if(!k.__webglVertexBuffer)h=
k,h.__webglVertexBuffer=o.createBuffer(),h.__webglColorBuffer=o.createBuffer(),h=k,m=h.vertices.length,h.__vertexArray=new Float32Array(m*3),h.__colorArray=new Float32Array(m*3),h.__webglVertexCount=m,k.__dirtyVertices=!0,k.__dirtyColors=!0;R(f.__webglObjects,k,e)}else if(e instanceof THREE.Line){k=e.geometry;if(!k.__webglVertexBuffer)h=k,h.__webglVertexBuffer=o.createBuffer(),h.__webglColorBuffer=o.createBuffer(),h=k,m=h.vertices.length,h.__vertexArray=new Float32Array(m*3),h.__colorArray=new Float32Array(m*
3),h.__webglLineCount=m,k.__dirtyVertices=!0,k.__dirtyColors=!0;R(f.__webglObjects,k,e)}else if(e instanceof THREE.ParticleSystem){k=e.geometry;if(!k.__webglVertexBuffer){h=k;h.__webglVertexBuffer=o.createBuffer();h.__webglColorBuffer=o.createBuffer();h=k;m=e;n=h.vertices.length;h.__vertexArray=new Float32Array(n*3);h.__colorArray=new Float32Array(n*3);h.__sortArray=[];h.__webglParticleCount=n;h.__materials=m.materials;z=p=v=void 0;v=0;for(p=m.materials.length;v<p;v++)if(z=m.materials[v],z.attributes){if(h.__webglCustomAttributes===
void 0)h.__webglCustomAttributes={};for(a in z.attributes){originalAttribute=z.attributes[a];attribute={};for(property in originalAttribute)attribute[property]=originalAttribute[property];if(!attribute.__webglInitialized||attribute.createUniqueBuffers)attribute.__webglInitialized=!0,size=1,attribute.type==="v2"?size=2:attribute.type==="v3"?size=3:attribute.type==="v4"?size=4:attribute.type==="c"&&(size=3),attribute.size=size,attribute.array=new Float32Array(n*size),attribute.buffer=o.createBuffer(),
attribute.buffer.belongsToAttribute=a,originalAttribute.needsUpdate=!0,attribute.__original=originalAttribute;h.__webglCustomAttributes[a]=attribute}}k.__dirtyVertices=!0;k.__dirtyColors=!0}R(f.__webglObjects,k,e)}else THREE.MarchingCubes!==void 0&&e instanceof THREE.MarchingCubes?f.__webglObjectsImmediate.push({object:e,opaque:{list:[],count:0},transparent:{list:[],count:0}}):e instanceof THREE.Sprite&&f.__webglSprites.push(e);b.__objectsAdded.splice(0,1)}for(;b.__objectsRemoved.length;){f=b.__objectsRemoved[0];
e=b;if(f instanceof THREE.Mesh||f instanceof THREE.ParticleSystem||f instanceof THREE.Ribbon||f instanceof THREE.Line)H(e.__webglObjects,f);else if(f instanceof THREE.Sprite){e=e.__webglSprites;k=void 0;for(k=e.length-1;k>=0;k--)e[k]==f&&e.splice(k,1)}else f instanceof THREE.MarchingCubes&&H(e.__webglObjectsImmediate,f);b.__objectsRemoved.splice(0,1)}e=0;for(f=b.__webglObjects.length;e<f;e++)if(h=b.__webglObjects[e].object,p=m=k=void 0,h instanceof THREE.Mesh){k=h.geometry;n=0;for(v=k.geometryGroupsList.length;n<
v;n++)if(m=k.geometryGroupsList[n],p=E(m),k.__dirtyVertices||k.__dirtyMorphTargets||k.__dirtyElements||k.__dirtyUvs||k.__dirtyNormals||k.__dirtyColors||k.__dirtyTangents||p)if(p=m,z=o.DYNAMIC_DRAW,y=!k.dynamic,p.__inittedArrays){var aa=x=ha=void 0,N=void 0,I=aa=void 0,qa=void 0,K=void 0,fa=void 0,ia=C=A=w=O=L=u=t=void 0,J=void 0,F=N=fa=N=K=qa=void 0,B=void 0,D=B=F=qa=void 0,Y=void 0,$=D=B=F=aa=aa=I=fa=N=D=B=F=Y=D=B=F=Y=D=B=F=void 0,V=0,ra=0,S=0,ua=0,ya=0,T=0,oa=0,U=0,Q=0,P=0,W=0,D=F=0,D=void 0,ea=
p.__vertexArray,da=p.__uvArray,ja=p.__uv2Array,na=p.__normalArray,Z=p.__tangentArray,ka=p.__colorArray,va=p.__skinVertexAArray,ca=p.__skinVertexBArray,sa=p.__skinIndexArray,ga=p.__skinWeightArray,pa=p.__morphTargetsArrays,la=p.__webglCustomAttributes,B=void 0,ta=p.__faceArray,ma=p.__lineArray,Fa=p.__needsSmoothNormals,u=p.__vertexColorType,t=p.__uvType,L=p.__normalType,xa=h.geometry,za=xa.__dirtyVertices,Ca=xa.__dirtyElements,Ba=xa.__dirtyUvs,Aa=xa.__dirtyNormals,Ea=xa.__dirtyTangents,ab=xa.__dirtyColors,
bb=xa.__dirtyMorphTargets,Oa=xa.vertices,db=p.faces,gb=xa.faces,eb=xa.faceVertexUvs[0],fb=xa.faceVertexUvs[1],Pa=xa.skinVerticesA,Qa=xa.skinVerticesB,Ra=xa.skinIndices,Ha=xa.skinWeights,Ga=xa.morphTargets;if(la)for($ in la)la[$].offset=0,la[$].offsetSrc=0;ha=0;for(x=db.length;ha<x;ha++)if(aa=db[ha],N=gb[aa],eb&&(O=eb[aa]),fb&&(w=fb[aa]),aa=N.vertexNormals,I=N.normal,qa=N.vertexColors,K=N.color,fa=N.vertexTangents,N instanceof THREE.Face3){if(za)A=Oa[N.a].position,C=Oa[N.b].position,ia=Oa[N.c].position,
ea[ra]=A.x,ea[ra+1]=A.y,ea[ra+2]=A.z,ea[ra+3]=C.x,ea[ra+4]=C.y,ea[ra+5]=C.z,ea[ra+6]=ia.x,ea[ra+7]=ia.y,ea[ra+8]=ia.z,ra+=9;if(la)for($ in la)if(B=la[$],B.__original.needsUpdate)F=B.offset,D=B.offsetSrc,B.size===1?(B.boundTo===void 0||B.boundTo==="vertices"?(B.array[F]=B.value[N.a],B.array[F+1]=B.value[N.b],B.array[F+2]=B.value[N.c]):B.boundTo==="faces"?(D=B.value[D],B.array[F]=D,B.array[F+1]=D,B.array[F+2]=D,B.offsetSrc++):B.boundTo==="faceVertices"&&(B.array[F]=B.value[D],B.array[F+1]=B.value[D+
1],B.array[F+2]=B.value[D+2],B.offsetSrc+=3),B.offset+=3):(B.boundTo===void 0||B.boundTo==="vertices"?(A=B.value[N.a],C=B.value[N.b],ia=B.value[N.c]):B.boundTo==="faces"?(ia=C=A=D=B.value[D],B.offsetSrc++):B.boundTo==="faceVertices"&&(A=B.value[D],C=B.value[D+1],ia=B.value[D+2],B.offsetSrc+=3),B.size===2?(B.array[F]=A.x,B.array[F+1]=A.y,B.array[F+2]=C.x,B.array[F+3]=C.y,B.array[F+4]=ia.x,B.array[F+5]=ia.y,B.offset+=6):B.size===3?(B.type==="c"?(B.array[F]=A.r,B.array[F+1]=A.g,B.array[F+2]=A.b,B.array[F+
3]=C.r,B.array[F+4]=C.g,B.array[F+5]=C.b,B.array[F+6]=ia.r,B.array[F+7]=ia.g,B.array[F+8]=ia.b):(B.array[F]=A.x,B.array[F+1]=A.y,B.array[F+2]=A.z,B.array[F+3]=C.x,B.array[F+4]=C.y,B.array[F+5]=C.z,B.array[F+6]=ia.x,B.array[F+7]=ia.y,B.array[F+8]=ia.z),B.offset+=9):(B.array[F]=A.x,B.array[F+1]=A.y,B.array[F+2]=A.z,B.array[F+3]=A.w,B.array[F+4]=C.x,B.array[F+5]=C.y,B.array[F+6]=C.z,B.array[F+7]=C.w,B.array[F+8]=ia.x,B.array[F+9]=ia.y,B.array[F+10]=ia.z,B.array[F+11]=ia.w,B.offset+=12));if(bb){F=0;for(B=
Ga.length;F<B;F++)A=Ga[F].vertices[N.a].position,C=Ga[F].vertices[N.b].position,ia=Ga[F].vertices[N.c].position,D=pa[F],D[W]=A.x,D[W+1]=A.y,D[W+2]=A.z,D[W+3]=C.x,D[W+4]=C.y,D[W+5]=C.z,D[W+6]=ia.x,D[W+7]=ia.y,D[W+8]=ia.z;W+=9}if(Ha.length)F=Ha[N.a],B=Ha[N.b],D=Ha[N.c],ga[P]=F.x,ga[P+1]=F.y,ga[P+2]=F.z,ga[P+3]=F.w,ga[P+4]=B.x,ga[P+5]=B.y,ga[P+6]=B.z,ga[P+7]=B.w,ga[P+8]=D.x,ga[P+9]=D.y,ga[P+10]=D.z,ga[P+11]=D.w,F=Ra[N.a],B=Ra[N.b],D=Ra[N.c],sa[P]=F.x,sa[P+1]=F.y,sa[P+2]=F.z,sa[P+3]=F.w,sa[P+4]=B.x,sa[P+
5]=B.y,sa[P+6]=B.z,sa[P+7]=B.w,sa[P+8]=D.x,sa[P+9]=D.y,sa[P+10]=D.z,sa[P+11]=D.w,F=Pa[N.a],B=Pa[N.b],D=Pa[N.c],va[P]=F.x,va[P+1]=F.y,va[P+2]=F.z,va[P+3]=1,va[P+4]=B.x,va[P+5]=B.y,va[P+6]=B.z,va[P+7]=1,va[P+8]=D.x,va[P+9]=D.y,va[P+10]=D.z,va[P+11]=1,F=Qa[N.a],B=Qa[N.b],D=Qa[N.c],ca[P]=F.x,ca[P+1]=F.y,ca[P+2]=F.z,ca[P+3]=1,ca[P+4]=B.x,ca[P+5]=B.y,ca[P+6]=B.z,ca[P+7]=1,ca[P+8]=D.x,ca[P+9]=D.y,ca[P+10]=D.z,ca[P+11]=1,P+=12;if(ab&&u)qa.length==3&&u==THREE.VertexColors?(N=qa[0],F=qa[1],B=qa[2]):B=F=N=K,
ka[Q]=N.r,ka[Q+1]=N.g,ka[Q+2]=N.b,ka[Q+3]=F.r,ka[Q+4]=F.g,ka[Q+5]=F.b,ka[Q+6]=B.r,ka[Q+7]=B.g,ka[Q+8]=B.b,Q+=9;if(Ea&&xa.hasTangents)qa=fa[0],K=fa[1],N=fa[2],Z[oa]=qa.x,Z[oa+1]=qa.y,Z[oa+2]=qa.z,Z[oa+3]=qa.w,Z[oa+4]=K.x,Z[oa+5]=K.y,Z[oa+6]=K.z,Z[oa+7]=K.w,Z[oa+8]=N.x,Z[oa+9]=N.y,Z[oa+10]=N.z,Z[oa+11]=N.w,oa+=12;if(Aa&&L)if(aa.length==3&&Fa)for(fa=0;fa<3;fa++)I=aa[fa],na[T]=I.x,na[T+1]=I.y,na[T+2]=I.z,T+=3;else for(fa=0;fa<3;fa++)na[T]=I.x,na[T+1]=I.y,na[T+2]=I.z,T+=3;if(Ba&&O!==void 0&&t)for(fa=0;fa<
3;fa++)aa=O[fa],da[S]=aa.u,da[S+1]=aa.v,S+=2;if(Ba&&w!==void 0&&t)for(fa=0;fa<3;fa++)aa=w[fa],ja[ua]=aa.u,ja[ua+1]=aa.v,ua+=2;Ca&&(ta[ya]=V,ta[ya+1]=V+1,ta[ya+2]=V+2,ya+=3,ma[U]=V,ma[U+1]=V+1,ma[U+2]=V,ma[U+3]=V+2,ma[U+4]=V+1,ma[U+5]=V+2,U+=6,V+=3)}else if(N instanceof THREE.Face4){if(za)A=Oa[N.a].position,C=Oa[N.b].position,ia=Oa[N.c].position,J=Oa[N.d].position,ea[ra]=A.x,ea[ra+1]=A.y,ea[ra+2]=A.z,ea[ra+3]=C.x,ea[ra+4]=C.y,ea[ra+5]=C.z,ea[ra+6]=ia.x,ea[ra+7]=ia.y,ea[ra+8]=ia.z,ea[ra+9]=J.x,ea[ra+
10]=J.y,ea[ra+11]=J.z,ra+=12;if(la)for($ in la)if(B=la[$],B.__original.needsUpdate)F=B.offset,D=B.offsetSrc,B.size===1?(B.boundTo===void 0||B.boundTo==="vertices"?(B.array[F]=B.value[N.a],B.array[F+1]=B.value[N.b],B.array[F+2]=B.value[N.c],B.array[F+3]=B.value[N.d]):B.boundTo==="faces"?(D=B.value[D],B.array[F]=D,B.array[F+1]=D,B.array[F+2]=D,B.array[F+3]=D,B.offsetSrc++):B.boundTo==="faceVertices"&&(B.array[F]=B.value[D],B.array[F+1]=B.value[D+1],B.array[F+2]=B.value[D+2],B.array[F+3]=B.value[D+3],
B.offsetSrc+=4),B.offset+=4):(B.boundTo===void 0||B.boundTo==="vertices"?(A=B.value[N.a],C=B.value[N.b],ia=B.value[N.c],J=B.value[N.d]):B.boundTo==="faces"?(J=ia=C=A=D=B.value[D],B.offsetSrc++):B.boundTo==="faceVertices"&&(A=B.value[D],C=B.value[D+1],ia=B.value[D+2],J=B.value[D+3],B.offsetSrc+=4),B.size===2?(B.array[F]=A.x,B.array[F+1]=A.y,B.array[F+2]=C.x,B.array[F+3]=C.y,B.array[F+4]=ia.x,B.array[F+5]=ia.y,B.array[F+6]=J.x,B.array[F+7]=J.y,B.offset+=8):B.size===3?(B.type==="c"?(B.array[F]=A.r,B.array[F+
1]=A.g,B.array[F+2]=A.b,B.array[F+3]=C.r,B.array[F+4]=C.g,B.array[F+5]=C.b,B.array[F+6]=ia.r,B.array[F+7]=ia.g,B.array[F+8]=ia.b,B.array[F+9]=J.r,B.array[F+10]=J.g,B.array[F+11]=J.b):(B.array[F]=A.x,B.array[F+1]=A.y,B.array[F+2]=A.z,B.array[F+3]=C.x,B.array[F+4]=C.y,B.array[F+5]=C.z,B.array[F+6]=ia.x,B.array[F+7]=ia.y,B.array[F+8]=ia.z,B.array[F+9]=J.x,B.array[F+10]=J.y,B.array[F+11]=J.z),B.offset+=12):(B.array[F]=A.x,B.array[F+1]=A.y,B.array[F+2]=A.z,B.array[F+3]=A.w,B.array[F+4]=C.x,B.array[F+5]=
C.y,B.array[F+6]=C.z,B.array[F+7]=C.w,B.array[F+8]=ia.x,B.array[F+9]=ia.y,B.array[F+10]=ia.z,B.array[F+11]=ia.w,B.array[F+12]=J.x,B.array[F+13]=J.y,B.array[F+14]=J.z,B.array[F+15]=J.w,B.offset+=16));if(bb){F=0;for(B=Ga.length;F<B;F++)A=Ga[F].vertices[N.a].position,C=Ga[F].vertices[N.b].position,ia=Ga[F].vertices[N.c].position,J=Ga[F].vertices[N.d].position,D=pa[F],D[W]=A.x,D[W+1]=A.y,D[W+2]=A.z,D[W+3]=C.x,D[W+4]=C.y,D[W+5]=C.z,D[W+6]=ia.x,D[W+7]=ia.y,D[W+8]=ia.z,D[W+9]=J.x,D[W+10]=J.y,D[W+11]=J.z;
W+=12}if(Ha.length)F=Ha[N.a],B=Ha[N.b],D=Ha[N.c],Y=Ha[N.d],ga[P]=F.x,ga[P+1]=F.y,ga[P+2]=F.z,ga[P+3]=F.w,ga[P+4]=B.x,ga[P+5]=B.y,ga[P+6]=B.z,ga[P+7]=B.w,ga[P+8]=D.x,ga[P+9]=D.y,ga[P+10]=D.z,ga[P+11]=D.w,ga[P+12]=Y.x,ga[P+13]=Y.y,ga[P+14]=Y.z,ga[P+15]=Y.w,F=Ra[N.a],B=Ra[N.b],D=Ra[N.c],Y=Ra[N.d],sa[P]=F.x,sa[P+1]=F.y,sa[P+2]=F.z,sa[P+3]=F.w,sa[P+4]=B.x,sa[P+5]=B.y,sa[P+6]=B.z,sa[P+7]=B.w,sa[P+8]=D.x,sa[P+9]=D.y,sa[P+10]=D.z,sa[P+11]=D.w,sa[P+12]=Y.x,sa[P+13]=Y.y,sa[P+14]=Y.z,sa[P+15]=Y.w,F=Pa[N.a],
B=Pa[N.b],D=Pa[N.c],Y=Pa[N.d],va[P]=F.x,va[P+1]=F.y,va[P+2]=F.z,va[P+3]=1,va[P+4]=B.x,va[P+5]=B.y,va[P+6]=B.z,va[P+7]=1,va[P+8]=D.x,va[P+9]=D.y,va[P+10]=D.z,va[P+11]=1,va[P+12]=Y.x,va[P+13]=Y.y,va[P+14]=Y.z,va[P+15]=1,F=Qa[N.a],B=Qa[N.b],D=Qa[N.c],N=Qa[N.d],ca[P]=F.x,ca[P+1]=F.y,ca[P+2]=F.z,ca[P+3]=1,ca[P+4]=B.x,ca[P+5]=B.y,ca[P+6]=B.z,ca[P+7]=1,ca[P+8]=D.x,ca[P+9]=D.y,ca[P+10]=D.z,ca[P+11]=1,ca[P+12]=N.x,ca[P+13]=N.y,ca[P+14]=N.z,ca[P+15]=1,P+=16;if(ab&&u)qa.length==4&&u==THREE.VertexColors?(N=qa[0],
F=qa[1],B=qa[2],qa=qa[3]):qa=B=F=N=K,ka[Q]=N.r,ka[Q+1]=N.g,ka[Q+2]=N.b,ka[Q+3]=F.r,ka[Q+4]=F.g,ka[Q+5]=F.b,ka[Q+6]=B.r,ka[Q+7]=B.g,ka[Q+8]=B.b,ka[Q+9]=qa.r,ka[Q+10]=qa.g,ka[Q+11]=qa.b,Q+=12;if(Ea&&xa.hasTangents)qa=fa[0],K=fa[1],N=fa[2],fa=fa[3],Z[oa]=qa.x,Z[oa+1]=qa.y,Z[oa+2]=qa.z,Z[oa+3]=qa.w,Z[oa+4]=K.x,Z[oa+5]=K.y,Z[oa+6]=K.z,Z[oa+7]=K.w,Z[oa+8]=N.x,Z[oa+9]=N.y,Z[oa+10]=N.z,Z[oa+11]=N.w,Z[oa+12]=fa.x,Z[oa+13]=fa.y,Z[oa+14]=fa.z,Z[oa+15]=fa.w,oa+=16;if(Aa&&L)if(aa.length==4&&Fa)for(fa=0;fa<4;fa++)I=
aa[fa],na[T]=I.x,na[T+1]=I.y,na[T+2]=I.z,T+=3;else for(fa=0;fa<4;fa++)na[T]=I.x,na[T+1]=I.y,na[T+2]=I.z,T+=3;if(Ba&&O!==void 0&&t)for(fa=0;fa<4;fa++)aa=O[fa],da[S]=aa.u,da[S+1]=aa.v,S+=2;if(Ba&&w!==void 0&&t)for(fa=0;fa<4;fa++)aa=w[fa],ja[ua]=aa.u,ja[ua+1]=aa.v,ua+=2;Ca&&(ta[ya]=V,ta[ya+1]=V+1,ta[ya+2]=V+3,ta[ya+3]=V+1,ta[ya+4]=V+2,ta[ya+5]=V+3,ya+=6,ma[U]=V,ma[U+1]=V+1,ma[U+2]=V,ma[U+3]=V+3,ma[U+4]=V+1,ma[U+5]=V+2,ma[U+6]=V+2,ma[U+7]=V+3,U+=8,V+=4)}za&&(o.bindBuffer(o.ARRAY_BUFFER,p.__webglVertexBuffer),
o.bufferData(o.ARRAY_BUFFER,ea,z));if(la)for($ in la)B=la[$],B.__original.needsUpdate&&(o.bindBuffer(o.ARRAY_BUFFER,B.buffer),o.bufferData(o.ARRAY_BUFFER,B.array,z));if(bb){F=0;for(B=Ga.length;F<B;F++)o.bindBuffer(o.ARRAY_BUFFER,p.__webglMorphTargetsBuffers[F]),o.bufferData(o.ARRAY_BUFFER,pa[F],z)}ab&&Q>0&&(o.bindBuffer(o.ARRAY_BUFFER,p.__webglColorBuffer),o.bufferData(o.ARRAY_BUFFER,ka,z));Aa&&(o.bindBuffer(o.ARRAY_BUFFER,p.__webglNormalBuffer),o.bufferData(o.ARRAY_BUFFER,na,z));Ea&&xa.hasTangents&&
(o.bindBuffer(o.ARRAY_BUFFER,p.__webglTangentBuffer),o.bufferData(o.ARRAY_BUFFER,Z,z));Ba&&S>0&&(o.bindBuffer(o.ARRAY_BUFFER,p.__webglUVBuffer),o.bufferData(o.ARRAY_BUFFER,da,z));Ba&&ua>0&&(o.bindBuffer(o.ARRAY_BUFFER,p.__webglUV2Buffer),o.bufferData(o.ARRAY_BUFFER,ja,z));Ca&&(o.bindBuffer(o.ELEMENT_ARRAY_BUFFER,p.__webglFaceBuffer),o.bufferData(o.ELEMENT_ARRAY_BUFFER,ta,z),o.bindBuffer(o.ELEMENT_ARRAY_BUFFER,p.__webglLineBuffer),o.bufferData(o.ELEMENT_ARRAY_BUFFER,ma,z));P>0&&(o.bindBuffer(o.ARRAY_BUFFER,
p.__webglSkinVertexABuffer),o.bufferData(o.ARRAY_BUFFER,va,z),o.bindBuffer(o.ARRAY_BUFFER,p.__webglSkinVertexBBuffer),o.bufferData(o.ARRAY_BUFFER,ca,z),o.bindBuffer(o.ARRAY_BUFFER,p.__webglSkinIndicesBuffer),o.bufferData(o.ARRAY_BUFFER,sa,z),o.bindBuffer(o.ARRAY_BUFFER,p.__webglSkinWeightsBuffer),o.bufferData(o.ARRAY_BUFFER,ga,z));y&&(delete p.__inittedArrays,delete p.__colorArray,delete p.__normalArray,delete p.__tangentArray,delete p.__uvArray,delete p.__uv2Array,delete p.__faceArray,delete p.__vertexArray,
delete p.__lineArray,delete p.__skinVertexAArray,delete p.__skinVertexBArray,delete p.__skinIndexArray,delete p.__skinWeightArray)}k.__dirtyVertices=!1;k.__dirtyMorphTargets=!1;k.__dirtyElements=!1;k.__dirtyUvs=!1;k.__dirtyNormals=!1;k.__dirtyTangents=!1;k.__dirtyColors=!1;G(m)}else if(h instanceof THREE.Ribbon){k=h.geometry;if(k.__dirtyVertices||k.__dirtyColors){h=k;m=o.DYNAMIC_DRAW;n=ha=y=y=void 0;x=h.vertices;v=h.colors;t=x.length;p=v.length;u=h.__vertexArray;z=h.__colorArray;L=h.__dirtyColors;
if(h.__dirtyVertices){for(y=0;y<t;y++)ha=x[y].position,n=y*3,u[n]=ha.x,u[n+1]=ha.y,u[n+2]=ha.z;o.bindBuffer(o.ARRAY_BUFFER,h.__webglVertexBuffer);o.bufferData(o.ARRAY_BUFFER,u,m)}if(L){for(y=0;y<p;y++)color=v[y],n=y*3,z[n]=color.r,z[n+1]=color.g,z[n+2]=color.b;o.bindBuffer(o.ARRAY_BUFFER,h.__webglColorBuffer);o.bufferData(o.ARRAY_BUFFER,z,m)}}k.__dirtyVertices=!1;k.__dirtyColors=!1}else if(h instanceof THREE.Line){k=h.geometry;if(k.__dirtyVertices||k.__dirtyColors){h=k;m=o.DYNAMIC_DRAW;n=ha=y=y=void 0;
x=h.vertices;v=h.colors;t=x.length;p=v.length;u=h.__vertexArray;z=h.__colorArray;L=h.__dirtyColors;if(h.__dirtyVertices){for(y=0;y<t;y++)ha=x[y].position,n=y*3,u[n]=ha.x,u[n+1]=ha.y,u[n+2]=ha.z;o.bindBuffer(o.ARRAY_BUFFER,h.__webglVertexBuffer);o.bufferData(o.ARRAY_BUFFER,u,m)}if(L){for(y=0;y<p;y++)color=v[y],n=y*3,z[n]=color.r,z[n+1]=color.g,z[n+2]=color.b;o.bindBuffer(o.ARRAY_BUFFER,h.__webglColorBuffer);o.bufferData(o.ARRAY_BUFFER,z,m)}}k.__dirtyVertices=!1;k.__dirtyColors=!1}else if(h instanceof
THREE.ParticleSystem)k=h.geometry,p=E(k),(k.__dirtyVertices||k.__dirtyColors||h.sortParticles||p)&&c(k,o.DYNAMIC_DRAW,h),k.__dirtyVertices=!1,k.__dirtyColors=!1,G(k)};this.setFaceCulling=function(b,e){b?(!e||e=="ccw"?o.frontFace(o.CCW):o.frontFace(o.CW),b=="back"?o.cullFace(o.BACK):b=="front"?o.cullFace(o.FRONT):o.cullFace(o.FRONT_AND_BACK),o.enable(o.CULL_FACE)):o.disable(o.CULL_FACE)};this.supportsVertexTextures=function(){return Fa}};
THREE.WebGLRenderTarget=function(b,c,e){this.width=b;this.height=c;e=e||{};this.wrapS=e.wrapS!==void 0?e.wrapS:THREE.ClampToEdgeWrapping;this.wrapT=e.wrapT!==void 0?e.wrapT:THREE.ClampToEdgeWrapping;this.magFilter=e.magFilter!==void 0?e.magFilter:THREE.LinearFilter;this.minFilter=e.minFilter!==void 0?e.minFilter:THREE.LinearMipMapLinearFilter;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.format=e.format!==void 0?e.format:THREE.RGBAFormat;this.type=e.type!==void 0?e.type:
THREE.UnsignedByteType;this.depthBuffer=e.depthBuffer!==void 0?e.depthBuffer:!0;this.stencilBuffer=e.stencilBuffer!==void 0?e.stencilBuffer:!0};
THREE.WebGLRenderTarget.prototype.clone=function(){var b=new THREE.WebGLRenderTarget(this.width,this.height);b.wrapS=this.wrapS;b.wrapT=this.wrapT;b.magFilter=this.magFilter;b.minFilter=this.minFilter;b.offset.copy(this.offset);b.repeat.copy(this.repeat);b.format=this.format;b.type=this.type;b.depthBuffer=this.depthBuffer;b.stencilBuffer=this.stencilBuffer;return b};THREE.WebGLRenderTargetCube=function(b,c,e){THREE.WebGLRenderTarget.call(this,b,c,e);this.activeCubeFace=0};
THREE.WebGLRenderTargetCube.prototype=new THREE.WebGLRenderTarget;THREE.WebGLRenderTargetCube.prototype.constructor=THREE.WebGLRenderTargetCube;THREE.RenderableVertex=function(){this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.visible=!0};THREE.RenderableVertex.prototype.copy=function(b){this.positionWorld.copy(b.positionWorld);this.positionScreen.copy(b.positionScreen)};
THREE.RenderableFace3=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[[]];this.z=null};
THREE.RenderableFace4=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.v4=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[[]];this.z=null};
THREE.RenderableObject=function(){this.z=this.object=null};THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.materials=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.materials=null};
THREE.ColorUtils={adjustHSV:function(b,c,e,f){var h=THREE.ColorUtils.__hsv;THREE.ColorUtils.rgbToHsv(b,h);h.h=THREE.ColorUtils.clamp(h.h+c,0,1);h.s=THREE.ColorUtils.clamp(h.s+e,0,1);h.v=THREE.ColorUtils.clamp(h.v+f,0,1);b.setHSV(h.h,h.s,h.v)},rgbToHsv:function(b,c){var e=b.r,f=b.g,h=b.b,m=Math.max(Math.max(e,f),h),k=Math.min(Math.min(e,f),h);if(k==m)k=e=0;else{var n=m-k,k=n/m,e=e==m?(f-h)/n:f==m?2+(h-e)/n:4+(e-f)/n;e/=6;e<0&&(e+=1);e>1&&(e-=1)}c===void 0&&(c={h:0,s:0,v:0});c.h=e;c.s=k;c.v=m;return c},
clamp:function(b,c,e){return b<c?c:b>e?e:b}};THREE.ColorUtils.__hsv={h:0,s:0,v:0};
THREE.GeometryUtils={merge:function(b,c){var e,f,h=b.vertices.length,m=c instanceof THREE.Mesh?c.geometry:c,k=b.vertices,n=m.vertices,t=b.faces,u=m.faces,w=b.faceVertexUvs[0],m=m.faceVertexUvs[0];if(c instanceof THREE.Mesh)c.matrixAutoUpdate&&c.updateMatrix(),e=c.matrix,f=new THREE.Matrix4,f.extractRotation(e,c.scale);for(var v=0,x=n.length;v<x;v++){var p=new THREE.Vertex(n[v].position.clone());e&&e.multiplyVector3(p.position);k.push(p)}v=0;for(x=u.length;v<x;v++){var p=u[v],y,z,A=p.vertexNormals,
C=p.vertexColors;p instanceof THREE.Face3?y=new THREE.Face3(p.a+h,p.b+h,p.c+h):p instanceof THREE.Face4&&(y=new THREE.Face4(p.a+h,p.b+h,p.c+h,p.d+h));y.normal.copy(p.normal);f&&f.multiplyVector3(y.normal);k=0;for(n=A.length;k<n;k++)z=A[k].clone(),f&&f.multiplyVector3(z),y.vertexNormals.push(z);y.color.copy(p.color);k=0;for(n=C.length;k<n;k++)z=C[k],y.vertexColors.push(z.clone());y.materials=p.materials.slice();y.centroid.copy(p.centroid);e&&e.multiplyVector3(y.centroid);t.push(y)}v=0;for(x=m.length;v<
x;v++){e=m[v];f=[];k=0;for(n=e.length;k<n;k++)f.push(new THREE.UV(e[k].u,e[k].v));w.push(f)}},clone:function(b){var c=new THREE.Geometry,e,f=b.vertices,h=b.faces,m=b.faceVertexUvs[0],b=0;for(e=f.length;b<e;b++){var k=new THREE.Vertex(f[b].position.clone());c.vertices.push(k)}b=0;for(e=h.length;b<e;b++){var n=h[b],t,u,w=n.vertexNormals,v=n.vertexColors;n instanceof THREE.Face3?t=new THREE.Face3(n.a,n.b,n.c):n instanceof THREE.Face4&&(t=new THREE.Face4(n.a,n.b,n.c,n.d));t.normal.copy(n.normal);f=0;
for(k=w.length;f<k;f++)u=w[f],t.vertexNormals.push(u.clone());t.color.copy(n.color);f=0;for(k=v.length;f<k;f++)u=v[f],t.vertexColors.push(u.clone());t.materials=n.materials.slice();t.centroid.copy(n.centroid);c.faces.push(t)}b=0;for(e=m.length;b<e;b++){h=m[b];t=[];f=0;for(k=h.length;f<k;f++)t.push(new THREE.UV(h[f].u,h[f].v));c.faceVertexUvs[0].push(t)}return c},randomPointInTriangle:function(b,c,e){var f,h,m,k=new THREE.Vector3,n=THREE.GeometryUtils.__v1;f=THREE.GeometryUtils.random();h=THREE.GeometryUtils.random();
f+h>1&&(f=1-f,h=1-h);m=1-f-h;k.copy(b);k.multiplyScalar(f);n.copy(c);n.multiplyScalar(h);k.addSelf(n);n.copy(e);n.multiplyScalar(m);k.addSelf(n);return k},randomPointInFace:function(b,c,e){var f,h,m;if(b instanceof THREE.Face3)return f=c.vertices[b.a].position,h=c.vertices[b.b].position,m=c.vertices[b.c].position,THREE.GeometryUtils.randomPointInTriangle(f,h,m);else if(b instanceof THREE.Face4){f=c.vertices[b.a].position;h=c.vertices[b.b].position;m=c.vertices[b.c].position;var c=c.vertices[b.d].position,
k;e?b._area1&&b._area2?(e=b._area1,k=b._area2):(e=THREE.GeometryUtils.triangleArea(f,h,c),k=THREE.GeometryUtils.triangleArea(h,m,c),b._area1=e,b._area2=k):(e=THREE.GeometryUtils.triangleArea(f,h,c),k=THREE.GeometryUtils.triangleArea(h,m,c));return THREE.GeometryUtils.random()*(e+k)<e?THREE.GeometryUtils.randomPointInTriangle(f,h,c):THREE.GeometryUtils.randomPointInTriangle(h,m,c)}},randomPointsInGeometry:function(b,c){function e(b){function e(c,f){if(f<c)return c;var h=c+Math.floor((f-c)/2);return u[h]>
b?e(c,h-1):u[h]<b?e(h+1,f):h}return e(0,u.length-1)}var f,h,m=b.faces,k=b.vertices,n=m.length,t=0,u=[],w,v,x,p;for(h=0;h<n;h++){f=m[h];if(f instanceof THREE.Face3)w=k[f.a].position,v=k[f.b].position,x=k[f.c].position,f._area=THREE.GeometryUtils.triangleArea(w,v,x);else if(f instanceof THREE.Face4)w=k[f.a].position,v=k[f.b].position,x=k[f.c].position,p=k[f.d].position,f._area1=THREE.GeometryUtils.triangleArea(w,v,p),f._area2=THREE.GeometryUtils.triangleArea(v,x,p),f._area=f._area1+f._area2;t+=f._area;
u[h]=t}f=[];k={};for(h=0;h<c;h++)n=THREE.GeometryUtils.random()*t,n=e(n),f[h]=THREE.GeometryUtils.randomPointInFace(m[n],b,!0),k[n]?k[n]+=1:k[n]=1;return f},triangleArea:function(b,c,e){var f,h=THREE.GeometryUtils.__v1;h.sub(b,c);f=h.length();h.sub(b,e);b=h.length();h.sub(c,e);e=h.length();c=0.5*(f+b+e);return Math.sqrt(c*(c-f)*(c-b)*(c-e))},random16:function(){return(65280*Math.random()+255*Math.random())/65535},center:function(b){b.computeBoundingBox();var c=new THREE.Matrix4;c.setTranslation(-0.5*
(b.boundingBox.x[1]+b.boundingBox.x[0]),-0.5*(b.boundingBox.y[1]+b.boundingBox.y[0]),-0.5*(b.boundingBox.z[1]+b.boundingBox.z[0]));b.applyMatrix(c);b.computeBoundingBox()}};THREE.GeometryUtils.random=THREE.GeometryUtils.random16;THREE.GeometryUtils.__v1=new THREE.Vector3;
THREE.ImageUtils={loadTexture:function(b,c,e){var f=new Image,h=new THREE.Texture(f,c);f.onload=function(){h.needsUpdate=!0;e&&e(this)};f.crossOrigin="";f.src=b;return h},loadTextureCube:function(b,c,e){var f,h=[],m=new THREE.Texture(h,c),c=h.loadCount=0;for(f=b.length;c<f;++c)h[c]=new Image,h[c].onload=function(){h.loadCount+=1;if(h.loadCount==6)m.needsUpdate=!0;e&&e(this)},h[c].crossOrigin="",h[c].src=b[c];return m},getNormalMap:function(b,c){var e=function(b){var e=Math.sqrt(b[0]*b[0]+b[1]*b[1]+
b[2]*b[2]);return[b[0]/e,b[1]/e,b[2]/e]};c|=1;var f=b.width,h=b.height,m=document.createElement("canvas");m.width=f;m.height=h;var k=m.getContext("2d");k.drawImage(b,0,0);for(var n=k.getImageData(0,0,f,h).data,t=k.createImageData(f,h),u=t.data,w=0;w<f;w++)for(var v=1;v<h;v++){var x=v-1<0?h-1:v-1,p=(v+1)%h,y=w-1<0?f-1:w-1,z=(w+1)%f,A=[],C=[0,0,n[(v*f+w)*4]/255*c];A.push([-1,0,n[(v*f+y)*4]/255*c]);A.push([-1,-1,n[(x*f+y)*4]/255*c]);A.push([0,-1,n[(x*f+w)*4]/255*c]);A.push([1,-1,n[(x*f+z)*4]/255*c]);
A.push([1,0,n[(v*f+z)*4]/255*c]);A.push([1,1,n[(p*f+z)*4]/255*c]);A.push([0,1,n[(p*f+w)*4]/255*c]);A.push([-1,1,n[(p*f+y)*4]/255*c]);x=[];y=A.length;for(p=0;p<y;p++){var z=A[p],E=A[(p+1)%y],z=[z[0]-C[0],z[1]-C[1],z[2]-C[2]],E=[E[0]-C[0],E[1]-C[1],E[2]-C[2]];x.push(e([z[1]*E[2]-z[2]*E[1],z[2]*E[0]-z[0]*E[2],z[0]*E[1]-z[1]*E[0]]))}A=[0,0,0];for(p=0;p<x.length;p++)A[0]+=x[p][0],A[1]+=x[p][1],A[2]+=x[p][2];A[0]/=x.length;A[1]/=x.length;A[2]/=x.length;C=(v*f+w)*4;u[C]=(A[0]+1)/2*255|0;u[C+1]=(A[1]+0.5)*
255|0;u[C+2]=A[2]*255|0;u[C+3]=255}k.putImageData(t,0,0);return m}};THREE.SceneUtils={showHierarchy:function(b,c){THREE.SceneUtils.traverseHierarchy(b,function(b){b.visible=c})},traverseHierarchy:function(b,c){var e,f,h=b.children.length;for(f=0;f<h;f++)e=b.children[f],c(e),THREE.SceneUtils.traverseHierarchy(e,c)}};
if(THREE.WebGLRenderer)THREE.ShaderUtils={lib:{fresnel:{uniforms:{mRefractionRatio:{type:"f",value:1.02},mFresnelBias:{type:"f",value:0.1},mFresnelPower:{type:"f",value:2},mFresnelScale:{type:"f",value:1},tCube:{type:"t",value:1,texture:null}},fragmentShader:"uniform samplerCube tCube;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 reflectedColor = textureCube( tCube, vec3( -vReflect.x, vReflect.yz ) );\nvec4 refractedColor = vec4( 1.0, 1.0, 1.0, 1.0 );\nrefractedColor.r = textureCube( tCube, vec3( -vRefract[0].x, vRefract[0].yz ) ).r;\nrefractedColor.g = textureCube( tCube, vec3( -vRefract[1].x, vRefract[1].yz ) ).g;\nrefractedColor.b = textureCube( tCube, vec3( -vRefract[2].x, vRefract[2].yz ) ).b;\nrefractedColor.a = 1.0;\ngl_FragColor = mix( refractedColor, reflectedColor, clamp( vReflectionFactor, 0.0, 1.0 ) );\n}",
vertexShader:"uniform float mRefractionRatio;\nuniform float mFresnelBias;\nuniform float mFresnelScale;\nuniform float mFresnelPower;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = normalize ( mat3( objectMatrix[0].xyz, objectMatrix[1].xyz, objectMatrix[2].xyz ) * normal );\nvec3 I = mPosition.xyz - cameraPosition;\nvReflect = reflect( I, nWorld );\nvRefract[0] = refract( normalize( I ), nWorld, mRefractionRatio );\nvRefract[1] = refract( normalize( I ), nWorld, mRefractionRatio * 0.99 );\nvRefract[2] = refract( normalize( I ), nWorld, mRefractionRatio * 0.98 );\nvReflectionFactor = mFresnelBias + mFresnelScale * pow( 1.0 + dot( normalize( I ), nWorld ), mFresnelPower );\ngl_Position = projectionMatrix * mvPosition;\n}"},
normal:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.fog,THREE.UniformsLib.lights,{enableAO:{type:"i",value:0},enableDiffuse:{type:"i",value:0},enableSpecular:{type:"i",value:0},tDiffuse:{type:"t",value:0,texture:null},tNormal:{type:"t",value:2,texture:null},tSpecular:{type:"t",value:3,texture:null},tAO:{type:"t",value:4,texture:null},uNormalScale:{type:"f",value:1},tDisplacement:{type:"t",value:5,texture:null},uDisplacementBias:{type:"f",value:0},uDisplacementScale:{type:"f",value:1},uDiffuseColor:{type:"c",
value:new THREE.Color(15658734)},uSpecularColor:{type:"c",value:new THREE.Color(1118481)},uAmbientColor:{type:"c",value:new THREE.Color(328965)},uShininess:{type:"f",value:30},uOpacity:{type:"f",value:1}}]),fragmentShader:["uniform vec3 uAmbientColor;\nuniform vec3 uDiffuseColor;\nuniform vec3 uSpecularColor;\nuniform float uShininess;\nuniform float uOpacity;\nuniform bool enableDiffuse;\nuniform bool enableSpecular;\nuniform bool enableAO;\nuniform sampler2D tDiffuse;\nuniform sampler2D tNormal;\nuniform sampler2D tSpecular;\nuniform sampler2D tAO;\nuniform float uNormalScale;\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nuniform vec3 ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\nvarying vec3 vViewPosition;",
THREE.ShaderChunk.fog_pars_fragment,"void main() {\ngl_FragColor = vec4( 1.0 );\nvec4 mColor = vec4( uDiffuseColor, uOpacity );\nvec4 mSpecular = vec4( uSpecularColor, uOpacity );\nvec3 specularTex = vec3( 1.0 );\nvec3 normalTex = texture2D( tNormal, vUv ).xyz * 2.0 - 1.0;\nnormalTex.xy *= uNormalScale;\nnormalTex = normalize( normalTex );\nif( enableDiffuse )\ngl_FragColor = gl_FragColor * texture2D( tDiffuse, vUv );\nif( enableAO )\ngl_FragColor = gl_FragColor * texture2D( tAO, vUv );\nif( enableSpecular )\nspecularTex = texture2D( tSpecular, vUv ).xyz;\nmat3 tsb = mat3( vTangent, vBinormal, vNormal );\nvec3 finalNormal = tsb * normalTex;\nvec3 normal = normalize( finalNormal );\nvec3 viewPosition = normalize( vViewPosition );\n#if MAX_POINT_LIGHTS > 0\nvec4 pointTotal = vec4( vec3( 0.0 ), 1.0 );\nfor ( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\nvec3 pointVector = normalize( vPointLight[ i ].xyz );\nvec3 pointHalfVector = normalize( vPointLight[ i ].xyz + viewPosition );\nfloat pointDistance = vPointLight[ i ].w;\nfloat pointDotNormalHalf = dot( normal, pointHalfVector );\nfloat pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );\nfloat pointSpecularWeight = 0.0;\nif ( pointDotNormalHalf >= 0.0 )\npointSpecularWeight = specularTex.r * pow( pointDotNormalHalf, uShininess );\npointTotal  += pointDistance * vec4( pointLightColor[ i ], 1.0 ) * ( mColor * pointDiffuseWeight + mSpecular * pointSpecularWeight * pointDiffuseWeight );\n}\n#endif\n#if MAX_DIR_LIGHTS > 0\nvec4 dirTotal = vec4( vec3( 0.0 ), 1.0 );\nfor( int i = 0; i < MAX_DIR_LIGHTS; i++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nvec3 dirHalfVector = normalize( lDirection.xyz + viewPosition );\nfloat dirDotNormalHalf = dot( normal, dirHalfVector );\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\nfloat dirSpecularWeight = 0.0;\nif ( dirDotNormalHalf >= 0.0 )\ndirSpecularWeight = specularTex.r * pow( dirDotNormalHalf, uShininess );\ndirTotal  += vec4( directionalLightColor[ i ], 1.0 ) * ( mColor * dirDiffuseWeight + mSpecular * dirSpecularWeight * dirDiffuseWeight );\n}\n#endif\nvec4 totalLight = vec4( ambientLightColor * uAmbientColor, uOpacity );\n#if MAX_DIR_LIGHTS > 0\ntotalLight += dirTotal;\n#endif\n#if MAX_POINT_LIGHTS > 0\ntotalLight += pointTotal;\n#endif\ngl_FragColor = gl_FragColor * totalLight;",
THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:"attribute vec4 tangent;\n#ifdef VERTEX_TEXTURES\nuniform sampler2D tDisplacement;\nuniform float uDisplacementScale;\nuniform float uDisplacementBias;\n#endif\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\nuniform float pointLightDistance[ MAX_POINT_LIGHTS ];\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\nvarying vec3 vViewPosition;\nvoid main() {\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvViewPosition = -mvPosition.xyz;\nvNormal = normalize( normalMatrix * normal );\nvTangent = normalize( normalMatrix * tangent.xyz );\nvBinormal = cross( vNormal, vTangent ) * tangent.w;\nvBinormal = normalize( vBinormal );\nvUv = uv;\n#if MAX_POINT_LIGHTS > 0\nfor( int i = 0; i < MAX_POINT_LIGHTS; i++ ) {\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 lVector = lPosition.xyz - mvPosition.xyz;\nfloat lDistance = 1.0;\nif ( pointLightDistance[ i ] > 0.0 )\nlDistance = 1.0 - min( ( length( lVector ) / pointLightDistance[ i ] ), 1.0 );\nlVector = normalize( lVector );\nvPointLight[ i ] = vec4( lVector, lDistance );\n}\n#endif\n#ifdef VERTEX_TEXTURES\nvec3 dv = texture2D( tDisplacement, uv ).xyz;\nfloat df = uDisplacementScale * dv.x + uDisplacementBias;\nvec4 displacedPosition = vec4( vNormal.xyz * df, 0.0 ) + mvPosition;\ngl_Position = projectionMatrix * displacedPosition;\n#else\ngl_Position = projectionMatrix * mvPosition;\n#endif\n}"},
cube:{uniforms:{tCube:{type:"t",value:1,texture:null}},vertexShader:"varying vec3 vViewPosition;\nvoid main() {\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvViewPosition = cameraPosition - mPosition.xyz;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"uniform samplerCube tCube;\nvarying vec3 vViewPosition;\nvoid main() {\nvec3 wPos = cameraPosition - vViewPosition;\ngl_FragColor = textureCube( tCube, vec3( - wPos.x, wPos.yz ) );\n}"}}};
THREE.Curve=function(){};THREE.Curve.prototype.getPoint=function(){console.log("Warning, getPoint() not implemented!");return null};THREE.Curve.prototype.getPointAt=function(b){return this.getPoint(this.getUtoTmapping(b))};THREE.Curve.prototype.getPoints=function(b){b||(b=5);var c,e=[];for(c=0;c<=b;c++)e.push(this.getPoint(c/b));return e};THREE.Curve.prototype.getSpacedPoints=function(b){b||(b=5);var c,e=[];for(c=0;c<=b;c++)e.push(this.getPointAt(c/b));return e};
THREE.Curve.prototype.getLength=function(){var b=this.getLengths();return b[b.length-1]};THREE.Curve.prototype.getLengths=function(b){b||(b=200);if(this.cacheArcLengths&&this.cacheArcLengths.length==b+1)return this.cacheArcLengths;var c=[],e,f=this.getPoint(0),h,m=0;c.push(0);for(h=1;h<=b;h++)e=this.getPoint(h/b),m+=e.distanceTo(f),c.push(m),f=e;return this.cacheArcLengths=c};
THREE.Curve.prototype.getUtoTmapping=function(b,c){var e=this.getLengths(),f=0,h=e.length,m;m=c?c:b*e[h-1];time=Date.now();for(var k=0,n=h-1,t;k<=n;)if(f=Math.floor(k+(n-k)/2),t=e[f]-m,t<0)k=f+1;else if(t>0)n=f-1;else{n=f;break}f=n;if(e[f]==m)return f/(h-1);k=e[f];return e=(f+(m-k)/(e[f+1]-k))/(h-1)};THREE.Curve.prototype.getNormalVector=function(b){b=this.getTangent(b);return new THREE.Vector2(-b.y,b.x)};
THREE.Curve.prototype.getTangent=function(b){var c=b-1.0E-4;b+=1.0E-4;c<0&&(c=0);b>1&&(b=1);var c=this.getPoint(c),b=this.getPoint(b),e=new THREE.Vector2;e.sub(b,c);return e.unit()};THREE.LineCurve=function(b,c){b instanceof THREE.Vector2?(this.v1=b,this.v2=c):THREE.LineCurve.oldConstructor.apply(this,arguments)};THREE.LineCurve.oldConstructor=function(b,c,e,f){this.constructor(new THREE.Vector2(b,c),new THREE.Vector2(e,f))};THREE.LineCurve.prototype=new THREE.Curve;
THREE.LineCurve.prototype.constructor=THREE.LineCurve;THREE.LineCurve.prototype.getPoint=function(b){var c=new THREE.Vector2;c.sub(this.v2,this.v1);c.multiplyScalar(b).addSelf(this.v1);return c};THREE.LineCurve.prototype.getPointAt=function(b){return this.getPoint(b)};THREE.LineCurve.prototype.getTangent=function(){var b=new THREE.Vector2;b.sub(this.v2,this.v1);b.normalize();return b};
THREE.QuadraticBezierCurve=function(b,c,e){if(!(c instanceof THREE.Vector2))var f=Array.prototype.slice.call(arguments),b=new THREE.Vector2(f[0],f[1]),c=new THREE.Vector2(f[2],f[3]),e=new THREE.Vector2(f[4],f[5]);this.v0=b;this.v1=c;this.v2=e};THREE.QuadraticBezierCurve.prototype=new THREE.Curve;THREE.QuadraticBezierCurve.prototype.constructor=THREE.QuadraticBezierCurve;
THREE.QuadraticBezierCurve.prototype.getPoint=function(b){var c;c=THREE.Shape.Utils.b2(b,this.v0.x,this.v1.x,this.v2.x);b=THREE.Shape.Utils.b2(b,this.v0.y,this.v1.y,this.v2.y);return new THREE.Vector2(c,b)};THREE.QuadraticBezierCurve.prototype.getTangent=function(b){var c;c=THREE.Curve.Utils.tangentQuadraticBezier(b,this.v0.x,this.v1.x,this.v2.x);b=THREE.Curve.Utils.tangentQuadraticBezier(b,this.v0.y,this.v1.y,this.v2.y);c=new THREE.Vector2(c,b);c.normalize();return c};
THREE.CubicBezierCurve=function(b,c,e,f){if(!(c instanceof THREE.Vector2))var h=Array.prototype.slice.call(arguments),b=new THREE.Vector2(h[0],h[1]),c=new THREE.Vector2(h[2],h[3]),e=new THREE.Vector2(h[4],h[5]),f=new THREE.Vector2(h[6],h[7]);this.v0=b;this.v1=c;this.v2=e;this.v3=f};THREE.CubicBezierCurve.prototype=new THREE.Curve;THREE.CubicBezierCurve.prototype.constructor=THREE.CubicBezierCurve;
THREE.CubicBezierCurve.prototype.getPoint=function(b){var c;c=THREE.Shape.Utils.b3(b,this.v0.x,this.v1.x,this.v2.x,this.v3.x);b=THREE.Shape.Utils.b3(b,this.v0.y,this.v1.y,this.v2.y,this.v3.y);return new THREE.Vector2(c,b)};THREE.CubicBezierCurve.prototype.getTangent=function(b){var c;c=THREE.Curve.Utils.tangentCubicBezier(b,this.v0.x,this.v1.x,this.v2.x,this.v3.x);b=THREE.Curve.Utils.tangentCubicBezier(b,this.v0.y,this.v1.y,this.v2.y,this.v3.y);c=new THREE.Vector2(c,b);c.normalize();return c};
THREE.SplineCurve=function(b){this.points=b};THREE.SplineCurve.prototype=new THREE.Curve;THREE.SplineCurve.prototype.constructor=THREE.SplineCurve;
THREE.SplineCurve.prototype.getPoint=function(b){var c=new THREE.Vector2,e=[],f=this.points,h;h=(f.length-1)*b;b=Math.floor(h);h-=b;e[0]=b==0?b:b-1;e[1]=b;e[2]=b>f.length-2?b:b+1;e[3]=b>f.length-3?b:b+2;c.x=THREE.Curve.Utils.interpolate(f[e[0]].x,f[e[1]].x,f[e[2]].x,f[e[3]].x,h);c.y=THREE.Curve.Utils.interpolate(f[e[0]].y,f[e[1]].y,f[e[2]].y,f[e[3]].y,h);return c};THREE.ArcCurve=function(b,c,e,f,h,m){this.aX=b;this.aY=c;this.aRadius=e;this.aStartAngle=f;this.aEndAngle=h;this.aClockwise=m};
THREE.ArcCurve.prototype=new THREE.Curve;THREE.ArcCurve.prototype.constructor=THREE.ArcCurve;THREE.ArcCurve.prototype.getPoint=function(b){var c=this.aEndAngle-this.aStartAngle;this.aClockwise||(b=1-b);b=this.aStartAngle+b*c;return new THREE.Vector2(this.aX+this.aRadius*Math.cos(b),this.aY+this.aRadius*Math.sin(b))};
THREE.Curve.Utils={tangentQuadraticBezier:function(b,c,e,f){return 2*(1-b)*(e-c)+2*b*(f-e)},tangentCubicBezier:function(b,c,e,f,h){return-3*c*(1-b)*(1-b)+3*e*(1-b)*(1-b)-6*b*e*(1-b)+6*b*f*(1-b)-3*b*b*f+3*b*b*h},tangentSpline:function(b){return 6*b*b-6*b+(3*b*b-4*b+1)+(-6*b*b+6*b)+(3*b*b-2*b)},interpolate:function(b,c,e,f,h){var b=(e-b)*0.5,f=(f-c)*0.5,m=h*h;return(2*c-2*e+b+f)*h*m+(-3*c+3*e-2*b-f)*m+b*h+c}};
THREE.Curve.create=function(b,c){b.prototype=new THREE.Curve;b.prototype.constructor=b;b.prototype.getPoint=c;return b};THREE.LineCurve3=THREE.Curve.create(function(b,c){this.v1=b;this.v2=c},function(b){var c=new THREE.Vector3;c.sub(v2,v1);c.multiplyScalar(b);c.addSelf(this.v1);return c});
THREE.QuadraticBezierCurve3=THREE.Curve.create(function(b,c,e){this.v0=b;this.v1=c;this.v2=e},function(b){var c,e;c=THREE.Shape.Utils.b2(b,this.v0.x,this.v1.x,this.v2.x);e=THREE.Shape.Utils.b2(b,this.v0.y,this.v1.y,this.v2.y);b=THREE.Shape.Utils.b2(b,this.v0.z,this.v1.z,this.v2.z);return new THREE.Vector3(c,e,b)});THREE.CurvePath=function(){this.curves=[];this.bends=[]};THREE.CurvePath.prototype=new THREE.Curve;THREE.CurvePath.prototype.constructor=THREE.CurvePath;THREE.CurvePath.prototype.add=function(b){this.curves.push(b)};
THREE.CurvePath.prototype.checkConnection=function(){};THREE.CurvePath.prototype.closePath=function(){};THREE.CurvePath.prototype.getPoint=function(b){for(var c=b*this.getLength(),e=this.getCurveLengths(),b=0;b<e.length;){if(e[b]>=c)return c=e[b]-c,b=this.curves[b],c=1-c/b.getLength(),b.getPointAt(c);b++}return null};THREE.CurvePath.prototype.getLength=function(){var b=this.getCurveLengths();return b[b.length-1]};
THREE.CurvePath.prototype.getCurveLengths=function(){if(this.cacheLengths&&this.cacheLengths.length==this.curves.length)return this.cacheLengths;var b=[],c=0,e,f=this.curves.length;for(e=0;e<f;e++)c+=this.curves[e].getLength(),b.push(c);return this.cacheLengths=b};
THREE.CurvePath.prototype.getBoundingBox=function(){var b=this.getPoints(),c,e,f,h;c=e=Number.NEGATIVE_INFINITY;f=h=Number.POSITIVE_INFINITY;var m,k,n,t;t=new THREE.Vector2;k=0;for(n=b.length;k<n;k++){m=b[k];if(m.x>c)c=m.x;else if(m.x<f)f=m.x;if(m.y>e)e=m.y;else if(m.y<e)h=m.y;t.addSelf(m.x,m.y)}return{minX:f,minY:h,maxX:c,maxY:e,centroid:t.divideScalar(n)}};THREE.CurvePath.prototype.createPointsGeometry=function(b){return this.createGeometry(this.getPoints(b,!0))};
THREE.CurvePath.prototype.createSpacedPointsGeometry=function(b){return this.createGeometry(this.getSpacedPoints(b,!0))};THREE.CurvePath.prototype.createGeometry=function(b){for(var c=new THREE.Geometry,e=0;e<b.length;e++)c.vertices.push(new THREE.Vertex(new THREE.Vector3(b[e].x,b[e].y,0)));return c};THREE.CurvePath.prototype.addWrapPath=function(b){this.bends.push(b)};
THREE.CurvePath.prototype.getTransformedPoints=function(b,c){var e=this.getPoints(b),f,h;if(!c)c=this.bends;f=0;for(h=c.length;f<h;f++)e=this.getWrapPoints(e,c[f]);return e};THREE.CurvePath.prototype.getTransformedSpacedPoints=function(b,c){var e=this.getSpacedPoints(b),f,h;if(!c)c=this.bends;f=0;for(h=c.length;f<h;f++)e=this.getWrapPoints(e,c[f]);return e};
THREE.CurvePath.prototype.getWrapPoints=function(b,c){var e=this.getBoundingBox(),f,h,m,k,n,t;f=0;for(h=b.length;f<h;f++)m=b[f],k=m.x,n=m.y,t=k/e.maxX,t=c.getUtoTmapping(t,k),k=c.getPoint(t),n=c.getNormalVector(t).multiplyScalar(n),m.x=k.x+n.x,m.y=k.y+n.y;return b};THREE.Path=function(b){THREE.CurvePath.call(this);this.actions=[];b&&this.fromPoints(b)};THREE.Path.prototype=new THREE.CurvePath;THREE.Path.prototype.constructor=THREE.Path;
THREE.PathActions={MOVE_TO:"moveTo",LINE_TO:"lineTo",QUADRATIC_CURVE_TO:"quadraticCurveTo",BEZIER_CURVE_TO:"bezierCurveTo",CSPLINE_THRU:"splineThru",ARC:"arc"};THREE.Path.prototype.fromPoints=function(b){this.moveTo(b[0].x,b[0].y);var c,e=b.length;for(c=1;c<e;c++)this.lineTo(b[c].x,b[c].y)};THREE.Path.prototype.moveTo=function(){var b=Array.prototype.slice.call(arguments);this.actions.push({action:THREE.PathActions.MOVE_TO,args:b})};
THREE.Path.prototype.lineTo=function(b,c){var e=Array.prototype.slice.call(arguments),f=this.actions[this.actions.length-1].args;this.curves.push(new THREE.LineCurve(new THREE.Vector2(f[f.length-2],f[f.length-1]),new THREE.Vector2(b,c)));this.actions.push({action:THREE.PathActions.LINE_TO,args:e})};
THREE.Path.prototype.quadraticCurveTo=function(b,c,e,f){var h=Array.prototype.slice.call(arguments),m=this.actions[this.actions.length-1].args;this.curves.push(new THREE.QuadraticBezierCurve(new THREE.Vector2(m[m.length-2],m[m.length-1]),new THREE.Vector2(b,c),new THREE.Vector2(e,f)));this.actions.push({action:THREE.PathActions.QUADRATIC_CURVE_TO,args:h})};
THREE.Path.prototype.bezierCurveTo=function(b,c,e,f,h,m){var k=Array.prototype.slice.call(arguments),n=this.actions[this.actions.length-1].args;this.curves.push(new THREE.CubicBezierCurve(new THREE.Vector2(n[n.length-2],n[n.length-1]),new THREE.Vector2(b,c),new THREE.Vector2(e,f),new THREE.Vector2(h,m)));this.actions.push({action:THREE.PathActions.BEZIER_CURVE_TO,args:k})};
THREE.Path.prototype.splineThru=function(b){var c=Array.prototype.slice.call(arguments),e=this.actions[this.actions.length-1].args,e=[new THREE.Vector2(e[e.length-2],e[e.length-1])],e=e.concat(b);this.curves.push(new THREE.SplineCurve(e));this.actions.push({action:THREE.PathActions.CSPLINE_THRU,args:c})};THREE.Path.prototype.arc=function(b,c,e,f,h,m){var k=Array.prototype.slice.call(arguments);this.curves.push(new THREE.ArcCurve(b,c,e,f,h,m));this.actions.push({action:THREE.PathActions.ARC,args:k})};
THREE.Path.prototype.getSpacedPoints=function(b){b||(b=40);for(var c=[],e=0;e<b;e++)c.push(this.getPoint(e/b));return c};
THREE.Path.prototype.getPoints=function(b,c){var b=b||12,e=[],f,h,m,k,n,t,u,w,v,x,p,y,z;f=0;for(h=this.actions.length;f<h;f++)switch(m=this.actions[f],k=m.action,m=m.args,k){case THREE.PathActions.LINE_TO:e.push(new THREE.Vector2(m[0],m[1]));break;case THREE.PathActions.QUADRATIC_CURVE_TO:n=m[2];t=m[3];v=m[0];x=m[1];e.length>0?(k=e[e.length-1],p=k.x,y=k.y):(k=this.actions[f-1].args,p=k[k.length-2],y=k[k.length-1]);for(k=1;k<=b;k++)z=k/b,m=THREE.Shape.Utils.b2(z,p,v,n),z=THREE.Shape.Utils.b2(z,y,x,
t),e.push(new THREE.Vector2(m,z));break;case THREE.PathActions.BEZIER_CURVE_TO:n=m[4];t=m[5];v=m[0];x=m[1];u=m[2];w=m[3];e.length>0?(k=e[e.length-1],p=k.x,y=k.y):(k=this.actions[f-1].args,p=k[k.length-2],y=k[k.length-1]);for(k=1;k<=b;k++)z=k/b,m=THREE.Shape.Utils.b3(z,p,v,u,n),z=THREE.Shape.Utils.b3(z,y,x,w,t),e.push(new THREE.Vector2(m,z));break;case THREE.PathActions.CSPLINE_THRU:k=this.actions[f-1].args;k=[new THREE.Vector2(k[k.length-2],k[k.length-1])];z=b*m[0].length;k=k.concat(m[0]);m=new THREE.SplineCurve(k);
for(k=1;k<=z;k++)e.push(m.getPointAt(k/z));break;case THREE.PathActions.ARC:k=this.actions[f-1].args;n=m[0];t=m[1];u=m[2];v=m[3];z=m[4];x=!!m[5];w=k[k.length-2];p=k[k.length-1];k.length==0&&(w=p=0);y=z-v;var A=b*2;for(k=1;k<=A;k++)z=k/A,x||(z=1-z),z=v+z*y,m=w+n+u*Math.cos(z),z=p+t+u*Math.sin(z),e.push(new THREE.Vector2(m,z))}c&&e.push(e[0]);return e};THREE.Path.prototype.transform=function(b,c){this.getBoundingBox();return this.getWrapPoints(this.getPoints(c),b)};
THREE.Path.prototype.nltransform=function(b,c,e,f,h,m){var k=this.getPoints(),n,t,u,w,v;n=0;for(t=k.length;n<t;n++)u=k[n],w=u.x,v=u.y,u.x=b*w+c*v+e,u.y=f*v+h*w+m;return k};
THREE.Path.prototype.debug=function(b){var c=this.getBoundingBox();b||(b=document.createElement("canvas"),b.setAttribute("width",c.maxX+100),b.setAttribute("height",c.maxY+100),document.body.appendChild(b));c=b.getContext("2d");c.fillStyle="white";c.fillRect(0,0,b.width,b.height);c.strokeStyle="black";c.beginPath();var e,f,h,b=0;for(e=this.actions.length;b<e;b++)f=this.actions[b],h=f.args,f=f.action,f!=THREE.PathActions.CSPLINE_THRU&&c[f].apply(c,h);c.stroke();c.closePath();c.strokeStyle="red";f=
this.getPoints();b=0;for(e=f.length;b<e;b++)h=f[b],c.beginPath(),c.arc(h.x,h.y,1.5,0,Math.PI*2,!1),c.stroke(),c.closePath()};
THREE.Path.prototype.toShapes=function(){var b,c,e,f,h=[],m=new THREE.Path;b=0;for(c=this.actions.length;b<c;b++)e=this.actions[b],f=e.args,e=e.action,e==THREE.PathActions.MOVE_TO&&m.actions.length!=0&&(h.push(m),m=new THREE.Path),m[e].apply(m,f);m.actions.length!=0&&h.push(m);if(h.length==0)return[];var k,m=[];if(THREE.Shape.Utils.isClockWise(h[0].getPoints())){b=0;for(c=h.length;b<c;b++)f=h[b],THREE.Shape.Utils.isClockWise(f.getPoints())?(k&&m.push(k),k=new THREE.Shape,k.actions=f.actions,k.curves=
f.curves):k.holes.push(f);m.push(k)}else{k=new THREE.Shape;b=0;for(c=h.length;b<c;b++)f=h[b],THREE.Shape.Utils.isClockWise(f.getPoints())?(k.actions=f.actions,k.curves=f.curves,m.push(k),k=new THREE.Shape):k.holes.push(f)}return m};THREE.Shape=function(){THREE.Path.apply(this,arguments);this.holes=[]};THREE.Shape.prototype=new THREE.Path;THREE.Shape.prototype.constructor=THREE.Path;THREE.Shape.prototype.extrude=function(b){return new THREE.ExtrudeGeometry(this,b)};
THREE.Shape.prototype.getPointsHoles=function(b){var c,e=this.holes.length,f=[];for(c=0;c<e;c++)f[c]=this.holes[c].getTransformedPoints(b,this.bends);return f};THREE.Shape.prototype.getSpacedPointsHoles=function(b){var c,e=this.holes.length,f=[];for(c=0;c<e;c++)f[c]=this.holes[c].getTransformedSpacedPoints(b,this.bends);return f};THREE.Shape.prototype.extractAllPoints=function(b){return{shape:this.getTransformedPoints(b),holes:this.getPointsHoles(b)}};
THREE.Shape.prototype.extractAllSpacedPoints=function(b){return{shape:this.getTransformedSpacedPoints(b),holes:this.getSpacedPointsHoles(b)}};
THREE.Shape.Utils={removeHoles:function(b,c){var e=b.concat(),f=e.concat(),h,m,k,n,t,u,w,v,x,p,y=[];for(t=0;t<c.length;t++){u=c[t];f=f.concat(u);m=Number.POSITIVE_INFINITY;for(h=0;h<u.length;h++){x=u[h];p=[];for(v=0;v<e.length;v++)w=e[v],w=x.distanceToSquared(w),p.push(w),w<m&&(m=w,k=h,n=v)}h=n-1>=0?n-1:e.length-1;m=k-1>=0?k-1:u.length-1;var z=[u[k],e[n],e[h]];v=THREE.FontUtils.Triangulate.area(z);var A=[u[k],u[m],e[n]];x=THREE.FontUtils.Triangulate.area(A);p=n;w=k;n+=1;k+=-1;n<0&&(n+=e.length);n%=
e.length;k<0&&(k+=u.length);k%=u.length;h=n-1>=0?n-1:e.length-1;m=k-1>=0?k-1:u.length-1;z=[u[k],e[n],e[h]];z=THREE.FontUtils.Triangulate.area(z);A=[u[k],u[m],e[n]];A=THREE.FontUtils.Triangulate.area(A);v+x>z+A&&(n=p,k=w,n<0&&(n+=e.length),n%=e.length,k<0&&(k+=u.length),k%=u.length,h=n-1>=0?n-1:e.length-1,m=k-1>=0?k-1:u.length-1);v=e.slice(0,n);x=e.slice(n);p=u.slice(k);w=u.slice(0,k);m=[u[k],u[m],e[n]];y.push([u[k],e[n],e[h]]);y.push(m);e=v.concat(p).concat(w).concat(x)}return{shape:e,isolatedPts:y,
allpoints:f}},triangulateShape:function(b,c){var e=THREE.Shape.Utils.removeHoles(b,c),f=e.allpoints,h=e.isolatedPts,e=THREE.FontUtils.Triangulate(e.shape,!1),m,k,n,t,u={};m=0;for(k=f.length;m<k;m++)t=f[m].x+":"+f[m].y,u[t]!==void 0&&console.log("Duplicate point",t),u[t]=m;m=0;for(k=e.length;m<k;m++){n=e[m];for(f=0;f<3;f++)t=n[f].x+":"+n[f].y,t=u[t],t!==void 0&&(n[f]=t)}m=0;for(k=h.length;m<k;m++){n=h[m];for(f=0;f<3;f++)t=n[f].x+":"+n[f].y,t=u[t],t!==void 0&&(n[f]=t)}return e.concat(h)},isClockWise:function(b){return THREE.FontUtils.Triangulate.area(b)<
0},b2p0:function(b,c){var e=1-b;return e*e*c},b2p1:function(b,c){return 2*(1-b)*b*c},b2p2:function(b,c){return b*b*c},b2:function(b,c,e,f){return this.b2p0(b,c)+this.b2p1(b,e)+this.b2p2(b,f)},b3p0:function(b,c){var e=1-b;return e*e*e*c},b3p1:function(b,c){var e=1-b;return 3*e*e*b*c},b3p2:function(b,c){return 3*(1-b)*b*b*c},b3p3:function(b,c){return b*b*b*c},b3:function(b,c,e,f,h){return this.b3p0(b,c)+this.b3p1(b,e)+this.b3p2(b,f)+this.b3p3(b,h)}};
THREE.TextPath=function(b,c){THREE.Path.call(this);this.parameters=c||{};this.set(b)};THREE.TextPath.prototype.set=function(b,c){this.text=b;var c=c||this.parameters,e=c.curveSegments!==void 0?c.curveSegments:4,f=c.font!==void 0?c.font:"helvetiker",h=c.weight!==void 0?c.weight:"normal",m=c.style!==void 0?c.style:"normal";THREE.FontUtils.size=c.size!==void 0?c.size:100;THREE.FontUtils.divisions=e;THREE.FontUtils.face=f;THREE.FontUtils.weight=h;THREE.FontUtils.style=m};
THREE.TextPath.prototype.toShapes=function(){for(var b=THREE.FontUtils.drawText(this.text).paths,c=[],e=0,f=b.length;e<f;e++)c=c.concat(b[e].toShapes());return c};
THREE.AnimationHandler=function(){var b=[],c={},e={update:function(e){for(var c=0;c<b.length;c++)b[c].update(e)},addToUpdate:function(e){b.indexOf(e)===-1&&b.push(e)},removeFromUpdate:function(e){e=b.indexOf(e);e!==-1&&b.splice(e,1)},add:function(b){c[b.name]!==void 0&&console.log("THREE.AnimationHandler.add: Warning! "+b.name+" already exists in library. Overwriting.");c[b.name]=b;if(b.initialized!==!0){for(var e=0;e<b.hierarchy.length;e++){for(var f=0;f<b.hierarchy[e].keys.length;f++){if(b.hierarchy[e].keys[f].time<
0)b.hierarchy[e].keys[f].time=0;if(b.hierarchy[e].keys[f].rot!==void 0&&!(b.hierarchy[e].keys[f].rot instanceof THREE.Quaternion)){var n=b.hierarchy[e].keys[f].rot;b.hierarchy[e].keys[f].rot=new THREE.Quaternion(n[0],n[1],n[2],n[3])}}if(b.hierarchy[e].keys[0].morphTargets!==void 0){n={};for(f=0;f<b.hierarchy[e].keys.length;f++)for(var t=0;t<b.hierarchy[e].keys[f].morphTargets.length;t++){var u=b.hierarchy[e].keys[f].morphTargets[t];n[u]=-1}b.hierarchy[e].usedMorphTargets=n;for(f=0;f<b.hierarchy[e].keys.length;f++){var w=
{};for(u in n){for(t=0;t<b.hierarchy[e].keys[f].morphTargets.length;t++)if(b.hierarchy[e].keys[f].morphTargets[t]===u){w[u]=b.hierarchy[e].keys[f].morphTargetsInfluences[t];break}t===b.hierarchy[e].keys[f].morphTargets.length&&(w[u]=0)}b.hierarchy[e].keys[f].morphTargetsInfluences=w}}for(f=1;f<b.hierarchy[e].keys.length;f++)b.hierarchy[e].keys[f].time===b.hierarchy[e].keys[f-1].time&&(b.hierarchy[e].keys.splice(f,1),f--);for(f=1;f<b.hierarchy[e].keys.length;f++)b.hierarchy[e].keys[f].index=f}f=parseInt(b.length*
b.fps,10);b.JIT={};b.JIT.hierarchy=[];for(e=0;e<b.hierarchy.length;e++)b.JIT.hierarchy.push(Array(f));b.initialized=!0}},get:function(b){if(typeof b==="string")return c[b]?c[b]:(console.log("THREE.AnimationHandler.get: Couldn't find animation "+b),null)},parse:function(b){var e=[];if(b instanceof THREE.SkinnedMesh)for(var c=0;c<b.bones.length;c++)e.push(b.bones[c]);else f(b,e);return e}},f=function(b,e){e.push(b);for(var c=0;c<b.children.length;c++)f(b.children[c],e)};e.LINEAR=0;e.CATMULLROM=1;e.CATMULLROM_FORWARD=
2;return e}();THREE.Animation=function(b,c,e,f){this.root=b;this.data=THREE.AnimationHandler.get(c);this.hierarchy=THREE.AnimationHandler.parse(b);this.currentTime=0;this.timeScale=1;this.isPlaying=!1;this.loop=this.isPaused=!0;this.interpolationType=e!==void 0?e:THREE.AnimationHandler.LINEAR;this.JITCompile=f!==void 0?f:!0;this.points=[];this.target=new THREE.Vector3};
THREE.Animation.prototype.play=function(b,c){if(!this.isPlaying){this.isPlaying=!0;this.loop=b!==void 0?b:!0;this.currentTime=c!==void 0?c:0;var e,f=this.hierarchy.length,h;for(e=0;e<f;e++){h=this.hierarchy[e];if(this.interpolationType!==THREE.AnimationHandler.CATMULLROM_FORWARD)h.useQuaternion=!0;h.matrixAutoUpdate=!0;if(h.animationCache===void 0)h.animationCache={},h.animationCache.prevKey={pos:0,rot:0,scl:0},h.animationCache.nextKey={pos:0,rot:0,scl:0},h.animationCache.originalMatrix=h instanceof
THREE.Bone?h.skinMatrix:h.matrix;var m=h.animationCache.prevKey;h=h.animationCache.nextKey;m.pos=this.data.hierarchy[e].keys[0];m.rot=this.data.hierarchy[e].keys[0];m.scl=this.data.hierarchy[e].keys[0];h.pos=this.getNextKeyWith("pos",e,1);h.rot=this.getNextKeyWith("rot",e,1);h.scl=this.getNextKeyWith("scl",e,1)}this.update(0)}this.isPaused=!1;THREE.AnimationHandler.addToUpdate(this)};
THREE.Animation.prototype.pause=function(){this.isPaused?THREE.AnimationHandler.addToUpdate(this):THREE.AnimationHandler.removeFromUpdate(this);this.isPaused=!this.isPaused};
THREE.Animation.prototype.stop=function(){this.isPaused=this.isPlaying=!1;THREE.AnimationHandler.removeFromUpdate(this);for(var b=0;b<this.hierarchy.length;b++)if(this.hierarchy[b].animationCache!==void 0)this.hierarchy[b]instanceof THREE.Bone?this.hierarchy[b].skinMatrix=this.hierarchy[b].animationCache.originalMatrix:this.hierarchy[b].matrix=this.hierarchy[b].animationCache.originalMatrix,delete this.hierarchy[b].animationCache};
THREE.Animation.prototype.update=function(b){if(this.isPlaying){var c=["pos","rot","scl"],e,f,h,m,k,n,t,u,w=this.data.JIT.hierarchy,v,x;this.currentTime+=b*this.timeScale;x=this.currentTime;v=this.currentTime%=this.data.length;u=parseInt(Math.min(v*this.data.fps,this.data.length*this.data.fps),10);for(var p=0,y=this.hierarchy.length;p<y;p++)if(b=this.hierarchy[p],t=b.animationCache,this.JITCompile&&w[p][u]!==void 0)b instanceof THREE.Bone?(b.skinMatrix=w[p][u],b.matrixAutoUpdate=!1,b.matrixWorldNeedsUpdate=
!1):(b.matrix=w[p][u],b.matrixAutoUpdate=!1,b.matrixWorldNeedsUpdate=!0);else{if(this.JITCompile)b instanceof THREE.Bone?b.skinMatrix=b.animationCache.originalMatrix:b.matrix=b.animationCache.originalMatrix;for(var z=0;z<3;z++){e=c[z];k=t.prevKey[e];n=t.nextKey[e];if(n.time<=x){if(v<x)if(this.loop){k=this.data.hierarchy[p].keys[0];for(n=this.getNextKeyWith(e,p,1);n.time<v;)k=n,n=this.getNextKeyWith(e,p,n.index+1)}else{this.stop();return}else{do k=n,n=this.getNextKeyWith(e,p,n.index+1);while(n.time<
v)}t.prevKey[e]=k;t.nextKey[e]=n}b.matrixAutoUpdate=!0;b.matrixWorldNeedsUpdate=!0;f=(v-k.time)/(n.time-k.time);h=k[e];m=n[e];if(f<0||f>1)console.log("THREE.Animation.update: Warning! Scale out of bounds:"+f+" on bone "+p),f=f<0?0:1;if(e==="pos")if(e=b.position,this.interpolationType===THREE.AnimationHandler.LINEAR)e.x=h[0]+(m[0]-h[0])*f,e.y=h[1]+(m[1]-h[1])*f,e.z=h[2]+(m[2]-h[2])*f;else{if(this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD)if(this.points[0]=
this.getPrevKeyWith("pos",p,k.index-1).pos,this.points[1]=h,this.points[2]=m,this.points[3]=this.getNextKeyWith("pos",p,n.index+1).pos,f=f*0.33+0.33,h=this.interpolateCatmullRom(this.points,f),e.x=h[0],e.y=h[1],e.z=h[2],this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD)f=this.interpolateCatmullRom(this.points,f*1.01),this.target.set(f[0],f[1],f[2]),this.target.subSelf(e),this.target.y=0,this.target.normalize(),f=Math.atan2(this.target.x,this.target.z),b.rotation.set(0,f,0)}else if(e===
"rot")THREE.Quaternion.slerp(h,m,b.quaternion,f);else if(e==="scl")e=b.scale,e.x=h[0]+(m[0]-h[0])*f,e.y=h[1]+(m[1]-h[1])*f,e.z=h[2]+(m[2]-h[2])*f}}if(this.JITCompile&&w[0][u]===void 0){this.hierarchy[0].update(void 0,!0);for(p=0;p<this.hierarchy.length;p++)w[p][u]=this.hierarchy[p]instanceof THREE.Bone?this.hierarchy[p].skinMatrix.clone():this.hierarchy[p].matrix.clone()}}};
THREE.Animation.prototype.interpolateCatmullRom=function(b,c){var e=[],f=[],h,m,k,n,t,u;h=(b.length-1)*c;m=Math.floor(h);h-=m;e[0]=m==0?m:m-1;e[1]=m;e[2]=m>b.length-2?m:m+1;e[3]=m>b.length-3?m:m+2;m=b[e[0]];n=b[e[1]];t=b[e[2]];u=b[e[3]];e=h*h;k=h*e;f[0]=this.interpolate(m[0],n[0],t[0],u[0],h,e,k);f[1]=this.interpolate(m[1],n[1],t[1],u[1],h,e,k);f[2]=this.interpolate(m[2],n[2],t[2],u[2],h,e,k);return f};
THREE.Animation.prototype.interpolate=function(b,c,e,f,h,m,k){b=(e-b)*0.5;f=(f-c)*0.5;return(2*(c-e)+b+f)*k+(-3*(c-e)-2*b-f)*m+b*h+c};THREE.Animation.prototype.getNextKeyWith=function(b,c,e){var f=this.data.hierarchy[c].keys;for(this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD?e=e<f.length-1?e:f.length-1:e%=f.length;e<f.length;e++)if(f[e][b]!==void 0)return f[e];return this.data.hierarchy[c].keys[0]};
THREE.Animation.prototype.getPrevKeyWith=function(b,c,e){for(var f=this.data.hierarchy[c].keys,e=this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD?e>0?e:0:e>=0?e:e+f.length;e>=0;e--)if(f[e][b]!==void 0)return f[e];return this.data.hierarchy[c].keys[f.length-1]};
THREE.FirstPersonCamera=function(b){function c(b,c){return function(){c.apply(b,arguments)}}THREE.Camera.call(this,b.fov,b.aspect,b.near,b.far,b.target);this.movementSpeed=1;this.lookSpeed=0.005;this.noFly=!1;this.lookVertical=!0;this.autoForward=!1;this.activeLook=!0;this.heightSpeed=!1;this.heightCoef=1;this.heightMin=0;this.constrainVertical=!1;this.verticalMin=0;this.verticalMax=3.14;this.domElement=document;this.lastUpdate=(new Date).getTime();this.tdiff=0;if(b){if(b.movementSpeed!==void 0)this.movementSpeed=
b.movementSpeed;if(b.lookSpeed!==void 0)this.lookSpeed=b.lookSpeed;if(b.noFly!==void 0)this.noFly=b.noFly;if(b.lookVertical!==void 0)this.lookVertical=b.lookVertical;if(b.autoForward!==void 0)this.autoForward=b.autoForward;if(b.activeLook!==void 0)this.activeLook=b.activeLook;if(b.heightSpeed!==void 0)this.heightSpeed=b.heightSpeed;if(b.heightCoef!==void 0)this.heightCoef=b.heightCoef;if(b.heightMin!==void 0)this.heightMin=b.heightMin;if(b.heightMax!==void 0)this.heightMax=b.heightMax;if(b.constrainVertical!==
void 0)this.constrainVertical=b.constrainVertical;if(b.verticalMin!==void 0)this.verticalMin=b.verticalMin;if(b.verticalMax!==void 0)this.verticalMax=b.verticalMax;if(b.domElement!==void 0)this.domElement=b.domElement}this.theta=this.phi=this.lon=this.lat=this.mouseY=this.mouseX=this.autoSpeedFactor=0;this.mouseDragOn=this.freeze=this.moveRight=this.moveLeft=this.moveBackward=this.moveForward=!1;this.windowHalfX=window.innerWidth/2;this.windowHalfY=window.innerHeight/2;this.onMouseDown=function(b){b.preventDefault();
b.stopPropagation();if(this.activeLook)switch(b.button){case 0:this.moveForward=!0;break;case 2:this.moveBackward=!0}this.mouseDragOn=!0};this.onMouseUp=function(b){b.preventDefault();b.stopPropagation();if(this.activeLook)switch(b.button){case 0:this.moveForward=!1;break;case 2:this.moveBackward=!1}this.mouseDragOn=!1};this.onMouseMove=function(b){this.mouseX=b.clientX-this.windowHalfX;this.mouseY=b.clientY-this.windowHalfY};this.onKeyDown=function(b){switch(b.keyCode){case 38:case 87:this.moveForward=
!0;break;case 37:case 65:this.moveLeft=!0;break;case 40:case 83:this.moveBackward=!0;break;case 39:case 68:this.moveRight=!0;break;case 82:this.moveUp=!0;break;case 70:this.moveDown=!0;break;case 81:this.freeze=!this.freeze}};this.onKeyUp=function(b){switch(b.keyCode){case 38:case 87:this.moveForward=!1;break;case 37:case 65:this.moveLeft=!1;break;case 40:case 83:this.moveBackward=!1;break;case 39:case 68:this.moveRight=!1;break;case 82:this.moveUp=!1;break;case 70:this.moveDown=!1}};this.update=
function(){var b=(new Date).getTime();this.tdiff=(b-this.lastUpdate)/1E3;this.lastUpdate=b;if(!this.freeze){this.autoSpeedFactor=this.heightSpeed?this.tdiff*((this.position.y<this.heightMin?this.heightMin:this.position.y>this.heightMax?this.heightMax:this.position.y)-this.heightMin)*this.heightCoef:0;var c=this.tdiff*this.movementSpeed;(this.moveForward||this.autoForward&&!this.moveBackward)&&this.translateZ(-(c+this.autoSpeedFactor));this.moveBackward&&this.translateZ(c);this.moveLeft&&this.translateX(-c);
this.moveRight&&this.translateX(c);this.moveUp&&this.translateY(c);this.moveDown&&this.translateY(-c);c=this.tdiff*this.lookSpeed;this.activeLook||(c=0);this.lon+=this.mouseX*c;this.lookVertical&&(this.lat-=this.mouseY*c);this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*Math.PI/180;this.theta=this.lon*Math.PI/180;var b=this.target.position,h=this.position;b.x=h.x+100*Math.sin(this.phi)*Math.cos(this.theta);b.y=h.y+100*Math.cos(this.phi);b.z=h.z+100*Math.sin(this.phi)*Math.sin(this.theta)}b=
1;this.constrainVertical&&(b=3.14/(this.verticalMax-this.verticalMin));this.lon+=this.mouseX*c;this.lookVertical&&(this.lat-=this.mouseY*c*b);this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*Math.PI/180;this.theta=this.lon*Math.PI/180;if(this.constrainVertical)this.phi=(this.phi-0)*(this.verticalMax-this.verticalMin)/3.14+this.verticalMin;b=this.target.position;h=this.position;b.x=h.x+100*Math.sin(this.phi)*Math.cos(this.theta);b.y=h.y+100*Math.cos(this.phi);b.z=h.z+100*Math.sin(this.phi)*
Math.sin(this.theta);this.supr.update.call(this)};this.domElement.addEventListener("contextmenu",function(b){b.preventDefault()},!1);this.domElement.addEventListener("mousemove",c(this,this.onMouseMove),!1);this.domElement.addEventListener("mousedown",c(this,this.onMouseDown),!1);this.domElement.addEventListener("mouseup",c(this,this.onMouseUp),!1);this.domElement.addEventListener("keydown",c(this,this.onKeyDown),!1);this.domElement.addEventListener("keyup",c(this,this.onKeyUp),!1)};
THREE.FirstPersonCamera.prototype=new THREE.Camera;THREE.FirstPersonCamera.prototype.constructor=THREE.FirstPersonCamera;THREE.FirstPersonCamera.prototype.supr=THREE.Camera.prototype;THREE.FirstPersonCamera.prototype.translate=function(b,c){this.matrix.rotateAxis(c);if(this.noFly)c.y=0;this.position.addSelf(c.multiplyScalar(b));this.target.position.addSelf(c.multiplyScalar(b))};
THREE.PathCamera=function(b){function c(b,e,c,f){var h={name:c,fps:0.6,length:f,hierarchy:[]},k,m=e.getControlPointsArray(),n=e.getLength(),t=m.length,E=0;k=t-1;e={parent:-1,keys:[]};e.keys[0]={time:0,pos:m[0],rot:[0,0,0,1],scl:[1,1,1]};e.keys[k]={time:f,pos:m[k],rot:[0,0,0,1],scl:[1,1,1]};for(k=1;k<t-1;k++)E=f*n.chunks[k]/n.total,e.keys[k]={time:E,pos:m[k]};h.hierarchy[0]=e;THREE.AnimationHandler.add(h);return new THREE.Animation(b,c,THREE.AnimationHandler.CATMULLROM_FORWARD,!1)}function e(b,e){var c,
f,h=new THREE.Geometry;for(c=0;c<b.points.length*e;c++)f=c/(b.points.length*e),f=b.getPoint(f),h.vertices[c]=new THREE.Vertex(new THREE.Vector3(f.x,f.y,f.z));return h}function f(b,c){var f=e(c,10),h=e(c,10),k=new THREE.LineBasicMaterial({color:16711680,linewidth:3});lineObj=new THREE.Line(f,k);particleObj=new THREE.ParticleSystem(h,new THREE.ParticleBasicMaterial({color:16755200,size:3}));lineObj.scale.set(1,1,1);b.addChild(lineObj);particleObj.scale.set(1,1,1);b.addChild(particleObj);h=new THREE.SphereGeometry(1,
16,8);k=new THREE.MeshBasicMaterial({color:65280});for(i=0;i<c.points.length;i++)f=new THREE.Mesh(h,k),f.position.copy(c.points[i]),f.updateMatrix(),b.addChild(f)}THREE.Camera.call(this,b.fov,b.aspect,b.near,b.far,b.target);this.id="PathCamera"+THREE.PathCameraIdCounter++;this.duration=1E4;this.waypoints=[];this.useConstantSpeed=!0;this.resamplingCoef=50;this.debugPath=new THREE.Object3D;this.debugDummy=new THREE.Object3D;this.animationParent=new THREE.Object3D;this.lookSpeed=0.005;this.lookHorizontal=
this.lookVertical=!0;this.verticalAngleMap={srcRange:[0,6.28],dstRange:[0,6.28]};this.horizontalAngleMap={srcRange:[0,6.28],dstRange:[0,6.28]};this.domElement=document;if(b){if(b.duration!==void 0)this.duration=b.duration*1E3;if(b.waypoints!==void 0)this.waypoints=b.waypoints;if(b.useConstantSpeed!==void 0)this.useConstantSpeed=b.useConstantSpeed;if(b.resamplingCoef!==void 0)this.resamplingCoef=b.resamplingCoef;if(b.createDebugPath!==void 0)this.createDebugPath=b.createDebugPath;if(b.createDebugDummy!==
void 0)this.createDebugDummy=b.createDebugDummy;if(b.lookSpeed!==void 0)this.lookSpeed=b.lookSpeed;if(b.lookVertical!==void 0)this.lookVertical=b.lookVertical;if(b.lookHorizontal!==void 0)this.lookHorizontal=b.lookHorizontal;if(b.verticalAngleMap!==void 0)this.verticalAngleMap=b.verticalAngleMap;if(b.horizontalAngleMap!==void 0)this.horizontalAngleMap=b.horizontalAngleMap;if(b.domElement!==void 0)this.domElement=b.domElement}this.theta=this.phi=this.lon=this.lat=this.mouseY=this.mouseX=0;this.windowHalfX=
window.innerWidth/2;this.windowHalfY=window.innerHeight/2;var h=Math.PI*2,m=Math.PI/180;this.update=function(b,e,c){var f,k;this.lookHorizontal&&(this.lon+=this.mouseX*this.lookSpeed);this.lookVertical&&(this.lat-=this.mouseY*this.lookSpeed);this.lon=Math.max(0,Math.min(360,this.lon));this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*m;this.theta=this.lon*m;f=this.phi%h;this.phi=f>=0?f:f+h;f=this.verticalAngleMap.srcRange;k=this.verticalAngleMap.dstRange;var n=k[1]-k[0];this.phi=
TWEEN.Easing.Quadratic.EaseInOut(((this.phi-f[0])*(k[1]-k[0])/(f[1]-f[0])+k[0]-k[0])/n)*n+k[0];f=this.horizontalAngleMap.srcRange;k=this.horizontalAngleMap.dstRange;n=k[1]-k[0];this.theta=TWEEN.Easing.Quadratic.EaseInOut(((this.theta-f[0])*(k[1]-k[0])/(f[1]-f[0])+k[0]-k[0])/n)*n+k[0];f=this.target.position;f.x=100*Math.sin(this.phi)*Math.cos(this.theta);f.y=100*Math.cos(this.phi);f.z=100*Math.sin(this.phi)*Math.sin(this.theta);this.supr.update.call(this,b,e,c)};this.onMouseMove=function(b){this.mouseX=
b.clientX-this.windowHalfX;this.mouseY=b.clientY-this.windowHalfY};this.spline=new THREE.Spline;this.spline.initFromArray(this.waypoints);this.useConstantSpeed&&this.spline.reparametrizeByArcLength(this.resamplingCoef);if(this.createDebugDummy){var b=new THREE.MeshLambertMaterial({color:30719}),k=new THREE.MeshLambertMaterial({color:65280}),n=new THREE.CubeGeometry(10,10,20),t=new THREE.CubeGeometry(2,2,10);this.animationParent=new THREE.Mesh(n,b);b=new THREE.Mesh(t,k);b.position.set(0,10,0);this.animation=
c(this.animationParent,this.spline,this.id,this.duration);this.animationParent.addChild(this);this.animationParent.addChild(this.target);this.animationParent.addChild(b)}else this.animation=c(this.animationParent,this.spline,this.id,this.duration),this.animationParent.addChild(this.target),this.animationParent.addChild(this);this.createDebugPath&&f(this.debugPath,this.spline);this.domElement.addEventListener("mousemove",function(b,e){return function(){e.apply(b,arguments)}}(this,this.onMouseMove),
!1)};THREE.PathCamera.prototype=new THREE.Camera;THREE.PathCamera.prototype.constructor=THREE.PathCamera;THREE.PathCamera.prototype.supr=THREE.Camera.prototype;THREE.PathCameraIdCounter=0;
THREE.FlyCamera=function(b){function c(b,c){return function(){c.apply(b,arguments)}}THREE.Camera.call(this,b.fov,b.aspect,b.near,b.far,b.target);this.tmpQuaternion=new THREE.Quaternion;this.movementSpeed=1;this.rollSpeed=0.005;this.autoForward=this.dragToLook=!1;this.domElement=document;if(b){if(b.movementSpeed!==void 0)this.movementSpeed=b.movementSpeed;if(b.rollSpeed!==void 0)this.rollSpeed=b.rollSpeed;if(b.dragToLook!==void 0)this.dragToLook=b.dragToLook;if(b.autoForward!==void 0)this.autoForward=
b.autoForward;if(b.domElement!==void 0)this.domElement=b.domElement}this.useTarget=!1;this.useQuaternion=!0;this.mouseStatus=0;this.moveState={up:0,down:0,left:0,right:0,forward:0,back:0,pitchUp:0,pitchDown:0,yawLeft:0,yawRight:0,rollLeft:0,rollRight:0};this.moveVector=new THREE.Vector3(0,0,0);this.rotationVector=new THREE.Vector3(0,0,0);this.lastUpdate=-1;this.tdiff=0;this.handleEvent=function(b){if(typeof this[b.type]=="function")this[b.type](b)};this.keydown=function(b){if(!b.altKey){switch(b.keyCode){case 16:this.movementSpeedMultiplier=
0.1;break;case 87:this.moveState.forward=1;break;case 83:this.moveState.back=1;break;case 65:this.moveState.left=1;break;case 68:this.moveState.right=1;break;case 82:this.moveState.up=1;break;case 70:this.moveState.down=1;break;case 38:this.moveState.pitchUp=1;break;case 40:this.moveState.pitchDown=1;break;case 37:this.moveState.yawLeft=1;break;case 39:this.moveState.yawRight=1;break;case 81:this.moveState.rollLeft=1;break;case 69:this.moveState.rollRight=1}this.updateMovementVector();this.updateRotationVector()}};
this.keyup=function(b){switch(b.keyCode){case 16:this.movementSpeedMultiplier=1;break;case 87:this.moveState.forward=0;break;case 83:this.moveState.back=0;break;case 65:this.moveState.left=0;break;case 68:this.moveState.right=0;break;case 82:this.moveState.up=0;break;case 70:this.moveState.down=0;break;case 38:this.moveState.pitchUp=0;break;case 40:this.moveState.pitchDown=0;break;case 37:this.moveState.yawLeft=0;break;case 39:this.moveState.yawRight=0;break;case 81:this.moveState.rollLeft=0;break;
case 69:this.moveState.rollRight=0}this.updateMovementVector();this.updateRotationVector()};this.mousedown=function(b){b.preventDefault();b.stopPropagation();if(this.dragToLook)this.mouseStatus++;else switch(b.button){case 0:this.moveForward=!0;break;case 2:this.moveBackward=!0}};this.mousemove=function(b){if(!this.dragToLook||this.mouseStatus>0){var c=this.getContainerDimensions(),h=c.size[0]/2,m=c.size[1]/2;this.moveState.yawLeft=-(b.clientX-c.offset[0]-h)/h;this.moveState.pitchDown=(b.clientY-
c.offset[1]-m)/m;this.updateRotationVector()}};this.mouseup=function(b){b.preventDefault();b.stopPropagation();if(this.dragToLook)this.mouseStatus--,this.moveState.yawLeft=this.moveState.pitchDown=0;else switch(b.button){case 0:this.moveForward=!1;break;case 2:this.moveBackward=!1}this.updateRotationVector()};this.update=function(){var b=(new Date).getTime();if(this.lastUpdate==-1)this.lastUpdate=b;this.tdiff=(b-this.lastUpdate)/1E3;this.lastUpdate=b;var b=this.tdiff*this.movementSpeed,c=this.tdiff*
this.rollSpeed;this.translateX(this.moveVector.x*b);this.translateY(this.moveVector.y*b);this.translateZ(this.moveVector.z*b);this.tmpQuaternion.set(this.rotationVector.x*c,this.rotationVector.y*c,this.rotationVector.z*c,1).normalize();this.quaternion.multiplySelf(this.tmpQuaternion);this.matrix.setPosition(this.position);this.matrix.setRotationFromQuaternion(this.quaternion);this.matrixWorldNeedsUpdate=!0;this.supr.update.call(this)};this.updateMovementVector=function(){var b=this.moveState.forward||
this.autoForward&&!this.moveState.back?1:0;this.moveVector.x=-this.moveState.left+this.moveState.right;this.moveVector.y=-this.moveState.down+this.moveState.up;this.moveVector.z=-b+this.moveState.back};this.updateRotationVector=function(){this.rotationVector.x=-this.moveState.pitchDown+this.moveState.pitchUp;this.rotationVector.y=-this.moveState.yawRight+this.moveState.yawLeft;this.rotationVector.z=-this.moveState.rollRight+this.moveState.rollLeft};this.getContainerDimensions=function(){return this.domElement!=
document?{size:[this.domElement.offsetWidth,this.domElement.offsetHeight],offset:[this.domElement.offsetLeft,this.domElement.offsetTop]}:{size:[window.innerWidth,window.innerHeight],offset:[0,0]}};this.domElement.addEventListener("mousemove",c(this,this.mousemove),!1);this.domElement.addEventListener("mousedown",c(this,this.mousedown),!1);this.domElement.addEventListener("mouseup",c(this,this.mouseup),!1);window.addEventListener("keydown",c(this,this.keydown),!1);window.addEventListener("keyup",c(this,
this.keyup),!1);this.updateMovementVector();this.updateRotationVector()};THREE.FlyCamera.prototype=new THREE.Camera;THREE.FlyCamera.prototype.constructor=THREE.FlyCamera;THREE.FlyCamera.prototype.supr=THREE.Camera.prototype;
THREE.RollCamera=function(b,c,e,f){THREE.Camera.call(this,b,c,e,f);this.mouseLook=!0;this.autoForward=!1;this.rollSpeed=this.movementSpeed=this.lookSpeed=1;this.constrainVertical=[-0.9,0.9];this.domElement=document;this.matrixAutoUpdate=this.useTarget=!1;this.forward=new THREE.Vector3(0,0,1);this.roll=0;this.lastUpdate=-1;this.delta=0;var h=new THREE.Vector3,m=new THREE.Vector3,k=new THREE.Vector3,n=new THREE.Matrix4,t=!1,u=1,w=0,v=0,x=0,p=0,y=0,z=window.innerWidth/2,A=window.innerHeight/2;this.update=
function(){var b=(new Date).getTime();if(this.lastUpdate==-1)this.lastUpdate=b;this.delta=(b-this.lastUpdate)/1E3;this.lastUpdate=b;this.mouseLook&&(b=this.delta*this.lookSpeed,this.rotateHorizontally(b*p),this.rotateVertically(b*y));b=this.delta*this.movementSpeed;this.translateZ(b*(w>0||this.autoForward&&!(w<0)?1:w));this.translateX(b*v);this.translateY(b*x);t&&(this.roll+=this.rollSpeed*this.delta*u);if(this.forward.y>this.constrainVertical[1])this.forward.y=this.constrainVertical[1],this.forward.normalize();
else if(this.forward.y<this.constrainVertical[0])this.forward.y=this.constrainVertical[0],this.forward.normalize();k.copy(this.forward);m.set(0,1,0);h.cross(m,k).normalize();m.cross(k,h).normalize();this.matrix.n11=h.x;this.matrix.n12=m.x;this.matrix.n13=k.x;this.matrix.n21=h.y;this.matrix.n22=m.y;this.matrix.n23=k.y;this.matrix.n31=h.z;this.matrix.n32=m.z;this.matrix.n33=k.z;n.identity();n.n11=Math.cos(this.roll);n.n12=-Math.sin(this.roll);n.n21=Math.sin(this.roll);n.n22=Math.cos(this.roll);this.matrix.multiplySelf(n);
this.matrixWorldNeedsUpdate=!0;this.matrix.n14=this.position.x;this.matrix.n24=this.position.y;this.matrix.n34=this.position.z;this.supr.update.call(this)};this.translateX=function(b){this.position.x+=this.matrix.n11*b;this.position.y+=this.matrix.n21*b;this.position.z+=this.matrix.n31*b};this.translateY=function(b){this.position.x+=this.matrix.n12*b;this.position.y+=this.matrix.n22*b;this.position.z+=this.matrix.n32*b};this.translateZ=function(b){this.position.x-=this.matrix.n13*b;this.position.y-=
this.matrix.n23*b;this.position.z-=this.matrix.n33*b};this.rotateHorizontally=function(b){h.set(this.matrix.n11,this.matrix.n21,this.matrix.n31);h.multiplyScalar(b);this.forward.subSelf(h);this.forward.normalize()};this.rotateVertically=function(b){m.set(this.matrix.n12,this.matrix.n22,this.matrix.n32);m.multiplyScalar(b);this.forward.addSelf(m);this.forward.normalize()};this.domElement.addEventListener("contextmenu",function(b){b.preventDefault()},!1);this.domElement.addEventListener("mousemove",
function(b){p=(b.clientX-z)/window.innerWidth;y=(b.clientY-A)/window.innerHeight},!1);this.domElement.addEventListener("mousedown",function(b){b.preventDefault();b.stopPropagation();switch(b.button){case 0:w=1;break;case 2:w=-1}},!1);this.domElement.addEventListener("mouseup",function(b){b.preventDefault();b.stopPropagation();switch(b.button){case 0:w=0;break;case 2:w=0}},!1);this.domElement.addEventListener("keydown",function(b){switch(b.keyCode){case 38:case 87:w=1;break;case 37:case 65:v=-1;break;
case 40:case 83:w=-1;break;case 39:case 68:v=1;break;case 81:t=!0;u=1;break;case 69:t=!0;u=-1;break;case 82:x=1;break;case 70:x=-1}},!1);this.domElement.addEventListener("keyup",function(b){switch(b.keyCode){case 38:case 87:w=0;break;case 37:case 65:v=0;break;case 40:case 83:w=0;break;case 39:case 68:v=0;break;case 81:t=!1;break;case 69:t=!1;break;case 82:x=0;break;case 70:x=0}},!1)};THREE.RollCamera.prototype=new THREE.Camera;THREE.RollCamera.prototype.constructor=THREE.RollCamera;
THREE.RollCamera.prototype.supr=THREE.Camera.prototype;
THREE.TrackballCamera=function(b){function c(b,c){return function(){c.apply(b,arguments)}}b=b||{};THREE.Camera.call(this,b.fov,b.aspect,b.near,b.far,b.target);this.domElement=b.domElement||document;this.screen=b.screen||{width:window.innerWidth,height:window.innerHeight,offsetLeft:0,offsetTop:0};this.radius=b.radius||(this.screen.width+this.screen.height)/4;this.rotateSpeed=b.rotateSpeed||1;this.zoomSpeed=b.zoomSpeed||1.2;this.panSpeed=b.panSpeed||0.3;this.noZoom=b.noZoom||!1;this.noPan=b.noPan||
!1;this.staticMoving=b.staticMoving||!1;this.dynamicDampingFactor=b.dynamicDampingFactor||0.2;this.minDistance=b.minDistance||0;this.maxDistance=b.maxDistance||Infinity;this.keys=b.keys||[65,83,68];this.useTarget=!0;var e=!1,f=this.STATE.NONE,h=new THREE.Vector3,m=new THREE.Vector3,k=new THREE.Vector3,n=new THREE.Vector2,t=new THREE.Vector2,u=new THREE.Vector2,w=new THREE.Vector2;this.handleEvent=function(b){if(typeof this[b.type]=="function")this[b.type](b)};this.getMouseOnScreen=function(b,c){return new THREE.Vector2((b-
this.screen.offsetLeft)/this.radius*0.5,(c-this.screen.offsetTop)/this.radius*0.5)};this.getMouseProjectionOnBall=function(b,c){var e=new THREE.Vector3((b-this.screen.width*0.5-this.screen.offsetLeft)/this.radius,(this.screen.height*0.5+this.screen.offsetTop-c)/this.radius,0),f=e.length();f>1?e.normalize():e.z=Math.sqrt(1-f*f);h=this.position.clone().subSelf(this.target.position);f=this.up.clone().setLength(e.y);f.addSelf(this.up.clone().crossSelf(h).setLength(e.x));f.addSelf(h.setLength(e.z));return f};
this.rotateCamera=function(){var b=Math.acos(m.dot(k)/m.length()/k.length());if(b){var c=(new THREE.Vector3).cross(m,k).normalize(),e=new THREE.Quaternion;b*=this.rotateSpeed;e.setFromAxisAngle(c,-b);e.multiplyVector3(h);e.multiplyVector3(this.up);e.multiplyVector3(k);this.staticMoving?m=k:(e.setFromAxisAngle(c,b*(this.dynamicDampingFactor-1)),e.multiplyVector3(m))}};this.zoomCamera=function(){var b=1+(t.y-n.y)*this.zoomSpeed;b!==1&&b>0&&(h.multiplyScalar(b),this.staticMoving?n=t:n.y+=(t.y-n.y)*this.dynamicDampingFactor)};
this.panCamera=function(){var b=w.clone().subSelf(u);if(b.lengthSq()){b.multiplyScalar(h.length()*this.panSpeed);var c=h.clone().crossSelf(this.up).setLength(b.x);c.addSelf(this.up.clone().setLength(b.y));this.position.addSelf(c);this.target.position.addSelf(c);this.staticMoving?u=w:u.addSelf(b.sub(w,u).multiplyScalar(this.dynamicDampingFactor))}};this.checkDistances=function(){if(!this.noZoom||!this.noPan)this.position.lengthSq()>this.maxDistance*this.maxDistance&&this.position.setLength(this.maxDistance),
h.lengthSq()<this.minDistance*this.minDistance&&this.position.add(this.target.position,h.setLength(this.minDistance))};this.update=function(b,c,e){h=this.position.clone().subSelf(this.target.position);this.rotateCamera();this.noZoom||this.zoomCamera();this.noPan||this.panCamera();this.position.add(this.target.position,h);this.checkDistances();this.supr.update.call(this,b,c,e)};this.domElement.addEventListener("contextmenu",function(b){b.preventDefault()},!1);this.domElement.addEventListener("mousemove",
c(this,function(b){e&&(m=k=this.getMouseProjectionOnBall(b.clientX,b.clientY),n=t=this.getMouseOnScreen(b.clientX,b.clientY),u=w=this.getMouseOnScreen(b.clientX,b.clientY),e=!1);f!==this.STATE.NONE&&(f===this.STATE.ROTATE?k=this.getMouseProjectionOnBall(b.clientX,b.clientY):f===this.STATE.ZOOM&&!this.noZoom?t=this.getMouseOnScreen(b.clientX,b.clientY):f===this.STATE.PAN&&!this.noPan&&(w=this.getMouseOnScreen(b.clientX,b.clientY)))}),!1);this.domElement.addEventListener("mousedown",c(this,function(b){b.preventDefault();
b.stopPropagation();if(f===this.STATE.NONE)f=b.button,f===this.STATE.ROTATE?m=k=this.getMouseProjectionOnBall(b.clientX,b.clientY):f===this.STATE.ZOOM&&!this.noZoom?n=t=this.getMouseOnScreen(b.clientX,b.clientY):this.noPan||(u=w=this.getMouseOnScreen(b.clientX,b.clientY))}),!1);this.domElement.addEventListener("mouseup",c(this,function(b){b.preventDefault();b.stopPropagation();f=this.STATE.NONE}),!1);window.addEventListener("keydown",c(this,function(b){if(f===this.STATE.NONE){if(b.keyCode===this.keys[this.STATE.ROTATE])f=
this.STATE.ROTATE;else if(b.keyCode===this.keys[this.STATE.ZOOM]&&!this.noZoom)f=this.STATE.ZOOM;else if(b.keyCode===this.keys[this.STATE.PAN]&&!this.noPan)f=this.STATE.PAN;f!==this.STATE.NONE&&(e=!0)}}),!1);window.addEventListener("keyup",c(this,function(){if(f!==this.STATE.NONE)f=this.STATE.NONE}),!1)};THREE.TrackballCamera.prototype=new THREE.Camera;THREE.TrackballCamera.prototype.constructor=THREE.TrackballCamera;THREE.TrackballCamera.prototype.supr=THREE.Camera.prototype;
THREE.TrackballCamera.prototype.STATE={NONE:-1,ROTATE:0,ZOOM:1,PAN:2};THREE.QuakeCamera=THREE.FirstPersonCamera;
THREE.CubeGeometry=function(b,c,e,f,h,m,k,n,t){function u(b,c,e,k,n,p,t,v){var u,x,y=f||1,z=h||1,S=n/2,U=p/2,da=w.vertices.length;if(b=="x"&&c=="y"||b=="y"&&c=="x")u="z";else if(b=="x"&&c=="z"||b=="z"&&c=="x")u="y",z=m||1;else if(b=="z"&&c=="y"||b=="y"&&c=="z")u="x",y=m||1;var Q=y+1,o=z+1;n/=y;var pa=p/z;for(x=0;x<o;x++)for(p=0;p<Q;p++){var T=new THREE.Vector3;T[b]=(p*n-S)*e;T[c]=(x*pa-U)*k;T[u]=t;w.vertices.push(new THREE.Vertex(T))}for(x=0;x<z;x++)for(p=0;p<y;p++)w.faces.push(new THREE.Face4(p+
Q*x+da,p+Q*(x+1)+da,p+1+Q*(x+1)+da,p+1+Q*x+da,null,null,v)),w.faceVertexUvs[0].push([new THREE.UV(p/y,x/z),new THREE.UV(p/y,(x+1)/z),new THREE.UV((p+1)/y,(x+1)/z),new THREE.UV((p+1)/y,x/z)])}THREE.Geometry.call(this);var w=this,v=b/2,x=c/2,p=e/2,n=n?-1:1;if(k!==void 0)if(k instanceof Array)this.materials=k;else{this.materials=[];for(var y=0;y<6;y++)this.materials.push([k])}else this.materials=[];this.sides={px:!0,nx:!0,py:!0,ny:!0,pz:!0,nz:!0};if(t!=void 0)for(var z in t)this.sides[z]!=void 0&&(this.sides[z]=
t[z]);this.sides.px&&u("z","y",1*n,-1,e,c,-v,this.materials[0]);this.sides.nx&&u("z","y",-1*n,-1,e,c,v,this.materials[1]);this.sides.py&&u("x","z",1*n,1,b,e,x,this.materials[2]);this.sides.ny&&u("x","z",1*n,-1,b,e,-x,this.materials[3]);this.sides.pz&&u("x","y",1*n,-1,b,c,p,this.materials[4]);this.sides.nz&&u("x","y",-1*n,-1,b,c,-p,this.materials[5]);(function(){for(var b=[],c=[],e=0,f=w.vertices.length;e<f;e++){for(var h=w.vertices[e],k=!1,m=0,n=b.length;m<n;m++){var p=b[m];if(h.position.x==p.position.x&&
h.position.y==p.position.y&&h.position.z==p.position.z){c[e]=m;k=!0;break}}if(!k)c[e]=b.length,b.push(new THREE.Vertex(h.position.clone()))}e=0;for(f=w.faces.length;e<f;e++)h=w.faces[e],h.a=c[h.a],h.b=c[h.b],h.c=c[h.c],h.d=c[h.d];w.vertices=b})();this.computeCentroids();this.computeFaceNormals()};THREE.CubeGeometry.prototype=new THREE.Geometry;THREE.CubeGeometry.prototype.constructor=THREE.CubeGeometry;
THREE.CylinderGeometry=function(b,c,e,f,h,m){THREE.Geometry.call(this);var b=b!=null?b:20,c=c!=null?c:20,e=e||100,k=e/2,f=f||8,h=h||1,n,t,u=[],w=[];for(t=0;t<=h;t++){var v=[],x=[],p=t/h,y=p*(c-b)+b;for(n=0;n<=f;n++){var z=n/f;this.vertices.push(new THREE.Vertex(new THREE.Vector3(y*Math.sin(z*Math.PI*2),-p*e+k,y*Math.cos(z*Math.PI*2))));v.push(this.vertices.length-1);x.push(new THREE.UV(z,p))}u.push(v);w.push(x)}for(t=0;t<h;t++)for(n=0;n<f;n++){var e=u[t][n],v=u[t+1][n],x=u[t+1][n+1],p=u[t][n+1],y=
this.vertices[e].position.clone().setY(0).normalize(),z=this.vertices[v].position.clone().setY(0).normalize(),A=this.vertices[x].position.clone().setY(0).normalize(),C=this.vertices[p].position.clone().setY(0).normalize(),E=w[t][n].clone(),G=w[t+1][n].clone(),H=w[t+1][n+1].clone(),M=w[t][n+1].clone();this.faces.push(new THREE.Face4(e,v,x,p,[y,z,A,C]));this.faceVertexUvs[0].push([E,G,H,M])}if(!m&&b>0){this.vertices.push(new THREE.Vertex(new THREE.Vector3(0,k,0)));for(n=0;n<f;n++)e=u[0][n],v=u[0][n+
1],x=this.vertices.length-1,y=new THREE.Vector3(0,1,0),z=new THREE.Vector3(0,1,0),A=new THREE.Vector3(0,1,0),E=w[0][n].clone(),G=w[0][n+1].clone(),H=new THREE.UV(G.u,0),this.faces.push(new THREE.Face3(e,v,x,[y,z,A])),this.faceVertexUvs[0].push([E,G,H])}if(!m&&c>0){this.vertices.push(new THREE.Vertex(new THREE.Vector3(0,-k,0)));for(n=0;n<f;n++)e=u[t][n+1],v=u[t][n],x=this.vertices.length-1,y=new THREE.Vector3(0,-1,0),z=new THREE.Vector3(0,-1,0),A=new THREE.Vector3(0,-1,0),E=w[t][n+1].clone(),G=w[t][n].clone(),
H=new THREE.UV(G.u,1),this.faces.push(new THREE.Face3(e,v,x,[y,z,A])),this.faceVertexUvs[0].push([E,G,H])}this.computeCentroids();this.computeFaceNormals()};THREE.CylinderGeometry.prototype=new THREE.Geometry;THREE.CylinderGeometry.prototype.constructor=THREE.CylinderGeometry;
THREE.ExtrudeGeometry=function(b,c){if(typeof b!="undefined"){THREE.Geometry.call(this);var b=b instanceof Array?b:[b],e,f=b.length,h;this.shapebb=b[f-1].getBoundingBox();for(e=0;e<f;e++)h=b[e],this.addShape(h,c);this.computeCentroids();this.computeFaceNormals()}};THREE.ExtrudeGeometry.prototype=new THREE.Geometry;THREE.ExtrudeGeometry.prototype.constructor=THREE.ExtrudeGeometry;
THREE.ExtrudeGeometry.prototype.addShape=function(b,c){function e(b,c,e){c||console.log("die");return c.clone().multiplyScalar(e).addSelf(b)}function f(b,c,e){var f=THREE.ExtrudeGeometry.__v1,h=THREE.ExtrudeGeometry.__v2,k=THREE.ExtrudeGeometry.__v3,m=THREE.ExtrudeGeometry.__v4,n=THREE.ExtrudeGeometry.__v5,o=THREE.ExtrudeGeometry.__v6;f.set(b.x-c.x,b.y-c.y);h.set(b.x-e.x,b.y-e.y);f=f.normalize();h=h.normalize();k.set(-f.y,f.x);m.set(h.y,-h.x);n.copy(b).addSelf(k);o.copy(b).addSelf(m);if(n.equals(o))return m.clone();
n.copy(c).addSelf(k);o.copy(e).addSelf(m);k=f.dot(m);m=o.subSelf(n).dot(m);k==0&&(console.log("Either infinite or no solutions!"),m==0?console.log("Its finite solutions."):console.log("Too bad, no solutions."));m/=k;if(m<0)return c=Math.atan2(c.y-b.y,c.x-b.x),b=Math.atan2(e.y-b.y,e.x-b.x),c>b&&(b+=Math.PI*2),anglec=(c+b)/2,new THREE.Vector2(-Math.cos(anglec),-Math.sin(anglec));return f.multiplyScalar(m).addSelf(n).subSelf(b).clone()}function h(b){for(D=b.length;--D>=0;){la=D;ga=D-1;ga<0&&(ga=b.length-
1);for(var c=0,e=p+w*2,c=0;c<e;c++){var f=pa*c,h=pa*(c+1),k=Z+la+f,m=Z+la+h,o=k,f=Z+ga+f,h=Z+ga+h,v=m;o+=W;f+=W;h+=W;v+=W;K.faces.push(new THREE.Face4(o,f,h,v,null,null,H));H&&(o=c/e,f=(c+1)/e,h=n+t*2,k=(K.vertices[k].position.z+t)/h,m=(K.vertices[m].position.z+t)/h,K.faceVertexUvs[0].push([new THREE.UV(k,o),new THREE.UV(m,o),new THREE.UV(m,f),new THREE.UV(k,f)]))}}}function m(b,c,e){K.vertices.push(new THREE.Vertex(new THREE.Vector3(b,c,e)))}function k(b,c,e){b+=W;c+=W;e+=W;K.faces.push(new THREE.Face3(b,
c,e,null,null,G));if(G){var f=M.maxY,h=M.maxX,k=K.vertices[c].position.x,c=K.vertices[c].position.y,m=K.vertices[e].position.x,e=K.vertices[e].position.y;K.faceVertexUvs[0].push([new THREE.UV(K.vertices[b].position.x/h,K.vertices[b].position.y/f),new THREE.UV(k/h,c/f),new THREE.UV(m/h,e/f)])}}var n=c.amount!==void 0?c.amount:100,t=c.bevelThickness!==void 0?c.bevelThickness:6,u=c.bevelSize!==void 0?c.bevelSize:t-2,w=c.bevelSegments!==void 0?c.bevelSegments:3,v=c.bevelEnabled!==void 0?c.bevelEnabled:
!0,x=c.curveSegments!==void 0?c.curveSegments:12,p=c.steps!==void 0?c.steps:1,y=c.bendPath,z=c.extrudePath,A,C=!1,E=c.useSpacedPoints!==void 0?c.useSpacedPoints:!1,G=c.material,H=c.extrudeMaterial,M=this.shapebb;if(z)A=z.getPoints(x),p=A.length,C=!0,v=!1;v||(u=t=w=0);var R,J,I,K=this,W=this.vertices.length;y&&b.addWrapPath(y);x=E?b.extractAllSpacedPoints(x):b.extractAllPoints(x);y=x.shape;x=x.holes;if(z=!THREE.Shape.Utils.isClockWise(y)){y=y.reverse();J=0;for(I=x.length;J<I;J++)R=x[J],THREE.Shape.Utils.isClockWise(R)&&
(x[J]=R.reverse());z=!1}z=THREE.Shape.Utils.triangulateShape(y,x);E=y;J=0;for(I=x.length;J<I;J++)R=x[J],y=y.concat(R);var D,S,U,da,Q,o,pa=y.length,T=z.length,ma=[];D=0;S=E.length;la=S-1;for(ga=D+1;D<S;D++,la++,ga++)la==S&&(la=0),ga==S&&(ga=0),ma[D]=f(E[D],E[la],E[ga]);var ca=[],na,ja=ma.concat();J=0;for(I=x.length;J<I;J++){R=x[J];na=[];D=0;S=R.length;la=S-1;for(ga=D+1;D<S;D++,la++,ga++)la==S&&(la=0),ga==S&&(ga=0),na[D]=f(R[D],R[la],R[ga]);ca.push(na);ja=ja.concat(na)}for(U=0;U<w;U++){da=U/w;Q=t*(1-
da);da=u*Math.sin(da*Math.PI/2);D=0;for(S=E.length;D<S;D++)o=e(E[D],ma[D],da),m(o.x,o.y,-Q);J=0;for(I=x.length;J<I;J++){R=x[J];na=ca[J];D=0;for(S=R.length;D<S;D++)o=e(R[D],na[D],da),m(o.x,o.y,-Q)}}da=u;for(D=0;D<pa;D++)o=v?e(y[D],ja[D],da):y[D],C?m(o.x,o.y+A[0].y,A[0].x):m(o.x,o.y,0);for(U=1;U<=p;U++)for(D=0;D<pa;D++)o=v?e(y[D],ja[D],da):y[D],C?m(o.x,o.y+A[U-1].y,A[U-1].x):m(o.x,o.y,n/p*U);for(U=w-1;U>=0;U--){da=U/w;Q=t*(1-da);da=u*Math.sin(da*Math.PI/2);D=0;for(S=E.length;D<S;D++)o=e(E[D],ma[D],
da),m(o.x,o.y,n+Q);J=0;for(I=x.length;J<I;J++){R=x[J];na=ca[J];D=0;for(S=R.length;D<S;D++)o=e(R[D],na[D],da),C?m(o.x,o.y+A[p-1].y,A[p-1].x+Q):m(o.x,o.y,n+Q)}}if(v){v=pa*0;for(D=0;D<T;D++)u=z[D],k(u[2]+v,u[1]+v,u[0]+v);v=pa*(p+w*2);for(D=0;D<T;D++)u=z[D],k(u[0]+v,u[1]+v,u[2]+v)}else{for(D=0;D<T;D++)u=z[D],k(u[2],u[1],u[0]);for(D=0;D<T;D++)u=z[D],k(u[0]+pa*p,u[1]+pa*p,u[2]+pa*p)}var la,ga,Z=0;h(E);Z+=E.length;J=0;for(I=x.length;J<I;J++)R=x[J],h(R),Z+=R.length};THREE.ExtrudeGeometry.__v1=new THREE.Vector2;
THREE.ExtrudeGeometry.__v2=new THREE.Vector2;THREE.ExtrudeGeometry.__v3=new THREE.Vector2;THREE.ExtrudeGeometry.__v4=new THREE.Vector2;THREE.ExtrudeGeometry.__v5=new THREE.Vector2;THREE.ExtrudeGeometry.__v6=new THREE.Vector2;
THREE.IcosahedronGeometry=function(b){function c(b,c,e){var f=Math.sqrt(b*b+c*c+e*e);return h.vertices.push(new THREE.Vertex(new THREE.Vector3(b/f,c/f,e/f)))-1}function e(b,c,e,f){f.faces.push(new THREE.Face3(b,c,e))}function f(b,e){var f=h.vertices[b].position,k=h.vertices[e].position;return c((f.x+k.x)/2,(f.y+k.y)/2,(f.z+k.z)/2)}var h=this,m=new THREE.Geometry;this.subdivisions=b||0;THREE.Geometry.call(this);b=(1+Math.sqrt(5))/2;c(-1,b,0);c(1,b,0);c(-1,-b,0);c(1,-b,0);c(0,-1,b);c(0,1,b);c(0,-1,
-b);c(0,1,-b);c(b,0,-1);c(b,0,1);c(-b,0,-1);c(-b,0,1);e(0,11,5,m);e(0,5,1,m);e(0,1,7,m);e(0,7,10,m);e(0,10,11,m);e(1,5,9,m);e(5,11,4,m);e(11,10,2,m);e(10,7,6,m);e(7,1,8,m);e(3,9,4,m);e(3,4,2,m);e(3,2,6,m);e(3,6,8,m);e(3,8,9,m);e(4,9,5,m);e(2,4,11,m);e(6,2,10,m);e(8,6,7,m);e(9,8,1,m);for(var k=0;k<this.subdivisions;k++){var b=new THREE.Geometry,n;for(n in m.faces){var t=f(m.faces[n].a,m.faces[n].b),u=f(m.faces[n].b,m.faces[n].c),w=f(m.faces[n].c,m.faces[n].a);e(m.faces[n].a,t,w,b);e(m.faces[n].b,u,
t,b);e(m.faces[n].c,w,u,b);e(t,u,w,b)}m.faces=b.faces}h.faces=m.faces;this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};THREE.IcosahedronGeometry.prototype=new THREE.Geometry;THREE.IcosahedronGeometry.prototype.constructor=THREE.IcosahedronGeometry;
THREE.LatheGeometry=function(b,c,e){THREE.Geometry.call(this);this.steps=c||12;this.angle=e||2*Math.PI;for(var c=this.angle/this.steps,e=[],f=[],h=[],m=[],k=(new THREE.Matrix4).setRotationZ(c),n=0;n<b.length;n++)this.vertices.push(new THREE.Vertex(b[n])),e[n]=b[n].clone(),f[n]=this.vertices.length-1;for(var t=0;t<=this.angle+0.001;t+=c){for(n=0;n<e.length;n++)t<this.angle?(e[n]=k.multiplyVector3(e[n].clone()),this.vertices.push(new THREE.Vertex(e[n])),h[n]=this.vertices.length-1):h=m;t==0&&(m=f);
for(n=0;n<f.length-1;n++)this.faces.push(new THREE.Face4(h[n],h[n+1],f[n+1],f[n])),this.faceVertexUvs[0].push([new THREE.UV(1-t/this.angle,n/b.length),new THREE.UV(1-t/this.angle,(n+1)/b.length),new THREE.UV(1-(t-c)/this.angle,(n+1)/b.length),new THREE.UV(1-(t-c)/this.angle,n/b.length)]);f=h;h=[]}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};THREE.LatheGeometry.prototype=new THREE.Geometry;THREE.LatheGeometry.prototype.constructor=THREE.LatheGeometry;
THREE.PlaneGeometry=function(b,c,e,f){THREE.Geometry.call(this);var h,m=b/2,k=c/2,e=e||1,f=f||1,n=e+1,t=f+1;b/=e;var u=c/f;for(h=0;h<t;h++)for(c=0;c<n;c++)this.vertices.push(new THREE.Vertex(new THREE.Vector3(c*b-m,-(h*u-k),0)));for(h=0;h<f;h++)for(c=0;c<e;c++)this.faces.push(new THREE.Face4(c+n*h,c+n*(h+1),c+1+n*(h+1),c+1+n*h)),this.faceVertexUvs[0].push([new THREE.UV(c/e,h/f),new THREE.UV(c/e,(h+1)/f),new THREE.UV((c+1)/e,(h+1)/f),new THREE.UV((c+1)/e,h/f)]);this.computeCentroids();this.computeFaceNormals()};
THREE.PlaneGeometry.prototype=new THREE.Geometry;THREE.PlaneGeometry.prototype.constructor=THREE.PlaneGeometry;
THREE.SphereGeometry=function(b,c,e){THREE.Geometry.call(this);for(var b=b||50,f,h=Math.PI,m=Math.max(3,c||8),k=Math.max(2,e||6),c=[],e=0;e<k+1;e++){f=e/k;var n=b*Math.cos(f*h),t=b*Math.sin(f*h),u=[],w=0;for(f=0;f<m;f++){var v=2*f/m,x=t*Math.sin(v*h),v=t*Math.cos(v*h);(e==0||e==k)&&f>0||(w=this.vertices.push(new THREE.Vertex(new THREE.Vector3(v,n,x)))-1);u.push(w)}c.push(u)}for(var p,y,z,h=c.length,e=0;e<h;e++)if(m=c[e].length,e>0)for(f=0;f<m;f++){u=f==m-1;k=c[e][u?0:f+1];n=c[e][u?m-1:f];t=c[e-1][u?
m-1:f];u=c[e-1][u?0:f+1];x=e/(h-1);p=(e-1)/(h-1);y=(f+1)/m;var v=f/m,w=new THREE.UV(1-y,x),x=new THREE.UV(1-v,x),v=new THREE.UV(1-v,p),A=new THREE.UV(1-y,p);e<c.length-1&&(p=this.vertices[k].position.clone(),y=this.vertices[n].position.clone(),z=this.vertices[t].position.clone(),p.normalize(),y.normalize(),z.normalize(),this.faces.push(new THREE.Face3(k,n,t,[new THREE.Vector3(p.x,p.y,p.z),new THREE.Vector3(y.x,y.y,y.z),new THREE.Vector3(z.x,z.y,z.z)])),this.faceVertexUvs[0].push([w,x,v]));e>1&&(p=
this.vertices[k].position.clone(),y=this.vertices[t].position.clone(),z=this.vertices[u].position.clone(),p.normalize(),y.normalize(),z.normalize(),this.faces.push(new THREE.Face3(k,t,u,[new THREE.Vector3(p.x,p.y,p.z),new THREE.Vector3(y.x,y.y,y.z),new THREE.Vector3(z.x,z.y,z.z)])),this.faceVertexUvs[0].push([w,v,A]))}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals();this.boundingSphere={radius:b}};THREE.SphereGeometry.prototype=new THREE.Geometry;
THREE.SphereGeometry.prototype.constructor=THREE.SphereGeometry;
THREE.TextGeometry=function(b,c){var e=(new THREE.TextPath(b,c)).toShapes();c.amount=c.height!==void 0?c.height:50;if(c.bevelThickness===void 0)c.bevelThickness=10;if(c.bevelSize===void 0)c.bevelSize=8;if(c.bevelEnabled===void 0)c.bevelEnabled=!1;if(c.bend){var f=e[e.length-1].getBoundingBox().maxX;c.bendPath=new THREE.QuadraticBezierCurve(new THREE.Vector2(0,0),new THREE.Vector2(f/2,120),new THREE.Vector2(f,0))}THREE.ExtrudeGeometry.call(this,e,c)};THREE.TextGeometry.prototype=new THREE.ExtrudeGeometry;
THREE.TextGeometry.prototype.constructor=THREE.TextGeometry;
THREE.FontUtils={faces:{},face:"helvetiker",weight:"normal",style:"normal",size:150,divisions:10,getFace:function(){return this.faces[this.face][this.weight][this.style]},getTextShapes:function(b,c){return(new TextPath(b,c)).toShapes()},loadFace:function(b){var c=b.familyName.toLowerCase();this.faces[c]=this.faces[c]||{};this.faces[c][b.cssFontWeight]=this.faces[c][b.cssFontWeight]||{};this.faces[c][b.cssFontWeight][b.cssFontStyle]=b;return this.faces[c][b.cssFontWeight][b.cssFontStyle]=b},drawText:function(b){for(var c=
this.getFace(),e=this.size/c.resolution,f=0,h=String(b).split(""),m=h.length,k=[],b=0;b<m;b++){var n=new THREE.Path,n=this.extractGlyphPoints(h[b],c,e,f,n);f+=n.offset;k.push(n.path)}return{paths:k,offset:f/2}},extractGlyphPoints:function(b,c,e,f,h){var m=[],k,n,t,u,w,v,x,p,y,z,A=c.glyphs[b]||c.glyphs[ctxt.options.fallbackCharacter];if(A){if(A.o){c=A._cachedOutline||(A._cachedOutline=A.o.split(" "));t=c.length;for(b=0;b<t;)switch(n=c[b++],n){case "m":n=c[b++]*e+f;u=c[b++]*e;m.push(new THREE.Vector2(n,
u));h.moveTo(n,u);break;case "l":n=c[b++]*e+f;u=c[b++]*e;m.push(new THREE.Vector2(n,u));h.lineTo(n,u);break;case "q":n=c[b++]*e+f;u=c[b++]*e;x=c[b++]*e+f;p=c[b++]*e;h.quadraticCurveTo(x,p,n,u);if(k=m[m.length-1]){w=k.x;v=k.y;k=1;for(divisions=this.divisions;k<=divisions;k++){var C=k/divisions,E=THREE.Shape.Utils.b2(C,w,x,n),C=THREE.Shape.Utils.b2(C,v,p,u);m.push(new THREE.Vector2(E,C))}}break;case "b":if(n=c[b++]*e+f,u=c[b++]*e,x=c[b++]*e+f,p=c[b++]*-e,y=c[b++]*e+f,z=c[b++]*-e,h.bezierCurveTo(n,u,
x,p,y,z),k=m[m.length-1]){w=k.x;v=k.y;k=1;for(divisions=this.divisions;k<=divisions;k++)C=k/divisions,E=THREE.Shape.Utils.b3(C,w,x,y,n),C=THREE.Shape.Utils.b3(C,v,p,z,u),m.push(new THREE.Vector2(E,C))}}}return{offset:A.ha*e,points:m,path:h}}}};
(function(b){var c=function(b){for(var c=b.length,h=0,m=c-1,k=0;k<c;m=k++)h+=b[m].x*b[k].y-b[k].x*b[m].y;return h*0.5};b.Triangulate=function(b,f){var h=b.length;if(h<3)return null;var m=[],k=[],n=[],t,u,w;if(c(b)>0)for(u=0;u<h;u++)k[u]=u;else for(u=0;u<h;u++)k[u]=h-1-u;var v=2*h;for(u=h-1;h>2;){if(v--<=0){console.log("Warning, unable to triangulate polygon!");if(f)return n;return m}t=u;h<=t&&(t=0);u=t+1;h<=u&&(u=0);w=u+1;h<=w&&(w=0);var x;a:{x=b;var p=t,y=u,z=w,A=h,C=k,E=void 0,G=void 0,H=void 0,
M=void 0,R=void 0,J=void 0,I=void 0,K=void 0,W=void 0,G=x[C[p]].x,H=x[C[p]].y,M=x[C[y]].x,R=x[C[y]].y,J=x[C[z]].x,I=x[C[z]].y;if(1.0E-10>(M-G)*(I-H)-(R-H)*(J-G))x=!1;else{for(E=0;E<A;E++)if(!(E==p||E==y||E==z)){var K=x[C[E]].x,W=x[C[E]].y,D=void 0,S=void 0,U=void 0,da=void 0,Q=void 0,o=void 0,pa=void 0,T=void 0,ma=void 0,ca=void 0,na=void 0,ja=void 0,D=U=Q=void 0,D=J-M,S=I-R,U=G-J,da=H-I,Q=M-G,o=R-H,pa=K-G,T=W-H,ma=K-M,ca=W-R,na=K-J,ja=W-I,D=D*ca-S*ma,Q=Q*T-o*pa,U=U*ja-da*na;if(D>=0&&U>=0&&Q>=0){x=
!1;break a}}x=!0}}if(x){m.push([b[k[t]],b[k[u]],b[k[w]]]);n.push([k[t],k[u],k[w]]);t=u;for(w=u+1;w<h;t++,w++)k[t]=k[w];h--;v=2*h}}if(f)return n;return m};b.Triangulate.area=c;return b})(THREE.FontUtils);self._typeface_js={faces:THREE.FontUtils.faces,loadFace:THREE.FontUtils.loadFace};
THREE.TorusGeometry=function(b,c,e,f,h){THREE.Geometry.call(this);this.radius=b||100;this.tube=c||40;this.segmentsR=e||8;this.segmentsT=f||6;this.arc=h||Math.PI*2;h=new THREE.Vector3;b=[];c=[];for(e=0;e<=this.segmentsR;e++)for(f=0;f<=this.segmentsT;f++){var m=f/this.segmentsT*this.arc,k=e/this.segmentsR*Math.PI*2;h.x=this.radius*Math.cos(m);h.y=this.radius*Math.sin(m);var n=new THREE.Vector3;n.x=(this.radius+this.tube*Math.cos(k))*Math.cos(m);n.y=(this.radius+this.tube*Math.cos(k))*Math.sin(m);n.z=
this.tube*Math.sin(k);this.vertices.push(new THREE.Vertex(n));b.push(new THREE.UV(f/this.segmentsT,1-e/this.segmentsR));c.push(n.clone().subSelf(h).normalize())}for(e=1;e<=this.segmentsR;e++)for(f=1;f<=this.segmentsT;f++){var h=(this.segmentsT+1)*e+f-1,m=(this.segmentsT+1)*(e-1)+f-1,k=(this.segmentsT+1)*(e-1)+f,n=(this.segmentsT+1)*e+f,t=new THREE.Face4(h,m,k,n,[c[h],c[m],c[k],c[n]]);t.normal.addSelf(c[h]);t.normal.addSelf(c[m]);t.normal.addSelf(c[k]);t.normal.addSelf(c[n]);t.normal.normalize();this.faces.push(t);
this.faceVertexUvs[0].push([b[h].clone(),b[m].clone(),b[k].clone(),b[n].clone()])}this.computeCentroids()};THREE.TorusGeometry.prototype=new THREE.Geometry;THREE.TorusGeometry.prototype.constructor=THREE.TorusGeometry;
THREE.TorusKnotGeometry=function(b,c,e,f,h,m,k){function n(b,c,e,f,h,k){c=e/f*b;e=Math.cos(c);return new THREE.Vector3(h*(2+e)*0.5*Math.cos(b),h*(2+e)*Math.sin(b)*0.5,k*h*Math.sin(c)*0.5)}THREE.Geometry.call(this);this.radius=b||200;this.tube=c||40;this.segmentsR=e||64;this.segmentsT=f||8;this.p=h||2;this.q=m||3;this.heightScale=k||1;this.grid=Array(this.segmentsR);e=new THREE.Vector3;f=new THREE.Vector3;m=new THREE.Vector3;for(b=0;b<this.segmentsR;++b){this.grid[b]=Array(this.segmentsT);for(c=0;c<
this.segmentsT;++c){var t=b/this.segmentsR*2*this.p*Math.PI,k=c/this.segmentsT*2*Math.PI,h=n(t,k,this.q,this.p,this.radius,this.heightScale),t=n(t+0.01,k,this.q,this.p,this.radius,this.heightScale);e.x=t.x-h.x;e.y=t.y-h.y;e.z=t.z-h.z;f.x=t.x+h.x;f.y=t.y+h.y;f.z=t.z+h.z;m.cross(e,f);f.cross(m,e);m.normalize();f.normalize();t=-this.tube*Math.cos(k);k=this.tube*Math.sin(k);h.x+=t*f.x+k*m.x;h.y+=t*f.y+k*m.y;h.z+=t*f.z+k*m.z;this.grid[b][c]=this.vertices.push(new THREE.Vertex(new THREE.Vector3(h.x,h.y,
h.z)))-1}}for(b=0;b<this.segmentsR;++b)for(c=0;c<this.segmentsT;++c){var f=(b+1)%this.segmentsR,m=(c+1)%this.segmentsT,h=this.grid[b][c],e=this.grid[f][c],f=this.grid[f][m],m=this.grid[b][m],k=new THREE.UV(b/this.segmentsR,c/this.segmentsT),t=new THREE.UV((b+1)/this.segmentsR,c/this.segmentsT),u=new THREE.UV((b+1)/this.segmentsR,(c+1)/this.segmentsT),w=new THREE.UV(b/this.segmentsR,(c+1)/this.segmentsT);this.faces.push(new THREE.Face4(h,e,f,m));this.faceVertexUvs[0].push([k,t,u,w])}this.computeCentroids();
this.computeFaceNormals();this.computeVertexNormals()};THREE.TorusKnotGeometry.prototype=new THREE.Geometry;THREE.TorusKnotGeometry.prototype.constructor=THREE.TorusKnotGeometry;THREE.Loader=function(b){this.statusDomElement=(this.showStatus=b)?THREE.Loader.prototype.addStatusElement():null;this.onLoadStart=function(){};this.onLoadProgress=function(){};this.onLoadComplete=function(){}};
THREE.Loader.prototype={addStatusElement:function(){var b=document.createElement("div");b.style.position="absolute";b.style.right="0px";b.style.top="0px";b.style.fontSize="0.8em";b.style.textAlign="left";b.style.background="rgba(0,0,0,0.25)";b.style.color="#fff";b.style.width="120px";b.style.padding="0.5em 0.5em 0.5em 0.5em";b.style.zIndex=1E3;b.innerHTML="Loading ...";return b},updateProgress:function(b){var c="Loaded ";c+=b.total?(100*b.loaded/b.total).toFixed(0)+"%":(b.loaded/1E3).toFixed(2)+" KB";
this.statusDomElement.innerHTML=c},extractUrlbase:function(b){b=b.split("/");b.pop();return b.join("/")},init_materials:function(b,c,e){b.materials=[];for(var f=0;f<c.length;++f)b.materials[f]=[THREE.Loader.prototype.createMaterial(c[f],e)]},hasNormals:function(b){var c,e,f=b.materials.length;for(e=0;e<f;e++)if(c=b.materials[e][0],c instanceof THREE.ShaderMaterial)return!0;return!1},createMaterial:function(b,c){function e(b){b=Math.log(b)/Math.LN2;return Math.floor(b)==b}function f(b,c){var f=new Image;
f.onload=function(){if(!e(this.width)||!e(this.height)){var c=Math.pow(2,Math.round(Math.log(this.width)/Math.LN2)),f=Math.pow(2,Math.round(Math.log(this.height)/Math.LN2));b.image.width=c;b.image.height=f;b.image.getContext("2d").drawImage(this,0,0,c,f)}else b.image=this;b.needsUpdate=!0};f.src=c}function h(b,e,h,k,m,n){var t=document.createElement("canvas");b[e]=new THREE.Texture(t);b[e].sourceFile=h;if(k){b[e].repeat.set(k[0],k[1]);if(k[0]!=1)b[e].wrapS=THREE.RepeatWrapping;if(k[1]!=1)b[e].wrapT=
THREE.RepeatWrapping}m&&b[e].offset.set(m[0],m[1]);if(n){k={repeat:THREE.RepeatWrapping,mirror:THREE.MirroredRepeatWrapping};if(k[n[0]]!==void 0)b[e].wrapS=k[n[0]];if(k[n[1]]!==void 0)b[e].wrapT=k[n[1]]}f(b[e],c+"/"+h)}function m(b){return(b[0]*255<<16)+(b[1]*255<<8)+b[2]*255}var k,n,t;n="MeshLambertMaterial";k={color:15658734,opacity:1,map:null,lightMap:null,normalMap:null,wireframe:b.wireframe};b.shading&&(b.shading=="Phong"?n="MeshPhongMaterial":b.shading=="Basic"&&(n="MeshBasicMaterial"));if(b.blending)if(b.blending==
"Additive")k.blending=THREE.AdditiveBlending;else if(b.blending=="Subtractive")k.blending=THREE.SubtractiveBlending;else if(b.blending=="Multiply")k.blending=THREE.MultiplyBlending;if(b.transparent!==void 0||b.opacity<1)k.transparent=b.transparent;if(b.depthTest!==void 0)k.depthTest=b.depthTest;if(b.vertexColors!==void 0)if(b.vertexColors=="face")k.vertexColors=THREE.FaceColors;else if(b.vertexColors)k.vertexColors=THREE.VertexColors;if(b.colorDiffuse)k.color=m(b.colorDiffuse);else if(b.DbgColor)k.color=
b.DbgColor;if(b.colorSpecular)k.specular=m(b.colorSpecular);if(b.colorAmbient)k.ambient=m(b.colorAmbient);if(b.transparency)k.opacity=b.transparency;if(b.specularCoef)k.shininess=b.specularCoef;b.mapDiffuse&&c&&h(k,"map",b.mapDiffuse,b.mapDiffuseRepeat,b.mapDiffuseOffset,b.mapDiffuseWrap);b.mapLight&&c&&h(k,"lightMap",b.mapLight,b.mapLightRepeat,b.mapLightOffset,b.mapLightWrap);b.mapNormal&&c&&h(k,"normalMap",b.mapNormal,b.mapNormalRepeat,b.mapNormalOffset,b.mapNormalWrap);b.mapSpecular&&c&&h(k,"specularMap",
b.mapSpecular,b.mapSpecularRepeat,b.mapSpecularOffset,b.mapSpecularWrap);if(b.mapNormal){var u=THREE.ShaderUtils.lib.normal,w=THREE.UniformsUtils.clone(u.uniforms),v=k.color;n=k.specular;t=k.ambient;var x=k.shininess;w.tNormal.texture=k.normalMap;if(b.mapNormalFactor)w.uNormalScale.value=b.mapNormalFactor;if(k.map)w.tDiffuse.texture=k.map,w.enableDiffuse.value=!0;if(k.specularMap)w.tSpecular.texture=k.specularMap,w.enableSpecular.value=!0;if(k.lightMap)w.tAO.texture=k.lightMap,w.enableAO.value=!0;
w.uDiffuseColor.value.setHex(v);w.uSpecularColor.value.setHex(n);w.uAmbientColor.value.setHex(t);w.uShininess.value=x;if(k.opacity)w.uOpacity.value=k.opacity;k=new THREE.ShaderMaterial({fragmentShader:u.fragmentShader,vertexShader:u.vertexShader,uniforms:w,lights:!0,fog:!0})}else k=new THREE[n](k);return k},constructor:THREE.Loader};THREE.BinaryLoader=function(b){THREE.Loader.call(this,b)};THREE.BinaryLoader.prototype=new THREE.Loader;THREE.BinaryLoader.prototype.constructor=THREE.BinaryLoader;
THREE.BinaryLoader.prototype.supr=THREE.Loader.prototype;
THREE.BinaryLoader.prototype.load=function(b){var c=b.model,e=b.callback,f=b.texture_path?b.texture_path:THREE.Loader.prototype.extractUrlbase(c),h=b.bin_path?b.bin_path:THREE.Loader.prototype.extractUrlbase(c),b=(new Date).getTime(),c=new Worker(c),m=this.showProgress?THREE.Loader.prototype.updateProgress:null;c.onmessage=function(b){THREE.BinaryLoader.prototype.loadAjaxBuffers(b.data.buffers,b.data.materials,e,h,f,m)};c.onerror=function(b){alert("worker.onerror: "+b.message+"\n"+b.data);b.preventDefault()};
c.postMessage(b)};
THREE.BinaryLoader.prototype.loadAjaxBuffers=function(b,c,e,f,h,m){var k=new XMLHttpRequest,n=f+"/"+b,t=0;k.onreadystatechange=function(){k.readyState==4?k.status==200||k.status==0?THREE.BinaryLoader.prototype.createBinModel(k.responseText,e,h,c):alert("Couldn't load ["+n+"] ["+k.status+"]"):k.readyState==3?m&&(t==0&&(t=k.getResponseHeader("Content-Length")),m({total:t,loaded:k.responseText.length})):k.readyState==2&&(t=k.getResponseHeader("Content-Length"))};k.open("GET",n,!0);k.overrideMimeType("text/plain; charset=x-user-defined");
k.setRequestHeader("Content-Type","text/plain");k.send(null)};
THREE.BinaryLoader.prototype.createBinModel=function(b,c,e,f){var h=function(c){function e(b,c){var f=w(b,c),h=w(b,c+1),k=w(b,c+2),m=w(b,c+3),n=(m<<1&255|k>>7)-127;f|=(k&127)<<16|h<<8;if(f==0&&n==-127)return 0;return(1-2*(m>>7))*(1+f*Math.pow(2,-23))*Math.pow(2,n)}function h(b,c){var e=w(b,c),f=w(b,c+1),k=w(b,c+2);return(w(b,c+3)<<24)+(k<<16)+(f<<8)+e}function t(b,c){var e=w(b,c);return(w(b,c+1)<<8)+e}function u(b,c){var e=w(b,c);return e>127?e-256:e}function w(b,c){return b.charCodeAt(c)&255}function v(c){var e,
f,k;e=h(b,c);f=h(b,c+R);k=h(b,c+J);c=t(b,c+I);C.faces.push(new THREE.Face3(e,f,k,null,null,C.materials[c]))}function x(c){var e,f,k,m,o,p;e=h(b,c);f=h(b,c+R);k=h(b,c+J);m=t(b,c+I);o=h(b,c+K);p=h(b,c+W);c=h(b,c+D);m=C.materials[m];var v=H[p*3],u=H[p*3+1];p=H[p*3+2];var w=H[c*3],L=H[c*3+1],c=H[c*3+2];C.faces.push(new THREE.Face3(e,f,k,[new THREE.Vector3(H[o*3],H[o*3+1],H[o*3+2]),new THREE.Vector3(v,u,p),new THREE.Vector3(w,L,c)],null,m))}function p(c){var e,f,k,m;e=h(b,c);f=h(b,c+S);k=h(b,c+U);m=h(b,
c+da);c=t(b,c+Q);C.faces.push(new THREE.Face4(e,f,k,m,null,null,C.materials[c]))}function y(c){var e,f,k,m,p,v,u,w;e=h(b,c);f=h(b,c+S);k=h(b,c+U);m=h(b,c+da);p=t(b,c+Q);v=h(b,c+o);u=h(b,c+pa);w=h(b,c+T);c=h(b,c+ma);p=C.materials[p];var x=H[u*3],L=H[u*3+1];u=H[u*3+2];var O=H[w*3],ha=H[w*3+1];w=H[w*3+2];var y=H[c*3],z=H[c*3+1],c=H[c*3+2];C.faces.push(new THREE.Face4(e,f,k,m,[new THREE.Vector3(H[v*3],H[v*3+1],H[v*3+2]),new THREE.Vector3(x,L,u),new THREE.Vector3(O,ha,w),new THREE.Vector3(y,z,c)],null,
p))}function z(c){var e,f,k,m;e=h(b,c);f=h(b,c+ca);k=h(b,c+na);c=M[e*2];m=M[e*2+1];e=M[f*2];var o=C.faceVertexUvs[0];f=M[f*2+1];var p=M[k*2];k=M[k*2+1];var t=[];t.push(new THREE.UV(c,m));t.push(new THREE.UV(e,f));t.push(new THREE.UV(p,k));o.push(t)}function A(c){var e,f,k,m,o,p;e=h(b,c);f=h(b,c+ja);k=h(b,c+la);m=h(b,c+ga);c=M[e*2];o=M[e*2+1];e=M[f*2];p=M[f*2+1];f=M[k*2];var t=C.faceVertexUvs[0];k=M[k*2+1];var v=M[m*2];m=M[m*2+1];var u=[];u.push(new THREE.UV(c,o));u.push(new THREE.UV(e,p));u.push(new THREE.UV(f,
k));u.push(new THREE.UV(v,m));t.push(u)}var C=this,E=0,G,H=[],M=[],R,J,I,K,W,D,S,U,da,Q,o,pa,T,ma,ca,na,ja,la,ga,Z,V,$,ea,ka,ta;THREE.Geometry.call(this);THREE.Loader.prototype.init_materials(C,f,c);G={signature:b.substr(E,8),header_bytes:w(b,E+8),vertex_coordinate_bytes:w(b,E+9),normal_coordinate_bytes:w(b,E+10),uv_coordinate_bytes:w(b,E+11),vertex_index_bytes:w(b,E+12),normal_index_bytes:w(b,E+13),uv_index_bytes:w(b,E+14),material_index_bytes:w(b,E+15),nvertices:h(b,E+16),nnormals:h(b,E+16+4),nuvs:h(b,
E+16+8),ntri_flat:h(b,E+16+12),ntri_smooth:h(b,E+16+16),ntri_flat_uv:h(b,E+16+20),ntri_smooth_uv:h(b,E+16+24),nquad_flat:h(b,E+16+28),nquad_smooth:h(b,E+16+32),nquad_flat_uv:h(b,E+16+36),nquad_smooth_uv:h(b,E+16+40)};E+=G.header_bytes;R=G.vertex_index_bytes;J=G.vertex_index_bytes*2;I=G.vertex_index_bytes*3;K=G.vertex_index_bytes*3+G.material_index_bytes;W=G.vertex_index_bytes*3+G.material_index_bytes+G.normal_index_bytes;D=G.vertex_index_bytes*3+G.material_index_bytes+G.normal_index_bytes*2;S=G.vertex_index_bytes;
U=G.vertex_index_bytes*2;da=G.vertex_index_bytes*3;Q=G.vertex_index_bytes*4;o=G.vertex_index_bytes*4+G.material_index_bytes;pa=G.vertex_index_bytes*4+G.material_index_bytes+G.normal_index_bytes;T=G.vertex_index_bytes*4+G.material_index_bytes+G.normal_index_bytes*2;ma=G.vertex_index_bytes*4+G.material_index_bytes+G.normal_index_bytes*3;ca=G.uv_index_bytes;na=G.uv_index_bytes*2;ja=G.uv_index_bytes;la=G.uv_index_bytes*2;ga=G.uv_index_bytes*3;c=G.vertex_index_bytes*3+G.material_index_bytes;ta=G.vertex_index_bytes*
4+G.material_index_bytes;Z=G.ntri_flat*c;V=G.ntri_smooth*(c+G.normal_index_bytes*3);$=G.ntri_flat_uv*(c+G.uv_index_bytes*3);ea=G.ntri_smooth_uv*(c+G.normal_index_bytes*3+G.uv_index_bytes*3);ka=G.nquad_flat*ta;c=G.nquad_smooth*(ta+G.normal_index_bytes*4);ta=G.nquad_flat_uv*(ta+G.uv_index_bytes*4);E+=function(c){for(var f,h,m,n=G.vertex_coordinate_bytes*3,o=c+G.nvertices*n;c<o;c+=n)f=e(b,c),h=e(b,c+G.vertex_coordinate_bytes),m=e(b,c+G.vertex_coordinate_bytes*2),C.vertices.push(new THREE.Vertex(new THREE.Vector3(f,
h,m)));return G.nvertices*n}(E);E+=function(c){for(var e,f,h,k=G.normal_coordinate_bytes*3,m=c+G.nnormals*k;c<m;c+=k)e=u(b,c),f=u(b,c+G.normal_coordinate_bytes),h=u(b,c+G.normal_coordinate_bytes*2),H.push(e/127,f/127,h/127);return G.nnormals*k}(E);E+=function(c){for(var f,h,m=G.uv_coordinate_bytes*2,n=c+G.nuvs*m;c<n;c+=m)f=e(b,c),h=e(b,c+G.uv_coordinate_bytes),M.push(f,h);return G.nuvs*m}(E);Z=E+Z;V=Z+V;$=V+$;ea=$+ea;ka=ea+ka;c=ka+c;ta=c+ta;(function(b){var c,e=G.vertex_index_bytes*3+G.material_index_bytes,
f=e+G.uv_index_bytes*3,h=b+G.ntri_flat_uv*f;for(c=b;c<h;c+=f)v(c),z(c+e);return h-b})(V);(function(b){var c,e=G.vertex_index_bytes*3+G.material_index_bytes+G.normal_index_bytes*3,f=e+G.uv_index_bytes*3,h=b+G.ntri_smooth_uv*f;for(c=b;c<h;c+=f)x(c),z(c+e);return h-b})($);(function(b){var c,e=G.vertex_index_bytes*4+G.material_index_bytes,f=e+G.uv_index_bytes*4,h=b+G.nquad_flat_uv*f;for(c=b;c<h;c+=f)p(c),A(c+e);return h-b})(c);(function(b){var c,e=G.vertex_index_bytes*4+G.material_index_bytes+G.normal_index_bytes*
4,f=e+G.uv_index_bytes*4,h=b+G.nquad_smooth_uv*f;for(c=b;c<h;c+=f)y(c),A(c+e);return h-b})(ta);(function(b){var c,e=G.vertex_index_bytes*3+G.material_index_bytes,f=b+G.ntri_flat*e;for(c=b;c<f;c+=e)v(c);return f-b})(E);(function(b){var c,e=G.vertex_index_bytes*3+G.material_index_bytes+G.normal_index_bytes*3,f=b+G.ntri_smooth*e;for(c=b;c<f;c+=e)x(c);return f-b})(Z);(function(b){var c,e=G.vertex_index_bytes*4+G.material_index_bytes,f=b+G.nquad_flat*e;for(c=b;c<f;c+=e)p(c);return f-b})(ea);(function(b){var c,
e=G.vertex_index_bytes*4+G.material_index_bytes+G.normal_index_bytes*4,f=b+G.nquad_smooth*e;for(c=b;c<f;c+=e)y(c);return f-b})(ka);this.computeCentroids();this.computeFaceNormals();THREE.Loader.prototype.hasNormals(this)&&this.computeTangents()};h.prototype=new THREE.Geometry;h.prototype.constructor=h;c(new h(e))};
var ColladaLoader=function(){function b(b,c,e){for(var b=Z.evaluate(b,Z,T,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null),f={},h=b.iterateNext(),k=0;h;){h=(new c).parse(h);if(h.id.length==0)h.id=e+k++;f[h.id]=h;h=b.iterateNext()}return f}function c(){var b=1E6,c=-b,e=0,f;for(f in ta)for(var h=ta[f],k=0;k<h.sampler.length;k++){var m=h.sampler[k];m.create();b=Math.min(b,m.startTime);c=Math.max(c,m.endTime);e=Math.max(e,m.input.length)}return{start:b,end:c,frames:e}}function e(b,c,f,h){b.world=b.world||
new THREE.Matrix4;b.world.copy(b.matrix);if(b.channels&&b.channels.length){var k=b.channels[0].sampler.output[f];k instanceof THREE.Matrix4&&b.world.copy(k)}h&&b.world.multiply(h,b.world);c.push(b);for(h=0;h<b.nodes.length;h++)e(b.nodes[h],c,f,b.world)}function f(b,f,h){var k=N[f.url];if(!k||!k.skin)console.log("could not find skin controller!");else if(!f.skeleton||!f.skeleton.length)console.log("could not find the skeleton for the skin!");else{var m=c(),f=$.getChildById(f.skeleton[0],!0)||$.getChildBySid(f.skeleton[0],
!0),n,o,p,t,v=new THREE.Vector3,u;for(n=0;n<b.vertices.length;n++)k.skin.bindShapeMatrix.multiplyVector3(b.vertices[n].position);for(h=0;h<m.frames;h++){var w=[],x=[];for(n=0;n<b.vertices.length;n++)x.push(new THREE.Vertex(new THREE.Vector3));e(f,w,h);n=w;o=k.skin;for(t=0;t<n.length;t++){p=n[t];u=-1;for(var y=0;y<o.joints.length;y++)if(p.sid==o.joints[y]){u=y;break}if(u>=0){y=o.invBindMatrices[u];p.invBindMatrix=y;p.skinningMatrix=new THREE.Matrix4;p.skinningMatrix.multiply(p.world,y);p.weights=[];
for(y=0;y<o.weights.length;y++)for(var z=0;z<o.weights[y].length;z++){var A=o.weights[y][z];A.joint==u&&p.weights.push(A)}}else throw"could not find joint!";}for(n=0;n<w.length;n++)for(o=0;o<w[n].weights.length;o++)p=w[n].weights[o],t=p.index,p=p.weight,u=b.vertices[t],t=x[t],v.x=u.position.x,v.y=u.position.y,v.z=u.position.z,w[n].skinningMatrix.multiplyVector3(v),t.position.x+=v.x*p,t.position.y+=v.y*p,t.position.z+=v.z*p;b.morphTargets.push({name:"target_"+h,vertices:x})}}}function h(b){var c=new THREE.Object3D,
e,k,m;c.name=b.id||"";c.matrixAutoUpdate=!1;c.matrix=b.matrix;for(m=0;m<b.controllers.length;m++){var n=N[b.controllers[m].url];switch(n.type){case "skin":if(fa[n.skin.source]){var o=new y;o.url=n.skin.source;o.instance_material=b.controllers[m].instance_material;b.geometries.push(o);e=b.controllers[m]}else if(N[n.skin.source]&&(k=n=N[n.skin.source],n.morph&&fa[n.morph.source]))o=new y,o.url=n.morph.source,o.instance_material=b.controllers[m].instance_material,b.geometries.push(o);break;case "morph":if(fa[n.morph.source])o=
new y,o.url=n.morph.source,o.instance_material=b.controllers[m].instance_material,b.geometries.push(o),k=b.controllers[m];console.log("DAE: morph-controller partially supported.")}}for(m=0;m<b.geometries.length;m++){var n=b.geometries[m],o=n.instance_material,n=fa[n.url],p={},t=0,v;if(n&&n.mesh&&n.mesh.primitives){if(c.name.length==0)c.name=n.id;if(o)for(j=0;j<o.length;j++){v=o[j];var u=ua[ra[v.target].instance_effect.url].shader;u.material.opacity=!u.material.opacity?1:u.material.opacity;v=p[v.symbol]=
u.material;t++}o=v||new THREE.MeshLambertMaterial({color:14540253,shading:THREE.FlatShading});n=n.mesh.geometry3js;if(t>1){o=new THREE.MeshFaceMaterial;for(j=0;j<n.faces.length;j++)t=n.faces[j],t.materials=[p[t.daeMaterial]]}if(e!==void 0)f(n,e),o.morphTargets=!0,o=new THREE.SkinnedMesh(n,o),o.skeleton=e.skeleton,o.skinController=N[e.url],o.skinInstanceController=e,o.name="skin_"+Aa.length,Aa.push(o);else if(k!==void 0){p=n;t=k instanceof x?N[k.url]:k;if(!t||!t.morph)console.log("could not find morph controller!");
else{t=t.morph;for(u=0;u<t.targets.length;u++){var w=fa[t.targets[u]];if(w.mesh&&w.mesh.primitives&&w.mesh.primitives.length)w=w.mesh.primitives[0].geometry,w.vertices.length===p.vertices.length&&p.morphTargets.push({name:"target_1",vertices:w.vertices})}p.morphTargets.push({name:"target_Z",vertices:p.vertices})}o.morphTargets=!0;o=new THREE.Mesh(n,o);o.name="morph_"+za.length;za.push(o)}else o=new THREE.Mesh(n,o);c.addChild(o)}}for(m=0;m<b.nodes.length;m++)c.addChild(h(b.nodes[m],b));return c}function m(){this.init_from=
this.id=""}function k(){this.type=this.name=this.id="";this.morph=this.skin=null}function n(){this.weights=this.targets=this.source=this.method=null}function t(){this.source="";this.bindShapeMatrix=null;this.invBindMatrices=[];this.joints=[];this.weights=[]}function u(){this.name=this.id="";this.nodes=[];this.scene=new THREE.Object3D}function w(){this.sid=this.name=this.id="";this.nodes=[];this.controllers=[];this.transforms=[];this.geometries=[];this.channels=[];this.matrix=new THREE.Matrix4}function v(){this.type=
this.sid="";this.data=[];this.matrix=new THREE.Matrix4}function x(){this.url="";this.skeleton=[];this.instance_material=[]}function p(){this.target=this.symbol=""}function y(){this.url="";this.instance_material=[]}function z(){this.id="";this.mesh=null}function A(b){this.geometry=b.id;this.primitives=[];this.geometry3js=this.vertices=null}function C(){}function E(){this.material="";this.count=0;this.inputs=[];this.vcount=null;this.p=[];this.geometry=new THREE.Geometry}function G(){this.source="";
this.stride=this.count=0;this.params=[]}function H(){this.input={}}function M(){this.semantic="";this.offset=0;this.source="";this.set=0}function R(b){this.id=b;this.type=null}function J(){this.name=this.id="";this.instance_effect=null}function I(){this.color=new THREE.Color(0);this.color.setRGB(Math.random(),Math.random(),Math.random());this.color.a=1;this.texcoord=this.texture=null}function K(b,c){this.type=b;this.effect=c;this.material=null}function W(b){this.effect=b;this.format=this.init_from=
null}function D(b){this.effect=b;this.mipfilter=this.magfilter=this.minfilter=this.wrap_t=this.wrap_s=this.source=null}function S(){this.name=this.id="";this.sampler=this.surface=this.shader=null}function U(){this.url=""}function da(){this.name=this.id="";this.source={};this.sampler=[];this.channel=[]}function Q(b){this.animation=b;this.target=this.source="";this.member=this.arrIndices=this.arrSyntax=this.dotSyntax=this.sid=null}function o(b){this.id="";this.animation=b;this.inputs=[];this.endTime=
this.startTime=this.interpolation=this.output=this.input=null;this.duration=0}function pa(b){var c=b.getAttribute("id");if(ea[c]!=void 0)return ea[c];ea[c]=(new R(c)).parse(b);return ea[c]}function T(b){if(b=="dae")return"http://www.collada.org/2005/11/COLLADASchema";return null}function ma(b){for(var b=na(b),c=[],e=0;e<b.length;e++)c.push(parseFloat(b[e]));return c}function ca(b){for(var b=na(b),c=[],e=0;e<b.length;e++)c.push(parseInt(b[e],10));return c}function na(b){return b.replace(/^\s+/,"").replace(/\s+$/,
"").split(/\s+/)}function ja(b,c,e){return b.hasAttribute(c)?parseInt(b.getAttribute(c),10):e}function la(b,c){if(b===void 0){for(var e="0.";e.length<c+2;)e+="0";return e}c=c||2;e=b.toString().split(".");for(e[1]=e.length>1?e[1].substr(0,c):"0";e[1].length<c;)e[1]+="0";return e.join(".")}function ga(b,c){var e="";e+=la(b.x,c)+",";e+=la(b.y,c)+",";e+=la(b.z,c);return e}var Z=null,V=null,$,ea={},ka={},ta={},N={},fa={},ra={},ua={},sa,xa=null,Ca,za,Aa,Ea=THREE.SmoothShading;m.prototype.parse=function(b){this.id=
b.getAttribute("id");for(var c=0;c<b.childNodes.length;c++){var e=b.childNodes[c];if(e.nodeName=="init_from")this.init_from=e.textContent}return this};k.prototype.parse=function(b){this.id=b.getAttribute("id");this.name=b.getAttribute("name");this.type="none";for(var c=0;c<b.childNodes.length;c++){var e=b.childNodes[c];switch(e.nodeName){case "skin":this.skin=(new t).parse(e);this.type=e.nodeName;break;case "morph":this.morph=(new n).parse(e),this.type=e.nodeName}}return this};n.prototype.parse=function(b){var c=
{},e=[],f;this.method=b.getAttribute("method");this.source=b.getAttribute("source").replace(/^#/,"");for(f=0;f<b.childNodes.length;f++){var h=b.childNodes[f];if(h.nodeType==1)switch(h.nodeName){case "source":h=(new R).parse(h);c[h.id]=h;break;case "targets":e=this.parseInputs(h);break;default:console.log(h.nodeName)}}for(f=0;f<e.length;f++)switch(b=e[f],h=c[b.source],b.semantic){case "MORPH_TARGET":this.targets=h.read();break;case "MORPH_WEIGHT":this.weights=h.read()}return this};n.prototype.parseInputs=
function(b){for(var c=[],e=0;e<b.childNodes.length;e++){var f=b.childNodes[e];if(f.nodeType==1)switch(f.nodeName){case "input":c.push((new M).parse(f))}}return c};t.prototype.parse=function(b){var c={},e,f;this.source=b.getAttribute("source").replace(/^#/,"");this.invBindMatrices=[];this.joints=[];this.weights=[];for(var h=0;h<b.childNodes.length;h++){var k=b.childNodes[h];if(k.nodeType==1)switch(k.nodeName){case "bind_shape_matrix":k=ma(k.textContent);this.bindShapeMatrix=new THREE.Matrix4;this.bindShapeMatrix.set(k[0],
k[1],k[2],k[3],k[4],k[5],k[6],k[7],k[8],k[9],k[10],k[11],k[12],k[13],k[14],k[15]);break;case "source":k=(new R).parse(k);c[k.id]=k;break;case "joints":e=k;break;case "vertex_weights":f=k;break;default:console.log(k.nodeName)}}this.parseJoints(e,c);this.parseWeights(f,c);return this};t.prototype.parseJoints=function(b,c){for(var e=0;e<b.childNodes.length;e++){var f=b.childNodes[e];if(f.nodeType==1)switch(f.nodeName){case "input":var f=(new M).parse(f),h=c[f.source];if(f.semantic=="JOINT")this.joints=
h.read();else if(f.semantic=="INV_BIND_MATRIX")this.invBindMatrices=h.read()}}};t.prototype.parseWeights=function(b,c){for(var e,f,h=[],k=0;k<b.childNodes.length;k++){var m=b.childNodes[k];if(m.nodeType==1)switch(m.nodeName){case "input":h.push((new M).parse(m));break;case "v":e=ca(m.textContent);break;case "vcount":f=ca(m.textContent)}}for(k=m=0;k<f.length;k++){for(var n=f[k],o=[],p=0;p<n;p++){for(var t={},v=0;v<h.length;v++){var u=h[v],w=e[m+u.offset];switch(u.semantic){case "JOINT":t.joint=w;break;
case "WEIGHT":t.weight=c[u.source].data[w]}}o.push(t);m+=h.length}for(p=0;p<o.length;p++)o[p].index=k;this.weights.push(o)}};u.prototype.getChildById=function(b,c){for(var e=0;e<this.nodes.length;e++){var f=this.nodes[e].getChildById(b,c);if(f)return f}return null};u.prototype.getChildBySid=function(b,c){for(var e=0;e<this.nodes.length;e++){var f=this.nodes[e].getChildBySid(b,c);if(f)return f}return null};u.prototype.parse=function(b){this.id=b.getAttribute("id");this.name=b.getAttribute("name");
this.nodes=[];for(var c=0;c<b.childNodes.length;c++){var e=b.childNodes[c];if(e.nodeType==1)switch(e.nodeName){case "node":this.nodes.push((new w).parse(e))}}return this};w.prototype.getChannelForTransform=function(b){for(var c=0;c<this.channels.length;c++){var e=this.channels[c],f=e.target.split("/");f.shift();var h=f.shift(),k=h.indexOf(".")>=0,m=h.indexOf("(")>=0,n;if(k)f=h.split("."),h=f.shift(),f.shift();else if(m){n=h.split("(");h=n.shift();for(f=0;f<n.length;f++)n[f]=parseInt(n[f].replace(/\)/,
""))}if(h==b)return e.info={sid:h,dotSyntax:k,arrSyntax:m,arrIndices:n},e}return null};w.prototype.getChildById=function(b,c){if(this.id==b)return this;if(c)for(var e=0;e<this.nodes.length;e++){var f=this.nodes[e].getChildById(b,c);if(f)return f}return null};w.prototype.getChildBySid=function(b,c){if(this.sid==b)return this;if(c)for(var e=0;e<this.nodes.length;e++){var f=this.nodes[e].getChildBySid(b,c);if(f)return f}return null};w.prototype.getTransformBySid=function(b){for(var c=0;c<this.transforms.length;c++)if(this.transforms[c].sid==
b)return this.transforms[c];return null};w.prototype.parse=function(b){var c;this.id=b.getAttribute("id");this.sid=b.getAttribute("sid");this.name=b.getAttribute("name");this.type=b.getAttribute("type");this.type=this.type=="JOINT"?this.type:"NODE";this.nodes=[];this.transforms=[];this.geometries=[];this.controllers=[];this.matrix=new THREE.Matrix4;for(var e=0;e<b.childNodes.length;e++)if(c=b.childNodes[e],c.nodeType==1)switch(c.nodeName){case "node":this.nodes.push((new w).parse(c));break;case "instance_camera":break;
case "instance_controller":this.controllers.push((new x).parse(c));break;case "instance_geometry":this.geometries.push((new y).parse(c));break;case "instance_light":break;case "instance_node":c=c.getAttribute("url").replace(/^#/,"");(c=Z.evaluate(".//dae:library_nodes//dae:node[@id='"+c+"']",Z,T,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null).iterateNext())&&this.nodes.push((new w).parse(c));break;case "rotate":case "translate":case "scale":case "matrix":case "lookat":case "skew":this.transforms.push((new v).parse(c));
break;case "extra":break;default:console.log(c.nodeName)}b=[];e=1E6;c=-1E6;for(var f in ta)for(var h=ta[f],k=0;k<h.channel.length;k++){var m=h.channel[k],n=h.sampler[k];f=m.target.split("/")[0];if(f==this.id)n.create(),m.sampler=n,e=Math.min(e,n.startTime),c=Math.max(c,n.endTime),b.push(m)}if(b.length)this.startTime=e,this.endTime=c;if((this.channels=b)&&this.channels.length){f=1E7;for(i=0;i<this.channels.length;i++){b=this.channels[i].sampler;for(e=0;e<b.input.length-1;e++)f=Math.min(f,b.input[e+
1]-b.input[e])}e=[];for(b=this.startTime;b<this.endTime;b+=f){c=b;for(var h={},o=k=void 0,k=0;k<this.channels.length;k++)o=this.channels[k],h[o.sid]=o;m=new THREE.Matrix4;for(k=0;k<this.transforms.length;k++)if(n=this.transforms[k],o=h[n.sid],o!==void 0){for(var p=o.sampler,t,o=0;o<p.input.length-1;o++)if(p.input[o+1]>c){t=p.output[o];break}m=t!==void 0?t instanceof THREE.Matrix4?m.multiply(m,t):m.multiply(m,n.matrix):m.multiply(m,n.matrix)}else m=m.multiply(m,n.matrix);c=m;e.push({time:b,pos:[c.n14,
c.n24,c.n34],rotq:[0,0,0,1],scl:[1,1,1]})}this.keys=e}this.updateMatrix();return this};w.prototype.updateMatrix=function(){this.matrix.identity();for(var b=0;b<this.transforms.length;b++)this.matrix.multiply(this.matrix,this.transforms[b].matrix)};v.prototype.parse=function(b){this.sid=b.getAttribute("sid");this.type=b.nodeName;this.data=ma(b.textContent);this.updateMatrix();return this};v.prototype.updateMatrix=function(){var b=0;this.matrix.identity();switch(this.type){case "matrix":this.matrix.set(this.data[0],
this.data[1],this.data[2],this.data[3],this.data[4],this.data[5],this.data[6],this.data[7],this.data[8],this.data[9],this.data[10],this.data[11],this.data[12],this.data[13],this.data[14],this.data[15]);break;case "translate":this.matrix.setTranslation(this.data[0],this.data[1],this.data[2]);break;case "rotate":b=this.data[3]*(Math.PI/180);this.matrix.setRotationAxis(new THREE.Vector3(this.data[0],this.data[1],this.data[2]),b);break;case "scale":this.matrix.setScale(this.data[0],this.data[1],this.data[2])}return this.matrix};
x.prototype.parse=function(b){this.url=b.getAttribute("url").replace(/^#/,"");this.skeleton=[];this.instance_material=[];for(var c=0;c<b.childNodes.length;c++){var e=b.childNodes[c];if(e.nodeType==1)switch(e.nodeName){case "skeleton":this.skeleton.push(e.textContent.replace(/^#/,""));break;case "bind_material":if(e=Z.evaluate(".//dae:instance_material",e,T,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null))for(var f=e.iterateNext();f;)this.instance_material.push((new p).parse(f)),f=e.iterateNext()}}return this};
p.prototype.parse=function(b){this.symbol=b.getAttribute("symbol");this.target=b.getAttribute("target").replace(/^#/,"");return this};y.prototype.parse=function(b){this.url=b.getAttribute("url").replace(/^#/,"");this.instance_material=[];for(var c=0;c<b.childNodes.length;c++){var e=b.childNodes[c];if(e.nodeType==1&&e.nodeName=="bind_material"){if(b=Z.evaluate(".//dae:instance_material",e,T,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null))for(c=b.iterateNext();c;)this.instance_material.push((new p).parse(c)),
c=b.iterateNext();break}}return this};z.prototype.parse=function(b){this.id=b.getAttribute("id");for(var c=0;c<b.childNodes.length;c++){var e=b.childNodes[c];switch(e.nodeName){case "mesh":this.mesh=(new A(this)).parse(e)}}return this};A.prototype.parse=function(b){function c(b,e){var f=ga(b.position);h[f]===void 0&&(h[f]={v:b,index:e});return h[f]}this.primitives=[];var e;for(e=0;e<b.childNodes.length;e++){var f=b.childNodes[e];switch(f.nodeName){case "source":pa(f);break;case "vertices":this.vertices=
(new H).parse(f);break;case "triangles":this.primitives.push((new E).parse(f));break;case "polygons":console.warn("polygon holes not yet supported!");case "polylist":this.primitives.push((new C).parse(f))}}var h={};this.geometry3js=new THREE.Geometry;f=ea[this.vertices.input.POSITION.source].data;for(b=e=0;e<f.length;e+=3,b++){var k=new THREE.Vertex(new THREE.Vector3(f[e],f[e+1],f[e+2]));c(k,b);this.geometry3js.vertices.push(k)}for(e=0;e<this.primitives.length;e++)primitive=this.primitives[e],primitive.setVertices(this.vertices),
this.handlePrimitive(primitive,this.geometry3js,h);this.geometry3js.computeCentroids();this.geometry3js.computeFaceNormals();this.geometry3js.computeVertexNormals();this.geometry3js.computeBoundingBox();return this};A.prototype.handlePrimitive=function(b,c,e){var f=0,h,k,m=b.p,n=b.inputs,o,p,t,v=0,u=3,w=[];for(h=0;h<n.length;h++)o=n[h],o.semantic=="TEXCOORD"&&w.push(o.set);for(;f<m.length;){var x=[],y=[],z={};b.vcount&&(u=b.vcount[v++]);for(h=0;h<u;h++)for(k=0;k<n.length;k++)switch(o=n[k],source=
ea[o.source],p=m[f+h*n.length+o.offset],numParams=source.accessor.params.length,t=p*numParams,o.semantic){case "VERTEX":o=ga(c.vertices[p].position);x.push(e[o].index);break;case "NORMAL":y.push(new THREE.Vector3(source.data[t+0],source.data[t+1],source.data[t+2]));break;case "TEXCOORD":z[o.set]===void 0&&(z[o.set]=[]),z[o.set].push(new THREE.UV(source.data[t+0],source.data[t+1]))}k=new THREE.Face3(x[0],x[1],x[2],[y[0],y[1],y[2]]);k.daeMaterial=b.material;c.faces.push(k);for(k=0;k<w.length;k++)o=
z[w[k]],c.faceVertexUvs[k].push([o[0],o[1],o[2]]);if(u>3)for(h=2;h<x.length-1;h++){k=new THREE.Face3(x[0],x[h],x[h+1],[y[0],y[h],y[h+1]]);k.daeMaterial=b.material;c.faces.push(k);for(k=0;k<w.length;k++)o=z[w[k]],c.faceVertexUvs[k].push([o[0],o[h],o[h+1]])}f+=n.length*u}};C.prototype=new E;C.prototype.constructor=C;E.prototype.setVertices=function(b){for(var c=0;c<this.inputs.length;c++)if(this.inputs[c].source==b.id)this.inputs[c].source=b.input.POSITION.source};E.prototype.parse=function(b){this.inputs=
[];this.material=b.getAttribute("material");this.count=ja(b,"count",0);for(var c=0;c<b.childNodes.length;c++){var e=b.childNodes[c];switch(e.nodeName){case "input":this.inputs.push((new M).parse(b.childNodes[c]));break;case "vcount":this.vcount=ca(e.textContent);break;case "p":this.p=ca(e.textContent)}}return this};G.prototype.parse=function(b){this.params=[];this.source=b.getAttribute("source");this.count=ja(b,"count",0);this.stride=ja(b,"stride",0);for(var c=0;c<b.childNodes.length;c++){var e=b.childNodes[c];
if(e.nodeName=="param"){var f={};f.name=e.getAttribute("name");f.type=e.getAttribute("type");this.params.push(f)}}return this};H.prototype.parse=function(b){this.id=b.getAttribute("id");for(var c=0;c<b.childNodes.length;c++)b.childNodes[c].nodeName=="input"&&(input=(new M).parse(b.childNodes[c]),this.input[input.semantic]=input);return this};M.prototype.parse=function(b){this.semantic=b.getAttribute("semantic");this.source=b.getAttribute("source").replace(/^#/,"");this.set=ja(b,"set",-1);this.offset=
ja(b,"offset",0);if(this.semantic=="TEXCOORD"&&this.set<0)this.set=0;return this};R.prototype.parse=function(b){this.id=b.getAttribute("id");for(var c=0;c<b.childNodes.length;c++){var e=b.childNodes[c];switch(e.nodeName){case "bool_array":for(var f=na(e.textContent),h=[],k=0;k<f.length;k++)h.push(f[k]=="true"||f[k]=="1"?!0:!1);this.data=h;this.type=e.nodeName;break;case "float_array":this.data=ma(e.textContent);this.type=e.nodeName;break;case "int_array":this.data=ca(e.textContent);this.type=e.nodeName;
break;case "IDREF_array":case "Name_array":this.data=na(e.textContent);this.type=e.nodeName;break;case "technique_common":for(f=0;f<e.childNodes.length;f++)if(e.childNodes[f].nodeName=="accessor"){this.accessor=(new G).parse(e.childNodes[f]);break}}}return this};R.prototype.read=function(){var b=[],c=this.accessor.params[0];switch(c.type){case "IDREF":case "Name":case "float":return this.data;case "float4x4":for(c=0;c<this.data.length;c+=16){var e=this.data.slice(c,c+16),f=new THREE.Matrix4;f.set(e[0],
e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]);b.push(f)}break;default:console.log("Dae::Source:read dont know how to read "+c.type)}return b};J.prototype.parse=function(b){this.id=b.getAttribute("id");this.name=b.getAttribute("name");for(var c=0;c<b.childNodes.length;c++)if(b.childNodes[c].nodeName=="instance_effect"){this.instance_effect=(new U).parse(b.childNodes[c]);break}return this};I.prototype.isColor=function(){return this.texture==null};I.prototype.isTexture=
function(){return this.texture!=null};I.prototype.parse=function(b){for(var c=0;c<b.childNodes.length;c++){var e=b.childNodes[c];if(e.nodeType==1)switch(e.nodeName){case "color":e=ma(e.textContent);this.color=new THREE.Color(0);this.color.setRGB(e[0],e[1],e[2]);this.color.a=e[3];break;case "texture":this.texture=e.getAttribute("texture"),this.texcoord=e.getAttribute("texcoord")}}return this};K.prototype.parse=function(b){for(var c=0;c<b.childNodes.length;c++){var e=b.childNodes[c];if(e.nodeType==
1)switch(e.nodeName){case "ambient":case "emission":case "diffuse":case "specular":case "transparent":this[e.nodeName]=(new I).parse(e);break;case "shininess":case "reflectivity":case "transparency":var f;f=Z.evaluate(".//dae:float",e,T,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null);for(var h=f.iterateNext(),k=[];h;)k.push(h),h=f.iterateNext();f=k;f.length>0&&(this[e.nodeName]=parseFloat(f[0].textContent))}}this.create();return this};K.prototype.create=function(){var b={},c=this.transparency!==void 0&&
this.transparency<1,e;for(e in this)switch(e){case "ambient":case "emission":case "diffuse":case "specular":var f=this[e];if(f instanceof I)if(f.isTexture()){if(this.effect.sampler&&this.effect.surface&&this.effect.sampler.source==this.effect.surface.sid&&(f=ka[this.effect.surface.init_from]))b.map=THREE.ImageUtils.loadTexture(Ca+f.init_from),b.map.wrapS=THREE.RepeatWrapping,b.map.wrapT=THREE.RepeatWrapping,b.map.repeat.x=1,b.map.repeat.y=-1}else e=="diffuse"?b.color=f.color.getHex():c||(b[e]=f.color.getHex());
break;case "shininess":case "reflectivity":b[e]=this[e];break;case "transparency":if(c)b.transparent=!0,b.opacity=this[e],c=!0}b.shading=Ea;return this.material=new THREE.MeshLambertMaterial(b)};W.prototype.parse=function(b){for(var c=0;c<b.childNodes.length;c++){var e=b.childNodes[c];if(e.nodeType==1)switch(e.nodeName){case "init_from":this.init_from=e.textContent;break;case "format":this.format=e.textContent;break;default:console.log("unhandled Surface prop: "+e.nodeName)}}return this};D.prototype.parse=
function(b){for(var c=0;c<b.childNodes.length;c++){var e=b.childNodes[c];if(e.nodeType==1)switch(e.nodeName){case "source":this.source=e.textContent;break;case "minfilter":this.minfilter=e.textContent;break;case "magfilter":this.magfilter=e.textContent;break;case "mipfilter":this.mipfilter=e.textContent;break;case "wrap_s":this.wrap_s=e.textContent;break;case "wrap_t":this.wrap_t=e.textContent;break;default:console.log("unhandled Sampler2D prop: "+e.nodeName)}}return this};S.prototype.create=function(){if(this.shader==
null)return null};S.prototype.parse=function(b){this.id=b.getAttribute("id");this.name=b.getAttribute("name");this.shader=null;for(var c=0;c<b.childNodes.length;c++){var e=b.childNodes[c];if(e.nodeType==1)switch(e.nodeName){case "profile_COMMON":this.parseTechnique(this.parseProfileCOMMON(e))}}return this};S.prototype.parseNewparam=function(b){for(var c=b.getAttribute("sid"),e=0;e<b.childNodes.length;e++){var f=b.childNodes[e];if(f.nodeType==1)switch(f.nodeName){case "surface":this.surface=(new W(this)).parse(f);
this.surface.sid=c;break;case "sampler2D":this.sampler=(new D(this)).parse(f);this.sampler.sid=c;break;case "extra":break;default:console.log(f.nodeName)}}};S.prototype.parseProfileCOMMON=function(b){for(var c,e=0;e<b.childNodes.length;e++){var f=b.childNodes[e];if(f.nodeType==1)switch(f.nodeName){case "profile_COMMON":this.parseProfileCOMMON(f);break;case "technique":c=f;break;case "newparam":this.parseNewparam(f);break;case "extra":break;default:console.log(f.nodeName)}}return c};S.prototype.parseTechnique=
function(b){for(var c=0;c<b.childNodes.length;c++){var e=b.childNodes[c];if(e.nodeType==1)switch(e.nodeName){case "lambert":case "blinn":case "phong":this.shader=(new K(e.nodeName,this)).parse(e)}}};U.prototype.parse=function(b){this.url=b.getAttribute("url").replace(/^#/,"");return this};da.prototype.parse=function(b){this.id=b.getAttribute("id");this.name=b.getAttribute("name");this.source={};for(var c=0;c<b.childNodes.length;c++){var e=b.childNodes[c];if(e.nodeType==1)switch(e.nodeName){case "source":e=
(new R).parse(e);this.source[e.id]=e;break;case "sampler":this.sampler.push((new o(this)).parse(e));break;case "channel":this.channel.push((new Q(this)).parse(e))}}return this};Q.prototype.parse=function(b){this.source=b.getAttribute("source").replace(/^#/,"");this.target=b.getAttribute("target");var c=this.target.split("/");c.shift();var b=c.shift(),e=b.indexOf(".")>=0,f=b.indexOf("(")>=0,h,k;if(e)c=b.split("."),b=c.shift(),k=c.shift();else if(f){h=b.split("(");b=h.shift();for(c=0;c<h.length;c++)h[c]=
parseInt(h[c].replace(/\)/,""))}this.sid=b;this.dotSyntax=e;this.arrSyntax=f;this.arrIndices=h;this.member=k;return this};o.prototype.parse=function(b){this.id=b.getAttribute("id");this.inputs=[];for(var c=0;c<b.childNodes.length;c++){var e=b.childNodes[c];if(e.nodeType==1)switch(e.nodeName){case "input":this.inputs.push((new M).parse(e))}}return this};o.prototype.create=function(){for(var b=0;b<this.inputs.length;b++){var c=this.inputs[b],e=this.animation.source[c.source];switch(c.semantic){case "INPUT":this.input=
e.read();break;case "OUTPUT":this.output=e.read();break;case "INTERPOLATION":this.interpolation=e.read();break;case "IN_TANGENT":break;case "OUT_TANGENT":break;default:console.log(c.semantic)}}this.duration=this.endTime=this.startTime=0;if(this.input.length){this.startTime=1E8;this.endTime=-1E8;for(b=0;b<this.input.length;b++)this.startTime=Math.min(this.startTime,this.input[b]),this.endTime=Math.max(this.endTime,this.input[b]);this.duration=this.endTime-this.startTime}};return{load:function(e,f){if(document.implementation&&
document.implementation.createDocument){document.implementation.createDocument("http://www.collada.org/2005/11/COLLADASchema","COLLADA",null);e+="?rnd="+Math.random();var n=new XMLHttpRequest;n.overrideMimeType&&n.overrideMimeType("text/xml");n.onreadystatechange=function(){if(n.readyState==4&&(n.status==0||n.status==200)){xa=f;var o,p=e;Z=n.responseXML;o=xa;p!==void 0&&(p=p.split("/"),p.pop(),Ca=p.join("/")+"/");ka=b("//dae:library_images/dae:image",m,"image");ra=b("//dae:library_materials/dae:material",
J,"material");ua=b("//dae:library_effects/dae:effect",S,"effect");fa=b("//dae:library_geometries/dae:geometry",z,"geometry");N=b("//dae:library_controllers/dae:controller",k,"controller");ta=b("//dae:library_animations/dae:animation",da,"animation");sa=b(".//dae:library_visual_scenes/dae:visual_scene",u,"visual_scene");za=[];Aa=[];(p=Z.evaluate(".//dae:scene/dae:instance_visual_scene",Z,T,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null).iterateNext())?(p=p.getAttribute("url").replace(/^#/,""),$=sa[p]):
$=null;V=new THREE.Object3D;for(p=0;p<$.nodes.length;p++)V.addChild(h($.nodes[p]));c();for(var t in ta);t={scene:V,morphs:za,skins:Aa,dae:{images:ka,materials:ra,effects:ua,geometries:fa,controllers:N,animations:ta,visualScenes:sa,scene:$}};o&&o(t)}};n.open("GET",e,!0);n.send(null)}else alert("Don't know how to parse XML!")},setPreferredShading:function(b){Ea=b},applySkin:f,geometries:fa}};THREE.JSONLoader=function(b){THREE.Loader.call(this,b)};THREE.JSONLoader.prototype=new THREE.Loader;
THREE.JSONLoader.prototype.constructor=THREE.JSONLoader;THREE.JSONLoader.prototype.supr=THREE.Loader.prototype;THREE.JSONLoader.prototype.load=function(b){var c=this,e=b.model,f=b.callback,h=b.texture_path?b.texture_path:this.extractUrlbase(e),b=new Worker(e);b.onmessage=function(b){c.createModel(b.data,f,h);c.onLoadComplete()};this.onLoadStart();b.postMessage((new Date).getTime())};
THREE.JSONLoader.prototype.createModel=function(b,c,e){var f=new THREE.Geometry,h=b.scale!==void 0?1/b.scale:1;this.init_materials(f,b.materials,e);(function(c){if(b.version===void 0||b.version!=2)console.error("Deprecated file format.");else{var e,h,t,u,w,v,x,p,y,z,A,C,E,G,H=b.faces;v=b.vertices;var M=b.normals,R=b.colors,J=0;for(e=0;e<b.uvs.length;e++)b.uvs[e].length&&J++;for(e=0;e<J;e++)f.faceUvs[e]=[],f.faceVertexUvs[e]=[];u=0;for(w=v.length;u<w;)x=new THREE.Vertex,x.position.x=v[u++]*c,x.position.y=
v[u++]*c,x.position.z=v[u++]*c,f.vertices.push(x);u=0;for(w=H.length;u<w;){c=H[u++];v=c&1;t=c&2;e=c&4;h=c&8;p=c&16;x=c&32;z=c&64;c&=128;v?(A=new THREE.Face4,A.a=H[u++],A.b=H[u++],A.c=H[u++],A.d=H[u++],v=4):(A=new THREE.Face3,A.a=H[u++],A.b=H[u++],A.c=H[u++],v=3);if(t)t=H[u++],A.materials=f.materials[t];t=f.faces.length;if(e)for(e=0;e<J;e++)C=b.uvs[e],y=H[u++],G=C[y*2],y=C[y*2+1],f.faceUvs[e][t]=new THREE.UV(G,y);if(h)for(e=0;e<J;e++){C=b.uvs[e];E=[];for(h=0;h<v;h++)y=H[u++],G=C[y*2],y=C[y*2+1],E[h]=
new THREE.UV(G,y);f.faceVertexUvs[e][t]=E}if(p)p=H[u++]*3,h=new THREE.Vector3,h.x=M[p++],h.y=M[p++],h.z=M[p],A.normal=h;if(x)for(e=0;e<v;e++)p=H[u++]*3,h=new THREE.Vector3,h.x=M[p++],h.y=M[p++],h.z=M[p],A.vertexNormals.push(h);if(z)x=H[u++],x=new THREE.Color(R[x]),A.color=x;if(c)for(e=0;e<v;e++)x=H[u++],x=new THREE.Color(R[x]),A.vertexColors.push(x);f.faces.push(A)}}})(h);(function(){var c,e,h,t;if(b.skinWeights){c=0;for(e=b.skinWeights.length;c<e;c+=2)h=b.skinWeights[c],t=b.skinWeights[c+1],f.skinWeights.push(new THREE.Vector4(h,
t,0,0))}if(b.skinIndices){c=0;for(e=b.skinIndices.length;c<e;c+=2)h=b.skinIndices[c],t=b.skinIndices[c+1],f.skinIndices.push(new THREE.Vector4(h,t,0,0))}f.bones=b.bones;f.animation=b.animation})();(function(c){if(b.morphTargets!==void 0){var e,h,t,u,w,v,x,p,y;e=0;for(h=b.morphTargets.length;e<h;e++){f.morphTargets[e]={};f.morphTargets[e].name=b.morphTargets[e].name;f.morphTargets[e].vertices=[];p=f.morphTargets[e].vertices;y=b.morphTargets[e].vertices;t=0;for(u=y.length;t<u;t+=3)w=y[t]*c,v=y[t+1]*
c,x=y[t+2]*c,p.push(new THREE.Vertex(new THREE.Vector3(w,v,x)))}}if(b.morphColors!==void 0){e=0;for(h=b.morphColors.length;e<h;e++){f.morphColors[e]={};f.morphColors[e].name=b.morphColors[e].name;f.morphColors[e].colors=[];u=f.morphColors[e].colors;w=b.morphColors[e].colors;c=0;for(t=w.length;c<t;c+=3)v=new THREE.Color(16755200),v.setRGB(w[c],w[c+1],w[c+2]),u.push(v)}}})(h);(function(){if(b.edges!==void 0){var c,e,h;for(c=0;c<b.edges.length;c+=2)e=b.edges[c],h=b.edges[c+1],f.edges.push(new THREE.Edge(f.vertices[e],
f.vertices[h],e,h))}})();f.computeCentroids();f.computeFaceNormals();this.hasNormals(f)&&f.computeTangents();c(f)};THREE.SceneLoader=function(){this.onLoadStart=function(){};this.onLoadProgress=function(){};this.onLoadComplete=function(){};this.callbackSync=function(){};this.callbackProgress=function(){}};
THREE.SceneLoader.prototype={load:function(b,c){var e=this,f=new Worker(b);f.postMessage(0);var h=THREE.Loader.prototype.extractUrlbase(b);f.onmessage=function(b){function f(b,c){return c=="relativeToHTML"?b:h+"/"+b}function n(){for(p in S.objects)if(!T.objects[p])if(E=S.objects[p],E.geometry!==void 0){if(R=T.geometries[E.geometry]){var b=!1;W=[];for(ca=0;ca<E.materials.length;ca++)W[ca]=T.materials[E.materials[ca]],b=W[ca]instanceof THREE.ShaderMaterial;b&&R.computeTangents();G=E.position;r=E.rotation;
q=E.quaternion;s=E.scale;q=0;W.length==0&&(W[0]=new THREE.MeshFaceMaterial);W.length>1&&(W=[new THREE.MeshFaceMaterial]);object=new THREE.Mesh(R,W);object.name=p;object.position.set(G[0],G[1],G[2]);q?(object.quaternion.set(q[0],q[1],q[2],q[3]),object.useQuaternion=!0):object.rotation.set(r[0],r[1],r[2]);object.scale.set(s[0],s[1],s[2]);object.visible=E.visible;T.scene.addObject(object);T.objects[p]=object;E.meshCollider&&(b=THREE.CollisionUtils.MeshColliderWBox(object),T.scene.collisions.colliders.push(b));
if(E.castsShadow)b=new THREE.ShadowVolume(R),T.scene.addChild(b),b.position=object.position,b.rotation=object.rotation,b.scale=object.scale;E.trigger&&E.trigger.toLowerCase()!="none"&&(b={type:E.trigger,object:E},T.triggers[object.name]=b)}}else G=E.position,r=E.rotation,q=E.quaternion,s=E.scale,q=0,object=new THREE.Object3D,object.name=p,object.position.set(G[0],G[1],G[2]),q?(object.quaternion.set(q[0],q[1],q[2],q[3]),object.useQuaternion=!0):object.rotation.set(r[0],r[1],r[2]),object.scale.set(s[0],
s[1],s[2]),object.visible=E.visible!==void 0?E.visible:!1,T.scene.addObject(object),T.objects[p]=object,T.empties[p]=object,E.trigger&&E.trigger.toLowerCase()!="none"&&(b={type:E.trigger,object:E},T.triggers[object.name]=b)}function t(b){return function(c){T.geometries[b]=c;n();da-=1;e.onLoadComplete();w()}}function u(b){return function(c){T.geometries[b]=c}}function w(){e.callbackProgress({totalModels:o,totalTextures:pa,loadedModels:o-da,loadedTextures:pa-Q},T);e.onLoadProgress();da==0&&Q==0&&c(T)}
var v,x,p,y,z,A,C,E,G,H,M,R,J,I,K,W,D,S,U,da,Q,o,pa,T;S=b.data;K=new THREE.BinaryLoader;U=new THREE.JSONLoader;Q=da=0;T={scene:new THREE.Scene,geometries:{},materials:{},textures:{},objects:{},cameras:{},lights:{},fogs:{},triggers:{},empties:{}};b=!1;for(p in S.objects)if(E=S.objects[p],E.meshCollider){b=!0;break}if(b)T.scene.collisions=new THREE.CollisionSystem;if(S.transform){b=S.transform.position;H=S.transform.rotation;var ma=S.transform.scale;b&&T.scene.position.set(b[0],b[1],b[2]);H&&T.scene.rotation.set(H[0],
H[1],H[2]);ma&&T.scene.scale.set(ma[0],ma[1],ma[2]);(b||H||ma)&&T.scene.updateMatrix()}b=function(){Q-=1;w();e.onLoadComplete()};for(z in S.cameras){H=S.cameras[z];if(H.type=="perspective")J=new THREE.Camera(H.fov,H.aspect,H.near,H.far);else if(H.type=="ortho")J=new THREE.Camera,J.projectionMatrix=THREE.Matrix4.makeOrtho(H.left,H.right,H.top,H.bottom,H.near,H.far);G=H.position;H=H.target;J.position.set(G[0],G[1],G[2]);J.target.position.set(H[0],H[1],H[2]);T.cameras[z]=J}for(y in S.lights)z=S.lights[y],
J=z.color!==void 0?z.color:16777215,H=z.intensity!==void 0?z.intensity:1,z.type=="directional"?(G=z.direction,D=new THREE.DirectionalLight(J,H),D.position.set(G[0],G[1],G[2]),D.position.normalize()):z.type=="point"?(G=z.position,d=z.distance,D=new THREE.PointLight(J,H,d),D.position.set(G[0],G[1],G[2])):z.type=="ambient"&&(D=new THREE.AmbientLight(J)),T.scene.addLight(D),T.lights[y]=D;for(A in S.fogs)y=S.fogs[A],y.type=="linear"?I=new THREE.Fog(0,y.near,y.far):y.type=="exp2"&&(I=new THREE.FogExp2(0,
y.density)),H=y.color,I.color.setRGB(H[0],H[1],H[2]),T.fogs[A]=I;if(T.cameras&&S.defaults.camera)T.currentCamera=T.cameras[S.defaults.camera];if(T.fogs&&S.defaults.fog)T.scene.fog=T.fogs[S.defaults.fog];H=S.defaults.bgcolor;T.bgColor=new THREE.Color;T.bgColor.setRGB(H[0],H[1],H[2]);T.bgColorAlpha=S.defaults.bgalpha;for(v in S.geometries)if(A=S.geometries[v],A.type=="bin_mesh"||A.type=="ascii_mesh")da+=1,e.onLoadStart();o=da;for(v in S.geometries)A=S.geometries[v],A.type=="cube"?(R=new THREE.CubeGeometry(A.width,
A.height,A.depth,A.segmentsWidth,A.segmentsHeight,A.segmentsDepth,null,A.flipped,A.sides),T.geometries[v]=R):A.type=="plane"?(R=new THREE.PlaneGeometry(A.width,A.height,A.segmentsWidth,A.segmentsHeight),T.geometries[v]=R):A.type=="sphere"?(R=new THREE.SphereGeometry(A.radius,A.segmentsWidth,A.segmentsHeight),T.geometries[v]=R):A.type=="cylinder"?(R=new THREE.CylinderGeometry(A.topRad,A.botRad,A.height,A.radSegs,A.heightSegs),T.geometries[v]=R):A.type=="torus"?(R=new THREE.TorusGeometry(A.radius,A.tube,
A.segmentsR,A.segmentsT),T.geometries[v]=R):A.type=="icosahedron"?(R=new THREE.IcosahedronGeometry(A.subdivisions),T.geometries[v]=R):A.type=="bin_mesh"?K.load({model:f(A.url,S.urlBaseType),callback:t(v)}):A.type=="ascii_mesh"?U.load({model:f(A.url,S.urlBaseType),callback:t(v)}):A.type=="embedded_mesh"&&(A=S.embeds[A.id])&&U.createModel(A,u(v),"");for(C in S.textures)if(v=S.textures[C],v.url instanceof Array){Q+=v.url.length;for(K=0;K<v.url.length;K++)e.onLoadStart()}else Q+=1,e.onLoadStart();pa=
Q;for(C in S.textures){v=S.textures[C];if(v.mapping!=void 0&&THREE[v.mapping]!=void 0)v.mapping=new THREE[v.mapping];if(v.url instanceof Array){K=[];for(var ca=0;ca<v.url.length;ca++)K[ca]=f(v.url[ca],S.urlBaseType);K=THREE.ImageUtils.loadTextureCube(K,v.mapping,b)}else{K=THREE.ImageUtils.loadTexture(f(v.url,S.urlBaseType),v.mapping,b);if(THREE[v.minFilter]!=void 0)K.minFilter=THREE[v.minFilter];if(THREE[v.magFilter]!=void 0)K.magFilter=THREE[v.magFilter];if(v.repeat){K.repeat.set(v.repeat[0],v.repeat[1]);
if(v.repeat[0]!=1)K.wrapS=THREE.RepeatWrapping;if(v.repeat[1]!=1)K.wrapT=THREE.RepeatWrapping}v.offset&&K.offset.set(v.offset[0],v.offset[1]);if(v.wrap){U={repeat:THREE.RepeatWrapping,mirror:THREE.MirroredRepeatWrapping};if(U[v.wrap[0]]!==void 0)K.wrapS=U[v.wrap[0]];if(U[v.wrap[1]]!==void 0)K.wrapT=U[v.wrap[1]]}}T.textures[C]=K}for(x in S.materials){C=S.materials[x];for(M in C.parameters)if(M=="envMap"||M=="map"||M=="lightMap")C.parameters[M]=T.textures[C.parameters[M]];else if(M=="shading")C.parameters[M]=
C.parameters[M]=="flat"?THREE.FlatShading:THREE.SmoothShading;else if(M=="blending")C.parameters[M]=THREE[C.parameters[M]]?THREE[C.parameters[M]]:THREE.NormalBlending;else if(M=="combine")C.parameters[M]=C.parameters[M]=="MixOperation"?THREE.MixOperation:THREE.MultiplyOperation;else if(M=="vertexColors")if(C.parameters[M]=="face")C.parameters[M]=THREE.FaceColors;else if(C.parameters[M])C.parameters[M]=THREE.VertexColors;if(C.parameters.opacity!==void 0&&C.parameters.opacity<1)C.parameters.transparent=
!0;if(C.parameters.normalMap){v=THREE.ShaderUtils.lib.normal;b=THREE.UniformsUtils.clone(v.uniforms);K=C.parameters.color;U=C.parameters.specular;A=C.parameters.ambient;I=C.parameters.shininess;b.tNormal.texture=T.textures[C.parameters.normalMap];if(C.parameters.normalMapFactor)b.uNormalScale.value=C.parameters.normalMapFactor;if(C.parameters.map)b.tDiffuse.texture=C.parameters.map,b.enableDiffuse.value=!0;if(C.parameters.lightMap)b.tAO.texture=C.parameters.lightMap,b.enableAO.value=!0;if(C.parameters.specularMap)b.tSpecular.texture=
T.textures[C.parameters.specularMap],b.enableSpecular.value=!0;b.uDiffuseColor.value.setHex(K);b.uSpecularColor.value.setHex(U);b.uAmbientColor.value.setHex(A);b.uShininess.value=I;if(C.parameters.opacity)b.uOpacity.value=C.parameters.opacity;C=new THREE.ShaderMaterial({fragmentShader:v.fragmentShader,vertexShader:v.vertexShader,uniforms:b,lights:!0,fog:!0})}else C=new THREE[C.type](C.parameters);T.materials[x]=C}n();e.callbackSync(T)}},constructor:THREE.SceneLoader};THREE.UTF8Loader=function(){};
THREE.UTF8Loader.prototype=new THREE.UTF8Loader;THREE.UTF8Loader.prototype.constructor=THREE.UTF8Loader;
THREE.UTF8Loader.prototype.load=function(b){var c=new XMLHttpRequest,e=b.model,f=b.callback,h=b.scale!==void 0?b.scale:1,m=b.offsetX!==void 0?b.offsetX:0,k=b.offsetY!==void 0?b.offsetY:0,n=b.offsetZ!==void 0?b.offsetZ:0;c.onreadystatechange=function(){c.readyState==4?c.status==200||c.status==0?THREE.UTF8Loader.prototype.createModel(c.responseText,f,h,m,k,n):alert("Couldn't load ["+e+"] ["+c.status+"]"):c.readyState!=3&&c.readyState==2&&c.getResponseHeader("Content-Length")};c.open("GET",e,!0);c.send(null)};
THREE.UTF8Loader.prototype.decompressMesh=function(b){var c=b.charCodeAt(0);c>=57344&&(c-=2048);c++;for(var e=new Float32Array(8*c),f=1,h=0;h<8;h++){for(var m=0,k=0;k<c;++k){var n=b.charCodeAt(k+f);m+=n>>1^-(n&1);e[8*k+h]=m}f+=c}c=b.length-f;m=new Uint16Array(c);for(h=k=0;h<c;h++)n=b.charCodeAt(h+f),m[h]=k-n,n==0&&k++;return[e,m]};
THREE.UTF8Loader.prototype.createModel=function(b,c,e,f,h,m){var k=function(){var c=this;c.materials=[];THREE.Geometry.call(this);var k=THREE.UTF8Loader.prototype.decompressMesh(b),u=[],w=[];(function(b,k,p){for(var t,u,w,C=b.length;p<C;p+=k)t=b[p],u=b[p+1],w=b[p+2],t=t/16383*e,u=u/16383*e,w=w/16383*e,t+=f,u+=h,w+=m,c.vertices.push(new THREE.Vertex(new THREE.Vector3(t,u,w)))})(k[0],8,0);(function(b,c,e){for(var f,h,k=b.length;e<k;e+=c)f=b[e],h=b[e+1],f/=1023,h/=1023,w.push(f,1-h)})(k[0],8,3);(function(b,
c,e){for(var f,h,k,m=b.length;e<m;e+=c)f=b[e],h=b[e+1],k=b[e+2],f=(f-512)/511,h=(h-512)/511,k=(k-512)/511,u.push(f,h,k)})(k[0],8,5);(function(b){var e,f,h,k,m,t,E,G,H,M=b.length;for(e=0;e<M;e+=3){f=b[e];h=b[e+1];k=b[e+2];m=c;G=f;H=h;t=k;E=f;var R=h,J=k,I=m.materials[0],K=u[R*3],W=u[R*3+1],R=u[R*3+2],D=u[J*3],S=u[J*3+1],J=u[J*3+2];E=new THREE.Vector3(u[E*3],u[E*3+1],u[E*3+2]);R=new THREE.Vector3(K,W,R);J=new THREE.Vector3(D,S,J);m.faces.push(new THREE.Face3(G,H,t,[E,R,J],null,I));m=w[f*2];f=w[f*2+
1];t=w[h*2];E=w[h*2+1];G=w[k*2];H=w[k*2+1];k=c.faceVertexUvs[0];h=t;t=E;E=[];E.push(new THREE.UV(m,f));E.push(new THREE.UV(h,t));E.push(new THREE.UV(G,H));k.push(E)}})(k[1]);this.computeCentroids();this.computeFaceNormals()};k.prototype=new THREE.Geometry;k.prototype.constructor=k;c(new k)};
THREE.MarchingCubes=function(b,c){THREE.Object3D.call(this);this.materials=c instanceof Array?c:[c];this.init=function(b){this.isolation=80;this.size=b;this.size2=this.size*this.size;this.size3=this.size2*this.size;this.halfsize=this.size/2;this.delta=2/this.size;this.yd=this.size;this.zd=this.size2;this.field=new Float32Array(this.size3);this.normal_cache=new Float32Array(this.size3*3);this.vlist=new Float32Array(36);this.nlist=new Float32Array(36);this.firstDraw=!0;this.maxCount=4096;this.count=
0;this.hasNormal=this.hasPos=!1;this.positionArray=new Float32Array(this.maxCount*3);this.normalArray=new Float32Array(this.maxCount*3)};this.lerp=function(b,c,h){return b+(c-b)*h};this.VIntX=function(b,c,h,m,k,n,t,u,w,v){k=(k-w)/(v-w);w=this.normal_cache;c[m]=n+k*this.delta;c[m+1]=t;c[m+2]=u;h[m]=this.lerp(w[b],w[b+3],k);h[m+1]=this.lerp(w[b+1],w[b+4],k);h[m+2]=this.lerp(w[b+2],w[b+5],k)};this.VIntY=function(b,c,h,m,k,n,t,u,w,v){k=(k-w)/(v-w);w=this.normal_cache;c[m]=n;c[m+1]=t+k*this.delta;c[m+
2]=u;c=b+this.yd*3;h[m]=this.lerp(w[b],w[c],k);h[m+1]=this.lerp(w[b+1],w[c+1],k);h[m+2]=this.lerp(w[b+2],w[c+2],k)};this.VIntZ=function(b,c,h,m,k,n,t,u,w,v){k=(k-w)/(v-w);w=this.normal_cache;c[m]=n;c[m+1]=t;c[m+2]=u+k*this.delta;c=b+this.zd*3;h[m]=this.lerp(w[b],w[c],k);h[m+1]=this.lerp(w[b+1],w[c+1],k);h[m+2]=this.lerp(w[b+2],w[c+2],k)};this.compNorm=function(b){var c=b*3;this.normal_cache[c]==0&&(this.normal_cache[c]=this.field[b-1]-this.field[b+1],this.normal_cache[c+1]=this.field[b-this.yd]-this.field[b+
this.yd],this.normal_cache[c+2]=this.field[b-this.zd]-this.field[b+this.zd])};this.polygonize=function(b,c,h,m,k,n){var t=m+1,u=m+this.yd,w=m+this.zd,v=t+this.yd,x=t+this.zd,p=m+this.yd+this.zd,y=t+this.yd+this.zd,z=0,A=this.field[m],C=this.field[t],E=this.field[u],G=this.field[v],H=this.field[w],M=this.field[x],R=this.field[p],J=this.field[y];A<k&&(z|=1);C<k&&(z|=2);E<k&&(z|=8);G<k&&(z|=4);H<k&&(z|=16);M<k&&(z|=32);R<k&&(z|=128);J<k&&(z|=64);var I=THREE.edgeTable[z];if(I==0)return 0;var K=this.delta,
W=b+K,D=c+K,K=h+K;I&1&&(this.compNorm(m),this.compNorm(t),this.VIntX(m*3,this.vlist,this.nlist,0,k,b,c,h,A,C));I&2&&(this.compNorm(t),this.compNorm(v),this.VIntY(t*3,this.vlist,this.nlist,3,k,W,c,h,C,G));I&4&&(this.compNorm(u),this.compNorm(v),this.VIntX(u*3,this.vlist,this.nlist,6,k,b,D,h,E,G));I&8&&(this.compNorm(m),this.compNorm(u),this.VIntY(m*3,this.vlist,this.nlist,9,k,b,c,h,A,E));I&16&&(this.compNorm(w),this.compNorm(x),this.VIntX(w*3,this.vlist,this.nlist,12,k,b,c,K,H,M));I&32&&(this.compNorm(x),
this.compNorm(y),this.VIntY(x*3,this.vlist,this.nlist,15,k,W,c,K,M,J));I&64&&(this.compNorm(p),this.compNorm(y),this.VIntX(p*3,this.vlist,this.nlist,18,k,b,D,K,R,J));I&128&&(this.compNorm(w),this.compNorm(p),this.VIntY(w*3,this.vlist,this.nlist,21,k,b,c,K,H,R));I&256&&(this.compNorm(m),this.compNorm(w),this.VIntZ(m*3,this.vlist,this.nlist,24,k,b,c,h,A,H));I&512&&(this.compNorm(t),this.compNorm(x),this.VIntZ(t*3,this.vlist,this.nlist,27,k,W,c,h,C,M));I&1024&&(this.compNorm(v),this.compNorm(y),this.VIntZ(v*
3,this.vlist,this.nlist,30,k,W,D,h,G,J));I&2048&&(this.compNorm(u),this.compNorm(p),this.VIntZ(u*3,this.vlist,this.nlist,33,k,b,D,h,E,R));z<<=4;for(k=m=0;THREE.triTable[z+k]!=-1;)b=z+k,c=b+1,h=b+2,this.posnormtriv(this.vlist,this.nlist,3*THREE.triTable[b],3*THREE.triTable[c],3*THREE.triTable[h],n),k+=3,m++;return m};this.posnormtriv=function(b,c,h,m,k,n){var t=this.count*3;this.positionArray[t]=b[h];this.positionArray[t+1]=b[h+1];this.positionArray[t+2]=b[h+2];this.positionArray[t+3]=b[m];this.positionArray[t+
4]=b[m+1];this.positionArray[t+5]=b[m+2];this.positionArray[t+6]=b[k];this.positionArray[t+7]=b[k+1];this.positionArray[t+8]=b[k+2];this.normalArray[t]=c[h];this.normalArray[t+1]=c[h+1];this.normalArray[t+2]=c[h+2];this.normalArray[t+3]=c[m];this.normalArray[t+4]=c[m+1];this.normalArray[t+5]=c[m+2];this.normalArray[t+6]=c[k];this.normalArray[t+7]=c[k+1];this.normalArray[t+8]=c[k+2];this.hasNormal=this.hasPos=!0;this.count+=3;this.count>=this.maxCount-3&&n(this)};this.begin=function(){this.count=0;
this.hasNormal=this.hasPos=!1};this.end=function(b){if(this.count!=0){for(var c=this.count*3;c<this.positionArray.length;c++)this.positionArray[c]=0;b(this)}};this.addBall=function(b,c,h,m,k){var n=this.size*Math.sqrt(m/k),t=h*this.size,u=c*this.size,w=b*this.size,v=Math.floor(t-n);v<1&&(v=1);t=Math.floor(t+n);t>this.size-1&&(t=this.size-1);var x=Math.floor(u-n);x<1&&(x=1);u=Math.floor(u+n);u>this.size-1&&(u=this.size-1);var p=Math.floor(w-n);p<1&&(p=1);n=Math.floor(w+n);n>this.size-1&&(n=this.size-
1);for(var y,z,A,C,E,G;v<t;v++){w=this.size2*v;z=v/this.size-h;E=z*z;for(z=x;z<u;z++){A=w+this.size*z;y=z/this.size-c;G=y*y;for(y=p;y<n;y++)C=y/this.size-b,C=m/(1.0E-6+C*C+G+E)-k,C>0&&(this.field[A+y]+=C)}}};this.addPlaneX=function(b,c){var h,m,k,n,t,u=this.size,w=this.yd,v=this.zd,x=this.field,p=u*Math.sqrt(b/c);p>u&&(p=u);for(h=0;h<p;h++)if(m=h/u,m*=m,n=b/(1.0E-4+m)-c,n>0)for(m=0;m<u;m++){t=h+m*w;for(k=0;k<u;k++)x[v*k+t]+=n}};this.addPlaneY=function(b,c){var h,m,k,n,t,u,w=this.size,v=this.yd,x=
this.zd,p=this.field,y=w*Math.sqrt(b/c);y>w&&(y=w);for(m=0;m<y;m++)if(h=m/w,h*=h,n=b/(1.0E-4+h)-c,n>0){t=m*v;for(h=0;h<w;h++){u=t+h;for(k=0;k<w;k++)p[x*k+u]+=n}}};this.addPlaneZ=function(b,c){var h,m,k,n,t,u;size=this.size;yd=this.yd;zd=this.zd;field=this.field;dist=size*Math.sqrt(b/c);dist>size&&(dist=size);for(k=0;k<dist;k++)if(h=k/size,h*=h,n=b/(1.0E-4+h)-c,n>0){t=zd*k;for(m=0;m<size;m++){u=t+m*yd;for(h=0;h<size;h++)field[u+h]+=n}}};this.reset=function(){var b;for(b=0;b<this.size3;b++)this.normal_cache[b*
3]=0,this.field[b]=0};this.render=function(b){this.begin();var c,h,m,k,n,t,u,w,v,x=this.size-2;for(k=1;k<x;k++){v=this.size2*k;u=(k-this.halfsize)/this.halfsize;for(m=1;m<x;m++){w=v+this.size*m;t=(m-this.halfsize)/this.halfsize;for(h=1;h<x;h++)n=(h-this.halfsize)/this.halfsize,c=w+h,this.polygonize(n,t,u,c,this.isolation,b)}}this.end(b)};this.generateGeometry=function(){var b=0,c=new THREE.Geometry,h=[];this.render(function(m){var k,n,t,u,w,v,x,p;for(k=0;k<m.count;k++)x=k*3,w=x+1,p=x+2,n=m.positionArray[x],
t=m.positionArray[w],u=m.positionArray[p],v=new THREE.Vector3(n,t,u),n=m.normalArray[x],t=m.normalArray[w],u=m.normalArray[p],x=new THREE.Vector3(n,t,u),x.normalize(),w=new THREE.Vertex(v),c.vertices.push(w),h.push(x);nfaces=m.count/3;for(k=0;k<nfaces;k++)x=(b+k)*3,w=x+1,p=x+2,v=h[x],n=h[w],t=h[p],x=new THREE.Face3(x,w,p,[v,n,t]),c.faces.push(x);b+=nfaces;m.count=0});return c};this.init(b)};THREE.MarchingCubes.prototype=new THREE.Object3D;THREE.MarchingCubes.prototype.constructor=THREE.MarchingCubes;
THREE.edgeTable=new Int32Array([0,265,515,778,1030,1295,1541,1804,2060,2309,2575,2822,3082,3331,3593,3840,400,153,915,666,1430,1183,1941,1692,2460,2197,2975,2710,3482,3219,3993,3728,560,825,51,314,1590,1855,1077,1340,2620,2869,2111,2358,3642,3891,3129,3376,928,681,419,170,1958,1711,1445,1196,2988,2725,2479,2214,4010,3747,3497,3232,1120,1385,1635,1898,102,367,613,876,3180,3429,3695,3942,2154,2403,2665,2912,1520,1273,2035,1786,502,255,1013,764,3580,3317,4095,3830,2554,2291,3065,2800,1616,1881,1107,
1370,598,863,85,348,3676,3925,3167,3414,2650,2899,2137,2384,1984,1737,1475,1226,966,719,453,204,4044,3781,3535,3270,3018,2755,2505,2240,2240,2505,2755,3018,3270,3535,3781,4044,204,453,719,966,1226,1475,1737,1984,2384,2137,2899,2650,3414,3167,3925,3676,348,85,863,598,1370,1107,1881,1616,2800,3065,2291,2554,3830,4095,3317,3580,764,1013,255,502,1786,2035,1273,1520,2912,2665,2403,2154,3942,3695,3429,3180,876,613,367,102,1898,1635,1385,1120,3232,3497,3747,4010,2214,2479,2725,2988,1196,1445,1711,1958,170,
419,681,928,3376,3129,3891,3642,2358,2111,2869,2620,1340,1077,1855,1590,314,51,825,560,3728,3993,3219,3482,2710,2975,2197,2460,1692,1941,1183,1430,666,915,153,400,3840,3593,3331,3082,2822,2575,2309,2060,1804,1541,1295,1030,778,515,265,0]);
THREE.triTable=new Int32Array([-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,9,8,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,2,10,0,2,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,8,3,2,10,8,10,9,8,-1,-1,-1,-1,-1,-1,-1,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,8,11,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,11,-1,-1,-1,-1,-1,
-1,-1,-1,-1,-1,1,11,2,1,9,11,9,8,11,-1,-1,-1,-1,-1,-1,-1,3,10,1,11,10,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,10,1,0,8,10,8,11,10,-1,-1,-1,-1,-1,-1,-1,3,9,0,3,11,9,11,10,9,-1,-1,-1,-1,-1,-1,-1,9,8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,7,3,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,1,9,4,7,1,7,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,4,7,3,0,4,1,2,10,-1,-1,-1,-1,-1,-1,-1,9,2,10,9,0,2,8,4,7,
-1,-1,-1,-1,-1,-1,-1,2,10,9,2,9,7,2,7,3,7,9,4,-1,-1,-1,-1,8,4,7,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,4,7,11,2,4,2,0,4,-1,-1,-1,-1,-1,-1,-1,9,0,1,8,4,7,2,3,11,-1,-1,-1,-1,-1,-1,-1,4,7,11,9,4,11,9,11,2,9,2,1,-1,-1,-1,-1,3,10,1,3,11,10,7,8,4,-1,-1,-1,-1,-1,-1,-1,1,11,10,1,4,11,1,0,4,7,11,4,-1,-1,-1,-1,4,7,8,9,0,11,9,11,10,11,0,3,-1,-1,-1,-1,4,7,11,4,11,9,9,11,10,-1,-1,-1,-1,-1,-1,-1,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,5,4,1,5,0,-1,-1,-1,-1,-1,-1,
-1,-1,-1,-1,8,5,4,8,3,5,3,1,5,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,10,4,9,5,-1,-1,-1,-1,-1,-1,-1,5,2,10,5,4,2,4,0,2,-1,-1,-1,-1,-1,-1,-1,2,10,5,3,2,5,3,5,4,3,4,8,-1,-1,-1,-1,9,5,4,2,3,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,0,8,11,4,9,5,-1,-1,-1,-1,-1,-1,-1,0,5,4,0,1,5,2,3,11,-1,-1,-1,-1,-1,-1,-1,2,1,5,2,5,8,2,8,11,4,8,5,-1,-1,-1,-1,10,3,11,10,1,3,9,5,4,-1,-1,-1,-1,-1,-1,-1,4,9,5,0,8,1,8,10,1,8,11,10,-1,-1,-1,-1,5,4,0,5,0,11,5,11,10,11,0,3,-1,-1,-1,-1,5,4,8,5,
8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,9,7,8,5,7,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,3,0,9,5,3,5,7,3,-1,-1,-1,-1,-1,-1,-1,0,7,8,0,1,7,1,5,7,-1,-1,-1,-1,-1,-1,-1,1,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,7,8,9,5,7,10,1,2,-1,-1,-1,-1,-1,-1,-1,10,1,2,9,5,0,5,3,0,5,7,3,-1,-1,-1,-1,8,0,2,8,2,5,8,5,7,10,5,2,-1,-1,-1,-1,2,10,5,2,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,7,9,5,7,8,9,3,11,2,-1,-1,-1,-1,-1,-1,-1,9,5,7,9,7,2,9,2,0,2,7,11,-1,-1,-1,-1,2,3,11,0,1,8,1,7,8,1,5,7,-1,-1,-1,-1,11,2,1,11,1,7,7,1,5,-1,-1,-1,-1,-1,-1,
-1,9,5,8,8,5,7,10,1,3,10,3,11,-1,-1,-1,-1,5,7,0,5,0,9,7,11,0,1,0,10,11,10,0,-1,11,10,0,11,0,3,10,5,0,8,0,7,5,7,0,-1,11,10,5,7,11,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,6,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,0,1,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,1,9,8,5,10,6,-1,-1,-1,-1,-1,-1,-1,1,6,5,2,6,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,6,5,1,2,6,3,0,8,-1,-1,-1,-1,-1,-1,-1,9,6,5,9,0,6,0,2,6,-1,-1,-1,-1,-1,-1,-1,5,9,8,5,8,2,5,2,6,3,2,8,-1,-1,-1,-1,2,3,11,10,6,
5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,0,8,11,2,0,10,6,5,-1,-1,-1,-1,-1,-1,-1,0,1,9,2,3,11,5,10,6,-1,-1,-1,-1,-1,-1,-1,5,10,6,1,9,2,9,11,2,9,8,11,-1,-1,-1,-1,6,3,11,6,5,3,5,1,3,-1,-1,-1,-1,-1,-1,-1,0,8,11,0,11,5,0,5,1,5,11,6,-1,-1,-1,-1,3,11,6,0,3,6,0,6,5,0,5,9,-1,-1,-1,-1,6,5,9,6,9,11,11,9,8,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,4,7,3,6,5,10,-1,-1,-1,-1,-1,-1,-1,1,9,0,5,10,6,8,4,7,-1,-1,-1,-1,-1,-1,-1,10,6,5,1,9,7,1,7,3,7,9,4,-1,-1,-1,-1,6,1,2,6,5,1,4,7,8,-1,-1,-1,-1,
-1,-1,-1,1,2,5,5,2,6,3,0,4,3,4,7,-1,-1,-1,-1,8,4,7,9,0,5,0,6,5,0,2,6,-1,-1,-1,-1,7,3,9,7,9,4,3,2,9,5,9,6,2,6,9,-1,3,11,2,7,8,4,10,6,5,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,2,4,2,0,2,7,11,-1,-1,-1,-1,0,1,9,4,7,8,2,3,11,5,10,6,-1,-1,-1,-1,9,2,1,9,11,2,9,4,11,7,11,4,5,10,6,-1,8,4,7,3,11,5,3,5,1,5,11,6,-1,-1,-1,-1,5,1,11,5,11,6,1,0,11,7,11,4,0,4,11,-1,0,5,9,0,6,5,0,3,6,11,6,3,8,4,7,-1,6,5,9,6,9,11,4,7,9,7,11,9,-1,-1,-1,-1,10,4,9,6,4,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,10,6,4,9,10,0,8,3,-1,-1,-1,-1,-1,-1,-1,
10,0,1,10,6,0,6,4,0,-1,-1,-1,-1,-1,-1,-1,8,3,1,8,1,6,8,6,4,6,1,10,-1,-1,-1,-1,1,4,9,1,2,4,2,6,4,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,9,2,4,9,2,6,4,-1,-1,-1,-1,0,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,3,2,8,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,10,4,9,10,6,4,11,2,3,-1,-1,-1,-1,-1,-1,-1,0,8,2,2,8,11,4,9,10,4,10,6,-1,-1,-1,-1,3,11,2,0,1,6,0,6,4,6,1,10,-1,-1,-1,-1,6,4,1,6,1,10,4,8,1,2,1,11,8,11,1,-1,9,6,4,9,3,6,9,1,3,11,6,3,-1,-1,-1,-1,8,11,1,8,1,0,11,6,1,9,1,4,6,4,1,-1,3,11,6,3,6,0,0,6,4,-1,-1,-1,-1,-1,-1,-1,
6,4,8,11,6,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,10,6,7,8,10,8,9,10,-1,-1,-1,-1,-1,-1,-1,0,7,3,0,10,7,0,9,10,6,7,10,-1,-1,-1,-1,10,6,7,1,10,7,1,7,8,1,8,0,-1,-1,-1,-1,10,6,7,10,7,1,1,7,3,-1,-1,-1,-1,-1,-1,-1,1,2,6,1,6,8,1,8,9,8,6,7,-1,-1,-1,-1,2,6,9,2,9,1,6,7,9,0,9,3,7,3,9,-1,7,8,0,7,0,6,6,0,2,-1,-1,-1,-1,-1,-1,-1,7,3,2,6,7,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,11,10,6,8,10,8,9,8,6,7,-1,-1,-1,-1,2,0,7,2,7,11,0,9,7,6,7,10,9,10,7,-1,1,8,0,1,7,8,1,10,7,6,7,10,2,3,11,-1,11,2,1,11,1,7,10,6,1,6,7,1,-1,-1,-1,-1,
8,9,6,8,6,7,9,1,6,11,6,3,1,3,6,-1,0,9,1,11,6,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,8,0,7,0,6,3,11,0,11,6,0,-1,-1,-1,-1,7,11,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,1,9,8,3,1,11,7,6,-1,-1,-1,-1,-1,-1,-1,10,1,2,6,11,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,3,0,8,6,11,7,-1,-1,-1,-1,-1,-1,-1,2,9,0,2,10,9,6,11,7,-1,-1,-1,-1,-1,-1,-1,6,11,7,2,10,3,10,8,3,10,9,8,-1,-1,-1,-1,7,
2,3,6,2,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,0,8,7,6,0,6,2,0,-1,-1,-1,-1,-1,-1,-1,2,7,6,2,3,7,0,1,9,-1,-1,-1,-1,-1,-1,-1,1,6,2,1,8,6,1,9,8,8,7,6,-1,-1,-1,-1,10,7,6,10,1,7,1,3,7,-1,-1,-1,-1,-1,-1,-1,10,7,6,1,7,10,1,8,7,1,0,8,-1,-1,-1,-1,0,3,7,0,7,10,0,10,9,6,10,7,-1,-1,-1,-1,7,6,10,7,10,8,8,10,9,-1,-1,-1,-1,-1,-1,-1,6,8,4,11,8,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,6,11,3,0,6,0,4,6,-1,-1,-1,-1,-1,-1,-1,8,6,11,8,4,6,9,0,1,-1,-1,-1,-1,-1,-1,-1,9,4,6,9,6,3,9,3,1,11,3,6,-1,-1,-1,-1,6,8,4,6,11,8,2,10,1,-1,-1,-1,
-1,-1,-1,-1,1,2,10,3,0,11,0,6,11,0,4,6,-1,-1,-1,-1,4,11,8,4,6,11,0,2,9,2,10,9,-1,-1,-1,-1,10,9,3,10,3,2,9,4,3,11,3,6,4,6,3,-1,8,2,3,8,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,0,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,4,2,4,6,4,3,8,-1,-1,-1,-1,1,9,4,1,4,2,2,4,6,-1,-1,-1,-1,-1,-1,-1,8,1,3,8,6,1,8,4,6,6,10,1,-1,-1,-1,-1,10,1,0,10,0,6,6,0,4,-1,-1,-1,-1,-1,-1,-1,4,6,3,4,3,8,6,10,3,0,3,9,10,9,3,-1,10,9,4,6,10,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,5,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,5,11,7,6,
-1,-1,-1,-1,-1,-1,-1,5,0,1,5,4,0,7,6,11,-1,-1,-1,-1,-1,-1,-1,11,7,6,8,3,4,3,5,4,3,1,5,-1,-1,-1,-1,9,5,4,10,1,2,7,6,11,-1,-1,-1,-1,-1,-1,-1,6,11,7,1,2,10,0,8,3,4,9,5,-1,-1,-1,-1,7,6,11,5,4,10,4,2,10,4,0,2,-1,-1,-1,-1,3,4,8,3,5,4,3,2,5,10,5,2,11,7,6,-1,7,2,3,7,6,2,5,4,9,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,6,0,6,2,6,8,7,-1,-1,-1,-1,3,6,2,3,7,6,1,5,0,5,4,0,-1,-1,-1,-1,6,2,8,6,8,7,2,1,8,4,8,5,1,5,8,-1,9,5,4,10,1,6,1,7,6,1,3,7,-1,-1,-1,-1,1,6,10,1,7,6,1,0,7,8,7,0,9,5,4,-1,4,0,10,4,10,5,0,3,10,6,10,7,3,7,10,
-1,7,6,10,7,10,8,5,4,10,4,8,10,-1,-1,-1,-1,6,9,5,6,11,9,11,8,9,-1,-1,-1,-1,-1,-1,-1,3,6,11,0,6,3,0,5,6,0,9,5,-1,-1,-1,-1,0,11,8,0,5,11,0,1,5,5,6,11,-1,-1,-1,-1,6,11,3,6,3,5,5,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,11,9,11,8,11,5,6,-1,-1,-1,-1,0,11,3,0,6,11,0,9,6,5,6,9,1,2,10,-1,11,8,5,11,5,6,8,0,5,10,5,2,0,2,5,-1,6,11,3,6,3,5,2,10,3,10,5,3,-1,-1,-1,-1,5,8,9,5,2,8,5,6,2,3,8,2,-1,-1,-1,-1,9,5,6,9,6,0,0,6,2,-1,-1,-1,-1,-1,-1,-1,1,5,8,1,8,0,5,6,8,3,8,2,6,2,8,-1,1,5,6,2,1,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
1,3,6,1,6,10,3,8,6,5,6,9,8,9,6,-1,10,1,0,10,0,6,9,5,0,5,6,0,-1,-1,-1,-1,0,3,8,5,6,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,5,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,7,5,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,11,7,5,8,3,0,-1,-1,-1,-1,-1,-1,-1,5,11,7,5,10,11,1,9,0,-1,-1,-1,-1,-1,-1,-1,10,7,5,10,11,7,9,8,1,8,3,1,-1,-1,-1,-1,11,1,2,11,7,1,7,5,1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,7,1,7,5,7,2,11,-1,-1,-1,-1,9,7,5,9,2,7,9,0,2,2,11,7,-1,-1,-1,-1,7,5,2,7,2,11,5,9,2,3,2,8,9,8,2,-1,2,5,10,2,3,5,3,7,5,-1,-1,
-1,-1,-1,-1,-1,8,2,0,8,5,2,8,7,5,10,2,5,-1,-1,-1,-1,9,0,1,5,10,3,5,3,7,3,10,2,-1,-1,-1,-1,9,8,2,9,2,1,8,7,2,10,2,5,7,5,2,-1,1,3,5,3,7,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,7,0,7,1,1,7,5,-1,-1,-1,-1,-1,-1,-1,9,0,3,9,3,5,5,3,7,-1,-1,-1,-1,-1,-1,-1,9,8,7,5,9,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5,8,4,5,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,5,0,4,5,11,0,5,10,11,11,3,0,-1,-1,-1,-1,0,1,9,8,4,10,8,10,11,10,4,5,-1,-1,-1,-1,10,11,4,10,4,5,11,3,4,9,4,1,3,1,4,-1,2,5,1,2,8,5,2,11,8,4,5,8,-1,-1,-1,-1,0,4,11,0,11,3,4,5,11,
2,11,1,5,1,11,-1,0,2,5,0,5,9,2,11,5,4,5,8,11,8,5,-1,9,4,5,2,11,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,5,10,3,5,2,3,4,5,3,8,4,-1,-1,-1,-1,5,10,2,5,2,4,4,2,0,-1,-1,-1,-1,-1,-1,-1,3,10,2,3,5,10,3,8,5,4,5,8,0,1,9,-1,5,10,2,5,2,4,1,9,2,9,4,2,-1,-1,-1,-1,8,4,5,8,5,3,3,5,1,-1,-1,-1,-1,-1,-1,-1,0,4,5,1,0,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,4,5,8,5,3,9,0,5,0,3,5,-1,-1,-1,-1,9,4,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,11,7,4,9,11,9,10,11,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,7,9,11,7,9,10,11,-1,-1,-1,-1,1,10,11,1,11,
4,1,4,0,7,4,11,-1,-1,-1,-1,3,1,4,3,4,8,1,10,4,7,4,11,10,11,4,-1,4,11,7,9,11,4,9,2,11,9,1,2,-1,-1,-1,-1,9,7,4,9,11,7,9,1,11,2,11,1,0,8,3,-1,11,7,4,11,4,2,2,4,0,-1,-1,-1,-1,-1,-1,-1,11,7,4,11,4,2,8,3,4,3,2,4,-1,-1,-1,-1,2,9,10,2,7,9,2,3,7,7,4,9,-1,-1,-1,-1,9,10,7,9,7,4,10,2,7,8,7,0,2,0,7,-1,3,7,10,3,10,2,7,4,10,1,10,0,4,0,10,-1,1,10,2,8,7,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,7,1,3,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,0,8,1,8,7,1,-1,-1,-1,-1,4,0,3,7,4,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,8,7,-1,-1,-1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,11,9,10,-1,-1,-1,-1,-1,-1,-1,0,1,10,0,10,8,8,10,11,-1,-1,-1,-1,-1,-1,-1,3,1,10,11,3,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,11,1,11,9,9,11,8,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,1,2,9,2,11,9,-1,-1,-1,-1,0,2,11,8,0,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,2,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,10,8,9,-1,-1,-1,-1,-1,-1,-1,9,10,2,0,9,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,0,1,8,1,10,8,-1,-1,-1,-1,1,10,
2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,3,8,9,1,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,9,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,3,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1]);
THREE.Trident=function(){THREE.Object3D.call(this);var b=new THREE.Geometry;b.vertices.push(new THREE.Vertex);b.vertices.push(new THREE.Vertex(new THREE.Vector3(0,100,0)));var c=new THREE.CylinderGeometry(0,5,25,5,1),e=new THREE.Line(b,new THREE.LineBasicMaterial({color:16711680}));e.rotation.z=-Math.PI/2;this.add(e);e=new THREE.Mesh(c,new THREE.MeshBasicMaterial({color:16711680}));e.position.x=100;e.rotation.z=-Math.PI/2;this.add(e);e=new THREE.Line(b,new THREE.LineBasicMaterial({color:65280}));
this.add(e);e=new THREE.Mesh(c,new THREE.MeshBasicMaterial({color:65280}));e.position.y=100;this.add(e);e=new THREE.Line(b,new THREE.LineBasicMaterial({color:255}));e.rotation.x=Math.PI/2;this.add(e);e=new THREE.Mesh(c,new THREE.MeshBasicMaterial({color:255}));e.position.z=100;e.rotation.x=Math.PI/2;this.add(e)};THREE.Trident.prototype=new THREE.Object3D;THREE.Trident.prototype.constructor=THREE.Trident;THREE.PlaneCollider=function(b,c){this.point=b;this.normal=c};
THREE.SphereCollider=function(b,c){this.center=b;this.radius=c;this.radiusSq=c*c};THREE.BoxCollider=function(b,c){this.min=b;this.max=c;this.dynamic=!0;this.normal=new THREE.Vector3};THREE.MeshCollider=function(b,c){this.mesh=b;this.box=c;this.numFaces=this.mesh.geometry.faces.length;this.normal=new THREE.Vector3};THREE.CollisionSystem=function(){this.collisionNormal=new THREE.Vector3;this.colliders=[];this.hits=[]};THREE.Collisions=new THREE.CollisionSystem;
THREE.CollisionSystem.prototype.merge=function(b){this.colliders=this.colliders.concat(b.colliders);this.hits=this.hits.concat(b.hits)};THREE.CollisionSystem.prototype.rayCastAll=function(b){b.direction.normalize();this.hits.length=0;var c,e,f,h,m=0;c=0;for(e=this.colliders.length;c<e;c++)if(h=this.colliders[c],f=this.rayCast(b,h),f<Number.MAX_VALUE)h.distance=f,f>m?this.hits.push(h):this.hits.unshift(h),m=f;return this.hits};
THREE.CollisionSystem.prototype.rayCastNearest=function(b){var c=this.rayCastAll(b);if(c.length==0)return null;for(var e=0;c[e]instanceof THREE.MeshCollider;){var f=this.rayMesh(b,c[e]);if(f.dist<Number.MAX_VALUE){c[e].distance=f.dist;c[e].faceIndex=f.faceIndex;break}e++}if(e>c.length)return null;return c[e]};
THREE.CollisionSystem.prototype.rayCast=function(b,c){if(c instanceof THREE.PlaneCollider)return this.rayPlane(b,c);else if(c instanceof THREE.SphereCollider)return this.raySphere(b,c);else if(c instanceof THREE.BoxCollider)return this.rayBox(b,c);else if(c instanceof THREE.MeshCollider&&c.box)return this.rayBox(b,c.box)};
THREE.CollisionSystem.prototype.rayMesh=function(b,c){for(var e=this.makeRayLocal(b,c.mesh),f=Number.MAX_VALUE,h,m=0;m<c.numFaces;m++){var k=c.mesh.geometry.faces[m],n=c.mesh.geometry.vertices[k.a].position,t=c.mesh.geometry.vertices[k.b].position,u=c.mesh.geometry.vertices[k.c].position,w=k instanceof THREE.Face4?c.mesh.geometry.vertices[k.d].position:null;k instanceof THREE.Face3?(k=this.rayTriangle(e,n,t,u,f,this.collisionNormal,c.mesh),k<f&&(f=k,h=m,c.normal.copy(this.collisionNormal),c.normal.normalize())):
k instanceof THREE.Face4&&(k=this.rayTriangle(e,n,t,w,f,this.collisionNormal,c.mesh),k<f&&(f=k,h=m,c.normal.copy(this.collisionNormal),c.normal.normalize()),k=this.rayTriangle(e,t,u,w,f,this.collisionNormal,c.mesh),k<f&&(f=k,h=m,c.normal.copy(this.collisionNormal),c.normal.normalize()))}return{dist:f,faceIndex:h}};
THREE.CollisionSystem.prototype.rayTriangle=function(b,c,e,f,h,m,k){var n=THREE.CollisionSystem.__v1,t=THREE.CollisionSystem.__v2;m.set(0,0,0);n.sub(e,c);t.sub(f,e);m.cross(n,t);n=m.dot(b.direction);if(!(n<0))if(k.doubleSided||k.flipSided)m.multiplyScalar(-1),n*=-1;else return Number.MAX_VALUE;k=m.dot(c)-m.dot(b.origin);if(!(k<=0))return Number.MAX_VALUE;if(!(k>=n*h))return Number.MAX_VALUE;k/=n;n=THREE.CollisionSystem.__v3;n.copy(b.direction);n.multiplyScalar(k);n.addSelf(b.origin);Math.abs(m.x)>
Math.abs(m.y)?Math.abs(m.x)>Math.abs(m.z)?(b=n.y-c.y,m=e.y-c.y,h=f.y-c.y,n=n.z-c.z,e=e.z-c.z,f=f.z-c.z):(b=n.x-c.x,m=e.x-c.x,h=f.x-c.x,n=n.y-c.y,e=e.y-c.y,f=f.y-c.y):Math.abs(m.y)>Math.abs(m.z)?(b=n.x-c.x,m=e.x-c.x,h=f.x-c.x,n=n.z-c.z,e=e.z-c.z,f=f.z-c.z):(b=n.x-c.x,m=e.x-c.x,h=f.x-c.x,n=n.y-c.y,e=e.y-c.y,f=f.y-c.y);c=m*f-e*h;if(c==0)return Number.MAX_VALUE;c=1/c;f=(b*f-n*h)*c;if(!(f>=0))return Number.MAX_VALUE;c*=m*n-e*b;if(!(c>=0))return Number.MAX_VALUE;if(!(1-f-c>=0))return Number.MAX_VALUE;return k};
THREE.CollisionSystem.prototype.makeRayLocal=function(b,c){var e=THREE.CollisionSystem.__m;THREE.Matrix4.makeInvert(c.matrixWorld,e);var f=THREE.CollisionSystem.__r;f.origin.copy(b.origin);f.direction.copy(b.direction);e.multiplyVector3(f.origin);e.rotateAxis(f.direction);f.direction.normalize();return f};
THREE.CollisionSystem.prototype.rayBox=function(b,c){var e;c.dynamic&&c.mesh&&c.mesh.matrixWorld?e=this.makeRayLocal(b,c.mesh):(e=THREE.CollisionSystem.__r,e.origin.copy(b.origin),e.direction.copy(b.direction));var f=0,h=0,m=0,k=0,n=0,t=0,u=!0;e.origin.x<c.min.x?(f=c.min.x-e.origin.x,f/=e.direction.x,u=!1,k=-1):e.origin.x>c.max.x&&(f=c.max.x-e.origin.x,f/=e.direction.x,u=!1,k=1);e.origin.y<c.min.y?(h=c.min.y-e.origin.y,h/=e.direction.y,u=!1,n=-1):e.origin.y>c.max.y&&(h=c.max.y-e.origin.y,h/=e.direction.y,
u=!1,n=1);e.origin.z<c.min.z?(m=c.min.z-e.origin.z,m/=e.direction.z,u=!1,t=-1):e.origin.z>c.max.z&&(m=c.max.z-e.origin.z,m/=e.direction.z,u=!1,t=1);if(u)return-1;u=0;h>f&&(u=1,f=h);m>f&&(u=2,f=m);switch(u){case 0:n=e.origin.y+e.direction.y*f;if(n<c.min.y||n>c.max.y)return Number.MAX_VALUE;e=e.origin.z+e.direction.z*f;if(e<c.min.z||e>c.max.z)return Number.MAX_VALUE;c.normal.set(k,0,0);break;case 1:k=e.origin.x+e.direction.x*f;if(k<c.min.x||k>c.max.x)return Number.MAX_VALUE;e=e.origin.z+e.direction.z*
f;if(e<c.min.z||e>c.max.z)return Number.MAX_VALUE;c.normal.set(0,n,0);break;case 2:k=e.origin.x+e.direction.x*f;if(k<c.min.x||k>c.max.x)return Number.MAX_VALUE;n=e.origin.y+e.direction.y*f;if(n<c.min.y||n>c.max.y)return Number.MAX_VALUE;c.normal.set(0,0,t)}return f};THREE.CollisionSystem.prototype.rayPlane=function(b,c){var e=b.direction.dot(c.normal),f=c.point.dot(c.normal);if(e<0)e=(f-b.origin.dot(c.normal))/e;else return Number.MAX_VALUE;return e>0?e:Number.MAX_VALUE};
THREE.CollisionSystem.prototype.raySphere=function(b,c){var e=c.center.clone().subSelf(b.origin);if(e.lengthSq<c.radiusSq)return-1;var f=e.dot(b.direction.clone());if(f<=0)return Number.MAX_VALUE;e=c.radiusSq-(e.lengthSq()-f*f);if(e>=0)return Math.abs(f)-Math.sqrt(e);return Number.MAX_VALUE};THREE.CollisionSystem.__v1=new THREE.Vector3;THREE.CollisionSystem.__v2=new THREE.Vector3;THREE.CollisionSystem.__v3=new THREE.Vector3;THREE.CollisionSystem.__nr=new THREE.Vector3;THREE.CollisionSystem.__m=new THREE.Matrix4;
THREE.CollisionSystem.__r=new THREE.Ray;THREE.CollisionUtils={};THREE.CollisionUtils.MeshOBB=function(b){b.geometry.computeBoundingBox();var c=b.geometry.boundingBox,e=new THREE.Vector3(c.x[0],c.y[0],c.z[0]),c=new THREE.Vector3(c.x[1],c.y[1],c.z[1]),e=new THREE.BoxCollider(e,c);e.mesh=b;return e};THREE.CollisionUtils.MeshAABB=function(b){var c=THREE.CollisionUtils.MeshOBB(b);c.min.addSelf(b.position);c.max.addSelf(b.position);c.dynamic=!1;return c};
THREE.CollisionUtils.MeshColliderWBox=function(b){return new THREE.MeshCollider(b,THREE.CollisionUtils.MeshOBB(b))};
if(THREE.WebGLRenderer)THREE.AnaglyphWebGLRenderer=function(b){THREE.WebGLRenderer.call(this,b);var c=this,e=this.setSize,f=this.render,h=new THREE.Camera,m=new THREE.Camera,k=new THREE.Matrix4,n=new THREE.Matrix4,t,u,w;h.useTarget=m.useTarget=!1;h.matrixAutoUpdate=m.matrixAutoUpdate=!1;var b={minFilter:THREE.LinearFilter,magFilter:THREE.NearestFilter,format:THREE.RGBAFormat},v=new THREE.WebGLRenderTarget(512,512,b),x=new THREE.WebGLRenderTarget(512,512,b),p=new THREE.Camera(53,1,1,1E4);p.position.z=
2;_material=new THREE.ShaderMaterial({uniforms:{mapLeft:{type:"t",value:0,texture:v},mapRight:{type:"t",value:1,texture:x}},vertexShader:"varying vec2 vUv;\nvoid main() {\nvUv = vec2( uv.x, 1.0 - uv.y );\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"uniform sampler2D mapLeft;\nuniform sampler2D mapRight;\nvarying vec2 vUv;\nvoid main() {\nvec4 colorL, colorR;\nvec2 uv = vUv;\ncolorL = texture2D( mapLeft, uv );\ncolorR = texture2D( mapRight, uv );\ngl_FragColor = vec4( colorL.g * 0.7 + colorL.b * 0.3, colorR.g, colorR.b, colorL.a + colorR.a ) * 1.1;\n}"});
var y=new THREE.Scene;y.addObject(new THREE.Mesh(new THREE.PlaneGeometry(2,2),_material));this.setSize=function(b,f){e.call(c,b,f);v.width=b;v.height=f;x.width=b;x.height=f};this.render=function(b,e){e.update(null,!0);if(t!==e.aspect||u!==e.near||w!==e.fov){t=e.aspect;u=e.near;w=e.fov;var C=e.projectionMatrix.clone(),E=125/30*0.5,G=E*u/125,H=u*Math.tan(w*Math.PI/360),M;k.n14=E;n.n14=-E;E=-H*t+G;M=H*t+G;C.n11=2*u/(M-E);C.n13=(M+E)/(M-E);h.projectionMatrix=C.clone();E=-H*t-G;M=H*t-G;C.n11=2*u/(M-E);
C.n13=(M+E)/(M-E);m.projectionMatrix=C.clone()}h.matrix=e.matrixWorld.clone().multiplySelf(n);h.update(null,!0);h.position.copy(e.position);h.near=u;h.far=e.far;f.call(c,b,h,v,!0);m.matrix=e.matrixWorld.clone().multiplySelf(k);m.update(null,!0);m.position.copy(e.position);m.near=u;m.far=e.far;f.call(c,b,m,x,!0);f.call(c,y,p)}};
if(THREE.WebGLRenderer)THREE.CrosseyedWebGLRenderer=function(b){THREE.WebGLRenderer.call(this,b);this.autoClear=!1;var c=this,e=this.setSize,f=this.render,h,m,k=new THREE.Camera,n=new THREE.Camera;c.separation=10;if(b&&b.separation!==void 0)c.separation=b.separation;(new THREE.Camera(53,window.innerWidth/2/window.innerHeight,1,1E4)).position.z=-10;this.setSize=function(b,f){e.call(c,b,f);h=b/2;m=f};this.render=function(b,e){this.clear();k.fov=e.fov;k.aspect=0.5*e.aspect;k.near=e.near;k.far=e.far;
k.updateProjectionMatrix();k.position.copy(e.position);k.target.position.copy(e.target.position);k.translateX(c.separation);n.projectionMatrix=k.projectionMatrix;n.position.copy(e.position);n.target.position.copy(e.target.position);n.translateX(-c.separation);this.setViewport(0,0,h,m);f.call(c,b,k);this.setViewport(h,0,h,m);f.call(c,b,n,!1)}};


var FlatShading=THREE.FlatShading;
var Texture = THREE.Texture;
var SmoothShading=THREE.SmoothShading;
var SphericalReflectionMapping=THREE.SphericalReflectionMapping;
var LineBasicMaterial=THREE.LineBasicMaterial;
var MeshBasicMaterial=THREE.MeshBasicMaterial;
var MeshLambertMaterial=THREE.MeshLambertMaterial;
