/*
 * Decompiled with CFR 0.152.
 */
package manakeri.Zombicalypse;

import com.badlogic.gdx.Game;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g3d.loaders.g3d.G3dLoader;
import com.badlogic.gdx.graphics.g3d.model.still.StillModel;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import java.util.Random;
import manakeri.Zombicalypse.GameLoop;
import manakeri.Zombicalypse.GameOver;
import manakeri.Zombicalypse.HighScores;
import manakeri.Zombicalypse.MainMenu;
import manakeri.Zombicalypse.Options;

public class TGame
extends Game {
    public static final String TAG = "zombicalypse";
    public static final float VIRTUAL_WIDTH = 800.0f;
    public static final float VIRTUAL_HEIGHT = 480.0f;
    public static final boolean DEBUG = false;
    public static TGame game;
    public static StillModel[] house;
    public static Music music;
    public static MainMenu mainmenu;
    public static GameLoop gameloop;
    public static GameOver gameover;
    public static Options options;
    public static HighScores highscores;
    public static Random rand;
    public static Label.LabelStyle labelStyle;
    public static Slider.SliderStyle sliderStyle;
    public static TextButton.TextButtonStyle textbuttonStyle;
    public static CheckBox.CheckBoxStyle checkboxStyle;
    public static BitmapFont font;
    public static NinePatchDrawable ninepatch;
    public static TextureAtlas atlas;
    public static Preferences prefs;
    public static Sound[] snd_explosion;
    public static Sound[] snd_zombie;
    private final String tex_vertexShader = "attribute vec4 a_position;attribute vec4 a_color;attribute vec2 a_texCoord0;uniform mat4 u_worldView;varying vec2 v_texCoords;void main() {v_texCoords = a_texCoord0;gl_Position = u_worldView * a_position; }";
    private final String tex_fragmentShader = "varying vec2 v_texCoords;uniform sampler2D u_texture;void main() { gl_FragColor = texture2D(u_texture, v_texCoords); }";
    private final String col_vertexShader = "attribute vec4 a_position;uniform mat4 u_worldView;void main() { gl_Position = u_worldView * a_position; }";
    private final String col_fragmentShader = "void main() { gl_FragColor = vec4(1,0,0,1); }";
    public static ShaderProgram texshader;
    public static ShaderProgram colshader;
    public static Screen previous_screen;

    static {
        rand = new Random();
    }

    @Override
    public void create() {
        game = this;
        prefs = Gdx.app.getPreferences("zombicalypse.ini");
        prefs.getBoolean("effects", true);
        prefs.getBoolean("music", true);
        music = Gdx.audio.newMusic(Gdx.files.internal("data/snd/music-01.ogg"));
        music.setLooping(true);
        snd_explosion = new Sound[4];
        TGame.snd_explosion[0] = Gdx.audio.newSound(Gdx.files.internal("data/snd/explosion-01.ogg"));
        TGame.snd_explosion[1] = Gdx.audio.newSound(Gdx.files.internal("data/snd/explosion-02.ogg"));
        TGame.snd_explosion[2] = Gdx.audio.newSound(Gdx.files.internal("data/snd/explosion-03.ogg"));
        TGame.snd_explosion[3] = Gdx.audio.newSound(Gdx.files.internal("data/snd/explosion-04.ogg"));
        snd_zombie = new Sound[4];
        TGame.snd_zombie[0] = Gdx.audio.newSound(Gdx.files.internal("data/snd/zombie-01.ogg"));
        TGame.snd_zombie[1] = Gdx.audio.newSound(Gdx.files.internal("data/snd/zombie-02.ogg"));
        TGame.snd_zombie[2] = Gdx.audio.newSound(Gdx.files.internal("data/snd/zombie-03.ogg"));
        TGame.snd_zombie[3] = Gdx.audio.newSound(Gdx.files.internal("data/snd/zombie-04.ogg"));
        atlas = new TextureAtlas("data/img/pack");
        ninepatch = new NinePatchDrawable(new NinePatch((TextureRegion)atlas.findRegion("menuskin"), 8, 8, 8, 8));
        font = new BitmapFont(new BitmapFont.BitmapFontData(Gdx.files.internal("data/primo.fnt"), false), (TextureRegion)atlas.findRegion("primo"), false);
        house = new StillModel[3];
        TGame.house[0] = G3dLoader.loadStillModel(Gdx.files.internal("data/mdl/house1.g3d"));
        TGame.house[1] = G3dLoader.loadStillModel(Gdx.files.internal("data/mdl/house2.g3d"));
        TGame.house[2] = G3dLoader.loadStillModel(Gdx.files.internal("data/mdl/house3.g3d"));
        labelStyle = new Label.LabelStyle(font, Color.WHITE);
        sliderStyle = new Slider.SliderStyle();
        TGame.sliderStyle.background = ninepatch;
        TGame.sliderStyle.knob = new TextureRegionDrawable(atlas.findRegion("checkboxon"));
        textbuttonStyle = new TextButton.TextButtonStyle();
        TGame.textbuttonStyle.font = font;
        TGame.textbuttonStyle.fontColor = Color.WHITE;
        TGame.textbuttonStyle.downFontColor = Color.RED;
        checkboxStyle = new CheckBox.CheckBoxStyle();
        TGame.checkboxStyle.font = font;
        TGame.checkboxStyle.checkboxOn = new TextureRegionDrawable(atlas.findRegion("checkboxon"));
        TGame.checkboxStyle.checkboxOff = new TextureRegionDrawable(atlas.findRegion("checkboxoff"));
        TGame.checkboxStyle.checked = new TextureRegionDrawable(atlas.findRegion("checkboxon"));
        highscores = new HighScores();
        options = new Options();
        gameover = new GameOver();
        gameloop = new GameLoop();
        mainmenu = new MainMenu();
        Gdx.input.setCatchBackKey(true);
        Gdx.input.setCatchMenuKey(true);
        Gdx.app.log(TAG, "isGL20 available: " + Gdx.graphics.isGL20Available());
        if (Gdx.graphics.isGL20Available()) {
            texshader = new ShaderProgram("attribute vec4 a_position;attribute vec4 a_color;attribute vec2 a_texCoord0;uniform mat4 u_worldView;varying vec2 v_texCoords;void main() {v_texCoords = a_texCoord0;gl_Position = u_worldView * a_position; }", "varying vec2 v_texCoords;uniform sampler2D u_texture;void main() { gl_FragColor = texture2D(u_texture, v_texCoords); }");
            colshader = new ShaderProgram("attribute vec4 a_position;uniform mat4 u_worldView;void main() { gl_Position = u_worldView * a_position; }", "void main() { gl_FragColor = vec4(1,0,0,1); }");
        }
        previous_screen = mainmenu;
        this.setScreen(mainmenu);
    }

    @Override
    public void dispose() {
        Object element;
        prefs.flush();
        if (music != null) {
            music.dispose();
        }
        if (mainmenu != null) {
            mainmenu.dispose();
        }
        if (gameloop != null) {
            gameloop.dispose();
        }
        if (gameover != null) {
            gameover.dispose();
        }
        if (options != null) {
            options.dispose();
        }
        if (highscores != null) {
            highscores.dispose();
        }
        if (font != null) {
            font.dispose();
        }
        if (atlas != null) {
            atlas.dispose();
        }
        Object[] objectArray = snd_explosion;
        int n = snd_explosion.length;
        int n2 = 0;
        while (n2 < n) {
            element = objectArray[n2];
            element.dispose();
            ++n2;
        }
        objectArray = snd_zombie;
        n = snd_zombie.length;
        n2 = 0;
        while (n2 < n) {
            element = objectArray[n2];
            element.dispose();
            ++n2;
        }
        objectArray = house;
        n = house.length;
        n2 = 0;
        while (n2 < n) {
            element = objectArray[n2];
            ((StillModel)element).dispose();
            ++n2;
        }
    }

    @Override
    public void pause() {
        super.pause();
    }

    @Override
    public void render() {
        super.render();
    }

    @Override
    public void resize(int width, int height) {
        super.resize(width, height);
    }

    @Override
    public void resume() {
        super.resume();
    }
}

