/*
 * Decompiled with CFR 0.152.
 */
package darwin.jopenctm.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lzma.sdk.lzma.Encoder;
import lzma.streams.LzmaEncoderWrapper;

public class CtmOutputStream
extends DataOutputStream {
    private final int compressionLevel;

    public CtmOutputStream(OutputStream out) {
        this(5, out);
    }

    public CtmOutputStream(int compressionLevel, OutputStream out) {
        super(out);
        this.compressionLevel = compressionLevel;
    }

    public void writeString(String text) throws IOException {
        if (text != null) {
            this.writeLittleInt(text.length());
            this.write(text.getBytes());
        } else {
            this.writeLittleInt(0);
        }
    }

    public void writeLittleInt(int v) throws IOException {
        this.out.write(v & 0xFF);
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v >>> 16 & 0xFF);
        this.out.write(v >>> 24 & 0xFF);
    }

    public void writeLittleIntArray(int[] v) throws IOException {
        for (int a : v) {
            this.writeLittleInt(a);
        }
    }

    public void writeLittleFloat(float v) throws IOException {
        this.writeLittleInt(Float.floatToIntBits(v));
    }

    public void writeLittleFloatArray(float[] v) throws IOException {
        for (float a : v) {
            this.writeLittleFloat(a);
        }
    }

    public void writePackedInts(int[] data, int count, int size, boolean signed) throws IOException {
        assert (data.length >= count * size) : "The data to be written is smaller as stated by other parameters. Needed: " + count * size + " Provided: " + data.length;
        byte[] tmp = new byte[count * size * 4];
        for (int i = 0; i < count; ++i) {
            for (int k = 0; k < size; ++k) {
                int value = data[i * size + k];
                if (signed) {
                    value = value < 0 ? -1 - (value << 1) : value << 1;
                }
                CtmOutputStream.interleavedInsert(value, tmp, i + k * count, count * size);
            }
        }
        this.writeCompressedData(tmp);
    }

    public void writePackedFloats(float[] data, int count, int size) throws IOException {
        assert (data.length >= count * size) : "The data to be written is smaller as stated by other parameters. Needed: " + count * size + " Provided: " + data.length;
        byte[] tmp = new byte[count * size * 4];
        for (int x = 0; x < count; ++x) {
            for (int y = 0; y < size; ++y) {
                int value = Float.floatToIntBits(data[x * size + y]);
                CtmOutputStream.interleavedInsert(value, tmp, x + y * count, count * size);
            }
        }
        this.writeCompressedData(tmp);
    }

    public static void interleavedInsert(int value, byte[] data, int offset, int stride) {
        data[offset + 3 * stride] = (byte)(value & 0xFF);
        data[offset + 2 * stride] = (byte)(value >> 8 & 0xFF);
        data[offset + stride] = (byte)(value >> 16 & 0xFF);
        data[offset] = (byte)(value >> 24 & 0xFF);
    }

    public void writeCompressedData(byte[] data) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(1000 + data.length);
        Encoder enc = new Encoder();
        enc.code((InputStream)new ByteArrayInputStream(data), (OutputStream)bout, (long)data.length, -1L, null);
        this.writeLittleInt(bout.size());
        enc.writeCoderProperties((OutputStream)this);
        bout.writeTo(this);
    }

    private static class CustomWrapper
    extends LzmaEncoderWrapper {
        private final Encoder e;

        CustomWrapper(Encoder encoder) {
            super(encoder);
            this.e = encoder;
        }

        public void code(InputStream in, OutputStream out) throws IOException {
            this.e.code(in, out, -1L, -1L, null);
        }
    }
}

