/*
 * Decompiled with CFR 0.152.
 */
package darwin.jopenctm.io;

import darwin.jopenctm.compression.MeshDecoder;
import darwin.jopenctm.data.Mesh;
import darwin.jopenctm.errorhandling.BadFormatException;
import darwin.jopenctm.errorhandling.InvalidDataException;
import darwin.jopenctm.io.CtmInputStream;
import darwin.jopenctm.io.MeshInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.ServiceLoader;

public class CtmFileReader {
    public static final int OCTM = CtmFileReader.getTagInt("OCTM");
    private Mesh mesh;
    private String comment;
    private final CtmInputStream in;
    private boolean decoded;

    public CtmFileReader(InputStream source) {
        this.in = new CtmInputStream(source);
    }

    public Mesh decode() throws IOException, BadFormatException, InvalidDataException {
        if (this.decoded) {
            throw new RuntimeException("Ctm File got already decoded");
        }
        this.decoded = true;
        if (this.in.readLittleInt() != OCTM) {
            throw new BadFormatException("The CTM file doesn't start with the OCTM tag!");
        }
        int formatVersion = this.in.readLittleInt();
        int methodTag = this.in.readLittleInt();
        MeshInfo mi = new MeshInfo(this.in.readLittleInt(), this.in.readLittleInt(), this.in.readLittleInt(), this.in.readLittleInt(), this.in.readLittleInt());
        this.comment = this.in.readString();
        Mesh m = null;
        ServiceLoader<MeshDecoder> services = ServiceLoader.load(MeshDecoder.class);
        for (MeshDecoder md : services) {
            if (!md.isFormatSupported(methodTag, formatVersion)) continue;
            m = md.decode(mi, this.in);
            break;
        }
        if (m == null) {
            throw new IOException("No sutible decoder found for Mesh of compression type: " + CtmFileReader.unpack(methodTag) + ", version " + formatVersion);
        }
        m.checkIntegrity();
        return m;
    }

    public static String unpack(int tag) {
        byte[] chars = new byte[]{(byte)(tag & 0xFF), (byte)(tag >> 8 & 0xFF), (byte)(tag >> 16 & 0xFF), (byte)(tag >> 24 & 0xFF)};
        return new String(chars);
    }

    public String getFileComment() {
        if (!this.decoded) {
            throw new RuntimeException("The CTM file is not decoded yet.");
        }
        return this.comment;
    }

    public static int getTagInt(String tag) {
        char[] chars = tag.toCharArray();
        assert (chars.length == 4) : "A tag has to be constructed out of 4 characters!";
        return chars[0] | chars[1] << 8 | chars[2] << 16 | chars[3] << 24;
    }
}

