/*
 * Decompiled with CFR 0.152.
 */
package darwin.jopenctm.compression;

import darwin.jopenctm.compression.MeshDecoder;
import darwin.jopenctm.data.AttributeData;
import darwin.jopenctm.data.Mesh;
import darwin.jopenctm.errorhandling.BadFormatException;
import darwin.jopenctm.errorhandling.InvalidDataException;
import darwin.jopenctm.io.CtmFileReader;
import darwin.jopenctm.io.CtmInputStream;
import darwin.jopenctm.io.MeshInfo;
import java.io.IOException;

public class RawDecoder
implements MeshDecoder {
    public static final int RAW_TAG = CtmFileReader.getTagInt("RAW\u0000");
    public static final int FORMAT_VERSION = 5;

    @Override
    public Mesh decode(MeshInfo minfo, CtmInputStream in) throws IOException, BadFormatException, InvalidDataException {
        int i;
        int vc = minfo.getVertexCount();
        AttributeData[] tex = new AttributeData[minfo.getUvMapCount()];
        AttributeData[] att = new AttributeData[minfo.getAttrCount()];
        this.checkTag(in.readLittleInt(), INDX);
        int[] indices = this.readIntArray(in, minfo.getTriangleCount(), 3, false);
        this.checkTag(in.readLittleInt(), VERT);
        float[] vertices = this.readFloatArray(in, vc * 3, 1);
        float[] normals = null;
        if (minfo.hasNormals()) {
            this.checkTag(in.readLittleInt(), NORM);
            normals = this.readFloatArray(in, vc, 3);
        }
        for (i = 0; i < tex.length; ++i) {
            this.checkTag(in.readLittleInt(), TEXC);
            tex[i] = this.readUVData(vc, in);
        }
        for (i = 0; i < att.length; ++i) {
            this.checkTag(in.readLittleInt(), ATTR);
            att[i] = this.readAttrData(vc, in);
        }
        return new Mesh(vertices, normals, indices, tex, att);
    }

    protected void checkTag(int readTag, int expectedTag) throws BadFormatException {
        if (readTag != expectedTag) {
            throw new BadFormatException("Instead of the expected data tag(\"" + CtmFileReader.unpack(expectedTag) + "\") the tag(\"" + CtmFileReader.unpack(readTag) + "\") was read!");
        }
    }

    protected int[] readIntArray(CtmInputStream in, int count, int size, boolean signed) throws IOException {
        return in.readLittleIntArray(count * size);
    }

    protected float[] readFloatArray(CtmInputStream in, int count, int size) throws IOException {
        return in.readLittleFloatArray(count * size);
    }

    private AttributeData readUVData(int vertCount, CtmInputStream in) throws IOException {
        String name = in.readString();
        String matname = in.readString();
        float[] data = this.readFloatArray(in, vertCount, 2);
        return new AttributeData(name, matname, 2.4414062E-4f, data);
    }

    private AttributeData readAttrData(int vertCount, CtmInputStream in) throws IOException {
        String name = in.readString();
        float[] data = this.readFloatArray(in, vertCount, 4);
        return new AttributeData(name, null, 0.00390625f, data);
    }

    @Override
    public boolean isFormatSupported(int tag, int version) {
        return tag == RAW_TAG && version == 5;
    }
}

