/*
 * Decompiled with CFR 0.152.
 */
package darwin.jopenctm.compression;

import darwin.jopenctm.compression.MG1Decoder;
import darwin.jopenctm.compression.RawEncoder;
import darwin.jopenctm.data.Triangle;
import darwin.jopenctm.io.CtmOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class MG1Encoder
extends RawEncoder {
    @Override
    public int getTag() {
        return MG1Decoder.MG1_TAG;
    }

    @Override
    protected void writeFloatArray(float[] array, CtmOutputStream out, int count, int size) throws IOException {
        out.writePackedFloats(array, count, size);
    }

    @Override
    protected void writeIndicies(int[] indices, CtmOutputStream out) throws IOException {
        int[] tmp = new int[indices.length];
        System.arraycopy(indices, 0, tmp, 0, tmp.length);
        this.rearrangeTriangles(tmp);
        this.makeIndexDeltas(tmp);
        out.writePackedInts(tmp, tmp.length / 3, 3, false);
    }

    public void rearrangeTriangles(int[] indices) {
        int off;
        int i;
        assert (indices.length % 3 == 0);
        for (int off2 = 0; off2 < indices.length; off2 += 3) {
            int tmp;
            if (indices[off2 + 1] < indices[off2] && indices[off2 + 1] < indices[off2 + 2]) {
                tmp = indices[off2];
                indices[off2] = indices[off2 + 1];
                indices[off2 + 1] = indices[off2 + 2];
                indices[off2 + 2] = tmp;
                continue;
            }
            if (indices[off2 + 2] >= indices[off2] || indices[off2 + 2] >= indices[off2 + 1]) continue;
            tmp = indices[off2];
            indices[off2] = indices[off2 + 2];
            indices[off2 + 2] = indices[off2 + 1];
            indices[off2 + 1] = tmp;
        }
        Object[] tris = new Triangle[indices.length / 3];
        for (i = 0; i < tris.length; ++i) {
            off = i * 3;
            tris[i] = new Triangle(indices, off);
        }
        Arrays.sort(tris);
        for (i = 0; i < tris.length; ++i) {
            off = i * 3;
            ((Triangle)tris[i]).copyBack(indices, off);
        }
    }

    public void makeIndexDeltas(int[] indices) {
        assert (indices.length % 3 == 0);
        for (int i = indices.length / 3 - 1; i >= 0; --i) {
            if (i >= 1 && indices[i * 3] == indices[(i - 1) * 3]) {
                int n = i * 3 + 1;
                indices[n] = indices[n] - indices[(i - 1) * 3 + 1];
            } else {
                int n = i * 3 + 1;
                indices[n] = indices[n] - indices[i * 3];
            }
            int n = i * 3 + 2;
            indices[n] = indices[n] - indices[i * 3];
            if (i < 1) continue;
            int n2 = i * 3;
            indices[n2] = indices[n2] - indices[(i - 1) * 3];
        }
    }
}

