/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.test.utils;

import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.Plane;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.Ray;

public class PerspectiveCamController
extends InputAdapter {
    final PerspectiveCamera camera;
    final Vector3 curr = new Vector3();
    final Vector3 last = new Vector3(-1.0f, -1.0f, -1.0f);
    final Vector3 delta = new Vector3();
    final Plane plane = new Plane(new Vector3(0.0f, 0.0f, 1.0f), 0.0f);

    public PerspectiveCamController(PerspectiveCamera camera) {
        this.camera = camera;
    }

    @Override
    public boolean touchDragged(int x, int y, int pointer) {
        Ray ray = this.camera.getPickRay(x, y);
        Intersector.intersectRayPlane(ray, this.plane, this.curr);
        if (this.last.x != -1.0f || this.last.y != -1.0f || this.last.z != -1.0f) {
            ray = this.camera.getPickRay(this.last.x, this.last.y);
            Intersector.intersectRayPlane(ray, this.plane, this.delta);
            this.delta.sub(this.curr);
            this.camera.position.add(this.delta.x, this.delta.y, this.delta.z);
        }
        this.last.set(x, y, 0.0f);
        return false;
    }

    @Override
    public boolean touchUp(int x, int y, int pointer, int button) {
        this.last.set(-1.0f, -1.0f, -1.0f);
        return false;
    }
}

