/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.test;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl.LwjglApplication;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g3d.loaders.ogre.OgreXmlLoader;
import com.badlogic.gdx.graphics.g3d.materials.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.materials.Material;
import com.badlogic.gdx.graphics.g3d.materials.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonKeyframe;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonModel;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer10;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import java.util.ArrayList;
import java.util.List;

public class Viewer
implements ApplicationListener {
    static final int NUM_INSTANCES = 1;
    SkeletonModel model;
    PerspectiveCamera cam;
    ImmediateModeRenderer10 renderer;
    float angle = 0.0f;
    SpriteBatch batch;
    BitmapFont font;
    List<String> animNames = new ArrayList<String>();
    String animation;
    float time = 0.0f;
    int currAnimIdx = 0;
    float[] lightColor = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
    float[] lightPosition = new float[]{2.0f, 5.0f, 10.0f, 0.0f};
    Vector3 point1 = new Vector3();
    Vector3 point2 = new Vector3();

    public static void main(String[] argv) {
        new LwjglApplication(new Viewer(), "Viewer", 480, 320, false);
    }

    @Override
    public void create() {
        Texture texture = new Texture(Gdx.files.internal("data/models/ninja.jpg"));
        Material mat = new Material("mat", new TextureAttribute(texture, 0, "s_tex"), new ColorAttribute(Color.CYAN, "diffuseColor"));
        this.model = new OgreXmlLoader().load(Gdx.files.internal("data/models/ninja.mesh.xml"), Gdx.files.internal("data/models/ninja.skeleton.xml"));
        this.model.setMaterial(mat);
        this.cam = new PerspectiveCamera(67.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        BoundingBox bounds = this.model.subMeshes[0].mesh.calculateBoundingBox();
        this.cam.position.set(bounds.getCenter().cpy().add(100.0f, 100.0f, 100.0f));
        this.cam.lookAt(bounds.getCenter().x, bounds.getCenter().y, bounds.getCenter().z);
        this.cam.near = 0.1f;
        this.cam.far = 1000.0f;
        this.renderer = new ImmediateModeRenderer10();
        this.batch = new SpriteBatch();
        this.font = new BitmapFont();
        for (String name : this.model.skeleton.animations.keys()) {
            this.animNames.add(name);
        }
        this.animation = this.animNames.get(0);
    }

    @Override
    public void resume() {
    }

    @Override
    public void render() {
        Gdx.gl.glClearColor(0.2f, 0.2f, 0.2f, 1.0f);
        Gdx.gl.glClear(16640);
        Gdx.gl.glEnable(2929);
        Gdx.gl.glEnable(3553);
        Gdx.gl.glEnable(2896);
        Gdx.gl.glEnable(2903);
        this.cam.update();
        this.cam.apply(Gdx.gl10);
        Gdx.gl.glEnable(16384);
        Gdx.gl10.glLightfv(16384, 4609, this.lightColor, 0);
        Gdx.gl10.glLightfv(16384, 4611, this.lightPosition, 0);
        this.angle += 45.0f * Gdx.graphics.getDeltaTime();
        long processingTime = 0L;
        int i = 0;
        while (i < 1) {
            this.model.setAnimation(this.animation, this.time, true);
            this.model.render();
            ++i;
        }
        Gdx.gl.glDisable(2896);
        Gdx.gl.glDisable(2929);
        Gdx.gl.glDisable(3553);
        this.renderSkeleton();
        Gdx.app.log("Skinning", "took: " + (float)processingTime / 1.0E9f + " secs");
        this.batch.begin();
        this.font.draw(this.batch, "Touch to switch Animation, Animation: " + this.animation + ", FPS: " + Gdx.graphics.getFramesPerSecond(), 10.0f, 30.0f);
        this.batch.end();
        if (Gdx.input.justTouched()) {
            ++this.currAnimIdx;
            if (this.currAnimIdx == this.animNames.size()) {
                this.currAnimIdx = 0;
            }
            this.animation = this.animNames.get(this.currAnimIdx);
            this.time = 0.0f;
        }
        this.time += Gdx.graphics.getDeltaTime() / 10.0f;
        if (this.time > this.model.skeleton.animations.get((String)this.animation).totalDuration) {
            this.time = 0.0f;
        }
    }

    private void renderSkeleton() {
        this.renderer.begin(1);
        int i = 0;
        while (i < this.model.skeleton.sceneMatrices.size) {
            SkeletonKeyframe joint = this.model.skeleton.bindPoseJoints.get(i);
            if (joint.parentIndex != -1) {
                this.point1.set(0.0f, 0.0f, 0.0f).mul(this.model.skeleton.sceneMatrices.get(i));
                this.point2.set(0.0f, 0.0f, 0.0f).mul(this.model.skeleton.sceneMatrices.get(joint.parentIndex));
                this.renderer.color(1.0f, 1.0f, 1.0f, 1.0f);
                this.renderer.vertex(this.point1);
                this.renderer.color(1.0f, 1.0f, 1.0f, 1.0f);
                this.renderer.vertex(this.point2);
            }
            ++i;
        }
        this.renderer.end();
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void pause() {
    }

    @Override
    public void dispose() {
    }
}

