/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.test;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g3d.AnimatedModelInstance;
import com.badlogic.gdx.graphics.g3d.ModelRenderer;
import com.badlogic.gdx.graphics.g3d.StillModelInstance;
import com.badlogic.gdx.graphics.g3d.experimental.MaterialShaderHandler;
import com.badlogic.gdx.graphics.g3d.lights.LightManager;
import com.badlogic.gdx.graphics.g3d.materials.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.materials.GpuSkinningAttribute;
import com.badlogic.gdx.graphics.g3d.materials.Material;
import com.badlogic.gdx.graphics.g3d.materials.MaterialAttribute;
import com.badlogic.gdx.graphics.g3d.materials.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.model.AnimatedModel;
import com.badlogic.gdx.graphics.g3d.model.Model;
import com.badlogic.gdx.graphics.g3d.model.SubMesh;
import com.badlogic.gdx.graphics.g3d.model.still.StillModel;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import java.util.Comparator;

public class PrototypeRendererGL20
implements ModelRenderer {
    static final int SIZE = 256;
    private final Array<Model> modelQueue = new Array(false, 256);
    private final Array<StillModelInstance> modelInstances = new Array(false, 256);
    final MaterialShaderHandler materialShaderHandler;
    private LightManager lightManager;
    private boolean drawing;
    private final Matrix3 normalMatrix = new Matrix3();
    public Camera cam;
    DrawableManager drawableManager = new DrawableManager();
    private ShaderProgram currentShader;
    private final TextureAttribute[] lastTexture = new TextureAttribute[16];
    public static final Comparator<DrawableManager.Drawable> opaqueSorter = new Comparator<DrawableManager.Drawable>(){

        @Override
        public int compare(DrawableManager.Drawable a, DrawableManager.Drawable b) {
            if (a.firstShaderHash != b.firstShaderHash) {
                return b.firstShaderHash - a.firstShaderHash;
            }
            if (a.modelHash != b.modelHash) {
                return b.modelHash - a.modelHash;
            }
            return b.distance - a.distance;
        }
    };

    public PrototypeRendererGL20(LightManager lightManager) {
        this.lightManager = lightManager;
        this.materialShaderHandler = new MaterialShaderHandler(lightManager);
    }

    @Override
    public void begin() {
        this.drawing = true;
    }

    @Override
    public void draw(StillModel model, StillModelInstance instance) {
        if (this.cam != null && !this.cam.frustum.sphereInFrustum(instance.getSortCenter(), instance.getBoundingSphereRadius())) {
            return;
        }
        this.drawableManager.add(model, instance);
    }

    @Override
    public void draw(AnimatedModel model, AnimatedModelInstance instance) {
        if (this.cam != null && !this.cam.frustum.sphereInFrustum(instance.getSortCenter(), instance.getBoundingSphereRadius())) {
            return;
        }
        this.drawableManager.add(model, instance);
    }

    @Override
    public void end() {
        if (Gdx.graphics.isGL20Available()) {
            this.flush();
        }
    }

    private void flush() {
        this.drawableManager.drawables.sort(opaqueSorter);
        int i = this.drawableManager.drawables.size;
        while (--i >= 0) {
            DrawableManager.Drawable drawable = this.drawableManager.drawables.get(i);
            Vector3 center = drawable.sortCenter;
            this.lightManager.calculateLights(center.x, center.y, center.z);
            Matrix4 modelMatrix = drawable.transform;
            this.normalMatrix.set(modelMatrix);
            if (drawable.isAnimated) {
                ((AnimatedModel)drawable.model).setAnimation(drawable.animation, drawable.animationTime, drawable.isLooping);
            }
            SubMesh[] subMeshes = drawable.model.getSubMeshes();
            boolean matrixChanged = true;
            int j = 0;
            while (j < subMeshes.length) {
                SubMesh subMesh = subMeshes[j];
                Material material = drawable.materials.get(j);
                boolean shaderChanged = this.bindShader(material);
                if (shaderChanged || matrixChanged) {
                    this.currentShader.setUniformMatrix("u_normalMatrix", this.normalMatrix, false);
                    this.currentShader.setUniformMatrix("u_modelMatrix", modelMatrix, false);
                    matrixChanged = false;
                }
                int k = 0;
                int len = material.attributes.size;
                while (k < len) {
                    MaterialAttribute atrib = material.attributes.get(k);
                    if (atrib instanceof TextureAttribute) {
                        TextureAttribute texAtrib = (TextureAttribute)atrib;
                        if (!texAtrib.texturePortionEquals(this.lastTexture[texAtrib.unit])) {
                            this.lastTexture[texAtrib.unit] = texAtrib;
                            texAtrib.bind(this.currentShader);
                        } else {
                            this.currentShader.setUniformi(texAtrib.name, texAtrib.unit);
                        }
                    } else if (atrib instanceof GpuSkinningAttribute) {
                        GpuSkinningAttribute gpuAttrib = (GpuSkinningAttribute)atrib;
                        gpuAttrib.setModelMatrix(modelMatrix);
                        gpuAttrib.bind(this.currentShader);
                    } else {
                        atrib.bind(this.currentShader);
                    }
                    ++k;
                }
                subMesh.getMesh().render(this.currentShader, subMesh.primitiveType);
                ++j;
            }
        }
        if (this.drawableManager.drawablesBlended.size > 0) {
            this.renderBlended();
        }
        if (this.currentShader != null) {
            this.currentShader.end();
            this.currentShader = null;
        }
        i = 0;
        int len = 16;
        while (i < len) {
            this.lastTexture[i] = null;
            ++i;
        }
        this.drawing = false;
        this.drawableManager.clear();
    }

    boolean bindShader(Material material) {
        ShaderProgram shader = material.getShader();
        if (shader == this.currentShader) {
            return false;
        }
        this.currentShader = shader;
        this.currentShader.begin();
        this.lightManager.applyGlobalLights(this.currentShader);
        this.lightManager.applyLights(this.currentShader);
        this.currentShader.setUniformMatrix("u_projectionViewMatrix", this.cam.combined);
        this.currentShader.setUniformf("camPos", this.cam.position.x, this.cam.position.y, this.cam.position.z, 1.2f / this.cam.far);
        this.currentShader.setUniformf("camDir", this.cam.direction.x, this.cam.direction.y, this.cam.direction.z);
        return true;
    }

    public void dispose() {
        this.materialShaderHandler.dispose();
    }

    private void renderBlended() {
        Gdx.gl.glEnable(3042);
        Array<DrawableManager.Drawable> transparentDrawables = this.drawableManager.drawablesBlended;
        transparentDrawables.sort();
        int lastSrcBlend = -1;
        int lastDstBlend = -1;
        int i = 0;
        int size = transparentDrawables.size;
        while (i < size) {
            DrawableManager.Drawable drawable = transparentDrawables.get(i);
            Vector3 center = drawable.sortCenter;
            this.lightManager.calculateLights(center.x, center.y, center.z);
            Matrix4 modelMatrix = drawable.transform;
            this.normalMatrix.set(modelMatrix);
            if (drawable.isAnimated) {
                ((AnimatedModel)drawable.model).setAnimation(drawable.animation, drawable.animationTime, drawable.isLooping);
            }
            SubMesh[] subMeshes = drawable.model.getSubMeshes();
            boolean matrixChanged = true;
            int j = 0;
            while (j < subMeshes.length) {
                SubMesh subMesh = subMeshes[j];
                Material material = drawable.materials.get(j);
                boolean shaderChanged = this.bindShader(material);
                if (shaderChanged || matrixChanged) {
                    this.currentShader.setUniformMatrix("u_normalMatrix", this.normalMatrix, false);
                    this.currentShader.setUniformMatrix("u_modelMatrix", modelMatrix, false);
                    matrixChanged = false;
                }
                int k = 0;
                int len = material.attributes.size;
                while (k < len) {
                    MaterialAttribute atrib = material.attributes.get(k);
                    if (atrib instanceof BlendingAttribute) {
                        BlendingAttribute blending = (BlendingAttribute)atrib;
                        if (blending.blendSrcFunc != lastSrcBlend || blending.blendDstFunc != lastDstBlend) {
                            atrib.bind(this.currentShader);
                            lastSrcBlend = blending.blendSrcFunc;
                            lastDstBlend = blending.blendDstFunc;
                        }
                    } else if (atrib instanceof TextureAttribute) {
                        TextureAttribute texAtrib = (TextureAttribute)atrib;
                        if (!texAtrib.texturePortionEquals(this.lastTexture[texAtrib.unit])) {
                            this.lastTexture[texAtrib.unit] = texAtrib;
                            texAtrib.bind(this.currentShader);
                        } else {
                            this.currentShader.setUniformi(texAtrib.name, texAtrib.unit);
                        }
                    } else if (atrib instanceof GpuSkinningAttribute) {
                        GpuSkinningAttribute gpuAtrib = (GpuSkinningAttribute)atrib;
                        gpuAtrib.setModelMatrix(modelMatrix);
                        gpuAtrib.bind(this.currentShader);
                    } else {
                        atrib.bind(this.currentShader);
                    }
                    ++k;
                }
                subMesh.getMesh().render(this.currentShader, subMesh.primitiveType);
                ++j;
            }
            ++i;
        }
        Gdx.gl.glDisable(3042);
    }

    class DrawableManager {
        Pool<Drawable> drawablePool = new Pool<Drawable>(){

            @Override
            protected Drawable newObject() {
                return new Drawable();
            }
        };
        Pool<Material> materialPool = new Pool<Material>(){

            @Override
            protected Material newObject() {
                return new Material();
            }
        };
        Array<Drawable> drawables = new Array();
        Array<Drawable> drawablesBlended = new Array();

        DrawableManager() {
        }

        public void add(StillModel model, StillModelInstance instance) {
            Drawable drawable = this.drawablePool.obtain();
            drawable.set(model, instance);
            if (drawable.blending) {
                this.drawablesBlended.add(drawable);
            } else {
                this.drawables.add(drawable);
            }
        }

        public void add(AnimatedModel model, AnimatedModelInstance instance) {
            Drawable drawable = this.drawablePool.obtain();
            drawable.set(model, instance);
            if (drawable.blending) {
                this.drawablesBlended.add(drawable);
            } else {
                this.drawables.add(drawable);
            }
        }

        public void clear() {
            this.clear(this.drawables);
            this.clear(this.drawablesBlended);
        }

        private void clear(Array<Drawable> drawables) {
            while (drawables.size > 0) {
                Drawable drawable = drawables.pop();
                while (drawable.materials.size > 0) {
                    Material material = drawable.materials.pop();
                    while (material.attributes.size > 0) {
                        material.attributes.pop().free();
                    }
                    material.resetShader();
                    this.materialPool.free(material);
                }
                this.drawablePool.free(drawable);
            }
        }

        class Drawable
        implements Comparable<Drawable> {
            private static final int PRIORITY_DISCRETE_STEPS = 256;
            Model model;
            final Matrix4 transform = new Matrix4();
            final Vector3 sortCenter = new Vector3();
            final Array<Material> materials = new Array(2);
            boolean isAnimated;
            String animation;
            float animationTime;
            boolean isLooping;
            boolean blending;
            int distance;
            int firstShaderHash;
            int modelHash;

            Drawable() {
            }

            public void set(StillModel model, StillModelInstance instance) {
                this.setCommon(model, instance);
                this.isAnimated = false;
            }

            public void set(AnimatedModel model, AnimatedModelInstance instance) {
                this.setCommon(model, instance);
                this.isAnimated = true;
                this.animation = instance.getAnimation();
                this.animationTime = instance.getAnimationTime();
                this.isLooping = instance.isLooping();
            }

            private void setCommon(Model model, StillModelInstance instance) {
                int n;
                int n2;
                Object[] objectArray;
                this.model = model;
                this.modelHash = model.hashCode();
                System.arraycopy(instance.getTransform().val, 0, this.transform.val, 0, 16);
                this.sortCenter.set(instance.getSortCenter());
                this.distance = (int)(256.0f * this.sortCenter.dst(((DrawableManager)DrawableManager.this).PrototypeRendererGL20.this.cam.position));
                if (instance.getMaterials() != null) {
                    objectArray = instance.getMaterials();
                    n2 = objectArray.length;
                    n = 0;
                    while (n < n2) {
                        Object material = objectArray[n];
                        if (((Material)material).getShader() == null) {
                            ((Material)material).generateShader(((DrawableManager)DrawableManager.this).PrototypeRendererGL20.this.materialShaderHandler);
                        }
                        Material copy = DrawableManager.this.materialPool.obtain();
                        copy.setPooled((Material)material);
                        this.materials.add(copy);
                        ++n;
                    }
                } else {
                    objectArray = model.getSubMeshes();
                    n2 = objectArray.length;
                    n = 0;
                    while (n < n2) {
                        Object subMesh = objectArray[n];
                        Material material = ((SubMesh)subMesh).material;
                        if (material.getShader() == null) {
                            material.generateShader(((DrawableManager)DrawableManager.this).PrototypeRendererGL20.this.materialShaderHandler);
                        }
                        Material copy = DrawableManager.this.materialPool.obtain();
                        copy.setPooled(material);
                        this.materials.add(copy);
                        ++n;
                    }
                }
                this.blending = false;
                for (Material mat : this.materials) {
                    if (!mat.isNeedBlending()) continue;
                    this.blending = true;
                    break;
                }
                if (this.materials.size > 0) {
                    this.firstShaderHash = this.materials.get(0).getShader().hashCode();
                }
            }

            @Override
            public int compareTo(Drawable other) {
                return other.distance - this.distance;
            }
        }
    }
}

